// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "iCalendar-props.hxx"

namespace icalendar_2_0
{
  // BasePropertyType
  //

  const BasePropertyType::parameters_optional& BasePropertyType::
  parameters () const
  {
    return this->parameters_;
  }

  BasePropertyType::parameters_optional& BasePropertyType::
  parameters ()
  {
    return this->parameters_;
  }

  void BasePropertyType::
  parameters (const parameters_type& x)
  {
    this->parameters_.set (x);
  }

  void BasePropertyType::
  parameters (const parameters_optional& x)
  {
    this->parameters_ = x;
  }

  void BasePropertyType::
  parameters (::std::unique_ptr< parameters_type > x)
  {
    this->parameters_.set (std::move (x));
  }


  // ArrayOfProperties
  //

  const ArrayOfProperties::baseProperty_sequence& ArrayOfProperties::
  baseProperty () const
  {
    return this->baseProperty_;
  }

  ArrayOfProperties::baseProperty_sequence& ArrayOfProperties::
  baseProperty ()
  {
    return this->baseProperty_;
  }

  void ArrayOfProperties::
  baseProperty (const baseProperty_sequence& s)
  {
    this->baseProperty_ = s;
  }


  // TextPropertyType
  //

  const TextPropertyType::text_type& TextPropertyType::
  text () const
  {
    return this->text_.get ();
  }

  TextPropertyType::text_type& TextPropertyType::
  text ()
  {
    return this->text_.get ();
  }

  void TextPropertyType::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void TextPropertyType::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }


  // TextListPropertyType
  //

  const TextListPropertyType::text_sequence& TextListPropertyType::
  text () const
  {
    return this->text_;
  }

  TextListPropertyType::text_sequence& TextListPropertyType::
  text ()
  {
    return this->text_;
  }

  void TextListPropertyType::
  text (const text_sequence& s)
  {
    this->text_ = s;
  }


  // CalAddressPropertyType
  //

  const CalAddressPropertyType::cal_address_type& CalAddressPropertyType::
  cal_address () const
  {
    return this->cal_address_.get ();
  }

  CalAddressPropertyType::cal_address_type& CalAddressPropertyType::
  cal_address ()
  {
    return this->cal_address_.get ();
  }

  void CalAddressPropertyType::
  cal_address (const cal_address_type& x)
  {
    this->cal_address_.set (x);
  }

  void CalAddressPropertyType::
  cal_address (::std::unique_ptr< cal_address_type > x)
  {
    this->cal_address_.set (std::move (x));
  }


  // IntegerPropertyType
  //

  const IntegerPropertyType::integer_type& IntegerPropertyType::
  integer () const
  {
    return this->integer_.get ();
  }

  IntegerPropertyType::integer_type& IntegerPropertyType::
  integer ()
  {
    return this->integer_.get ();
  }

  void IntegerPropertyType::
  integer (const integer_type& x)
  {
    this->integer_.set (x);
  }


  // UriPropertyType
  //

  const UriPropertyType::uri_type& UriPropertyType::
  uri () const
  {
    return this->uri_.get ();
  }

  UriPropertyType::uri_type& UriPropertyType::
  uri ()
  {
    return this->uri_.get ();
  }

  void UriPropertyType::
  uri (const uri_type& x)
  {
    this->uri_.set (x);
  }

  void UriPropertyType::
  uri (::std::unique_ptr< uri_type > x)
  {
    this->uri_.set (std::move (x));
  }


  // UtcOffsetPropertyType
  //

  const UtcOffsetPropertyType::utc_offset_type& UtcOffsetPropertyType::
  utc_offset () const
  {
    return this->utc_offset_.get ();
  }

  UtcOffsetPropertyType::utc_offset_type& UtcOffsetPropertyType::
  utc_offset ()
  {
    return this->utc_offset_.get ();
  }

  void UtcOffsetPropertyType::
  utc_offset (const utc_offset_type& x)
  {
    this->utc_offset_.set (x);
  }

  void UtcOffsetPropertyType::
  utc_offset (::std::unique_ptr< utc_offset_type > x)
  {
    this->utc_offset_.set (std::move (x));
  }


  // DatetimePropertyType
  //

  const DatetimePropertyType::date_time_type& DatetimePropertyType::
  date_time () const
  {
    return this->date_time_.get ();
  }

  DatetimePropertyType::date_time_type& DatetimePropertyType::
  date_time ()
  {
    return this->date_time_.get ();
  }

  void DatetimePropertyType::
  date_time (const date_time_type& x)
  {
    this->date_time_.set (x);
  }

  void DatetimePropertyType::
  date_time (::std::unique_ptr< date_time_type > x)
  {
    this->date_time_.set (std::move (x));
  }


  // UtcDatetimePropertyType
  //

  const UtcDatetimePropertyType::utc_date_time_optional& UtcDatetimePropertyType::
  utc_date_time () const
  {
    return this->utc_date_time_;
  }

  UtcDatetimePropertyType::utc_date_time_optional& UtcDatetimePropertyType::
  utc_date_time ()
  {
    return this->utc_date_time_;
  }

  void UtcDatetimePropertyType::
  utc_date_time (const utc_date_time_type& x)
  {
    this->utc_date_time_.set (x);
  }

  void UtcDatetimePropertyType::
  utc_date_time (const utc_date_time_optional& x)
  {
    this->utc_date_time_ = x;
  }

  void UtcDatetimePropertyType::
  utc_date_time (::std::unique_ptr< utc_date_time_type > x)
  {
    this->utc_date_time_.set (std::move (x));
  }

  const UtcDatetimePropertyType::date_time_optional& UtcDatetimePropertyType::
  date_time () const
  {
    return this->date_time_;
  }

  UtcDatetimePropertyType::date_time_optional& UtcDatetimePropertyType::
  date_time ()
  {
    return this->date_time_;
  }

  void UtcDatetimePropertyType::
  date_time (const date_time_type& x)
  {
    this->date_time_.set (x);
  }

  void UtcDatetimePropertyType::
  date_time (const date_time_optional& x)
  {
    this->date_time_ = x;
  }

  void UtcDatetimePropertyType::
  date_time (::std::unique_ptr< date_time_type > x)
  {
    this->date_time_.set (std::move (x));
  }


  // DateDatetimePropertyType
  //

  const DateDatetimePropertyType::date_time_optional& DateDatetimePropertyType::
  date_time () const
  {
    return this->date_time_;
  }

  DateDatetimePropertyType::date_time_optional& DateDatetimePropertyType::
  date_time ()
  {
    return this->date_time_;
  }

  void DateDatetimePropertyType::
  date_time (const date_time_type& x)
  {
    this->date_time_.set (x);
  }

  void DateDatetimePropertyType::
  date_time (const date_time_optional& x)
  {
    this->date_time_ = x;
  }

  void DateDatetimePropertyType::
  date_time (::std::unique_ptr< date_time_type > x)
  {
    this->date_time_.set (std::move (x));
  }

  const DateDatetimePropertyType::date_optional& DateDatetimePropertyType::
  date () const
  {
    return this->date_;
  }

  DateDatetimePropertyType::date_optional& DateDatetimePropertyType::
  date ()
  {
    return this->date_;
  }

  void DateDatetimePropertyType::
  date (const date_type& x)
  {
    this->date_.set (x);
  }

  void DateDatetimePropertyType::
  date (const date_optional& x)
  {
    this->date_ = x;
  }

  void DateDatetimePropertyType::
  date (::std::unique_ptr< date_type > x)
  {
    this->date_.set (std::move (x));
  }


  // RecurPropertyType
  //

  const RecurPropertyType::recur_type& RecurPropertyType::
  recur () const
  {
    return this->recur_.get ();
  }

  RecurPropertyType::recur_type& RecurPropertyType::
  recur ()
  {
    return this->recur_.get ();
  }

  void RecurPropertyType::
  recur (const recur_type& x)
  {
    this->recur_.set (x);
  }

  void RecurPropertyType::
  recur (::std::unique_ptr< recur_type > x)
  {
    this->recur_.set (std::move (x));
  }


  // CalscaleValueType
  //

  CalscaleValueType::
  CalscaleValueType (value v)
  : ::xml_schema::string (_xsd_CalscaleValueType_literals_[v])
  {
  }

  CalscaleValueType::
  CalscaleValueType (const char* v)
  : ::xml_schema::string (v)
  {
  }

  CalscaleValueType::
  CalscaleValueType (const ::std::string& v)
  : ::xml_schema::string (v)
  {
  }

  CalscaleValueType::
  CalscaleValueType (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  CalscaleValueType::
  CalscaleValueType (const CalscaleValueType& v,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  CalscaleValueType& CalscaleValueType::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_CalscaleValueType_literals_[v]);

    return *this;
  }


  // CalscalePropType
  //

  const CalscalePropType::text_type& CalscalePropType::
  text () const
  {
    return this->text_.get ();
  }

  CalscalePropType::text_type& CalscalePropType::
  text ()
  {
    return this->text_.get ();
  }

  void CalscalePropType::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void CalscalePropType::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }


  // MethodPropType
  //


  // ProdidPropType
  //


  // VersionPropType
  //


  // AttachPropType
  //

  const AttachPropType::uri_optional& AttachPropType::
  uri () const
  {
    return this->uri_;
  }

  AttachPropType::uri_optional& AttachPropType::
  uri ()
  {
    return this->uri_;
  }

  void AttachPropType::
  uri (const uri_type& x)
  {
    this->uri_.set (x);
  }

  void AttachPropType::
  uri (const uri_optional& x)
  {
    this->uri_ = x;
  }

  void AttachPropType::
  uri (::std::unique_ptr< uri_type > x)
  {
    this->uri_.set (std::move (x));
  }

  const AttachPropType::binary_optional& AttachPropType::
  binary () const
  {
    return this->binary_;
  }

  AttachPropType::binary_optional& AttachPropType::
  binary ()
  {
    return this->binary_;
  }

  void AttachPropType::
  binary (const binary_type& x)
  {
    this->binary_.set (x);
  }

  void AttachPropType::
  binary (const binary_optional& x)
  {
    this->binary_ = x;
  }

  void AttachPropType::
  binary (::std::unique_ptr< binary_type > x)
  {
    this->binary_.set (std::move (x));
  }


  // CategoriesPropType
  //


  // ClassPropType
  //


  // CommentPropType
  //


  // DescriptionPropType
  //


  // GeoPropType
  //

  const GeoPropType::latitude_type& GeoPropType::
  latitude () const
  {
    return this->latitude_.get ();
  }

  GeoPropType::latitude_type& GeoPropType::
  latitude ()
  {
    return this->latitude_.get ();
  }

  void GeoPropType::
  latitude (const latitude_type& x)
  {
    this->latitude_.set (x);
  }

  const GeoPropType::longitude_type& GeoPropType::
  longitude () const
  {
    return this->longitude_.get ();
  }

  GeoPropType::longitude_type& GeoPropType::
  longitude ()
  {
    return this->longitude_.get ();
  }

  void GeoPropType::
  longitude (const longitude_type& x)
  {
    this->longitude_.set (x);
  }


  // LocationPropType
  //


  // PercentCompletePropType
  //


  // PriorityPropType
  //


  // ResourcesPropType
  //


  // StatusPropType
  //


  // SummaryPropType
  //


  // CompletedPropType
  //


  // DtendPropType
  //


  // DuePropType
  //


  // DtstartPropType
  //


  // DurationPropType
  //

  const DurationPropType::duration_type& DurationPropType::
  duration () const
  {
    return this->duration_.get ();
  }

  DurationPropType::duration_type& DurationPropType::
  duration ()
  {
    return this->duration_.get ();
  }

  void DurationPropType::
  duration (const duration_type& x)
  {
    this->duration_.set (x);
  }

  void DurationPropType::
  duration (::std::unique_ptr< duration_type > x)
  {
    this->duration_.set (std::move (x));
  }


  // FreebusyPropType
  //

  const FreebusyPropType::period_sequence& FreebusyPropType::
  period () const
  {
    return this->period_;
  }

  FreebusyPropType::period_sequence& FreebusyPropType::
  period ()
  {
    return this->period_;
  }

  void FreebusyPropType::
  period (const period_sequence& s)
  {
    this->period_ = s;
  }


  // TranspPropType
  //


  // TzidPropType
  //


  // TznamePropType
  //


  // TzoffsetfromPropType
  //


  // TzoffsettoPropType
  //


  // TzurlPropType
  //


  // AttendeePropType
  //


  // ContactPropType
  //


  // OrganizerPropType
  //


  // RecurrenceIdPropType
  //


  // RelatedToPropType
  //


  // UrlPropType
  //


  // UidPropType
  //


  // ExdatePropType
  //

  const ExdatePropType::date_time_sequence& ExdatePropType::
  date_time () const
  {
    return this->date_time_;
  }

  ExdatePropType::date_time_sequence& ExdatePropType::
  date_time ()
  {
    return this->date_time_;
  }

  void ExdatePropType::
  date_time (const date_time_sequence& s)
  {
    this->date_time_ = s;
  }

  const ExdatePropType::date_sequence& ExdatePropType::
  date () const
  {
    return this->date_;
  }

  ExdatePropType::date_sequence& ExdatePropType::
  date ()
  {
    return this->date_;
  }

  void ExdatePropType::
  date (const date_sequence& s)
  {
    this->date_ = s;
  }


  // RdatePropType
  //

  const RdatePropType::date_sequence& RdatePropType::
  date () const
  {
    return this->date_;
  }

  RdatePropType::date_sequence& RdatePropType::
  date ()
  {
    return this->date_;
  }

  void RdatePropType::
  date (const date_sequence& s)
  {
    this->date_ = s;
  }

  const RdatePropType::date_time_sequence& RdatePropType::
  date_time () const
  {
    return this->date_time_;
  }

  RdatePropType::date_time_sequence& RdatePropType::
  date_time ()
  {
    return this->date_time_;
  }

  void RdatePropType::
  date_time (const date_time_sequence& s)
  {
    this->date_time_ = s;
  }

  const RdatePropType::period_sequence& RdatePropType::
  period () const
  {
    return this->period_;
  }

  RdatePropType::period_sequence& RdatePropType::
  period ()
  {
    return this->period_;
  }

  void RdatePropType::
  period (const period_sequence& s)
  {
    this->period_ = s;
  }


  // RrulePropType
  //


  // ExrulePropType
  //


  // ActionPropType
  //


  // RepeatPropType
  //


  // TriggerPropType
  //

  const TriggerPropType::duration_optional& TriggerPropType::
  duration () const
  {
    return this->duration_;
  }

  TriggerPropType::duration_optional& TriggerPropType::
  duration ()
  {
    return this->duration_;
  }

  void TriggerPropType::
  duration (const duration_type& x)
  {
    this->duration_.set (x);
  }

  void TriggerPropType::
  duration (const duration_optional& x)
  {
    this->duration_ = x;
  }

  void TriggerPropType::
  duration (::std::unique_ptr< duration_type > x)
  {
    this->duration_.set (std::move (x));
  }

  const TriggerPropType::date_time_optional& TriggerPropType::
  date_time () const
  {
    return this->date_time_;
  }

  TriggerPropType::date_time_optional& TriggerPropType::
  date_time ()
  {
    return this->date_time_;
  }

  void TriggerPropType::
  date_time (const date_time_type& x)
  {
    this->date_time_.set (x);
  }

  void TriggerPropType::
  date_time (const date_time_optional& x)
  {
    this->date_time_ = x;
  }

  void TriggerPropType::
  date_time (::std::unique_ptr< date_time_type > x)
  {
    this->date_time_.set (std::move (x));
  }


  // CreatedPropType
  //


  // DtstampPropType
  //


  // LastModifiedPropType
  //


  // SequencePropType
  //


  // RequestStatusPropType
  //

  const RequestStatusPropType::code_type& RequestStatusPropType::
  code () const
  {
    return this->code_.get ();
  }

  RequestStatusPropType::code_type& RequestStatusPropType::
  code ()
  {
    return this->code_.get ();
  }

  void RequestStatusPropType::
  code (const code_type& x)
  {
    this->code_.set (x);
  }

  void RequestStatusPropType::
  code (::std::unique_ptr< code_type > x)
  {
    this->code_.set (std::move (x));
  }

  const RequestStatusPropType::description_type& RequestStatusPropType::
  description () const
  {
    return this->description_.get ();
  }

  RequestStatusPropType::description_type& RequestStatusPropType::
  description ()
  {
    return this->description_.get ();
  }

  void RequestStatusPropType::
  description (const description_type& x)
  {
    this->description_.set (x);
  }

  void RequestStatusPropType::
  description (::std::unique_ptr< description_type > x)
  {
    this->description_.set (std::move (x));
  }

  const RequestStatusPropType::extdata_type& RequestStatusPropType::
  extdata () const
  {
    return this->extdata_.get ();
  }

  RequestStatusPropType::extdata_type& RequestStatusPropType::
  extdata ()
  {
    return this->extdata_.get ();
  }

  void RequestStatusPropType::
  extdata (const extdata_type& x)
  {
    this->extdata_.set (x);
  }

  void RequestStatusPropType::
  extdata (::std::unique_ptr< extdata_type > x)
  {
    this->extdata_.set (std::move (x));
  }
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

#include <xsd/cxx/tree/type-factory-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_factory_plate< 0, char >
  type_factory_plate_init;
}

namespace icalendar_2_0
{
  // BasePropertyType
  //

  BasePropertyType::
  BasePropertyType ()
  : ::xml_schema::type (),
    parameters_ (this)
  {
  }

  BasePropertyType::
  BasePropertyType (const BasePropertyType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    parameters_ (x.parameters_, f, this)
  {
  }

  BasePropertyType::
  BasePropertyType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    parameters_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void BasePropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // parameters
      //
      if (n.name () == "parameters" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< parameters_type > r (
          parameters_traits::create (i, f, this));

        if (!this->parameters_)
        {
          this->parameters_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  BasePropertyType& BasePropertyType::
  operator= (const BasePropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->parameters_ = x.parameters_;
    }

    return *this;
  }

  BasePropertyType::
  ~BasePropertyType ()
  {
  }

  // ArrayOfProperties
  //

  ArrayOfProperties::
  ArrayOfProperties ()
  : ::xml_schema::type (),
    baseProperty_ (this)
  {
  }

  ArrayOfProperties::
  ArrayOfProperties (const ArrayOfProperties& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    baseProperty_ (x.baseProperty_, f, this)
  {
  }

  ArrayOfProperties::
  ArrayOfProperties (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    baseProperty_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void ArrayOfProperties::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // baseProperty
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "baseProperty",
            "urn:ietf:params:xml:ns:icalendar-2.0",
            0,
            true, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< baseProperty_type > r (
            dynamic_cast< baseProperty_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->baseProperty_.push_back (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  ArrayOfProperties* ArrayOfProperties::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ArrayOfProperties (*this, f, c);
  }

  ArrayOfProperties& ArrayOfProperties::
  operator= (const ArrayOfProperties& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->baseProperty_ = x.baseProperty_;
    }

    return *this;
  }

  ArrayOfProperties::
  ~ArrayOfProperties ()
  {
  }

  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_calscale_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "calscale",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::CalscalePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_method_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "method",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::MethodPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_prodid_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "prodid",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ProdidPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_version_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "version",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::VersionPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_attach_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "attach",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::AttachPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_categories_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "categories",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::CategoriesPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_class__element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "class",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ClassPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_comment_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "comment",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::CommentPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_description_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "description",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DescriptionPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_geo_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "geo",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::GeoPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_location_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "location",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::LocationPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_percent_complete_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "percent-complete",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::PercentCompletePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_priority_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "priority",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::PriorityPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_resources_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "resources",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ResourcesPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_status_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "status",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::StatusPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_summary_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "summary",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::SummaryPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_completed_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "completed",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::CompletedPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_dtend_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "dtend",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DtendPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_dtstart_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "dtstart",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DtstartPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_due_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "due",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DuePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_duration_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "duration",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DurationPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_freebusy_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "freebusy",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::FreebusyPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_transp_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "transp",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::TranspPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_tzname_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzname",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::TznamePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_tzoffsetfrom_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzoffsetfrom",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::TzoffsetfromPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_tzoffsetto_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzoffsetto",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::TzoffsettoPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_tzurl_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzurl",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::TzurlPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_attendee_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "attendee",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::AttendeePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_contact_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "contact",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ContactPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_organizer_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "organizer",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::OrganizerPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_recurrence_id_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "recurrence-id",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RecurrenceIdPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_url_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "url",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::UrlPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_uid_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "uid",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::UidPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_exdate_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "exdate",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ExdatePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_rdate_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "rdate",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RdatePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_related_to_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "related-to",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RelatedToPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_exrule_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "exrule",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ExrulePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_rrule_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "rrule",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RrulePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_action_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "action",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ActionPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_repeat_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "repeat",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RepeatPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_trigger_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "trigger",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::TriggerPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_created_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "created",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::CreatedPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_dtstamp_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "dtstamp",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DtstampPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_last_modified_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "last-modified",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::LastModifiedPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_sequence_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "sequence",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::SequencePropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_request_status_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "request-status",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RequestStatusPropType >);


  // TextPropertyType
  //

  TextPropertyType::
  TextPropertyType (const text_type& text)
  : ::icalendar_2_0::BasePropertyType (),
    text_ (text, this)
  {
  }

  TextPropertyType::
  TextPropertyType (const TextPropertyType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  TextPropertyType::
  TextPropertyType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TextPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  TextPropertyType* TextPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TextPropertyType (*this, f, c);
  }

  TextPropertyType& TextPropertyType::
  operator= (const TextPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  TextPropertyType::
  ~TextPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TextPropertyType >
  _xsd_TextPropertyType_type_factory_init (
    "TextPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TextListPropertyType
  //

  TextListPropertyType::
  TextListPropertyType ()
  : ::icalendar_2_0::BasePropertyType (),
    text_ (this)
  {
  }

  TextListPropertyType::
  TextListPropertyType (const TextListPropertyType& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  TextListPropertyType::
  TextListPropertyType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TextListPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        this->text_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  TextListPropertyType* TextListPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TextListPropertyType (*this, f, c);
  }

  TextListPropertyType& TextListPropertyType::
  operator= (const TextListPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  TextListPropertyType::
  ~TextListPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TextListPropertyType >
  _xsd_TextListPropertyType_type_factory_init (
    "TextListPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CalAddressPropertyType
  //

  CalAddressPropertyType::
  CalAddressPropertyType (const cal_address_type& cal_address)
  : ::icalendar_2_0::BasePropertyType (),
    cal_address_ (cal_address, this)
  {
  }

  CalAddressPropertyType::
  CalAddressPropertyType (const CalAddressPropertyType& x,
                          ::xml_schema::flags f,
                          ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    cal_address_ (x.cal_address_, f, this)
  {
  }

  CalAddressPropertyType::
  CalAddressPropertyType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f,
                          ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    cal_address_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void CalAddressPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // cal-address
      //
      if (n.name () == "cal-address" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< cal_address_type > r (
          cal_address_traits::create (i, f, this));

        if (!cal_address_.present ())
        {
          this->cal_address_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!cal_address_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "cal-address",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  CalAddressPropertyType* CalAddressPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CalAddressPropertyType (*this, f, c);
  }

  CalAddressPropertyType& CalAddressPropertyType::
  operator= (const CalAddressPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->cal_address_ = x.cal_address_;
    }

    return *this;
  }

  CalAddressPropertyType::
  ~CalAddressPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CalAddressPropertyType >
  _xsd_CalAddressPropertyType_type_factory_init (
    "CalAddressPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // IntegerPropertyType
  //

  IntegerPropertyType::
  IntegerPropertyType (const integer_type& integer)
  : ::icalendar_2_0::BasePropertyType (),
    integer_ (integer, this)
  {
  }

  IntegerPropertyType::
  IntegerPropertyType (const IntegerPropertyType& x,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    integer_ (x.integer_, f, this)
  {
  }

  IntegerPropertyType::
  IntegerPropertyType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    integer_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void IntegerPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // integer
      //
      if (n.name () == "integer" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        if (!integer_.present ())
        {
          this->integer_.set (integer_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!integer_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "integer",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  IntegerPropertyType* IntegerPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class IntegerPropertyType (*this, f, c);
  }

  IntegerPropertyType& IntegerPropertyType::
  operator= (const IntegerPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->integer_ = x.integer_;
    }

    return *this;
  }

  IntegerPropertyType::
  ~IntegerPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, IntegerPropertyType >
  _xsd_IntegerPropertyType_type_factory_init (
    "IntegerPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // UriPropertyType
  //

  UriPropertyType::
  UriPropertyType (const uri_type& uri)
  : ::icalendar_2_0::BasePropertyType (),
    uri_ (uri, this)
  {
  }

  UriPropertyType::
  UriPropertyType (const UriPropertyType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    uri_ (x.uri_, f, this)
  {
  }

  UriPropertyType::
  UriPropertyType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    uri_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void UriPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uri
      //
      if (n.name () == "uri" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< uri_type > r (
          uri_traits::create (i, f, this));

        if (!uri_.present ())
        {
          this->uri_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!uri_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "uri",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  UriPropertyType* UriPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UriPropertyType (*this, f, c);
  }

  UriPropertyType& UriPropertyType::
  operator= (const UriPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->uri_ = x.uri_;
    }

    return *this;
  }

  UriPropertyType::
  ~UriPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, UriPropertyType >
  _xsd_UriPropertyType_type_factory_init (
    "UriPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // UtcOffsetPropertyType
  //

  UtcOffsetPropertyType::
  UtcOffsetPropertyType (const utc_offset_type& utc_offset)
  : ::icalendar_2_0::BasePropertyType (),
    utc_offset_ (utc_offset, this)
  {
  }

  UtcOffsetPropertyType::
  UtcOffsetPropertyType (const UtcOffsetPropertyType& x,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    utc_offset_ (x.utc_offset_, f, this)
  {
  }

  UtcOffsetPropertyType::
  UtcOffsetPropertyType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    utc_offset_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void UtcOffsetPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // utc-offset
      //
      if (n.name () == "utc-offset" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< utc_offset_type > r (
          utc_offset_traits::create (i, f, this));

        if (!utc_offset_.present ())
        {
          this->utc_offset_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!utc_offset_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "utc-offset",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  UtcOffsetPropertyType* UtcOffsetPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UtcOffsetPropertyType (*this, f, c);
  }

  UtcOffsetPropertyType& UtcOffsetPropertyType::
  operator= (const UtcOffsetPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->utc_offset_ = x.utc_offset_;
    }

    return *this;
  }

  UtcOffsetPropertyType::
  ~UtcOffsetPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, UtcOffsetPropertyType >
  _xsd_UtcOffsetPropertyType_type_factory_init (
    "UtcOffsetPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DatetimePropertyType
  //

  DatetimePropertyType::
  DatetimePropertyType (const date_time_type& date_time)
  : ::icalendar_2_0::BasePropertyType (),
    date_time_ (date_time, this)
  {
  }

  DatetimePropertyType::
  DatetimePropertyType (const DatetimePropertyType& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    date_time_ (x.date_time_, f, this)
  {
  }

  DatetimePropertyType::
  DatetimePropertyType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    date_time_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DatetimePropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // date-time
      //
      if (n.name () == "date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_time_type > r (
          date_time_traits::create (i, f, this));

        if (!date_time_.present ())
        {
          this->date_time_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!date_time_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "date-time",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  DatetimePropertyType* DatetimePropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DatetimePropertyType (*this, f, c);
  }

  DatetimePropertyType& DatetimePropertyType::
  operator= (const DatetimePropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->date_time_ = x.date_time_;
    }

    return *this;
  }

  DatetimePropertyType::
  ~DatetimePropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DatetimePropertyType >
  _xsd_DatetimePropertyType_type_factory_init (
    "DatetimePropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // UtcDatetimePropertyType
  //

  UtcDatetimePropertyType::
  UtcDatetimePropertyType ()
  : ::icalendar_2_0::BasePropertyType (),
    utc_date_time_ (this),
    date_time_ (this)
  {
  }

  UtcDatetimePropertyType::
  UtcDatetimePropertyType (const UtcDatetimePropertyType& x,
                           ::xml_schema::flags f,
                           ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    utc_date_time_ (x.utc_date_time_, f, this),
    date_time_ (x.date_time_, f, this)
  {
  }

  UtcDatetimePropertyType::
  UtcDatetimePropertyType (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f,
                           ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    utc_date_time_ (this),
    date_time_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void UtcDatetimePropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // utc-date-time
      //
      if (n.name () == "utc-date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< utc_date_time_type > r (
          utc_date_time_traits::create (i, f, this));

        if (!this->utc_date_time_)
        {
          this->utc_date_time_.set (::std::move (r));
          continue;
        }
      }

      // date-time
      //
      if (n.name () == "date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_time_type > r (
          date_time_traits::create (i, f, this));

        if (!this->date_time_)
        {
          this->date_time_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  UtcDatetimePropertyType* UtcDatetimePropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UtcDatetimePropertyType (*this, f, c);
  }

  UtcDatetimePropertyType& UtcDatetimePropertyType::
  operator= (const UtcDatetimePropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->utc_date_time_ = x.utc_date_time_;
      this->date_time_ = x.date_time_;
    }

    return *this;
  }

  UtcDatetimePropertyType::
  ~UtcDatetimePropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, UtcDatetimePropertyType >
  _xsd_UtcDatetimePropertyType_type_factory_init (
    "UtcDatetimePropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DateDatetimePropertyType
  //

  DateDatetimePropertyType::
  DateDatetimePropertyType ()
  : ::icalendar_2_0::BasePropertyType (),
    date_time_ (this),
    date_ (this)
  {
  }

  DateDatetimePropertyType::
  DateDatetimePropertyType (const DateDatetimePropertyType& x,
                            ::xml_schema::flags f,
                            ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    date_time_ (x.date_time_, f, this),
    date_ (x.date_, f, this)
  {
  }

  DateDatetimePropertyType::
  DateDatetimePropertyType (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f,
                            ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    date_time_ (this),
    date_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DateDatetimePropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // date-time
      //
      if (n.name () == "date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_time_type > r (
          date_time_traits::create (i, f, this));

        if (!this->date_time_)
        {
          this->date_time_.set (::std::move (r));
          continue;
        }
      }

      // date
      //
      if (n.name () == "date" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_type > r (
          date_traits::create (i, f, this));

        if (!this->date_)
        {
          this->date_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  DateDatetimePropertyType* DateDatetimePropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DateDatetimePropertyType (*this, f, c);
  }

  DateDatetimePropertyType& DateDatetimePropertyType::
  operator= (const DateDatetimePropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->date_time_ = x.date_time_;
      this->date_ = x.date_;
    }

    return *this;
  }

  DateDatetimePropertyType::
  ~DateDatetimePropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DateDatetimePropertyType >
  _xsd_DateDatetimePropertyType_type_factory_init (
    "DateDatetimePropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RecurPropertyType
  //

  RecurPropertyType::
  RecurPropertyType (const recur_type& recur)
  : ::icalendar_2_0::BasePropertyType (),
    recur_ (recur, this)
  {
  }

  RecurPropertyType::
  RecurPropertyType (::std::unique_ptr< recur_type > recur)
  : ::icalendar_2_0::BasePropertyType (),
    recur_ (std::move (recur), this)
  {
  }

  RecurPropertyType::
  RecurPropertyType (const RecurPropertyType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    recur_ (x.recur_, f, this)
  {
  }

  RecurPropertyType::
  RecurPropertyType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    recur_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void RecurPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // recur
      //
      if (n.name () == "recur" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< recur_type > r (
          recur_traits::create (i, f, this));

        if (!recur_.present ())
        {
          this->recur_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!recur_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "recur",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  RecurPropertyType* RecurPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RecurPropertyType (*this, f, c);
  }

  RecurPropertyType& RecurPropertyType::
  operator= (const RecurPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->recur_ = x.recur_;
    }

    return *this;
  }

  RecurPropertyType::
  ~RecurPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RecurPropertyType >
  _xsd_RecurPropertyType_type_factory_init (
    "RecurPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CalscaleValueType
  //

  CalscaleValueType::
  CalscaleValueType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_CalscaleValueType_convert ();
  }

  CalscaleValueType::
  CalscaleValueType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_CalscaleValueType_convert ();
  }

  CalscaleValueType::
  CalscaleValueType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_CalscaleValueType_convert ();
  }

  CalscaleValueType* CalscaleValueType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CalscaleValueType (*this, f, c);
  }

  CalscaleValueType::value CalscaleValueType::
  _xsd_CalscaleValueType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_CalscaleValueType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_CalscaleValueType_indexes_,
                      _xsd_CalscaleValueType_indexes_ + 1,
                      *this,
                      c));

    if (i == _xsd_CalscaleValueType_indexes_ + 1 || _xsd_CalscaleValueType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const CalscaleValueType::
  _xsd_CalscaleValueType_literals_[1] =
  {
    "GREGORIAN"
  };

  const CalscaleValueType::value CalscaleValueType::
  _xsd_CalscaleValueType_indexes_[1] =
  {
    ::icalendar_2_0::CalscaleValueType::GREGORIAN
  };

  // CalscalePropType
  //

  CalscalePropType::
  CalscalePropType (const text_type& text)
  : ::icalendar_2_0::BasePropertyType (),
    text_ (text, this)
  {
  }

  CalscalePropType::
  CalscalePropType (const CalscalePropType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  CalscalePropType::
  CalscalePropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void CalscalePropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  CalscalePropType* CalscalePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CalscalePropType (*this, f, c);
  }

  CalscalePropType& CalscalePropType::
  operator= (const CalscalePropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  CalscalePropType::
  ~CalscalePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CalscalePropType >
  _xsd_CalscalePropType_type_factory_init (
    "CalscalePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // MethodPropType
  //

  MethodPropType::
  MethodPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  MethodPropType::
  MethodPropType (const MethodPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  MethodPropType::
  MethodPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  MethodPropType* MethodPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class MethodPropType (*this, f, c);
  }

  MethodPropType::
  ~MethodPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, MethodPropType >
  _xsd_MethodPropType_type_factory_init (
    "MethodPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ProdidPropType
  //

  ProdidPropType::
  ProdidPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  ProdidPropType::
  ProdidPropType (const ProdidPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  ProdidPropType::
  ProdidPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  ProdidPropType* ProdidPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ProdidPropType (*this, f, c);
  }

  ProdidPropType::
  ~ProdidPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ProdidPropType >
  _xsd_ProdidPropType_type_factory_init (
    "ProdidPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // VersionPropType
  //

  VersionPropType::
  VersionPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  VersionPropType::
  VersionPropType (const VersionPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  VersionPropType::
  VersionPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  VersionPropType* VersionPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class VersionPropType (*this, f, c);
  }

  VersionPropType::
  ~VersionPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, VersionPropType >
  _xsd_VersionPropType_type_factory_init (
    "VersionPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // AttachPropType
  //

  AttachPropType::
  AttachPropType ()
  : ::icalendar_2_0::BasePropertyType (),
    uri_ (this),
    binary_ (this)
  {
  }

  AttachPropType::
  AttachPropType (const AttachPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    uri_ (x.uri_, f, this),
    binary_ (x.binary_, f, this)
  {
  }

  AttachPropType::
  AttachPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    uri_ (this),
    binary_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void AttachPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uri
      //
      if (n.name () == "uri" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< uri_type > r (
          uri_traits::create (i, f, this));

        if (!this->uri_)
        {
          this->uri_.set (::std::move (r));
          continue;
        }
      }

      // binary
      //
      if (n.name () == "binary" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< binary_type > r (
          binary_traits::create (i, f, this));

        if (!this->binary_)
        {
          this->binary_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  AttachPropType* AttachPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class AttachPropType (*this, f, c);
  }

  AttachPropType& AttachPropType::
  operator= (const AttachPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->uri_ = x.uri_;
      this->binary_ = x.binary_;
    }

    return *this;
  }

  AttachPropType::
  ~AttachPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, AttachPropType >
  _xsd_AttachPropType_type_factory_init (
    "AttachPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CategoriesPropType
  //

  CategoriesPropType::
  CategoriesPropType ()
  : ::icalendar_2_0::TextListPropertyType ()
  {
  }

  CategoriesPropType::
  CategoriesPropType (const CategoriesPropType& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::icalendar_2_0::TextListPropertyType (x, f, c)
  {
  }

  CategoriesPropType::
  CategoriesPropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::icalendar_2_0::TextListPropertyType (e, f, c)
  {
  }

  CategoriesPropType* CategoriesPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CategoriesPropType (*this, f, c);
  }

  CategoriesPropType::
  ~CategoriesPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CategoriesPropType >
  _xsd_CategoriesPropType_type_factory_init (
    "CategoriesPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ClassPropType
  //

  ClassPropType::
  ClassPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  ClassPropType::
  ClassPropType (const ClassPropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  ClassPropType::
  ClassPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  ClassPropType* ClassPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ClassPropType (*this, f, c);
  }

  ClassPropType::
  ~ClassPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ClassPropType >
  _xsd_ClassPropType_type_factory_init (
    "ClassPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CommentPropType
  //

  CommentPropType::
  CommentPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  CommentPropType::
  CommentPropType (const CommentPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  CommentPropType::
  CommentPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  CommentPropType* CommentPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CommentPropType (*this, f, c);
  }

  CommentPropType::
  ~CommentPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CommentPropType >
  _xsd_CommentPropType_type_factory_init (
    "CommentPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DescriptionPropType
  //

  DescriptionPropType::
  DescriptionPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  DescriptionPropType::
  DescriptionPropType (const DescriptionPropType& x,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  DescriptionPropType::
  DescriptionPropType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  DescriptionPropType* DescriptionPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DescriptionPropType (*this, f, c);
  }

  DescriptionPropType::
  ~DescriptionPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DescriptionPropType >
  _xsd_DescriptionPropType_type_factory_init (
    "DescriptionPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // GeoPropType
  //

  GeoPropType::
  GeoPropType (const latitude_type& latitude,
               const longitude_type& longitude)
  : ::icalendar_2_0::BasePropertyType (),
    latitude_ (latitude, this),
    longitude_ (longitude, this)
  {
  }

  GeoPropType::
  GeoPropType (const GeoPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    latitude_ (x.latitude_, f, this),
    longitude_ (x.longitude_, f, this)
  {
  }

  GeoPropType::
  GeoPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    latitude_ (this),
    longitude_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void GeoPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // latitude
      //
      if (n.name () == "latitude" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        if (!latitude_.present ())
        {
          this->latitude_.set (latitude_traits::create (i, f, this));
          continue;
        }
      }

      // longitude
      //
      if (n.name () == "longitude" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        if (!longitude_.present ())
        {
          this->longitude_.set (longitude_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!latitude_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "latitude",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }

    if (!longitude_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "longitude",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  GeoPropType* GeoPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class GeoPropType (*this, f, c);
  }

  GeoPropType& GeoPropType::
  operator= (const GeoPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->latitude_ = x.latitude_;
      this->longitude_ = x.longitude_;
    }

    return *this;
  }

  GeoPropType::
  ~GeoPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, GeoPropType >
  _xsd_GeoPropType_type_factory_init (
    "GeoPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // LocationPropType
  //

  LocationPropType::
  LocationPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  LocationPropType::
  LocationPropType (const LocationPropType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  LocationPropType::
  LocationPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  LocationPropType* LocationPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class LocationPropType (*this, f, c);
  }

  LocationPropType::
  ~LocationPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, LocationPropType >
  _xsd_LocationPropType_type_factory_init (
    "LocationPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // PercentCompletePropType
  //

  PercentCompletePropType::
  PercentCompletePropType (const integer_type& integer)
  : ::icalendar_2_0::IntegerPropertyType (integer)
  {
  }

  PercentCompletePropType::
  PercentCompletePropType (const PercentCompletePropType& x,
                           ::xml_schema::flags f,
                           ::xml_schema::container* c)
  : ::icalendar_2_0::IntegerPropertyType (x, f, c)
  {
  }

  PercentCompletePropType::
  PercentCompletePropType (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f,
                           ::xml_schema::container* c)
  : ::icalendar_2_0::IntegerPropertyType (e, f, c)
  {
  }

  PercentCompletePropType* PercentCompletePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class PercentCompletePropType (*this, f, c);
  }

  PercentCompletePropType::
  ~PercentCompletePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, PercentCompletePropType >
  _xsd_PercentCompletePropType_type_factory_init (
    "PercentCompletePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // PriorityPropType
  //

  PriorityPropType::
  PriorityPropType (const integer_type& integer)
  : ::icalendar_2_0::IntegerPropertyType (integer)
  {
  }

  PriorityPropType::
  PriorityPropType (const PriorityPropType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::IntegerPropertyType (x, f, c)
  {
  }

  PriorityPropType::
  PriorityPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::IntegerPropertyType (e, f, c)
  {
  }

  PriorityPropType* PriorityPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class PriorityPropType (*this, f, c);
  }

  PriorityPropType::
  ~PriorityPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, PriorityPropType >
  _xsd_PriorityPropType_type_factory_init (
    "PriorityPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ResourcesPropType
  //

  ResourcesPropType::
  ResourcesPropType ()
  : ::icalendar_2_0::TextListPropertyType ()
  {
  }

  ResourcesPropType::
  ResourcesPropType (const ResourcesPropType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextListPropertyType (x, f, c)
  {
  }

  ResourcesPropType::
  ResourcesPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextListPropertyType (e, f, c)
  {
  }

  ResourcesPropType* ResourcesPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ResourcesPropType (*this, f, c);
  }

  ResourcesPropType::
  ~ResourcesPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ResourcesPropType >
  _xsd_ResourcesPropType_type_factory_init (
    "ResourcesPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // StatusPropType
  //

  StatusPropType::
  StatusPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  StatusPropType::
  StatusPropType (const StatusPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  StatusPropType::
  StatusPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  StatusPropType* StatusPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class StatusPropType (*this, f, c);
  }

  StatusPropType::
  ~StatusPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, StatusPropType >
  _xsd_StatusPropType_type_factory_init (
    "StatusPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // SummaryPropType
  //

  SummaryPropType::
  SummaryPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  SummaryPropType::
  SummaryPropType (const SummaryPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  SummaryPropType::
  SummaryPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  SummaryPropType* SummaryPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class SummaryPropType (*this, f, c);
  }

  SummaryPropType::
  ~SummaryPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, SummaryPropType >
  _xsd_SummaryPropType_type_factory_init (
    "SummaryPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CompletedPropType
  //

  CompletedPropType::
  CompletedPropType ()
  : ::icalendar_2_0::UtcDatetimePropertyType ()
  {
  }

  CompletedPropType::
  CompletedPropType (const CompletedPropType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::UtcDatetimePropertyType (x, f, c)
  {
  }

  CompletedPropType::
  CompletedPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::UtcDatetimePropertyType (e, f, c)
  {
  }

  CompletedPropType* CompletedPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CompletedPropType (*this, f, c);
  }

  CompletedPropType::
  ~CompletedPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CompletedPropType >
  _xsd_CompletedPropType_type_factory_init (
    "CompletedPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DtendPropType
  //

  DtendPropType::
  DtendPropType ()
  : ::icalendar_2_0::DateDatetimePropertyType ()
  {
  }

  DtendPropType::
  DtendPropType (const DtendPropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::DateDatetimePropertyType (x, f, c)
  {
  }

  DtendPropType::
  DtendPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::DateDatetimePropertyType (e, f, c)
  {
  }

  DtendPropType* DtendPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DtendPropType (*this, f, c);
  }

  DtendPropType::
  ~DtendPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DtendPropType >
  _xsd_DtendPropType_type_factory_init (
    "DtendPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DuePropType
  //

  DuePropType::
  DuePropType ()
  : ::icalendar_2_0::DateDatetimePropertyType ()
  {
  }

  DuePropType::
  DuePropType (const DuePropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::DateDatetimePropertyType (x, f, c)
  {
  }

  DuePropType::
  DuePropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::DateDatetimePropertyType (e, f, c)
  {
  }

  DuePropType* DuePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DuePropType (*this, f, c);
  }

  DuePropType::
  ~DuePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DuePropType >
  _xsd_DuePropType_type_factory_init (
    "DuePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DtstartPropType
  //

  DtstartPropType::
  DtstartPropType ()
  : ::icalendar_2_0::DateDatetimePropertyType ()
  {
  }

  DtstartPropType::
  DtstartPropType (const DtstartPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::DateDatetimePropertyType (x, f, c)
  {
  }

  DtstartPropType::
  DtstartPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::DateDatetimePropertyType (e, f, c)
  {
  }

  DtstartPropType* DtstartPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DtstartPropType (*this, f, c);
  }

  DtstartPropType::
  ~DtstartPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DtstartPropType >
  _xsd_DtstartPropType_type_factory_init (
    "DtstartPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DurationPropType
  //

  DurationPropType::
  DurationPropType (const duration_type& duration)
  : ::icalendar_2_0::BasePropertyType (),
    duration_ (duration, this)
  {
  }

  DurationPropType::
  DurationPropType (const DurationPropType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    duration_ (x.duration_, f, this)
  {
  }

  DurationPropType::
  DurationPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    duration_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DurationPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // duration
      //
      if (n.name () == "duration" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< duration_type > r (
          duration_traits::create (i, f, this));

        if (!duration_.present ())
        {
          this->duration_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!duration_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "duration",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  DurationPropType* DurationPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DurationPropType (*this, f, c);
  }

  DurationPropType& DurationPropType::
  operator= (const DurationPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->duration_ = x.duration_;
    }

    return *this;
  }

  DurationPropType::
  ~DurationPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DurationPropType >
  _xsd_DurationPropType_type_factory_init (
    "DurationPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // FreebusyPropType
  //

  FreebusyPropType::
  FreebusyPropType ()
  : ::icalendar_2_0::BasePropertyType (),
    period_ (this)
  {
  }

  FreebusyPropType::
  FreebusyPropType (const FreebusyPropType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    period_ (x.period_, f, this)
  {
  }

  FreebusyPropType::
  FreebusyPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    period_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void FreebusyPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // period
      //
      if (n.name () == "period" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< period_type > r (
          period_traits::create (i, f, this));

        this->period_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  FreebusyPropType* FreebusyPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class FreebusyPropType (*this, f, c);
  }

  FreebusyPropType& FreebusyPropType::
  operator= (const FreebusyPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->period_ = x.period_;
    }

    return *this;
  }

  FreebusyPropType::
  ~FreebusyPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, FreebusyPropType >
  _xsd_FreebusyPropType_type_factory_init (
    "FreebusyPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TranspPropType
  //

  TranspPropType::
  TranspPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  TranspPropType::
  TranspPropType (const TranspPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  TranspPropType::
  TranspPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  TranspPropType* TranspPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TranspPropType (*this, f, c);
  }

  TranspPropType::
  ~TranspPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TranspPropType >
  _xsd_TranspPropType_type_factory_init (
    "TranspPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TzidPropType
  //

  TzidPropType::
  TzidPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  TzidPropType::
  TzidPropType (const TzidPropType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  TzidPropType::
  TzidPropType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  TzidPropType* TzidPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TzidPropType (*this, f, c);
  }

  TzidPropType::
  ~TzidPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TzidPropType >
  _xsd_TzidPropType_type_factory_init (
    "TzidPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TznamePropType
  //

  TznamePropType::
  TznamePropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  TznamePropType::
  TznamePropType (const TznamePropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  TznamePropType::
  TznamePropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  TznamePropType* TznamePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TznamePropType (*this, f, c);
  }

  TznamePropType::
  ~TznamePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TznamePropType >
  _xsd_TznamePropType_type_factory_init (
    "TznamePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TzoffsetfromPropType
  //

  TzoffsetfromPropType::
  TzoffsetfromPropType (const utc_offset_type& utc_offset)
  : ::icalendar_2_0::UtcOffsetPropertyType (utc_offset)
  {
  }

  TzoffsetfromPropType::
  TzoffsetfromPropType (const TzoffsetfromPropType& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::UtcOffsetPropertyType (x, f, c)
  {
  }

  TzoffsetfromPropType::
  TzoffsetfromPropType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::UtcOffsetPropertyType (e, f, c)
  {
  }

  TzoffsetfromPropType* TzoffsetfromPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TzoffsetfromPropType (*this, f, c);
  }

  TzoffsetfromPropType::
  ~TzoffsetfromPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TzoffsetfromPropType >
  _xsd_TzoffsetfromPropType_type_factory_init (
    "TzoffsetfromPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TzoffsettoPropType
  //

  TzoffsettoPropType::
  TzoffsettoPropType (const utc_offset_type& utc_offset)
  : ::icalendar_2_0::UtcOffsetPropertyType (utc_offset)
  {
  }

  TzoffsettoPropType::
  TzoffsettoPropType (const TzoffsettoPropType& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::icalendar_2_0::UtcOffsetPropertyType (x, f, c)
  {
  }

  TzoffsettoPropType::
  TzoffsettoPropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::icalendar_2_0::UtcOffsetPropertyType (e, f, c)
  {
  }

  TzoffsettoPropType* TzoffsettoPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TzoffsettoPropType (*this, f, c);
  }

  TzoffsettoPropType::
  ~TzoffsettoPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TzoffsettoPropType >
  _xsd_TzoffsettoPropType_type_factory_init (
    "TzoffsettoPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TzurlPropType
  //

  TzurlPropType::
  TzurlPropType (const uri_type& uri)
  : ::icalendar_2_0::UriPropertyType (uri)
  {
  }

  TzurlPropType::
  TzurlPropType (const TzurlPropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::UriPropertyType (x, f, c)
  {
  }

  TzurlPropType::
  TzurlPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::UriPropertyType (e, f, c)
  {
  }

  TzurlPropType* TzurlPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TzurlPropType (*this, f, c);
  }

  TzurlPropType::
  ~TzurlPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TzurlPropType >
  _xsd_TzurlPropType_type_factory_init (
    "TzurlPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // AttendeePropType
  //

  AttendeePropType::
  AttendeePropType (const cal_address_type& cal_address)
  : ::icalendar_2_0::CalAddressPropertyType (cal_address)
  {
  }

  AttendeePropType::
  AttendeePropType (const AttendeePropType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressPropertyType (x, f, c)
  {
  }

  AttendeePropType::
  AttendeePropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressPropertyType (e, f, c)
  {
  }

  AttendeePropType* AttendeePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class AttendeePropType (*this, f, c);
  }

  AttendeePropType::
  ~AttendeePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, AttendeePropType >
  _xsd_AttendeePropType_type_factory_init (
    "AttendeePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ContactPropType
  //

  ContactPropType::
  ContactPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  ContactPropType::
  ContactPropType (const ContactPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  ContactPropType::
  ContactPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  ContactPropType* ContactPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ContactPropType (*this, f, c);
  }

  ContactPropType::
  ~ContactPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ContactPropType >
  _xsd_ContactPropType_type_factory_init (
    "ContactPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // OrganizerPropType
  //

  OrganizerPropType::
  OrganizerPropType (const cal_address_type& cal_address)
  : ::icalendar_2_0::CalAddressPropertyType (cal_address)
  {
  }

  OrganizerPropType::
  OrganizerPropType (const OrganizerPropType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressPropertyType (x, f, c)
  {
  }

  OrganizerPropType::
  OrganizerPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressPropertyType (e, f, c)
  {
  }

  OrganizerPropType* OrganizerPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class OrganizerPropType (*this, f, c);
  }

  OrganizerPropType::
  ~OrganizerPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, OrganizerPropType >
  _xsd_OrganizerPropType_type_factory_init (
    "OrganizerPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RecurrenceIdPropType
  //

  RecurrenceIdPropType::
  RecurrenceIdPropType ()
  : ::icalendar_2_0::DateDatetimePropertyType ()
  {
  }

  RecurrenceIdPropType::
  RecurrenceIdPropType (const RecurrenceIdPropType& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::DateDatetimePropertyType (x, f, c)
  {
  }

  RecurrenceIdPropType::
  RecurrenceIdPropType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::DateDatetimePropertyType (e, f, c)
  {
  }

  RecurrenceIdPropType* RecurrenceIdPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RecurrenceIdPropType (*this, f, c);
  }

  RecurrenceIdPropType::
  ~RecurrenceIdPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RecurrenceIdPropType >
  _xsd_RecurrenceIdPropType_type_factory_init (
    "RecurrenceIdPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RelatedToPropType
  //

  RelatedToPropType::
  RelatedToPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  RelatedToPropType::
  RelatedToPropType (const RelatedToPropType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  RelatedToPropType::
  RelatedToPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  RelatedToPropType* RelatedToPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RelatedToPropType (*this, f, c);
  }

  RelatedToPropType::
  ~RelatedToPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RelatedToPropType >
  _xsd_RelatedToPropType_type_factory_init (
    "RelatedToPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // UrlPropType
  //

  UrlPropType::
  UrlPropType (const uri_type& uri)
  : ::icalendar_2_0::UriPropertyType (uri)
  {
  }

  UrlPropType::
  UrlPropType (const UrlPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::UriPropertyType (x, f, c)
  {
  }

  UrlPropType::
  UrlPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::UriPropertyType (e, f, c)
  {
  }

  UrlPropType* UrlPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UrlPropType (*this, f, c);
  }

  UrlPropType::
  ~UrlPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, UrlPropType >
  _xsd_UrlPropType_type_factory_init (
    "UrlPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // UidPropType
  //

  UidPropType::
  UidPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  UidPropType::
  UidPropType (const UidPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  UidPropType::
  UidPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  UidPropType* UidPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UidPropType (*this, f, c);
  }

  UidPropType::
  ~UidPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, UidPropType >
  _xsd_UidPropType_type_factory_init (
    "UidPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ExdatePropType
  //

  ExdatePropType::
  ExdatePropType ()
  : ::icalendar_2_0::BasePropertyType (),
    date_time_ (this),
    date_ (this)
  {
  }

  ExdatePropType::
  ExdatePropType (const ExdatePropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    date_time_ (x.date_time_, f, this),
    date_ (x.date_, f, this)
  {
  }

  ExdatePropType::
  ExdatePropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    date_time_ (this),
    date_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void ExdatePropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // date-time
      //
      if (n.name () == "date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_time_type > r (
          date_time_traits::create (i, f, this));

        this->date_time_.push_back (::std::move (r));
        continue;
      }

      // date
      //
      if (n.name () == "date" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_type > r (
          date_traits::create (i, f, this));

        this->date_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  ExdatePropType* ExdatePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ExdatePropType (*this, f, c);
  }

  ExdatePropType& ExdatePropType::
  operator= (const ExdatePropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->date_time_ = x.date_time_;
      this->date_ = x.date_;
    }

    return *this;
  }

  ExdatePropType::
  ~ExdatePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ExdatePropType >
  _xsd_ExdatePropType_type_factory_init (
    "ExdatePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RdatePropType
  //

  RdatePropType::
  RdatePropType ()
  : ::icalendar_2_0::BasePropertyType (),
    date_ (this),
    date_time_ (this),
    period_ (this)
  {
  }

  RdatePropType::
  RdatePropType (const RdatePropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    date_ (x.date_, f, this),
    date_time_ (x.date_time_, f, this),
    period_ (x.period_, f, this)
  {
  }

  RdatePropType::
  RdatePropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    date_ (this),
    date_time_ (this),
    period_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void RdatePropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // date
      //
      if (n.name () == "date" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_type > r (
          date_traits::create (i, f, this));

        this->date_.push_back (::std::move (r));
        continue;
      }

      // date-time
      //
      if (n.name () == "date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_time_type > r (
          date_time_traits::create (i, f, this));

        this->date_time_.push_back (::std::move (r));
        continue;
      }

      // period
      //
      if (n.name () == "period" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< period_type > r (
          period_traits::create (i, f, this));

        this->period_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  RdatePropType* RdatePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RdatePropType (*this, f, c);
  }

  RdatePropType& RdatePropType::
  operator= (const RdatePropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->date_ = x.date_;
      this->date_time_ = x.date_time_;
      this->period_ = x.period_;
    }

    return *this;
  }

  RdatePropType::
  ~RdatePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RdatePropType >
  _xsd_RdatePropType_type_factory_init (
    "RdatePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RrulePropType
  //

  RrulePropType::
  RrulePropType (const recur_type& recur)
  : ::icalendar_2_0::RecurPropertyType (recur)
  {
  }

  RrulePropType::
  RrulePropType (::std::unique_ptr< recur_type > recur)
  : ::icalendar_2_0::RecurPropertyType (std::move (recur))
  {
  }

  RrulePropType::
  RrulePropType (const RrulePropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::RecurPropertyType (x, f, c)
  {
  }

  RrulePropType::
  RrulePropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::RecurPropertyType (e, f, c)
  {
  }

  RrulePropType* RrulePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RrulePropType (*this, f, c);
  }

  RrulePropType::
  ~RrulePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RrulePropType >
  _xsd_RrulePropType_type_factory_init (
    "RrulePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ExrulePropType
  //

  ExrulePropType::
  ExrulePropType (const recur_type& recur)
  : ::icalendar_2_0::RecurPropertyType (recur)
  {
  }

  ExrulePropType::
  ExrulePropType (::std::unique_ptr< recur_type > recur)
  : ::icalendar_2_0::RecurPropertyType (std::move (recur))
  {
  }

  ExrulePropType::
  ExrulePropType (const ExrulePropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::RecurPropertyType (x, f, c)
  {
  }

  ExrulePropType::
  ExrulePropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::RecurPropertyType (e, f, c)
  {
  }

  ExrulePropType* ExrulePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ExrulePropType (*this, f, c);
  }

  ExrulePropType::
  ~ExrulePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ExrulePropType >
  _xsd_ExrulePropType_type_factory_init (
    "ExrulePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ActionPropType
  //

  ActionPropType::
  ActionPropType (const text_type& text)
  : ::icalendar_2_0::TextPropertyType (text)
  {
  }

  ActionPropType::
  ActionPropType (const ActionPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (x, f, c)
  {
  }

  ActionPropType::
  ActionPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::TextPropertyType (e, f, c)
  {
  }

  ActionPropType* ActionPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ActionPropType (*this, f, c);
  }

  ActionPropType::
  ~ActionPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ActionPropType >
  _xsd_ActionPropType_type_factory_init (
    "ActionPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RepeatPropType
  //

  RepeatPropType::
  RepeatPropType (const integer_type& integer)
  : ::icalendar_2_0::IntegerPropertyType (integer)
  {
  }

  RepeatPropType::
  RepeatPropType (const RepeatPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::IntegerPropertyType (x, f, c)
  {
  }

  RepeatPropType::
  RepeatPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::IntegerPropertyType (e, f, c)
  {
  }

  RepeatPropType* RepeatPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RepeatPropType (*this, f, c);
  }

  RepeatPropType::
  ~RepeatPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RepeatPropType >
  _xsd_RepeatPropType_type_factory_init (
    "RepeatPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TriggerPropType
  //

  TriggerPropType::
  TriggerPropType ()
  : ::icalendar_2_0::BasePropertyType (),
    duration_ (this),
    date_time_ (this)
  {
  }

  TriggerPropType::
  TriggerPropType (const TriggerPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    duration_ (x.duration_, f, this),
    date_time_ (x.date_time_, f, this)
  {
  }

  TriggerPropType::
  TriggerPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    duration_ (this),
    date_time_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TriggerPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // duration
      //
      if (n.name () == "duration" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< duration_type > r (
          duration_traits::create (i, f, this));

        if (!this->duration_)
        {
          this->duration_.set (::std::move (r));
          continue;
        }
      }

      // date-time
      //
      if (n.name () == "date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_time_type > r (
          date_time_traits::create (i, f, this));

        if (!this->date_time_)
        {
          this->date_time_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  TriggerPropType* TriggerPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TriggerPropType (*this, f, c);
  }

  TriggerPropType& TriggerPropType::
  operator= (const TriggerPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->duration_ = x.duration_;
      this->date_time_ = x.date_time_;
    }

    return *this;
  }

  TriggerPropType::
  ~TriggerPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TriggerPropType >
  _xsd_TriggerPropType_type_factory_init (
    "TriggerPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CreatedPropType
  //

  CreatedPropType::
  CreatedPropType ()
  : ::icalendar_2_0::UtcDatetimePropertyType ()
  {
  }

  CreatedPropType::
  CreatedPropType (const CreatedPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::UtcDatetimePropertyType (x, f, c)
  {
  }

  CreatedPropType::
  CreatedPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::UtcDatetimePropertyType (e, f, c)
  {
  }

  CreatedPropType* CreatedPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CreatedPropType (*this, f, c);
  }

  CreatedPropType::
  ~CreatedPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CreatedPropType >
  _xsd_CreatedPropType_type_factory_init (
    "CreatedPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DtstampPropType
  //

  DtstampPropType::
  DtstampPropType ()
  : ::icalendar_2_0::UtcDatetimePropertyType ()
  {
  }

  DtstampPropType::
  DtstampPropType (const DtstampPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::UtcDatetimePropertyType (x, f, c)
  {
  }

  DtstampPropType::
  DtstampPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::UtcDatetimePropertyType (e, f, c)
  {
  }

  DtstampPropType* DtstampPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DtstampPropType (*this, f, c);
  }

  DtstampPropType::
  ~DtstampPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DtstampPropType >
  _xsd_DtstampPropType_type_factory_init (
    "DtstampPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // LastModifiedPropType
  //

  LastModifiedPropType::
  LastModifiedPropType ()
  : ::icalendar_2_0::UtcDatetimePropertyType ()
  {
  }

  LastModifiedPropType::
  LastModifiedPropType (const LastModifiedPropType& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::UtcDatetimePropertyType (x, f, c)
  {
  }

  LastModifiedPropType::
  LastModifiedPropType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::UtcDatetimePropertyType (e, f, c)
  {
  }

  LastModifiedPropType* LastModifiedPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class LastModifiedPropType (*this, f, c);
  }

  LastModifiedPropType::
  ~LastModifiedPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, LastModifiedPropType >
  _xsd_LastModifiedPropType_type_factory_init (
    "LastModifiedPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // SequencePropType
  //

  SequencePropType::
  SequencePropType (const integer_type& integer)
  : ::icalendar_2_0::IntegerPropertyType (integer)
  {
  }

  SequencePropType::
  SequencePropType (const SequencePropType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::IntegerPropertyType (x, f, c)
  {
  }

  SequencePropType::
  SequencePropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::IntegerPropertyType (e, f, c)
  {
  }

  SequencePropType* SequencePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class SequencePropType (*this, f, c);
  }

  SequencePropType::
  ~SequencePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, SequencePropType >
  _xsd_SequencePropType_type_factory_init (
    "SequencePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RequestStatusPropType
  //

  RequestStatusPropType::
  RequestStatusPropType (const code_type& code,
                         const description_type& description,
                         const extdata_type& extdata)
  : ::icalendar_2_0::BasePropertyType (),
    code_ (code, this),
    description_ (description, this),
    extdata_ (extdata, this)
  {
  }

  RequestStatusPropType::
  RequestStatusPropType (const RequestStatusPropType& x,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (x, f, c),
    code_ (x.code_, f, this),
    description_ (x.description_, f, this),
    extdata_ (x.extdata_, f, this)
  {
  }

  RequestStatusPropType::
  RequestStatusPropType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::icalendar_2_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    code_ (this),
    description_ (this),
    extdata_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void RequestStatusPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::icalendar_2_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // code
      //
      if (n.name () == "code" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< code_type > r (
          code_traits::create (i, f, this));

        if (!code_.present ())
        {
          this->code_.set (::std::move (r));
          continue;
        }
      }

      // description
      //
      if (n.name () == "description" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< description_type > r (
          description_traits::create (i, f, this));

        if (!description_.present ())
        {
          this->description_.set (::std::move (r));
          continue;
        }
      }

      // extdata
      //
      if (n.name () == "extdata" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< extdata_type > r (
          extdata_traits::create (i, f, this));

        if (!extdata_.present ())
        {
          this->extdata_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!code_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "code",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }

    if (!description_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "description",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }

    if (!extdata_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "extdata",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  RequestStatusPropType* RequestStatusPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RequestStatusPropType (*this, f, c);
  }

  RequestStatusPropType& RequestStatusPropType::
  operator= (const RequestStatusPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BasePropertyType& > (*this) = x;
      this->code_ = x.code_;
      this->description_ = x.description_;
      this->extdata_ = x.extdata_;
    }

    return *this;
  }

  RequestStatusPropType::
  ~RequestStatusPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RequestStatusPropType >
  _xsd_RequestStatusPropType_type_factory_init (
    "RequestStatusPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace icalendar_2_0
{
}

#include <ostream>
#include <xsd/cxx/tree/error-handler.hxx>
#include <xsd/cxx/xml/dom/serialization-source.hxx>

#include <xsd/cxx/tree/type-serializer-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_serializer_plate< 0, char >
  type_serializer_plate_init;
}

namespace icalendar_2_0
{
  void
  operator<< (::xercesc::DOMElement& e, const BasePropertyType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // parameters
    //
    if (i.parameters ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "parameters",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.parameters ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const ArrayOfProperties& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // baseProperty
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (ArrayOfProperties::baseProperty_const_iterator
           b (i.baseProperty ().begin ()), n (i.baseProperty ().end ());
           b != n; ++b)
      {
        const ArrayOfProperties::baseProperty_type& x (*b);

        if (typeid (ArrayOfProperties::baseProperty_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "baseProperty",
              "urn:ietf:params:xml:ns:icalendar-2.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "baseProperty",
            "urn:ietf:params:xml:ns:icalendar-2.0",
            true, true, e, x);
      }
    }
  }

  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::CalscalePropType >
  _xsd_calscale_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "calscale",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::CalscalePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::MethodPropType >
  _xsd_method_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "method",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::MethodPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ProdidPropType >
  _xsd_prodid_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "prodid",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ProdidPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::VersionPropType >
  _xsd_version_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "version",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::VersionPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::AttachPropType >
  _xsd_attach_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "attach",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::AttachPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::CategoriesPropType >
  _xsd_categories_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "categories",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::CategoriesPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ClassPropType >
  _xsd_class__element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "class",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ClassPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::CommentPropType >
  _xsd_comment_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "comment",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::CommentPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DescriptionPropType >
  _xsd_description_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "description",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DescriptionPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::GeoPropType >
  _xsd_geo_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "geo",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::GeoPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::LocationPropType >
  _xsd_location_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "location",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::LocationPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::PercentCompletePropType >
  _xsd_percent_complete_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "percent-complete",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::PercentCompletePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::PriorityPropType >
  _xsd_priority_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "priority",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::PriorityPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ResourcesPropType >
  _xsd_resources_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "resources",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ResourcesPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::StatusPropType >
  _xsd_status_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "status",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::StatusPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::SummaryPropType >
  _xsd_summary_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "summary",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::SummaryPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::CompletedPropType >
  _xsd_completed_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "completed",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::CompletedPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DtendPropType >
  _xsd_dtend_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "dtend",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DtendPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DtstartPropType >
  _xsd_dtstart_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "dtstart",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DtstartPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DuePropType >
  _xsd_due_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "due",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DuePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DurationPropType >
  _xsd_duration_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "duration",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DurationPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::FreebusyPropType >
  _xsd_freebusy_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "freebusy",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::FreebusyPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::TranspPropType >
  _xsd_transp_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "transp",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::TranspPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::TznamePropType >
  _xsd_tzname_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzname",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::TznamePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::TzoffsetfromPropType >
  _xsd_tzoffsetfrom_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzoffsetfrom",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::TzoffsetfromPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::TzoffsettoPropType >
  _xsd_tzoffsetto_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzoffsetto",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::TzoffsettoPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::TzurlPropType >
  _xsd_tzurl_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzurl",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::TzurlPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::AttendeePropType >
  _xsd_attendee_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "attendee",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::AttendeePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ContactPropType >
  _xsd_contact_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "contact",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ContactPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::OrganizerPropType >
  _xsd_organizer_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "organizer",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::OrganizerPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RecurrenceIdPropType >
  _xsd_recurrence_id_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "recurrence-id",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RecurrenceIdPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::UrlPropType >
  _xsd_url_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "url",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::UrlPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::UidPropType >
  _xsd_uid_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "uid",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::UidPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ExdatePropType >
  _xsd_exdate_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "exdate",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ExdatePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RdatePropType >
  _xsd_rdate_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "rdate",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RdatePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RelatedToPropType >
  _xsd_related_to_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "related-to",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RelatedToPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ExrulePropType >
  _xsd_exrule_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "exrule",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ExrulePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RrulePropType >
  _xsd_rrule_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "rrule",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RrulePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ActionPropType >
  _xsd_action_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "action",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ActionPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RepeatPropType >
  _xsd_repeat_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "repeat",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RepeatPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::TriggerPropType >
  _xsd_trigger_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "trigger",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::TriggerPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::CreatedPropType >
  _xsd_created_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "created",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::CreatedPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DtstampPropType >
  _xsd_dtstamp_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "dtstamp",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DtstampPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::LastModifiedPropType >
  _xsd_last_modified_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "last-modified",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::LastModifiedPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::SequencePropType >
  _xsd_sequence_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "sequence",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::SequencePropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RequestStatusPropType >
  _xsd_request_status_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "request-status",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RequestStatusPropType >);


  void
  operator<< (::xercesc::DOMElement& e, const TextPropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.text ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TextPropertyType >
  _xsd_TextPropertyType_type_serializer_init (
    "TextPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TextListPropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // text
    //
    for (TextListPropertyType::text_const_iterator
         b (i.text ().begin ()), n (i.text ().end ());
         b != n; ++b)
    {
      const TextListPropertyType::text_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TextListPropertyType >
  _xsd_TextListPropertyType_type_serializer_init (
    "TextListPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CalAddressPropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // cal-address
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "cal-address",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.cal_address ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CalAddressPropertyType >
  _xsd_CalAddressPropertyType_type_serializer_init (
    "CalAddressPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const IntegerPropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // integer
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "integer",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.integer ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, IntegerPropertyType >
  _xsd_IntegerPropertyType_type_serializer_init (
    "IntegerPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const UriPropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // uri
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uri",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.uri ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, UriPropertyType >
  _xsd_UriPropertyType_type_serializer_init (
    "UriPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const UtcOffsetPropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // utc-offset
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "utc-offset",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.utc_offset ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, UtcOffsetPropertyType >
  _xsd_UtcOffsetPropertyType_type_serializer_init (
    "UtcOffsetPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DatetimePropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // date-time
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date-time",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.date_time ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DatetimePropertyType >
  _xsd_DatetimePropertyType_type_serializer_init (
    "DatetimePropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const UtcDatetimePropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // utc-date-time
    //
    if (i.utc_date_time ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "utc-date-time",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.utc_date_time ();
    }

    // date-time
    //
    if (i.date_time ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date-time",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.date_time ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, UtcDatetimePropertyType >
  _xsd_UtcDatetimePropertyType_type_serializer_init (
    "UtcDatetimePropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DateDatetimePropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // date-time
    //
    if (i.date_time ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date-time",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.date_time ();
    }

    // date
    //
    if (i.date ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.date ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DateDatetimePropertyType >
  _xsd_DateDatetimePropertyType_type_serializer_init (
    "DateDatetimePropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RecurPropertyType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // recur
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "recur",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.recur ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RecurPropertyType >
  _xsd_RecurPropertyType_type_serializer_init (
    "RecurPropertyType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CalscaleValueType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const CalscaleValueType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const CalscaleValueType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const CalscalePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.text ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CalscalePropType >
  _xsd_CalscalePropType_type_serializer_init (
    "CalscalePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const MethodPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, MethodPropType >
  _xsd_MethodPropType_type_serializer_init (
    "MethodPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ProdidPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ProdidPropType >
  _xsd_ProdidPropType_type_serializer_init (
    "ProdidPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const VersionPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, VersionPropType >
  _xsd_VersionPropType_type_serializer_init (
    "VersionPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const AttachPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // uri
    //
    if (i.uri ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uri",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.uri ();
    }

    // binary
    //
    if (i.binary ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "binary",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.binary ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, AttachPropType >
  _xsd_AttachPropType_type_serializer_init (
    "AttachPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CategoriesPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextListPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CategoriesPropType >
  _xsd_CategoriesPropType_type_serializer_init (
    "CategoriesPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ClassPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ClassPropType >
  _xsd_ClassPropType_type_serializer_init (
    "ClassPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CommentPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CommentPropType >
  _xsd_CommentPropType_type_serializer_init (
    "CommentPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DescriptionPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DescriptionPropType >
  _xsd_DescriptionPropType_type_serializer_init (
    "DescriptionPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const GeoPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // latitude
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "latitude",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.latitude ();
    }

    // longitude
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "longitude",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.longitude ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, GeoPropType >
  _xsd_GeoPropType_type_serializer_init (
    "GeoPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const LocationPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, LocationPropType >
  _xsd_LocationPropType_type_serializer_init (
    "LocationPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const PercentCompletePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::IntegerPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, PercentCompletePropType >
  _xsd_PercentCompletePropType_type_serializer_init (
    "PercentCompletePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const PriorityPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::IntegerPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, PriorityPropType >
  _xsd_PriorityPropType_type_serializer_init (
    "PriorityPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ResourcesPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextListPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ResourcesPropType >
  _xsd_ResourcesPropType_type_serializer_init (
    "ResourcesPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const StatusPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, StatusPropType >
  _xsd_StatusPropType_type_serializer_init (
    "StatusPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const SummaryPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, SummaryPropType >
  _xsd_SummaryPropType_type_serializer_init (
    "SummaryPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CompletedPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::UtcDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CompletedPropType >
  _xsd_CompletedPropType_type_serializer_init (
    "CompletedPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DtendPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::DateDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DtendPropType >
  _xsd_DtendPropType_type_serializer_init (
    "DtendPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DuePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::DateDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DuePropType >
  _xsd_DuePropType_type_serializer_init (
    "DuePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DtstartPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::DateDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DtstartPropType >
  _xsd_DtstartPropType_type_serializer_init (
    "DtstartPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DurationPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // duration
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "duration",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.duration ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DurationPropType >
  _xsd_DurationPropType_type_serializer_init (
    "DurationPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const FreebusyPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // period
    //
    for (FreebusyPropType::period_const_iterator
         b (i.period ().begin ()), n (i.period ().end ());
         b != n; ++b)
    {
      const FreebusyPropType::period_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "period",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, FreebusyPropType >
  _xsd_FreebusyPropType_type_serializer_init (
    "FreebusyPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TranspPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TranspPropType >
  _xsd_TranspPropType_type_serializer_init (
    "TranspPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TzidPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TzidPropType >
  _xsd_TzidPropType_type_serializer_init (
    "TzidPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TznamePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TznamePropType >
  _xsd_TznamePropType_type_serializer_init (
    "TznamePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TzoffsetfromPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::UtcOffsetPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TzoffsetfromPropType >
  _xsd_TzoffsetfromPropType_type_serializer_init (
    "TzoffsetfromPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TzoffsettoPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::UtcOffsetPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TzoffsettoPropType >
  _xsd_TzoffsettoPropType_type_serializer_init (
    "TzoffsettoPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TzurlPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TzurlPropType >
  _xsd_TzurlPropType_type_serializer_init (
    "TzurlPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const AttendeePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::CalAddressPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, AttendeePropType >
  _xsd_AttendeePropType_type_serializer_init (
    "AttendeePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ContactPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ContactPropType >
  _xsd_ContactPropType_type_serializer_init (
    "ContactPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const OrganizerPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::CalAddressPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, OrganizerPropType >
  _xsd_OrganizerPropType_type_serializer_init (
    "OrganizerPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RecurrenceIdPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::DateDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RecurrenceIdPropType >
  _xsd_RecurrenceIdPropType_type_serializer_init (
    "RecurrenceIdPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RelatedToPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RelatedToPropType >
  _xsd_RelatedToPropType_type_serializer_init (
    "RelatedToPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const UrlPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, UrlPropType >
  _xsd_UrlPropType_type_serializer_init (
    "UrlPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const UidPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, UidPropType >
  _xsd_UidPropType_type_serializer_init (
    "UidPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ExdatePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // date-time
    //
    for (ExdatePropType::date_time_const_iterator
         b (i.date_time ().begin ()), n (i.date_time ().end ());
         b != n; ++b)
    {
      const ExdatePropType::date_time_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date-time",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // date
    //
    for (ExdatePropType::date_const_iterator
         b (i.date ().begin ()), n (i.date ().end ());
         b != n; ++b)
    {
      const ExdatePropType::date_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ExdatePropType >
  _xsd_ExdatePropType_type_serializer_init (
    "ExdatePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RdatePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // date
    //
    for (RdatePropType::date_const_iterator
         b (i.date ().begin ()), n (i.date ().end ());
         b != n; ++b)
    {
      const RdatePropType::date_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // date-time
    //
    for (RdatePropType::date_time_const_iterator
         b (i.date_time ().begin ()), n (i.date_time ().end ());
         b != n; ++b)
    {
      const RdatePropType::date_time_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date-time",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // period
    //
    for (RdatePropType::period_const_iterator
         b (i.period ().begin ()), n (i.period ().end ());
         b != n; ++b)
    {
      const RdatePropType::period_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "period",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RdatePropType >
  _xsd_RdatePropType_type_serializer_init (
    "RdatePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RrulePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::RecurPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RrulePropType >
  _xsd_RrulePropType_type_serializer_init (
    "RrulePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ExrulePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::RecurPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ExrulePropType >
  _xsd_ExrulePropType_type_serializer_init (
    "ExrulePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ActionPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ActionPropType >
  _xsd_ActionPropType_type_serializer_init (
    "ActionPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RepeatPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::IntegerPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RepeatPropType >
  _xsd_RepeatPropType_type_serializer_init (
    "RepeatPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TriggerPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // duration
    //
    if (i.duration ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "duration",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.duration ();
    }

    // date-time
    //
    if (i.date_time ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date-time",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.date_time ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TriggerPropType >
  _xsd_TriggerPropType_type_serializer_init (
    "TriggerPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CreatedPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::UtcDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CreatedPropType >
  _xsd_CreatedPropType_type_serializer_init (
    "CreatedPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DtstampPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::UtcDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DtstampPropType >
  _xsd_DtstampPropType_type_serializer_init (
    "DtstampPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const LastModifiedPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::UtcDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, LastModifiedPropType >
  _xsd_LastModifiedPropType_type_serializer_init (
    "LastModifiedPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const SequencePropType& i)
  {
    e << static_cast< const ::icalendar_2_0::IntegerPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, SequencePropType >
  _xsd_SequencePropType_type_serializer_init (
    "SequencePropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RequestStatusPropType& i)
  {
    e << static_cast< const ::icalendar_2_0::BasePropertyType& > (i);

    // code
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "code",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.code ();
    }

    // description
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "description",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.description ();
    }

    // extdata
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "extdata",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.extdata ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RequestStatusPropType >
  _xsd_RequestStatusPropType_type_serializer_init (
    "RequestStatusPropType",
    "urn:ietf:params:xml:ns:icalendar-2.0");
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

