#ifndef INCLUDED_OFFICECFG_OFFICE_COMMON_HXX
#define INCLUDED_OFFICECFG_OFFICE_COMMON_HXX

#include "sal/config.h"

#include <optional>
#include "com/sun/star/uno/Sequence.hxx"
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Common {

struct VCL: public comphelper::ConfigurationGroup< VCL> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL"_ustr); return PATH; }

struct DisableOpenGL: public comphelper::ConfigurationProperty<DisableOpenGL, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL/DisableOpenGL"_ustr); return PATH; }
private:
    DisableOpenGL(); // not defined
    ~DisableOpenGL(); // not defined
};

struct UseSkia: public comphelper::ConfigurationProperty<UseSkia, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL/UseSkia"_ustr); return PATH; }
private:
    UseSkia(); // not defined
    ~UseSkia(); // not defined
};

struct ForceSkia: public comphelper::ConfigurationProperty<ForceSkia, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL/ForceSkia"_ustr); return PATH; }
private:
    ForceSkia(); // not defined
    ~ForceSkia(); // not defined
};

struct ForceSkiaRaster: public comphelper::ConfigurationProperty<ForceSkiaRaster, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL/ForceSkiaRaster"_ustr); return PATH; }
private:
    ForceSkiaRaster(); // not defined
    ~ForceSkiaRaster(); // not defined
};

struct ReduceTransparencyMinArea: public comphelper::ConfigurationProperty<ReduceTransparencyMinArea, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL/ReduceTransparencyMinArea"_ustr); return PATH; }
private:
    ReduceTransparencyMinArea(); // not defined
    ~ReduceTransparencyMinArea(); // not defined
};

struct PDFExportImageCacheSize: public comphelper::ConfigurationProperty<PDFExportImageCacheSize, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL/PDFExportImageCacheSize"_ustr); return PATH; }
private:
    PDFExportImageCacheSize(); // not defined
    ~PDFExportImageCacheSize(); // not defined
};

struct macOS: public comphelper::ConfigurationGroup< macOS> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL/macOS"_ustr); return PATH; }

struct IgnoreKeysWhenScrollingWithTrackpadOrMagicMouse: public comphelper::ConfigurationProperty<IgnoreKeysWhenScrollingWithTrackpadOrMagicMouse, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/VCL/macOS/IgnoreKeysWhenScrollingWithTrackpadOrMagicMouse"_ustr); return PATH; }
private:
    IgnoreKeysWhenScrollingWithTrackpadOrMagicMouse(); // not defined
    ~IgnoreKeysWhenScrollingWithTrackpadOrMagicMouse(); // not defined
};

private:
    macOS(); // not defined
    ~macOS(); // not defined
};

private:
    VCL(); // not defined
    ~VCL(); // not defined
};

struct Passwords: public comphelper::ConfigurationGroup< Passwords> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords"_ustr); return PATH; }

struct UseStorage: public comphelper::ConfigurationProperty<UseStorage, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords/UseStorage"_ustr); return PATH; }
private:
    UseStorage(); // not defined
    ~UseStorage(); // not defined
};

struct StorageVersion: public comphelper::ConfigurationProperty<StorageVersion, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords/StorageVersion"_ustr); return PATH; }
private:
    StorageVersion(); // not defined
    ~StorageVersion(); // not defined
};

struct HasMaster: public comphelper::ConfigurationProperty<HasMaster, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords/HasMaster"_ustr); return PATH; }
private:
    HasMaster(); // not defined
    ~HasMaster(); // not defined
};

struct MasterInitializationVector: public comphelper::ConfigurationProperty<MasterInitializationVector, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords/MasterInitializationVector"_ustr); return PATH; }
private:
    MasterInitializationVector(); // not defined
    ~MasterInitializationVector(); // not defined
};

struct Master: public comphelper::ConfigurationProperty<Master, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords/Master"_ustr); return PATH; }
private:
    Master(); // not defined
    ~Master(); // not defined
};

struct Store: public comphelper::ConfigurationSet< Store> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords/Store"_ustr); return PATH; }
private:
    Store(); // not defined
    ~Store(); // not defined
};

struct AuthenticateUsingSystemCredentials: public comphelper::ConfigurationProperty<AuthenticateUsingSystemCredentials, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords/AuthenticateUsingSystemCredentials"_ustr); return PATH; }
private:
    AuthenticateUsingSystemCredentials(); // not defined
    ~AuthenticateUsingSystemCredentials(); // not defined
};

struct TrySystemCredentialsFirst: public comphelper::ConfigurationProperty<TrySystemCredentialsFirst, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Passwords/TrySystemCredentialsFirst"_ustr); return PATH; }
private:
    TrySystemCredentialsFirst(); // not defined
    ~TrySystemCredentialsFirst(); // not defined
};

private:
    Passwords(); // not defined
    ~Passwords(); // not defined
};

struct Drawinglayer: public comphelper::ConfigurationGroup< Drawinglayer> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer"_ustr); return PATH; }

struct OverlayBuffer: public comphelper::ConfigurationProperty<OverlayBuffer, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/OverlayBuffer"_ustr); return PATH; }
private:
    OverlayBuffer(); // not defined
    ~OverlayBuffer(); // not defined
};

struct OverlayBuffer_Calc: public comphelper::ConfigurationProperty<OverlayBuffer_Calc, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/OverlayBuffer_Calc"_ustr); return PATH; }
private:
    OverlayBuffer_Calc(); // not defined
    ~OverlayBuffer_Calc(); // not defined
};

struct OverlayBuffer_Writer: public comphelper::ConfigurationProperty<OverlayBuffer_Writer, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/OverlayBuffer_Writer"_ustr); return PATH; }
private:
    OverlayBuffer_Writer(); // not defined
    ~OverlayBuffer_Writer(); // not defined
};

struct OverlayBuffer_DrawImpress: public comphelper::ConfigurationProperty<OverlayBuffer_DrawImpress, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/OverlayBuffer_DrawImpress"_ustr); return PATH; }
private:
    OverlayBuffer_DrawImpress(); // not defined
    ~OverlayBuffer_DrawImpress(); // not defined
};

struct PaintBuffer: public comphelper::ConfigurationProperty<PaintBuffer, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/PaintBuffer"_ustr); return PATH; }
private:
    PaintBuffer(); // not defined
    ~PaintBuffer(); // not defined
};

struct PaintBuffer_Calc: public comphelper::ConfigurationProperty<PaintBuffer_Calc, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/PaintBuffer_Calc"_ustr); return PATH; }
private:
    PaintBuffer_Calc(); // not defined
    ~PaintBuffer_Calc(); // not defined
};

struct PaintBuffer_DrawImpress: public comphelper::ConfigurationProperty<PaintBuffer_DrawImpress, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/PaintBuffer_DrawImpress"_ustr); return PATH; }
private:
    PaintBuffer_DrawImpress(); // not defined
    ~PaintBuffer_DrawImpress(); // not defined
};

struct StripeColorA: public comphelper::ConfigurationProperty<StripeColorA, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/StripeColorA"_ustr); return PATH; }
private:
    StripeColorA(); // not defined
    ~StripeColorA(); // not defined
};

struct StripeColorB: public comphelper::ConfigurationProperty<StripeColorB, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/StripeColorB"_ustr); return PATH; }
private:
    StripeColorB(); // not defined
    ~StripeColorB(); // not defined
};

struct StripeLength: public comphelper::ConfigurationProperty<StripeLength, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/StripeLength"_ustr); return PATH; }
private:
    StripeLength(); // not defined
    ~StripeLength(); // not defined
};

struct MaximumPaperWidth: public comphelper::ConfigurationProperty<MaximumPaperWidth, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/MaximumPaperWidth"_ustr); return PATH; }
private:
    MaximumPaperWidth(); // not defined
    ~MaximumPaperWidth(); // not defined
};

struct MaximumPaperHeight: public comphelper::ConfigurationProperty<MaximumPaperHeight, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/MaximumPaperHeight"_ustr); return PATH; }
private:
    MaximumPaperHeight(); // not defined
    ~MaximumPaperHeight(); // not defined
};

struct MaximumPaperLeftMargin: public comphelper::ConfigurationProperty<MaximumPaperLeftMargin, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/MaximumPaperLeftMargin"_ustr); return PATH; }
private:
    MaximumPaperLeftMargin(); // not defined
    ~MaximumPaperLeftMargin(); // not defined
};

struct MaximumPaperRightMargin: public comphelper::ConfigurationProperty<MaximumPaperRightMargin, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/MaximumPaperRightMargin"_ustr); return PATH; }
private:
    MaximumPaperRightMargin(); // not defined
    ~MaximumPaperRightMargin(); // not defined
};

struct MaximumPaperTopMargin: public comphelper::ConfigurationProperty<MaximumPaperTopMargin, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/MaximumPaperTopMargin"_ustr); return PATH; }
private:
    MaximumPaperTopMargin(); // not defined
    ~MaximumPaperTopMargin(); // not defined
};

struct MaximumPaperBottomMargin: public comphelper::ConfigurationProperty<MaximumPaperBottomMargin, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/MaximumPaperBottomMargin"_ustr); return PATH; }
private:
    MaximumPaperBottomMargin(); // not defined
    ~MaximumPaperBottomMargin(); // not defined
};

struct AntiAliasing: public comphelper::ConfigurationProperty<AntiAliasing, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/AntiAliasing"_ustr); return PATH; }
private:
    AntiAliasing(); // not defined
    ~AntiAliasing(); // not defined
};

struct SnapHorVerLinesToDiscrete: public comphelper::ConfigurationProperty<SnapHorVerLinesToDiscrete, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/SnapHorVerLinesToDiscrete"_ustr); return PATH; }
private:
    SnapHorVerLinesToDiscrete(); // not defined
    ~SnapHorVerLinesToDiscrete(); // not defined
};

struct RenderDecoratedTextDirect: public comphelper::ConfigurationProperty<RenderDecoratedTextDirect, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/RenderDecoratedTextDirect"_ustr); return PATH; }
private:
    RenderDecoratedTextDirect(); // not defined
    ~RenderDecoratedTextDirect(); // not defined
};

struct RenderSimpleTextDirect: public comphelper::ConfigurationProperty<RenderSimpleTextDirect, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/RenderSimpleTextDirect"_ustr); return PATH; }
private:
    RenderSimpleTextDirect(); // not defined
    ~RenderSimpleTextDirect(); // not defined
};

struct SolidDragCreate: public comphelper::ConfigurationProperty<SolidDragCreate, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/SolidDragCreate"_ustr); return PATH; }
private:
    SolidDragCreate(); // not defined
    ~SolidDragCreate(); // not defined
};

struct Quadratic3DRenderLimit: public comphelper::ConfigurationProperty<Quadratic3DRenderLimit, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/Quadratic3DRenderLimit"_ustr); return PATH; }
private:
    Quadratic3DRenderLimit(); // not defined
    ~Quadratic3DRenderLimit(); // not defined
};

struct QuadraticFormControlRenderLimit: public comphelper::ConfigurationProperty<QuadraticFormControlRenderLimit, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/QuadraticFormControlRenderLimit"_ustr); return PATH; }
private:
    QuadraticFormControlRenderLimit(); // not defined
    ~QuadraticFormControlRenderLimit(); // not defined
};

struct TransparentSelection: public comphelper::ConfigurationProperty<TransparentSelection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/TransparentSelection"_ustr); return PATH; }
private:
    TransparentSelection(); // not defined
    ~TransparentSelection(); // not defined
};

struct TransparentSelectionPercent: public comphelper::ConfigurationProperty<TransparentSelectionPercent, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/TransparentSelectionPercent"_ustr); return PATH; }
private:
    TransparentSelectionPercent(); // not defined
    ~TransparentSelectionPercent(); // not defined
};

struct SelectionMaximumLuminancePercent: public comphelper::ConfigurationProperty<SelectionMaximumLuminancePercent, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Drawinglayer/SelectionMaximumLuminancePercent"_ustr); return PATH; }
private:
    SelectionMaximumLuminancePercent(); // not defined
    ~SelectionMaximumLuminancePercent(); // not defined
};

private:
    Drawinglayer(); // not defined
    ~Drawinglayer(); // not defined
};

struct AutoCorrect: public comphelper::ConfigurationGroup< AutoCorrect> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect"_ustr); return PATH; }

struct UseReplacementTable: public comphelper::ConfigurationProperty<UseReplacementTable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/UseReplacementTable"_ustr); return PATH; }
private:
    UseReplacementTable(); // not defined
    ~UseReplacementTable(); // not defined
};

struct TwoCapitalsAtStart: public comphelper::ConfigurationProperty<TwoCapitalsAtStart, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/TwoCapitalsAtStart"_ustr); return PATH; }
private:
    TwoCapitalsAtStart(); // not defined
    ~TwoCapitalsAtStart(); // not defined
};

struct CapitalAtStartSentence: public comphelper::ConfigurationProperty<CapitalAtStartSentence, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/CapitalAtStartSentence"_ustr); return PATH; }
private:
    CapitalAtStartSentence(); // not defined
    ~CapitalAtStartSentence(); // not defined
};

struct ChangeUnderlineWeight: public comphelper::ConfigurationProperty<ChangeUnderlineWeight, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/ChangeUnderlineWeight"_ustr); return PATH; }
private:
    ChangeUnderlineWeight(); // not defined
    ~ChangeUnderlineWeight(); // not defined
};

struct SetInetAttribute: public comphelper::ConfigurationProperty<SetInetAttribute, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/SetInetAttribute"_ustr); return PATH; }
private:
    SetInetAttribute(); // not defined
    ~SetInetAttribute(); // not defined
};

struct SetDOIAttribute: public comphelper::ConfigurationProperty<SetDOIAttribute, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/SetDOIAttribute"_ustr); return PATH; }
private:
    SetDOIAttribute(); // not defined
    ~SetDOIAttribute(); // not defined
};

struct ChangeOrdinalNumber: public comphelper::ConfigurationProperty<ChangeOrdinalNumber, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/ChangeOrdinalNumber"_ustr); return PATH; }
private:
    ChangeOrdinalNumber(); // not defined
    ~ChangeOrdinalNumber(); // not defined
};

struct ChangeDash: public comphelper::ConfigurationProperty<ChangeDash, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/ChangeDash"_ustr); return PATH; }
private:
    ChangeDash(); // not defined
    ~ChangeDash(); // not defined
};

struct AddNonBreakingSpace: public comphelper::ConfigurationProperty<AddNonBreakingSpace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/AddNonBreakingSpace"_ustr); return PATH; }
private:
    AddNonBreakingSpace(); // not defined
    ~AddNonBreakingSpace(); // not defined
};

struct TransliterateRTL: public comphelper::ConfigurationProperty<TransliterateRTL, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/TransliterateRTL"_ustr); return PATH; }
private:
    TransliterateRTL(); // not defined
    ~TransliterateRTL(); // not defined
};

struct ChangeAngleQuotes: public comphelper::ConfigurationProperty<ChangeAngleQuotes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/ChangeAngleQuotes"_ustr); return PATH; }
private:
    ChangeAngleQuotes(); // not defined
    ~ChangeAngleQuotes(); // not defined
};

struct RemoveDoubleSpaces: public comphelper::ConfigurationProperty<RemoveDoubleSpaces, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/RemoveDoubleSpaces"_ustr); return PATH; }
private:
    RemoveDoubleSpaces(); // not defined
    ~RemoveDoubleSpaces(); // not defined
};

struct CorrectAccidentalCapsLock: public comphelper::ConfigurationProperty<CorrectAccidentalCapsLock, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/CorrectAccidentalCapsLock"_ustr); return PATH; }
private:
    CorrectAccidentalCapsLock(); // not defined
    ~CorrectAccidentalCapsLock(); // not defined
};

struct ReplaceSingleQuote: public comphelper::ConfigurationProperty<ReplaceSingleQuote, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/ReplaceSingleQuote"_ustr); return PATH; }
private:
    ReplaceSingleQuote(); // not defined
    ~ReplaceSingleQuote(); // not defined
};

struct SingleQuoteAtStart: public comphelper::ConfigurationProperty<SingleQuoteAtStart, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/SingleQuoteAtStart"_ustr); return PATH; }
private:
    SingleQuoteAtStart(); // not defined
    ~SingleQuoteAtStart(); // not defined
};

struct SingleQuoteAtEnd: public comphelper::ConfigurationProperty<SingleQuoteAtEnd, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/SingleQuoteAtEnd"_ustr); return PATH; }
private:
    SingleQuoteAtEnd(); // not defined
    ~SingleQuoteAtEnd(); // not defined
};

struct ReplaceDoubleQuote: public comphelper::ConfigurationProperty<ReplaceDoubleQuote, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/ReplaceDoubleQuote"_ustr); return PATH; }
private:
    ReplaceDoubleQuote(); // not defined
    ~ReplaceDoubleQuote(); // not defined
};

struct DoubleQuoteAtStart: public comphelper::ConfigurationProperty<DoubleQuoteAtStart, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/DoubleQuoteAtStart"_ustr); return PATH; }
private:
    DoubleQuoteAtStart(); // not defined
    ~DoubleQuoteAtStart(); // not defined
};

struct DoubleQuoteAtEnd: public comphelper::ConfigurationProperty<DoubleQuoteAtEnd, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/DoubleQuoteAtEnd"_ustr); return PATH; }
private:
    DoubleQuoteAtEnd(); // not defined
    ~DoubleQuoteAtEnd(); // not defined
};

struct Exceptions: public comphelper::ConfigurationGroup< Exceptions> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/Exceptions"_ustr); return PATH; }

struct TwoCapitalsAtStart: public comphelper::ConfigurationProperty<TwoCapitalsAtStart, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/Exceptions/TwoCapitalsAtStart"_ustr); return PATH; }
private:
    TwoCapitalsAtStart(); // not defined
    ~TwoCapitalsAtStart(); // not defined
};

struct CapitalAtStartSentence: public comphelper::ConfigurationProperty<CapitalAtStartSentence, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AutoCorrect/Exceptions/CapitalAtStartSentence"_ustr); return PATH; }
private:
    CapitalAtStartSentence(); // not defined
    ~CapitalAtStartSentence(); // not defined
};

private:
    Exceptions(); // not defined
    ~Exceptions(); // not defined
};

private:
    AutoCorrect(); // not defined
    ~AutoCorrect(); // not defined
};

struct Cache: public comphelper::ConfigurationGroup< Cache> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache"_ustr); return PATH; }

struct DrawingEngine: public comphelper::ConfigurationGroup< DrawingEngine> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/DrawingEngine"_ustr); return PATH; }

struct OLE_Objects: public comphelper::ConfigurationProperty<OLE_Objects, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/DrawingEngine/OLE_Objects"_ustr); return PATH; }
private:
    OLE_Objects(); // not defined
    ~OLE_Objects(); // not defined
};

private:
    DrawingEngine(); // not defined
    ~DrawingEngine(); // not defined
};

struct Writer: public comphelper::ConfigurationGroup< Writer> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/Writer"_ustr); return PATH; }

struct OLE_Objects: public comphelper::ConfigurationProperty<OLE_Objects, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/Writer/OLE_Objects"_ustr); return PATH; }
private:
    OLE_Objects(); // not defined
    ~OLE_Objects(); // not defined
};

private:
    Writer(); // not defined
    ~Writer(); // not defined
};

struct GraphicManager: public comphelper::ConfigurationGroup< GraphicManager> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/GraphicManager"_ustr); return PATH; }

struct GraphicSwappingEnabled: public comphelper::ConfigurationProperty<GraphicSwappingEnabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/GraphicManager/GraphicSwappingEnabled"_ustr); return PATH; }
private:
    GraphicSwappingEnabled(); // not defined
    ~GraphicSwappingEnabled(); // not defined
};

struct GraphicMemoryLimit: public comphelper::ConfigurationProperty<GraphicMemoryLimit, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/GraphicManager/GraphicMemoryLimit"_ustr); return PATH; }
private:
    GraphicMemoryLimit(); // not defined
    ~GraphicMemoryLimit(); // not defined
};

struct GraphicAllowedIdleTime: public comphelper::ConfigurationProperty<GraphicAllowedIdleTime, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/GraphicManager/GraphicAllowedIdleTime"_ustr); return PATH; }
private:
    GraphicAllowedIdleTime(); // not defined
    ~GraphicAllowedIdleTime(); // not defined
};

private:
    GraphicManager(); // not defined
    ~GraphicManager(); // not defined
};

struct Skia: public comphelper::ConfigurationGroup< Skia> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/Skia"_ustr); return PATH; }

struct ImageCacheSize: public comphelper::ConfigurationProperty<ImageCacheSize, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/Skia/ImageCacheSize"_ustr); return PATH; }
private:
    ImageCacheSize(); // not defined
    ~ImageCacheSize(); // not defined
};

private:
    Skia(); // not defined
    ~Skia(); // not defined
};

struct Font: public comphelper::ConfigurationGroup< Font> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/Font"_ustr); return PATH; }

struct GlyphsCacheSize: public comphelper::ConfigurationProperty<GlyphsCacheSize, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/Font/GlyphsCacheSize"_ustr); return PATH; }
private:
    GlyphsCacheSize(); // not defined
    ~GlyphsCacheSize(); // not defined
};

struct TextRunsCacheSize: public comphelper::ConfigurationProperty<TextRunsCacheSize, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Cache/Font/TextRunsCacheSize"_ustr); return PATH; }
private:
    TextRunsCacheSize(); // not defined
    ~TextRunsCacheSize(); // not defined
};

private:
    Font(); // not defined
    ~Font(); // not defined
};

private:
    Cache(); // not defined
    ~Cache(); // not defined
};

struct Path: public comphelper::ConfigurationGroup< Path> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path"_ustr); return PATH; }

struct Current: public comphelper::ConfigurationGroup< Current> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current"_ustr); return PATH; }

struct Addin: public comphelper::ConfigurationProperty<Addin, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Addin"_ustr); return PATH; }
private:
    Addin(); // not defined
    ~Addin(); // not defined
};

struct AutoCorrect: public comphelper::ConfigurationProperty<AutoCorrect, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/AutoCorrect"_ustr); return PATH; }
private:
    AutoCorrect(); // not defined
    ~AutoCorrect(); // not defined
};

struct AutoText: public comphelper::ConfigurationProperty<AutoText, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/AutoText"_ustr); return PATH; }
private:
    AutoText(); // not defined
    ~AutoText(); // not defined
};

struct Backup: public comphelper::ConfigurationProperty<Backup, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Backup"_ustr); return PATH; }
private:
    Backup(); // not defined
    ~Backup(); // not defined
};

struct Basic: public comphelper::ConfigurationProperty<Basic, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Basic"_ustr); return PATH; }
private:
    Basic(); // not defined
    ~Basic(); // not defined
};

struct Bitmap: public comphelper::ConfigurationProperty<Bitmap, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Bitmap"_ustr); return PATH; }
private:
    Bitmap(); // not defined
    ~Bitmap(); // not defined
};

struct Config: public comphelper::ConfigurationProperty<Config, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Config"_ustr); return PATH; }
private:
    Config(); // not defined
    ~Config(); // not defined
};

struct Dictionary: public comphelper::ConfigurationProperty<Dictionary, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Dictionary"_ustr); return PATH; }
private:
    Dictionary(); // not defined
    ~Dictionary(); // not defined
};

struct Favorite: public comphelper::ConfigurationProperty<Favorite, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Favorite"_ustr); return PATH; }
private:
    Favorite(); // not defined
    ~Favorite(); // not defined
};

struct Filter: public comphelper::ConfigurationProperty<Filter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Filter"_ustr); return PATH; }
private:
    Filter(); // not defined
    ~Filter(); // not defined
};

struct Gallery: public comphelper::ConfigurationProperty<Gallery, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Gallery"_ustr); return PATH; }
private:
    Gallery(); // not defined
    ~Gallery(); // not defined
};

struct Graphic: public comphelper::ConfigurationProperty<Graphic, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Graphic"_ustr); return PATH; }
private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct Help: public comphelper::ConfigurationProperty<Help, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Help"_ustr); return PATH; }
private:
    Help(); // not defined
    ~Help(); // not defined
};

struct Linguistic: public comphelper::ConfigurationProperty<Linguistic, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Linguistic"_ustr); return PATH; }
private:
    Linguistic(); // not defined
    ~Linguistic(); // not defined
};

struct Module: public comphelper::ConfigurationProperty<Module, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Module"_ustr); return PATH; }
private:
    Module(); // not defined
    ~Module(); // not defined
};

struct Palette: public comphelper::ConfigurationProperty<Palette, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Palette"_ustr); return PATH; }
private:
    Palette(); // not defined
    ~Palette(); // not defined
};

struct Plugin: public comphelper::ConfigurationProperty<Plugin, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Plugin"_ustr); return PATH; }
private:
    Plugin(); // not defined
    ~Plugin(); // not defined
};

struct Template: public comphelper::ConfigurationProperty<Template, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Template"_ustr); return PATH; }
private:
    Template(); // not defined
    ~Template(); // not defined
};

struct UIConfig: public comphelper::ConfigurationProperty<UIConfig, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/UIConfig"_ustr); return PATH; }
private:
    UIConfig(); // not defined
    ~UIConfig(); // not defined
};

struct UserConfig: public comphelper::ConfigurationProperty<UserConfig, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/UserConfig"_ustr); return PATH; }
private:
    UserConfig(); // not defined
    ~UserConfig(); // not defined
};

struct UserDictionary: public comphelper::ConfigurationProperty<UserDictionary, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/UserDictionary"_ustr); return PATH; }
private:
    UserDictionary(); // not defined
    ~UserDictionary(); // not defined
};

struct Work: public comphelper::ConfigurationProperty<Work, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Current/Work"_ustr); return PATH; }
private:
    Work(); // not defined
    ~Work(); // not defined
};

private:
    Current(); // not defined
    ~Current(); // not defined
};

struct Default: public comphelper::ConfigurationGroup< Default> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default"_ustr); return PATH; }

struct Addin: public comphelper::ConfigurationProperty<Addin, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Addin"_ustr); return PATH; }
private:
    Addin(); // not defined
    ~Addin(); // not defined
};

struct AutoCorrect: public comphelper::ConfigurationProperty<AutoCorrect, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/AutoCorrect"_ustr); return PATH; }
private:
    AutoCorrect(); // not defined
    ~AutoCorrect(); // not defined
};

struct AutoText: public comphelper::ConfigurationProperty<AutoText, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/AutoText"_ustr); return PATH; }
private:
    AutoText(); // not defined
    ~AutoText(); // not defined
};

struct Backup: public comphelper::ConfigurationProperty<Backup, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Backup"_ustr); return PATH; }
private:
    Backup(); // not defined
    ~Backup(); // not defined
};

struct Basic: public comphelper::ConfigurationProperty<Basic, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Basic"_ustr); return PATH; }
private:
    Basic(); // not defined
    ~Basic(); // not defined
};

struct Bitmap: public comphelper::ConfigurationProperty<Bitmap, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Bitmap"_ustr); return PATH; }
private:
    Bitmap(); // not defined
    ~Bitmap(); // not defined
};

struct Config: public comphelper::ConfigurationProperty<Config, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Config"_ustr); return PATH; }
private:
    Config(); // not defined
    ~Config(); // not defined
};

struct Classification: public comphelper::ConfigurationProperty<Classification, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Classification"_ustr); return PATH; }
private:
    Classification(); // not defined
    ~Classification(); // not defined
};

struct Dictionary: public comphelper::ConfigurationProperty<Dictionary, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Dictionary"_ustr); return PATH; }
private:
    Dictionary(); // not defined
    ~Dictionary(); // not defined
};

struct Favorite: public comphelper::ConfigurationProperty<Favorite, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Favorite"_ustr); return PATH; }
private:
    Favorite(); // not defined
    ~Favorite(); // not defined
};

struct Filter: public comphelper::ConfigurationProperty<Filter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Filter"_ustr); return PATH; }
private:
    Filter(); // not defined
    ~Filter(); // not defined
};

struct Gallery: public comphelper::ConfigurationProperty<Gallery, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Gallery"_ustr); return PATH; }
private:
    Gallery(); // not defined
    ~Gallery(); // not defined
};

struct Graphic: public comphelper::ConfigurationProperty<Graphic, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Graphic"_ustr); return PATH; }
private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct Help: public comphelper::ConfigurationProperty<Help, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Help"_ustr); return PATH; }
private:
    Help(); // not defined
    ~Help(); // not defined
};

struct Linguistic: public comphelper::ConfigurationProperty<Linguistic, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Linguistic"_ustr); return PATH; }
private:
    Linguistic(); // not defined
    ~Linguistic(); // not defined
};

struct Module: public comphelper::ConfigurationProperty<Module, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Module"_ustr); return PATH; }
private:
    Module(); // not defined
    ~Module(); // not defined
};

struct Palette: public comphelper::ConfigurationProperty<Palette, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Palette"_ustr); return PATH; }
private:
    Palette(); // not defined
    ~Palette(); // not defined
};

struct Plugin: public comphelper::ConfigurationProperty<Plugin, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Plugin"_ustr); return PATH; }
private:
    Plugin(); // not defined
    ~Plugin(); // not defined
};

struct Temp: public comphelper::ConfigurationProperty<Temp, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Temp"_ustr); return PATH; }
private:
    Temp(); // not defined
    ~Temp(); // not defined
};

struct Template: public comphelper::ConfigurationProperty<Template, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Template"_ustr); return PATH; }
private:
    Template(); // not defined
    ~Template(); // not defined
};

struct UIConfig: public comphelper::ConfigurationProperty<UIConfig, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/UIConfig"_ustr); return PATH; }
private:
    UIConfig(); // not defined
    ~UIConfig(); // not defined
};

struct UserConfig: public comphelper::ConfigurationProperty<UserConfig, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/UserConfig"_ustr); return PATH; }
private:
    UserConfig(); // not defined
    ~UserConfig(); // not defined
};

struct UserDictionary: public comphelper::ConfigurationProperty<UserDictionary, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/UserDictionary"_ustr); return PATH; }
private:
    UserDictionary(); // not defined
    ~UserDictionary(); // not defined
};

struct Work: public comphelper::ConfigurationProperty<Work, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Path/Default/Work"_ustr); return PATH; }
private:
    Work(); // not defined
    ~Work(); // not defined
};

private:
    Default(); // not defined
    ~Default(); // not defined
};

private:
    Path(); // not defined
    ~Path(); // not defined
};

struct Font: public comphelper::ConfigurationGroup< Font> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font"_ustr); return PATH; }

struct Substitution: public comphelper::ConfigurationGroup< Substitution> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/Substitution"_ustr); return PATH; }

struct Replacement: public comphelper::ConfigurationProperty<Replacement, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/Substitution/Replacement"_ustr); return PATH; }
private:
    Replacement(); // not defined
    ~Replacement(); // not defined
};

struct FontPairs: public comphelper::ConfigurationSet< FontPairs> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/Substitution/FontPairs"_ustr); return PATH; }
private:
    FontPairs(); // not defined
    ~FontPairs(); // not defined
};

private:
    Substitution(); // not defined
    ~Substitution(); // not defined
};

struct View: public comphelper::ConfigurationGroup< View> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/View"_ustr); return PATH; }

struct History: public comphelper::ConfigurationProperty<History, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/View/History"_ustr); return PATH; }
private:
    History(); // not defined
    ~History(); // not defined
};

struct ShowFontBoxWYSIWYG: public comphelper::ConfigurationProperty<ShowFontBoxWYSIWYG, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/View/ShowFontBoxWYSIWYG"_ustr); return PATH; }
private:
    ShowFontBoxWYSIWYG(); // not defined
    ~ShowFontBoxWYSIWYG(); // not defined
};

private:
    View(); // not defined
    ~View(); // not defined
};

struct SourceViewFont: public comphelper::ConfigurationGroup< SourceViewFont> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/SourceViewFont"_ustr); return PATH; }

struct FontName: public comphelper::ConfigurationProperty<FontName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/SourceViewFont/FontName"_ustr); return PATH; }
private:
    FontName(); // not defined
    ~FontName(); // not defined
};

struct FontHeight: public comphelper::ConfigurationProperty<FontHeight, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/SourceViewFont/FontHeight"_ustr); return PATH; }
private:
    FontHeight(); // not defined
    ~FontHeight(); // not defined
};

struct NonProportionalFontsOnly: public comphelper::ConfigurationProperty<NonProportionalFontsOnly, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Font/SourceViewFont/NonProportionalFontsOnly"_ustr); return PATH; }
private:
    NonProportionalFontsOnly(); // not defined
    ~NonProportionalFontsOnly(); // not defined
};

private:
    SourceViewFont(); // not defined
    ~SourceViewFont(); // not defined
};

private:
    Font(); // not defined
    ~Font(); // not defined
};

struct Menus: public comphelper::ConfigurationGroup< Menus> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus"_ustr); return PATH; }

struct New: public comphelper::ConfigurationSet< New> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/New"_ustr); return PATH; }
private:
    New(); // not defined
    ~New(); // not defined
};

struct Wizard: public comphelper::ConfigurationSet< Wizard> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/Wizard"_ustr); return PATH; }
private:
    Wizard(); // not defined
    ~Wizard(); // not defined
};

struct HelpBookmarks: public comphelper::ConfigurationSet< HelpBookmarks> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/HelpBookmarks"_ustr); return PATH; }
private:
    HelpBookmarks(); // not defined
    ~HelpBookmarks(); // not defined
};

struct SendFeedbackURL: public comphelper::ConfigurationProperty<SendFeedbackURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/SendFeedbackURL"_ustr); return PATH; }
private:
    SendFeedbackURL(); // not defined
    ~SendFeedbackURL(); // not defined
};

struct VolunteerURL: public comphelper::ConfigurationProperty<VolunteerURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/VolunteerURL"_ustr); return PATH; }
private:
    VolunteerURL(); // not defined
    ~VolunteerURL(); // not defined
};

struct QA_URL: public comphelper::ConfigurationProperty<QA_URL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/QA_URL"_ustr); return PATH; }
private:
    QA_URL(); // not defined
    ~QA_URL(); // not defined
};

struct DocumentationURL: public comphelper::ConfigurationProperty<DocumentationURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/DocumentationURL"_ustr); return PATH; }
private:
    DocumentationURL(); // not defined
    ~DocumentationURL(); // not defined
};

struct GetInvolvedURL: public comphelper::ConfigurationProperty<GetInvolvedURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/GetInvolvedURL"_ustr); return PATH; }
private:
    GetInvolvedURL(); // not defined
    ~GetInvolvedURL(); // not defined
};

struct DonationURL: public comphelper::ConfigurationProperty<DonationURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/DonationURL"_ustr); return PATH; }
private:
    DonationURL(); // not defined
    ~DonationURL(); // not defined
};

struct ReleaseNotesURL: public comphelper::ConfigurationProperty<ReleaseNotesURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/ReleaseNotesURL"_ustr); return PATH; }
private:
    ReleaseNotesURL(); // not defined
    ~ReleaseNotesURL(); // not defined
};

struct CreditsURL: public comphelper::ConfigurationProperty<CreditsURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/CreditsURL"_ustr); return PATH; }
private:
    CreditsURL(); // not defined
    ~CreditsURL(); // not defined
};

struct HyphenationMissingURL: public comphelper::ConfigurationProperty<HyphenationMissingURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/HyphenationMissingURL"_ustr); return PATH; }
private:
    HyphenationMissingURL(); // not defined
    ~HyphenationMissingURL(); // not defined
};

struct InstallJavaURL: public comphelper::ConfigurationProperty<InstallJavaURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/InstallJavaURL"_ustr); return PATH; }
private:
    InstallJavaURL(); // not defined
    ~InstallJavaURL(); // not defined
};

struct PrivacyPolicyURL: public comphelper::ConfigurationProperty<PrivacyPolicyURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/PrivacyPolicyURL"_ustr); return PATH; }
private:
    PrivacyPolicyURL(); // not defined
    ~PrivacyPolicyURL(); // not defined
};

struct ExtensionsURL: public comphelper::ConfigurationProperty<ExtensionsURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Menus/ExtensionsURL"_ustr); return PATH; }
private:
    ExtensionsURL(); // not defined
    ~ExtensionsURL(); // not defined
};

private:
    Menus(); // not defined
    ~Menus(); // not defined
};

struct History: public comphelper::ConfigurationGroup< History> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History"_ustr); return PATH; }

struct HelpBookmarkSize: public comphelper::ConfigurationProperty<HelpBookmarkSize, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History/HelpBookmarkSize"_ustr); return PATH; }
private:
    HelpBookmarkSize(); // not defined
    ~HelpBookmarkSize(); // not defined
};

struct Size: public comphelper::ConfigurationProperty<Size, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History/Size"_ustr); return PATH; }
private:
    Size(); // not defined
    ~Size(); // not defined
};

struct PickListSize: public comphelper::ConfigurationProperty<PickListSize, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History/PickListSize"_ustr); return PATH; }
private:
    PickListSize(); // not defined
    ~PickListSize(); // not defined
};

struct RecentDocsThumbnail: public comphelper::ConfigurationProperty<RecentDocsThumbnail, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History/RecentDocsThumbnail"_ustr); return PATH; }
private:
    RecentDocsThumbnail(); // not defined
    ~RecentDocsThumbnail(); // not defined
};

struct ShowCurrentModuleOnly: public comphelper::ConfigurationProperty<ShowCurrentModuleOnly, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History/ShowCurrentModuleOnly"_ustr); return PATH; }
private:
    ShowCurrentModuleOnly(); // not defined
    ~ShowCurrentModuleOnly(); // not defined
};

struct HelpBookmarks: public comphelper::ConfigurationSet< HelpBookmarks> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History/HelpBookmarks"_ustr); return PATH; }
private:
    HelpBookmarks(); // not defined
    ~HelpBookmarks(); // not defined
};

struct List: public comphelper::ConfigurationSet< List> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History/List"_ustr); return PATH; }
private:
    List(); // not defined
    ~List(); // not defined
};

struct PickList: public comphelper::ConfigurationSet< PickList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/History/PickList"_ustr); return PATH; }
private:
    PickList(); // not defined
    ~PickList(); // not defined
};

private:
    History(); // not defined
    ~History(); // not defined
};

struct Internal: public comphelper::ConfigurationGroup< Internal> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Internal"_ustr); return PATH; }

struct RecoveryList: public comphelper::ConfigurationSet< RecoveryList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Internal/RecoveryList"_ustr); return PATH; }
private:
    RecoveryList(); // not defined
    ~RecoveryList(); // not defined
};

private:
    Internal(); // not defined
    ~Internal(); // not defined
};

struct Save: public comphelper::ConfigurationGroup< Save> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save"_ustr); return PATH; }

struct WorkingSet: public comphelper::ConfigurationProperty<WorkingSet, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/WorkingSet"_ustr); return PATH; }
private:
    WorkingSet(); // not defined
    ~WorkingSet(); // not defined
};

struct Document: public comphelper::ConfigurationGroup< Document> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document"_ustr); return PATH; }

struct Unpacked: public comphelper::ConfigurationProperty<Unpacked, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/Unpacked"_ustr); return PATH; }
private:
    Unpacked(); // not defined
    ~Unpacked(); // not defined
};

struct UseUserData: public comphelper::ConfigurationProperty<UseUserData, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/UseUserData"_ustr); return PATH; }
private:
    UseUserData(); // not defined
    ~UseUserData(); // not defined
};

struct GenerateThumbnail: public comphelper::ConfigurationProperty<GenerateThumbnail, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/GenerateThumbnail"_ustr); return PATH; }
private:
    GenerateThumbnail(); // not defined
    ~GenerateThumbnail(); // not defined
};

struct CreateBackup: public comphelper::ConfigurationProperty<CreateBackup, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/CreateBackup"_ustr); return PATH; }
private:
    CreateBackup(); // not defined
    ~CreateBackup(); // not defined
};

struct BackupIntoDocumentFolder: public comphelper::ConfigurationProperty<BackupIntoDocumentFolder, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/BackupIntoDocumentFolder"_ustr); return PATH; }
private:
    BackupIntoDocumentFolder(); // not defined
    ~BackupIntoDocumentFolder(); // not defined
};

struct EditProperty: public comphelper::ConfigurationProperty<EditProperty, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/EditProperty"_ustr); return PATH; }
private:
    EditProperty(); // not defined
    ~EditProperty(); // not defined
};

struct ViewInfo: public comphelper::ConfigurationProperty<ViewInfo, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/ViewInfo"_ustr); return PATH; }
private:
    ViewInfo(); // not defined
    ~ViewInfo(); // not defined
};

struct PrettyPrinting: public comphelper::ConfigurationProperty<PrettyPrinting, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/PrettyPrinting"_ustr); return PATH; }
private:
    PrettyPrinting(); // not defined
    ~PrettyPrinting(); // not defined
};

struct WarnAlienFormat: public comphelper::ConfigurationProperty<WarnAlienFormat, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/WarnAlienFormat"_ustr); return PATH; }
private:
    WarnAlienFormat(); // not defined
    ~WarnAlienFormat(); // not defined
};

struct AlwaysSaveAs: public comphelper::ConfigurationProperty<AlwaysSaveAs, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/AlwaysSaveAs"_ustr); return PATH; }
private:
    AlwaysSaveAs(); // not defined
    ~AlwaysSaveAs(); // not defined
};

struct LoadPrinter: public comphelper::ConfigurationProperty<LoadPrinter, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/LoadPrinter"_ustr); return PATH; }
private:
    LoadPrinter(); // not defined
    ~LoadPrinter(); // not defined
};

struct GeneratorOverride: public comphelper::ConfigurationProperty<GeneratorOverride, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Document/GeneratorOverride"_ustr); return PATH; }
private:
    GeneratorOverride(); // not defined
    ~GeneratorOverride(); // not defined
};

private:
    Document(); // not defined
    ~Document(); // not defined
};

struct Graphic: public comphelper::ConfigurationGroup< Graphic> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Graphic"_ustr); return PATH; }

struct Format: public comphelper::ConfigurationProperty<Format, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Graphic/Format"_ustr); return PATH; }
private:
    Format(); // not defined
    ~Format(); // not defined
};

struct AddReplacementImages: public comphelper::ConfigurationProperty<AddReplacementImages, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/Graphic/AddReplacementImages"_ustr); return PATH; }
private:
    AddReplacementImages(); // not defined
    ~AddReplacementImages(); // not defined
};

private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct URL: public comphelper::ConfigurationGroup< URL> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/URL"_ustr); return PATH; }

struct FileSystem: public comphelper::ConfigurationProperty<FileSystem, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/URL/FileSystem"_ustr); return PATH; }
private:
    FileSystem(); // not defined
    ~FileSystem(); // not defined
};

struct Internet: public comphelper::ConfigurationProperty<Internet, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/URL/Internet"_ustr); return PATH; }
private:
    Internet(); // not defined
    ~Internet(); // not defined
};

private:
    URL(); // not defined
    ~URL(); // not defined
};

struct ODF: public comphelper::ConfigurationGroup< ODF> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/ODF"_ustr); return PATH; }

struct DefaultVersion: public comphelper::ConfigurationProperty<DefaultVersion, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Save/ODF/DefaultVersion"_ustr); return PATH; }
private:
    DefaultVersion(); // not defined
    ~DefaultVersion(); // not defined
};

private:
    ODF(); // not defined
    ~ODF(); // not defined
};

private:
    Save(); // not defined
    ~Save(); // not defined
};

struct Load: public comphelper::ConfigurationGroup< Load> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Load"_ustr); return PATH; }

struct UserDefinedSettings: public comphelper::ConfigurationProperty<UserDefinedSettings, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Load/UserDefinedSettings"_ustr); return PATH; }
private:
    UserDefinedSettings(); // not defined
    ~UserDefinedSettings(); // not defined
};

struct ViewPositionForAnyUser: public comphelper::ConfigurationProperty<ViewPositionForAnyUser, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Load/ViewPositionForAnyUser"_ustr); return PATH; }
private:
    ViewPositionForAnyUser(); // not defined
    ~ViewPositionForAnyUser(); // not defined
};

struct DetectWebDAVRedirection: public comphelper::ConfigurationProperty<DetectWebDAVRedirection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Load/DetectWebDAVRedirection"_ustr); return PATH; }
private:
    DetectWebDAVRedirection(); // not defined
    ~DetectWebDAVRedirection(); // not defined
};

struct DisableBuiltinStyles: public comphelper::ConfigurationProperty<DisableBuiltinStyles, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Load/DisableBuiltinStyles"_ustr); return PATH; }
private:
    DisableBuiltinStyles(); // not defined
    ~DisableBuiltinStyles(); // not defined
};

private:
    Load(); // not defined
    ~Load(); // not defined
};

struct Security: public comphelper::ConfigurationGroup< Security> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security"_ustr); return PATH; }

struct LoadExoticFileFormats: public comphelper::ConfigurationProperty<LoadExoticFileFormats, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/LoadExoticFileFormats"_ustr); return PATH; }
private:
    LoadExoticFileFormats(); // not defined
    ~LoadExoticFileFormats(); // not defined
};

struct EnableExpertConfiguration: public comphelper::ConfigurationProperty<EnableExpertConfiguration, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/EnableExpertConfiguration"_ustr); return PATH; }
private:
    EnableExpertConfiguration(); // not defined
    ~EnableExpertConfiguration(); // not defined
};

struct OpenPGP: public comphelper::ConfigurationGroup< OpenPGP> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/OpenPGP"_ustr); return PATH; }

struct MinimalKeyExport: public comphelper::ConfigurationProperty<MinimalKeyExport, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/OpenPGP/MinimalKeyExport"_ustr); return PATH; }
private:
    MinimalKeyExport(); // not defined
    ~MinimalKeyExport(); // not defined
};

private:
    OpenPGP(); // not defined
    ~OpenPGP(); // not defined
};

struct Scripting: public comphelper::ConfigurationGroup< Scripting> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting"_ustr); return PATH; }

struct SecureURL: public comphelper::ConfigurationProperty<SecureURL, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/SecureURL"_ustr); return PATH; }
private:
    SecureURL(); // not defined
    ~SecureURL(); // not defined
};

struct WarnSaveOrSendDoc: public comphelper::ConfigurationProperty<WarnSaveOrSendDoc, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WarnSaveOrSendDoc"_ustr); return PATH; }
private:
    WarnSaveOrSendDoc(); // not defined
    ~WarnSaveOrSendDoc(); // not defined
};

struct WarnSignDoc: public comphelper::ConfigurationProperty<WarnSignDoc, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WarnSignDoc"_ustr); return PATH; }
private:
    WarnSignDoc(); // not defined
    ~WarnSignDoc(); // not defined
};

struct ImplicitScriptSign: public comphelper::ConfigurationProperty<ImplicitScriptSign, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/ImplicitScriptSign"_ustr); return PATH; }
private:
    ImplicitScriptSign(); // not defined
    ~ImplicitScriptSign(); // not defined
};

struct CertDir: public comphelper::ConfigurationProperty<CertDir, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/CertDir"_ustr); return PATH; }
private:
    CertDir(); // not defined
    ~CertDir(); // not defined
};

struct ManualCertDir: public comphelper::ConfigurationProperty<ManualCertDir, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/ManualCertDir"_ustr); return PATH; }
private:
    ManualCertDir(); // not defined
    ~ManualCertDir(); // not defined
};

struct CertMgrPath: public comphelper::ConfigurationProperty<CertMgrPath, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/CertMgrPath"_ustr); return PATH; }
private:
    CertMgrPath(); // not defined
    ~CertMgrPath(); // not defined
};

struct TSAURLs: public comphelper::ConfigurationProperty<TSAURLs, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/TSAURLs"_ustr); return PATH; }
private:
    TSAURLs(); // not defined
    ~TSAURLs(); // not defined
};

struct WarnPrintDoc: public comphelper::ConfigurationProperty<WarnPrintDoc, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WarnPrintDoc"_ustr); return PATH; }
private:
    WarnPrintDoc(); // not defined
    ~WarnPrintDoc(); // not defined
};

struct WarnCreatePDF: public comphelper::ConfigurationProperty<WarnCreatePDF, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WarnCreatePDF"_ustr); return PATH; }
private:
    WarnCreatePDF(); // not defined
    ~WarnCreatePDF(); // not defined
};

struct RemovePersonalInfoOnSaving: public comphelper::ConfigurationProperty<RemovePersonalInfoOnSaving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/RemovePersonalInfoOnSaving"_ustr); return PATH; }
private:
    RemovePersonalInfoOnSaving(); // not defined
    ~RemovePersonalInfoOnSaving(); // not defined
};

struct KeepRedlineInfoOnSaving: public comphelper::ConfigurationProperty<KeepRedlineInfoOnSaving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/KeepRedlineInfoOnSaving"_ustr); return PATH; }
private:
    KeepRedlineInfoOnSaving(); // not defined
    ~KeepRedlineInfoOnSaving(); // not defined
};

struct KeepDocUserInfoOnSaving: public comphelper::ConfigurationProperty<KeepDocUserInfoOnSaving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/KeepDocUserInfoOnSaving"_ustr); return PATH; }
private:
    KeepDocUserInfoOnSaving(); // not defined
    ~KeepDocUserInfoOnSaving(); // not defined
};

struct KeepNoteAuthorDateInfoOnSaving: public comphelper::ConfigurationProperty<KeepNoteAuthorDateInfoOnSaving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/KeepNoteAuthorDateInfoOnSaving"_ustr); return PATH; }
private:
    KeepNoteAuthorDateInfoOnSaving(); // not defined
    ~KeepNoteAuthorDateInfoOnSaving(); // not defined
};

struct KeepDocVersionInfoOnSaving: public comphelper::ConfigurationProperty<KeepDocVersionInfoOnSaving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/KeepDocVersionInfoOnSaving"_ustr); return PATH; }
private:
    KeepDocVersionInfoOnSaving(); // not defined
    ~KeepDocVersionInfoOnSaving(); // not defined
};

struct KeepDocPrinterSettingsOnSaving: public comphelper::ConfigurationProperty<KeepDocPrinterSettingsOnSaving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/KeepDocPrinterSettingsOnSaving"_ustr); return PATH; }
private:
    KeepDocPrinterSettingsOnSaving(); // not defined
    ~KeepDocPrinterSettingsOnSaving(); // not defined
};

struct RecommendPasswordProtection: public comphelper::ConfigurationProperty<RecommendPasswordProtection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/RecommendPasswordProtection"_ustr); return PATH; }
private:
    RecommendPasswordProtection(); // not defined
    ~RecommendPasswordProtection(); // not defined
};

struct PasswordPolicy: public comphelper::ConfigurationProperty<PasswordPolicy, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/PasswordPolicy"_ustr); return PATH; }
private:
    PasswordPolicy(); // not defined
    ~PasswordPolicy(); // not defined
};

struct PasswordPolicyErrorMessage: public comphelper::ConfigurationLocalizedProperty<PasswordPolicyErrorMessage, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/PasswordPolicyErrorMessage"_ustr); return PATH; }
private:
    PasswordPolicyErrorMessage(); // not defined
    ~PasswordPolicyErrorMessage(); // not defined
};

struct HyperlinksWithCtrlClick: public comphelper::ConfigurationProperty<HyperlinksWithCtrlClick, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/HyperlinksWithCtrlClick"_ustr); return PATH; }
private:
    HyperlinksWithCtrlClick(); // not defined
    ~HyperlinksWithCtrlClick(); // not defined
};

struct BlockUntrustedRefererLinks: public comphelper::ConfigurationProperty<BlockUntrustedRefererLinks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/BlockUntrustedRefererLinks"_ustr); return PATH; }
private:
    BlockUntrustedRefererLinks(); // not defined
    ~BlockUntrustedRefererLinks(); // not defined
};

struct MacroSecurityLevel: public comphelper::ConfigurationProperty<MacroSecurityLevel, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/MacroSecurityLevel"_ustr); return PATH; }
private:
    MacroSecurityLevel(); // not defined
    ~MacroSecurityLevel(); // not defined
};

struct DisableMacrosExecution: public comphelper::ConfigurationProperty<DisableMacrosExecution, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/DisableMacrosExecution"_ustr); return PATH; }
private:
    DisableMacrosExecution(); // not defined
    ~DisableMacrosExecution(); // not defined
};

struct DisableActiveContent: public comphelper::ConfigurationProperty<DisableActiveContent, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/DisableActiveContent"_ustr); return PATH; }
private:
    DisableActiveContent(); // not defined
    ~DisableActiveContent(); // not defined
};

struct DisablePythonRuntime: public comphelper::ConfigurationProperty<DisablePythonRuntime, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/DisablePythonRuntime"_ustr); return PATH; }
private:
    DisablePythonRuntime(); // not defined
    ~DisablePythonRuntime(); // not defined
};

struct DisableOLEAutomation: public comphelper::ConfigurationProperty<DisableOLEAutomation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/DisableOLEAutomation"_ustr); return PATH; }
private:
    DisableOLEAutomation(); // not defined
    ~DisableOLEAutomation(); // not defined
};

struct CheckDocumentEvents: public comphelper::ConfigurationProperty<CheckDocumentEvents, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/CheckDocumentEvents"_ustr); return PATH; }
private:
    CheckDocumentEvents(); // not defined
    ~CheckDocumentEvents(); // not defined
};

struct AllowedDocumentEventURLs: public comphelper::ConfigurationProperty<AllowedDocumentEventURLs, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/AllowedDocumentEventURLs"_ustr); return PATH; }
private:
    AllowedDocumentEventURLs(); // not defined
    ~AllowedDocumentEventURLs(); // not defined
};

struct TrustedAuthors: public comphelper::ConfigurationSet< TrustedAuthors> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/TrustedAuthors"_ustr); return PATH; }
private:
    TrustedAuthors(); // not defined
    ~TrustedAuthors(); // not defined
};

struct WindowsSecurityZone: public comphelper::ConfigurationGroup< WindowsSecurityZone> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WindowsSecurityZone"_ustr); return PATH; }

struct ZoneLocal: public comphelper::ConfigurationProperty<ZoneLocal, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WindowsSecurityZone/ZoneLocal"_ustr); return PATH; }
private:
    ZoneLocal(); // not defined
    ~ZoneLocal(); // not defined
};

struct ZoneIntranet: public comphelper::ConfigurationProperty<ZoneIntranet, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WindowsSecurityZone/ZoneIntranet"_ustr); return PATH; }
private:
    ZoneIntranet(); // not defined
    ~ZoneIntranet(); // not defined
};

struct ZoneTrusted: public comphelper::ConfigurationProperty<ZoneTrusted, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WindowsSecurityZone/ZoneTrusted"_ustr); return PATH; }
private:
    ZoneTrusted(); // not defined
    ~ZoneTrusted(); // not defined
};

struct ZoneInternet: public comphelper::ConfigurationProperty<ZoneInternet, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WindowsSecurityZone/ZoneInternet"_ustr); return PATH; }
private:
    ZoneInternet(); // not defined
    ~ZoneInternet(); // not defined
};

struct ZoneUntrusted: public comphelper::ConfigurationProperty<ZoneUntrusted, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Security/Scripting/WindowsSecurityZone/ZoneUntrusted"_ustr); return PATH; }
private:
    ZoneUntrusted(); // not defined
    ~ZoneUntrusted(); // not defined
};

private:
    WindowsSecurityZone(); // not defined
    ~WindowsSecurityZone(); // not defined
};

private:
    Scripting(); // not defined
    ~Scripting(); // not defined
};

private:
    Security(); // not defined
    ~Security(); // not defined
};

struct View: public comphelper::ConfigurationGroup< View> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View"_ustr); return PATH; }

struct NewDocumentHandling: public comphelper::ConfigurationGroup< NewDocumentHandling> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/NewDocumentHandling"_ustr); return PATH; }

struct ForceFocusAndToFront: public comphelper::ConfigurationProperty<ForceFocusAndToFront, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/NewDocumentHandling/ForceFocusAndToFront"_ustr); return PATH; }
private:
    ForceFocusAndToFront(); // not defined
    ~ForceFocusAndToFront(); // not defined
};

private:
    NewDocumentHandling(); // not defined
    ~NewDocumentHandling(); // not defined
};

struct Dialog: public comphelper::ConfigurationGroup< Dialog> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Dialog"_ustr); return PATH; }

struct MousePositioning: public comphelper::ConfigurationProperty<MousePositioning, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Dialog/MousePositioning"_ustr); return PATH; }
private:
    MousePositioning(); // not defined
    ~MousePositioning(); // not defined
};

struct MiddleMouseButton: public comphelper::ConfigurationProperty<MiddleMouseButton, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Dialog/MiddleMouseButton"_ustr); return PATH; }
private:
    MiddleMouseButton(); // not defined
    ~MiddleMouseButton(); // not defined
};

private:
    Dialog(); // not defined
    ~Dialog(); // not defined
};

struct Menu: public comphelper::ConfigurationGroup< Menu> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Menu"_ustr); return PATH; }

struct DontHideDisabledEntry: public comphelper::ConfigurationProperty<DontHideDisabledEntry, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Menu/DontHideDisabledEntry"_ustr); return PATH; }
private:
    DontHideDisabledEntry(); // not defined
    ~DontHideDisabledEntry(); // not defined
};

struct IsSystemIconsInMenus: public comphelper::ConfigurationProperty<IsSystemIconsInMenus, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Menu/IsSystemIconsInMenus"_ustr); return PATH; }
private:
    IsSystemIconsInMenus(); // not defined
    ~IsSystemIconsInMenus(); // not defined
};

struct ShowIconsInMenues: public comphelper::ConfigurationProperty<ShowIconsInMenues, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Menu/ShowIconsInMenues"_ustr); return PATH; }
private:
    ShowIconsInMenues(); // not defined
    ~ShowIconsInMenues(); // not defined
};

struct FollowMouse: public comphelper::ConfigurationProperty<FollowMouse, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Menu/FollowMouse"_ustr); return PATH; }
private:
    FollowMouse(); // not defined
    ~FollowMouse(); // not defined
};

struct ShortcutsInContextMenus: public comphelper::ConfigurationProperty<ShortcutsInContextMenus, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Menu/ShortcutsInContextMenus"_ustr); return PATH; }
private:
    ShortcutsInContextMenus(); // not defined
    ~ShortcutsInContextMenus(); // not defined
};

private:
    Menu(); // not defined
    ~Menu(); // not defined
};

struct Window: public comphelper::ConfigurationGroup< Window> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Window"_ustr); return PATH; }

struct Drag: public comphelper::ConfigurationProperty<Drag, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/Window/Drag"_ustr); return PATH; }
private:
    Drag(); // not defined
    ~Drag(); // not defined
};

private:
    Window(); // not defined
    ~Window(); // not defined
};

struct FontAntiAliasing: public comphelper::ConfigurationGroup< FontAntiAliasing> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/FontAntiAliasing"_ustr); return PATH; }

struct Enabled: public comphelper::ConfigurationProperty<Enabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/FontAntiAliasing/Enabled"_ustr); return PATH; }
private:
    Enabled(); // not defined
    ~Enabled(); // not defined
};

struct MinPixelHeight: public comphelper::ConfigurationProperty<MinPixelHeight, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/View/FontAntiAliasing/MinPixelHeight"_ustr); return PATH; }
private:
    MinPixelHeight(); // not defined
    ~MinPixelHeight(); // not defined
};

private:
    FontAntiAliasing(); // not defined
    ~FontAntiAliasing(); // not defined
};

private:
    View(); // not defined
    ~View(); // not defined
};

struct Undo: public comphelper::ConfigurationGroup< Undo> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Undo"_ustr); return PATH; }

struct Steps: public comphelper::ConfigurationProperty<Steps, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Undo/Steps"_ustr); return PATH; }
private:
    Steps(); // not defined
    ~Steps(); // not defined
};

private:
    Undo(); // not defined
    ~Undo(); // not defined
};

struct Setup: public comphelper::ConfigurationGroup< Setup> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Setup"_ustr); return PATH; }

struct Language: public comphelper::ConfigurationGroup< Language> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Setup/Language"_ustr); return PATH; }

struct Locales: public comphelper::ConfigurationProperty<Locales, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Setup/Language/Locales"_ustr); return PATH; }
private:
    Locales(); // not defined
    ~Locales(); // not defined
};

private:
    Language(); // not defined
    ~Language(); // not defined
};

private:
    Setup(); // not defined
    ~Setup(); // not defined
};

struct Print: public comphelper::ConfigurationGroup< Print> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print"_ustr); return PATH; }

struct PrintingModifiesDocument: public comphelper::ConfigurationProperty<PrintingModifiesDocument, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/PrintingModifiesDocument"_ustr); return PATH; }
private:
    PrintingModifiesDocument(); // not defined
    ~PrintingModifiesDocument(); // not defined
};

struct Warning: public comphelper::ConfigurationGroup< Warning> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Warning"_ustr); return PATH; }

struct PaperSize: public comphelper::ConfigurationProperty<PaperSize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Warning/PaperSize"_ustr); return PATH; }
private:
    PaperSize(); // not defined
    ~PaperSize(); // not defined
};

struct PaperOrientation: public comphelper::ConfigurationProperty<PaperOrientation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Warning/PaperOrientation"_ustr); return PATH; }
private:
    PaperOrientation(); // not defined
    ~PaperOrientation(); // not defined
};

struct NotFound: public comphelper::ConfigurationProperty<NotFound, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Warning/NotFound"_ustr); return PATH; }
private:
    NotFound(); // not defined
    ~NotFound(); // not defined
};

struct Transparency: public comphelper::ConfigurationProperty<Transparency, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Warning/Transparency"_ustr); return PATH; }
private:
    Transparency(); // not defined
    ~Transparency(); // not defined
};

private:
    Warning(); // not defined
    ~Warning(); // not defined
};

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option"_ustr); return PATH; }

struct Printer: public comphelper::ConfigurationGroup< Printer> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer"_ustr); return PATH; }

struct ReduceTransparency: public comphelper::ConfigurationProperty<ReduceTransparency, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReduceTransparency"_ustr); return PATH; }
private:
    ReduceTransparency(); // not defined
    ~ReduceTransparency(); // not defined
};

struct ReducedTransparencyMode: public comphelper::ConfigurationProperty<ReducedTransparencyMode, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReducedTransparencyMode"_ustr); return PATH; }
private:
    ReducedTransparencyMode(); // not defined
    ~ReducedTransparencyMode(); // not defined
};

struct ReduceGradients: public comphelper::ConfigurationProperty<ReduceGradients, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReduceGradients"_ustr); return PATH; }
private:
    ReduceGradients(); // not defined
    ~ReduceGradients(); // not defined
};

struct ReducedGradientMode: public comphelper::ConfigurationProperty<ReducedGradientMode, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReducedGradientMode"_ustr); return PATH; }
private:
    ReducedGradientMode(); // not defined
    ~ReducedGradientMode(); // not defined
};

struct ReducedGradientStepCount: public comphelper::ConfigurationProperty<ReducedGradientStepCount, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReducedGradientStepCount"_ustr); return PATH; }
private:
    ReducedGradientStepCount(); // not defined
    ~ReducedGradientStepCount(); // not defined
};

struct ReduceBitmaps: public comphelper::ConfigurationProperty<ReduceBitmaps, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReduceBitmaps"_ustr); return PATH; }
private:
    ReduceBitmaps(); // not defined
    ~ReduceBitmaps(); // not defined
};

struct ReducedBitmapMode: public comphelper::ConfigurationProperty<ReducedBitmapMode, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReducedBitmapMode"_ustr); return PATH; }
private:
    ReducedBitmapMode(); // not defined
    ~ReducedBitmapMode(); // not defined
};

struct ReducedBitmapResolution: public comphelper::ConfigurationProperty<ReducedBitmapResolution, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReducedBitmapResolution"_ustr); return PATH; }
private:
    ReducedBitmapResolution(); // not defined
    ~ReducedBitmapResolution(); // not defined
};

struct ReducedBitmapIncludesTransparency: public comphelper::ConfigurationProperty<ReducedBitmapIncludesTransparency, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ReducedBitmapIncludesTransparency"_ustr); return PATH; }
private:
    ReducedBitmapIncludesTransparency(); // not defined
    ~ReducedBitmapIncludesTransparency(); // not defined
};

struct ConvertToGreyscales: public comphelper::ConfigurationProperty<ConvertToGreyscales, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/Printer/ConvertToGreyscales"_ustr); return PATH; }
private:
    ConvertToGreyscales(); // not defined
    ~ConvertToGreyscales(); // not defined
};

private:
    Printer(); // not defined
    ~Printer(); // not defined
};

struct File: public comphelper::ConfigurationGroup< File> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File"_ustr); return PATH; }

struct ReduceTransparency: public comphelper::ConfigurationProperty<ReduceTransparency, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReduceTransparency"_ustr); return PATH; }
private:
    ReduceTransparency(); // not defined
    ~ReduceTransparency(); // not defined
};

struct ReducedTransparencyMode: public comphelper::ConfigurationProperty<ReducedTransparencyMode, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReducedTransparencyMode"_ustr); return PATH; }
private:
    ReducedTransparencyMode(); // not defined
    ~ReducedTransparencyMode(); // not defined
};

struct ReduceGradients: public comphelper::ConfigurationProperty<ReduceGradients, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReduceGradients"_ustr); return PATH; }
private:
    ReduceGradients(); // not defined
    ~ReduceGradients(); // not defined
};

struct ReducedGradientMode: public comphelper::ConfigurationProperty<ReducedGradientMode, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReducedGradientMode"_ustr); return PATH; }
private:
    ReducedGradientMode(); // not defined
    ~ReducedGradientMode(); // not defined
};

struct ReducedGradientStepCount: public comphelper::ConfigurationProperty<ReducedGradientStepCount, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReducedGradientStepCount"_ustr); return PATH; }
private:
    ReducedGradientStepCount(); // not defined
    ~ReducedGradientStepCount(); // not defined
};

struct ReduceBitmaps: public comphelper::ConfigurationProperty<ReduceBitmaps, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReduceBitmaps"_ustr); return PATH; }
private:
    ReduceBitmaps(); // not defined
    ~ReduceBitmaps(); // not defined
};

struct ReducedBitmapMode: public comphelper::ConfigurationProperty<ReducedBitmapMode, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReducedBitmapMode"_ustr); return PATH; }
private:
    ReducedBitmapMode(); // not defined
    ~ReducedBitmapMode(); // not defined
};

struct ReducedBitmapResolution: public comphelper::ConfigurationProperty<ReducedBitmapResolution, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReducedBitmapResolution"_ustr); return PATH; }
private:
    ReducedBitmapResolution(); // not defined
    ~ReducedBitmapResolution(); // not defined
};

struct ReducedBitmapIncludesTransparency: public comphelper::ConfigurationProperty<ReducedBitmapIncludesTransparency, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ReducedBitmapIncludesTransparency"_ustr); return PATH; }
private:
    ReducedBitmapIncludesTransparency(); // not defined
    ~ReducedBitmapIncludesTransparency(); // not defined
};

struct ConvertToGreyscales: public comphelper::ConfigurationProperty<ConvertToGreyscales, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Option/File/ConvertToGreyscales"_ustr); return PATH; }
private:
    ConvertToGreyscales(); // not defined
    ~ConvertToGreyscales(); // not defined
};

private:
    File(); // not defined
    ~File(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

struct Dialog: public comphelper::ConfigurationGroup< Dialog> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Dialog"_ustr); return PATH; }

struct RangeSectionExpanded: public comphelper::ConfigurationProperty<RangeSectionExpanded, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Dialog/RangeSectionExpanded"_ustr); return PATH; }
private:
    RangeSectionExpanded(); // not defined
    ~RangeSectionExpanded(); // not defined
};

struct LayoutSectionExpanded: public comphelper::ConfigurationProperty<LayoutSectionExpanded, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Print/Dialog/LayoutSectionExpanded"_ustr); return PATH; }
private:
    LayoutSectionExpanded(); // not defined
    ~LayoutSectionExpanded(); // not defined
};

private:
    Dialog(); // not defined
    ~Dialog(); // not defined
};

private:
    Print(); // not defined
    ~Print(); // not defined
};

struct UserColors: public comphelper::ConfigurationGroup< UserColors> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/UserColors"_ustr); return PATH; }

struct RecentColor: public comphelper::ConfigurationProperty<RecentColor, com::sun::star::uno::Sequence<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/UserColors/RecentColor"_ustr); return PATH; }
private:
    RecentColor(); // not defined
    ~RecentColor(); // not defined
};

struct RecentColorName: public comphelper::ConfigurationProperty<RecentColorName, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/UserColors/RecentColorName"_ustr); return PATH; }
private:
    RecentColorName(); // not defined
    ~RecentColorName(); // not defined
};

struct PaletteName: public comphelper::ConfigurationProperty<PaletteName, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/UserColors/PaletteName"_ustr); return PATH; }
private:
    PaletteName(); // not defined
    ~PaletteName(); // not defined
};

struct CustomColor: public comphelper::ConfigurationProperty<CustomColor, com::sun::star::uno::Sequence<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/UserColors/CustomColor"_ustr); return PATH; }
private:
    CustomColor(); // not defined
    ~CustomColor(); // not defined
};

struct CustomColorName: public comphelper::ConfigurationProperty<CustomColorName, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/UserColors/CustomColorName"_ustr); return PATH; }
private:
    CustomColorName(); // not defined
    ~CustomColorName(); // not defined
};

private:
    UserColors(); // not defined
    ~UserColors(); // not defined
};

struct RecentCharacters: public comphelper::ConfigurationGroup< RecentCharacters> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/RecentCharacters"_ustr); return PATH; }

struct RecentCharacterList: public comphelper::ConfigurationProperty<RecentCharacterList, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/RecentCharacters/RecentCharacterList"_ustr); return PATH; }
private:
    RecentCharacterList(); // not defined
    ~RecentCharacterList(); // not defined
};

struct RecentCharacterFontList: public comphelper::ConfigurationProperty<RecentCharacterFontList, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/RecentCharacters/RecentCharacterFontList"_ustr); return PATH; }
private:
    RecentCharacterFontList(); // not defined
    ~RecentCharacterFontList(); // not defined
};

private:
    RecentCharacters(); // not defined
    ~RecentCharacters(); // not defined
};

struct FavoriteCharacters: public comphelper::ConfigurationGroup< FavoriteCharacters> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/FavoriteCharacters"_ustr); return PATH; }

struct FavoriteCharacterList: public comphelper::ConfigurationProperty<FavoriteCharacterList, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/FavoriteCharacters/FavoriteCharacterList"_ustr); return PATH; }
private:
    FavoriteCharacterList(); // not defined
    ~FavoriteCharacterList(); // not defined
};

struct FavoriteCharacterFontList: public comphelper::ConfigurationProperty<FavoriteCharacterFontList, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/FavoriteCharacters/FavoriteCharacterFontList"_ustr); return PATH; }
private:
    FavoriteCharacterFontList(); // not defined
    ~FavoriteCharacterFontList(); // not defined
};

private:
    FavoriteCharacters(); // not defined
    ~FavoriteCharacters(); // not defined
};

struct BulletsNumbering: public comphelper::ConfigurationGroup< BulletsNumbering> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/BulletsNumbering"_ustr); return PATH; }

struct DefaultBullets: public comphelper::ConfigurationProperty<DefaultBullets, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/BulletsNumbering/DefaultBullets"_ustr); return PATH; }
private:
    DefaultBullets(); // not defined
    ~DefaultBullets(); // not defined
};

struct DefaultBulletsFonts: public comphelper::ConfigurationProperty<DefaultBulletsFonts, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/BulletsNumbering/DefaultBulletsFonts"_ustr); return PATH; }
private:
    DefaultBulletsFonts(); // not defined
    ~DefaultBulletsFonts(); // not defined
};

private:
    BulletsNumbering(); // not defined
    ~BulletsNumbering(); // not defined
};

struct Help: public comphelper::ConfigurationGroup< Help> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help"_ustr); return PATH; }

struct ShowBasic: public comphelper::ConfigurationProperty<ShowBasic, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/ShowBasic"_ustr); return PATH; }
private:
    ShowBasic(); // not defined
    ~ShowBasic(); // not defined
};

struct Locale: public comphelper::ConfigurationProperty<Locale, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/Locale"_ustr); return PATH; }
private:
    Locale(); // not defined
    ~Locale(); // not defined
};

struct System: public comphelper::ConfigurationProperty<System, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/System"_ustr); return PATH; }
private:
    System(); // not defined
    ~System(); // not defined
};

struct Tip: public comphelper::ConfigurationProperty<Tip, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/Tip"_ustr); return PATH; }
private:
    Tip(); // not defined
    ~Tip(); // not defined
};

struct ExtendedTip: public comphelper::ConfigurationProperty<ExtendedTip, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/ExtendedTip"_ustr); return PATH; }
private:
    ExtendedTip(); // not defined
    ~ExtendedTip(); // not defined
};

struct BuiltInHelpNotInstalledPopUp: public comphelper::ConfigurationProperty<BuiltInHelpNotInstalledPopUp, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/BuiltInHelpNotInstalledPopUp"_ustr); return PATH; }
private:
    BuiltInHelpNotInstalledPopUp(); // not defined
    ~BuiltInHelpNotInstalledPopUp(); // not defined
};

struct HelpStyleSheet: public comphelper::ConfigurationProperty<HelpStyleSheet, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/HelpStyleSheet"_ustr); return PATH; }
private:
    HelpStyleSheet(); // not defined
    ~HelpStyleSheet(); // not defined
};

struct HelpRootURL: public comphelper::ConfigurationProperty<HelpRootURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/HelpRootURL"_ustr); return PATH; }
private:
    HelpRootURL(); // not defined
    ~HelpRootURL(); // not defined
};

struct StartCenter: public comphelper::ConfigurationGroup< StartCenter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/StartCenter"_ustr); return PATH; }

struct InfoURL: public comphelper::ConfigurationProperty<InfoURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/StartCenter/InfoURL"_ustr); return PATH; }
private:
    InfoURL(); // not defined
    ~InfoURL(); // not defined
};

struct StartCenterThumbnailsBackgroundColor: public comphelper::ConfigurationProperty<StartCenterThumbnailsBackgroundColor, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/StartCenter/StartCenterThumbnailsBackgroundColor"_ustr); return PATH; }
private:
    StartCenterThumbnailsBackgroundColor(); // not defined
    ~StartCenterThumbnailsBackgroundColor(); // not defined
};

struct StartCenterThumbnailsTextColor: public comphelper::ConfigurationProperty<StartCenterThumbnailsTextColor, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Help/StartCenter/StartCenterThumbnailsTextColor"_ustr); return PATH; }
private:
    StartCenterThumbnailsTextColor(); // not defined
    ~StartCenterThumbnailsTextColor(); // not defined
};

private:
    StartCenter(); // not defined
    ~StartCenter(); // not defined
};

private:
    Help(); // not defined
    ~Help(); // not defined
};

struct Vectorize: public comphelper::ConfigurationGroup< Vectorize> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Vectorize"_ustr); return PATH; }

struct ColorCount: public comphelper::ConfigurationProperty<ColorCount, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Vectorize/ColorCount"_ustr); return PATH; }
private:
    ColorCount(); // not defined
    ~ColorCount(); // not defined
};

struct PointReduce: public comphelper::ConfigurationProperty<PointReduce, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Vectorize/PointReduce"_ustr); return PATH; }
private:
    PointReduce(); // not defined
    ~PointReduce(); // not defined
};

struct FillHole: public comphelper::ConfigurationProperty<FillHole, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Vectorize/FillHole"_ustr); return PATH; }
private:
    FillHole(); // not defined
    ~FillHole(); // not defined
};

struct TileExtent: public comphelper::ConfigurationProperty<TileExtent, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Vectorize/TileExtent"_ustr); return PATH; }
private:
    TileExtent(); // not defined
    ~TileExtent(); // not defined
};

private:
    Vectorize(); // not defined
    ~Vectorize(); // not defined
};

struct DateFormat: public comphelper::ConfigurationGroup< DateFormat> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/DateFormat"_ustr); return PATH; }

struct TwoDigitYear: public comphelper::ConfigurationProperty<TwoDigitYear, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/DateFormat/TwoDigitYear"_ustr); return PATH; }
private:
    TwoDigitYear(); // not defined
    ~TwoDigitYear(); // not defined
};

private:
    DateFormat(); // not defined
    ~DateFormat(); // not defined
};

struct Filter: public comphelper::ConfigurationGroup< Filter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter"_ustr); return PATH; }

struct Adobe: public comphelper::ConfigurationGroup< Adobe> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Adobe"_ustr); return PATH; }

struct Import: public comphelper::ConfigurationGroup< Import> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Adobe/Import"_ustr); return PATH; }

struct PDFToDraw: public comphelper::ConfigurationProperty<PDFToDraw, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Adobe/Import/PDFToDraw"_ustr); return PATH; }
private:
    PDFToDraw(); // not defined
    ~PDFToDraw(); // not defined
};

private:
    Import(); // not defined
    ~Import(); // not defined
};

private:
    Adobe(); // not defined
    ~Adobe(); // not defined
};

struct Microsoft: public comphelper::ConfigurationGroup< Microsoft> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft"_ustr); return PATH; }

struct Import: public comphelper::ConfigurationGroup< Import> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import"_ustr); return PATH; }

struct MathTypeToMath: public comphelper::ConfigurationProperty<MathTypeToMath, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/MathTypeToMath"_ustr); return PATH; }
private:
    MathTypeToMath(); // not defined
    ~MathTypeToMath(); // not defined
};

struct WinWordToWriter: public comphelper::ConfigurationProperty<WinWordToWriter, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/WinWordToWriter"_ustr); return PATH; }
private:
    WinWordToWriter(); // not defined
    ~WinWordToWriter(); // not defined
};

struct ExcelToCalc: public comphelper::ConfigurationProperty<ExcelToCalc, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/ExcelToCalc"_ustr); return PATH; }
private:
    ExcelToCalc(); // not defined
    ~ExcelToCalc(); // not defined
};

struct PowerPointToImpress: public comphelper::ConfigurationProperty<PowerPointToImpress, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/PowerPointToImpress"_ustr); return PATH; }
private:
    PowerPointToImpress(); // not defined
    ~PowerPointToImpress(); // not defined
};

struct SmartArtToShapes: public comphelper::ConfigurationProperty<SmartArtToShapes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/SmartArtToShapes"_ustr); return PATH; }
private:
    SmartArtToShapes(); // not defined
    ~SmartArtToShapes(); // not defined
};

struct ImportWWFieldsAsEnhancedFields: public comphelper::ConfigurationProperty<ImportWWFieldsAsEnhancedFields, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/ImportWWFieldsAsEnhancedFields"_ustr); return PATH; }
private:
    ImportWWFieldsAsEnhancedFields(); // not defined
    ~ImportWWFieldsAsEnhancedFields(); // not defined
};

struct ForceImportWWFieldsAsGenericFields: public comphelper::ConfigurationProperty<ForceImportWWFieldsAsGenericFields, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/ForceImportWWFieldsAsGenericFields"_ustr); return PATH; }
private:
    ForceImportWWFieldsAsGenericFields(); // not defined
    ~ForceImportWWFieldsAsGenericFields(); // not defined
};

struct CreateMSOLockFiles: public comphelper::ConfigurationProperty<CreateMSOLockFiles, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/CreateMSOLockFiles"_ustr); return PATH; }
private:
    CreateMSOLockFiles(); // not defined
    ~CreateMSOLockFiles(); // not defined
};

struct VisioToDraw: public comphelper::ConfigurationProperty<VisioToDraw, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Import/VisioToDraw"_ustr); return PATH; }
private:
    VisioToDraw(); // not defined
    ~VisioToDraw(); // not defined
};

private:
    Import(); // not defined
    ~Import(); // not defined
};

struct Export: public comphelper::ConfigurationGroup< Export> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export"_ustr); return PATH; }

struct MathToMathType: public comphelper::ConfigurationProperty<MathToMathType, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export/MathToMathType"_ustr); return PATH; }
private:
    MathToMathType(); // not defined
    ~MathToMathType(); // not defined
};

struct WriterToWinWord: public comphelper::ConfigurationProperty<WriterToWinWord, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export/WriterToWinWord"_ustr); return PATH; }
private:
    WriterToWinWord(); // not defined
    ~WriterToWinWord(); // not defined
};

struct CalcToExcel: public comphelper::ConfigurationProperty<CalcToExcel, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export/CalcToExcel"_ustr); return PATH; }
private:
    CalcToExcel(); // not defined
    ~CalcToExcel(); // not defined
};

struct ImpressToPowerPoint: public comphelper::ConfigurationProperty<ImpressToPowerPoint, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export/ImpressToPowerPoint"_ustr); return PATH; }
private:
    ImpressToPowerPoint(); // not defined
    ~ImpressToPowerPoint(); // not defined
};

struct EnablePowerPointPreview: public comphelper::ConfigurationProperty<EnablePowerPointPreview, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export/EnablePowerPointPreview"_ustr); return PATH; }
private:
    EnablePowerPointPreview(); // not defined
    ~EnablePowerPointPreview(); // not defined
};

struct EnableExcelPreview: public comphelper::ConfigurationProperty<EnableExcelPreview, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export/EnableExcelPreview"_ustr); return PATH; }
private:
    EnableExcelPreview(); // not defined
    ~EnableExcelPreview(); // not defined
};

struct EnableWordPreview: public comphelper::ConfigurationProperty<EnableWordPreview, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export/EnableWordPreview"_ustr); return PATH; }
private:
    EnableWordPreview(); // not defined
    ~EnableWordPreview(); // not defined
};

struct CharBackgroundToHighlighting: public comphelper::ConfigurationProperty<CharBackgroundToHighlighting, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Microsoft/Export/CharBackgroundToHighlighting"_ustr); return PATH; }
private:
    CharBackgroundToHighlighting(); // not defined
    ~CharBackgroundToHighlighting(); // not defined
};

private:
    Export(); // not defined
    ~Export(); // not defined
};

private:
    Microsoft(); // not defined
    ~Microsoft(); // not defined
};

struct Graphic: public comphelper::ConfigurationGroup< Graphic> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic"_ustr); return PATH; }

struct Import: public comphelper::ConfigurationGroup< Import> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Import"_ustr); return PATH; }

struct PCD: public comphelper::ConfigurationGroup< PCD> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Import/PCD"_ustr); return PATH; }

struct Resolution: public comphelper::ConfigurationProperty<Resolution, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Import/PCD/Resolution"_ustr); return PATH; }
private:
    Resolution(); // not defined
    ~Resolution(); // not defined
};

private:
    PCD(); // not defined
    ~PCD(); // not defined
};

private:
    Import(); // not defined
    ~Import(); // not defined
};

struct Export: public comphelper::ConfigurationGroup< Export> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export"_ustr); return PATH; }

struct PixelExportUnit: public comphelper::ConfigurationProperty<PixelExportUnit, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PixelExportUnit"_ustr); return PATH; }
private:
    PixelExportUnit(); // not defined
    ~PixelExportUnit(); // not defined
};

struct PixelExportResolutionUnit: public comphelper::ConfigurationProperty<PixelExportResolutionUnit, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PixelExportResolutionUnit"_ustr); return PATH; }
private:
    PixelExportResolutionUnit(); // not defined
    ~PixelExportResolutionUnit(); // not defined
};

struct PixelExportResolution: public comphelper::ConfigurationProperty<PixelExportResolution, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PixelExportResolution"_ustr); return PATH; }
private:
    PixelExportResolution(); // not defined
    ~PixelExportResolution(); // not defined
};

struct MaxFilesizeForRealtimePreview: public comphelper::ConfigurationProperty<MaxFilesizeForRealtimePreview, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/MaxFilesizeForRealtimePreview"_ustr); return PATH; }
private:
    MaxFilesizeForRealtimePreview(); // not defined
    ~MaxFilesizeForRealtimePreview(); // not defined
};

struct VectorExportUnit: public comphelper::ConfigurationProperty<VectorExportUnit, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/VectorExportUnit"_ustr); return PATH; }
private:
    VectorExportUnit(); // not defined
    ~VectorExportUnit(); // not defined
};

struct BMP: public comphelper::ConfigurationGroup< BMP> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/BMP"_ustr); return PATH; }

struct Color: public comphelper::ConfigurationProperty<Color, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/BMP/Color"_ustr); return PATH; }
private:
    Color(); // not defined
    ~Color(); // not defined
};

struct RLE_Coding: public comphelper::ConfigurationProperty<RLE_Coding, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/BMP/RLE_Coding"_ustr); return PATH; }
private:
    RLE_Coding(); // not defined
    ~RLE_Coding(); // not defined
};

private:
    BMP(); // not defined
    ~BMP(); // not defined
};

struct EPS: public comphelper::ConfigurationGroup< EPS> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/EPS"_ustr); return PATH; }

struct Preview: public comphelper::ConfigurationProperty<Preview, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/EPS/Preview"_ustr); return PATH; }
private:
    Preview(); // not defined
    ~Preview(); // not defined
};

struct Version: public comphelper::ConfigurationProperty<Version, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/EPS/Version"_ustr); return PATH; }
private:
    Version(); // not defined
    ~Version(); // not defined
};

struct ColorFormat: public comphelper::ConfigurationProperty<ColorFormat, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/EPS/ColorFormat"_ustr); return PATH; }
private:
    ColorFormat(); // not defined
    ~ColorFormat(); // not defined
};

struct CompressionMode: public comphelper::ConfigurationProperty<CompressionMode, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/EPS/CompressionMode"_ustr); return PATH; }
private:
    CompressionMode(); // not defined
    ~CompressionMode(); // not defined
};

struct TextMode: public comphelper::ConfigurationProperty<TextMode, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/EPS/TextMode"_ustr); return PATH; }
private:
    TextMode(); // not defined
    ~TextMode(); // not defined
};

private:
    EPS(); // not defined
    ~EPS(); // not defined
};

struct GIF: public comphelper::ConfigurationGroup< GIF> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/GIF"_ustr); return PATH; }

struct Interlaced: public comphelper::ConfigurationProperty<Interlaced, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/GIF/Interlaced"_ustr); return PATH; }
private:
    Interlaced(); // not defined
    ~Interlaced(); // not defined
};

struct Translucent: public comphelper::ConfigurationProperty<Translucent, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/GIF/Translucent"_ustr); return PATH; }
private:
    Translucent(); // not defined
    ~Translucent(); // not defined
};

private:
    GIF(); // not defined
    ~GIF(); // not defined
};

struct JPG: public comphelper::ConfigurationGroup< JPG> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/JPG"_ustr); return PATH; }

struct Quality: public comphelper::ConfigurationProperty<Quality, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/JPG/Quality"_ustr); return PATH; }
private:
    Quality(); // not defined
    ~Quality(); // not defined
};

struct ColorMode: public comphelper::ConfigurationProperty<ColorMode, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/JPG/ColorMode"_ustr); return PATH; }
private:
    ColorMode(); // not defined
    ~ColorMode(); // not defined
};

private:
    JPG(); // not defined
    ~JPG(); // not defined
};

struct PBM: public comphelper::ConfigurationGroup< PBM> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PBM"_ustr); return PATH; }

struct FileFormat: public comphelper::ConfigurationProperty<FileFormat, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PBM/FileFormat"_ustr); return PATH; }
private:
    FileFormat(); // not defined
    ~FileFormat(); // not defined
};

private:
    PBM(); // not defined
    ~PBM(); // not defined
};

struct PGM: public comphelper::ConfigurationGroup< PGM> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PGM"_ustr); return PATH; }

struct FileFormat: public comphelper::ConfigurationProperty<FileFormat, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PGM/FileFormat"_ustr); return PATH; }
private:
    FileFormat(); // not defined
    ~FileFormat(); // not defined
};

private:
    PGM(); // not defined
    ~PGM(); // not defined
};

struct PPM: public comphelper::ConfigurationGroup< PPM> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PPM"_ustr); return PATH; }

struct FileFormat: public comphelper::ConfigurationProperty<FileFormat, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PPM/FileFormat"_ustr); return PATH; }
private:
    FileFormat(); // not defined
    ~FileFormat(); // not defined
};

private:
    PPM(); // not defined
    ~PPM(); // not defined
};

struct PNG: public comphelper::ConfigurationGroup< PNG> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PNG"_ustr); return PATH; }

struct Compression: public comphelper::ConfigurationProperty<Compression, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PNG/Compression"_ustr); return PATH; }
private:
    Compression(); // not defined
    ~Compression(); // not defined
};

struct Interlaced: public comphelper::ConfigurationProperty<Interlaced, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PNG/Interlaced"_ustr); return PATH; }
private:
    Interlaced(); // not defined
    ~Interlaced(); // not defined
};

struct Translucent: public comphelper::ConfigurationProperty<Translucent, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/PNG/Translucent"_ustr); return PATH; }
private:
    Translucent(); // not defined
    ~Translucent(); // not defined
};

private:
    PNG(); // not defined
    ~PNG(); // not defined
};

struct SVG: public comphelper::ConfigurationGroup< SVG> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/SVG"_ustr); return PATH; }

struct TinyMode: public comphelper::ConfigurationProperty<TinyMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/SVG/TinyMode"_ustr); return PATH; }
private:
    TinyMode(); // not defined
    ~TinyMode(); // not defined
};

struct EmbedFonts: public comphelper::ConfigurationProperty<EmbedFonts, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/SVG/EmbedFonts"_ustr); return PATH; }
private:
    EmbedFonts(); // not defined
    ~EmbedFonts(); // not defined
};

struct UseNativeTextDecoration: public comphelper::ConfigurationProperty<UseNativeTextDecoration, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/Graphic/Export/SVG/UseNativeTextDecoration"_ustr); return PATH; }
private:
    UseNativeTextDecoration(); // not defined
    ~UseNativeTextDecoration(); // not defined
};

private:
    SVG(); // not defined
    ~SVG(); // not defined
};

private:
    Export(); // not defined
    ~Export(); // not defined
};

private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct HTML: public comphelper::ConfigurationGroup< HTML> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML"_ustr); return PATH; }

struct Import: public comphelper::ConfigurationGroup< Import> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import"_ustr); return PATH; }

struct NumbersEnglishUS: public comphelper::ConfigurationProperty<NumbersEnglishUS, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/NumbersEnglishUS"_ustr); return PATH; }
private:
    NumbersEnglishUS(); // not defined
    ~NumbersEnglishUS(); // not defined
};

struct UnknownTag: public comphelper::ConfigurationProperty<UnknownTag, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/UnknownTag"_ustr); return PATH; }
private:
    UnknownTag(); // not defined
    ~UnknownTag(); // not defined
};

struct FontSetting: public comphelper::ConfigurationProperty<FontSetting, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSetting"_ustr); return PATH; }
private:
    FontSetting(); // not defined
    ~FontSetting(); // not defined
};

struct FontSize: public comphelper::ConfigurationGroup< FontSize> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSize"_ustr); return PATH; }

struct Size_1: public comphelper::ConfigurationProperty<Size_1, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSize/Size_1"_ustr); return PATH; }
private:
    Size_1(); // not defined
    ~Size_1(); // not defined
};

struct Size_2: public comphelper::ConfigurationProperty<Size_2, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSize/Size_2"_ustr); return PATH; }
private:
    Size_2(); // not defined
    ~Size_2(); // not defined
};

struct Size_3: public comphelper::ConfigurationProperty<Size_3, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSize/Size_3"_ustr); return PATH; }
private:
    Size_3(); // not defined
    ~Size_3(); // not defined
};

struct Size_4: public comphelper::ConfigurationProperty<Size_4, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSize/Size_4"_ustr); return PATH; }
private:
    Size_4(); // not defined
    ~Size_4(); // not defined
};

struct Size_5: public comphelper::ConfigurationProperty<Size_5, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSize/Size_5"_ustr); return PATH; }
private:
    Size_5(); // not defined
    ~Size_5(); // not defined
};

struct Size_6: public comphelper::ConfigurationProperty<Size_6, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSize/Size_6"_ustr); return PATH; }
private:
    Size_6(); // not defined
    ~Size_6(); // not defined
};

struct Size_7: public comphelper::ConfigurationProperty<Size_7, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Import/FontSize/Size_7"_ustr); return PATH; }
private:
    Size_7(); // not defined
    ~Size_7(); // not defined
};

private:
    FontSize(); // not defined
    ~FontSize(); // not defined
};

private:
    Import(); // not defined
    ~Import(); // not defined
};

struct Export: public comphelper::ConfigurationGroup< Export> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Export"_ustr); return PATH; }

struct Browser: public comphelper::ConfigurationProperty<Browser, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Export/Browser"_ustr); return PATH; }
private:
    Browser(); // not defined
    ~Browser(); // not defined
};

struct Basic: public comphelper::ConfigurationProperty<Basic, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Export/Basic"_ustr); return PATH; }
private:
    Basic(); // not defined
    ~Basic(); // not defined
};

struct PrintLayout: public comphelper::ConfigurationProperty<PrintLayout, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Export/PrintLayout"_ustr); return PATH; }
private:
    PrintLayout(); // not defined
    ~PrintLayout(); // not defined
};

struct LocalGraphic: public comphelper::ConfigurationProperty<LocalGraphic, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Export/LocalGraphic"_ustr); return PATH; }
private:
    LocalGraphic(); // not defined
    ~LocalGraphic(); // not defined
};

struct Warning: public comphelper::ConfigurationProperty<Warning, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Export/Warning"_ustr); return PATH; }
private:
    Warning(); // not defined
    ~Warning(); // not defined
};

struct Encoding: public comphelper::ConfigurationProperty<Encoding, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/HTML/Export/Encoding"_ustr); return PATH; }
private:
    Encoding(); // not defined
    ~Encoding(); // not defined
};

private:
    Export(); // not defined
    ~Export(); // not defined
};

private:
    HTML(); // not defined
    ~HTML(); // not defined
};

struct PDF: public comphelper::ConfigurationGroup< PDF> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF"_ustr); return PATH; }

struct Export: public comphelper::ConfigurationGroup< Export> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export"_ustr); return PATH; }

struct UseLosslessCompression: public comphelper::ConfigurationProperty<UseLosslessCompression, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/UseLosslessCompression"_ustr); return PATH; }
private:
    UseLosslessCompression(); // not defined
    ~UseLosslessCompression(); // not defined
};

struct Quality: public comphelper::ConfigurationProperty<Quality, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/Quality"_ustr); return PATH; }
private:
    Quality(); // not defined
    ~Quality(); // not defined
};

struct ReduceImageResolution: public comphelper::ConfigurationProperty<ReduceImageResolution, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ReduceImageResolution"_ustr); return PATH; }
private:
    ReduceImageResolution(); // not defined
    ~ReduceImageResolution(); // not defined
};

struct MaxImageResolution: public comphelper::ConfigurationProperty<MaxImageResolution, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/MaxImageResolution"_ustr); return PATH; }
private:
    MaxImageResolution(); // not defined
    ~MaxImageResolution(); // not defined
};

struct UseTaggedPDF: public comphelper::ConfigurationProperty<UseTaggedPDF, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/UseTaggedPDF"_ustr); return PATH; }
private:
    UseTaggedPDF(); // not defined
    ~UseTaggedPDF(); // not defined
};

struct ExportNotes: public comphelper::ConfigurationProperty<ExportNotes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportNotes"_ustr); return PATH; }
private:
    ExportNotes(); // not defined
    ~ExportNotes(); // not defined
};

struct ExportNotesInMargin: public comphelper::ConfigurationProperty<ExportNotesInMargin, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportNotesInMargin"_ustr); return PATH; }
private:
    ExportNotesInMargin(); // not defined
    ~ExportNotesInMargin(); // not defined
};

struct ViewPDFAfterExport: public comphelper::ConfigurationProperty<ViewPDFAfterExport, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ViewPDFAfterExport"_ustr); return PATH; }
private:
    ViewPDFAfterExport(); // not defined
    ~ViewPDFAfterExport(); // not defined
};

struct ExportBookmarks: public comphelper::ConfigurationProperty<ExportBookmarks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportBookmarks"_ustr); return PATH; }
private:
    ExportBookmarks(); // not defined
    ~ExportBookmarks(); // not defined
};

struct ExportPlaceholders: public comphelper::ConfigurationProperty<ExportPlaceholders, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportPlaceholders"_ustr); return PATH; }
private:
    ExportPlaceholders(); // not defined
    ~ExportPlaceholders(); // not defined
};

struct OpenBookmarkLevels: public comphelper::ConfigurationProperty<OpenBookmarkLevels, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/OpenBookmarkLevels"_ustr); return PATH; }
private:
    OpenBookmarkLevels(); // not defined
    ~OpenBookmarkLevels(); // not defined
};

struct ExportNotesPages: public comphelper::ConfigurationProperty<ExportNotesPages, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportNotesPages"_ustr); return PATH; }
private:
    ExportNotesPages(); // not defined
    ~ExportNotesPages(); // not defined
};

struct ExportOnlyNotesPages: public comphelper::ConfigurationProperty<ExportOnlyNotesPages, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportOnlyNotesPages"_ustr); return PATH; }
private:
    ExportOnlyNotesPages(); // not defined
    ~ExportOnlyNotesPages(); // not defined
};

struct UseTransitionEffects: public comphelper::ConfigurationProperty<UseTransitionEffects, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/UseTransitionEffects"_ustr); return PATH; }
private:
    UseTransitionEffects(); // not defined
    ~UseTransitionEffects(); // not defined
};

struct ExportHiddenSlides: public comphelper::ConfigurationProperty<ExportHiddenSlides, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportHiddenSlides"_ustr); return PATH; }
private:
    ExportHiddenSlides(); // not defined
    ~ExportHiddenSlides(); // not defined
};

struct SinglePageSheets: public comphelper::ConfigurationProperty<SinglePageSheets, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/SinglePageSheets"_ustr); return PATH; }
private:
    SinglePageSheets(); // not defined
    ~SinglePageSheets(); // not defined
};

struct ExportFormFields: public comphelper::ConfigurationProperty<ExportFormFields, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportFormFields"_ustr); return PATH; }
private:
    ExportFormFields(); // not defined
    ~ExportFormFields(); // not defined
};

struct FormsType: public comphelper::ConfigurationProperty<FormsType, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/FormsType"_ustr); return PATH; }
private:
    FormsType(); // not defined
    ~FormsType(); // not defined
};

struct AllowDuplicateFieldNames: public comphelper::ConfigurationProperty<AllowDuplicateFieldNames, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/AllowDuplicateFieldNames"_ustr); return PATH; }
private:
    AllowDuplicateFieldNames(); // not defined
    ~AllowDuplicateFieldNames(); // not defined
};

struct IsSkipEmptyPages: public comphelper::ConfigurationProperty<IsSkipEmptyPages, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/IsSkipEmptyPages"_ustr); return PATH; }
private:
    IsSkipEmptyPages(); // not defined
    ~IsSkipEmptyPages(); // not defined
};

struct IsAddStream: public comphelper::ConfigurationProperty<IsAddStream, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/IsAddStream"_ustr); return PATH; }
private:
    IsAddStream(); // not defined
    ~IsAddStream(); // not defined
};

struct HideViewerMenubar: public comphelper::ConfigurationProperty<HideViewerMenubar, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/HideViewerMenubar"_ustr); return PATH; }
private:
    HideViewerMenubar(); // not defined
    ~HideViewerMenubar(); // not defined
};

struct HideViewerToolbar: public comphelper::ConfigurationProperty<HideViewerToolbar, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/HideViewerToolbar"_ustr); return PATH; }
private:
    HideViewerToolbar(); // not defined
    ~HideViewerToolbar(); // not defined
};

struct HideViewerWindowControls: public comphelper::ConfigurationProperty<HideViewerWindowControls, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/HideViewerWindowControls"_ustr); return PATH; }
private:
    HideViewerWindowControls(); // not defined
    ~HideViewerWindowControls(); // not defined
};

struct ResizeWindowToInitialPage: public comphelper::ConfigurationProperty<ResizeWindowToInitialPage, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ResizeWindowToInitialPage"_ustr); return PATH; }
private:
    ResizeWindowToInitialPage(); // not defined
    ~ResizeWindowToInitialPage(); // not defined
};

struct CenterWindow: public comphelper::ConfigurationProperty<CenterWindow, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/CenterWindow"_ustr); return PATH; }
private:
    CenterWindow(); // not defined
    ~CenterWindow(); // not defined
};

struct OpenInFullScreenMode: public comphelper::ConfigurationProperty<OpenInFullScreenMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/OpenInFullScreenMode"_ustr); return PATH; }
private:
    OpenInFullScreenMode(); // not defined
    ~OpenInFullScreenMode(); // not defined
};

struct DisplayPDFDocumentTitle: public comphelper::ConfigurationProperty<DisplayPDFDocumentTitle, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/DisplayPDFDocumentTitle"_ustr); return PATH; }
private:
    DisplayPDFDocumentTitle(); // not defined
    ~DisplayPDFDocumentTitle(); // not defined
};

struct InitialView: public comphelper::ConfigurationProperty<InitialView, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/InitialView"_ustr); return PATH; }
private:
    InitialView(); // not defined
    ~InitialView(); // not defined
};

struct Magnification: public comphelper::ConfigurationProperty<Magnification, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/Magnification"_ustr); return PATH; }
private:
    Magnification(); // not defined
    ~Magnification(); // not defined
};

struct Zoom: public comphelper::ConfigurationProperty<Zoom, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/Zoom"_ustr); return PATH; }
private:
    Zoom(); // not defined
    ~Zoom(); // not defined
};

struct InitialPage: public comphelper::ConfigurationProperty<InitialPage, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/InitialPage"_ustr); return PATH; }
private:
    InitialPage(); // not defined
    ~InitialPage(); // not defined
};

struct PageLayout: public comphelper::ConfigurationProperty<PageLayout, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/PageLayout"_ustr); return PATH; }
private:
    PageLayout(); // not defined
    ~PageLayout(); // not defined
};

struct FirstPageOnLeft: public comphelper::ConfigurationProperty<FirstPageOnLeft, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/FirstPageOnLeft"_ustr); return PATH; }
private:
    FirstPageOnLeft(); // not defined
    ~FirstPageOnLeft(); // not defined
};

struct Printing: public comphelper::ConfigurationProperty<Printing, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/Printing"_ustr); return PATH; }
private:
    Printing(); // not defined
    ~Printing(); // not defined
};

struct Changes: public comphelper::ConfigurationProperty<Changes, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/Changes"_ustr); return PATH; }
private:
    Changes(); // not defined
    ~Changes(); // not defined
};

struct EnableCopyingOfContent: public comphelper::ConfigurationProperty<EnableCopyingOfContent, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/EnableCopyingOfContent"_ustr); return PATH; }
private:
    EnableCopyingOfContent(); // not defined
    ~EnableCopyingOfContent(); // not defined
};

struct EnableTextAccessForAccessibilityTools: public comphelper::ConfigurationProperty<EnableTextAccessForAccessibilityTools, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/EnableTextAccessForAccessibilityTools"_ustr); return PATH; }
private:
    EnableTextAccessForAccessibilityTools(); // not defined
    ~EnableTextAccessForAccessibilityTools(); // not defined
};

struct SelectPdfVersion: public comphelper::ConfigurationProperty<SelectPdfVersion, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/SelectPdfVersion"_ustr); return PATH; }
private:
    SelectPdfVersion(); // not defined
    ~SelectPdfVersion(); // not defined
};

struct PDFUACompliance: public comphelper::ConfigurationProperty<PDFUACompliance, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/PDFUACompliance"_ustr); return PATH; }
private:
    PDFUACompliance(); // not defined
    ~PDFUACompliance(); // not defined
};

struct ExportLinksRelativeFsys: public comphelper::ConfigurationProperty<ExportLinksRelativeFsys, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportLinksRelativeFsys"_ustr); return PATH; }
private:
    ExportLinksRelativeFsys(); // not defined
    ~ExportLinksRelativeFsys(); // not defined
};

struct PDFViewSelection: public comphelper::ConfigurationProperty<PDFViewSelection, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/PDFViewSelection"_ustr); return PATH; }
private:
    PDFViewSelection(); // not defined
    ~PDFViewSelection(); // not defined
};

struct ConvertOOoTargetToPDFTarget: public comphelper::ConfigurationProperty<ConvertOOoTargetToPDFTarget, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ConvertOOoTargetToPDFTarget"_ustr); return PATH; }
private:
    ConvertOOoTargetToPDFTarget(); // not defined
    ~ConvertOOoTargetToPDFTarget(); // not defined
};

struct ExportBookmarksToPDFDestination: public comphelper::ConfigurationProperty<ExportBookmarksToPDFDestination, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Filter/PDF/Export/ExportBookmarksToPDFDestination"_ustr); return PATH; }
private:
    ExportBookmarksToPDFDestination(); // not defined
    ~ExportBookmarksToPDFDestination(); // not defined
};

private:
    Export(); // not defined
    ~Export(); // not defined
};

private:
    PDF(); // not defined
    ~PDF(); // not defined
};

private:
    Filter(); // not defined
    ~Filter(); // not defined
};

struct Appearance: public comphelper::ConfigurationGroup< Appearance> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Appearance"_ustr); return PATH; }

struct LibreOfficeTheme: public comphelper::ConfigurationProperty<LibreOfficeTheme, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Appearance/LibreOfficeTheme"_ustr); return PATH; }
private:
    LibreOfficeTheme(); // not defined
    ~LibreOfficeTheme(); // not defined
};

struct ApplicationAppearance: public comphelper::ConfigurationProperty<ApplicationAppearance, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Appearance/ApplicationAppearance"_ustr); return PATH; }
private:
    ApplicationAppearance(); // not defined
    ~ApplicationAppearance(); // not defined
};

private:
    Appearance(); // not defined
    ~Appearance(); // not defined
};

struct Misc: public comphelper::ConfigurationGroup< Misc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc"_ustr); return PATH; }

struct MaxOpenDocuments: public comphelper::ConfigurationProperty<MaxOpenDocuments, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/MaxOpenDocuments"_ustr); return PATH; }
private:
    MaxOpenDocuments(); // not defined
    ~MaxOpenDocuments(); // not defined
};

struct FontsUseWinMetrics: public comphelper::ConfigurationProperty<FontsUseWinMetrics, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FontsUseWinMetrics"_ustr); return PATH; }
private:
    FontsUseWinMetrics(); // not defined
    ~FontsUseWinMetrics(); // not defined
};

struct FontsDontUseUnderlineMetrics: public comphelper::ConfigurationProperty<FontsDontUseUnderlineMetrics, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FontsDontUseUnderlineMetrics"_ustr); return PATH; }
private:
    FontsDontUseUnderlineMetrics(); // not defined
    ~FontsDontUseUnderlineMetrics(); // not defined
};

struct PluginsEnabled: public comphelper::ConfigurationProperty<PluginsEnabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/PluginsEnabled"_ustr); return PATH; }
private:
    PluginsEnabled(); // not defined
    ~PluginsEnabled(); // not defined
};

struct UseSystemFileDialog: public comphelper::ConfigurationProperty<UseSystemFileDialog, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/UseSystemFileDialog"_ustr); return PATH; }
private:
    UseSystemFileDialog(); // not defined
    ~UseSystemFileDialog(); // not defined
};

struct UseDocumentSystemFileLocking: public comphelper::ConfigurationProperty<UseDocumentSystemFileLocking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/UseDocumentSystemFileLocking"_ustr); return PATH; }
private:
    UseDocumentSystemFileLocking(); // not defined
    ~UseDocumentSystemFileLocking(); // not defined
};

struct UseWebDAVFileLocking: public comphelper::ConfigurationProperty<UseWebDAVFileLocking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/UseWebDAVFileLocking"_ustr); return PATH; }
private:
    UseWebDAVFileLocking(); // not defined
    ~UseWebDAVFileLocking(); // not defined
};

struct TempFileNextToLocalFile: public comphelper::ConfigurationProperty<TempFileNextToLocalFile, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/TempFileNextToLocalFile"_ustr); return PATH; }
private:
    TempFileNextToLocalFile(); // not defined
    ~TempFileNextToLocalFile(); // not defined
};

struct UseDocumentOOoLockFile: public comphelper::ConfigurationProperty<UseDocumentOOoLockFile, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/UseDocumentOOoLockFile"_ustr); return PATH; }
private:
    UseDocumentOOoLockFile(); // not defined
    ~UseDocumentOOoLockFile(); // not defined
};

struct UseLocking: public comphelper::ConfigurationProperty<UseLocking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/UseLocking"_ustr); return PATH; }
private:
    UseLocking(); // not defined
    ~UseLocking(); // not defined
};

struct AllowOverrideLocking: public comphelper::ConfigurationProperty<AllowOverrideLocking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/AllowOverrideLocking"_ustr); return PATH; }
private:
    AllowOverrideLocking(); // not defined
    ~AllowOverrideLocking(); // not defined
};

struct ShowLinkWarningDialog: public comphelper::ConfigurationProperty<ShowLinkWarningDialog, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/ShowLinkWarningDialog"_ustr); return PATH; }
private:
    ShowLinkWarningDialog(); // not defined
    ~ShowLinkWarningDialog(); // not defined
};

struct UseSystemPrintDialog: public comphelper::ConfigurationProperty<UseSystemPrintDialog, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/UseSystemPrintDialog"_ustr); return PATH; }
private:
    UseSystemPrintDialog(); // not defined
    ~UseSystemPrintDialog(); // not defined
};

struct DisableUICustomization: public comphelper::ConfigurationProperty<DisableUICustomization, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/DisableUICustomization"_ustr); return PATH; }
private:
    DisableUICustomization(); // not defined
    ~DisableUICustomization(); // not defined
};

struct WriteLayerStateAsConfigItem: public comphelper::ConfigurationProperty<WriteLayerStateAsConfigItem, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/WriteLayerStateAsConfigItem"_ustr); return PATH; }
private:
    WriteLayerStateAsConfigItem(); // not defined
    ~WriteLayerStateAsConfigItem(); // not defined
};

struct ExperimentalMode: public comphelper::ConfigurationProperty<ExperimentalMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/ExperimentalMode"_ustr); return PATH; }
private:
    ExperimentalMode(); // not defined
    ~ExperimentalMode(); // not defined
};

struct ScreenshotMode: public comphelper::ConfigurationProperty<ScreenshotMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/ScreenshotMode"_ustr); return PATH; }
private:
    ScreenshotMode(); // not defined
    ~ScreenshotMode(); // not defined
};

struct CrashReport: public comphelper::ConfigurationProperty<CrashReport, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/CrashReport"_ustr); return PATH; }
private:
    CrashReport(); // not defined
    ~CrashReport(); // not defined
};

struct ShowTipOfTheDay: public comphelper::ConfigurationProperty<ShowTipOfTheDay, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/ShowTipOfTheDay"_ustr); return PATH; }
private:
    ShowTipOfTheDay(); // not defined
    ~ShowTipOfTheDay(); // not defined
};

struct LastTipOfTheDayShown: public comphelper::ConfigurationProperty<LastTipOfTheDayShown, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/LastTipOfTheDayShown"_ustr); return PATH; }
private:
    LastTipOfTheDayShown(); // not defined
    ~LastTipOfTheDayShown(); // not defined
};

struct LastTipOfTheDayID: public comphelper::ConfigurationProperty<LastTipOfTheDayID, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/LastTipOfTheDayID"_ustr); return PATH; }
private:
    LastTipOfTheDayID(); // not defined
    ~LastTipOfTheDayID(); // not defined
};

struct QuerySetInsMode: public comphelper::ConfigurationProperty<QuerySetInsMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/QuerySetInsMode"_ustr); return PATH; }
private:
    QuerySetInsMode(); // not defined
    ~QuerySetInsMode(); // not defined
};

struct PerformFileExtCheck: public comphelper::ConfigurationProperty<PerformFileExtCheck, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/PerformFileExtCheck"_ustr); return PATH; }
private:
    PerformFileExtCheck(); // not defined
    ~PerformFileExtCheck(); // not defined
};

struct ShowDonation: public comphelper::ConfigurationProperty<ShowDonation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/ShowDonation"_ustr); return PATH; }
private:
    ShowDonation(); // not defined
    ~ShowDonation(); // not defined
};

struct UseOpenCL: public comphelper::ConfigurationProperty<UseOpenCL, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/UseOpenCL"_ustr); return PATH; }
private:
    UseOpenCL(); // not defined
    ~UseOpenCL(); // not defined
};

struct OpenCLDenyList: public comphelper::ConfigurationProperty<OpenCLDenyList, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/OpenCLDenyList"_ustr); return PATH; }
private:
    OpenCLDenyList(); // not defined
    ~OpenCLDenyList(); // not defined
};

struct OpenCLAllowList: public comphelper::ConfigurationProperty<OpenCLAllowList, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/OpenCLAllowList"_ustr); return PATH; }
private:
    OpenCLAllowList(); // not defined
    ~OpenCLAllowList(); // not defined
};

struct SelectedOpenCLDeviceIdentifier: public comphelper::ConfigurationProperty<SelectedOpenCLDeviceIdentifier, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/SelectedOpenCLDeviceIdentifier"_ustr); return PATH; }
private:
    SelectedOpenCLDeviceIdentifier(); // not defined
    ~SelectedOpenCLDeviceIdentifier(); // not defined
};

struct MacroRecorderMode: public comphelper::ConfigurationProperty<MacroRecorderMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/MacroRecorderMode"_ustr); return PATH; }
private:
    MacroRecorderMode(); // not defined
    ~MacroRecorderMode(); // not defined
};

struct SymbolSet: public comphelper::ConfigurationProperty<SymbolSet, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/SymbolSet"_ustr); return PATH; }
private:
    SymbolSet(); // not defined
    ~SymbolSet(); // not defined
};

struct SidebarIconSize: public comphelper::ConfigurationProperty<SidebarIconSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/SidebarIconSize"_ustr); return PATH; }
private:
    SidebarIconSize(); // not defined
    ~SidebarIconSize(); // not defined
};

struct NotebookbarIconSize: public comphelper::ConfigurationProperty<NotebookbarIconSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/NotebookbarIconSize"_ustr); return PATH; }
private:
    NotebookbarIconSize(); // not defined
    ~NotebookbarIconSize(); // not defined
};

struct SymbolStyle: public comphelper::ConfigurationProperty<SymbolStyle, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/SymbolStyle"_ustr); return PATH; }
private:
    SymbolStyle(); // not defined
    ~SymbolStyle(); // not defined
};

struct FormControlPilotsEnabled: public comphelper::ConfigurationProperty<FormControlPilotsEnabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FormControlPilotsEnabled"_ustr); return PATH; }
private:
    FormControlPilotsEnabled(); // not defined
    ~FormControlPilotsEnabled(); // not defined
};

struct FirstRun: public comphelper::ConfigurationProperty<FirstRun, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FirstRun"_ustr); return PATH; }
private:
    FirstRun(); // not defined
    ~FirstRun(); // not defined
};

struct PreloadJVM: public comphelper::ConfigurationProperty<PreloadJVM, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/PreloadJVM"_ustr); return PATH; }
private:
    PreloadJVM(); // not defined
    ~PreloadJVM(); // not defined
};

struct FilePickerPlacesUrls: public comphelper::ConfigurationProperty<FilePickerPlacesUrls, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FilePickerPlacesUrls"_ustr); return PATH; }
private:
    FilePickerPlacesUrls(); // not defined
    ~FilePickerPlacesUrls(); // not defined
};

struct FilePickerPlacesNames: public comphelper::ConfigurationProperty<FilePickerPlacesNames, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FilePickerPlacesNames"_ustr); return PATH; }
private:
    FilePickerPlacesNames(); // not defined
    ~FilePickerPlacesNames(); // not defined
};

struct FilePickerLastService: public comphelper::ConfigurationProperty<FilePickerLastService, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FilePickerLastService"_ustr); return PATH; }
private:
    FilePickerLastService(); // not defined
    ~FilePickerLastService(); // not defined
};

struct FilePickerLastDirectory: public comphelper::ConfigurationSet< FilePickerLastDirectory> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FilePickerLastDirectory"_ustr); return PATH; }
private:
    FilePickerLastDirectory(); // not defined
    ~FilePickerLastDirectory(); // not defined
};

struct CmisServersUrls: public comphelper::ConfigurationProperty<CmisServersUrls, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/CmisServersUrls"_ustr); return PATH; }
private:
    CmisServersUrls(); // not defined
    ~CmisServersUrls(); // not defined
};

struct CmisServersNames: public comphelper::ConfigurationProperty<CmisServersNames, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/CmisServersNames"_ustr); return PATH; }
private:
    CmisServersNames(); // not defined
    ~CmisServersNames(); // not defined
};

struct FindReplaceRememberedSearches: public comphelper::ConfigurationProperty<FindReplaceRememberedSearches, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/FindReplaceRememberedSearches"_ustr); return PATH; }
private:
    FindReplaceRememberedSearches(); // not defined
    ~FindReplaceRememberedSearches(); // not defined
};

struct AllowEditReadonlyDocs: public comphelper::ConfigurationProperty<AllowEditReadonlyDocs, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/AllowEditReadonlyDocs"_ustr); return PATH; }
private:
    AllowEditReadonlyDocs(); // not defined
    ~AllowEditReadonlyDocs(); // not defined
};

struct OfferSafeMode: public comphelper::ConfigurationProperty<OfferSafeMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Misc/OfferSafeMode"_ustr); return PATH; }
private:
    OfferSafeMode(); // not defined
    ~OfferSafeMode(); // not defined
};

private:
    Misc(); // not defined
    ~Misc(); // not defined
};

struct Forms: public comphelper::ConfigurationGroup< Forms> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Forms"_ustr); return PATH; }

struct PropertyBrowser: public comphelper::ConfigurationGroup< PropertyBrowser> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Forms/PropertyBrowser"_ustr); return PATH; }

struct DirectHelp: public comphelper::ConfigurationProperty<DirectHelp, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Forms/PropertyBrowser/DirectHelp"_ustr); return PATH; }
private:
    DirectHelp(); // not defined
    ~DirectHelp(); // not defined
};

private:
    PropertyBrowser(); // not defined
    ~PropertyBrowser(); // not defined
};

private:
    Forms(); // not defined
    ~Forms(); // not defined
};

struct AsianLayout: public comphelper::ConfigurationGroup< AsianLayout> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AsianLayout"_ustr); return PATH; }

struct IsKerningWesternTextOnly: public comphelper::ConfigurationProperty<IsKerningWesternTextOnly, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AsianLayout/IsKerningWesternTextOnly"_ustr); return PATH; }
private:
    IsKerningWesternTextOnly(); // not defined
    ~IsKerningWesternTextOnly(); // not defined
};

struct CompressCharacterDistance: public comphelper::ConfigurationProperty<CompressCharacterDistance, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AsianLayout/CompressCharacterDistance"_ustr); return PATH; }
private:
    CompressCharacterDistance(); // not defined
    ~CompressCharacterDistance(); // not defined
};

struct StartEndCharacters: public comphelper::ConfigurationSet< StartEndCharacters> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AsianLayout/StartEndCharacters"_ustr); return PATH; }
private:
    StartEndCharacters(); // not defined
    ~StartEndCharacters(); // not defined
};

private:
    AsianLayout(); // not defined
    ~AsianLayout(); // not defined
};

struct SearchOptions: public comphelper::ConfigurationGroup< SearchOptions> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions"_ustr); return PATH; }

struct IsWholeWordsOnly: public comphelper::ConfigurationProperty<IsWholeWordsOnly, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsWholeWordsOnly"_ustr); return PATH; }
private:
    IsWholeWordsOnly(); // not defined
    ~IsWholeWordsOnly(); // not defined
};

struct IsBackwards: public comphelper::ConfigurationProperty<IsBackwards, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsBackwards"_ustr); return PATH; }
private:
    IsBackwards(); // not defined
    ~IsBackwards(); // not defined
};

struct IsUseWildcard: public comphelper::ConfigurationProperty<IsUseWildcard, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsUseWildcard"_ustr); return PATH; }
private:
    IsUseWildcard(); // not defined
    ~IsUseWildcard(); // not defined
};

struct IsUseRegularExpression: public comphelper::ConfigurationProperty<IsUseRegularExpression, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsUseRegularExpression"_ustr); return PATH; }
private:
    IsUseRegularExpression(); // not defined
    ~IsUseRegularExpression(); // not defined
};

struct IsSearchForStyles: public comphelper::ConfigurationProperty<IsSearchForStyles, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsSearchForStyles"_ustr); return PATH; }
private:
    IsSearchForStyles(); // not defined
    ~IsSearchForStyles(); // not defined
};

struct IsSimilaritySearch: public comphelper::ConfigurationProperty<IsSimilaritySearch, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsSimilaritySearch"_ustr); return PATH; }
private:
    IsSimilaritySearch(); // not defined
    ~IsSimilaritySearch(); // not defined
};

struct IsMatchCase: public comphelper::ConfigurationProperty<IsMatchCase, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsMatchCase"_ustr); return PATH; }
private:
    IsMatchCase(); // not defined
    ~IsMatchCase(); // not defined
};

struct IsIgnoreDiacritics_CTL: public comphelper::ConfigurationProperty<IsIgnoreDiacritics_CTL, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsIgnoreDiacritics_CTL"_ustr); return PATH; }
private:
    IsIgnoreDiacritics_CTL(); // not defined
    ~IsIgnoreDiacritics_CTL(); // not defined
};

struct IsIgnoreKashida_CTL: public comphelper::ConfigurationProperty<IsIgnoreKashida_CTL, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsIgnoreKashida_CTL"_ustr); return PATH; }
private:
    IsIgnoreKashida_CTL(); // not defined
    ~IsIgnoreKashida_CTL(); // not defined
};

struct IsUseAsianOptions: public comphelper::ConfigurationProperty<IsUseAsianOptions, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsUseAsianOptions"_ustr); return PATH; }
private:
    IsUseAsianOptions(); // not defined
    ~IsUseAsianOptions(); // not defined
};

struct ComponentSearchGroupLabel: public comphelper::ConfigurationLocalizedProperty<ComponentSearchGroupLabel, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/ComponentSearchGroupLabel"_ustr); return PATH; }
private:
    ComponentSearchGroupLabel(); // not defined
    ~ComponentSearchGroupLabel(); // not defined
};

struct ComponentSearchCommandLabel1: public comphelper::ConfigurationLocalizedProperty<ComponentSearchCommandLabel1, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/ComponentSearchCommandLabel1"_ustr); return PATH; }
private:
    ComponentSearchCommandLabel1(); // not defined
    ~ComponentSearchCommandLabel1(); // not defined
};

struct ComponentSearchCommandLabel2: public comphelper::ConfigurationLocalizedProperty<ComponentSearchCommandLabel2, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/ComponentSearchCommandLabel2"_ustr); return PATH; }
private:
    ComponentSearchCommandLabel2(); // not defined
    ~ComponentSearchCommandLabel2(); // not defined
};

struct IsNotes: public comphelper::ConfigurationProperty<IsNotes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsNotes"_ustr); return PATH; }
private:
    IsNotes(); // not defined
    ~IsNotes(); // not defined
};

struct IsSearchFormatted: public comphelper::ConfigurationProperty<IsSearchFormatted, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/IsSearchFormatted"_ustr); return PATH; }
private:
    IsSearchFormatted(); // not defined
    ~IsSearchFormatted(); // not defined
};

struct Japanese: public comphelper::ConfigurationGroup< Japanese> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese"_ustr); return PATH; }

struct IsMatchFullHalfWidthForms: public comphelper::ConfigurationProperty<IsMatchFullHalfWidthForms, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatchFullHalfWidthForms"_ustr); return PATH; }
private:
    IsMatchFullHalfWidthForms(); // not defined
    ~IsMatchFullHalfWidthForms(); // not defined
};

struct IsMatchHiraganaKatakana: public comphelper::ConfigurationProperty<IsMatchHiraganaKatakana, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatchHiraganaKatakana"_ustr); return PATH; }
private:
    IsMatchHiraganaKatakana(); // not defined
    ~IsMatchHiraganaKatakana(); // not defined
};

struct IsMatchContractions: public comphelper::ConfigurationProperty<IsMatchContractions, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatchContractions"_ustr); return PATH; }
private:
    IsMatchContractions(); // not defined
    ~IsMatchContractions(); // not defined
};

struct IsMatchMinusDashCho_on: public comphelper::ConfigurationProperty<IsMatchMinusDashCho_on, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatchMinusDashCho-on"_ustr); return PATH; }
private:
    IsMatchMinusDashCho_on(); // not defined
    ~IsMatchMinusDashCho_on(); // not defined
};

struct IsMatchRepeatCharMarks: public comphelper::ConfigurationProperty<IsMatchRepeatCharMarks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatchRepeatCharMarks"_ustr); return PATH; }
private:
    IsMatchRepeatCharMarks(); // not defined
    ~IsMatchRepeatCharMarks(); // not defined
};

struct IsMatchVariantFormKanji: public comphelper::ConfigurationProperty<IsMatchVariantFormKanji, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatchVariantFormKanji"_ustr); return PATH; }
private:
    IsMatchVariantFormKanji(); // not defined
    ~IsMatchVariantFormKanji(); // not defined
};

struct IsMatchOldKanaForms: public comphelper::ConfigurationProperty<IsMatchOldKanaForms, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatchOldKanaForms"_ustr); return PATH; }
private:
    IsMatchOldKanaForms(); // not defined
    ~IsMatchOldKanaForms(); // not defined
};

struct IsMatch_DiZi_DuZu: public comphelper::ConfigurationProperty<IsMatch_DiZi_DuZu, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatch_DiZi_DuZu"_ustr); return PATH; }
private:
    IsMatch_DiZi_DuZu(); // not defined
    ~IsMatch_DiZi_DuZu(); // not defined
};

struct IsMatch_BaVa_HaFa: public comphelper::ConfigurationProperty<IsMatch_BaVa_HaFa, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatch_BaVa_HaFa"_ustr); return PATH; }
private:
    IsMatch_BaVa_HaFa(); // not defined
    ~IsMatch_BaVa_HaFa(); // not defined
};

struct IsMatch_TsiThiChi_DhiZi: public comphelper::ConfigurationProperty<IsMatch_TsiThiChi_DhiZi, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatch_TsiThiChi_DhiZi"_ustr); return PATH; }
private:
    IsMatch_TsiThiChi_DhiZi(); // not defined
    ~IsMatch_TsiThiChi_DhiZi(); // not defined
};

struct IsMatch_HyuIyu_ByuVyu: public comphelper::ConfigurationProperty<IsMatch_HyuIyu_ByuVyu, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatch_HyuIyu_ByuVyu"_ustr); return PATH; }
private:
    IsMatch_HyuIyu_ByuVyu(); // not defined
    ~IsMatch_HyuIyu_ByuVyu(); // not defined
};

struct IsMatch_SeShe_ZeJe: public comphelper::ConfigurationProperty<IsMatch_SeShe_ZeJe, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatch_SeShe_ZeJe"_ustr); return PATH; }
private:
    IsMatch_SeShe_ZeJe(); // not defined
    ~IsMatch_SeShe_ZeJe(); // not defined
};

struct IsMatch_IaIya: public comphelper::ConfigurationProperty<IsMatch_IaIya, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatch_IaIya"_ustr); return PATH; }
private:
    IsMatch_IaIya(); // not defined
    ~IsMatch_IaIya(); // not defined
};

struct IsMatch_KiKu: public comphelper::ConfigurationProperty<IsMatch_KiKu, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsMatch_KiKu"_ustr); return PATH; }
private:
    IsMatch_KiKu(); // not defined
    ~IsMatch_KiKu(); // not defined
};

struct IsIgnorePunctuation: public comphelper::ConfigurationProperty<IsIgnorePunctuation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsIgnorePunctuation"_ustr); return PATH; }
private:
    IsIgnorePunctuation(); // not defined
    ~IsIgnorePunctuation(); // not defined
};

struct IsIgnoreWhitespace: public comphelper::ConfigurationProperty<IsIgnoreWhitespace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsIgnoreWhitespace"_ustr); return PATH; }
private:
    IsIgnoreWhitespace(); // not defined
    ~IsIgnoreWhitespace(); // not defined
};

struct IsIgnoreProlongedSoundMark: public comphelper::ConfigurationProperty<IsIgnoreProlongedSoundMark, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsIgnoreProlongedSoundMark"_ustr); return PATH; }
private:
    IsIgnoreProlongedSoundMark(); // not defined
    ~IsIgnoreProlongedSoundMark(); // not defined
};

struct IsIgnoreMiddleDot: public comphelper::ConfigurationProperty<IsIgnoreMiddleDot, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SearchOptions/Japanese/IsIgnoreMiddleDot"_ustr); return PATH; }
private:
    IsIgnoreMiddleDot(); // not defined
    ~IsIgnoreMiddleDot(); // not defined
};

private:
    Japanese(); // not defined
    ~Japanese(); // not defined
};

private:
    SearchOptions(); // not defined
    ~SearchOptions(); // not defined
};

struct Accessibility: public comphelper::ConfigurationGroup< Accessibility> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility"_ustr); return PATH; }

struct HighContrast: public comphelper::ConfigurationProperty<HighContrast, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/HighContrast"_ustr); return PATH; }
private:
    HighContrast(); // not defined
    ~HighContrast(); // not defined
};

struct IsForPagePreviews: public comphelper::ConfigurationProperty<IsForPagePreviews, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/IsForPagePreviews"_ustr); return PATH; }
private:
    IsForPagePreviews(); // not defined
    ~IsForPagePreviews(); // not defined
};

struct IsHelpTipsDisappear: public comphelper::ConfigurationProperty<IsHelpTipsDisappear, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/IsHelpTipsDisappear"_ustr); return PATH; }
private:
    IsHelpTipsDisappear(); // not defined
    ~IsHelpTipsDisappear(); // not defined
};

struct HelpTipSeconds: public comphelper::ConfigurationProperty<HelpTipSeconds, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/HelpTipSeconds"_ustr); return PATH; }
private:
    HelpTipSeconds(); // not defined
    ~HelpTipSeconds(); // not defined
};

struct AllowAnimatedGraphic: public comphelper::ConfigurationProperty<AllowAnimatedGraphic, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/AllowAnimatedGraphic"_ustr); return PATH; }
private:
    AllowAnimatedGraphic(); // not defined
    ~AllowAnimatedGraphic(); // not defined
};

struct AllowAnimatedText: public comphelper::ConfigurationProperty<AllowAnimatedText, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/AllowAnimatedText"_ustr); return PATH; }
private:
    AllowAnimatedText(); // not defined
    ~AllowAnimatedText(); // not defined
};

struct AllowAnimatedOthers: public comphelper::ConfigurationProperty<AllowAnimatedOthers, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/AllowAnimatedOthers"_ustr); return PATH; }
private:
    AllowAnimatedOthers(); // not defined
    ~AllowAnimatedOthers(); // not defined
};

struct IsAutomaticFontColor: public comphelper::ConfigurationProperty<IsAutomaticFontColor, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/IsAutomaticFontColor"_ustr); return PATH; }
private:
    IsAutomaticFontColor(); // not defined
    ~IsAutomaticFontColor(); // not defined
};

struct IsSelectionInReadonly: public comphelper::ConfigurationProperty<IsSelectionInReadonly, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/IsSelectionInReadonly"_ustr); return PATH; }
private:
    IsSelectionInReadonly(); // not defined
    ~IsSelectionInReadonly(); // not defined
};

struct EdgeBlending: public comphelper::ConfigurationProperty<EdgeBlending, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/EdgeBlending"_ustr); return PATH; }
private:
    EdgeBlending(); // not defined
    ~EdgeBlending(); // not defined
};

struct ListBoxMaximumLineCount: public comphelper::ConfigurationProperty<ListBoxMaximumLineCount, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/ListBoxMaximumLineCount"_ustr); return PATH; }
private:
    ListBoxMaximumLineCount(); // not defined
    ~ListBoxMaximumLineCount(); // not defined
};

struct ColorValueSetColumnCount: public comphelper::ConfigurationProperty<ColorValueSetColumnCount, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/ColorValueSetColumnCount"_ustr); return PATH; }
private:
    ColorValueSetColumnCount(); // not defined
    ~ColorValueSetColumnCount(); // not defined
};

struct PreviewUsesCheckeredBackground: public comphelper::ConfigurationProperty<PreviewUsesCheckeredBackground, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/PreviewUsesCheckeredBackground"_ustr); return PATH; }
private:
    PreviewUsesCheckeredBackground(); // not defined
    ~PreviewUsesCheckeredBackground(); // not defined
};

struct OnlineAccessibilityCheck: public comphelper::ConfigurationProperty<OnlineAccessibilityCheck, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Accessibility/OnlineAccessibilityCheck"_ustr); return PATH; }
private:
    OnlineAccessibilityCheck(); // not defined
    ~OnlineAccessibilityCheck(); // not defined
};

private:
    Accessibility(); // not defined
    ~Accessibility(); // not defined
};

struct AccessibilityIssues: public comphelper::ConfigurationGroup< AccessibilityIssues> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues"_ustr); return PATH; }

struct DocumentTitle: public comphelper::ConfigurationProperty<DocumentTitle, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/DocumentTitle"_ustr); return PATH; }
private:
    DocumentTitle(); // not defined
    ~DocumentTitle(); // not defined
};

struct DocumentLanguage: public comphelper::ConfigurationProperty<DocumentLanguage, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/DocumentLanguage"_ustr); return PATH; }
private:
    DocumentLanguage(); // not defined
    ~DocumentLanguage(); // not defined
};

struct DocumentBackground: public comphelper::ConfigurationProperty<DocumentBackground, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/DocumentBackground"_ustr); return PATH; }
private:
    DocumentBackground(); // not defined
    ~DocumentBackground(); // not defined
};

struct DocumentStyleLanguage: public comphelper::ConfigurationProperty<DocumentStyleLanguage, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/DocumentStyleLanguage"_ustr); return PATH; }
private:
    DocumentStyleLanguage(); // not defined
    ~DocumentStyleLanguage(); // not defined
};

struct LinkedGraphic: public comphelper::ConfigurationProperty<LinkedGraphic, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/LinkedGraphic"_ustr); return PATH; }
private:
    LinkedGraphic(); // not defined
    ~LinkedGraphic(); // not defined
};

struct NoAltOleObj: public comphelper::ConfigurationProperty<NoAltOleObj, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/NoAltOleObj"_ustr); return PATH; }
private:
    NoAltOleObj(); // not defined
    ~NoAltOleObj(); // not defined
};

struct NoAltGraphicObj: public comphelper::ConfigurationProperty<NoAltGraphicObj, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/NoAltGraphicObj"_ustr); return PATH; }
private:
    NoAltGraphicObj(); // not defined
    ~NoAltGraphicObj(); // not defined
};

struct NoAltShapeObj: public comphelper::ConfigurationProperty<NoAltShapeObj, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/NoAltShapeObj"_ustr); return PATH; }
private:
    NoAltShapeObj(); // not defined
    ~NoAltShapeObj(); // not defined
};

struct TableMergeSplit: public comphelper::ConfigurationProperty<TableMergeSplit, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/TableMergeSplit"_ustr); return PATH; }
private:
    TableMergeSplit(); // not defined
    ~TableMergeSplit(); // not defined
};

struct TextNewLines: public comphelper::ConfigurationProperty<TextNewLines, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/TextNewLines"_ustr); return PATH; }
private:
    TextNewLines(); // not defined
    ~TextNewLines(); // not defined
};

struct TextSpaces: public comphelper::ConfigurationProperty<TextSpaces, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/TextSpaces"_ustr); return PATH; }
private:
    TextSpaces(); // not defined
    ~TextSpaces(); // not defined
};

struct TextTabs: public comphelper::ConfigurationProperty<TextTabs, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/TextTabs"_ustr); return PATH; }
private:
    TextTabs(); // not defined
    ~TextTabs(); // not defined
};

struct TextEmptyNums: public comphelper::ConfigurationProperty<TextEmptyNums, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/TextEmptyNums"_ustr); return PATH; }
private:
    TextEmptyNums(); // not defined
    ~TextEmptyNums(); // not defined
};

struct DirectFormattings: public comphelper::ConfigurationProperty<DirectFormattings, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/DirectFormattings"_ustr); return PATH; }
private:
    DirectFormattings(); // not defined
    ~DirectFormattings(); // not defined
};

struct TableFormattings: public comphelper::ConfigurationProperty<TableFormattings, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/TableFormattings"_ustr); return PATH; }
private:
    TableFormattings(); // not defined
    ~TableFormattings(); // not defined
};

struct HyperlinkText: public comphelper::ConfigurationProperty<HyperlinkText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/HyperlinkText"_ustr); return PATH; }
private:
    HyperlinkText(); // not defined
    ~HyperlinkText(); // not defined
};

struct HyperlinkShort: public comphelper::ConfigurationProperty<HyperlinkShort, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/HyperlinkShort"_ustr); return PATH; }
private:
    HyperlinkShort(); // not defined
    ~HyperlinkShort(); // not defined
};

struct HyperlinkNoName: public comphelper::ConfigurationProperty<HyperlinkNoName, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/HyperlinkNoName"_ustr); return PATH; }
private:
    HyperlinkNoName(); // not defined
    ~HyperlinkNoName(); // not defined
};

struct FakeFootnotes: public comphelper::ConfigurationProperty<FakeFootnotes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/FakeFootnotes"_ustr); return PATH; }
private:
    FakeFootnotes(); // not defined
    ~FakeFootnotes(); // not defined
};

struct FakeCaptions: public comphelper::ConfigurationProperty<FakeCaptions, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/FakeCaptions"_ustr); return PATH; }
private:
    FakeCaptions(); // not defined
    ~FakeCaptions(); // not defined
};

struct ManualNumbering: public comphelper::ConfigurationProperty<ManualNumbering, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/ManualNumbering"_ustr); return PATH; }
private:
    ManualNumbering(); // not defined
    ~ManualNumbering(); // not defined
};

struct TextContrast: public comphelper::ConfigurationProperty<TextContrast, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/TextContrast"_ustr); return PATH; }
private:
    TextContrast(); // not defined
    ~TextContrast(); // not defined
};

struct TextBlinking: public comphelper::ConfigurationProperty<TextBlinking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/TextBlinking"_ustr); return PATH; }
private:
    TextBlinking(); // not defined
    ~TextBlinking(); // not defined
};

struct HeadingNotInOrder: public comphelper::ConfigurationProperty<HeadingNotInOrder, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/HeadingNotInOrder"_ustr); return PATH; }
private:
    HeadingNotInOrder(); // not defined
    ~HeadingNotInOrder(); // not defined
};

struct NonInteractiveForms: public comphelper::ConfigurationProperty<NonInteractiveForms, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/NonInteractiveForms"_ustr); return PATH; }
private:
    NonInteractiveForms(); // not defined
    ~NonInteractiveForms(); // not defined
};

struct Floatingtext: public comphelper::ConfigurationProperty<Floatingtext, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/Floatingtext"_ustr); return PATH; }
private:
    Floatingtext(); // not defined
    ~Floatingtext(); // not defined
};

struct HeadingTable: public comphelper::ConfigurationProperty<HeadingTable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/HeadingTable"_ustr); return PATH; }
private:
    HeadingTable(); // not defined
    ~HeadingTable(); // not defined
};

struct HeadingStart: public comphelper::ConfigurationProperty<HeadingStart, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/HeadingStart"_ustr); return PATH; }
private:
    HeadingStart(); // not defined
    ~HeadingStart(); // not defined
};

struct HeadingOrder: public comphelper::ConfigurationProperty<HeadingOrder, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/HeadingOrder"_ustr); return PATH; }
private:
    HeadingOrder(); // not defined
    ~HeadingOrder(); // not defined
};

struct ContentControl: public comphelper::ConfigurationProperty<ContentControl, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/ContentControl"_ustr); return PATH; }
private:
    ContentControl(); // not defined
    ~ContentControl(); // not defined
};

struct AvoidFootnotes: public comphelper::ConfigurationProperty<AvoidFootnotes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/AvoidFootnotes"_ustr); return PATH; }
private:
    AvoidFootnotes(); // not defined
    ~AvoidFootnotes(); // not defined
};

struct AvoidEndnotes: public comphelper::ConfigurationProperty<AvoidEndnotes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/AvoidEndnotes"_ustr); return PATH; }
private:
    AvoidEndnotes(); // not defined
    ~AvoidEndnotes(); // not defined
};

struct FontWorks: public comphelper::ConfigurationProperty<FontWorks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/AccessibilityIssues/FontWorks"_ustr); return PATH; }
private:
    FontWorks(); // not defined
    ~FontWorks(); // not defined
};

private:
    AccessibilityIssues(); // not defined
    ~AccessibilityIssues(); // not defined
};

struct ExternalMailer: public comphelper::ConfigurationGroup< ExternalMailer> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/ExternalMailer"_ustr); return PATH; }

struct Program: public comphelper::ConfigurationProperty<Program, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/ExternalMailer/Program"_ustr); return PATH; }
private:
    Program(); // not defined
    ~Program(); // not defined
};

private:
    ExternalMailer(); // not defined
    ~ExternalMailer(); // not defined
};

struct I18N: public comphelper::ConfigurationGroup< I18N> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N"_ustr); return PATH; }

struct CJK: public comphelper::ConfigurationGroup< CJK> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK"_ustr); return PATH; }

struct CJKFont: public comphelper::ConfigurationProperty<CJKFont, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK/CJKFont"_ustr); return PATH; }
private:
    CJKFont(); // not defined
    ~CJKFont(); // not defined
};

struct VerticalText: public comphelper::ConfigurationProperty<VerticalText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK/VerticalText"_ustr); return PATH; }
private:
    VerticalText(); // not defined
    ~VerticalText(); // not defined
};

struct AsianTypography: public comphelper::ConfigurationProperty<AsianTypography, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK/AsianTypography"_ustr); return PATH; }
private:
    AsianTypography(); // not defined
    ~AsianTypography(); // not defined
};

struct JapaneseFind: public comphelper::ConfigurationProperty<JapaneseFind, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK/JapaneseFind"_ustr); return PATH; }
private:
    JapaneseFind(); // not defined
    ~JapaneseFind(); // not defined
};

struct Ruby: public comphelper::ConfigurationProperty<Ruby, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK/Ruby"_ustr); return PATH; }
private:
    Ruby(); // not defined
    ~Ruby(); // not defined
};

struct ChangeCaseMap: public comphelper::ConfigurationProperty<ChangeCaseMap, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK/ChangeCaseMap"_ustr); return PATH; }
private:
    ChangeCaseMap(); // not defined
    ~ChangeCaseMap(); // not defined
};

struct DoubleLines: public comphelper::ConfigurationProperty<DoubleLines, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK/DoubleLines"_ustr); return PATH; }
private:
    DoubleLines(); // not defined
    ~DoubleLines(); // not defined
};

struct EmphasisMarks: public comphelper::ConfigurationProperty<EmphasisMarks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CJK/EmphasisMarks"_ustr); return PATH; }
private:
    EmphasisMarks(); // not defined
    ~EmphasisMarks(); // not defined
};

private:
    CJK(); // not defined
    ~CJK(); // not defined
};

struct CTL: public comphelper::ConfigurationGroup< CTL> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CTL"_ustr); return PATH; }

struct CTLFont: public comphelper::ConfigurationProperty<CTLFont, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CTL/CTLFont"_ustr); return PATH; }
private:
    CTLFont(); // not defined
    ~CTLFont(); // not defined
};

struct CTLSequenceChecking: public comphelper::ConfigurationProperty<CTLSequenceChecking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CTL/CTLSequenceChecking"_ustr); return PATH; }
private:
    CTLSequenceChecking(); // not defined
    ~CTLSequenceChecking(); // not defined
};

struct CTLSequenceCheckingRestricted: public comphelper::ConfigurationProperty<CTLSequenceCheckingRestricted, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CTL/CTLSequenceCheckingRestricted"_ustr); return PATH; }
private:
    CTLSequenceCheckingRestricted(); // not defined
    ~CTLSequenceCheckingRestricted(); // not defined
};

struct CTLSequenceCheckingTypeAndReplace: public comphelper::ConfigurationProperty<CTLSequenceCheckingTypeAndReplace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CTL/CTLSequenceCheckingTypeAndReplace"_ustr); return PATH; }
private:
    CTLSequenceCheckingTypeAndReplace(); // not defined
    ~CTLSequenceCheckingTypeAndReplace(); // not defined
};

struct CTLCursorMovement: public comphelper::ConfigurationProperty<CTLCursorMovement, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CTL/CTLCursorMovement"_ustr); return PATH; }
private:
    CTLCursorMovement(); // not defined
    ~CTLCursorMovement(); // not defined
};

struct CTLTextNumerals: public comphelper::ConfigurationProperty<CTLTextNumerals, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CTL/CTLTextNumerals"_ustr); return PATH; }
private:
    CTLTextNumerals(); // not defined
    ~CTLTextNumerals(); // not defined
};

struct UIMirroring: public comphelper::ConfigurationProperty<UIMirroring, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/I18N/CTL/UIMirroring"_ustr); return PATH; }
private:
    UIMirroring(); // not defined
    ~UIMirroring(); // not defined
};

private:
    CTL(); // not defined
    ~CTL(); // not defined
};

private:
    I18N(); // not defined
    ~I18N(); // not defined
};

struct SmartTags: public comphelper::ConfigurationGroup< SmartTags> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SmartTags"_ustr); return PATH; }

struct Writer: public comphelper::ConfigurationGroup< Writer> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SmartTags/Writer"_ustr); return PATH; }

struct RecognizeSmartTags: public comphelper::ConfigurationProperty<RecognizeSmartTags, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SmartTags/Writer/RecognizeSmartTags"_ustr); return PATH; }
private:
    RecognizeSmartTags(); // not defined
    ~RecognizeSmartTags(); // not defined
};

struct ExcludedSmartTagTypes: public comphelper::ConfigurationProperty<ExcludedSmartTagTypes, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/SmartTags/Writer/ExcludedSmartTagTypes"_ustr); return PATH; }
private:
    ExcludedSmartTagTypes(); // not defined
    ~ExcludedSmartTagTypes(); // not defined
};

private:
    Writer(); // not defined
    ~Writer(); // not defined
};

private:
    SmartTags(); // not defined
    ~SmartTags(); // not defined
};

struct StylesAndFormatting: public comphelper::ConfigurationGroup< StylesAndFormatting> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/StylesAndFormatting"_ustr); return PATH; }

struct Preview: public comphelper::ConfigurationProperty<Preview, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/StylesAndFormatting/Preview"_ustr); return PATH; }
private:
    Preview(); // not defined
    ~Preview(); // not defined
};

private:
    StylesAndFormatting(); // not defined
    ~StylesAndFormatting(); // not defined
};

struct PackageKit: public comphelper::ConfigurationGroup< PackageKit> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PackageKit"_ustr); return PATH; }

struct EnableFontInstallation: public comphelper::ConfigurationProperty<EnableFontInstallation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PackageKit/EnableFontInstallation"_ustr); return PATH; }
private:
    EnableFontInstallation(); // not defined
    ~EnableFontInstallation(); // not defined
};

struct EnableLangpackInstallation: public comphelper::ConfigurationProperty<EnableLangpackInstallation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PackageKit/EnableLangpackInstallation"_ustr); return PATH; }
private:
    EnableLangpackInstallation(); // not defined
    ~EnableLangpackInstallation(); // not defined
};

struct EnableBaseInstallation: public comphelper::ConfigurationProperty<EnableBaseInstallation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PackageKit/EnableBaseInstallation"_ustr); return PATH; }
private:
    EnableBaseInstallation(); // not defined
    ~EnableBaseInstallation(); // not defined
};

private:
    PackageKit(); // not defined
    ~PackageKit(); // not defined
};

struct Classification: public comphelper::ConfigurationGroup< Classification> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Classification"_ustr); return PATH; }

struct Policy: public comphelper::ConfigurationProperty<Policy, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Classification/Policy"_ustr); return PATH; }
private:
    Policy(); // not defined
    ~Policy(); // not defined
};

struct IntellectualPropertySectionExpanded: public comphelper::ConfigurationProperty<IntellectualPropertySectionExpanded, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Classification/IntellectualPropertySectionExpanded"_ustr); return PATH; }
private:
    IntellectualPropertySectionExpanded(); // not defined
    ~IntellectualPropertySectionExpanded(); // not defined
};

struct IntellectualPropertyTextInputIsFreeForm: public comphelper::ConfigurationProperty<IntellectualPropertyTextInputIsFreeForm, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/Classification/IntellectualPropertyTextInputIsFreeForm"_ustr); return PATH; }
private:
    IntellectualPropertyTextInputIsFreeForm(); // not defined
    ~IntellectualPropertyTextInputIsFreeForm(); // not defined
};

private:
    Classification(); // not defined
    ~Classification(); // not defined
};

struct PasteSpecial: public comphelper::ConfigurationGroup< PasteSpecial> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial"_ustr); return PATH; }

struct Paste: public comphelper::ConfigurationGroup< Paste> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste"_ustr); return PATH; }

struct All: public comphelper::ConfigurationProperty<All, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste/All"_ustr); return PATH; }
private:
    All(); // not defined
    ~All(); // not defined
};

struct Numbers: public comphelper::ConfigurationProperty<Numbers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste/Numbers"_ustr); return PATH; }
private:
    Numbers(); // not defined
    ~Numbers(); // not defined
};

struct Text: public comphelper::ConfigurationProperty<Text, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste/Text"_ustr); return PATH; }
private:
    Text(); // not defined
    ~Text(); // not defined
};

struct DateTime: public comphelper::ConfigurationProperty<DateTime, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste/DateTime"_ustr); return PATH; }
private:
    DateTime(); // not defined
    ~DateTime(); // not defined
};

struct Formats: public comphelper::ConfigurationProperty<Formats, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste/Formats"_ustr); return PATH; }
private:
    Formats(); // not defined
    ~Formats(); // not defined
};

struct Comments: public comphelper::ConfigurationProperty<Comments, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste/Comments"_ustr); return PATH; }
private:
    Comments(); // not defined
    ~Comments(); // not defined
};

struct Objects: public comphelper::ConfigurationProperty<Objects, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste/Objects"_ustr); return PATH; }
private:
    Objects(); // not defined
    ~Objects(); // not defined
};

struct Formulas: public comphelper::ConfigurationProperty<Formulas, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Paste/Formulas"_ustr); return PATH; }
private:
    Formulas(); // not defined
    ~Formulas(); // not defined
};

private:
    Paste(); // not defined
    ~Paste(); // not defined
};

struct ShiftCells: public comphelper::ConfigurationProperty<ShiftCells, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/ShiftCells"_ustr); return PATH; }
private:
    ShiftCells(); // not defined
    ~ShiftCells(); // not defined
};

struct Options: public comphelper::ConfigurationGroup< Options> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Options"_ustr); return PATH; }

struct AsLink: public comphelper::ConfigurationProperty<AsLink, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Options/AsLink"_ustr); return PATH; }
private:
    AsLink(); // not defined
    ~AsLink(); // not defined
};

struct Transpose: public comphelper::ConfigurationProperty<Transpose, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Options/Transpose"_ustr); return PATH; }
private:
    Transpose(); // not defined
    ~Transpose(); // not defined
};

struct SkipEmptyCells: public comphelper::ConfigurationProperty<SkipEmptyCells, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Options/SkipEmptyCells"_ustr); return PATH; }
private:
    SkipEmptyCells(); // not defined
    ~SkipEmptyCells(); // not defined
};

private:
    Options(); // not defined
    ~Options(); // not defined
};

struct Operations: public comphelper::ConfigurationProperty<Operations, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Common/PasteSpecial/Operations"_ustr); return PATH; }
private:
    Operations(); // not defined
    ~Operations(); // not defined
};

private:
    PasteSpecial(); // not defined
    ~PasteSpecial(); // not defined
};

} } }

#endif
