/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         ir3_yyparse
#define yylex           ir3_yylex
#define yyerror         ir3_yyerror
#define yydebug         ir3_yydebug
#define yynerrs         ir3_yynerrs
#define yylval          ir3_yylval
#define yychar          ir3_yychar

/* First part of user prologue.  */
#line 32 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"

#define YYDEBUG 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "util/half_float.h"
#include "util/u_math.h"

#include "ir3/ir3.h"
#include "ir3/ir3_shader.h"
#include "ir3/instr-a3xx.h"

#include "ir3_parser.h"

#define swap(a, b) \
	do { __typeof(a) __tmp = (a); (a) = (b); (b) = __tmp; } while (0)

/* ir3 treats the abs/neg flags as separate flags for float vs integer,
 * but in the instruction encoding they are the same thing.  Tracking
 * them separately is only for the benefit of ir3 opt passes, and not
 * required here, so just use the float versions:
 */
#define IR3_REG_ABS     IR3_REG_FABS
#define IR3_REG_NEGATE  IR3_REG_FNEG

static pthread_mutex_t ir3_parse_mtx = PTHREAD_MUTEX_INITIALIZER;

static struct ir3_kernel_info    *info;
static struct ir3_shader_variant *variant;
/* NOTE the assembler doesn't really use the ir3_block construction
 * like the compiler does.  Everything is treated as one large block.
 * Which might happen to contain flow control.  But since we don't
 * use any of the ir3 backend passes (sched, RA, etc) this doesn't
 * really matter.
 */
static struct ir3_block          *block;   /* current shader block */
static struct ir3_instruction    *instr;   /* current instruction */
static unsigned ip; /* current instruction pointer */
static struct hash_table *labels;

static bool is_in_fullnop_section;
static bool is_in_fullsync_section;

void *ir3_parser_dead_ctx;

char* current_line;

static struct {
	unsigned flags;
	unsigned repeat;
	unsigned nop;
} iflags;

static struct {
	unsigned flags;
	unsigned wrmask;
} rflags;

static struct {
        uint32_t reg_address_hi;
        uint32_t reg_address_lo;
        uint32_t reg_tmp;

        uint32_t regs_to_dump[128];
        uint32_t regs_count;
} meta_print_data;

int ir3_yyget_lineno(void);

static void new_label(const char *name)
{
	ralloc_steal(labels, (void *) name);
	_mesa_hash_table_insert(labels, name, (void *)(uintptr_t)ip);
}

static struct ir3_instruction * new_instr(opc_t opc)
{
	instr = ir3_instr_create_at_end(block, opc, 4, 6);
	instr->flags = iflags.flags;
	instr->repeat = iflags.repeat;
	instr->nop = iflags.nop;
	instr->line = ir3_yyget_lineno();
	iflags.flags = iflags.repeat = iflags.nop = 0;

	if (is_in_fullnop_section) {
		struct ir3_instruction *nop =
			ir3_instr_create_at(ir3_before_instr(instr), OPC_NOP, 0, 0);
		nop->repeat = 5;
		ip++;
	}

	if (is_in_fullsync_section) {
		struct ir3_instruction *nop =
			ir3_instr_create_at(ir3_before_instr(instr), OPC_NOP, 0, 0);
		nop->flags = IR3_INSTR_SS | IR3_INSTR_SY;
		ip++;
	}

	ip++;
	return instr;
}

static void new_shader(void)
{
	variant->ir = ir3_create(variant->compiler, variant);
	block = ir3_block_create(variant->ir);
	list_addtail(&block->node, &variant->ir->block_list);
	ip = 0;
	labels = _mesa_hash_table_create(variant, _mesa_hash_string, _mesa_key_string_equal);
	ir3_parser_dead_ctx = ralloc_context(NULL);
}

static type_t parse_type(const char **type)
{
	if (!strncmp("f16", *type, 3)) {
		*type += 3;
		return TYPE_F16;
	} else if (!strncmp("f32", *type, 3)) {
		*type += 3;
		return TYPE_F32;
	} else if (!strncmp("u16", *type, 3)) {
		*type += 3;
		return TYPE_U16;
	} else if (!strncmp("u32", *type, 3)) {
		*type += 3;
		return TYPE_U32;
	} else if (!strncmp("s16", *type, 3)) {
		*type += 3;
		return TYPE_S16;
	} else if (!strncmp("s32", *type, 3)) {
		*type += 3;
		return TYPE_S32;
	} else if (!strncmp("u8", *type, 2)) {
		*type += 2;
		return TYPE_U8;
	} else if (!strncmp("u8_32", *type, 5)) {
		*type += 5;
		return TYPE_U8_32;
	} else if (!strncmp("u64", *type, 3)) {
		*type += 3;
		return TYPE_ATOMIC_U64;
	} else {
		assert(0);  /* shouldn't get here */
		return ~0;
	}
}

static struct ir3_instruction * parse_type_type(struct ir3_instruction *instr,
		const char *type_type)
{
	instr->cat1.src_type = parse_type(&type_type);
	instr->cat1.dst_type = parse_type(&type_type);
	return instr;
}

static struct ir3_register * new_src(int num, unsigned flags)
{
	struct ir3_register *reg;
	flags |= rflags.flags;
	if (num & 0x1)
		flags |= IR3_REG_HALF;
	reg = ir3_src_create(instr, num>>1, flags);
	reg->wrmask = MAX2(1, rflags.wrmask);
	rflags.flags = rflags.wrmask = 0;
	return reg;
}

static struct ir3_register * new_dst(int num, unsigned flags)
{
	struct ir3_register *reg;
	flags |= rflags.flags;
	if (num & 0x1)
		flags |= IR3_REG_HALF;
	reg = ir3_dst_create(instr, num>>1, flags);
	reg->wrmask = MAX2(1, rflags.wrmask);
	rflags.flags = rflags.wrmask = 0;
	return reg;
}

static struct ir3_register * dummy_dst(void)
{
	return new_dst(0, 0);
}

static void fixup_cat5_s2en(void)
{
	assert(opc_cat(instr->opc) == 5);
	if (!(instr->flags & IR3_INSTR_S2EN))
		return;
	/* For various reasons (ie. mainly to make the .s2en src easier to
	 * find, given that various different cat5 tex instructions can have
	 * different # of src registers), in ir3 the samp/tex src register
	 * is first, rather than last.  So we have to detect this case and
	 * fix things up.
	 */

	uint32_t s2en_off = instr->srcs_count - 1;
	if (instr->flags & IR3_INSTR_A1EN)
		s2en_off = instr->srcs_count - 2;

	struct ir3_register *s2en_src = instr->srcs[s2en_off];

	if (instr->flags & IR3_INSTR_B)
		assert(!(s2en_src->flags & IR3_REG_HALF));
	else
		assert(s2en_src->flags & IR3_REG_HALF);

	memmove(instr->srcs + 1, instr->srcs, s2en_off * sizeof(instr->srcs[0]));
	instr->srcs[0] = s2en_src;
}

static void add_const(unsigned reg, unsigned c0, unsigned c1, unsigned c2, unsigned c3)
{
	struct ir3_imm_const_state *imm_state = &variant->imm_state;
	assert((reg & 0x7) == 0);
	int idx = reg >> (1 + 2); /* low bit is half vs full, next two bits are swiz */
	if (idx * 4 + 4 > imm_state->size) {
		imm_state->values = rerzalloc(variant,
				imm_state->values,
				__typeof__(imm_state->values[0]),
				imm_state->size,
				idx * 4 + 4);
		for (unsigned i = imm_state->size; i < idx * 4; i++)
			imm_state->values[i] = 0xd0d0d0d0;
		imm_state->size = imm_state->count = idx * 4 + 4;
	}
	imm_state->values[idx * 4 + 0] = c0;
	imm_state->values[idx * 4 + 1] = c1;
	imm_state->values[idx * 4 + 2] = c2;
	imm_state->values[idx * 4 + 3] = c3;
}

static void add_buf_init_val(uint32_t val)
{
	assert(info->num_bufs > 0);
	unsigned idx = info->num_bufs - 1;

	if (!info->buf_init_data[idx]) {
		unsigned sz = info->buf_sizes[idx] * 4;
		info->buf_init_data[idx] = malloc(sz);
		memset(info->buf_init_data[idx], 0, sz);
	}

	assert(info->buf_init_data_sizes[idx] < info->buf_sizes[idx]);
	info->buf_init_data[idx][info->buf_init_data_sizes[idx]++] = val;
}

static void add_sysval(unsigned reg, unsigned compmask, gl_system_value sysval)
{
	unsigned n = variant->inputs_count++;
	variant->inputs[n].regid = reg;
	variant->inputs[n].sysval = true;
	variant->inputs[n].slot = sysval;
	variant->inputs[n].compmask = compmask;
	variant->total_in++;
}

static bool resolve_labels(void)
{
	int instr_ip = 0;
	foreach_instr (instr, &block->instr_list) {
		if (opc_cat(instr->opc) == 0 && instr->cat0.target_label) {
			struct hash_entry *entry = _mesa_hash_table_search(labels, instr->cat0.target_label);
			if (!entry) {
				fprintf(stderr, "unknown label %s\n", instr->cat0.target_label);
				return false;
			}
			int target_ip = (uintptr_t)entry->data;
			instr->cat0.immed = target_ip - instr_ip;
		}
		instr_ip++;
	}
	return true;
}

static unsigned cat6_type_shift()
{
	return util_logbase2(type_size(instr->cat6.type) / 8);
}

#ifdef YYDEBUG
int yydebug;
#endif

extern int yylex(void);
void ir3_yyset_lineno(int _line_number);
void ir3_yyset_input(FILE *f);

int yyparse(void);

static void yyerror(const char *error)
{
	fprintf(stderr, "error at line %d: %s\n%s\n", ir3_yyget_lineno(), error, current_line);
}

/* Needs to be a macro to use YYERROR */
#define illegal_syntax_from(gen_from, error)              \
	do {                                              \
		if (variant->compiler->gen >= gen_from) { \
			yyerror(error);                   \
			YYERROR;                          \
		}                                         \
	} while (0)

struct ir3 * ir3_parse(struct ir3_shader_variant *v,
		struct ir3_kernel_info *k, FILE *f)
{
	pthread_mutex_lock(&ir3_parse_mtx);

	ir3_yyset_lineno(1);
	ir3_yyset_input(f);
#ifdef YYDEBUG
	yydebug = 1;
#endif
	info = k;
	variant = v;

	is_in_fullnop_section = false;
	is_in_fullsync_section = false;

	if (yyparse() || !resolve_labels()) {
		ir3_destroy(variant->ir);
		variant->ir = NULL;
	}
	ralloc_free(labels);
	ralloc_free(ir3_parser_dead_ctx);

	struct ir3 *ir = variant->ir;
	pthread_mutex_unlock(&ir3_parse_mtx);
	return ir;
}

#line 414 "src/freedreno/ir3/ir3_parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "ir3_parser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_T_INT = 3,                      /* T_INT  */
  YYSYMBOL_T_HEX = 4,                      /* T_HEX  */
  YYSYMBOL_T_FLOAT = 5,                    /* T_FLOAT  */
  YYSYMBOL_T_IDENTIFIER = 6,               /* T_IDENTIFIER  */
  YYSYMBOL_T_REGISTER = 7,                 /* T_REGISTER  */
  YYSYMBOL_T_CONSTANT = 8,                 /* T_CONSTANT  */
  YYSYMBOL_T_RT = 9,                       /* T_RT  */
  YYSYMBOL_T_A_LOCALSIZE = 10,             /* T_A_LOCALSIZE  */
  YYSYMBOL_T_A_CONST = 11,                 /* T_A_CONST  */
  YYSYMBOL_T_A_BUF = 12,                   /* T_A_BUF  */
  YYSYMBOL_T_A_UBO = 13,                   /* T_A_UBO  */
  YYSYMBOL_T_A_INVOCATIONID = 14,          /* T_A_INVOCATIONID  */
  YYSYMBOL_T_A_WGID = 15,                  /* T_A_WGID  */
  YYSYMBOL_T_A_NUMWG = 16,                 /* T_A_NUMWG  */
  YYSYMBOL_T_A_BRANCHSTACK = 17,           /* T_A_BRANCHSTACK  */
  YYSYMBOL_T_A_IN = 18,                    /* T_A_IN  */
  YYSYMBOL_T_A_OUT = 19,                   /* T_A_OUT  */
  YYSYMBOL_T_A_TEX = 20,                   /* T_A_TEX  */
  YYSYMBOL_T_A_PVTMEM = 21,                /* T_A_PVTMEM  */
  YYSYMBOL_T_A_LOCALMEM = 22,              /* T_A_LOCALMEM  */
  YYSYMBOL_T_A_EARLYPREAMBLE = 23,         /* T_A_EARLYPREAMBLE  */
  YYSYMBOL_T_A_FULLNOPSTART = 24,          /* T_A_FULLNOPSTART  */
  YYSYMBOL_T_A_FULLNOPEND = 25,            /* T_A_FULLNOPEND  */
  YYSYMBOL_T_A_FULLSYNCSTART = 26,         /* T_A_FULLSYNCSTART  */
  YYSYMBOL_T_A_FULLSYNCEND = 27,           /* T_A_FULLSYNCEND  */
  YYSYMBOL_T_ABSNEG = 28,                  /* T_ABSNEG  */
  YYSYMBOL_T_NEG = 29,                     /* T_NEG  */
  YYSYMBOL_T_ABS = 30,                     /* T_ABS  */
  YYSYMBOL_T_R = 31,                       /* T_R  */
  YYSYMBOL_T_LAST = 32,                    /* T_LAST  */
  YYSYMBOL_T_HR = 33,                      /* T_HR  */
  YYSYMBOL_T_HC = 34,                      /* T_HC  */
  YYSYMBOL_T_EVEN = 35,                    /* T_EVEN  */
  YYSYMBOL_T_POS_INFINITY = 36,            /* T_POS_INFINITY  */
  YYSYMBOL_T_NEG_INFINITY = 37,            /* T_NEG_INFINITY  */
  YYSYMBOL_T_EI = 38,                      /* T_EI  */
  YYSYMBOL_T_WRMASK = 39,                  /* T_WRMASK  */
  YYSYMBOL_T_FLUT_0_0 = 40,                /* T_FLUT_0_0  */
  YYSYMBOL_T_FLUT_0_5 = 41,                /* T_FLUT_0_5  */
  YYSYMBOL_T_FLUT_1_0 = 42,                /* T_FLUT_1_0  */
  YYSYMBOL_T_FLUT_2_0 = 43,                /* T_FLUT_2_0  */
  YYSYMBOL_T_FLUT_E = 44,                  /* T_FLUT_E  */
  YYSYMBOL_T_FLUT_PI = 45,                 /* T_FLUT_PI  */
  YYSYMBOL_T_FLUT_INV_PI = 46,             /* T_FLUT_INV_PI  */
  YYSYMBOL_T_FLUT_INV_LOG2_E = 47,         /* T_FLUT_INV_LOG2_E  */
  YYSYMBOL_T_FLUT_LOG2_E = 48,             /* T_FLUT_LOG2_E  */
  YYSYMBOL_T_FLUT_INV_LOG2_10 = 49,        /* T_FLUT_INV_LOG2_10  */
  YYSYMBOL_T_FLUT_LOG2_10 = 50,            /* T_FLUT_LOG2_10  */
  YYSYMBOL_T_FLUT_4_0 = 51,                /* T_FLUT_4_0  */
  YYSYMBOL_T_SY = 52,                      /* T_SY  */
  YYSYMBOL_T_SS = 53,                      /* T_SS  */
  YYSYMBOL_T_JP = 54,                      /* T_JP  */
  YYSYMBOL_T_EQ_FLAG = 55,                 /* T_EQ_FLAG  */
  YYSYMBOL_T_SAT = 56,                     /* T_SAT  */
  YYSYMBOL_T_RPT = 57,                     /* T_RPT  */
  YYSYMBOL_T_UL = 58,                      /* T_UL  */
  YYSYMBOL_T_NOP = 59,                     /* T_NOP  */
  YYSYMBOL_T_OP_NOP = 60,                  /* T_OP_NOP  */
  YYSYMBOL_T_OP_BR = 61,                   /* T_OP_BR  */
  YYSYMBOL_T_OP_BRAO = 62,                 /* T_OP_BRAO  */
  YYSYMBOL_T_OP_BRAA = 63,                 /* T_OP_BRAA  */
  YYSYMBOL_T_OP_BRAC = 64,                 /* T_OP_BRAC  */
  YYSYMBOL_T_OP_BANY = 65,                 /* T_OP_BANY  */
  YYSYMBOL_T_OP_BALL = 66,                 /* T_OP_BALL  */
  YYSYMBOL_T_OP_BRAX = 67,                 /* T_OP_BRAX  */
  YYSYMBOL_T_OP_JUMP = 68,                 /* T_OP_JUMP  */
  YYSYMBOL_T_OP_CALL = 69,                 /* T_OP_CALL  */
  YYSYMBOL_T_OP_RET = 70,                  /* T_OP_RET  */
  YYSYMBOL_T_OP_KILL = 71,                 /* T_OP_KILL  */
  YYSYMBOL_T_OP_END = 72,                  /* T_OP_END  */
  YYSYMBOL_T_OP_EMIT = 73,                 /* T_OP_EMIT  */
  YYSYMBOL_T_OP_CUT = 74,                  /* T_OP_CUT  */
  YYSYMBOL_T_OP_CHMASK = 75,               /* T_OP_CHMASK  */
  YYSYMBOL_T_OP_CHSH = 76,                 /* T_OP_CHSH  */
  YYSYMBOL_T_OP_FLOW_REV = 77,             /* T_OP_FLOW_REV  */
  YYSYMBOL_T_OP_BKT = 78,                  /* T_OP_BKT  */
  YYSYMBOL_T_OP_STKS = 79,                 /* T_OP_STKS  */
  YYSYMBOL_T_OP_STKR = 80,                 /* T_OP_STKR  */
  YYSYMBOL_T_OP_XSET = 81,                 /* T_OP_XSET  */
  YYSYMBOL_T_OP_XCLR = 82,                 /* T_OP_XCLR  */
  YYSYMBOL_T_OP_GETLAST = 83,              /* T_OP_GETLAST  */
  YYSYMBOL_T_OP_GETONE = 84,               /* T_OP_GETONE  */
  YYSYMBOL_T_OP_DBG = 85,                  /* T_OP_DBG  */
  YYSYMBOL_T_OP_SHPS = 86,                 /* T_OP_SHPS  */
  YYSYMBOL_T_OP_SHPE = 87,                 /* T_OP_SHPE  */
  YYSYMBOL_T_OP_PREDT = 88,                /* T_OP_PREDT  */
  YYSYMBOL_T_OP_PREDF = 89,                /* T_OP_PREDF  */
  YYSYMBOL_T_OP_PREDE = 90,                /* T_OP_PREDE  */
  YYSYMBOL_T_OP_MOVMSK = 91,               /* T_OP_MOVMSK  */
  YYSYMBOL_T_OP_MOVA1 = 92,                /* T_OP_MOVA1  */
  YYSYMBOL_T_OP_MOVA = 93,                 /* T_OP_MOVA  */
  YYSYMBOL_T_OP_MOV = 94,                  /* T_OP_MOV  */
  YYSYMBOL_T_OP_COV = 95,                  /* T_OP_COV  */
  YYSYMBOL_T_OP_SWZ = 96,                  /* T_OP_SWZ  */
  YYSYMBOL_T_OP_GAT = 97,                  /* T_OP_GAT  */
  YYSYMBOL_T_OP_SCT = 98,                  /* T_OP_SCT  */
  YYSYMBOL_T_OP_MOVS = 99,                 /* T_OP_MOVS  */
  YYSYMBOL_T_OP_ADD_F = 100,               /* T_OP_ADD_F  */
  YYSYMBOL_T_OP_MIN_F = 101,               /* T_OP_MIN_F  */
  YYSYMBOL_T_OP_MAX_F = 102,               /* T_OP_MAX_F  */
  YYSYMBOL_T_OP_MUL_F = 103,               /* T_OP_MUL_F  */
  YYSYMBOL_T_OP_SIGN_F = 104,              /* T_OP_SIGN_F  */
  YYSYMBOL_T_OP_CMPS_F = 105,              /* T_OP_CMPS_F  */
  YYSYMBOL_T_OP_ABSNEG_F = 106,            /* T_OP_ABSNEG_F  */
  YYSYMBOL_T_OP_CMPV_F = 107,              /* T_OP_CMPV_F  */
  YYSYMBOL_T_OP_FLOOR_F = 108,             /* T_OP_FLOOR_F  */
  YYSYMBOL_T_OP_CEIL_F = 109,              /* T_OP_CEIL_F  */
  YYSYMBOL_T_OP_RNDNE_F = 110,             /* T_OP_RNDNE_F  */
  YYSYMBOL_T_OP_RNDAZ_F = 111,             /* T_OP_RNDAZ_F  */
  YYSYMBOL_T_OP_TRUNC_F = 112,             /* T_OP_TRUNC_F  */
  YYSYMBOL_T_OP_ADD_U = 113,               /* T_OP_ADD_U  */
  YYSYMBOL_T_OP_ADD_S = 114,               /* T_OP_ADD_S  */
  YYSYMBOL_T_OP_SUB_U = 115,               /* T_OP_SUB_U  */
  YYSYMBOL_T_OP_SUB_S = 116,               /* T_OP_SUB_S  */
  YYSYMBOL_T_OP_CMPS_U = 117,              /* T_OP_CMPS_U  */
  YYSYMBOL_T_OP_CMPS_S = 118,              /* T_OP_CMPS_S  */
  YYSYMBOL_T_OP_MIN_U = 119,               /* T_OP_MIN_U  */
  YYSYMBOL_T_OP_MIN_S = 120,               /* T_OP_MIN_S  */
  YYSYMBOL_T_OP_MAX_U = 121,               /* T_OP_MAX_U  */
  YYSYMBOL_T_OP_MAX_S = 122,               /* T_OP_MAX_S  */
  YYSYMBOL_T_OP_ABSNEG_S = 123,            /* T_OP_ABSNEG_S  */
  YYSYMBOL_T_OP_AND_B = 124,               /* T_OP_AND_B  */
  YYSYMBOL_T_OP_OR_B = 125,                /* T_OP_OR_B  */
  YYSYMBOL_T_OP_NOT_B = 126,               /* T_OP_NOT_B  */
  YYSYMBOL_T_OP_XOR_B = 127,               /* T_OP_XOR_B  */
  YYSYMBOL_T_OP_CMPV_U = 128,              /* T_OP_CMPV_U  */
  YYSYMBOL_T_OP_CMPV_S = 129,              /* T_OP_CMPV_S  */
  YYSYMBOL_T_OP_MUL_U24 = 130,             /* T_OP_MUL_U24  */
  YYSYMBOL_T_OP_MUL_S24 = 131,             /* T_OP_MUL_S24  */
  YYSYMBOL_T_OP_MULL_U = 132,              /* T_OP_MULL_U  */
  YYSYMBOL_T_OP_BFREV_B = 133,             /* T_OP_BFREV_B  */
  YYSYMBOL_T_OP_CLZ_S = 134,               /* T_OP_CLZ_S  */
  YYSYMBOL_T_OP_CLZ_B = 135,               /* T_OP_CLZ_B  */
  YYSYMBOL_T_OP_SHL_B = 136,               /* T_OP_SHL_B  */
  YYSYMBOL_T_OP_SHR_B = 137,               /* T_OP_SHR_B  */
  YYSYMBOL_T_OP_ASHR_B = 138,              /* T_OP_ASHR_B  */
  YYSYMBOL_T_OP_BARY_F = 139,              /* T_OP_BARY_F  */
  YYSYMBOL_T_OP_FLAT_B = 140,              /* T_OP_FLAT_B  */
  YYSYMBOL_T_OP_MGEN_B = 141,              /* T_OP_MGEN_B  */
  YYSYMBOL_T_OP_GETBIT_B = 142,            /* T_OP_GETBIT_B  */
  YYSYMBOL_T_OP_SETRM = 143,               /* T_OP_SETRM  */
  YYSYMBOL_T_OP_CBITS_B = 144,             /* T_OP_CBITS_B  */
  YYSYMBOL_T_OP_SHB = 145,                 /* T_OP_SHB  */
  YYSYMBOL_T_OP_MSAD = 146,                /* T_OP_MSAD  */
  YYSYMBOL_T_OP_MAD_U16 = 147,             /* T_OP_MAD_U16  */
  YYSYMBOL_T_OP_MADSH_U16 = 148,           /* T_OP_MADSH_U16  */
  YYSYMBOL_T_OP_MAD_S16 = 149,             /* T_OP_MAD_S16  */
  YYSYMBOL_T_OP_MADSH_M16 = 150,           /* T_OP_MADSH_M16  */
  YYSYMBOL_T_OP_MAD_U24 = 151,             /* T_OP_MAD_U24  */
  YYSYMBOL_T_OP_MAD_S24 = 152,             /* T_OP_MAD_S24  */
  YYSYMBOL_T_OP_MAD_F16 = 153,             /* T_OP_MAD_F16  */
  YYSYMBOL_T_OP_MAD_F32 = 154,             /* T_OP_MAD_F32  */
  YYSYMBOL_T_OP_SEL_B16 = 155,             /* T_OP_SEL_B16  */
  YYSYMBOL_T_OP_SEL_B32 = 156,             /* T_OP_SEL_B32  */
  YYSYMBOL_T_OP_SEL_S16 = 157,             /* T_OP_SEL_S16  */
  YYSYMBOL_T_OP_SEL_S32 = 158,             /* T_OP_SEL_S32  */
  YYSYMBOL_T_OP_SEL_F16 = 159,             /* T_OP_SEL_F16  */
  YYSYMBOL_T_OP_SEL_F32 = 160,             /* T_OP_SEL_F32  */
  YYSYMBOL_T_OP_SAD_S16 = 161,             /* T_OP_SAD_S16  */
  YYSYMBOL_T_OP_SAD_S32 = 162,             /* T_OP_SAD_S32  */
  YYSYMBOL_T_OP_SHRM = 163,                /* T_OP_SHRM  */
  YYSYMBOL_T_OP_SHLM = 164,                /* T_OP_SHLM  */
  YYSYMBOL_T_OP_SHRG = 165,                /* T_OP_SHRG  */
  YYSYMBOL_T_OP_SHLG = 166,                /* T_OP_SHLG  */
  YYSYMBOL_T_OP_ANDG = 167,                /* T_OP_ANDG  */
  YYSYMBOL_T_OP_DP2ACC = 168,              /* T_OP_DP2ACC  */
  YYSYMBOL_T_OP_DP4ACC = 169,              /* T_OP_DP4ACC  */
  YYSYMBOL_T_OP_WMM = 170,                 /* T_OP_WMM  */
  YYSYMBOL_T_OP_WMM_ACCU = 171,            /* T_OP_WMM_ACCU  */
  YYSYMBOL_T_OP_RCP = 172,                 /* T_OP_RCP  */
  YYSYMBOL_T_OP_RSQ = 173,                 /* T_OP_RSQ  */
  YYSYMBOL_T_OP_LOG2 = 174,                /* T_OP_LOG2  */
  YYSYMBOL_T_OP_EXP2 = 175,                /* T_OP_EXP2  */
  YYSYMBOL_T_OP_SIN = 176,                 /* T_OP_SIN  */
  YYSYMBOL_T_OP_COS = 177,                 /* T_OP_COS  */
  YYSYMBOL_T_OP_SQRT = 178,                /* T_OP_SQRT  */
  YYSYMBOL_T_OP_HRSQ = 179,                /* T_OP_HRSQ  */
  YYSYMBOL_T_OP_HLOG2 = 180,               /* T_OP_HLOG2  */
  YYSYMBOL_T_OP_HEXP2 = 181,               /* T_OP_HEXP2  */
  YYSYMBOL_T_OP_ISAM = 182,                /* T_OP_ISAM  */
  YYSYMBOL_T_OP_ISAML = 183,               /* T_OP_ISAML  */
  YYSYMBOL_T_OP_ISAMM = 184,               /* T_OP_ISAMM  */
  YYSYMBOL_T_OP_SAM = 185,                 /* T_OP_SAM  */
  YYSYMBOL_T_OP_SAMB = 186,                /* T_OP_SAMB  */
  YYSYMBOL_T_OP_SAML = 187,                /* T_OP_SAML  */
  YYSYMBOL_T_OP_SAMGQ = 188,               /* T_OP_SAMGQ  */
  YYSYMBOL_T_OP_GETLOD = 189,              /* T_OP_GETLOD  */
  YYSYMBOL_T_OP_CONV = 190,                /* T_OP_CONV  */
  YYSYMBOL_T_OP_CONVM = 191,               /* T_OP_CONVM  */
  YYSYMBOL_T_OP_GETSIZE = 192,             /* T_OP_GETSIZE  */
  YYSYMBOL_T_OP_GETBUF = 193,              /* T_OP_GETBUF  */
  YYSYMBOL_T_OP_GETPOS = 194,              /* T_OP_GETPOS  */
  YYSYMBOL_T_OP_GETINFO = 195,             /* T_OP_GETINFO  */
  YYSYMBOL_T_OP_DSX = 196,                 /* T_OP_DSX  */
  YYSYMBOL_T_OP_DSY = 197,                 /* T_OP_DSY  */
  YYSYMBOL_T_OP_GATHER4R = 198,            /* T_OP_GATHER4R  */
  YYSYMBOL_T_OP_GATHER4G = 199,            /* T_OP_GATHER4G  */
  YYSYMBOL_T_OP_GATHER4B = 200,            /* T_OP_GATHER4B  */
  YYSYMBOL_T_OP_GATHER4A = 201,            /* T_OP_GATHER4A  */
  YYSYMBOL_T_OP_SAMGP0 = 202,              /* T_OP_SAMGP0  */
  YYSYMBOL_T_OP_SAMGP1 = 203,              /* T_OP_SAMGP1  */
  YYSYMBOL_T_OP_SAMGP2 = 204,              /* T_OP_SAMGP2  */
  YYSYMBOL_T_OP_SAMGP3 = 205,              /* T_OP_SAMGP3  */
  YYSYMBOL_T_OP_DSXPP_1 = 206,             /* T_OP_DSXPP_1  */
  YYSYMBOL_T_OP_DSYPP_1 = 207,             /* T_OP_DSYPP_1  */
  YYSYMBOL_T_OP_RGETPOS = 208,             /* T_OP_RGETPOS  */
  YYSYMBOL_T_OP_RGETINFO = 209,            /* T_OP_RGETINFO  */
  YYSYMBOL_T_OP_BRCST_A = 210,             /* T_OP_BRCST_A  */
  YYSYMBOL_T_OP_QSHUFFLE_BRCST = 211,      /* T_OP_QSHUFFLE_BRCST  */
  YYSYMBOL_T_OP_QSHUFFLE_H = 212,          /* T_OP_QSHUFFLE_H  */
  YYSYMBOL_T_OP_QSHUFFLE_V = 213,          /* T_OP_QSHUFFLE_V  */
  YYSYMBOL_T_OP_QSHUFFLE_DIAG = 214,       /* T_OP_QSHUFFLE_DIAG  */
  YYSYMBOL_T_OP_TCINV = 215,               /* T_OP_TCINV  */
  YYSYMBOL_T_OP_LDG = 216,                 /* T_OP_LDG  */
  YYSYMBOL_T_OP_LDG_A = 217,               /* T_OP_LDG_A  */
  YYSYMBOL_T_OP_LDG_K = 218,               /* T_OP_LDG_K  */
  YYSYMBOL_T_OP_LDL = 219,                 /* T_OP_LDL  */
  YYSYMBOL_T_OP_LDP = 220,                 /* T_OP_LDP  */
  YYSYMBOL_T_OP_STG = 221,                 /* T_OP_STG  */
  YYSYMBOL_T_OP_STG_A = 222,               /* T_OP_STG_A  */
  YYSYMBOL_T_OP_STL = 223,                 /* T_OP_STL  */
  YYSYMBOL_T_OP_STP = 224,                 /* T_OP_STP  */
  YYSYMBOL_T_OP_LDIB = 225,                /* T_OP_LDIB  */
  YYSYMBOL_T_OP_G2L = 226,                 /* T_OP_G2L  */
  YYSYMBOL_T_OP_L2G = 227,                 /* T_OP_L2G  */
  YYSYMBOL_T_OP_PREFETCH = 228,            /* T_OP_PREFETCH  */
  YYSYMBOL_T_OP_LDLW = 229,                /* T_OP_LDLW  */
  YYSYMBOL_T_OP_STLW = 230,                /* T_OP_STLW  */
  YYSYMBOL_T_OP_RESFMT = 231,              /* T_OP_RESFMT  */
  YYSYMBOL_T_OP_RESINFO = 232,             /* T_OP_RESINFO  */
  YYSYMBOL_T_OP_RESBASE = 233,             /* T_OP_RESBASE  */
  YYSYMBOL_T_OP_ATOMIC_ADD = 234,          /* T_OP_ATOMIC_ADD  */
  YYSYMBOL_T_OP_ATOMIC_SUB = 235,          /* T_OP_ATOMIC_SUB  */
  YYSYMBOL_T_OP_ATOMIC_XCHG = 236,         /* T_OP_ATOMIC_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_INC = 237,          /* T_OP_ATOMIC_INC  */
  YYSYMBOL_T_OP_ATOMIC_DEC = 238,          /* T_OP_ATOMIC_DEC  */
  YYSYMBOL_T_OP_ATOMIC_CMPXCHG = 239,      /* T_OP_ATOMIC_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_MIN = 240,          /* T_OP_ATOMIC_MIN  */
  YYSYMBOL_T_OP_ATOMIC_MAX = 241,          /* T_OP_ATOMIC_MAX  */
  YYSYMBOL_T_OP_ATOMIC_AND = 242,          /* T_OP_ATOMIC_AND  */
  YYSYMBOL_T_OP_ATOMIC_OR = 243,           /* T_OP_ATOMIC_OR  */
  YYSYMBOL_T_OP_ATOMIC_XOR = 244,          /* T_OP_ATOMIC_XOR  */
  YYSYMBOL_T_OP_RESINFO_B = 245,           /* T_OP_RESINFO_B  */
  YYSYMBOL_T_OP_LDIB_B = 246,              /* T_OP_LDIB_B  */
  YYSYMBOL_T_OP_STIB_B = 247,              /* T_OP_STIB_B  */
  YYSYMBOL_T_OP_ATOMIC_B_ADD = 248,        /* T_OP_ATOMIC_B_ADD  */
  YYSYMBOL_T_OP_ATOMIC_B_SUB = 249,        /* T_OP_ATOMIC_B_SUB  */
  YYSYMBOL_T_OP_ATOMIC_B_XCHG = 250,       /* T_OP_ATOMIC_B_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_B_INC = 251,        /* T_OP_ATOMIC_B_INC  */
  YYSYMBOL_T_OP_ATOMIC_B_DEC = 252,        /* T_OP_ATOMIC_B_DEC  */
  YYSYMBOL_T_OP_ATOMIC_B_CMPXCHG = 253,    /* T_OP_ATOMIC_B_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_B_MIN = 254,        /* T_OP_ATOMIC_B_MIN  */
  YYSYMBOL_T_OP_ATOMIC_B_MAX = 255,        /* T_OP_ATOMIC_B_MAX  */
  YYSYMBOL_T_OP_ATOMIC_B_AND = 256,        /* T_OP_ATOMIC_B_AND  */
  YYSYMBOL_T_OP_ATOMIC_B_OR = 257,         /* T_OP_ATOMIC_B_OR  */
  YYSYMBOL_T_OP_ATOMIC_B_XOR = 258,        /* T_OP_ATOMIC_B_XOR  */
  YYSYMBOL_T_OP_ATOMIC_S_ADD = 259,        /* T_OP_ATOMIC_S_ADD  */
  YYSYMBOL_T_OP_ATOMIC_S_SUB = 260,        /* T_OP_ATOMIC_S_SUB  */
  YYSYMBOL_T_OP_ATOMIC_S_XCHG = 261,       /* T_OP_ATOMIC_S_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_S_INC = 262,        /* T_OP_ATOMIC_S_INC  */
  YYSYMBOL_T_OP_ATOMIC_S_DEC = 263,        /* T_OP_ATOMIC_S_DEC  */
  YYSYMBOL_T_OP_ATOMIC_S_CMPXCHG = 264,    /* T_OP_ATOMIC_S_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_S_MIN = 265,        /* T_OP_ATOMIC_S_MIN  */
  YYSYMBOL_T_OP_ATOMIC_S_MAX = 266,        /* T_OP_ATOMIC_S_MAX  */
  YYSYMBOL_T_OP_ATOMIC_S_AND = 267,        /* T_OP_ATOMIC_S_AND  */
  YYSYMBOL_T_OP_ATOMIC_S_OR = 268,         /* T_OP_ATOMIC_S_OR  */
  YYSYMBOL_T_OP_ATOMIC_S_XOR = 269,        /* T_OP_ATOMIC_S_XOR  */
  YYSYMBOL_T_OP_ATOMIC_G_ADD = 270,        /* T_OP_ATOMIC_G_ADD  */
  YYSYMBOL_T_OP_ATOMIC_G_SUB = 271,        /* T_OP_ATOMIC_G_SUB  */
  YYSYMBOL_T_OP_ATOMIC_G_XCHG = 272,       /* T_OP_ATOMIC_G_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_G_INC = 273,        /* T_OP_ATOMIC_G_INC  */
  YYSYMBOL_T_OP_ATOMIC_G_DEC = 274,        /* T_OP_ATOMIC_G_DEC  */
  YYSYMBOL_T_OP_ATOMIC_G_CMPXCHG = 275,    /* T_OP_ATOMIC_G_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_G_MIN = 276,        /* T_OP_ATOMIC_G_MIN  */
  YYSYMBOL_T_OP_ATOMIC_G_MAX = 277,        /* T_OP_ATOMIC_G_MAX  */
  YYSYMBOL_T_OP_ATOMIC_G_AND = 278,        /* T_OP_ATOMIC_G_AND  */
  YYSYMBOL_T_OP_ATOMIC_G_OR = 279,         /* T_OP_ATOMIC_G_OR  */
  YYSYMBOL_T_OP_ATOMIC_G_XOR = 280,        /* T_OP_ATOMIC_G_XOR  */
  YYSYMBOL_T_OP_LDGB = 281,                /* T_OP_LDGB  */
  YYSYMBOL_T_OP_STGB = 282,                /* T_OP_STGB  */
  YYSYMBOL_T_OP_STIB = 283,                /* T_OP_STIB  */
  YYSYMBOL_T_OP_LDC = 284,                 /* T_OP_LDC  */
  YYSYMBOL_T_OP_LDLV = 285,                /* T_OP_LDLV  */
  YYSYMBOL_T_OP_GETSPID = 286,             /* T_OP_GETSPID  */
  YYSYMBOL_T_OP_GETWID = 287,              /* T_OP_GETWID  */
  YYSYMBOL_T_OP_GETFIBERID = 288,          /* T_OP_GETFIBERID  */
  YYSYMBOL_T_OP_STC = 289,                 /* T_OP_STC  */
  YYSYMBOL_T_OP_STSC = 290,                /* T_OP_STSC  */
  YYSYMBOL_T_OP_SHFL = 291,                /* T_OP_SHFL  */
  YYSYMBOL_T_OP_RAY_INTERSECTION = 292,    /* T_OP_RAY_INTERSECTION  */
  YYSYMBOL_T_OP_BAR = 293,                 /* T_OP_BAR  */
  YYSYMBOL_T_OP_FENCE = 294,               /* T_OP_FENCE  */
  YYSYMBOL_T_OP_SLEEP = 295,               /* T_OP_SLEEP  */
  YYSYMBOL_T_OP_ICINV = 296,               /* T_OP_ICINV  */
  YYSYMBOL_T_OP_DCCLN = 297,               /* T_OP_DCCLN  */
  YYSYMBOL_T_OP_DCINV = 298,               /* T_OP_DCINV  */
  YYSYMBOL_T_OP_DCFLU = 299,               /* T_OP_DCFLU  */
  YYSYMBOL_T_OP_CCINV = 300,               /* T_OP_CCINV  */
  YYSYMBOL_T_OP_LOCK = 301,                /* T_OP_LOCK  */
  YYSYMBOL_T_OP_UNLOCK = 302,              /* T_OP_UNLOCK  */
  YYSYMBOL_T_OP_ALIAS = 303,               /* T_OP_ALIAS  */
  YYSYMBOL_T_RAW = 304,                    /* T_RAW  */
  YYSYMBOL_T_OP_PRINT = 305,               /* T_OP_PRINT  */
  YYSYMBOL_T_TYPE_F16 = 306,               /* T_TYPE_F16  */
  YYSYMBOL_T_TYPE_F32 = 307,               /* T_TYPE_F32  */
  YYSYMBOL_T_TYPE_U16 = 308,               /* T_TYPE_U16  */
  YYSYMBOL_T_TYPE_U32 = 309,               /* T_TYPE_U32  */
  YYSYMBOL_T_TYPE_S16 = 310,               /* T_TYPE_S16  */
  YYSYMBOL_T_TYPE_S32 = 311,               /* T_TYPE_S32  */
  YYSYMBOL_T_TYPE_U8 = 312,                /* T_TYPE_U8  */
  YYSYMBOL_T_TYPE_U8_32 = 313,             /* T_TYPE_U8_32  */
  YYSYMBOL_T_TYPE_U64 = 314,               /* T_TYPE_U64  */
  YYSYMBOL_T_TYPE_B16 = 315,               /* T_TYPE_B16  */
  YYSYMBOL_T_TYPE_B32 = 316,               /* T_TYPE_B32  */
  YYSYMBOL_T_UNTYPED = 317,                /* T_UNTYPED  */
  YYSYMBOL_T_TYPED = 318,                  /* T_TYPED  */
  YYSYMBOL_T_MIXED = 319,                  /* T_MIXED  */
  YYSYMBOL_T_UNSIGNED = 320,               /* T_UNSIGNED  */
  YYSYMBOL_T_LOW = 321,                    /* T_LOW  */
  YYSYMBOL_T_HIGH = 322,                   /* T_HIGH  */
  YYSYMBOL_T_1D = 323,                     /* T_1D  */
  YYSYMBOL_T_2D = 324,                     /* T_2D  */
  YYSYMBOL_T_3D = 325,                     /* T_3D  */
  YYSYMBOL_T_4D = 326,                     /* T_4D  */
  YYSYMBOL_T_LT = 327,                     /* T_LT  */
  YYSYMBOL_T_LE = 328,                     /* T_LE  */
  YYSYMBOL_T_GT = 329,                     /* T_GT  */
  YYSYMBOL_T_GE = 330,                     /* T_GE  */
  YYSYMBOL_T_EQ = 331,                     /* T_EQ  */
  YYSYMBOL_T_NE = 332,                     /* T_NE  */
  YYSYMBOL_T_S2EN = 333,                   /* T_S2EN  */
  YYSYMBOL_T_SAMP = 334,                   /* T_SAMP  */
  YYSYMBOL_T_TEX = 335,                    /* T_TEX  */
  YYSYMBOL_T_BASE = 336,                   /* T_BASE  */
  YYSYMBOL_T_OFFSET = 337,                 /* T_OFFSET  */
  YYSYMBOL_T_UNIFORM = 338,                /* T_UNIFORM  */
  YYSYMBOL_T_NONUNIFORM = 339,             /* T_NONUNIFORM  */
  YYSYMBOL_T_IMM = 340,                    /* T_IMM  */
  YYSYMBOL_T_NAN = 341,                    /* T_NAN  */
  YYSYMBOL_T_INF = 342,                    /* T_INF  */
  YYSYMBOL_T_A0 = 343,                     /* T_A0  */
  YYSYMBOL_T_A1 = 344,                     /* T_A1  */
  YYSYMBOL_T_P0 = 345,                     /* T_P0  */
  YYSYMBOL_T_W = 346,                      /* T_W  */
  YYSYMBOL_T_CAT1_TYPE_TYPE = 347,         /* T_CAT1_TYPE_TYPE  */
  YYSYMBOL_T_MOD_TEX = 348,                /* T_MOD_TEX  */
  YYSYMBOL_T_MOD_MEM = 349,                /* T_MOD_MEM  */
  YYSYMBOL_T_MOD_RT = 350,                 /* T_MOD_RT  */
  YYSYMBOL_T_MOD_XOR = 351,                /* T_MOD_XOR  */
  YYSYMBOL_T_MOD_UP = 352,                 /* T_MOD_UP  */
  YYSYMBOL_T_MOD_DOWN = 353,               /* T_MOD_DOWN  */
  YYSYMBOL_T_MOD_RUP = 354,                /* T_MOD_RUP  */
  YYSYMBOL_T_MOD_RDOWN = 355,              /* T_MOD_RDOWN  */
  YYSYMBOL_356_ = 356,                     /* '-'  */
  YYSYMBOL_357_ = 357,                     /* ','  */
  YYSYMBOL_358_ = 358,                     /* '('  */
  YYSYMBOL_359_ = 359,                     /* ')'  */
  YYSYMBOL_360_ = 360,                     /* '='  */
  YYSYMBOL_361_ = 361,                     /* ':'  */
  YYSYMBOL_362_ = 362,                     /* '!'  */
  YYSYMBOL_363_ = 363,                     /* '#'  */
  YYSYMBOL_364_ = 364,                     /* '.'  */
  YYSYMBOL_365_a_ = 365,                   /* 'a'  */
  YYSYMBOL_366_o_ = 366,                   /* 'o'  */
  YYSYMBOL_367_p_ = 367,                   /* 'p'  */
  YYSYMBOL_368_s_ = 368,                   /* 's'  */
  YYSYMBOL_369_v_ = 369,                   /* 'v'  */
  YYSYMBOL_370_ = 370,                     /* '+'  */
  YYSYMBOL_371_ = 371,                     /* '<'  */
  YYSYMBOL_372_g_ = 372,                   /* 'g'  */
  YYSYMBOL_373_ = 373,                     /* '['  */
  YYSYMBOL_374_ = 374,                     /* ']'  */
  YYSYMBOL_375_c_ = 375,                   /* 'c'  */
  YYSYMBOL_376_l_ = 376,                   /* 'l'  */
  YYSYMBOL_377_u_ = 377,                   /* 'u'  */
  YYSYMBOL_378_k_ = 378,                   /* 'k'  */
  YYSYMBOL_379_w_ = 379,                   /* 'w'  */
  YYSYMBOL_380_r_ = 380,                   /* 'r'  */
  YYSYMBOL_381_ = 381,                     /* '>'  */
  YYSYMBOL_382_h_ = 382,                   /* 'h'  */
  YYSYMBOL_YYACCEPT = 383,                 /* $accept  */
  YYSYMBOL_shader = 384,                   /* shader  */
  YYSYMBOL_385_1 = 385,                    /* $@1  */
  YYSYMBOL_headers = 386,                  /* headers  */
  YYSYMBOL_header = 387,                   /* header  */
  YYSYMBOL_const_val = 388,                /* const_val  */
  YYSYMBOL_localsize_header = 389,         /* localsize_header  */
  YYSYMBOL_const_header = 390,             /* const_header  */
  YYSYMBOL_buf_header_init_val = 391,      /* buf_header_init_val  */
  YYSYMBOL_buf_header_init_vals = 392,     /* buf_header_init_vals  */
  YYSYMBOL_buf_header_addr_reg = 393,      /* buf_header_addr_reg  */
  YYSYMBOL_buf_type = 394,                 /* buf_type  */
  YYSYMBOL_buf_header = 395,               /* buf_header  */
  YYSYMBOL_396_2 = 396,                    /* $@2  */
  YYSYMBOL_invocationid_header = 397,      /* invocationid_header  */
  YYSYMBOL_wgid_header = 398,              /* wgid_header  */
  YYSYMBOL_numwg_header = 399,             /* numwg_header  */
  YYSYMBOL_branchstack_header = 400,       /* branchstack_header  */
  YYSYMBOL_pvtmem_header = 401,            /* pvtmem_header  */
  YYSYMBOL_localmem_header = 402,          /* localmem_header  */
  YYSYMBOL_earlypreamble_header = 403,     /* earlypreamble_header  */
  YYSYMBOL_in_header = 404,                /* in_header  */
  YYSYMBOL_out_header = 405,               /* out_header  */
  YYSYMBOL_tex_header_opc = 406,           /* tex_header_opc  */
  YYSYMBOL_tex_header = 407,               /* tex_header  */
  YYSYMBOL_fullnop_start_section = 408,    /* fullnop_start_section  */
  YYSYMBOL_fullnop_end_section = 409,      /* fullnop_end_section  */
  YYSYMBOL_fullsync_start_section = 410,   /* fullsync_start_section  */
  YYSYMBOL_fullsync_end_section = 411,     /* fullsync_end_section  */
  YYSYMBOL_iflag = 412,                    /* iflag  */
  YYSYMBOL_iflags = 413,                   /* iflags  */
  YYSYMBOL_instrs = 414,                   /* instrs  */
  YYSYMBOL_instr = 415,                    /* instr  */
  YYSYMBOL_label = 416,                    /* label  */
  YYSYMBOL_cat0_src1 = 417,                /* cat0_src1  */
  YYSYMBOL_cat0_src2 = 418,                /* cat0_src2  */
  YYSYMBOL_cat0_immed = 419,               /* cat0_immed  */
  YYSYMBOL_cat0_instr = 420,               /* cat0_instr  */
  YYSYMBOL_421_3 = 421,                    /* $@3  */
  YYSYMBOL_422_4 = 422,                    /* $@4  */
  YYSYMBOL_423_5 = 423,                    /* $@5  */
  YYSYMBOL_424_6 = 424,                    /* $@6  */
  YYSYMBOL_425_7 = 425,                    /* $@7  */
  YYSYMBOL_426_8 = 426,                    /* $@8  */
  YYSYMBOL_427_9 = 427,                    /* $@9  */
  YYSYMBOL_428_10 = 428,                   /* $@10  */
  YYSYMBOL_429_11 = 429,                   /* $@11  */
  YYSYMBOL_430_12 = 430,                   /* $@12  */
  YYSYMBOL_431_13 = 431,                   /* $@13  */
  YYSYMBOL_432_14 = 432,                   /* $@14  */
  YYSYMBOL_433_15 = 433,                   /* $@15  */
  YYSYMBOL_434_16 = 434,                   /* $@16  */
  YYSYMBOL_cat1_opc = 435,                 /* cat1_opc  */
  YYSYMBOL_cat1_src = 436,                 /* cat1_src  */
  YYSYMBOL_cat1_movmsk = 437,              /* cat1_movmsk  */
  YYSYMBOL_438_17 = 438,                   /* $@17  */
  YYSYMBOL_mova_src = 439,                 /* mova_src  */
  YYSYMBOL_cat1_mova1 = 440,               /* cat1_mova1  */
  YYSYMBOL_441_18 = 441,                   /* $@18  */
  YYSYMBOL_cat1_mova = 442,                /* cat1_mova  */
  YYSYMBOL_443_19 = 443,                   /* $@19  */
  YYSYMBOL_cat1_swz = 444,                 /* cat1_swz  */
  YYSYMBOL_445_20 = 445,                   /* $@20  */
  YYSYMBOL_cat1_gat = 446,                 /* cat1_gat  */
  YYSYMBOL_447_21 = 447,                   /* $@21  */
  YYSYMBOL_cat1_sct = 448,                 /* cat1_sct  */
  YYSYMBOL_449_22 = 449,                   /* $@22  */
  YYSYMBOL_movs_invocation = 450,          /* movs_invocation  */
  YYSYMBOL_cat1_movs = 451,                /* cat1_movs  */
  YYSYMBOL_452_23 = 452,                   /* $@23  */
  YYSYMBOL_cat1_instr = 453,               /* cat1_instr  */
  YYSYMBOL_cat2_opc_1src = 454,            /* cat2_opc_1src  */
  YYSYMBOL_cat2_opc_2src_cnd = 455,        /* cat2_opc_2src_cnd  */
  YYSYMBOL_cat2_opc_2src = 456,            /* cat2_opc_2src  */
  YYSYMBOL_cond = 457,                     /* cond  */
  YYSYMBOL_cat2_instr = 458,               /* cat2_instr  */
  YYSYMBOL_cat3_dp_signedness = 459,       /* cat3_dp_signedness  */
  YYSYMBOL_cat3_dp_pack = 460,             /* cat3_dp_pack  */
  YYSYMBOL_cat3_opc = 461,                 /* cat3_opc  */
  YYSYMBOL_cat3_imm_reg_opc = 462,         /* cat3_imm_reg_opc  */
  YYSYMBOL_cat3_wmm = 463,                 /* cat3_wmm  */
  YYSYMBOL_cat3_dp = 464,                  /* cat3_dp  */
  YYSYMBOL_cat3_instr = 465,               /* cat3_instr  */
  YYSYMBOL_cat4_opc = 466,                 /* cat4_opc  */
  YYSYMBOL_cat4_instr = 467,               /* cat4_instr  */
  YYSYMBOL_cat5_opc_dsxypp = 468,          /* cat5_opc_dsxypp  */
  YYSYMBOL_cat5_opc_isam = 469,            /* cat5_opc_isam  */
  YYSYMBOL_cat5_opc = 470,                 /* cat5_opc  */
  YYSYMBOL_cat5_flag = 471,                /* cat5_flag  */
  YYSYMBOL_cat5_flags = 472,               /* cat5_flags  */
  YYSYMBOL_cat5_samp = 473,                /* cat5_samp  */
  YYSYMBOL_cat5_tex = 474,                 /* cat5_tex  */
  YYSYMBOL_cat5_type = 475,                /* cat5_type  */
  YYSYMBOL_cat5_a1 = 476,                  /* cat5_a1  */
  YYSYMBOL_cat5_samp_tex = 477,            /* cat5_samp_tex  */
  YYSYMBOL_cat5_samp_tex_all = 478,        /* cat5_samp_tex_all  */
  YYSYMBOL_cat5_instr = 479,               /* cat5_instr  */
  YYSYMBOL_cat6_typed = 480,               /* cat6_typed  */
  YYSYMBOL_cat6_dim = 481,                 /* cat6_dim  */
  YYSYMBOL_cat6_type = 482,                /* cat6_type  */
  YYSYMBOL_cat6_imm_offset = 483,          /* cat6_imm_offset  */
  YYSYMBOL_cat6_offset = 484,              /* cat6_offset  */
  YYSYMBOL_cat6_dst_offset = 485,          /* cat6_dst_offset  */
  YYSYMBOL_cat6_immed = 486,               /* cat6_immed  */
  YYSYMBOL_cat6_src_shift = 487,           /* cat6_src_shift  */
  YYSYMBOL_cat6_a6xx_global_address_pt2 = 488, /* cat6_a6xx_global_address_pt2  */
  YYSYMBOL_cat6_a6xx_global_address = 489, /* cat6_a6xx_global_address  */
  YYSYMBOL_cat6_load = 490,                /* cat6_load  */
  YYSYMBOL_491_24 = 491,                   /* $@24  */
  YYSYMBOL_492_25 = 492,                   /* $@25  */
  YYSYMBOL_493_26 = 493,                   /* $@26  */
  YYSYMBOL_494_27 = 494,                   /* $@27  */
  YYSYMBOL_495_28 = 495,                   /* $@28  */
  YYSYMBOL_496_29 = 496,                   /* $@29  */
  YYSYMBOL_497_30 = 497,                   /* $@30  */
  YYSYMBOL_498_31 = 498,                   /* $@31  */
  YYSYMBOL_cat6_store = 499,               /* cat6_store  */
  YYSYMBOL_500_32 = 500,                   /* $@32  */
  YYSYMBOL_501_33 = 501,                   /* $@33  */
  YYSYMBOL_502_34 = 502,                   /* $@34  */
  YYSYMBOL_503_35 = 503,                   /* $@35  */
  YYSYMBOL_504_36 = 504,                   /* $@36  */
  YYSYMBOL_cat6_loadib = 505,              /* cat6_loadib  */
  YYSYMBOL_506_37 = 506,                   /* $@37  */
  YYSYMBOL_cat6_storeib = 507,             /* cat6_storeib  */
  YYSYMBOL_508_38 = 508,                   /* $@38  */
  YYSYMBOL_cat6_prefetch = 509,            /* cat6_prefetch  */
  YYSYMBOL_510_39 = 510,                   /* $@39  */
  YYSYMBOL_cat6_atomic_opc = 511,          /* cat6_atomic_opc  */
  YYSYMBOL_cat6_a3xx_atomic_opc = 512,     /* cat6_a3xx_atomic_opc  */
  YYSYMBOL_cat6_a6xx_atomic_opc = 513,     /* cat6_a6xx_atomic_opc  */
  YYSYMBOL_cat6_a3xx_atomic_s = 514,       /* cat6_a3xx_atomic_s  */
  YYSYMBOL_cat6_a6xx_atomic_g = 515,       /* cat6_a6xx_atomic_g  */
  YYSYMBOL_cat6_atomic_l = 516,            /* cat6_atomic_l  */
  YYSYMBOL_cat6_atomic = 517,              /* cat6_atomic  */
  YYSYMBOL_cat6_ibo_opc_1src = 518,        /* cat6_ibo_opc_1src  */
  YYSYMBOL_cat6_ibo_opc_ldgb = 519,        /* cat6_ibo_opc_ldgb  */
  YYSYMBOL_cat6_ibo_opc_stgb = 520,        /* cat6_ibo_opc_stgb  */
  YYSYMBOL_cat6_ibo = 521,                 /* cat6_ibo  */
  YYSYMBOL_522_40 = 522,                   /* $@40  */
  YYSYMBOL_cat6_id_opc = 523,              /* cat6_id_opc  */
  YYSYMBOL_cat6_id = 524,                  /* cat6_id  */
  YYSYMBOL_cat6_bindless_base = 525,       /* cat6_bindless_base  */
  YYSYMBOL_cat6_bindless_mode = 526,       /* cat6_bindless_mode  */
  YYSYMBOL_cat6_reg_or_immed = 527,        /* cat6_reg_or_immed  */
  YYSYMBOL_cat6_bindless_ibo_opc_1src = 528, /* cat6_bindless_ibo_opc_1src  */
  YYSYMBOL_cat6_bindless_ibo_opc_2src = 529, /* cat6_bindless_ibo_opc_2src  */
  YYSYMBOL_cat6_bindless_ibo_opc_3src = 530, /* cat6_bindless_ibo_opc_3src  */
  YYSYMBOL_cat6_bindless_ibo_opc_3src_dst = 531, /* cat6_bindless_ibo_opc_3src_dst  */
  YYSYMBOL_cat6_bindless_ibo = 532,        /* cat6_bindless_ibo  */
  YYSYMBOL_cat6_bindless_ldc_opc = 533,    /* cat6_bindless_ldc_opc  */
  YYSYMBOL_cat6_bindless_ldc_middle = 534, /* cat6_bindless_ldc_middle  */
  YYSYMBOL_cat6_bindless_ldc = 535,        /* cat6_bindless_ldc  */
  YYSYMBOL_const_dst = 536,                /* const_dst  */
  YYSYMBOL_cat6_stc = 537,                 /* cat6_stc  */
  YYSYMBOL_538_41 = 538,                   /* $@41  */
  YYSYMBOL_539_42 = 539,                   /* $@42  */
  YYSYMBOL_cat6_shfl_mode = 540,           /* cat6_shfl_mode  */
  YYSYMBOL_cat6_shfl = 541,                /* cat6_shfl  */
  YYSYMBOL_542_43 = 542,                   /* $@43  */
  YYSYMBOL_cat6_ray_intersection = 543,    /* cat6_ray_intersection  */
  YYSYMBOL_544_44 = 544,                   /* $@44  */
  YYSYMBOL_cat6_todo = 545,                /* cat6_todo  */
  YYSYMBOL_cat6_instr = 546,               /* cat6_instr  */
  YYSYMBOL_cat7_scope = 547,               /* cat7_scope  */
  YYSYMBOL_cat7_scopes = 548,              /* cat7_scopes  */
  YYSYMBOL_cat7_barrier = 549,             /* cat7_barrier  */
  YYSYMBOL_550_45 = 550,                   /* $@45  */
  YYSYMBOL_551_46 = 551,                   /* $@46  */
  YYSYMBOL_cat7_data_cache = 552,          /* cat7_data_cache  */
  YYSYMBOL_cat7_alias_dst = 553,           /* cat7_alias_dst  */
  YYSYMBOL_cat7_alias_src = 554,           /* cat7_alias_src  */
  YYSYMBOL_cat7_alias_scope = 555,         /* cat7_alias_scope  */
  YYSYMBOL_cat7_alias_int_type = 556,      /* cat7_alias_int_type  */
  YYSYMBOL_cat7_alias_float_type = 557,    /* cat7_alias_float_type  */
  YYSYMBOL_cat7_alias_type = 558,          /* cat7_alias_type  */
  YYSYMBOL_cat7_alias_table_size_minus_one = 559, /* cat7_alias_table_size_minus_one  */
  YYSYMBOL_cat7_instr = 560,               /* cat7_instr  */
  YYSYMBOL_561_47 = 561,                   /* $@47  */
  YYSYMBOL_raw_instr = 562,                /* raw_instr  */
  YYSYMBOL_meta_print_regs = 563,          /* meta_print_regs  */
  YYSYMBOL_meta_print_reg = 564,           /* meta_print_reg  */
  YYSYMBOL_meta_print_start = 565,         /* meta_print_start  */
  YYSYMBOL_meta_print = 566,               /* meta_print  */
  YYSYMBOL_src_gpr = 567,                  /* src_gpr  */
  YYSYMBOL_src_a0 = 568,                   /* src_a0  */
  YYSYMBOL_src_a1 = 569,                   /* src_a1  */
  YYSYMBOL_src_p0 = 570,                   /* src_p0  */
  YYSYMBOL_src = 571,                      /* src  */
  YYSYMBOL_dst = 572,                      /* dst  */
  YYSYMBOL_const = 573,                    /* const  */
  YYSYMBOL_dst_reg_flag = 574,             /* dst_reg_flag  */
  YYSYMBOL_dst_reg_flags = 575,            /* dst_reg_flags  */
  YYSYMBOL_dst_reg = 576,                  /* dst_reg  */
  YYSYMBOL_src_reg_flag = 577,             /* src_reg_flag  */
  YYSYMBOL_src_reg_flags = 578,            /* src_reg_flags  */
  YYSYMBOL_src_reg = 579,                  /* src_reg  */
  YYSYMBOL_src_reg_gpr = 580,              /* src_reg_gpr  */
  YYSYMBOL_src_const = 581,                /* src_const  */
  YYSYMBOL_src_reg_or_const = 582,         /* src_reg_or_const  */
  YYSYMBOL_src_reg_or_const_or_rel = 583,  /* src_reg_or_const_or_rel  */
  YYSYMBOL_src_reg_or_const_or_rel_or_imm = 584, /* src_reg_or_const_or_rel_or_imm  */
  YYSYMBOL_src_reg_or_rel_or_imm = 585,    /* src_reg_or_rel_or_imm  */
  YYSYMBOL_uoffset = 586,                  /* uoffset  */
  YYSYMBOL_offset = 587,                   /* offset  */
  YYSYMBOL_src_uoffset = 588,              /* src_uoffset  */
  YYSYMBOL_relative_gpr_src = 589,         /* relative_gpr_src  */
  YYSYMBOL_relative_gpr_dst = 590,         /* relative_gpr_dst  */
  YYSYMBOL_relative_const = 591,           /* relative_const  */
  YYSYMBOL_relative = 592,                 /* relative  */
  YYSYMBOL_immediate_cat1 = 593,           /* immediate_cat1  */
  YYSYMBOL_immediate = 594,                /* immediate  */
  YYSYMBOL_flut_immed = 595,               /* flut_immed  */
  YYSYMBOL_uinteger = 596,                 /* uinteger  */
  YYSYMBOL_integer = 597,                  /* integer  */
  YYSYMBOL_float = 598,                    /* float  */
  YYSYMBOL_type = 599                      /* type  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 383 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"

#if YYDEBUG
static void print_token(FILE *file, int type, YYSTYPE value)
{
	fprintf(file, "\ntype: %d\n", type);
}

#define YYPRINT(file, type, value) print_token(file, type, value)
#endif

#line 1058 "src/freedreno/ir3/ir3_parser.c"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1710

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  383
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  217
/* YYNRULES -- Number of rules.  */
#define YYNRULES  639
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1350

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   610


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   362,     2,   363,     2,     2,     2,     2,
     358,   359,     2,   370,   357,   356,   364,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   361,     2,
     371,   360,   381,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   373,     2,   374,     2,     2,     2,   365,     2,   375,
       2,     2,     2,   372,   382,     2,     2,   378,   376,     2,
       2,   366,   367,     2,   380,   368,     2,   377,   369,   379,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   808,   808,   808,   810,   811,   813,   814,   815,   816,
     817,   818,   819,   820,   821,   822,   823,   824,   825,   827,
     828,   829,   830,   832,   838,   842,   843,   844,   845,   848,
     856,   858,   859,   861,   861,   868,   874,   881,   888,   897,
     899,   901,   903,   906,   908,   911,   913,   921,   922,   923,
     924,   926,   927,   928,   929,   930,   931,   932,   933,   935,
     936,   938,   939,   941,   942,   943,   944,   945,   946,   947,
     948,   949,   950,   951,   952,   953,   954,   955,   957,   959,
     960,   962,   963,   965,   966,   968,   969,   969,   970,   970,
     971,   971,   972,   972,   973,   973,   974,   974,   975,   975,
     976,   976,   977,   977,   978,   979,   979,   980,   981,   982,
     983,   984,   985,   986,   986,   987,   988,   989,   990,   991,
     991,   992,   993,   993,   994,   995,   996,   997,   998,   998,
    1000,  1003,  1007,  1008,  1010,  1010,  1026,  1027,  1028,  1030,
    1030,  1037,  1037,  1044,  1044,  1046,  1046,  1048,  1048,  1050,
    1051,  1053,  1053,  1056,  1057,  1058,  1059,  1060,  1061,  1062,
    1063,  1064,  1066,  1067,  1068,  1069,  1070,  1071,  1072,  1073,
    1074,  1075,  1076,  1077,  1078,  1079,  1081,  1082,  1083,  1084,
    1085,  1086,  1088,  1089,  1090,  1091,  1092,  1093,  1094,  1095,
    1096,  1097,  1098,  1099,  1100,  1101,  1102,  1103,  1104,  1105,
    1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,  1116,
    1117,  1118,  1119,  1120,  1121,  1123,  1124,  1125,  1127,  1128,
    1130,  1131,  1133,  1134,  1135,  1136,  1137,  1138,  1139,  1140,
    1141,  1142,  1143,  1144,  1145,  1146,  1147,  1148,  1150,  1151,
    1152,  1153,  1154,  1156,  1157,  1159,  1160,  1162,  1163,  1164,
    1165,  1167,  1168,  1169,  1170,  1171,  1172,  1173,  1174,  1175,
    1176,  1178,  1180,  1181,  1183,  1185,  1186,  1187,  1188,  1189,
    1190,  1191,  1192,  1193,  1194,  1195,  1196,  1197,  1198,  1199,
    1200,  1201,  1202,  1203,  1204,  1205,  1206,  1207,  1208,  1209,
    1210,  1211,  1212,  1213,  1214,  1216,  1217,  1218,  1219,  1220,
    1221,  1222,  1223,  1224,  1225,  1226,  1227,  1228,  1230,  1231,
    1232,  1233,  1235,  1236,  1237,  1238,  1240,  1241,  1242,  1243,
    1245,  1246,  1247,  1248,  1249,  1250,  1251,  1252,  1253,  1255,
    1256,  1258,  1259,  1260,  1261,  1263,  1264,  1265,  1266,  1267,
    1268,  1270,  1272,  1273,  1276,  1281,  1286,  1292,  1304,  1306,
    1306,  1307,  1307,  1308,  1308,  1309,  1309,  1310,  1310,  1311,
    1311,  1312,  1312,  1312,  1316,  1316,  1317,  1317,  1318,  1318,
    1319,  1319,  1320,  1320,  1322,  1322,  1323,  1323,  1325,  1325,
    1327,  1328,  1329,  1330,  1331,  1332,  1333,  1334,  1335,  1336,
    1337,  1339,  1340,  1341,  1342,  1343,  1344,  1345,  1346,  1347,
    1348,  1349,  1351,  1352,  1353,  1354,  1355,  1356,  1357,  1358,
    1359,  1360,  1361,  1363,  1365,  1367,  1369,  1370,  1371,  1373,
    1375,  1376,  1378,  1379,  1380,  1380,  1383,  1384,  1385,  1387,
    1389,  1390,  1392,  1393,  1394,  1396,  1397,  1399,  1400,  1402,
    1403,  1404,  1405,  1406,  1407,  1408,  1409,  1410,  1411,  1412,
    1414,  1416,  1418,  1419,  1420,  1421,  1423,  1427,  1428,  1429,
    1431,  1437,  1438,  1439,  1442,  1442,  1443,  1443,  1445,  1446,
    1447,  1448,  1449,  1453,  1456,  1456,  1458,  1458,  1462,  1463,
    1464,  1466,  1467,  1468,  1469,  1470,  1471,  1472,  1473,  1474,
    1475,  1476,  1477,  1478,  1479,  1481,  1482,  1483,  1484,  1486,
    1487,  1489,  1489,  1490,  1490,  1492,  1493,  1494,  1496,  1497,
    1499,  1500,  1502,  1503,  1504,  1506,  1507,  1509,  1510,  1512,
    1513,  1515,  1517,  1518,  1519,  1520,  1521,  1522,  1523,  1524,
    1524,  1528,  1530,  1531,  1533,  1537,  1544,  1602,  1603,  1604,
    1605,  1607,  1608,  1609,  1610,  1612,  1613,  1614,  1615,  1617,
    1619,  1620,  1621,  1622,  1623,  1625,  1626,  1629,  1630,  1632,
    1633,  1634,  1635,  1636,  1638,  1639,  1641,  1642,  1644,  1645,
    1647,  1648,  1650,  1651,  1653,  1654,  1655,  1657,  1658,  1659,
    1661,  1662,  1663,  1665,  1666,  1668,  1669,  1671,  1673,  1674,
    1676,  1677,  1679,  1680,  1682,  1683,  1692,  1693,  1694,  1695,
    1696,  1697,  1698,  1699,  1700,  1701,  1702,  1703,  1705,  1706,
    1707,  1708,  1709,  1712,  1713,  1714,  1715,  1716,  1717,  1718,
    1719,  1720,  1721,  1722,  1723,  1725,  1726,  1728,  1729,  1731,
    1732,  1734,  1735,  1736,  1737,  1738,  1739,  1740,  1741,  1742
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "T_INT", "T_HEX",
  "T_FLOAT", "T_IDENTIFIER", "T_REGISTER", "T_CONSTANT", "T_RT",
  "T_A_LOCALSIZE", "T_A_CONST", "T_A_BUF", "T_A_UBO", "T_A_INVOCATIONID",
  "T_A_WGID", "T_A_NUMWG", "T_A_BRANCHSTACK", "T_A_IN", "T_A_OUT",
  "T_A_TEX", "T_A_PVTMEM", "T_A_LOCALMEM", "T_A_EARLYPREAMBLE",
  "T_A_FULLNOPSTART", "T_A_FULLNOPEND", "T_A_FULLSYNCSTART",
  "T_A_FULLSYNCEND", "T_ABSNEG", "T_NEG", "T_ABS", "T_R", "T_LAST", "T_HR",
  "T_HC", "T_EVEN", "T_POS_INFINITY", "T_NEG_INFINITY", "T_EI", "T_WRMASK",
  "T_FLUT_0_0", "T_FLUT_0_5", "T_FLUT_1_0", "T_FLUT_2_0", "T_FLUT_E",
  "T_FLUT_PI", "T_FLUT_INV_PI", "T_FLUT_INV_LOG2_E", "T_FLUT_LOG2_E",
  "T_FLUT_INV_LOG2_10", "T_FLUT_LOG2_10", "T_FLUT_4_0", "T_SY", "T_SS",
  "T_JP", "T_EQ_FLAG", "T_SAT", "T_RPT", "T_UL", "T_NOP", "T_OP_NOP",
  "T_OP_BR", "T_OP_BRAO", "T_OP_BRAA", "T_OP_BRAC", "T_OP_BANY",
  "T_OP_BALL", "T_OP_BRAX", "T_OP_JUMP", "T_OP_CALL", "T_OP_RET",
  "T_OP_KILL", "T_OP_END", "T_OP_EMIT", "T_OP_CUT", "T_OP_CHMASK",
  "T_OP_CHSH", "T_OP_FLOW_REV", "T_OP_BKT", "T_OP_STKS", "T_OP_STKR",
  "T_OP_XSET", "T_OP_XCLR", "T_OP_GETLAST", "T_OP_GETONE", "T_OP_DBG",
  "T_OP_SHPS", "T_OP_SHPE", "T_OP_PREDT", "T_OP_PREDF", "T_OP_PREDE",
  "T_OP_MOVMSK", "T_OP_MOVA1", "T_OP_MOVA", "T_OP_MOV", "T_OP_COV",
  "T_OP_SWZ", "T_OP_GAT", "T_OP_SCT", "T_OP_MOVS", "T_OP_ADD_F",
  "T_OP_MIN_F", "T_OP_MAX_F", "T_OP_MUL_F", "T_OP_SIGN_F", "T_OP_CMPS_F",
  "T_OP_ABSNEG_F", "T_OP_CMPV_F", "T_OP_FLOOR_F", "T_OP_CEIL_F",
  "T_OP_RNDNE_F", "T_OP_RNDAZ_F", "T_OP_TRUNC_F", "T_OP_ADD_U",
  "T_OP_ADD_S", "T_OP_SUB_U", "T_OP_SUB_S", "T_OP_CMPS_U", "T_OP_CMPS_S",
  "T_OP_MIN_U", "T_OP_MIN_S", "T_OP_MAX_U", "T_OP_MAX_S", "T_OP_ABSNEG_S",
  "T_OP_AND_B", "T_OP_OR_B", "T_OP_NOT_B", "T_OP_XOR_B", "T_OP_CMPV_U",
  "T_OP_CMPV_S", "T_OP_MUL_U24", "T_OP_MUL_S24", "T_OP_MULL_U",
  "T_OP_BFREV_B", "T_OP_CLZ_S", "T_OP_CLZ_B", "T_OP_SHL_B", "T_OP_SHR_B",
  "T_OP_ASHR_B", "T_OP_BARY_F", "T_OP_FLAT_B", "T_OP_MGEN_B",
  "T_OP_GETBIT_B", "T_OP_SETRM", "T_OP_CBITS_B", "T_OP_SHB", "T_OP_MSAD",
  "T_OP_MAD_U16", "T_OP_MADSH_U16", "T_OP_MAD_S16", "T_OP_MADSH_M16",
  "T_OP_MAD_U24", "T_OP_MAD_S24", "T_OP_MAD_F16", "T_OP_MAD_F32",
  "T_OP_SEL_B16", "T_OP_SEL_B32", "T_OP_SEL_S16", "T_OP_SEL_S32",
  "T_OP_SEL_F16", "T_OP_SEL_F32", "T_OP_SAD_S16", "T_OP_SAD_S32",
  "T_OP_SHRM", "T_OP_SHLM", "T_OP_SHRG", "T_OP_SHLG", "T_OP_ANDG",
  "T_OP_DP2ACC", "T_OP_DP4ACC", "T_OP_WMM", "T_OP_WMM_ACCU", "T_OP_RCP",
  "T_OP_RSQ", "T_OP_LOG2", "T_OP_EXP2", "T_OP_SIN", "T_OP_COS",
  "T_OP_SQRT", "T_OP_HRSQ", "T_OP_HLOG2", "T_OP_HEXP2", "T_OP_ISAM",
  "T_OP_ISAML", "T_OP_ISAMM", "T_OP_SAM", "T_OP_SAMB", "T_OP_SAML",
  "T_OP_SAMGQ", "T_OP_GETLOD", "T_OP_CONV", "T_OP_CONVM", "T_OP_GETSIZE",
  "T_OP_GETBUF", "T_OP_GETPOS", "T_OP_GETINFO", "T_OP_DSX", "T_OP_DSY",
  "T_OP_GATHER4R", "T_OP_GATHER4G", "T_OP_GATHER4B", "T_OP_GATHER4A",
  "T_OP_SAMGP0", "T_OP_SAMGP1", "T_OP_SAMGP2", "T_OP_SAMGP3",
  "T_OP_DSXPP_1", "T_OP_DSYPP_1", "T_OP_RGETPOS", "T_OP_RGETINFO",
  "T_OP_BRCST_A", "T_OP_QSHUFFLE_BRCST", "T_OP_QSHUFFLE_H",
  "T_OP_QSHUFFLE_V", "T_OP_QSHUFFLE_DIAG", "T_OP_TCINV", "T_OP_LDG",
  "T_OP_LDG_A", "T_OP_LDG_K", "T_OP_LDL", "T_OP_LDP", "T_OP_STG",
  "T_OP_STG_A", "T_OP_STL", "T_OP_STP", "T_OP_LDIB", "T_OP_G2L",
  "T_OP_L2G", "T_OP_PREFETCH", "T_OP_LDLW", "T_OP_STLW", "T_OP_RESFMT",
  "T_OP_RESINFO", "T_OP_RESBASE", "T_OP_ATOMIC_ADD", "T_OP_ATOMIC_SUB",
  "T_OP_ATOMIC_XCHG", "T_OP_ATOMIC_INC", "T_OP_ATOMIC_DEC",
  "T_OP_ATOMIC_CMPXCHG", "T_OP_ATOMIC_MIN", "T_OP_ATOMIC_MAX",
  "T_OP_ATOMIC_AND", "T_OP_ATOMIC_OR", "T_OP_ATOMIC_XOR", "T_OP_RESINFO_B",
  "T_OP_LDIB_B", "T_OP_STIB_B", "T_OP_ATOMIC_B_ADD", "T_OP_ATOMIC_B_SUB",
  "T_OP_ATOMIC_B_XCHG", "T_OP_ATOMIC_B_INC", "T_OP_ATOMIC_B_DEC",
  "T_OP_ATOMIC_B_CMPXCHG", "T_OP_ATOMIC_B_MIN", "T_OP_ATOMIC_B_MAX",
  "T_OP_ATOMIC_B_AND", "T_OP_ATOMIC_B_OR", "T_OP_ATOMIC_B_XOR",
  "T_OP_ATOMIC_S_ADD", "T_OP_ATOMIC_S_SUB", "T_OP_ATOMIC_S_XCHG",
  "T_OP_ATOMIC_S_INC", "T_OP_ATOMIC_S_DEC", "T_OP_ATOMIC_S_CMPXCHG",
  "T_OP_ATOMIC_S_MIN", "T_OP_ATOMIC_S_MAX", "T_OP_ATOMIC_S_AND",
  "T_OP_ATOMIC_S_OR", "T_OP_ATOMIC_S_XOR", "T_OP_ATOMIC_G_ADD",
  "T_OP_ATOMIC_G_SUB", "T_OP_ATOMIC_G_XCHG", "T_OP_ATOMIC_G_INC",
  "T_OP_ATOMIC_G_DEC", "T_OP_ATOMIC_G_CMPXCHG", "T_OP_ATOMIC_G_MIN",
  "T_OP_ATOMIC_G_MAX", "T_OP_ATOMIC_G_AND", "T_OP_ATOMIC_G_OR",
  "T_OP_ATOMIC_G_XOR", "T_OP_LDGB", "T_OP_STGB", "T_OP_STIB", "T_OP_LDC",
  "T_OP_LDLV", "T_OP_GETSPID", "T_OP_GETWID", "T_OP_GETFIBERID",
  "T_OP_STC", "T_OP_STSC", "T_OP_SHFL", "T_OP_RAY_INTERSECTION",
  "T_OP_BAR", "T_OP_FENCE", "T_OP_SLEEP", "T_OP_ICINV", "T_OP_DCCLN",
  "T_OP_DCINV", "T_OP_DCFLU", "T_OP_CCINV", "T_OP_LOCK", "T_OP_UNLOCK",
  "T_OP_ALIAS", "T_RAW", "T_OP_PRINT", "T_TYPE_F16", "T_TYPE_F32",
  "T_TYPE_U16", "T_TYPE_U32", "T_TYPE_S16", "T_TYPE_S32", "T_TYPE_U8",
  "T_TYPE_U8_32", "T_TYPE_U64", "T_TYPE_B16", "T_TYPE_B32", "T_UNTYPED",
  "T_TYPED", "T_MIXED", "T_UNSIGNED", "T_LOW", "T_HIGH", "T_1D", "T_2D",
  "T_3D", "T_4D", "T_LT", "T_LE", "T_GT", "T_GE", "T_EQ", "T_NE", "T_S2EN",
  "T_SAMP", "T_TEX", "T_BASE", "T_OFFSET", "T_UNIFORM", "T_NONUNIFORM",
  "T_IMM", "T_NAN", "T_INF", "T_A0", "T_A1", "T_P0", "T_W",
  "T_CAT1_TYPE_TYPE", "T_MOD_TEX", "T_MOD_MEM", "T_MOD_RT", "T_MOD_XOR",
  "T_MOD_UP", "T_MOD_DOWN", "T_MOD_RUP", "T_MOD_RDOWN", "'-'", "','",
  "'('", "')'", "'='", "':'", "'!'", "'#'", "'.'", "'a'", "'o'", "'p'",
  "'s'", "'v'", "'+'", "'<'", "'g'", "'['", "']'", "'c'", "'l'", "'u'",
  "'k'", "'w'", "'r'", "'>'", "'h'", "$accept", "shader", "$@1", "headers",
  "header", "const_val", "localsize_header", "const_header",
  "buf_header_init_val", "buf_header_init_vals", "buf_header_addr_reg",
  "buf_type", "buf_header", "$@2", "invocationid_header", "wgid_header",
  "numwg_header", "branchstack_header", "pvtmem_header", "localmem_header",
  "earlypreamble_header", "in_header", "out_header", "tex_header_opc",
  "tex_header", "fullnop_start_section", "fullnop_end_section",
  "fullsync_start_section", "fullsync_end_section", "iflag", "iflags",
  "instrs", "instr", "label", "cat0_src1", "cat0_src2", "cat0_immed",
  "cat0_instr", "$@3", "$@4", "$@5", "$@6", "$@7", "$@8", "$@9", "$@10",
  "$@11", "$@12", "$@13", "$@14", "$@15", "$@16", "cat1_opc", "cat1_src",
  "cat1_movmsk", "$@17", "mova_src", "cat1_mova1", "$@18", "cat1_mova",
  "$@19", "cat1_swz", "$@20", "cat1_gat", "$@21", "cat1_sct", "$@22",
  "movs_invocation", "cat1_movs", "$@23", "cat1_instr", "cat2_opc_1src",
  "cat2_opc_2src_cnd", "cat2_opc_2src", "cond", "cat2_instr",
  "cat3_dp_signedness", "cat3_dp_pack", "cat3_opc", "cat3_imm_reg_opc",
  "cat3_wmm", "cat3_dp", "cat3_instr", "cat4_opc", "cat4_instr",
  "cat5_opc_dsxypp", "cat5_opc_isam", "cat5_opc", "cat5_flag",
  "cat5_flags", "cat5_samp", "cat5_tex", "cat5_type", "cat5_a1",
  "cat5_samp_tex", "cat5_samp_tex_all", "cat5_instr", "cat6_typed",
  "cat6_dim", "cat6_type", "cat6_imm_offset", "cat6_offset",
  "cat6_dst_offset", "cat6_immed", "cat6_src_shift",
  "cat6_a6xx_global_address_pt2", "cat6_a6xx_global_address", "cat6_load",
  "$@24", "$@25", "$@26", "$@27", "$@28", "$@29", "$@30", "$@31",
  "cat6_store", "$@32", "$@33", "$@34", "$@35", "$@36", "cat6_loadib",
  "$@37", "cat6_storeib", "$@38", "cat6_prefetch", "$@39",
  "cat6_atomic_opc", "cat6_a3xx_atomic_opc", "cat6_a6xx_atomic_opc",
  "cat6_a3xx_atomic_s", "cat6_a6xx_atomic_g", "cat6_atomic_l",
  "cat6_atomic", "cat6_ibo_opc_1src", "cat6_ibo_opc_ldgb",
  "cat6_ibo_opc_stgb", "cat6_ibo", "$@40", "cat6_id_opc", "cat6_id",
  "cat6_bindless_base", "cat6_bindless_mode", "cat6_reg_or_immed",
  "cat6_bindless_ibo_opc_1src", "cat6_bindless_ibo_opc_2src",
  "cat6_bindless_ibo_opc_3src", "cat6_bindless_ibo_opc_3src_dst",
  "cat6_bindless_ibo", "cat6_bindless_ldc_opc", "cat6_bindless_ldc_middle",
  "cat6_bindless_ldc", "const_dst", "cat6_stc", "$@41", "$@42",
  "cat6_shfl_mode", "cat6_shfl", "$@43", "cat6_ray_intersection", "$@44",
  "cat6_todo", "cat6_instr", "cat7_scope", "cat7_scopes", "cat7_barrier",
  "$@45", "$@46", "cat7_data_cache", "cat7_alias_dst", "cat7_alias_src",
  "cat7_alias_scope", "cat7_alias_int_type", "cat7_alias_float_type",
  "cat7_alias_type", "cat7_alias_table_size_minus_one", "cat7_instr",
  "$@47", "raw_instr", "meta_print_regs", "meta_print_reg",
  "meta_print_start", "meta_print", "src_gpr", "src_a0", "src_a1",
  "src_p0", "src", "dst", "const", "dst_reg_flag", "dst_reg_flags",
  "dst_reg", "src_reg_flag", "src_reg_flags", "src_reg", "src_reg_gpr",
  "src_const", "src_reg_or_const", "src_reg_or_const_or_rel",
  "src_reg_or_const_or_rel_or_imm", "src_reg_or_rel_or_imm", "uoffset",
  "offset", "src_uoffset", "relative_gpr_src", "relative_gpr_dst",
  "relative_const", "relative", "immediate_cat1", "immediate",
  "flut_immed", "uinteger", "integer", "float", "type", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-1142)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-4)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -1142,    98,  1333, -1142,    56,  -300, -1142, -1142,  -257,  -245,
    -211,    56,  -204,  -189,  -183,    56,    56, -1142,  1142,  1333,
   -1142, -1142,    56, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142,   174,  -178,   173,
     206,    78,   217, -1142,   220,   223,   229, -1142, -1142,  -122,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142,   241, -1142, -1142, -1142, -1142,   754,  1407,
    1058, -1142, -1142, -1142,  -106, -1142, -1142, -1142, -1142,    56,
     -98,   -62,   -58,   -56,   -54,   -51,   -44,   -41, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142,   -97, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142,   -35, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142,   -34,    -8,     3,    -6,     0,     2,     4,    18,
      21, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142,     8, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142,   665,    22,   665, -1142,   665,
     665,   665,    23, -1142,   665, -1142,    26,    30,    26, -1142,
   -1142, -1142, -1142, -1142, -1142,    33,    33,    33, -1142, -1142,
   -1142, -1142,    40,    33,    33, -1142,    40, -1142,    33,    33,
      33,    33, -1142,    42, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142,   360, -1142,  -106,    25,    24,    56,
   -1142, -1142, -1142, -1142,   401,   403,   411,  -255,  -255,  -255,
     126,  -255,  -255,    55,    55,    55,  -255,    55,    73,    55,
      55,    88,    67,    75,    93,   102,   105,   108,   109,   113,
      40,    40,    40,    40,    40,    40,    40,    40,    40,    33,
     103,    40,    40,    33,    40,    40,    40,   117,   665,   119,
     119,   123, -1142,    68, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142,   106, -1142,   710,   145,   116,   137,   139,   313,
     144,   148,   152,   157,  -170,   138,   158,   974,    26,   665,
     936,   162,   162,  -146,   159,   159,   159,   399,   159,   159,
     159,   665,   159,   159,   159,   159,    28, -1142, -1142,   513,
      56,    56,   165,   167,   168,   170, -1142,   182,   177,   178,
     179, -1142, -1142,   193, -1142, -1142,   180,   183,   122, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142,   665,   665,   166,   665,
     665,   171,   187,   175,   195,   159,   169,   665,   184,   159,
     665,   189,   191,    19,   192,  -110,   119, -1142, -1142,   -57,
     226,   235, -1142, -1142,  1014,  1014,   898, -1142, -1142, -1142,
   -1142, -1142, -1142,   665,   898,    48,   950,   251, -1142, -1142,
     -89,   665,   898, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142,   215,    26,   399,   665,   665,
   -1142, -1142,   -38,    40,    40,    40, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142,   665,    40,    40, -1142,
      40,    40,    40,    40,   199,   218,   219,   224, -1142,   227,
   -1142,   228, -1142, -1142,    56,   582,   583,   126, -1142,    55,
    -205,  -205, -1142,    55,    55,    55, -1142, -1142,    55,   665,
    1014,  1014,   665,   665,   665,   665,   234,   236,   232,   249,
     250,   237,   240,   242,   244,    40,   213,   257,   246,    40,
     263,   248,   255, -1142, -1142, -1142, -1142, -1142,    40, -1142,
     256, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,   259,
    -197,  -197, -1142, -1142, -1142, -1142, -1142, -1142, -1142,   221,
     253, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,    69,
     261,   262,   276, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
     742,    58, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142,   126,   645,   718, -1142, -1142, -1142,
   -1142, -1142,   280,   281,   290,   213, -1142,   291, -1142, -1142,
   -1142,   300, -1142, -1142, -1142,   301, -1142,   601,   162,   307,
     303,   311, -1142, -1142, -1142, -1142,   305,   306,   309,   314,
     316,   318,   319,   320,   333,   350,   126,   340,   338,   101,
   -1142,    56,   321,   357,   358,   362, -1142, -1142,   378,   367,
     371, -1142, -1142, -1142, -1142, -1142, -1142,   833, -1142, -1142,
   -1142,   372,   375,   377,   379,   363,   366,   115,   364,   374,
     213,   282,   213,   213,   389,  -196,   380,   213,   390,   407,
     115,   115,   145,   282,   -72,   126,   126, -1142,   394,   398,
     396,   400, -1142,   427,   428,   339,   429,   430,   412,   447,
      64, -1142, -1142, -1142, -1142,   433,   126, -1142, -1142,   898,
     898,   282,   282,   331,   950, -1142,   665, -1142,   601,    44,
     126,   126,   126,   426,   126,   126,   126,   126,   126,   126,
     439,   440,   450,   458, -1142, -1142, -1142,    56,   126,   126,
     811, -1142,    55,    55, -1142,   665,   331,   665,   331,   446,
     449,   453,   452, -1142,   454,   455,  -197,   456,    86,   459,
    -176,  -176,   126,   101, -1142,   457, -1142,   460,  -176,   126,
     461,   465,   468,   478,   469, -1142, -1142, -1142, -1142, -1142,
   -1142,   482, -1142, -1142, -1142, -1142,  -197,  -197, -1142, -1142,
   -1142, -1142, -1142,  -197,  -197,   488,   489, -1142,   491,   494,
   -1142,   495,   496,   497,   498,   499,   500, -1142, -1142,   504,
   -1142, -1142,   505,   506,   507,   508,   512,   665, -1142,   514,
     515,   516,   522,    17,   126,    17,   101,   511,   518,   532,
     533, -1142, -1142,   537,   538,   539,   540,   213,   282,   126,
     542,   213,   213,   526,   546,   141,   101,   536, -1142,   541,
     665, -1142,   555,   213,   543,   544,   126,   556,   557,   213,
     561,   916,   553,   554,   569,   570, -1142, -1142, -1142,   898,
      48,   950,   142,   282,   601,    44,   585,    44,   547,   550,
     552,   101,   568,   565,    17,    17,    17,    17,   572,   572,
     572,   665,   588,   580, -1142,    56, -1142, -1142,   126,   331,
     331,   665,    46,  -196,   586, -1142,   587,  -196,  -196,   606,
     213,   188, -1142,  -197, -1142,   607,   608,   610,   126,  -196,
     611,   596,   598,   331,   142,   613,   331, -1142,   564, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142,   616,   604,   618,
     619, -1142, -1142,   620, -1142, -1142,   628,   665,   665,   665,
     612,   615,   631,   665,   331,   331,   665,   653, -1142, -1142,
   -1142, -1142,    17,   632, -1142,   649,   654,   655,   656, -1142,
   -1142, -1142,   640,   658,   643,   646,   650,   213,   662,   210,
     652, -1142,   213,   213,   657, -1142,   651,   213,   142, -1142,
     669,   670,   101,   671, -1142,   673, -1142,   950, -1142,   674,
    -238,   688,   194,   194,   676,   679,   692, -1142,   677,   101,
     694,   695,   696,   702, -1142,   665,   716,  1060,   331,   331,
     665,   711,   142,   213,   712,   713,   714,   142,   213,   652,
     701,   708,   720,   721,   700,   722,   723,   707,   729,   126,
     126, -1142,   331,    92, -1142,    44, -1142, -1142, -1142, -1142,
   -1142,   730, -1142,   699,   719,   213,   101,   715,   101,   101,
     101,   101, -1142,   727,   728, -1142,   733,   735,   142, -1142,
    -196,   142,   142,   142, -1142,   652,  -197,   126, -1142,   142,
     142,   142,   142,   142,   737,   142, -1142, -1142,   738, -1142,
   -1142, -1142, -1142,   688,   724,   732,   739,   734,   752, -1142,
     761,   604,   604, -1142,   126,   331,   331, -1142,   745, -1142,
   -1142, -1142,   762,   764, -1142, -1142, -1142,   746, -1142, -1142,
     213, -1142,   331,   101,   101,   213,   767,   213,   101,   770,
     771,   772, -1142, -1142,   773,  -197,   763,   776,   778, -1142,
     765,   766, -1142,   213,   780, -1142,   101,   101,   790,   142,
     782,   779,   213,   213,   785,   786,   787,   101, -1142, -1142,
     789, -1142,   783,   126,   794,   798,   213,   213,   213,   799,
     126,   791,   800,   213,   213, -1142,   801, -1142,   213,   803,
     126, -1142, -1142, -1142,   213, -1142,  1155,   812,   808,   814,
   -1142,   213,   126, -1142,   818,  1175,   822,   998, -1142, -1142
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     4,     1,     0,     0,    31,    32,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    42,    59,     4,
       6,     7,     0,     8,     9,    10,    11,    12,    16,    17,
      18,    13,    14,    15,    20,    22,    19,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,    40,    41,     0,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,   531,     0,    74,    75,    76,    77,    59,     0,
      59,    62,    73,    71,     0,    72,     5,    33,    21,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    78,   535,
      60,    85,    86,    88,    90,     0,    94,    96,    98,   100,
     102,   104,   105,   107,   108,   109,   110,   111,   112,   113,
     115,   116,   117,   118,     0,   119,   121,   122,   124,   125,
     126,   127,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   182,   183,   184,   185,   166,   176,   162,   179,   167,
     168,   169,   170,   171,   186,   187,   188,   189,   177,   178,
     190,   191,   192,   193,   163,   194,   195,   172,   196,   180,
     181,   197,   198,   199,   173,   165,   164,   200,   201,   202,
     203,   204,   205,   206,   174,   175,   207,   208,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   245,
     246,   243,   244,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   262,   263,   288,
     289,   290,   291,   292,   293,   294,   328,   349,   351,   353,
     357,   355,   364,   366,   370,   368,   374,   478,   479,   378,
     359,   372,   480,   419,   438,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   437,   451,   450,   439,
     440,   441,   442,   443,   444,   445,   446,   447,   448,   449,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,   420,   421,   376,   456,   361,   426,   427,   428,
     464,   466,   474,   476,   501,   503,   524,   526,   505,   506,
     507,   525,   527,   528,   529,    63,     0,   153,   154,   155,
     156,   157,   158,   161,    64,     0,     0,     0,    65,     0,
       0,     0,     0,    66,     0,    67,   306,   306,   306,    68,
     481,   483,   482,   484,   485,     0,     0,     0,   417,   418,
     416,   486,     0,     0,     0,   487,     0,   488,     0,     0,
       0,     0,   490,     0,   489,   491,   492,   493,   494,    69,
     522,   523,    70,    61,     0,   536,   532,    30,     0,     0,
      35,    36,    37,    38,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   499,
     499,     0,   545,     0,   550,   551,   552,   553,   554,   546,
     547,   548,     0,   557,   555,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   534,   533,     0,
      28,     0,     0,     0,     0,     0,    80,     0,     0,     0,
       0,   625,   626,     0,   627,    92,     0,     0,     0,    99,
     101,   103,   106,   114,   128,   120,   123,   134,   139,   141,
     130,   131,   143,   145,   147,   151,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   499,   502,   504,     0,
       0,     0,   556,   558,     0,     0,     0,   209,   210,   211,
     212,   213,   214,     0,     0,     0,     0,     0,   218,   219,
       0,     0,     0,   301,   295,   300,   304,   302,   303,   305,
     296,   297,   298,   299,   307,     0,   306,     0,     0,     0,
     329,   330,     0,     0,     0,     0,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   335,     0,     0,     0,   429,
       0,     0,     0,     0,     0,     0,     0,     0,   341,     0,
      25,    26,    34,    23,     0,     0,     0,     0,    79,     0,
       0,     0,   628,     0,     0,     0,    84,    83,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   468,   469,   470,   471,   472,     0,   473,
       0,   498,   497,   495,   496,   500,   512,   513,   514,     0,
     583,   583,   537,   549,   559,   560,   561,   562,   563,     0,
       0,   603,   604,   605,   606,   607,   538,   539,   540,     0,
       0,     0,     0,   159,   541,   542,   543,   544,   566,   570,
     564,     0,   572,   573,   574,   132,   594,   595,   575,   133,
     596,   160,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   624,     0,     0,     0,   577,   215,   579,
     610,   608,     0,     0,     0,     0,   580,     0,   581,   582,
     568,     0,   569,   220,   221,     0,   261,     0,     0,     0,
       0,   324,   331,   332,   333,   334,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      29,    28,     0,     0,     0,     0,    87,    82,     0,     0,
       0,    93,    95,    97,   129,   135,   140,     0,   136,   137,
     142,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   583,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   585,     0,     0,
       0,     0,   629,     0,     0,     0,     0,     0,     0,     0,
       0,   565,   567,   571,   576,     0,     0,   612,   578,     0,
       0,     0,     0,     0,     0,   320,     0,   310,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   435,   436,    27,     0,     0,     0,
       0,    81,     0,     0,   138,     0,     0,     0,     0,     0,
       0,   462,     0,   461,     0,     0,   583,     0,     0,     0,
     583,   583,     0,     0,   337,     0,   336,     0,   583,     0,
       0,     0,     0,     0,     0,   517,   518,   515,   516,   519,
     520,     0,   586,   584,   591,   590,   583,   583,   601,   602,
     630,   597,   598,   583,   583,     0,     0,   609,     0,     0,
     217,     0,     0,     0,     0,     0,     0,   308,   309,   314,
     315,   323,   312,     0,     0,     0,     0,     0,   424,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    89,    91,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   339,     0,
       0,   338,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   599,   600,   611,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   430,   430,
     430,     0,     0,     0,   460,     0,    43,    44,     0,     0,
       0,     0,     0,   583,     0,   463,     0,   583,   583,     0,
       0,     0,   348,   583,   340,     0,     0,     0,     0,   583,
       0,     0,     0,     0,     0,     0,     0,   521,     0,   589,
     593,   592,   588,   216,   247,   248,   249,     0,   583,   314,
     315,   316,   326,   312,   313,   322,   312,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   433,   434,
     432,   457,     0,     0,    24,     0,     0,     0,     0,   152,
     150,   149,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   347,     0,     0,     0,   379,     0,     0,     0,   362,
       0,     0,     0,     0,   509,     0,   508,     0,   587,     0,
       0,     0,     0,     0,     0,     0,     0,   422,     0,     0,
       0,     0,     0,     0,   431,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   475,     0,     0,   250,     0,   317,   311,   318,   319,
     325,   312,   321,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   458,     0,     0,   144,     0,     0,     0,   352,
     583,     0,     0,     0,   367,   343,   583,     0,   346,     0,
       0,     0,     0,     0,     0,     0,   465,   467,     0,   530,
     510,   511,   327,     0,     0,     0,     0,     0,     0,   452,
       0,   583,   583,   459,     0,     0,     0,   350,     0,   358,
     356,   365,     0,     0,   342,   371,   369,     0,   360,   373,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   146,   148,     0,   583,     0,     0,     0,   477,
       0,     0,   414,     0,     0,   453,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   454,   455,
       0,   354,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   415,     0,   423,     0,     0,
       0,   345,   375,   377,     0,   425,     0,     0,     0,     0,
     344,     0,     0,   413,     0,     0,     0,     0,    45,    46
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1142, -1142, -1142,  1169, -1142,    -4, -1142, -1142, -1142,   402,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
    1122, -1142,  1134, -1142,   -92,   551,  -380, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142,   663, -1142, -1142,   563, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,  -269,
     347,  -805,  -446,  -905,   348,  -985, -1142,   806,   717,   788,
     325,  -916,  -801,  -672, -1141, -1142,   239, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142,  -786,  -621,  -415, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142,  -555, -1142, -1142, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142,  -425, -1142, -1142, -1142, -1142,
   -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142, -1142,
     839, -1142, -1142, -1142,  -753,   185,  -988, -1142,  -171,  -463,
    -585, -1142,   774,  -321, -1142,  -512,  -557, -1142, -1142,  -750,
    -548,  -561,  -807, -1040,  -687,  -926,   659, -1142, -1142,  -570,
    -641,  -568,   501,  -508,  -409,   397,   642
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,    18,    19,   630,    20,    21,   631,   632,
     500,    22,    23,   397,    24,    25,    26,    27,    28,    29,
      30,    31,    32,  1349,    33,    64,    65,    66,    67,    68,
      69,    70,    71,    72,   508,   799,   519,   335,   407,   408,
     409,   643,   411,   412,   413,   414,   415,   416,   417,   419,
     420,   648,   336,   713,   337,   649,   806,   338,   650,   339,
     651,   340,   652,   341,   653,   342,   654,  1119,   343,   655,
     344,   345,   346,   347,   573,   348,   475,   581,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   478,   479,
    1089,  1090,   598,  1199,  1091,  1092,   359,   484,   603,   488,
     914,   915,   997,   626,  1181,  1062,   907,   360,   430,   431,
     432,   434,   433,   441,   444,  1188,   361,   435,   436,   438,
     437,   442,   362,   439,   363,   443,   364,   440,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,  1033,
     376,   377,  1108,  1041,   883,   378,   379,   380,   381,   382,
     383,   627,   384,   902,   385,   445,   446,   678,   386,   447,
     387,   448,   388,   389,   556,   557,   390,   449,   450,   391,
    1145,  1239,   689,   929,   930,   931,  1078,   392,   451,    73,
     395,   396,    74,    75,   714,   715,   716,   717,   718,   463,
     719,   464,   465,   466,   720,   755,   722,   761,   723,   724,
     747,   748,   757,   837,   916,  1149,   726,   467,   727,   728,
     729,   749,   750,   514,   751,   847,   615
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      38,   515,   563,   838,   839,   642,   758,    43,   759,   809,
     809,    47,    48,   753,   865,   452,   725,   725,    77,   756,
     760,   766,   511,   512,   468,   558,   470,   754,   471,   472,
     473,   511,   512,   476,   520,   521,   599,   523,  1226,   525,
     526,   453,  1095,   454,   455,   456,   457,   458,  1148,   511,
     512,   692,   721,   721,   746,   692,   693,   954,    39,    34,
      35,    36,   746,   721,   960,   692,   693,   511,   512,   842,
     746,   909,   511,   512,   842,   398,   694,   695,   696,   697,
     698,   699,   700,   924,  1262,    82,    83,   628,   481,   482,
     506,   699,   700,   692,   693,   511,   512,   958,     3,   692,
     693,    40,   808,   808,   511,   512,   707,   507,   692,   647,
     999,   951,   952,    41,   880,   956,   962,  1004,   511,   512,
     694,   695,   696,   697,   698,   511,   512,   554,   646,   511,
     512,   685,   701,   702,   703,   704,   853,  1122,   807,   807,
     797,  1125,  1126,   705,   679,   511,   512,    42,   692,   578,
     579,   854,   452,  1136,    44,   730,   730,   798,   595,   835,
     835,   853,  1197,  1197,  1197,  1197,   894,  1200,  1202,    45,
     619,   600,   601,   836,   913,    46,   854,    78,   858,    79,
     835,    80,   732,   733,   734,   735,   736,   737,   738,   739,
     740,   741,   742,   743,   996,   692,   511,   512,   963,   964,
     965,   692,   967,   968,   969,   970,   971,   972,   851,   594,
    1242,  1148,  1148,    81,  1085,   656,   657,   692,   659,   660,
     692,  1094,   853,   998,   998,    84,   667,    85,   795,   670,
      86,   998,   763,   764,   925,   926,    87,   854,   909,    88,
    1000,   730,   730,   927,   928,  1196,  1198,  1005,    89,  1012,
    1013,   394,   752,  1109,  1110,  1197,  1014,  1015,   692,   796,
     765,   399,   681,   801,   802,   803,   682,   410,   804,   683,
     684,  1088,  1093,  1087,  1096,   921,   922,   770,   771,   694,
     695,   696,   697,   698,   699,   772,   773,   774,   775,   692,
     693,   686,   687,   688,   758,   779,   759,   400,   949,   950,
     846,   401,  1042,   402,  1258,   403,   953,   756,   404,   908,
     694,   695,   696,   697,   698,   405,   509,   510,   406,   516,
     517,   908,   866,   853,   522,  1279,  1280,   768,   805,   418,
     421,   811,   812,   813,   814,   855,   422,   642,   692,   984,
    1194,   986,   511,   512,   940,  1094,   423,   746,   746,   908,
     908,   459,   460,   461,  1043,  1038,  1039,  1040,   424,   694,
     695,   696,   697,   698,   425,   624,   426,   497,   427,   923,
     673,   674,   675,   676,   677,   513,  1131,   628,   957,   958,
     885,   501,   428,   499,   513,   429,   469,   474,   462,   706,
     477,   706,   707,   708,   480,   502,  1135,   483,   730,  1201,
    1201,   706,   707,   708,   487,   625,   496,   503,   903,   504,
     843,   844,    37,  1103,  1104,  1105,  1106,   505,   518,   524,
     845,   903,   903,   710,   528,   845,   932,   933,   711,   706,
     707,   708,   529,   710,   527,   706,   707,   708,   711,   560,
     530,   945,  1201,  1240,   706,   707,   708,   948,   513,   531,
     709,   758,   532,   759,  1086,   533,   534,   513,  1083,   901,
     535,   628,   628,   628,   756,   628,   628,   628,   628,   628,
     628,   513,  1084,   564,   712,   546,   908,   561,   513,   978,
     979,   553,   513,   555,   706,   707,   708,   559,   459,   460,
     461,  1165,  1116,  1117,   565,   825,   566,   633,   513,  1061,
     744,   574,   580,   628,   933,   575,  1141,   746,   721,   576,
     628,   908,   981,   982,   577,   582,  1140,  1236,  1237,  1143,
     597,   629,   634,   602,   745,   635,   636,   638,   957,   958,
     637,   706,   707,   708,   639,   640,   641,   644,   707,  1263,
     645,   658,   666,   661,  1121,   955,  1129,  1161,  1162,   680,
     852,   663,  1241,   706,   707,   708,   706,   707,   708,   662,
     668,  1044,   664,   786,   671,   628,   672,   885,  1178,   690,
    1187,   452,   767,  1144,   983,   852,   985,   758,   691,   759,
    1055,   789,   787,   788,   852,   791,   790,   933,   793,   794,
     756,   815,   840,   816,   706,   707,   708,  1072,  1300,   454,
     455,   456,   457,   458,  1219,   817,   818,   819,   692,  1224,
     820,  1215,  1216,   821,   826,   822,  1100,   823,   884,   827,
     829,   830,   885,   834,   841,   706,   707,   708,   831,   833,
     792,   711,   848,   849,   850,  1238,   852,   859,   860,  1115,
     567,   568,   569,   570,   571,   572,  1032,   861,   862,   906,
    1257,   910,   911,  1259,  1260,  1261,   918,   863,   864,   628,
     868,  1265,  1266,  1267,  1268,  1269,   867,  1271,   869,   870,
     871,   873,   452,   872,   706,   707,   708,   881,   887,  1067,
     874,   908,   875,   876,   877,   732,   733,   734,   735,   736,
     737,   738,   739,   740,   741,   742,   743,   878,  1282,  1283,
     454,   455,   456,   457,   458,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   879,  1289,   882,   888,   889,   890,
    1111,   511,   512,   891,   892,   692,   693,  1191,   893,   895,
    1118,  1311,   896,   885,   897,   899,   898,   852,   900,   936,
     904,   905,  1001,   937,  1207,   454,   455,   456,   457,   458,
     885,   699,   700,   912,   919,   943,   917,  1146,   732,   733,
     734,   735,   736,   737,   738,   739,   740,   741,   742,   743,
     694,   695,   696,   697,   698,   934,  1154,  1155,  1156,   935,
     628,   628,  1160,   920,   730,  1163,   938,   939,   941,   942,
     944,  1247,   947,  1249,  1250,  1251,  1252,   885,   966,   885,
     885,   885,   885,   973,   974,   884,    54,    55,    56,    57,
      58,    59,    60,    61,   975,   976,  1053,   980,  1264,   987,
    1057,  1058,   988,   989,  1063,  1064,   990,   991,   992,   995,
     994,  1002,  1069,  1003,  1006,  1009,   511,   512,  1075,  1007,
     692,   693,  1008,  1010,  1212,  1281,  1011,  1016,  1017,  1217,
    1018,  1019,  1020,  1021,  1022,  1023,  1024,  1025,  1290,  1291,
     884,  1026,  1027,  1295,   885,   885,   699,   700,  1045,   885,
    1028,  1029,  1030,   701,   702,   703,   704,  1046,  1034,  1035,
    1036,  1308,  1309,   977,   705,  1031,  1037,   885,   885,  1128,
    1130,  1047,  1319,  1048,  1049,  1050,  1051,  1052,   885,  1056,
    1059,   511,   512,  1060,  1322,   692,   693,   459,   460,   461,
    1065,  1329,  1068,  1073,  1074,  1066,  1071,  1070,  1076,  1077,
     958,  1337,  1098,  1097,  1099,  1101,   694,   695,   696,   697,
     698,   699,   700,  1344,  1079,  1080,  1107,  1102,   732,   733,
     734,   735,   736,   737,   738,   739,   740,   741,   742,   743,
    1081,  1082,  1112,   511,   512,  1113,  1176,   692,  1179,  1124,
    1123,  1182,  1183,  1127,  1132,  1133,  1186,  1134,  1137,  1138,
    1142,   884,  1139,  1147,   836,  1150,  1151,  1152,   694,   695,
     696,   697,   698,   699,   700,  1153,  1157,  1158,   884,  1164,
     732,   733,   734,   735,   736,   737,   738,   739,   740,   741,
     742,   743,  1220,   856,  1159,  1166,  1167,  1225,   459,   460,
     461,  1168,  1169,  1170,  1171,  1172,  1173,   511,   512,  1177,
    1174,   692,   693,  1180,  1175,  1185,  1189,  1190,  1192,  1184,
    1193,  1195,   707,  1203,  1246,   884,  1204,   884,   884,   884,
     884,  1114,   694,   695,   696,   697,   698,   699,   700,  1205,
    1206,  1208,  1209,  1210,   701,   702,   703,   704,    -3,  1211,
    1213,   706,   707,   708,    49,   705,  1214,  1228,  1218,  1221,
    1222,  1223,  1227,  1231,   513,  1244,   744,  1229,  1230,  1232,
    1233,  1234,    50,    51,    52,    53,  1235,  1243,  1254,  1248,
    1255,  1245,  1256,   710,  1270,  1272,  1275,  1273,   711,  1288,
     745,  1253,   884,   884,  1292,  1274,  1294,   884,  1276,  1277,
      54,    55,    56,    57,    58,    59,    60,    61,  1278,  1284,
    1287,  1285,  1306,  1286,  1293,   884,   884,  1296,  1297,  1298,
    1299,  1314,  1315,  1302,  1301,  1303,   884,  1307,  1310,  1304,
    1305,  1312,  1316,  1317,  1318,  1325,  1326,  1327,    49,  1320,
    1313,  1323,  1332,  1333,  1321,  1324,  1328,  1335,  1334,  1331,
    1336,  1339,  1330,  1338,   491,  1341,    50,    51,    52,    53,
    1343,  1340,   485,   486,  1342,  1345,   706,   707,   708,   489,
     490,  1346,  1347,  1348,   492,   493,   494,   495,    76,   513,
      90,   709,   800,   886,    54,    55,    56,    57,    58,    59,
      60,    61,   604,   605,   393,   616,   617,   618,   710,   620,
     621,   622,   623,   711,   810,   712,   959,   961,   536,   537,
     538,   539,   540,   541,   542,   543,   544,  1054,   731,   547,
     548,   993,   550,   551,   552,   498,   762,  1120,   562,   769,
       0,   706,   707,   708,     0,   545,   857,   946,     0,   549,
       0,     0,     0,     0,   513,     0,   744,     0,     0,   583,
       0,   584,   665,     0,     0,     0,   669,     0,     0,   585,
       0,     0,   586,   710,   587,   588,     0,     0,   711,     0,
     745,     0,   589,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   706,   707,   708,     0,   583,     0,   584,
       0,   590,   591,   592,   593,   596,   513,   585,   744,     0,
     586,     0,   587,   588,     0,     0,     0,     0,     0,     0,
     589,     0,     0,     0,     0,   710,     0,     0,     0,     0,
     711,     0,   745,     0,     0,     0,     0,     0,     0,   590,
     591,   592,   593,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,   706,   707,   708,
       0,     0,    62,    63,     0,     0,     0,     0,     0,     0,
     513,     0,   709,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   710,
       0,   776,   777,   778,   711,     0,   712,     0,     0,     0,
       0,     0,     0,     0,     0,   780,   781,     0,   782,   783,
     784,   785,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    62,    63,     0,     0,
       0,     0,     0,   824,     0,     0,     0,   828,     0,     0,
       0,     0,     0,     0,     0,     0,   832,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334
};

static const yytype_int16 yycheck[] =
{
       4,   410,   465,   690,   691,   513,   576,    11,   576,   650,
     651,    15,    16,   574,   767,     7,   564,   565,    22,   576,
     577,   582,     3,     4,   345,   450,   347,   575,   349,   350,
     351,     3,     4,   354,   414,   415,   482,   417,  1179,   419,
     420,    33,  1027,    35,    36,    37,    38,    39,  1088,     3,
       4,     7,   564,   565,   566,     7,     8,   864,   358,     3,
       4,     5,   574,   575,   869,     7,     8,     3,     4,     5,
     582,   821,     3,     4,     5,    79,    28,    29,    30,    31,
      32,    33,    34,   833,  1225,     7,     8,   496,   357,   358,
     345,    33,    34,     7,     8,     3,     4,   335,     0,     7,
       8,   358,   650,   651,     3,     4,   344,   362,     7,   518,
     911,   861,   862,   358,   786,   868,   869,   918,     3,     4,
      28,    29,    30,    31,    32,     3,     4,   448,     6,     3,
       4,   556,    40,    41,    42,    43,   721,  1053,   650,   651,
     345,  1057,  1058,    51,   553,     3,     4,   358,     7,   319,
     320,   721,     7,  1069,   358,   564,   565,   362,   479,   356,
     356,   746,  1150,  1151,  1152,  1153,   807,  1152,  1153,   358,
     491,   317,   318,   370,   370,   358,   746,     3,   746,   357,
     356,     8,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,   370,     7,     3,     4,   870,   871,
     872,     7,   874,   875,   876,   877,   878,   879,   720,   478,
    1195,  1251,  1252,     7,  1021,   536,   537,     7,   539,   540,
       7,  1026,   807,   910,   911,     8,   547,     7,   637,   550,
       7,   918,   321,   322,   306,   307,     7,   807,   988,   361,
     912,   650,   651,   315,   316,  1150,  1151,   919,     7,   936,
     937,   357,   573,  1039,  1040,  1243,   943,   944,     7,   639,
     581,   359,   372,   643,   644,   645,   376,   364,   648,   379,
     380,  1024,  1025,  1023,  1027,   830,   831,   598,   599,    28,
      29,    30,    31,    32,    33,   323,   324,   325,   326,     7,
       8,   348,   349,   350,   864,   616,   864,   359,   859,   860,
     709,   359,   974,   359,  1220,   359,   863,   864,   359,   821,
      28,    29,    30,    31,    32,   359,   408,   409,   359,   411,
     412,   833,   768,   908,   416,  1251,  1252,   596,   649,   364,
     364,   652,   653,   654,   655,   744,   344,   845,     7,   896,
    1147,   898,     3,     4,     5,  1150,   343,   859,   860,   861,
     862,   343,   344,   345,   975,   338,   339,   340,   364,    28,
      29,    30,    31,    32,   364,   337,   364,     7,   364,   832,
     351,   352,   353,   354,   355,   356,  1063,   786,   334,   335,
     789,   357,   364,   358,   356,   364,   364,   364,   380,   343,
     364,   343,   344,   345,   364,   399,  1068,   364,   807,  1152,
    1153,   343,   344,   345,   364,   377,   364,     6,   817,     6,
     341,   342,   356,  1034,  1035,  1036,  1037,     6,   363,   346,
     356,   830,   831,   375,   357,   356,   835,   836,   380,   343,
     344,   345,   357,   375,   346,   343,   344,   345,   380,   371,
     347,   850,  1195,  1193,   343,   344,   345,   856,   356,   347,
     358,  1021,   347,  1021,  1022,   347,   347,   356,  1019,   344,
     347,   870,   871,   872,  1021,   874,   875,   876,   877,   878,
     879,   356,  1020,   357,   382,   372,   988,   371,   356,   888,
     889,   364,   356,   364,   343,   344,   345,   364,   343,   344,
     345,  1112,  1049,  1050,   357,   666,   357,   501,   356,   358,
     358,   357,   364,   912,   913,   357,  1074,  1019,  1020,   357,
     919,  1023,   892,   893,   357,   357,  1073,  1189,  1190,  1076,
     358,     8,   357,   364,   382,   358,   358,   345,   334,   335,
     360,   343,   344,   345,   357,   357,   357,   357,   344,  1226,
     357,   375,   373,   372,  1052,   866,   358,  1104,  1105,   357,
     721,   376,  1193,   343,   344,   345,   343,   344,   345,   372,
     376,   976,   367,   364,   375,   974,   375,   976,   358,   343,
    1138,     7,   357,     9,   895,   746,   897,  1147,   343,  1147,
     989,   357,   364,   364,   755,   357,   359,   996,     6,     6,
    1147,   357,   371,   357,   343,   344,   345,  1006,  1285,    35,
      36,    37,    38,    39,  1172,   373,   357,   357,     7,  1177,
     373,  1168,  1169,   373,   357,   373,  1031,   373,   789,   373,
     357,   373,  1031,   364,   371,   343,   344,   345,   373,   373,
     634,   380,   371,   371,   358,  1192,   807,   357,   357,  1048,
     327,   328,   329,   330,   331,   332,   967,   357,   357,   820,
    1218,   822,   823,  1221,  1222,  1223,   827,   357,   357,  1068,
     357,  1229,  1230,  1231,  1232,  1233,   359,  1235,   357,   364,
     364,   357,     7,   364,   343,   344,   345,   337,   357,  1000,
     364,  1193,   364,   364,   364,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,   364,  1255,  1256,
      35,    36,    37,    38,    39,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   364,  1272,   378,   360,   360,   357,
    1041,     3,     4,   345,   357,     7,     8,  1142,   357,   357,
    1051,  1299,   357,  1142,   357,   372,   357,   908,   372,   343,
     376,   367,   913,   343,  1159,    35,    36,    37,    38,    39,
    1159,    33,    34,   364,   364,   343,   376,  1078,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      28,    29,    30,    31,    32,   381,  1097,  1098,  1099,   381,
    1189,  1190,  1103,   376,  1193,  1106,   359,   359,   359,   359,
     343,  1206,   359,  1208,  1209,  1210,  1211,  1206,   372,  1208,
    1209,  1210,  1211,   364,   364,   976,    52,    53,    54,    55,
      56,    57,    58,    59,   364,   357,   987,     6,  1227,   373,
     991,   992,   373,   370,   995,   996,   374,   373,   373,   370,
     374,   374,  1003,   373,   373,   357,     3,     4,  1009,   374,
       7,     8,   374,   374,  1165,  1254,   364,   359,   359,  1170,
     359,   357,   357,   357,   357,   357,   357,   357,  1273,  1274,
    1031,   357,   357,  1278,  1273,  1274,    33,    34,   357,  1278,
     364,   364,   364,    40,    41,    42,    43,   359,   364,   364,
     364,  1296,  1297,   887,    51,   373,   364,  1296,  1297,  1060,
    1061,   359,  1307,   360,   357,   357,   357,   357,  1307,   357,
     374,     3,     4,   357,  1313,     7,     8,   343,   344,   345,
     374,  1320,   357,   357,   357,   374,   372,   374,   357,     3,
     335,  1330,   372,   376,   372,   357,    28,    29,    30,    31,
      32,    33,    34,  1342,   381,   381,   364,   372,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
     381,   381,   364,     3,     4,   375,  1127,     7,  1129,   372,
     374,  1132,  1133,   357,   357,   357,  1137,   357,   357,   373,
     357,  1142,   374,   357,   370,   357,   357,   357,    28,    29,
      30,    31,    32,    33,    34,   357,   374,   372,  1159,   336,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,  1173,   358,   373,   373,   357,  1178,   343,   344,
     345,   357,   357,   357,   374,   357,   373,     3,     4,   357,
     374,     7,     8,   371,   374,   374,   357,   357,   357,   372,
     357,   357,   344,   357,  1205,  1206,   357,  1208,  1209,  1210,
    1211,  1045,    28,    29,    30,    31,    32,    33,    34,   357,
     373,   357,   357,   357,    40,    41,    42,    43,     0,   357,
     344,   343,   344,   345,     6,    51,     6,   359,   357,   357,
     357,   357,   371,   373,   356,   376,   358,   357,   357,   357,
     357,   374,    24,    25,    26,    27,   357,   357,   360,   374,
     357,   372,   357,   375,   357,   357,   357,   373,   380,  1270,
     382,   374,  1273,  1274,  1275,   373,  1277,  1278,   374,   357,
      52,    53,    54,    55,    56,    57,    58,    59,   357,   374,
     374,   359,  1293,   359,   357,  1296,  1297,   357,   357,   357,
     357,  1302,  1303,   357,   371,   357,  1307,   357,   348,   374,
     374,   359,   357,   357,   357,  1316,  1317,  1318,     6,   360,
     371,   357,  1323,  1324,   371,   357,   357,  1328,   357,   359,
     357,     6,   371,  1334,   376,   357,    24,    25,    26,    27,
    1341,   359,   366,   367,   360,   357,   343,   344,   345,   373,
     374,     6,   360,   185,   378,   379,   380,   381,    19,   356,
      68,   358,   641,   791,    52,    53,    54,    55,    56,    57,
      58,    59,   485,   486,    70,   488,   489,   490,   375,   492,
     493,   494,   495,   380,   651,   382,   869,   869,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   988,   565,   441,
     442,   906,   444,   445,   446,   396,   577,  1052,   464,   597,
      -1,   343,   344,   345,    -1,   439,   745,   850,    -1,   443,
      -1,    -1,    -1,    -1,   356,    -1,   358,    -1,    -1,   323,
      -1,   325,   545,    -1,    -1,    -1,   549,    -1,    -1,   333,
      -1,    -1,   336,   375,   338,   339,    -1,    -1,   380,    -1,
     382,    -1,   346,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   343,   344,   345,    -1,   323,    -1,   325,
      -1,   365,   366,   367,   368,   369,   356,   333,   358,    -1,
     336,    -1,   338,   339,    -1,    -1,    -1,    -1,    -1,    -1,
     346,    -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,
     380,    -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,   365,
     366,   367,   368,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,   343,   344,   345,
      -1,    -1,   304,   305,    -1,    -1,    -1,    -1,    -1,    -1,
     356,    -1,   358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,
      -1,   603,   604,   605,   380,    -1,   382,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   617,   618,    -1,   620,   621,
     622,   623,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   304,   305,    -1,    -1,
      -1,    -1,    -1,   665,    -1,    -1,    -1,   669,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   678,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   384,   385,     0,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,   386,   387,
     389,   390,   394,   395,   397,   398,   399,   400,   401,   402,
     403,   404,   405,   407,     3,     4,     5,   356,   388,   358,
     358,   358,   358,   388,   358,   358,   358,   388,   388,     6,
      24,    25,    26,    27,    52,    53,    54,    55,    56,    57,
      58,    59,   304,   305,   408,   409,   410,   411,   412,   413,
     414,   415,   416,   562,   565,   566,   386,   388,     3,   357,
       8,     7,     7,     8,     8,     7,     7,     7,   361,     7,
     413,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   420,   435,   437,   440,   442,
     444,   446,   448,   451,   453,   454,   455,   456,   458,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   479,
     490,   499,   505,   507,   509,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   523,   524,   528,   529,
     530,   531,   532,   533,   535,   537,   541,   543,   545,   546,
     549,   552,   560,   415,   357,   563,   564,   396,   388,   359,
     359,   359,   359,   359,   359,   359,   359,   421,   422,   423,
     364,   425,   426,   427,   428,   429,   430,   431,   364,   432,
     433,   364,   344,   343,   364,   364,   364,   364,   364,   364,
     491,   492,   493,   495,   494,   500,   501,   503,   502,   506,
     510,   496,   504,   508,   497,   538,   539,   542,   544,   550,
     551,   561,     7,    33,    35,    36,    37,    38,    39,   343,
     344,   345,   380,   572,   574,   575,   576,   590,   576,   364,
     576,   576,   576,   576,   364,   459,   576,   364,   471,   472,
     364,   472,   472,   364,   480,   480,   480,   364,   482,   480,
     480,   482,   480,   480,   480,   480,   364,     7,   563,   358,
     393,   357,   388,     6,     6,     6,   345,   362,   417,   417,
     417,     3,     4,   356,   596,   597,   417,   417,   363,   419,
     419,   419,   417,   419,   346,   419,   419,   346,   357,   357,
     347,   347,   347,   347,   347,   347,   482,   482,   482,   482,
     482,   482,   482,   482,   482,   480,   372,   482,   482,   480,
     482,   482,   482,   364,   576,   364,   547,   548,   548,   364,
     371,   371,   575,   572,   357,   357,   357,   327,   328,   329,
     330,   331,   332,   457,   357,   357,   357,   357,   319,   320,
     364,   460,   357,   323,   325,   333,   336,   338,   339,   346,
     365,   366,   367,   368,   472,   576,   369,   358,   475,   475,
     317,   318,   364,   481,   481,   481,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   599,   481,   481,   481,   576,
     481,   481,   481,   481,   337,   377,   486,   534,   597,     8,
     388,   391,   392,   388,   357,   358,   358,   360,   345,   357,
     357,   357,   596,   424,   357,   357,     6,   597,   434,   438,
     441,   443,   445,   447,   449,   452,   576,   576,   375,   576,
     576,   372,   372,   376,   367,   481,   373,   576,   376,   481,
     576,   375,   375,   351,   352,   353,   354,   355,   540,   597,
     357,   372,   376,   379,   380,   548,   348,   349,   350,   555,
     343,   343,     7,     8,    28,    29,    30,    31,    32,    33,
      34,    40,    41,    42,    43,    51,   343,   344,   345,   358,
     375,   380,   382,   436,   567,   568,   569,   570,   571,   573,
     577,   578,   579,   581,   582,   583,   589,   591,   592,   593,
     597,   436,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,   358,   382,   578,   583,   584,   594,
     595,   597,   576,   584,   583,   578,   579,   585,   592,   594,
     579,   580,   589,   321,   322,   576,   584,   357,   472,   599,
     576,   576,   323,   324,   325,   326,   482,   482,   482,   576,
     482,   482,   482,   482,   482,   482,   364,   364,   364,   357,
     359,   357,   388,     6,     6,   597,   419,   345,   362,   418,
     418,   419,   419,   419,   419,   576,   439,   578,   583,   593,
     439,   576,   576,   576,   576,   357,   357,   373,   357,   357,
     373,   373,   373,   373,   482,   571,   357,   373,   482,   357,
     373,   373,   482,   373,   364,   356,   370,   586,   587,   587,
     371,   371,     5,   341,   342,   356,   597,   598,   371,   371,
     358,   578,   571,   573,   592,   597,   358,   595,   594,   357,
     357,   357,   357,   357,   357,   567,   475,   359,   357,   357,
     364,   364,   364,   357,   364,   364,   364,   364,   364,   364,
     486,   337,   378,   527,   571,   597,   392,   357,   360,   360,
     357,   345,   357,   357,   593,   357,   357,   357,   357,   372,
     372,   344,   536,   597,   376,   367,   571,   489,   578,   582,
     571,   571,   364,   370,   483,   484,   587,   376,   571,   364,
     376,   536,   536,   572,   582,   306,   307,   315,   316,   556,
     557,   558,   597,   597,   381,   381,   343,   343,   359,   359,
       5,   359,   359,   343,   343,   597,   598,   359,   597,   584,
     584,   582,   582,   579,   585,   576,   567,   334,   335,   473,
     474,   477,   567,   486,   486,   486,   372,   486,   486,   486,
     486,   486,   486,   364,   364,   364,   357,   388,   597,   597,
       6,   419,   419,   576,   579,   576,   579,   373,   373,   370,
     374,   373,   373,   483,   374,   370,   370,   485,   587,   485,
     486,   571,   374,   373,   485,   486,   373,   374,   374,   357,
     374,   364,   587,   587,   587,   587,   359,   359,   359,   357,
     357,   357,   357,   357,   357,   357,   357,   357,   364,   364,
     364,   373,   576,   522,   364,   364,   364,   364,   338,   339,
     340,   526,   486,   526,   527,   357,   359,   359,   360,   357,
     357,   357,   357,   571,   489,   597,   357,   571,   571,   374,
     357,   358,   488,   571,   571,   374,   374,   576,   357,   571,
     374,   372,   597,   357,   357,   571,   357,     3,   559,   381,
     381,   381,   381,   584,   583,   585,   594,   582,   567,   473,
     474,   477,   478,   567,   474,   478,   567,   376,   372,   372,
     527,   357,   372,   526,   526,   526,   526,   364,   525,   525,
     525,   576,   364,   375,   388,   597,   579,   579,   576,   450,
     568,   596,   484,   374,   372,   484,   484,   357,   571,   358,
     571,   587,   357,   357,   357,   486,   484,   357,   373,   374,
     579,   594,   357,   579,     9,   553,   576,   357,   586,   588,
     357,   357,   357,   357,   576,   576,   576,   374,   372,   373,
     576,   579,   579,   576,   336,   526,   373,   357,   357,   357,
     357,   374,   357,   373,   374,   374,   571,   357,   358,   571,
     371,   487,   571,   571,   372,   374,   571,   594,   498,   357,
     357,   527,   357,   357,   585,   357,   476,   569,   476,   476,
     478,   567,   478,   357,   357,   357,   373,   527,   357,   357,
     357,   357,   576,   344,     6,   579,   579,   576,   357,   594,
     571,   357,   357,   357,   594,   571,   487,   371,   359,   357,
     357,   373,   357,   357,   374,   357,   486,   486,   579,   554,
     582,   593,   478,   357,   376,   372,   571,   527,   374,   527,
     527,   527,   527,   374,   360,   357,   357,   594,   484,   594,
     594,   594,   487,   587,   597,   594,   594,   594,   594,   594,
     357,   594,   357,   373,   373,   357,   374,   357,   357,   588,
     588,   597,   579,   579,   374,   359,   359,   374,   571,   579,
     527,   527,   571,   357,   571,   527,   357,   357,   357,   357,
     587,   371,   357,   357,   374,   374,   571,   357,   527,   527,
     348,   594,   359,   371,   571,   571,   357,   357,   357,   527,
     360,   371,   597,   357,   357,   571,   571,   571,   357,   597,
     371,   359,   571,   571,   357,   571,   357,   597,   571,     6,
     359,   357,   360,   571,   597,   357,     6,   360,   185,   406
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   383,   385,   384,   386,   386,   387,   387,   387,   387,
     387,   387,   387,   387,   387,   387,   387,   387,   387,   388,
     388,   388,   388,   389,   390,   391,   392,   392,   392,   393,
     393,   394,   394,   396,   395,   397,   398,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,   412,   412,   412,   412,   412,   412,   412,   413,
     413,   414,   414,   415,   415,   415,   415,   415,   415,   415,
     415,   415,   415,   415,   415,   415,   415,   415,   416,   417,
     417,   418,   418,   419,   419,   420,   421,   420,   422,   420,
     423,   420,   424,   420,   425,   420,   426,   420,   427,   420,
     428,   420,   429,   420,   420,   430,   420,   420,   420,   420,
     420,   420,   420,   431,   420,   420,   420,   420,   420,   432,
     420,   420,   433,   420,   420,   420,   420,   420,   434,   420,
     435,   435,   436,   436,   438,   437,   439,   439,   439,   441,
     440,   443,   442,   445,   444,   447,   446,   449,   448,   450,
     450,   452,   451,   453,   453,   453,   453,   453,   453,   453,
     453,   453,   454,   454,   454,   454,   454,   454,   454,   454,
     454,   454,   454,   454,   454,   454,   455,   455,   455,   455,
     455,   455,   456,   456,   456,   456,   456,   456,   456,   456,
     456,   456,   456,   456,   456,   456,   456,   456,   456,   456,
     456,   456,   456,   456,   456,   456,   456,   456,   456,   457,
     457,   457,   457,   457,   457,   458,   458,   458,   459,   459,
     460,   460,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   462,   462,
     462,   462,   462,   463,   463,   464,   464,   465,   465,   465,
     465,   466,   466,   466,   466,   466,   466,   466,   466,   466,
     466,   467,   468,   468,   469,   470,   470,   470,   470,   470,
     470,   470,   470,   470,   470,   470,   470,   470,   470,   470,
     470,   470,   470,   470,   470,   470,   470,   470,   470,   470,
     470,   470,   470,   470,   470,   471,   471,   471,   471,   471,
     471,   471,   471,   471,   471,   471,   472,   472,   473,   474,
     475,   476,   477,   477,   477,   477,   478,   478,   478,   478,
     479,   479,   479,   479,   479,   479,   479,   479,   479,   480,
     480,   481,   481,   481,   481,   482,   483,   484,   484,   485,
     485,   486,   487,   487,   488,   488,   488,   488,   489,   491,
     490,   492,   490,   493,   490,   494,   490,   495,   490,   496,
     490,   497,   498,   490,   500,   499,   501,   499,   502,   499,
     503,   499,   504,   499,   506,   505,   508,   507,   510,   509,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   513,   513,   513,   513,   513,   513,   513,   513,
     513,   513,   513,   514,   515,   516,   517,   517,   517,   518,
     519,   520,   521,   521,   522,   521,   523,   523,   523,   524,
     525,   525,   526,   526,   526,   527,   527,   528,   528,   529,
     529,   529,   529,   529,   529,   529,   529,   529,   529,   529,
     530,   531,   532,   532,   532,   532,   533,   534,   534,   534,
     535,   536,   536,   536,   538,   537,   539,   537,   540,   540,
     540,   540,   540,   540,   542,   541,   544,   543,   545,   545,
     545,   546,   546,   546,   546,   546,   546,   546,   546,   546,
     546,   546,   546,   546,   546,   547,   547,   547,   547,   548,
     548,   550,   549,   551,   549,   552,   552,   552,   553,   553,
     554,   554,   555,   555,   555,   556,   556,   557,   557,   558,
     558,   559,   560,   560,   560,   560,   560,   560,   560,   561,
     560,   562,   563,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   571,   571,   571,   572,   572,   572,   572,   573,
     574,   574,   574,   574,   574,   575,   575,   576,   576,   577,
     577,   577,   577,   577,   578,   578,   579,   579,   580,   580,
     581,   581,   582,   582,   583,   583,   583,   584,   584,   584,
     585,   585,   585,   586,   586,   587,   587,   588,   589,   589,
     590,   590,   591,   591,   592,   592,   593,   593,   593,   593,
     593,   593,   593,   593,   593,   593,   593,   593,   594,   594,
     594,   594,   594,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   596,   596,   597,   597,   598,
     598,   599,   599,   599,   599,   599,   599,   599,   599,   599
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     3,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     6,    11,     1,     1,     3,     0,     3,
       0,     1,     1,     0,     5,     4,     4,     4,     4,     2,
       2,     2,     1,    10,    10,     1,    27,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     2,     1,     2,     2,     2,     2,     2,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     2,     1,     2,     2,     1,     0,     5,     0,     7,
       0,     7,     0,     5,     0,     5,     0,     5,     0,     3,
       0,     3,     0,     3,     1,     0,     3,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     1,     1,     1,     0,
       3,     1,     0,     3,     1,     1,     1,     1,     0,     5,
       3,     3,     1,     1,     0,     5,     1,     1,     2,     0,
       5,     0,     5,     0,    11,     0,    13,     0,    13,     1,
       1,     0,     9,     1,     1,     1,     1,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     8,     6,     2,     2,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     8,     8,     8,
      10,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     0,     2,     1,     1,
       3,     1,     1,     3,     1,     1,     1,     3,     3,     3,
       5,    10,     8,     6,     4,    10,     8,    11,     1,     2,
       2,     2,     2,     2,     2,     2,     1,     1,     2,     1,
       2,     1,     3,     0,    12,    10,     4,     2,     3,     0,
      12,     0,    11,     0,    15,     0,    12,     0,    12,     0,
      12,     0,     0,    12,     0,    12,     0,    11,     0,    12,
       0,    12,     0,    12,     0,    17,     0,    17,     0,     9,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,    20,    13,    16,     1,     1,     1,     1,
       1,     1,     9,    16,     0,    17,     1,     1,     1,     3,
       0,     2,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,    11,    13,    14,    14,     1,     6,     8,     9,
       7,     1,     1,     3,     0,    11,     0,    11,     1,     1,
       1,     1,     1,     1,     0,    10,     0,    13,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     0,
       2,     0,     3,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
      11,     1,     1,     2,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     2,     1,
       1,     1,     1,     1,     1,     2,     1,     2,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     1,     2,     1,
       1,     1,     1,     0,     2,     1,     2,     1,     5,     5,
       5,     5,     5,     5,     1,     1,     1,     3,     3,     4,
       4,     3,     3,     1,     1,     1,     1,     1,     1,     3,
       1,     4,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 808 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                   { new_shader(); }
#line 3407 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 19: /* const_val: T_FLOAT  */
#line 827 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = fui((yyvsp[0].flt)); }
#line 3413 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 20: /* const_val: T_INT  */
#line 828 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = (yyvsp[0].num);      }
#line 3419 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 21: /* const_val: '-' T_INT  */
#line 829 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = -(yyvsp[0].num);     }
#line 3425 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 22: /* const_val: T_HEX  */
#line 830 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = (yyvsp[0].unum);      }
#line 3431 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 23: /* localsize_header: T_A_LOCALSIZE const_val ',' const_val ',' const_val  */
#line 832 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                       {
                       variant->local_size[0] = (yyvsp[-4].unum);
                       variant->local_size[1] = (yyvsp[-2].unum);
                       variant->local_size[2] = (yyvsp[0].unum);
}
#line 3441 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 24: /* const_header: T_A_CONST '(' T_CONSTANT ')' const_val ',' const_val ',' const_val ',' const_val  */
#line 838 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                    {
                       add_const((yyvsp[-8].num), (yyvsp[-6].unum), (yyvsp[-4].unum), (yyvsp[-2].unum), (yyvsp[0].unum));
}
#line 3449 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 25: /* buf_header_init_val: const_val  */
#line 842 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { add_buf_init_val((yyvsp[0].unum)); }
#line 3455 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 29: /* buf_header_addr_reg: '(' T_CONSTANT ')'  */
#line 848 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                      {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;

                       info->buf_addr_regs[info->num_bufs - 1] = reg;
                       /* reserve space in immediates for the actual value to be plugged in later: */
                       add_const((yyvsp[-1].num), 0, 0, 0, 0);
}
#line 3468 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 31: /* buf_type: T_A_BUF  */
#line 858 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                  { (yyval.num) = KERNEL_BUF_UAV; }
#line 3474 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 32: /* buf_type: T_A_UBO  */
#line 859 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                  { (yyval.num) = KERNEL_BUF_UBO; }
#line 3480 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 33: /* $@2: %empty  */
#line 861 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                      {
                       int idx = info->num_bufs++;
                       assert(idx < MAX_BUFS);
                       info->buf_types[idx] = (yyvsp[-1].num);
                       info->buf_sizes[idx] = (yyvsp[0].unum);
}
#line 3491 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 35: /* invocationid_header: T_A_INVOCATIONID '(' T_REGISTER ')'  */
#line 868 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                         {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       add_sysval(reg, 0x7, SYSTEM_VALUE_LOCAL_INVOCATION_ID);
}
#line 3501 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 36: /* wgid_header: T_A_WGID '(' T_REGISTER ')'  */
#line 874 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                               {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       assert(variant->compiler->gen >= 5);
                       assert(reg >= regid(48, 0)); /* must be a high reg */
                       add_sysval(reg, 0x7, SYSTEM_VALUE_WORKGROUP_ID);
}
#line 3513 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 37: /* wgid_header: T_A_WGID '(' T_CONSTANT ')'  */
#line 881 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                               {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       assert(variant->compiler->gen < 5);
                       info->wgid = reg;
}
#line 3524 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 38: /* numwg_header: T_A_NUMWG '(' T_CONSTANT ')'  */
#line 888 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       info->numwg = reg;
                       /* reserve space in immediates for the actual value to be plugged in later: */
                       if (variant->compiler->gen >= 5)
                          add_const((yyvsp[-1].num), 0, 0, 0, 0);
}
#line 3537 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 39: /* branchstack_header: T_A_BRANCHSTACK const_val  */
#line 897 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { variant->branchstack = (yyvsp[0].unum); }
#line 3543 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 40: /* pvtmem_header: T_A_PVTMEM const_val  */
#line 899 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                    { variant->pvtmem_size = (yyvsp[0].unum); }
#line 3549 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 41: /* localmem_header: T_A_LOCALMEM const_val  */
#line 901 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                        { variant->shared_size = (yyvsp[0].unum); }
#line 3555 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 42: /* earlypreamble_header: T_A_EARLYPREAMBLE  */
#line 903 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                        { variant->early_preamble = 1; }
#line 3561 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 43: /* in_header: T_A_IN '(' T_REGISTER ')' T_IDENTIFIER '(' T_IDENTIFIER '=' integer ')'  */
#line 906 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                           { }
#line 3567 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 44: /* out_header: T_A_OUT '(' T_REGISTER ')' T_IDENTIFIER '(' T_IDENTIFIER '=' integer ')'  */
#line 908 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                            { }
#line 3573 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 46: /* tex_header: T_A_TEX '(' T_REGISTER ')' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer ',' T_MOD_TEX '=' integer ',' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' tex_header_opc  */
#line 919 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                 { }
#line 3579 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 47: /* fullnop_start_section: T_A_FULLNOPSTART  */
#line 921 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                        { is_in_fullnop_section = true; }
#line 3585 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 48: /* fullnop_end_section: T_A_FULLNOPEND  */
#line 922 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                    { is_in_fullnop_section = false; }
#line 3591 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 49: /* fullsync_start_section: T_A_FULLSYNCSTART  */
#line 923 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                          { is_in_fullsync_section = true; }
#line 3597 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 50: /* fullsync_end_section: T_A_FULLSYNCEND  */
#line 924 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                      { is_in_fullsync_section = false; }
#line 3603 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 51: /* iflag: T_SY  */
#line 926 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SY; }
#line 3609 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 52: /* iflag: T_SS  */
#line 927 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SS; }
#line 3615 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 53: /* iflag: T_JP  */
#line 928 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_JP; }
#line 3621 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 54: /* iflag: T_EQ_FLAG  */
#line 929 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { iflags.flags |= IR3_INSTR_EQ; }
#line 3627 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 55: /* iflag: T_SAT  */
#line 930 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SAT; }
#line 3633 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 56: /* iflag: T_RPT  */
#line 931 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.repeat = (yyvsp[0].num); }
#line 3639 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 57: /* iflag: T_UL  */
#line 932 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_UL; }
#line 3645 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 58: /* iflag: T_NOP  */
#line 933 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.nop = (yyvsp[0].tok); }
#line 3651 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 68: /* instr: iflags cat5_instr  */
#line 946 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                     { fixup_cat5_s2en(); }
#line 3657 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 78: /* label: T_IDENTIFIER ':'  */
#line 957 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                    { new_label((yyvsp[-1].str)); }
#line 3663 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 79: /* cat0_src1: '!' T_P0  */
#line 959 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.inv1 = true; (yyval.reg) = new_src((62 << 3) + (yyvsp[0].num), IR3_REG_PREDICATE); }
#line 3669 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 80: /* cat0_src1: T_P0  */
#line 960 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { (yyval.reg) = new_src((62 << 3) + (yyvsp[0].num), IR3_REG_PREDICATE); }
#line 3675 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 81: /* cat0_src2: '!' T_P0  */
#line 962 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.inv2 = true; (yyval.reg) = new_src((62 << 3) + (yyvsp[0].num), IR3_REG_PREDICATE); }
#line 3681 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 82: /* cat0_src2: T_P0  */
#line 963 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { (yyval.reg) = new_src((62 << 3) + (yyvsp[0].num), IR3_REG_PREDICATE); }
#line 3687 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 83: /* cat0_immed: '#' integer  */
#line 965 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.immed = (yyvsp[0].num); }
#line 3693 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 84: /* cat0_immed: '#' T_IDENTIFIER  */
#line 966 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                    { ralloc_steal(instr, (void *)(yyvsp[0].str)); instr->cat0.target_label = (yyvsp[0].str); }
#line 3699 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 85: /* cat0_instr: T_OP_NOP  */
#line 968 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_NOP); }
#line 3705 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 86: /* $@3: %empty  */
#line 969 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BR);   }
#line 3711 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 88: /* $@4: %empty  */
#line 970 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BRAO); }
#line 3717 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 90: /* $@5: %empty  */
#line 971 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BRAA); }
#line 3723 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 92: /* $@6: %empty  */
#line 972 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                         { new_instr(OPC_BRAC)->cat0.idx = (yyvsp[0].num); }
#line 3729 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 94: /* $@7: %empty  */
#line 973 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BANY); }
#line 3735 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 96: /* $@8: %empty  */
#line 974 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BALL); }
#line 3741 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 98: /* $@9: %empty  */
#line 975 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BRAX); }
#line 3747 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 100: /* $@10: %empty  */
#line 976 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_JUMP); }
#line 3753 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 102: /* $@11: %empty  */
#line 977 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CALL); }
#line 3759 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 104: /* cat0_instr: T_OP_RET  */
#line 978 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_RET); }
#line 3765 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 105: /* $@12: %empty  */
#line 979 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_KILL); }
#line 3771 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 107: /* cat0_instr: T_OP_END  */
#line 980 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_END); }
#line 3777 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 108: /* cat0_instr: T_OP_EMIT  */
#line 981 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_EMIT); }
#line 3783 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 109: /* cat0_instr: T_OP_CUT  */
#line 982 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CUT); }
#line 3789 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 110: /* cat0_instr: T_OP_CHMASK  */
#line 983 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CHMASK); }
#line 3795 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 111: /* cat0_instr: T_OP_CHSH  */
#line 984 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CHSH); }
#line 3801 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 112: /* cat0_instr: T_OP_FLOW_REV  */
#line 985 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_FLOW_REV); }
#line 3807 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 113: /* $@13: %empty  */
#line 986 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BKT); }
#line 3813 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 115: /* cat0_instr: T_OP_STKS  */
#line 987 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_STKS); }
#line 3819 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 116: /* cat0_instr: T_OP_STKR  */
#line 988 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_STKR); }
#line 3825 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 117: /* cat0_instr: T_OP_XSET  */
#line 989 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_XSET); }
#line 3831 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 118: /* cat0_instr: T_OP_XCLR  */
#line 990 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_XCLR); }
#line 3837 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 119: /* $@14: %empty  */
#line 991 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_GETONE); }
#line 3843 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 121: /* cat0_instr: T_OP_DBG  */
#line 992 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_DBG); }
#line 3849 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 122: /* $@15: %empty  */
#line 993 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_SHPS); }
#line 3855 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 124: /* cat0_instr: T_OP_SHPE  */
#line 994 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_SHPE); }
#line 3861 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 125: /* cat0_instr: T_OP_PREDT  */
#line 995 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDT); }
#line 3867 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 126: /* cat0_instr: T_OP_PREDF  */
#line 996 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDF); }
#line 3873 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 127: /* cat0_instr: T_OP_PREDE  */
#line 997 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDE); }
#line 3879 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 128: /* $@16: %empty  */
#line 998 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                        { new_instr(OPC_GETLAST); }
#line 3885 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 130: /* cat1_opc: T_OP_MOV '.' T_CAT1_TYPE_TYPE  */
#line 1000 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                 {
                       parse_type_type(new_instr(OPC_MOV), (yyvsp[0].str));
}
#line 3893 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 131: /* cat1_opc: T_OP_COV '.' T_CAT1_TYPE_TYPE  */
#line 1003 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                 {
                       parse_type_type(new_instr(OPC_MOV), (yyvsp[0].str));
}
#line 3901 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 134: /* $@17: %empty  */
#line 1010 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       {
                       new_instr(OPC_MOVMSK);
                       instr->cat1.src_type = TYPE_U32;
                       instr->cat1.dst_type = TYPE_U32;
                   }
#line 3911 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 135: /* cat1_movmsk: T_OP_MOVMSK '.' T_W $@17 dst_reg  */
#line 1014 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             {
                       if (((yyvsp[-2].num) % 32) != 0)
                          yyerror("w# must be multiple of 32");
                       if ((yyvsp[-2].num) < 32)
                          yyerror("w# must be at least 32");

                       int num = (yyvsp[-2].num) / 32;

                       instr->repeat = num - 1;
                       instr->dsts[0]->wrmask = (1 << num) - 1;
                   }
#line 3927 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 139: /* $@18: %empty  */
#line 1030 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       {
                       new_instr(OPC_MOV);
                       instr->cat1.src_type = TYPE_U16;
                       instr->cat1.dst_type = TYPE_U16;
                       new_dst((61 << 3) + 2, IR3_REG_HALF);
                   }
#line 3938 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 141: /* $@19: %empty  */
#line 1037 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                      {
                       new_instr(OPC_MOV);
                       instr->cat1.src_type = TYPE_S16;
                       instr->cat1.dst_type = TYPE_S16;
                       new_dst((61 << 3), IR3_REG_HALF);
                   }
#line 3949 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 143: /* $@20: %empty  */
#line 1044 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_SWZ), (yyvsp[0].str)); }
#line 3955 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 145: /* $@21: %empty  */
#line 1046 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_GAT), (yyvsp[0].str)); }
#line 3961 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 147: /* $@22: %empty  */
#line 1048 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_SCT), (yyvsp[0].str)); }
#line 3967 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 149: /* movs_invocation: uinteger  */
#line 1050 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[0].num); }
#line 3973 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 151: /* $@23: %empty  */
#line 1053 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                          { parse_type_type(new_instr(OPC_MOVS), (yyvsp[0].str)); }
#line 3979 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 162: /* cat2_opc_1src: T_OP_ABSNEG_F  */
#line 1066 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ABSNEG_F); }
#line 3985 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 163: /* cat2_opc_1src: T_OP_ABSNEG_S  */
#line 1067 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ABSNEG_S); }
#line 3991 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 164: /* cat2_opc_1src: T_OP_CLZ_B  */
#line 1068 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CLZ_B); }
#line 3997 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 165: /* cat2_opc_1src: T_OP_CLZ_S  */
#line 1069 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CLZ_S); }
#line 4003 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 166: /* cat2_opc_1src: T_OP_SIGN_F  */
#line 1070 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SIGN_F); }
#line 4009 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 167: /* cat2_opc_1src: T_OP_FLOOR_F  */
#line 1071 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_FLOOR_F); }
#line 4015 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 168: /* cat2_opc_1src: T_OP_CEIL_F  */
#line 1072 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CEIL_F); }
#line 4021 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 169: /* cat2_opc_1src: T_OP_RNDNE_F  */
#line 1073 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RNDNE_F); }
#line 4027 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 170: /* cat2_opc_1src: T_OP_RNDAZ_F  */
#line 1074 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RNDAZ_F); }
#line 4033 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 171: /* cat2_opc_1src: T_OP_TRUNC_F  */
#line 1075 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_TRUNC_F); }
#line 4039 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 172: /* cat2_opc_1src: T_OP_NOT_B  */
#line 1076 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_NOT_B); }
#line 4045 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 173: /* cat2_opc_1src: T_OP_BFREV_B  */
#line 1077 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BFREV_B); }
#line 4051 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 174: /* cat2_opc_1src: T_OP_SETRM  */
#line 1078 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SETRM); }
#line 4057 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 175: /* cat2_opc_1src: T_OP_CBITS_B  */
#line 1079 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CBITS_B); }
#line 4063 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 176: /* cat2_opc_2src_cnd: T_OP_CMPS_F  */
#line 1081 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_F); }
#line 4069 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 177: /* cat2_opc_2src_cnd: T_OP_CMPS_U  */
#line 1082 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_U); }
#line 4075 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 178: /* cat2_opc_2src_cnd: T_OP_CMPS_S  */
#line 1083 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_S); }
#line 4081 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 179: /* cat2_opc_2src_cnd: T_OP_CMPV_F  */
#line 1084 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_F); }
#line 4087 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 180: /* cat2_opc_2src_cnd: T_OP_CMPV_U  */
#line 1085 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_U); }
#line 4093 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 181: /* cat2_opc_2src_cnd: T_OP_CMPV_S  */
#line 1086 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_S); }
#line 4099 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 182: /* cat2_opc_2src: T_OP_ADD_F  */
#line 1088 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_F); }
#line 4105 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 183: /* cat2_opc_2src: T_OP_MIN_F  */
#line 1089 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_F); }
#line 4111 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 184: /* cat2_opc_2src: T_OP_MAX_F  */
#line 1090 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_F); }
#line 4117 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 185: /* cat2_opc_2src: T_OP_MUL_F  */
#line 1091 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_F); }
#line 4123 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 186: /* cat2_opc_2src: T_OP_ADD_U  */
#line 1092 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_U); }
#line 4129 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 187: /* cat2_opc_2src: T_OP_ADD_S  */
#line 1093 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_S); }
#line 4135 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 188: /* cat2_opc_2src: T_OP_SUB_U  */
#line 1094 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SUB_U); }
#line 4141 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 189: /* cat2_opc_2src: T_OP_SUB_S  */
#line 1095 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SUB_S); }
#line 4147 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 190: /* cat2_opc_2src: T_OP_MIN_U  */
#line 1096 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_U); }
#line 4153 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 191: /* cat2_opc_2src: T_OP_MIN_S  */
#line 1097 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_S); }
#line 4159 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 192: /* cat2_opc_2src: T_OP_MAX_U  */
#line 1098 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_U); }
#line 4165 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 193: /* cat2_opc_2src: T_OP_MAX_S  */
#line 1099 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_S); }
#line 4171 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 194: /* cat2_opc_2src: T_OP_AND_B  */
#line 1100 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_AND_B); }
#line 4177 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 195: /* cat2_opc_2src: T_OP_OR_B  */
#line 1101 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_OR_B); }
#line 4183 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 196: /* cat2_opc_2src: T_OP_XOR_B  */
#line 1102 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_XOR_B); }
#line 4189 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 197: /* cat2_opc_2src: T_OP_MUL_U24  */
#line 1103 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_U24); }
#line 4195 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 198: /* cat2_opc_2src: T_OP_MUL_S24  */
#line 1104 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_S24); }
#line 4201 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 199: /* cat2_opc_2src: T_OP_MULL_U  */
#line 1105 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MULL_U); }
#line 4207 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 200: /* cat2_opc_2src: T_OP_SHL_B  */
#line 1106 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHL_B); }
#line 4213 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 201: /* cat2_opc_2src: T_OP_SHR_B  */
#line 1107 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHR_B); }
#line 4219 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 202: /* cat2_opc_2src: T_OP_ASHR_B  */
#line 1108 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ASHR_B); }
#line 4225 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 203: /* cat2_opc_2src: T_OP_BARY_F  */
#line 1109 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BARY_F); }
#line 4231 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 204: /* cat2_opc_2src: T_OP_FLAT_B  */
#line 1110 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_FLAT_B); }
#line 4237 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 205: /* cat2_opc_2src: T_OP_MGEN_B  */
#line 1111 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MGEN_B); }
#line 4243 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 206: /* cat2_opc_2src: T_OP_GETBIT_B  */
#line 1112 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETBIT_B); }
#line 4249 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 207: /* cat2_opc_2src: T_OP_SHB  */
#line 1113 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHB); }
#line 4255 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 208: /* cat2_opc_2src: T_OP_MSAD  */
#line 1114 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MSAD); }
#line 4261 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 209: /* cond: T_LT  */
#line 1116 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_LT; }
#line 4267 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 210: /* cond: T_LE  */
#line 1117 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_LE; }
#line 4273 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 211: /* cond: T_GT  */
#line 1118 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_GT; }
#line 4279 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 212: /* cond: T_GE  */
#line 1119 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_GE; }
#line 4285 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 213: /* cond: T_EQ  */
#line 1120 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_EQ; }
#line 4291 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 214: /* cond: T_NE  */
#line 1121 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_NE; }
#line 4297 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 218: /* cat3_dp_signedness: '.' T_MIXED  */
#line 1127 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.signedness = IR3_SRC_MIXED; }
#line 4303 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 219: /* cat3_dp_signedness: '.' T_UNSIGNED  */
#line 1128 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.signedness = IR3_SRC_UNSIGNED; }
#line 4309 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 220: /* cat3_dp_pack: '.' T_LOW  */
#line 1130 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.packed = IR3_SRC_PACKED_LOW; }
#line 4315 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 221: /* cat3_dp_pack: '.' T_HIGH  */
#line 1131 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.packed = IR3_SRC_PACKED_HIGH; }
#line 4321 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 222: /* cat3_opc: T_OP_MAD_U16  */
#line 1133 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_U16); }
#line 4327 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 223: /* cat3_opc: T_OP_MADSH_U16  */
#line 1134 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MADSH_U16); }
#line 4333 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 224: /* cat3_opc: T_OP_MAD_S16  */
#line 1135 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_S16); }
#line 4339 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 225: /* cat3_opc: T_OP_MADSH_M16  */
#line 1136 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MADSH_M16); }
#line 4345 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 226: /* cat3_opc: T_OP_MAD_U24  */
#line 1137 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_U24); }
#line 4351 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 227: /* cat3_opc: T_OP_MAD_S24  */
#line 1138 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_S24); }
#line 4357 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 228: /* cat3_opc: T_OP_MAD_F16  */
#line 1139 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_F16); }
#line 4363 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 229: /* cat3_opc: T_OP_MAD_F32  */
#line 1140 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_F32); }
#line 4369 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 230: /* cat3_opc: T_OP_SEL_B16  */
#line 1141 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_B16); }
#line 4375 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 231: /* cat3_opc: T_OP_SEL_B32  */
#line 1142 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_B32); }
#line 4381 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 232: /* cat3_opc: T_OP_SEL_S16  */
#line 1143 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_S16); }
#line 4387 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 233: /* cat3_opc: T_OP_SEL_S32  */
#line 1144 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_S32); }
#line 4393 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 234: /* cat3_opc: T_OP_SEL_F16  */
#line 1145 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_F16); }
#line 4399 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 235: /* cat3_opc: T_OP_SEL_F32  */
#line 1146 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_F32); }
#line 4405 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 236: /* cat3_opc: T_OP_SAD_S16  */
#line 1147 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAD_S16); }
#line 4411 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 237: /* cat3_opc: T_OP_SAD_S32  */
#line 1148 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAD_S32); }
#line 4417 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 238: /* cat3_imm_reg_opc: T_OP_SHRM  */
#line 1150 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHRM); }
#line 4423 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 239: /* cat3_imm_reg_opc: T_OP_SHLM  */
#line 1151 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHLM); }
#line 4429 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 240: /* cat3_imm_reg_opc: T_OP_SHRG  */
#line 1152 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHRG); }
#line 4435 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 241: /* cat3_imm_reg_opc: T_OP_SHLG  */
#line 1153 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHLG); }
#line 4441 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 242: /* cat3_imm_reg_opc: T_OP_ANDG  */
#line 1154 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ANDG); }
#line 4447 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 243: /* cat3_wmm: T_OP_WMM  */
#line 1156 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_WMM); }
#line 4453 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 244: /* cat3_wmm: T_OP_WMM_ACCU  */
#line 1157 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_WMM_ACCU); }
#line 4459 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 245: /* cat3_dp: T_OP_DP2ACC  */
#line 1159 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DP2ACC); }
#line 4465 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 246: /* cat3_dp: T_OP_DP4ACC  */
#line 1160 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DP4ACC); }
#line 4471 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 251: /* cat4_opc: T_OP_RCP  */
#line 1167 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RCP); }
#line 4477 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 252: /* cat4_opc: T_OP_RSQ  */
#line 1168 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RSQ); }
#line 4483 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 253: /* cat4_opc: T_OP_LOG2  */
#line 1169 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_LOG2); }
#line 4489 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 254: /* cat4_opc: T_OP_EXP2  */
#line 1170 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_EXP2); }
#line 4495 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 255: /* cat4_opc: T_OP_SIN  */
#line 1171 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SIN); }
#line 4501 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 256: /* cat4_opc: T_OP_COS  */
#line 1172 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_COS); }
#line 4507 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 257: /* cat4_opc: T_OP_SQRT  */
#line 1173 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SQRT); }
#line 4513 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 258: /* cat4_opc: T_OP_HRSQ  */
#line 1174 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HRSQ); }
#line 4519 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 259: /* cat4_opc: T_OP_HLOG2  */
#line 1175 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HLOG2); }
#line 4525 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 260: /* cat4_opc: T_OP_HEXP2  */
#line 1176 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HEXP2); }
#line 4531 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 262: /* cat5_opc_dsxypp: T_OP_DSXPP_1  */
#line 1180 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSXPP_1)->cat5.type = TYPE_F32; }
#line 4537 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 263: /* cat5_opc_dsxypp: T_OP_DSYPP_1  */
#line 1181 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSYPP_1)->cat5.type = TYPE_F32; }
#line 4543 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 264: /* cat5_opc_isam: T_OP_ISAM  */
#line 1183 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAM)->flags |= IR3_INSTR_INV_1D; }
#line 4549 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 265: /* cat5_opc: T_OP_ISAML  */
#line 1185 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAML); }
#line 4555 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 266: /* cat5_opc: T_OP_ISAMM  */
#line 1186 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAMM); }
#line 4561 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 267: /* cat5_opc: T_OP_SAM  */
#line 1187 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAM); }
#line 4567 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 268: /* cat5_opc: T_OP_SAMB  */
#line 1188 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMB); }
#line 4573 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 269: /* cat5_opc: T_OP_SAML  */
#line 1189 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAML); }
#line 4579 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 270: /* cat5_opc: T_OP_SAMGQ  */
#line 1190 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGQ); }
#line 4585 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 271: /* cat5_opc: T_OP_GETLOD  */
#line 1191 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETLOD); }
#line 4591 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 272: /* cat5_opc: T_OP_CONV  */
#line 1192 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CONV); }
#line 4597 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 273: /* cat5_opc: T_OP_CONVM  */
#line 1193 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CONVM); }
#line 4603 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 274: /* cat5_opc: T_OP_GETSIZE  */
#line 1194 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETSIZE); }
#line 4609 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 275: /* cat5_opc: T_OP_GETBUF  */
#line 1195 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETBUF); }
#line 4615 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 276: /* cat5_opc: T_OP_GETPOS  */
#line 1196 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETPOS); }
#line 4621 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 277: /* cat5_opc: T_OP_GETINFO  */
#line 1197 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETINFO); }
#line 4627 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 278: /* cat5_opc: T_OP_DSX  */
#line 1198 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSX); }
#line 4633 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 279: /* cat5_opc: T_OP_DSY  */
#line 1199 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSY); }
#line 4639 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 280: /* cat5_opc: T_OP_GATHER4R  */
#line 1200 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4R); }
#line 4645 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 281: /* cat5_opc: T_OP_GATHER4G  */
#line 1201 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4G); }
#line 4651 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 282: /* cat5_opc: T_OP_GATHER4B  */
#line 1202 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4B); }
#line 4657 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 283: /* cat5_opc: T_OP_GATHER4A  */
#line 1203 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4A); }
#line 4663 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 284: /* cat5_opc: T_OP_SAMGP0  */
#line 1204 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP0); }
#line 4669 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 285: /* cat5_opc: T_OP_SAMGP1  */
#line 1205 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP1); }
#line 4675 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 286: /* cat5_opc: T_OP_SAMGP2  */
#line 1206 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP2); }
#line 4681 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 287: /* cat5_opc: T_OP_SAMGP3  */
#line 1207 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP3); }
#line 4687 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 288: /* cat5_opc: T_OP_RGETPOS  */
#line 1208 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RGETPOS); }
#line 4693 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 289: /* cat5_opc: T_OP_RGETINFO  */
#line 1209 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RGETINFO); }
#line 4699 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 290: /* cat5_opc: T_OP_BRCST_A  */
#line 1210 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BRCST_ACTIVE); }
#line 4705 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 291: /* cat5_opc: T_OP_QSHUFFLE_BRCST  */
#line 1211 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_BRCST); }
#line 4711 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 292: /* cat5_opc: T_OP_QSHUFFLE_H  */
#line 1212 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_HORIZ); }
#line 4717 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 293: /* cat5_opc: T_OP_QSHUFFLE_V  */
#line 1213 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_VERT); }
#line 4723 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 294: /* cat5_opc: T_OP_QSHUFFLE_DIAG  */
#line 1214 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_DIAG); }
#line 4729 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 295: /* cat5_flag: '.' T_3D  */
#line 1216 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_3D; }
#line 4735 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 296: /* cat5_flag: '.' 'a'  */
#line 1217 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_A; }
#line 4741 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 297: /* cat5_flag: '.' 'o'  */
#line 1218 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_O; }
#line 4747 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 298: /* cat5_flag: '.' 'p'  */
#line 1219 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_P; }
#line 4753 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 299: /* cat5_flag: '.' 's'  */
#line 1220 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_S; }
#line 4759 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 300: /* cat5_flag: '.' T_S2EN  */
#line 1221 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_S2EN; }
#line 4765 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 301: /* cat5_flag: '.' T_1D  */
#line 1222 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags &= ~IR3_INSTR_INV_1D; }
#line 4771 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 302: /* cat5_flag: '.' T_UNIFORM  */
#line 1223 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { }
#line 4777 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 303: /* cat5_flag: '.' T_NONUNIFORM  */
#line 1224 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                     { instr->flags |= IR3_INSTR_NONUNIF; }
#line 4783 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 304: /* cat5_flag: '.' T_BASE  */
#line 1225 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_B; instr->cat5.tex_base = (yyvsp[0].tok); }
#line 4789 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 305: /* cat5_flag: '.' T_W  */
#line 1226 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.cluster_size = (yyvsp[0].num); }
#line 4795 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 308: /* cat5_samp: T_SAMP  */
#line 1230 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.samp = (yyvsp[0].tok); }
#line 4801 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 309: /* cat5_tex: T_TEX  */
#line 1231 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.tex = (yyvsp[0].tok); }
#line 4807 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 310: /* cat5_type: '(' type ')'  */
#line 1232 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.type = (yyvsp[-1].type); }
#line 4813 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 311: /* cat5_a1: src_a1  */
#line 1233 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_A1EN; }
#line 4819 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 327: /* cat5_instr: cat5_opc_isam '.' 'v' cat5_flags cat5_type dst_reg ',' src_gpr src_uoffset ',' cat5_samp_tex_all  */
#line 1252 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                                    { instr->flags |= IR3_INSTR_V; }
#line 4825 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 328: /* cat5_instr: T_OP_TCINV  */
#line 1253 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_TCINV); }
#line 4831 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 329: /* cat6_typed: '.' T_UNTYPED  */
#line 1255 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat6.typed = 0; }
#line 4837 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 330: /* cat6_typed: '.' T_TYPED  */
#line 1256 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat6.typed = 1; }
#line 4843 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 331: /* cat6_dim: '.' T_1D  */
#line 1258 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 1; }
#line 4849 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 332: /* cat6_dim: '.' T_2D  */
#line 1259 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 2; }
#line 4855 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 333: /* cat6_dim: '.' T_3D  */
#line 1260 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 3; }
#line 4861 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 334: /* cat6_dim: '.' T_4D  */
#line 1261 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 4; }
#line 4867 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 335: /* cat6_type: '.' type  */
#line 1263 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.type = (yyvsp[0].type); }
#line 4873 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 336: /* cat6_imm_offset: offset  */
#line 1264 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 4879 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 339: /* cat6_dst_offset: offset  */
#line 1267 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.dst_offset = (yyvsp[0].num); }
#line 4885 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 341: /* cat6_immed: integer  */
#line 1270 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.iim_val = (yyvsp[0].num); }
#line 4891 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 342: /* cat6_src_shift: '<' '<' integer  */
#line 1272 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                {(yyval.unum) = (yyvsp[0].num);}
#line 4897 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 343: /* cat6_src_shift: %empty  */
#line 1273 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                {(yyval.unum) = 0;}
#line 4903 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 344: /* cat6_a6xx_global_address_pt2: '(' '(' '(' src cat6_src_shift ')' offset ')' '<' '<' integer ')'  */
#line 1276 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                     {
                        illegal_syntax_from(7, "pre-a7xx global offset syntax");
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-7].unum);
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-5].num);
                   }
#line 4913 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 345: /* cat6_a6xx_global_address_pt2: '(' '(' src cat6_src_shift offset ')' '<' '<' integer ')'  */
#line 1281 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                             {
                        illegal_syntax_from(7, "pre-a7xx global offset syntax");
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-6].unum);
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-5].num);
                   }
#line 4923 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 346: /* cat6_a6xx_global_address_pt2: '(' src cat6_src_shift ')'  */
#line 1286 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              {
                        illegal_syntax_from(7, "pre-a7xx global offset syntax");
                        // The shift contains the implicit type shift, subtract it.
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-1].unum) - cat6_type_shift();
                        new_src(0, IR3_REG_IMMED)->uim_val = 0;
                   }
#line 4934 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 347: /* cat6_a6xx_global_address_pt2: src offset  */
#line 1292 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              {
                        if (variant->compiler->gen < 7) {
                            new_src(0, IR3_REG_IMMED)->uim_val = 0;
                            new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[0].num);
                        } else {
                            new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[0].num);
                            // Dummy src to smooth the difference between a6xx and a7xx
                            new_src(0, IR3_REG_IMMED)->uim_val = 0;
                        }
                   }
#line 4949 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 349: /* $@24: %empty  */
#line 1306 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDG); }
#line 4955 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 351: /* $@25: %empty  */
#line 1307 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDG_A); }
#line 4961 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 353: /* $@26: %empty  */
#line 1308 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDG_K); }
#line 4967 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 355: /* $@27: %empty  */
#line 1309 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDP); }
#line 4973 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 357: /* $@28: %empty  */
#line 1310 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDL); }
#line 4979 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 359: /* $@29: %empty  */
#line 1311 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDLW); }
#line 4985 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 361: /* $@30: %empty  */
#line 1312 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDLV); }
#line 4991 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 362: /* $@31: %empty  */
#line 1312 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                  {
                       new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[-1].num);
                   }
#line 4999 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 364: /* $@32: %empty  */
#line 1316 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_STG); dummy_dst(); }
#line 5005 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 366: /* $@33: %empty  */
#line 1317 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_STG_A); dummy_dst(); }
#line 5011 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 368: /* $@34: %empty  */
#line 1318 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STP); dummy_dst(); }
#line 5017 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 370: /* $@35: %empty  */
#line 1319 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STL); dummy_dst(); }
#line 5023 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 372: /* $@36: %empty  */
#line 1320 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STLW); dummy_dst(); }
#line 5029 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 374: /* $@37: %empty  */
#line 1322 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_LDIB); }
#line 5035 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 376: /* $@38: %empty  */
#line 1323 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STIB); dummy_dst(); }
#line 5041 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 378: /* $@39: %empty  */
#line 1325 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                 { new_instr(OPC_PREFETCH); new_dst(0,0); /* dummy dst */ }
#line 5047 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 380: /* cat6_atomic_opc: T_OP_ATOMIC_ADD  */
#line 1327 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_ADD); }
#line 5053 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 381: /* cat6_atomic_opc: T_OP_ATOMIC_SUB  */
#line 1328 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_SUB); }
#line 5059 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 382: /* cat6_atomic_opc: T_OP_ATOMIC_XCHG  */
#line 1329 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_XCHG); }
#line 5065 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 383: /* cat6_atomic_opc: T_OP_ATOMIC_INC  */
#line 1330 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_INC); }
#line 5071 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 384: /* cat6_atomic_opc: T_OP_ATOMIC_DEC  */
#line 1331 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_DEC); }
#line 5077 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 385: /* cat6_atomic_opc: T_OP_ATOMIC_CMPXCHG  */
#line 1332 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_CMPXCHG); }
#line 5083 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 386: /* cat6_atomic_opc: T_OP_ATOMIC_MIN  */
#line 1333 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_MIN); }
#line 5089 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 387: /* cat6_atomic_opc: T_OP_ATOMIC_MAX  */
#line 1334 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_MAX); }
#line 5095 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 388: /* cat6_atomic_opc: T_OP_ATOMIC_AND  */
#line 1335 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_AND); }
#line 5101 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 389: /* cat6_atomic_opc: T_OP_ATOMIC_OR  */
#line 1336 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_OR); }
#line 5107 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 390: /* cat6_atomic_opc: T_OP_ATOMIC_XOR  */
#line 1337 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_XOR); }
#line 5113 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 391: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_ADD  */
#line 1339 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_ADD); }
#line 5119 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 392: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_SUB  */
#line 1340 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_SUB); }
#line 5125 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 393: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_XCHG  */
#line 1341 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_XCHG); }
#line 5131 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 394: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_INC  */
#line 1342 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_INC); }
#line 5137 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 395: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_DEC  */
#line 1343 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_DEC); }
#line 5143 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 396: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_CMPXCHG  */
#line 1344 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_CMPXCHG); }
#line 5149 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 397: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_MIN  */
#line 1345 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_MIN); }
#line 5155 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 398: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_MAX  */
#line 1346 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_MAX); }
#line 5161 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 399: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_AND  */
#line 1347 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_AND); }
#line 5167 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 400: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_OR  */
#line 1348 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_OR); }
#line 5173 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 401: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_XOR  */
#line 1349 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_XOR); }
#line 5179 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 402: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_ADD  */
#line 1351 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_ADD); }
#line 5185 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 403: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_SUB  */
#line 1352 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_SUB); }
#line 5191 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 404: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_XCHG  */
#line 1353 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_XCHG); }
#line 5197 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 405: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_INC  */
#line 1354 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_INC); }
#line 5203 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 406: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_DEC  */
#line 1355 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_DEC); }
#line 5209 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 407: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_CMPXCHG  */
#line 1356 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_CMPXCHG); }
#line 5215 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 408: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_MIN  */
#line 1357 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_MIN); }
#line 5221 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 409: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_MAX  */
#line 1358 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_MAX); }
#line 5227 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 410: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_AND  */
#line 1359 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_AND); }
#line 5233 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 411: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_OR  */
#line 1360 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_OR); }
#line 5239 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 412: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_XOR  */
#line 1361 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_XOR); }
#line 5245 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 419: /* cat6_ibo_opc_1src: T_OP_RESINFO  */
#line 1373 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RESINFO); }
#line 5251 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 420: /* cat6_ibo_opc_ldgb: T_OP_LDGB  */
#line 1375 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_LDGB); }
#line 5257 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 421: /* cat6_ibo_opc_stgb: T_OP_STGB  */
#line 1376 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_STGB); }
#line 5263 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 424: /* $@40: %empty  */
#line 1380 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                  { dummy_dst(); }
#line 5269 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 426: /* cat6_id_opc: T_OP_GETSPID  */
#line 1383 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { new_instr(OPC_GETSPID); }
#line 5275 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 427: /* cat6_id_opc: T_OP_GETWID  */
#line 1384 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { new_instr(OPC_GETWID); }
#line 5281 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 428: /* cat6_id_opc: T_OP_GETFIBERID  */
#line 1385 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_GETFIBERID); }
#line 5287 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 431: /* cat6_bindless_base: '.' T_BASE  */
#line 1390 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              { instr->flags |= IR3_INSTR_B; instr->cat6.base = (yyvsp[0].tok); }
#line 5293 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 434: /* cat6_bindless_mode: T_NONUNIFORM cat6_bindless_base  */
#line 1394 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                   { instr->flags |= IR3_INSTR_NONUNIF; }
#line 5299 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 436: /* cat6_reg_or_immed: integer  */
#line 1397 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                           { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 5305 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 437: /* cat6_bindless_ibo_opc_1src: T_OP_RESINFO_B  */
#line 1399 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                 { new_instr(OPC_RESINFO); }
#line 5311 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 438: /* cat6_bindless_ibo_opc_1src: T_OP_RESBASE  */
#line 1400 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                 { new_instr(OPC_RESBASE); }
#line 5317 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 439: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_ADD  */
#line 1402 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                     { new_instr(OPC_ATOMIC_B_ADD); dummy_dst(); }
#line 5323 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 440: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_SUB  */
#line 1403 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_SUB); dummy_dst(); }
#line 5329 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 441: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_XCHG  */
#line 1404 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_XCHG); dummy_dst(); }
#line 5335 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 442: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_INC  */
#line 1405 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_INC); dummy_dst(); }
#line 5341 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 443: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_DEC  */
#line 1406 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_DEC); dummy_dst(); }
#line 5347 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 444: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_CMPXCHG  */
#line 1407 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_CMPXCHG); dummy_dst(); }
#line 5353 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 445: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_MIN  */
#line 1408 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_MIN); dummy_dst(); }
#line 5359 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 446: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_MAX  */
#line 1409 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_MAX); dummy_dst(); }
#line 5365 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 447: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_AND  */
#line 1410 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_AND); dummy_dst(); }
#line 5371 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 448: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_OR  */
#line 1411 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_OR); dummy_dst(); }
#line 5377 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 449: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_XOR  */
#line 1412 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_XOR); dummy_dst(); }
#line 5383 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 450: /* cat6_bindless_ibo_opc_3src: T_OP_STIB_B  */
#line 1414 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_STIB); dummy_dst(); }
#line 5389 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 451: /* cat6_bindless_ibo_opc_3src_dst: T_OP_LDIB_B  */
#line 1416 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                         { new_instr(OPC_LDIB); }
#line 5395 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 453: /* cat6_bindless_ibo: cat6_bindless_ibo_opc_2src cat6_typed cat6_dim cat6_type '.' cat6_immed '.' cat6_bindless_mode src_reg ',' cat6_reg_or_immed ',' cat6_reg_or_immed  */
#line 1419 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                                                                                      { swap(instr->srcs[0], instr->srcs[2]); }
#line 5401 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 454: /* cat6_bindless_ibo: cat6_bindless_ibo_opc_3src cat6_typed cat6_dim cat6_type '.' cat6_immed '.' cat6_bindless_mode src_reg ',' cat6_reg_or_immed src_uoffset ',' cat6_reg_or_immed  */
#line 1420 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                                                                                                  { swap(instr->srcs[0], instr->srcs[3]); }
#line 5407 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 455: /* cat6_bindless_ibo: cat6_bindless_ibo_opc_3src_dst cat6_typed cat6_dim cat6_type '.' cat6_immed '.' cat6_bindless_mode dst_reg ',' cat6_reg_or_immed src_uoffset ',' cat6_reg_or_immed  */
#line 1421 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                                                                                                      { swap(instr->srcs[0], instr->srcs[2]); swap(instr->srcs[1], instr->srcs[2]); }
#line 5413 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 456: /* cat6_bindless_ldc_opc: T_OP_LDC  */
#line 1423 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                 { new_instr(OPC_LDC); }
#line 5419 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 457: /* cat6_bindless_ldc_middle: T_OFFSET '.' cat6_immed '.' cat6_bindless_mode dst_reg  */
#line 1427 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                               { instr->cat6.d = (yyvsp[-5].tok); }
#line 5425 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 458: /* cat6_bindless_ldc_middle: 'u' '.' T_OFFSET '.' cat6_immed '.' cat6_bindless_mode dst_reg  */
#line 1428 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                       { instr->flags |= IR3_INSTR_U; instr->cat6.d = (yyvsp[-5].tok); }
#line 5431 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 459: /* cat6_bindless_ldc_middle: cat6_immed '.' 'k' '.' cat6_bindless_mode 'c' '[' T_A1 ']'  */
#line 1429 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                   { instr->opc = OPC_LDC_K; }
#line 5437 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 460: /* cat6_bindless_ldc: cat6_bindless_ldc_opc '.' cat6_bindless_ldc_middle ',' cat6_reg_or_immed ',' cat6_reg_or_immed  */
#line 1431 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                                  {
                      instr->cat6.type = TYPE_U32;
                      /* TODO cleanup ir3 src order: */
                      swap(instr->srcs[0], instr->srcs[1]);
                   }
#line 5447 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 461: /* const_dst: integer  */
#line 1437 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                          { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 5453 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 462: /* const_dst: T_A1  */
#line 1438 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                       { new_src(0, IR3_REG_IMMED)->iim_val = 0; instr->flags |= IR3_INSTR_A1EN; }
#line 5459 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 463: /* const_dst: T_A1 '+' integer  */
#line 1439 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); instr->flags |= IR3_INSTR_A1EN; }
#line 5465 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 464: /* $@41: %empty  */
#line 1442 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                        { new_instr(OPC_STC); }
#line 5471 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 466: /* $@42: %empty  */
#line 1443 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                        { new_instr(OPC_STSC); }
#line 5477 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 468: /* cat6_shfl_mode: T_MOD_XOR  */
#line 1445 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat6.shfl_mode = SHFL_XOR;   }
#line 5483 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 469: /* cat6_shfl_mode: T_MOD_UP  */
#line 1446 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat6.shfl_mode = SHFL_UP;    }
#line 5489 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 470: /* cat6_shfl_mode: T_MOD_DOWN  */
#line 1447 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat6.shfl_mode = SHFL_DOWN;  }
#line 5495 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 471: /* cat6_shfl_mode: T_MOD_RUP  */
#line 1448 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat6.shfl_mode = SHFL_RUP;   }
#line 5501 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 472: /* cat6_shfl_mode: T_MOD_RDOWN  */
#line 1449 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat6.shfl_mode = SHFL_RDOWN; }
#line 5507 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 473: /* cat6_shfl_mode: integer  */
#line 1453 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat6.shfl_mode = (yyvsp[0].num); }
#line 5513 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 474: /* $@43: %empty  */
#line 1456 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                   { new_instr(OPC_SHFL); }
#line 5519 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 476: /* $@44: %empty  */
#line 1458 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                             {
                     new_instr(OPC_RAY_INTERSECTION);
                     }
#line 5527 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 478: /* cat6_todo: T_OP_G2L  */
#line 1462 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_G2L); }
#line 5533 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 479: /* cat6_todo: T_OP_L2G  */
#line 1463 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_L2G); }
#line 5539 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 480: /* cat6_todo: T_OP_RESFMT  */
#line 1464 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_RESFMT); }
#line 5545 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 495: /* cat7_scope: '.' 'w'  */
#line 1481 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.w = true; }
#line 5551 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 496: /* cat7_scope: '.' 'r'  */
#line 1482 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.r = true; }
#line 5557 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 497: /* cat7_scope: '.' 'l'  */
#line 1483 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.l = true; }
#line 5563 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 498: /* cat7_scope: '.' 'g'  */
#line 1484 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.g = true; }
#line 5569 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 501: /* $@45: %empty  */
#line 1489 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_BAR); }
#line 5575 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 503: /* $@46: %empty  */
#line 1490 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_FENCE); }
#line 5581 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 505: /* cat7_data_cache: T_OP_DCCLN  */
#line 1492 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_DCCLN); }
#line 5587 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 506: /* cat7_data_cache: T_OP_DCINV  */
#line 1493 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_DCINV); }
#line 5593 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 507: /* cat7_data_cache: T_OP_DCFLU  */
#line 1494 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_DCFLU); }
#line 5599 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 509: /* cat7_alias_dst: T_RT  */
#line 1497 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                        { new_dst((yyvsp[0].num), IR3_REG_RT); }
#line 5605 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 512: /* cat7_alias_scope: T_MOD_TEX  */
#line 1502 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { instr->cat7.alias_scope = ALIAS_TEX; }
#line 5611 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 513: /* cat7_alias_scope: T_MOD_MEM  */
#line 1503 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { instr->cat7.alias_scope = ALIAS_MEM; }
#line 5617 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 514: /* cat7_alias_scope: T_MOD_RT  */
#line 1504 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { instr->cat7.alias_scope = ALIAS_RT; }
#line 5623 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 520: /* cat7_alias_type: cat7_alias_float_type  */
#line 1513 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                        { instr->cat7.alias_type_float = true; }
#line 5629 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 521: /* cat7_alias_table_size_minus_one: T_INT  */
#line 1515 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { instr->cat7.alias_table_size_minus_one = (yyvsp[0].num); }
#line 5635 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 524: /* cat7_instr: T_OP_SLEEP  */
#line 1519 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_SLEEP); }
#line 5641 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 525: /* cat7_instr: T_OP_CCINV  */
#line 1520 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_CCINV); }
#line 5647 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 526: /* cat7_instr: T_OP_ICINV  */
#line 1521 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_ICINV); }
#line 5653 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 527: /* cat7_instr: T_OP_LOCK  */
#line 1522 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_LOCK); }
#line 5659 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 528: /* cat7_instr: T_OP_UNLOCK  */
#line 1523 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_UNLOCK); }
#line 5665 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 529: /* $@47: %empty  */
#line 1524 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                              {
                       new_instr(OPC_ALIAS);
                   }
#line 5673 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 531: /* raw_instr: T_RAW  */
#line 1528 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                   {new_instr(OPC_META_RAW)->raw.value = (yyvsp[0].u64);}
#line 5679 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 534: /* meta_print_reg: ',' T_REGISTER  */
#line 1533 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                               {
	meta_print_data.regs_to_dump[meta_print_data.regs_count++] = (yyvsp[0].num);
}
#line 5687 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 535: /* meta_print_start: T_OP_PRINT T_REGISTER  */
#line 1537 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                        {
	meta_print_data.reg_address_lo = (yyvsp[0].num);
	meta_print_data.reg_address_hi = (yyvsp[0].num) + 2;
	meta_print_data.reg_tmp = (yyvsp[0].num) + 4;
	meta_print_data.regs_count = 0;
}
#line 5698 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 536: /* meta_print: meta_print_start meta_print_regs  */
#line 1544 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                             {
	/* low */
	new_instr(OPC_MOV);
	instr->cat1.src_type = TYPE_U32;
	instr->cat1.dst_type = TYPE_U32;
	new_dst(meta_print_data.reg_address_lo, 0);
	new_src(0, IR3_REG_IMMED)->uim_val = info->shader_print_buffer_iova & 0xffffffff;

	/* high */
	new_instr(OPC_MOV);
	instr->cat1.src_type = TYPE_U32;
	instr->cat1.dst_type = TYPE_U32;
	new_dst(meta_print_data.reg_address_hi, 0);
	new_src(0, IR3_REG_IMMED)->uim_val = info->shader_print_buffer_iova >> 32;

	/* offset */
	new_instr(OPC_MOV);
	instr->cat1.src_type = TYPE_U32;
	instr->cat1.dst_type = TYPE_U32;
	new_dst(meta_print_data.reg_tmp, 0);
	new_src(0, IR3_REG_IMMED)->uim_val = 4 * meta_print_data.regs_count;

	new_instr(OPC_NOP);
	instr->repeat = 5;

	/* Increment and get current offset into print buffer */
	new_instr(OPC_ATOMIC_G_ADD);
	instr->cat6.d = 1;
	instr->cat6.typed = 0;
	instr->cat6.type = TYPE_U32;
	instr->cat6.iim_val = 1;

	new_dst(meta_print_data.reg_address_lo, 0);
	new_src(meta_print_data.reg_address_lo, 0);
	new_src(meta_print_data.reg_tmp, 0);

	/* Store all regs */
	for (uint32_t i = 0; i < meta_print_data.regs_count; i++) {
		new_instr(OPC_STG);
		dummy_dst();
		instr->cat6.type = TYPE_U32;
		instr->flags = IR3_INSTR_SY;
		new_src(meta_print_data.reg_address_lo, 0);
		new_src(0, IR3_REG_IMMED)->iim_val = 0;
		new_src(meta_print_data.regs_to_dump[i], IR3_REG_R);
		new_src(0, IR3_REG_IMMED)->iim_val = 1;

		new_instr(OPC_ADD_U);
		instr->flags = IR3_INSTR_SS;
		new_dst(meta_print_data.reg_address_lo, 0);
		new_src(meta_print_data.reg_address_lo, 0);
		new_src(0, IR3_REG_IMMED)->uim_val = 4;

		new_instr(OPC_NOP);
		instr->repeat = 5;
	}
}
#line 5760 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 537: /* src_gpr: T_REGISTER  */
#line 1602 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((yyvsp[0].num), 0); }
#line 5766 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 538: /* src_a0: T_A0  */
#line 1603 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((61 << 3), IR3_REG_HALF); }
#line 5772 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 539: /* src_a1: T_A1  */
#line 1604 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((61 << 3) + 1, IR3_REG_HALF); }
#line 5778 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 540: /* src_p0: T_P0  */
#line 1605 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((62 << 3) + (yyvsp[0].num), IR3_REG_PREDICATE); }
#line 5784 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 545: /* dst: T_REGISTER  */
#line 1612 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((yyvsp[0].num), 0); }
#line 5790 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 546: /* dst: T_A0  */
#line 1613 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((61 << 3), IR3_REG_HALF); }
#line 5796 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 547: /* dst: T_A1  */
#line 1614 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((61 << 3) + 1, IR3_REG_HALF); }
#line 5802 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 548: /* dst: T_P0  */
#line 1615 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((62 << 3) + (yyvsp[0].num), IR3_REG_PREDICATE); }
#line 5808 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 549: /* const: T_CONSTANT  */
#line 1617 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((yyvsp[0].num), IR3_REG_CONST); }
#line 5814 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 550: /* dst_reg_flag: T_EVEN  */
#line 1619 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_EVEN; }
#line 5820 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 551: /* dst_reg_flag: T_POS_INFINITY  */
#line 1620 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_POS_INF; }
#line 5826 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 552: /* dst_reg_flag: T_NEG_INFINITY  */
#line 1621 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_NEG_INF; }
#line 5832 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 553: /* dst_reg_flag: T_EI  */
#line 1622 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_EI; }
#line 5838 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 554: /* dst_reg_flag: T_WRMASK  */
#line 1623 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.wrmask = (yyvsp[0].num); }
#line 5844 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 557: /* dst_reg: dst  */
#line 1629 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { (yyvsp[0].reg)->flags |= IR3_REG_R; }
#line 5850 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 558: /* dst_reg: dst_reg_flags dst  */
#line 1630 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { (yyvsp[0].reg)->flags |= IR3_REG_R; }
#line 5856 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 559: /* src_reg_flag: T_ABSNEG  */
#line 1632 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_ABS|IR3_REG_NEGATE; }
#line 5862 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 560: /* src_reg_flag: T_NEG  */
#line 1633 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_NEGATE; }
#line 5868 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 561: /* src_reg_flag: T_ABS  */
#line 1634 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_ABS; }
#line 5874 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 562: /* src_reg_flag: T_R  */
#line 1635 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_R; }
#line 5880 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 563: /* src_reg_flag: T_LAST  */
#line 1636 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_LAST_USE; }
#line 5886 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 583: /* uoffset: %empty  */
#line 1665 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                   { (yyval.num) = 0; }
#line 5892 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 584: /* uoffset: '+' integer  */
#line 1666 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].num); }
#line 5898 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 586: /* offset: '-' integer  */
#line 1669 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = -(yyvsp[0].num); }
#line 5904 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 587: /* src_uoffset: uoffset  */
#line 1671 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                           { new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[0].num); if ((yyvsp[0].num)) instr->flags |= IR3_INSTR_IMM_OFFSET; }
#line 5910 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 588: /* relative_gpr_src: 'r' '<' T_A0 offset '>'  */
#line 1673 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_src(0, IR3_REG_RELATIV)->array.offset = (yyvsp[-1].num); }
#line 5916 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 589: /* relative_gpr_src: T_HR '<' T_A0 offset '>'  */
#line 1674 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                             { new_src(0, IR3_REG_RELATIV | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5922 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 590: /* relative_gpr_dst: 'r' '<' T_A0 offset '>'  */
#line 1676 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_dst(0, IR3_REG_RELATIV)->array.offset = (yyvsp[-1].num); }
#line 5928 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 591: /* relative_gpr_dst: T_HR '<' T_A0 offset '>'  */
#line 1677 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                             { new_dst(0, IR3_REG_RELATIV | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5934 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 592: /* relative_const: 'c' '<' T_A0 offset '>'  */
#line 1679 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_src(0, IR3_REG_RELATIV | IR3_REG_CONST)->array.offset = (yyvsp[-1].num); }
#line 5940 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 593: /* relative_const: T_HC '<' T_A0 offset '>'  */
#line 1680 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                             { new_src(0, IR3_REG_RELATIV | IR3_REG_CONST | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5946 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 596: /* immediate_cat1: integer  */
#line 1692 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->iim_val = type_size(instr->cat1.src_type) < 32 ? (yyvsp[0].num) & 0xffff : (yyvsp[0].num); }
#line 5952 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 597: /* immediate_cat1: '(' integer ')'  */
#line 1693 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[-1].num); }
#line 5958 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 598: /* immediate_cat1: '(' float ')'  */
#line 1694 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = (yyvsp[-1].flt); }
#line 5964 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 599: /* immediate_cat1: 'h' '(' integer ')'  */
#line 1695 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->iim_val = (yyvsp[-1].num) & 0xffff; }
#line 5970 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 600: /* immediate_cat1: 'h' '(' float ')'  */
#line 1696 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->uim_val = _mesa_float_to_half((yyvsp[-1].flt)); }
#line 5976 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 601: /* immediate_cat1: '(' T_NAN ')'  */
#line 1697 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = NAN; }
#line 5982 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 602: /* immediate_cat1: '(' T_INF ')'  */
#line 1698 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = INFINITY; }
#line 5988 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 603: /* immediate_cat1: T_FLUT_0_0  */
#line 1699 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = 0.0; }
#line 5994 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 604: /* immediate_cat1: T_FLUT_0_5  */
#line 1700 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = 0.5; }
#line 6000 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 605: /* immediate_cat1: T_FLUT_1_0  */
#line 1701 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = 1.0; }
#line 6006 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 606: /* immediate_cat1: T_FLUT_2_0  */
#line 1702 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = 2.0; }
#line 6012 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 607: /* immediate_cat1: T_FLUT_4_0  */
#line 1703 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = 4.0; }
#line 6018 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 608: /* immediate: integer  */
#line 1705 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 6024 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 609: /* immediate: '(' integer ')'  */
#line 1706 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[-1].num); }
#line 6030 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 610: /* immediate: flut_immed  */
#line 1707 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[0].num); }
#line 6036 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 611: /* immediate: 'h' '(' integer ')'  */
#line 1708 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->iim_val = (yyvsp[-1].num); }
#line 6042 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 612: /* immediate: 'h' flut_immed  */
#line 1709 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->uim_val = (yyvsp[0].num); }
#line 6048 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 625: /* uinteger: T_INT  */
#line 1725 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].num); }
#line 6054 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 626: /* uinteger: T_HEX  */
#line 1726 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].unum); }
#line 6060 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 627: /* integer: uinteger  */
#line 1728 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.num) = (yyvsp[0].num); }
#line 6066 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 628: /* integer: '-' uinteger  */
#line 1729 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.num) = -(yyvsp[0].num); }
#line 6072 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 629: /* float: T_FLOAT  */
#line 1731 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.flt) = (yyvsp[0].flt); }
#line 6078 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 630: /* float: '-' T_FLOAT  */
#line 1732 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.flt) = -(yyvsp[0].flt); }
#line 6084 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 631: /* type: T_TYPE_F16  */
#line 1734 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_F16;   }
#line 6090 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 632: /* type: T_TYPE_F32  */
#line 1735 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_F32;   }
#line 6096 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 633: /* type: T_TYPE_U16  */
#line 1736 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_U16;   }
#line 6102 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 634: /* type: T_TYPE_U32  */
#line 1737 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_U32;   }
#line 6108 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 635: /* type: T_TYPE_S16  */
#line 1738 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_S16;   }
#line 6114 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 636: /* type: T_TYPE_S32  */
#line 1739 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_S32;   }
#line 6120 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 637: /* type: T_TYPE_U8  */
#line 1740 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_U8;    }
#line 6126 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 638: /* type: T_TYPE_U8_32  */
#line 1741 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_U8_32; }
#line 6132 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 639: /* type: T_TYPE_U64  */
#line 1742 "../mesa-25.2.4/src/freedreno/ir3/ir3_parser.y"
                                { (yyval.type) = TYPE_ATOMIC_U64;  }
#line 6138 "src/freedreno/ir3/ir3_parser.c"
    break;


#line 6142 "src/freedreno/ir3/ir3_parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

