#include "nv_push_clc86f.h"

#include <stdio.h>

const char*
P_PARSE_NVC86F_MTHD(uint16_t idx)
{
    switch (idx) {
    case NVC86F_SET_OBJECT:
        return "NVC86F_SET_OBJECT";
    case NVC86F_ILLEGAL:
        return "NVC86F_ILLEGAL";
    case NVC86F_NOP:
        return "NVC86F_NOP";
    case NVC86F_SEMAPHOREA:
        return "NVC86F_SEMAPHOREA";
    case NVC86F_SEMAPHOREB:
        return "NVC86F_SEMAPHOREB";
    case NVC86F_SEMAPHOREC:
        return "NVC86F_SEMAPHOREC";
    case NVC86F_SEMAPHORED:
        return "NVC86F_SEMAPHORED";
    case NVC86F_NON_STALL_INTERRUPT:
        return "NVC86F_NON_STALL_INTERRUPT";
    case NVC86F_FB_FLUSH:
        return "NVC86F_FB_FLUSH";
    case NVC86F_MEM_OP_A:
        return "NVC86F_MEM_OP_A";
    case NVC86F_MEM_OP_B:
        return "NVC86F_MEM_OP_B";
    case NVC86F_MEM_OP_C:
        return "NVC86F_MEM_OP_C";
    case NVC86F_MEM_OP_D:
        return "NVC86F_MEM_OP_D";
    case NVC86F_SET_REFERENCE:
        return "NVC86F_SET_REFERENCE";
    case NVC86F_SEM_ADDR_LO:
        return "NVC86F_SEM_ADDR_LO";
    case NVC86F_SEM_ADDR_HI:
        return "NVC86F_SEM_ADDR_HI";
    case NVC86F_SEM_PAYLOAD_LO:
        return "NVC86F_SEM_PAYLOAD_LO";
    case NVC86F_SEM_PAYLOAD_HI:
        return "NVC86F_SEM_PAYLOAD_HI";
    case NVC86F_SEM_EXECUTE:
        return "NVC86F_SEM_EXECUTE";
    case NVC86F_WFI:
        return "NVC86F_WFI";
    case NVC86F_YIELD:
        return "NVC86F_YIELD";
    case NVC86F_CLEAR_FAULTED:
        return "NVC86F_CLEAR_FAULTED";
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVC86F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {
    case NVC86F_SET_OBJECT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.NVCLASS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 5) - 1);
        fprintf(fp, "%s.ENGINE = ", prefix);
        switch (parsed) {
        case NVC86F_SET_OBJECT_ENGINE_SW:
            fprintf(fp, "SW\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC86F_ILLEGAL:
    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_NOP:
    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEMAPHOREA:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEMAPHOREB:
    
        parsed = (data >> 2) & ((1u << 30) - 1);
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEMAPHOREC:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEMAPHORED:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC86F_SEMAPHORED_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVC86F_SEMAPHORED_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC86F_SEMAPHORED_OPERATION_ACQ_GEQ:
            fprintf(fp, "ACQ_GEQ\n");
            break;
        case NVC86F_SEMAPHORED_OPERATION_ACQ_AND:
            fprintf(fp, "ACQ_AND\n");
            break;
        case NVC86F_SEMAPHORED_OPERATION_REDUCTION:
            fprintf(fp, "REDUCTION\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE_SWITCH = ", prefix);
        switch (parsed) {
        case NVC86F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVC86F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED:
            fprintf(fp, "ENABLED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_WFI = ", prefix);
        switch (parsed) {
        case NVC86F_SEMAPHORED_RELEASE_WFI_EN:
            fprintf(fp, "EN\n");
            break;
        case NVC86F_SEMAPHORED_RELEASE_WFI_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_SIZE = ", prefix);
        switch (parsed) {
        case NVC86F_SEMAPHORED_RELEASE_SIZE_16BYTE:
            fprintf(fp, "16BYTE\n");
            break;
        case NVC86F_SEMAPHORED_RELEASE_SIZE_4BYTE:
            fprintf(fp, "4BYTE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 4) - 1);
        fprintf(fp, "%s.REDUCTION = ", prefix);
        switch (parsed) {
        case NVC86F_SEMAPHORED_REDUCTION_MIN:
            fprintf(fp, "MIN\n");
            break;
        case NVC86F_SEMAPHORED_REDUCTION_MAX:
            fprintf(fp, "MAX\n");
            break;
        case NVC86F_SEMAPHORED_REDUCTION_XOR:
            fprintf(fp, "XOR\n");
            break;
        case NVC86F_SEMAPHORED_REDUCTION_AND:
            fprintf(fp, "AND\n");
            break;
        case NVC86F_SEMAPHORED_REDUCTION_OR:
            fprintf(fp, "OR\n");
            break;
        case NVC86F_SEMAPHORED_REDUCTION_ADD:
            fprintf(fp, "ADD\n");
            break;
        case NVC86F_SEMAPHORED_REDUCTION_INC:
            fprintf(fp, "INC\n");
            break;
        case NVC86F_SEMAPHORED_REDUCTION_DEC:
            fprintf(fp, "DEC\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.FORMAT = ", prefix);
        switch (parsed) {
        case NVC86F_SEMAPHORED_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        case NVC86F_SEMAPHORED_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC86F_NON_STALL_INTERRUPT:
    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_FB_FLUSH:
    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_MEM_OP_A:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_CLIENT_UNIT_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVALIDATION_SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 5) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_GPC_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVAL_SCOPE = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_ALL_TLBS:
            fprintf(fp, "ALL_TLBS\n");
            break;
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_LINK_TLBS:
            fprintf(fp, "LINK_TLBS\n");
            break;
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS:
            fprintf(fp, "NON_LINK_TLBS\n");
            break;
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_RSVRVD:
            fprintf(fp, "RSVRVD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_MMU_ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_SYSMEMBAR = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN:
            fprintf(fp, "EN\n");
            break;
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_MEM_OP_B:
    
        parsed = data;
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET_ADDR_HI = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_MEM_OP_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MEMBAR_TYPE = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_C_MEMBAR_TYPE_SYS_MEMBAR:
            fprintf(fp, "SYS_MEMBAR\n");
            break;
        case NVC86F_MEM_OP_C_MEMBAR_TYPE_MEMBAR:
            fprintf(fp, "MEMBAR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_GPC = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_REPLAY = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START:
            fprintf(fp, "START\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START_ACK_ALL:
            fprintf(fp, "START_ACK_ALL\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_TARGETED:
            fprintf(fp, "CANCEL_TARGETED\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL:
            fprintf(fp, "CANCEL_GLOBAL\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_VA_GLOBAL:
            fprintf(fp, "CANCEL_VA_GLOBAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ACK_TYPE = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY:
            fprintf(fp, "GLOBALLY\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_INTRANODE:
            fprintf(fp, "INTRANODE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ACCESS_TYPE = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_READ:
            fprintf(fp, "VIRT_READ\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE:
            fprintf(fp, "VIRT_WRITE\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_STRONG:
            fprintf(fp, "VIRT_ATOMIC_STRONG\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_RSVRVD:
            fprintf(fp, "VIRT_RSVRVD\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_WEAK:
            fprintf(fp, "VIRT_ATOMIC_WEAK\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_ALL:
            fprintf(fp, "VIRT_ATOMIC_ALL\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE_AND_ATOMIC:
            fprintf(fp, "VIRT_WRITE_AND_ATOMIC\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ALL:
            fprintf(fp, "VIRT_ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PAGE_TABLE_LEVEL = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY:
            fprintf(fp, "PTE_ONLY\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0:
            fprintf(fp, "UP_TO_PDE0\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1:
            fprintf(fp, "UP_TO_PDE1\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2:
            fprintf(fp, "UP_TO_PDE2\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3:
            fprintf(fp, "UP_TO_PDE3\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4:
            fprintf(fp, "UP_TO_PDE4\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5:
            fprintf(fp, "UP_TO_PDE5\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_APERTURE = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM:
            fprintf(fp, "VID_MEM\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT:
            fprintf(fp, "SYS_MEM_COHERENT\n");
            break;
        case NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT:
            fprintf(fp, "SYS_MEM_NONCOHERENT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.ACCESS_COUNTER_CLR_TARGETED_NOTIFY_TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_MEM_OP_D:
    
        parsed = (data >> 0) & ((1u << 27) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_HI = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_D_OPERATION_MEMBAR:
            fprintf(fp, "MEMBAR\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE:
            fprintf(fp, "MMU_TLB_INVALIDATE\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED:
            fprintf(fp, "MMU_TLB_INVALIDATE_TARGETED\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_MMU_OPERATION:
            fprintf(fp, "MMU_OPERATION\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE:
            fprintf(fp, "L2_PEERMEM_INVALIDATE\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE:
            fprintf(fp, "L2_SYSMEM_INVALIDATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC86F_SET_REFERENCE:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEM_ADDR_LO:
    
        parsed = (data >> 2) & ((1u << 30) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEM_ADDR_HI:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEM_PAYLOAD_LO:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEM_PAYLOAD_HI:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC86F_SEM_EXECUTE:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC86F_SEM_EXECUTE_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVC86F_SEM_EXECUTE_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC86F_SEM_EXECUTE_OPERATION_ACQ_STRICT_GEQ:
            fprintf(fp, "ACQ_STRICT_GEQ\n");
            break;
        case NVC86F_SEM_EXECUTE_OPERATION_ACQ_CIRC_GEQ:
            fprintf(fp, "ACQ_CIRC_GEQ\n");
            break;
        case NVC86F_SEM_EXECUTE_OPERATION_ACQ_AND:
            fprintf(fp, "ACQ_AND\n");
            break;
        case NVC86F_SEM_EXECUTE_OPERATION_ACQ_NOR:
            fprintf(fp, "ACQ_NOR\n");
            break;
        case NVC86F_SEM_EXECUTE_OPERATION_REDUCTION:
            fprintf(fp, "REDUCTION\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE_SWITCH_TSG = ", prefix);
        switch (parsed) {
        case NVC86F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVC86F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_WFI = ", prefix);
        switch (parsed) {
        case NVC86F_SEM_EXECUTE_RELEASE_WFI_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVC86F_SEM_EXECUTE_RELEASE_WFI_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PAYLOAD_SIZE = ", prefix);
        switch (parsed) {
        case NVC86F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT:
            fprintf(fp, "32BIT\n");
            break;
        case NVC86F_SEM_EXECUTE_PAYLOAD_SIZE_64BIT:
            fprintf(fp, "64BIT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 25) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_TIMESTAMP = ", prefix);
        switch (parsed) {
        case NVC86F_SEM_EXECUTE_RELEASE_TIMESTAMP_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVC86F_SEM_EXECUTE_RELEASE_TIMESTAMP_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 4) - 1);
        fprintf(fp, "%s.REDUCTION = ", prefix);
        switch (parsed) {
        case NVC86F_SEM_EXECUTE_REDUCTION_IMIN:
            fprintf(fp, "IMIN\n");
            break;
        case NVC86F_SEM_EXECUTE_REDUCTION_IMAX:
            fprintf(fp, "IMAX\n");
            break;
        case NVC86F_SEM_EXECUTE_REDUCTION_IXOR:
            fprintf(fp, "IXOR\n");
            break;
        case NVC86F_SEM_EXECUTE_REDUCTION_IAND:
            fprintf(fp, "IAND\n");
            break;
        case NVC86F_SEM_EXECUTE_REDUCTION_IOR:
            fprintf(fp, "IOR\n");
            break;
        case NVC86F_SEM_EXECUTE_REDUCTION_IADD:
            fprintf(fp, "IADD\n");
            break;
        case NVC86F_SEM_EXECUTE_REDUCTION_INC:
            fprintf(fp, "INC\n");
            break;
        case NVC86F_SEM_EXECUTE_REDUCTION_DEC:
            fprintf(fp, "DEC\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC86F_SEM_EXECUTE_REDUCTION_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        case NVC86F_SEM_EXECUTE_REDUCTION_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC86F_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCOPE = ", prefix);
        switch (parsed) {
        case NVC86F_WFI_SCOPE_CURRENT_VEID:
            fprintf(fp, "CURRENT_VEID\n");
            break;
        case NVC86F_WFI_SCOPE_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC86F_YIELD:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NVC86F_YIELD_OP_NOP:
            fprintf(fp, "NOP\n");
            break;
        case NVC86F_YIELD_OP_TSG:
            fprintf(fp, "TSG\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC86F_CLEAR_FAULTED:
    
        parsed = (data >> 0) & ((1u << 31) - 1);
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC86F_CLEAR_FAULTED_TYPE_PBDMA_FAULTED:
            fprintf(fp, "PBDMA_FAULTED\n");
            break;
        case NVC86F_CLEAR_FAULTED_TYPE_ENG_FAULTED:
            fprintf(fp, "ENG_FAULTED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
