/*
 * Copyright Collabora Ltd
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */

#include <stdint.h>

#pragma once
#include "util/macros.h"

struct panlib_clear_afbc_metadata_args {
   uint64_t p;
   uint32_t layer_or_slice_stride;
} PACKED;

static_assert(offsetof(struct panlib_clear_afbc_metadata_args, p) == 0, "");
static_assert(offsetof(struct panlib_clear_afbc_metadata_args, layer_or_slice_stride) == 8, "");
static_assert(sizeof(struct panlib_clear_afbc_metadata_args) == 12, "");

struct panlib_copy_ts_query_result_args {
   uint64_t pool_addr;
   uint64_t available_addr;
   uint32_t query_stride;
   uint32_t first_query;
   uint32_t query_count;
   uint8_t _pad5[4];
   uint64_t dst_addr;
   uint64_t dst_stride;
   uint32_t query_type;
   uint32_t flags;
   uint32_t report_count;
} PACKED;

static_assert(offsetof(struct panlib_copy_ts_query_result_args, pool_addr) == 0, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, available_addr) == 8, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, query_stride) == 16, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, first_query) == 20, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, query_count) == 24, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, dst_addr) == 32, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, dst_stride) == 40, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, query_type) == 48, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, flags) == 52, "");
static_assert(offsetof(struct panlib_copy_ts_query_result_args, report_count) == 56, "");
static_assert(sizeof(struct panlib_copy_ts_query_result_args) == 60, "");

enum libpan_shaders_program {
    PANLIB_CLEAR_AFBC_METADATA = 0,
    PANLIB_COPY_TS_QUERY_RESULT = 1,
    LIBPAN_SHADERS_NUM_PROGRAMS,
};


#define panlib_clear_afbc_metadata_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_clear_afbc_metadata_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_CLEAR_AFBC_METADATA, &_args, sizeof(_args)); \
} while(0);

#define panlib_clear_afbc_metadata(_context, _grid, _barrier, p, layer_or_slice_stride) do { \
   struct panlib_clear_afbc_metadata_args _args = {p, layer_or_slice_stride};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_CLEAR_AFBC_METADATA, &_args, sizeof(_args)); \
} while(0);

#define panlib_copy_ts_query_result_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_copy_ts_query_result_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_COPY_TS_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_copy_ts_query_result(_context, _grid, _barrier, pool_addr, available_addr, query_stride, first_query, query_count, dst_addr, dst_stride, query_type, flags, report_count) do { \
   struct panlib_copy_ts_query_result_args _args = {pool_addr, available_addr, query_stride, first_query, query_count, {0}, dst_addr, dst_stride, query_type, flags, report_count};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_COPY_TS_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);


extern const uint32_t *libpan_shaders_default_v10[LIBPAN_SHADERS_NUM_PROGRAMS];
