/* LinkType.c generated by valac 0.56.18, the Vala compiler
 * generated from LinkType.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_LINK_TYPE (link_type_get_type ())
#define LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE, LinkType))
#define IS_LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE))
#define LINK_TYPE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LINK_TYPE, LinkTypeIface))

typedef struct _LinkType LinkType;
typedef struct _LinkTypeIface LinkTypeIface;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

struct _LinkTypeIface {
	GTypeInterface parent_iface;
	gchar* (*name) (LinkType* self);
	gchar* (*display_name) (LinkType* self);
	gchar* (*icon_name) (LinkType* self);
	void (*draw) (LinkType* self, cairo_t* ctx, Node* from_node, Node* to_node, gdouble from_x, gdouble from_y, gdouble to_x, gdouble to_y, gdouble* fx, gdouble* fy, gdouble* tx, gdouble* ty);
};

VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType link_type_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkType, g_object_unref)
VALA_EXTERN gchar* link_type_name (LinkType* self);
VALA_EXTERN gchar* link_type_display_name (LinkType* self);
VALA_EXTERN gchar* link_type_icon_name (LinkType* self);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN gdouble link_type_adjust_a (LinkType* self,
                            Style* style);
VALA_EXTERN gboolean* style_get_link_arrow (Style* self);
VALA_EXTERN gint* style_get_link_width (Style* self);
VALA_EXTERN gint* style_get_node_borderwidth (Style* self);
VALA_EXTERN gdouble link_type_adjust_tip (LinkType* self,
                              Style* style);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gdouble link_type_adjust_mid_by (LinkType* self,
                                 Node* parent,
                                 NodeSide child_side);
VALA_EXTERN gboolean node_is_root (Node* self);
VALA_EXTERN gdouble node_get_width (Node* self);
VALA_EXTERN gdouble node_get_height (Node* self);
VALA_EXTERN void link_type_draw (LinkType* self,
                     cairo_t* ctx,
                     Node* from_node,
                     Node* to_node,
                     gdouble from_x,
                     gdouble from_y,
                     gdouble to_x,
                     gdouble to_y,
                     gdouble* fx,
                     gdouble* fy,
                     gdouble* tx,
                     gdouble* ty);
static GType link_type_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
link_type_name (LinkType* self)
{
	LinkTypeIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = LINK_TYPE_GET_INTERFACE (self);
	if (_iface_->name) {
		return _iface_->name (self);
	}
	return NULL;
}

gchar*
link_type_display_name (LinkType* self)
{
	LinkTypeIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = LINK_TYPE_GET_INTERFACE (self);
	if (_iface_->display_name) {
		return _iface_->display_name (self);
	}
	return NULL;
}

gchar*
link_type_icon_name (LinkType* self)
{
	LinkTypeIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = LINK_TYPE_GET_INTERFACE (self);
	if (_iface_->icon_name) {
		return _iface_->icon_name (self);
	}
	return NULL;
}

gdouble
link_type_adjust_a (LinkType* self,
                    Style* style)
{
	gint _tmp0_ = 0;
	gboolean* _tmp1_;
	gboolean* _tmp2_;
	gdouble result;
	g_return_val_if_fail (style != NULL, 0.0);
	_tmp1_ = style_get_link_arrow (style);
	_tmp2_ = _tmp1_;
	if (*_tmp2_) {
		gint* _tmp3_;
		gint* _tmp4_;
		gint* _tmp5_;
		gint* _tmp6_;
		_tmp3_ = style_get_link_width (style);
		_tmp4_ = _tmp3_;
		_tmp5_ = style_get_node_borderwidth (style);
		_tmp6_ = _tmp5_;
		_tmp0_ = ((*_tmp4_) / 2) + (((*_tmp6_) / 2) + 2);
	} else {
		_tmp0_ = 0;
	}
	result = (gdouble) _tmp0_;
	return result;
}

gdouble
link_type_adjust_tip (LinkType* self,
                      Style* style)
{
	gint* _tmp0_;
	gint* _tmp1_;
	gdouble result;
	g_return_val_if_fail (style != NULL, 0.0);
	_tmp0_ = style_get_link_width (style);
	_tmp1_ = _tmp0_;
	result = (gdouble) (((*_tmp1_) / 2) + 1);
	return result;
}

gdouble
link_type_adjust_mid_by (LinkType* self,
                         Node* parent,
                         NodeSide child_side)
{
	gdouble result;
	g_return_val_if_fail (parent != NULL, 0.0);
	if (node_is_root (parent)) {
		switch (child_side) {
			case NODE_SIDE_LEFT:
			{
				gdouble _tmp0_;
				gdouble _tmp1_;
				_tmp0_ = node_get_width (parent);
				_tmp1_ = _tmp0_;
				result = 0 - (_tmp1_ / 4);
				return result;
			}
			case NODE_SIDE_RIGHT:
			{
				gdouble _tmp2_;
				gdouble _tmp3_;
				_tmp2_ = node_get_width (parent);
				_tmp3_ = _tmp2_;
				result = _tmp3_ / 4;
				return result;
			}
			case NODE_SIDE_TOP:
			{
				gdouble _tmp4_;
				gdouble _tmp5_;
				_tmp4_ = node_get_height (parent);
				_tmp5_ = _tmp4_;
				result = 0 - (_tmp5_ / 4);
				return result;
			}
			case NODE_SIDE_BOTTOM:
			{
				gdouble _tmp6_;
				gdouble _tmp7_;
				_tmp6_ = node_get_height (parent);
				_tmp7_ = _tmp6_;
				result = _tmp7_ / 4;
				return result;
			}
			default:
			break;
		}
	}
	result = (gdouble) 0;
	return result;
}

void
link_type_draw (LinkType* self,
                cairo_t* ctx,
                Node* from_node,
                Node* to_node,
                gdouble from_x,
                gdouble from_y,
                gdouble to_x,
                gdouble to_y,
                gdouble* fx,
                gdouble* fy,
                gdouble* tx,
                gdouble* ty)
{
	LinkTypeIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = LINK_TYPE_GET_INTERFACE (self);
	if (_iface_->draw) {
		_iface_->draw (self, ctx, from_node, to_node, from_x, from_y, to_x, to_y, fx, fy, tx, ty);
	}
}

static void
link_type_default_init (LinkTypeIface * iface,
                        gpointer iface_data)
{
}

static GType
link_type_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LinkTypeIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) link_type_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType link_type_type_id;
	link_type_type_id = g_type_register_static (G_TYPE_INTERFACE, "LinkType", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (link_type_type_id, G_TYPE_OBJECT);
	return link_type_type_id;
}

GType
link_type_get_type (void)
{
	static volatile gsize link_type_type_id__once = 0;
	if (g_once_init_enter (&link_type_type_id__once)) {
		GType link_type_type_id;
		link_type_type_id = link_type_get_type_once ();
		g_once_init_leave (&link_type_type_id__once, link_type_type_id);
	}
	return link_type_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

