/* UndoTextItem.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoTextItem.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	UNDO_TEXT_OP_INSERT = 0,
	UNDO_TEXT_OP_DELETE,
	UNDO_TEXT_OP_REPLACE,
	UNDO_TEXT_OP_TAGADD,
	UNDO_TEXT_OP_TAGDEL,
	UNDO_TEXT_OP_TAGCLEAR
} UndoTextOp;

#define TYPE_UNDO_TEXT_OP (undo_text_op_get_type ())

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;
typedef struct _UndoItemPrivate UndoItemPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_TEXT_ITEM (undo_text_item_get_type ())
#define UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItem))
#define UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))
#define IS_UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_ITEM))
#define IS_UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_ITEM))
#define UNDO_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))

typedef struct _UndoTextItem UndoTextItem;
typedef struct _UndoTextItemClass UndoTextItemClass;
typedef struct _UndoTextItemPrivate UndoTextItemPrivate;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;
enum  {
	UNDO_TEXT_ITEM_0_PROPERTY,
	UNDO_TEXT_ITEM_OP_PROPERTY,
	UNDO_TEXT_ITEM_START_CURSOR_PROPERTY,
	UNDO_TEXT_ITEM_END_CURSOR_PROPERTY,
	UNDO_TEXT_ITEM_NUM_PROPERTIES
};
static GParamSpec* undo_text_item_properties[UNDO_TEXT_ITEM_NUM_PROPERTIES];

struct _UndoItem {
	GObject parent_instance;
	UndoItemPrivate * priv;
};

struct _UndoItemClass {
	GObjectClass parent_class;
	void (*undo) (UndoItem* self, DrawArea* da);
	void (*redo) (UndoItem* self, DrawArea* da);
	gboolean (*matches) (UndoItem* self, UndoItem* item);
	void (*replace_with_item) (UndoItem* self, UndoItem* item);
	gchar* (*to_string) (UndoItem* self);
};

struct _UndoTextItem {
	UndoItem parent_instance;
	UndoTextItemPrivate * priv;
};

struct _UndoTextItemClass {
	UndoItemClass parent_class;
	gboolean (*merge) (UndoTextItem* self, CanvasText* ct, UndoTextItem* item);
	void (*undo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
	void (*redo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
};

struct _UndoTextItemPrivate {
	UndoTextOp _op;
	gint _start_cursor;
	gint _end_cursor;
};

static gint UndoTextItem_private_offset;
static gpointer undo_text_item_parent_class = NULL;

VALA_EXTERN GType undo_text_op_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextItem, g_object_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN gboolean undo_text_item_merge (UndoTextItem* self,
                               CanvasText* ct,
                               UndoTextItem* item);
VALA_EXTERN void undo_text_item_undo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN void undo_text_item_redo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN UndoTextItem* undo_text_item_new (const gchar* name,
                                  UndoTextOp op,
                                  gint start_cursor,
                                  gint end_cursor);
VALA_EXTERN UndoTextItem* undo_text_item_construct (GType object_type,
                                        const gchar* name,
                                        UndoTextOp op,
                                        gint start_cursor,
                                        gint end_cursor);
VALA_EXTERN UndoItem* undo_item_new (const gchar* name);
VALA_EXTERN UndoItem* undo_item_construct (GType object_type,
                               const gchar* name);
VALA_EXTERN void undo_text_item_set_op (UndoTextItem* self,
                            UndoTextOp value);
VALA_EXTERN void undo_text_item_set_start_cursor (UndoTextItem* self,
                                      gint value);
VALA_EXTERN void undo_text_item_set_end_cursor (UndoTextItem* self,
                                    gint value);
static gboolean undo_text_item_real_merge (UndoTextItem* self,
                                    CanvasText* ct,
                                    UndoTextItem* item);
static void undo_text_item_real_undo_text (UndoTextItem* self,
                                    DrawArea* da,
                                    CanvasText* ct);
static void undo_text_item_real_redo_text (UndoTextItem* self,
                                    DrawArea* da,
                                    CanvasText* ct);
VALA_EXTERN UndoTextOp undo_text_item_get_op (UndoTextItem* self);
VALA_EXTERN gint undo_text_item_get_start_cursor (UndoTextItem* self);
VALA_EXTERN gint undo_text_item_get_end_cursor (UndoTextItem* self);
static void undo_text_item_finalize (GObject * obj);
static GType undo_text_item_get_type_once (void);
static void _vala_undo_text_item_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_undo_text_item_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
undo_text_op_get_type_once (void)
{
	static const GEnumValue values[] = {{UNDO_TEXT_OP_INSERT, "UNDO_TEXT_OP_INSERT", "insert"}, {UNDO_TEXT_OP_DELETE, "UNDO_TEXT_OP_DELETE", "delete"}, {UNDO_TEXT_OP_REPLACE, "UNDO_TEXT_OP_REPLACE", "replace"}, {UNDO_TEXT_OP_TAGADD, "UNDO_TEXT_OP_TAGADD", "tagadd"}, {UNDO_TEXT_OP_TAGDEL, "UNDO_TEXT_OP_TAGDEL", "tagdel"}, {UNDO_TEXT_OP_TAGCLEAR, "UNDO_TEXT_OP_TAGCLEAR", "tagclear"}, {0, NULL, NULL}};
	GType undo_text_op_type_id;
	undo_text_op_type_id = g_enum_register_static ("UndoTextOp", values);
	return undo_text_op_type_id;
}

GType
undo_text_op_get_type (void)
{
	static volatile gsize undo_text_op_type_id__once = 0;
	if (g_once_init_enter (&undo_text_op_type_id__once)) {
		GType undo_text_op_type_id;
		undo_text_op_type_id = undo_text_op_get_type_once ();
		g_once_init_leave (&undo_text_op_type_id__once, undo_text_op_type_id);
	}
	return undo_text_op_type_id__once;
}

static inline gpointer
undo_text_item_get_instance_private (UndoTextItem* self)
{
	return G_STRUCT_MEMBER_P (self, UndoTextItem_private_offset);
}

UndoTextItem*
undo_text_item_construct (GType object_type,
                          const gchar* name,
                          UndoTextOp op,
                          gint start_cursor,
                          gint end_cursor)
{
	UndoTextItem * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (UndoTextItem*) undo_item_construct (object_type, name);
	undo_text_item_set_op (self, op);
	undo_text_item_set_start_cursor (self, start_cursor);
	undo_text_item_set_end_cursor (self, end_cursor);
	return self;
}

UndoTextItem*
undo_text_item_new (const gchar* name,
                    UndoTextOp op,
                    gint start_cursor,
                    gint end_cursor)
{
	return undo_text_item_construct (TYPE_UNDO_TEXT_ITEM, name, op, start_cursor, end_cursor);
}

static gboolean
undo_text_item_real_merge (UndoTextItem* self,
                           CanvasText* ct,
                           UndoTextItem* item)
{
	gboolean result;
	g_return_val_if_fail (ct != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
undo_text_item_merge (UndoTextItem* self,
                      CanvasText* ct,
                      UndoTextItem* item)
{
	UndoTextItemClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = UNDO_TEXT_ITEM_GET_CLASS (self);
	if (_klass_->merge) {
		return _klass_->merge (self, ct, item);
	}
	return FALSE;
}

static void
undo_text_item_real_undo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct)
{
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
}

void
undo_text_item_undo_text (UndoTextItem* self,
                          DrawArea* da,
                          CanvasText* ct)
{
	UndoTextItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = UNDO_TEXT_ITEM_GET_CLASS (self);
	if (_klass_->undo_text) {
		_klass_->undo_text (self, da, ct);
	}
}

static void
undo_text_item_real_redo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct)
{
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
}

void
undo_text_item_redo_text (UndoTextItem* self,
                          DrawArea* da,
                          CanvasText* ct)
{
	UndoTextItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = UNDO_TEXT_ITEM_GET_CLASS (self);
	if (_klass_->redo_text) {
		_klass_->redo_text (self, da, ct);
	}
}

UndoTextOp
undo_text_item_get_op (UndoTextItem* self)
{
	UndoTextOp result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_op;
	return result;
}

void
undo_text_item_set_op (UndoTextItem* self,
                       UndoTextOp value)
{
	UndoTextOp old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_item_get_op (self);
	if (old_value != value) {
		self->priv->_op = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_item_properties[UNDO_TEXT_ITEM_OP_PROPERTY]);
	}
}

gint
undo_text_item_get_start_cursor (UndoTextItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start_cursor;
	return result;
}

void
undo_text_item_set_start_cursor (UndoTextItem* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_item_get_start_cursor (self);
	if (old_value != value) {
		self->priv->_start_cursor = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_item_properties[UNDO_TEXT_ITEM_START_CURSOR_PROPERTY]);
	}
}

gint
undo_text_item_get_end_cursor (UndoTextItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_end_cursor;
	return result;
}

void
undo_text_item_set_end_cursor (UndoTextItem* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_item_get_end_cursor (self);
	if (old_value != value) {
		self->priv->_end_cursor = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_item_properties[UNDO_TEXT_ITEM_END_CURSOR_PROPERTY]);
	}
}

static void
undo_text_item_class_init (UndoTextItemClass * klass,
                           gpointer klass_data)
{
	undo_text_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoTextItem_private_offset);
	((UndoTextItemClass *) klass)->merge = (gboolean (*) (UndoTextItem*, CanvasText*, UndoTextItem*)) undo_text_item_real_merge;
	((UndoTextItemClass *) klass)->undo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_item_real_undo_text;
	((UndoTextItemClass *) klass)->redo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_item_real_redo_text;
	G_OBJECT_CLASS (klass)->get_property = _vala_undo_text_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_undo_text_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = undo_text_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_ITEM_OP_PROPERTY, undo_text_item_properties[UNDO_TEXT_ITEM_OP_PROPERTY] = g_param_spec_enum ("op", "op", "op", TYPE_UNDO_TEXT_OP, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_ITEM_START_CURSOR_PROPERTY, undo_text_item_properties[UNDO_TEXT_ITEM_START_CURSOR_PROPERTY] = g_param_spec_int ("start-cursor", "start-cursor", "start-cursor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_ITEM_END_CURSOR_PROPERTY, undo_text_item_properties[UNDO_TEXT_ITEM_END_CURSOR_PROPERTY] = g_param_spec_int ("end-cursor", "end-cursor", "end-cursor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
undo_text_item_instance_init (UndoTextItem * self,
                              gpointer klass)
{
	self->priv = undo_text_item_get_instance_private (self);
}

static void
undo_text_item_finalize (GObject * obj)
{
	UndoTextItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_TEXT_ITEM, UndoTextItem);
	G_OBJECT_CLASS (undo_text_item_parent_class)->finalize (obj);
}

static GType
undo_text_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoTextItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_text_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoTextItem), 0, (GInstanceInitFunc) undo_text_item_instance_init, NULL };
	GType undo_text_item_type_id;
	undo_text_item_type_id = g_type_register_static (TYPE_UNDO_ITEM, "UndoTextItem", &g_define_type_info, 0);
	UndoTextItem_private_offset = g_type_add_instance_private (undo_text_item_type_id, sizeof (UndoTextItemPrivate));
	return undo_text_item_type_id;
}

GType
undo_text_item_get_type (void)
{
	static volatile gsize undo_text_item_type_id__once = 0;
	if (g_once_init_enter (&undo_text_item_type_id__once)) {
		GType undo_text_item_type_id;
		undo_text_item_type_id = undo_text_item_get_type_once ();
		g_once_init_leave (&undo_text_item_type_id__once, undo_text_item_type_id);
	}
	return undo_text_item_type_id__once;
}

static void
_vala_undo_text_item_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	UndoTextItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_ITEM, UndoTextItem);
	switch (property_id) {
		case UNDO_TEXT_ITEM_OP_PROPERTY:
		g_value_set_enum (value, undo_text_item_get_op (self));
		break;
		case UNDO_TEXT_ITEM_START_CURSOR_PROPERTY:
		g_value_set_int (value, undo_text_item_get_start_cursor (self));
		break;
		case UNDO_TEXT_ITEM_END_CURSOR_PROPERTY:
		g_value_set_int (value, undo_text_item_get_end_cursor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_undo_text_item_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	UndoTextItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_ITEM, UndoTextItem);
	switch (property_id) {
		case UNDO_TEXT_ITEM_OP_PROPERTY:
		undo_text_item_set_op (self, g_value_get_enum (value));
		break;
		case UNDO_TEXT_ITEM_START_CURSOR_PROPERTY:
		undo_text_item_set_start_cursor (self, g_value_get_int (value));
		break;
		case UNDO_TEXT_ITEM_END_CURSOR_PROPERTY:
		undo_text_item_set_end_cursor (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

