/* ExportCSV.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportCSV.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_CSV (export_csv_get_type ())
#define EXPORT_CSV(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_CSV, ExportCSV))
#define EXPORT_CSV_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_CSV, ExportCSVClass))
#define IS_EXPORT_CSV(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_CSV))
#define IS_EXPORT_CSV_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_CSV))
#define EXPORT_CSV_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_CSV, ExportCSVClass))

typedef struct _ExportCSV ExportCSV;
typedef struct _ExportCSVClass ExportCSVClass;
typedef struct _ExportCSVPrivate ExportCSVPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportCSV {
	Export parent_instance;
	ExportCSVPrivate * priv;
};

struct _ExportCSVClass {
	ExportClass parent_class;
};

static gpointer export_csv_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_csv_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportCSV, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportCSV* export_csv_new (void);
VALA_EXTERN ExportCSV* export_csv_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_csv_real_export (Export* base,
                                 const gchar* fname,
                                 DrawArea* da);
static gint export_csv_levels (ExportCSV* self,
                        DrawArea* da);
static void export_csv_export_levels (ExportCSV* self,
                               GFileOutputStream* os,
                               gint levels);
static void export_csv_export_top_nodes (ExportCSV* self,
                                  GFileOutputStream* os,
                                  DrawArea* da,
                                  gint levels);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
static gint export_csv_child_levels (ExportCSV* self,
                              Node* node);
VALA_EXTERN GArray* node_children (Node* self);
static gchar* export_csv_stringify (ExportCSV* self,
                             const gchar* val);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN const gchar* node_get_note (Node* self);
static void export_csv_export_node (ExportCSV* self,
                             GFileOutputStream* os,
                             Node* node,
                             const gchar* prefix,
                             gint levels);
VALA_EXTERN gboolean node_is_task (Node* self);
VALA_EXTERN gboolean node_is_task_done (Node* self);
static GType export_csv_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportCSV*
export_csv_construct (GType object_type)
{
	ExportCSV* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".csv");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportCSV*) export_construct (object_type, "csv", _ ("CSV"), _tmp2_, (gint) 1, TRUE, FALSE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportCSV*
export_csv_new (void)
{
	return export_csv_construct (TYPE_EXPORT_CSV);
}

static gboolean
export_csv_real_export (Export* base,
                        const gchar* fname,
                        DrawArea* da)
{
	ExportCSV * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean retval = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportCSV*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (fname);
	file = _tmp0_;
	retval = TRUE;
	{
		GFileOutputStream* os = NULL;
		GFileOutputStream* _tmp1_;
		gint levels = 0;
		_tmp1_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		os = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		levels = export_csv_levels (self, da);
		export_csv_export_levels (self, os, levels);
		export_csv_export_top_nodes (self, os, da, levels);
		_g_object_unref0 (os);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		retval = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = retval;
	_g_object_unref0 (file);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
export_csv_export_levels (ExportCSV* self,
                          GFileOutputStream* os,
                          gint levels)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	{
		gchar* str = NULL;
		gchar* _tmp0_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		guint8* _tmp18_;
		gint _tmp18__length1;
		gint _tmp19_ = 0;
		guint8* _tmp20_;
		gint _tmp20__length1;
		_tmp0_ = g_strdup ("level0,note0");
		str = _tmp0_;
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					const gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(i < levels)) {
						break;
					}
					_tmp3_ = str;
					_tmp4_ = g_strdup_printf ("%i", i);
					_tmp5_ = _tmp4_;
					_tmp6_ = g_strconcat (",level", _tmp5_, NULL);
					_tmp7_ = _tmp6_;
					_tmp8_ = g_strconcat (_tmp7_, ",note", NULL);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strdup_printf ("%i", i);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (_tmp3_, _tmp13_, NULL);
					_g_free0 (str);
					str = _tmp14_;
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					_g_free0 (_tmp9_);
					_g_free0 (_tmp7_);
					_g_free0 (_tmp5_);
				}
			}
		}
		_tmp15_ = str;
		_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
		_g_free0 (str);
		str = _tmp16_;
		_tmp17_ = str;
		_tmp18_ = string_get_data (_tmp17_, &_tmp19_);
		_tmp18__length1 = _tmp19_;
		_tmp20_ = _tmp18_;
		_tmp20__length1 = _tmp18__length1;
		g_output_stream_write ((GOutputStream*) os, _tmp20_, (gsize) _tmp20__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (str);
			goto __catch0_g_error;
		}
		_g_free0 (str);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gint
export_csv_levels (ExportCSV* self,
                   DrawArea* da)
{
	GArray* nodes = NULL;
	GArray* _tmp0_;
	gint max_levels = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (da != NULL, 0);
	_tmp0_ = draw_area_get_nodes (da);
	nodes = _tmp0_;
	max_levels = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				gint levels = 0;
				GArray* _tmp4_;
				Node* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = nodes;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = nodes;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				levels = export_csv_child_levels (self, _tmp5_);
				if (levels > max_levels) {
					max_levels = levels;
				}
			}
		}
	}
	result = max_levels;
	_g_array_unref0 (nodes);
	return result;
}

static gint
export_csv_child_levels (ExportCSV* self,
                         Node* node)
{
	GArray* children = NULL;
	GArray* _tmp0_;
	gint max_levels = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (node != NULL, 0);
	_tmp0_ = node_children (node);
	children = _tmp0_;
	max_levels = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				gint levels = 0;
				GArray* _tmp4_;
				Node* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = children;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = children;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				levels = export_csv_child_levels (self, _tmp5_);
				if (levels > max_levels) {
					max_levels = levels;
				}
			}
		}
	}
	result = max_levels + 1;
	_g_array_unref0 (children);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
export_csv_stringify (ExportCSV* self,
                      const gchar* val)
{
	gchar* newval = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (val != NULL, NULL);
	_tmp0_ = string_replace (val, "\"", "");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "\n", " ");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	newval = _tmp3_;
	_tmp4_ = newval;
	if (string_index_of (_tmp4_, ",", 0) != -1) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = newval;
		_tmp6_ = g_strconcat ("\"", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "\"", NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		_g_free0 (newval);
		return result;
	}
	result = newval;
	return result;
}

static void
export_csv_export_top_nodes (ExportCSV* self,
                             GFileOutputStream* os,
                             DrawArea* da,
                             gint levels)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (da != NULL);
	{
		GArray* nodes = NULL;
		GArray* _tmp0_;
		_tmp0_ = draw_area_get_nodes (da);
		nodes = _tmp0_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					gchar* title = NULL;
					GArray* _tmp4_;
					Node* _tmp5_;
					CanvasText* _tmp6_;
					CanvasText* _tmp7_;
					FormattedText* _tmp8_;
					FormattedText* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					GArray* _tmp16_;
					Node* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					guint8* _tmp31_;
					gint _tmp31__length1;
					gint _tmp32_ = 0;
					guint8* _tmp33_;
					gint _tmp33__length1;
					GArray* children = NULL;
					GArray* _tmp34_;
					Node* _tmp35_;
					GArray* _tmp36_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = nodes;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = nodes;
					_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
					_tmp6_ = node_get_name (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = canvas_text_get_text (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = formatted_text_get_text (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = export_csv_stringify (self, _tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
					_tmp15_ = _tmp14_;
					_tmp16_ = nodes;
					_tmp17_ = g_array_index (_tmp16_, Node*, (guint) i);
					_tmp18_ = node_get_note (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = export_csv_stringify (self, _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strconcat (_tmp15_, _tmp21_, NULL);
					_tmp23_ = _tmp22_;
					_g_free0 (_tmp21_);
					_g_free0 (_tmp15_);
					_g_free0 (_tmp13_);
					title = _tmp23_;
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp24_ = FALSE;
							_tmp24_ = TRUE;
							while (TRUE) {
								const gchar* _tmp26_;
								gchar* _tmp27_;
								if (!_tmp24_) {
									gint _tmp25_;
									_tmp25_ = j;
									j = _tmp25_ + 1;
								}
								_tmp24_ = FALSE;
								if (!(j < (levels - 1))) {
									break;
								}
								_tmp26_ = title;
								_tmp27_ = g_strconcat (_tmp26_, ",,", NULL);
								_g_free0 (title);
								title = _tmp27_;
							}
						}
					}
					_tmp28_ = title;
					_tmp29_ = g_strconcat (_tmp28_, "\n", NULL);
					_g_free0 (title);
					title = _tmp29_;
					_tmp30_ = title;
					_tmp31_ = string_get_data (_tmp30_, &_tmp32_);
					_tmp31__length1 = _tmp32_;
					_tmp33_ = _tmp31_;
					_tmp33__length1 = _tmp31__length1;
					g_output_stream_write ((GOutputStream*) os, _tmp33_, (gsize) _tmp33__length1, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (title);
						_g_array_unref0 (nodes);
						goto __catch0_g_error;
					}
					_tmp34_ = nodes;
					_tmp35_ = g_array_index (_tmp34_, Node*, (guint) i);
					_tmp36_ = node_children (_tmp35_);
					children = _tmp36_;
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp37_ = FALSE;
							_tmp37_ = TRUE;
							while (TRUE) {
								GArray* _tmp39_;
								GArray* _tmp40_;
								Node* _tmp41_;
								if (!_tmp37_) {
									gint _tmp38_;
									_tmp38_ = j;
									j = _tmp38_ + 1;
								}
								_tmp37_ = FALSE;
								_tmp39_ = children;
								if (!(((guint) j) < _tmp39_->len)) {
									break;
								}
								_tmp40_ = children;
								_tmp41_ = g_array_index (_tmp40_, Node*, (guint) j);
								export_csv_export_node (self, os, _tmp41_, ",,", levels);
							}
						}
					}
					_g_array_unref0 (children);
					_g_free0 (title);
				}
			}
		}
		_g_array_unref0 (nodes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
export_csv_export_node (ExportCSV* self,
                        GFileOutputStream* os,
                        Node* node,
                        const gchar* prefix,
                        gint levels)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (prefix != NULL);
	{
		gchar* title = NULL;
		gchar* _tmp0_;
		const gchar* _tmp5_;
		CanvasText* _tmp6_;
		CanvasText* _tmp7_;
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		guint8* _tmp32_;
		gint _tmp32__length1;
		gint _tmp33_ = 0;
		guint8* _tmp34_;
		gint _tmp34__length1;
		GArray* children = NULL;
		GArray* _tmp35_;
		_tmp0_ = g_strdup (prefix);
		title = _tmp0_;
		if (node_is_task (node)) {
			if (node_is_task_done (node)) {
				const gchar* _tmp1_;
				gchar* _tmp2_;
				_tmp1_ = title;
				_tmp2_ = g_strconcat (_tmp1_, " - [x] ", NULL);
				_g_free0 (title);
				title = _tmp2_;
			} else {
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = title;
				_tmp4_ = g_strconcat (_tmp3_, " - [ ] ", NULL);
				_g_free0 (title);
				title = _tmp4_;
			}
		}
		_tmp5_ = title;
		_tmp6_ = node_get_name (node);
		_tmp7_ = _tmp6_;
		_tmp8_ = canvas_text_get_text (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = export_csv_stringify (self, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = node_get_note (node);
		_tmp17_ = _tmp16_;
		_tmp18_ = export_csv_stringify (self, _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp5_, _tmp21_, NULL);
		_g_free0 (title);
		title = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp23_ = FALSE;
				_tmp23_ = TRUE;
				while (TRUE) {
					gint _tmp25_;
					gint _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					if (!_tmp23_) {
						gint _tmp24_;
						_tmp24_ = i;
						i = _tmp24_ + 1;
					}
					_tmp23_ = FALSE;
					_tmp25_ = strlen (prefix);
					_tmp26_ = _tmp25_;
					if (!(i < ((levels - 1) - (_tmp26_ / 2)))) {
						break;
					}
					_tmp27_ = title;
					_tmp28_ = g_strconcat (_tmp27_, ",,", NULL);
					_g_free0 (title);
					title = _tmp28_;
				}
			}
		}
		_tmp29_ = title;
		_tmp30_ = g_strconcat (_tmp29_, "\n", NULL);
		_g_free0 (title);
		title = _tmp30_;
		_tmp31_ = title;
		_tmp32_ = string_get_data (_tmp31_, &_tmp33_);
		_tmp32__length1 = _tmp33_;
		_tmp34_ = _tmp32_;
		_tmp34__length1 = _tmp32__length1;
		g_output_stream_write ((GOutputStream*) os, _tmp34_, (gsize) _tmp34__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (title);
			goto __catch0_g_error;
		}
		_tmp35_ = node_children (node);
		children = _tmp35_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp36_ = FALSE;
				_tmp36_ = TRUE;
				while (TRUE) {
					GArray* _tmp38_;
					GArray* _tmp39_;
					Node* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					if (!_tmp36_) {
						gint _tmp37_;
						_tmp37_ = i;
						i = _tmp37_ + 1;
					}
					_tmp36_ = FALSE;
					_tmp38_ = children;
					if (!(((guint) i) < _tmp38_->len)) {
						break;
					}
					_tmp39_ = children;
					_tmp40_ = g_array_index (_tmp39_, Node*, (guint) i);
					_tmp41_ = g_strconcat (prefix, ",,", NULL);
					_tmp42_ = _tmp41_;
					export_csv_export_node (self, os, _tmp40_, _tmp42_, levels);
					_g_free0 (_tmp42_);
				}
			}
		}
		_g_array_unref0 (children);
		_g_free0 (title);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
export_csv_class_init (ExportCSVClass * klass,
                       gpointer klass_data)
{
	export_csv_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_csv_real_export;
}

static void
export_csv_instance_init (ExportCSV * self,
                          gpointer klass)
{
}

static GType
export_csv_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportCSVClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_csv_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportCSV), 0, (GInstanceInitFunc) export_csv_instance_init, NULL };
	GType export_csv_type_id;
	export_csv_type_id = g_type_register_static (TYPE_EXPORT, "ExportCSV", &g_define_type_info, 0);
	return export_csv_type_id;
}

GType
export_csv_get_type (void)
{
	static volatile gsize export_csv_type_id__once = 0;
	if (g_once_init_enter (&export_csv_type_id__once)) {
		GType export_csv_type_id;
		export_csv_type_id = export_csv_get_type_once ();
		g_once_init_leave (&export_csv_type_id__once, export_csv_type_id);
	}
	return export_csv_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

