// This file is @generated by prost-build.
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ProcessUsageStats {
    #[prost(float, required, tag = "1")]
    pub cpu_usage: f32,
    #[prost(uint64, required, tag = "2")]
    pub memory_usage: u64,
    #[prost(uint64, required, tag = "3")]
    pub shared_memory_usage: u64,
    #[prost(float, required, tag = "4")]
    pub disk_usage: f32,
    #[prost(float, required, tag = "5")]
    pub network_usage: f32,
    #[prost(float, required, tag = "6")]
    pub gpu_usage: f32,
    #[prost(uint64, required, tag = "7")]
    pub gpu_memory_usage: u64,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Process {
    #[prost(string, required, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub cmd: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, required, tag = "3")]
    pub exe: ::prost::alloc::string::String,
    #[prost(enumeration = "ProcessState", required, tag = "4")]
    pub state: i32,
    #[prost(uint32, required, tag = "5")]
    pub pid: u32,
    #[prost(uint32, required, tag = "6")]
    pub parent: u32,
    #[prost(message, required, tag = "7")]
    pub usage_stats: ProcessUsageStats,
    #[prost(uint64, required, tag = "8")]
    pub task_count: u64,
    #[prost(uint32, repeated, packed = "false", tag = "9")]
    pub children: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct TerminateProcessesRequest {
    #[prost(uint32, repeated, packed = "false", tag = "1")]
    pub pids: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct KillProcessesRequest {
    #[prost(uint32, repeated, packed = "false", tag = "1")]
    pub pids: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct InterruptProcessesRequest {
    #[prost(uint32, repeated, packed = "false", tag = "1")]
    pub pids: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct User1ProcessesRequest {
    #[prost(uint32, repeated, packed = "false", tag = "1")]
    pub pids: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct User2ProcessesRequest {
    #[prost(uint32, repeated, packed = "false", tag = "1")]
    pub pids: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct HangupProcessesRequest {
    #[prost(uint32, repeated, packed = "false", tag = "1")]
    pub pids: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ContinueProcessesRequest {
    #[prost(uint32, repeated, packed = "false", tag = "1")]
    pub pids: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SuspendProcessesRequest {
    #[prost(uint32, repeated, packed = "false", tag = "1")]
    pub pids: ::prost::alloc::vec::Vec<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ProcessesRequest {
    #[prost(oneof = "processes_request::Request", tags = "1, 2, 3, 4, 5, 6, 7, 8, 9")]
    pub request: ::core::option::Option<processes_request::Request>,
}
/// Nested message and enum types in `ProcessesRequest`.
pub mod processes_request {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, Eq, Hash, ::prost::Oneof)]
    pub enum Request {
        #[prost(message, tag = "1")]
        ProcessMap(super::super::common::Empty),
        #[prost(message, tag = "2")]
        Terminate(super::TerminateProcessesRequest),
        #[prost(message, tag = "3")]
        Kill(super::KillProcessesRequest),
        #[prost(message, tag = "4")]
        Interrupt(super::InterruptProcessesRequest),
        #[prost(message, tag = "5")]
        Hangup(super::HangupProcessesRequest),
        #[prost(message, tag = "6")]
        Continue(super::ContinueProcessesRequest),
        #[prost(message, tag = "7")]
        Suspend(super::SuspendProcessesRequest),
        #[prost(message, tag = "8")]
        User1(super::User1ProcessesRequest),
        #[prost(message, tag = "9")]
        User2(super::User2ProcessesRequest),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ProcessesResponse {
    #[prost(oneof = "processes_response::Response", tags = "1, 2, 3")]
    pub response: ::core::option::Option<processes_response::Response>,
}
/// Nested message and enum types in `ProcessesResponse`.
pub mod processes_response {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ProcessMap {
        #[prost(map = "uint32, message", tag = "1")]
        pub processes: ::std::collections::HashMap<u32, super::Process>,
        #[prost(oneof = "process_map::NetworkStatsError", tags = "2, 3")]
        pub network_stats_error: ::core::option::Option<process_map::NetworkStatsError>,
    }
    /// Nested message and enum types in `ProcessMap`.
    pub mod process_map {
        #[derive(serde::Serialize, serde::Deserialize)]
        #[serde(rename_all = "snake_case")]
        #[derive(strum::EnumIter)]
        #[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Oneof)]
        pub enum NetworkStatsError {
            #[prost(message, tag = "2")]
            LibraryMissing(super::super::LibraryMissingError),
            #[prost(message, tag = "3")]
            PermissionsError(super::super::PermissionsError),
        }
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Response {
        #[prost(message, tag = "1")]
        Processes(ProcessMap),
        #[prost(message, tag = "2")]
        TermKill(super::super::common::Empty),
        #[prost(message, tag = "3")]
        Error(super::ProcessesResponseError),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ProcessesResponseError {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LibraryMissingError {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct PermissionsError {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(strum::EnumIter)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum ProcessState {
    Running = 0,
    Sleeping = 1,
    SleepingUninterruptible = 2,
    Zombie = 3,
    Stopped = 4,
    Tracing = 5,
    Dead = 6,
    WakeKill = 7,
    Waking = 8,
    Parked = 9,
    Unknown = 10,
}
impl ProcessState {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Running => "Running",
            Self::Sleeping => "Sleeping",
            Self::SleepingUninterruptible => "SleepingUninterruptible",
            Self::Zombie => "Zombie",
            Self::Stopped => "Stopped",
            Self::Tracing => "Tracing",
            Self::Dead => "Dead",
            Self::WakeKill => "WakeKill",
            Self::Waking => "Waking",
            Self::Parked => "Parked",
            Self::Unknown => "Unknown",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "Running" => Some(Self::Running),
            "Sleeping" => Some(Self::Sleeping),
            "SleepingUninterruptible" => Some(Self::SleepingUninterruptible),
            "Zombie" => Some(Self::Zombie),
            "Stopped" => Some(Self::Stopped),
            "Tracing" => Some(Self::Tracing),
            "Dead" => Some(Self::Dead),
            "WakeKill" => Some(Self::WakeKill),
            "Waking" => Some(Self::Waking),
            "Parked" => Some(Self::Parked),
            "Unknown" => Some(Self::Unknown),
            _ => None,
        }
    }
}
