/* Generated by wayland-scanner 1.24.0 */

#ifndef POINTER_WARP_V1_SERVER_PROTOCOL_H
#define POINTER_WARP_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_pointer_warp_v1 The pointer_warp_v1 protocol
 * @section page_ifaces_pointer_warp_v1 Interfaces
 * - @subpage page_iface_wp_pointer_warp_v1 - reposition the pointer to a location on a surface
 * @section page_copyright_pointer_warp_v1 Copyright
 * <pre>
 *
 * Copyright © 2024 Neal Gompa
 * Copyright © 2024 Xaver Hugl
 * Copyright © 2024 Matthias Klumpp
 * Copyright © 2024 Vlad Zahorodnii
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_pointer;
struct wl_surface;
struct wp_pointer_warp_v1;

#ifndef WP_POINTER_WARP_V1_INTERFACE
#define WP_POINTER_WARP_V1_INTERFACE
/**
 * @page page_iface_wp_pointer_warp_v1 wp_pointer_warp_v1
 * @section page_iface_wp_pointer_warp_v1_desc Description
 *
 * This global interface allows applications to request the pointer to be
 * moved to a position relative to a wl_surface.
 *
 * Note that if the desired behavior is to constrain the pointer to an area
 * or lock it to a position, this protocol does not provide a reliable way
 * to do that. The pointer constraint and pointer lock protocols should be
 * used for those use cases instead.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_wp_pointer_warp_v1_api API
 * See @ref iface_wp_pointer_warp_v1.
 */
/**
 * @defgroup iface_wp_pointer_warp_v1 The wp_pointer_warp_v1 interface
 *
 * This global interface allows applications to request the pointer to be
 * moved to a position relative to a wl_surface.
 *
 * Note that if the desired behavior is to constrain the pointer to an area
 * or lock it to a position, this protocol does not provide a reliable way
 * to do that. The pointer constraint and pointer lock protocols should be
 * used for those use cases instead.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface wp_pointer_warp_v1_interface;
#endif

/**
 * @ingroup iface_wp_pointer_warp_v1
 * @struct wp_pointer_warp_v1_interface
 */
struct wp_pointer_warp_v1_interface {
	/**
	 * destroy the warp manager
	 *
	 * Destroy the pointer warp manager.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * reposition the pointer
	 *
	 * Request the compositor to move the pointer to a surface-local
	 * position. Whether or not the compositor honors the request is
	 * implementation defined, but it should - honor it if the surface
	 * has pointer focus, including when it has an implicit pointer
	 * grab - reject it if the enter serial is incorrect - reject it if
	 * the requested position is outside of the surface
	 *
	 * Note that the enter serial is valid for any surface of the
	 * client, and does not have to be from the surface the pointer is
	 * warped to.
	 * @param surface surface to position the pointer on
	 * @param pointer the pointer that should be repositioned
	 * @param serial serial number of the enter event
	 */
	void (*warp_pointer)(struct wl_client *client,
			     struct wl_resource *resource,
			     struct wl_resource *surface,
			     struct wl_resource *pointer,
			     wl_fixed_t x,
			     wl_fixed_t y,
			     uint32_t serial);
};


/**
 * @ingroup iface_wp_pointer_warp_v1
 */
#define WP_POINTER_WARP_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_pointer_warp_v1
 */
#define WP_POINTER_WARP_V1_WARP_POINTER_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
