/*
 * Copyright (C) by Hannah von Reth <hannah.vonreth@owncloud.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "common/version.h"

const QVersionNumber &OCC::Version::version()
{
    static const auto v = QVersionNumber({ 6, 0, 1 });
    return v;
}

const QVersionNumber &OCC::Version::versionWithBuildNumber()
{
    static const auto v = QVersionNumber({ 6, 0, 1, 0 });
    return v;
}

QString OCC::Version::gitSha()
{
    return QStringLiteral("63ace8f64d025ae9cd0d72c571c8f7e5d1c3c39a");
}

QString OCC::Version::suffix()
{
    return QStringLiteral("");
}

QString OCC::Version::displayString()
{
    // ensure a well-defined version string
    constexpr std::string_view versionString("6.0.1");
    constexpr std::string_view versionSuffix("");
    static_assert(versionString.find("6.0.1") == 0);
    static_assert(versionString.rfind("") == versionString.size() - versionSuffix.size());
    return QStringLiteral("6.0.1");
}
