/* Grid.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Grid.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2015 Maya Developers (http://launchpad.net/maya)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include "elementary-calendar.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <libecal/libecal.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_GRID (maya_view_grid_get_type ())
#define MAYA_VIEW_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_GRID, MayaViewGrid))
#define MAYA_VIEW_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_GRID, MayaViewGridClass))
#define MAYA_VIEW_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_GRID))
#define MAYA_VIEW_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_GRID))
#define MAYA_VIEW_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_GRID, MayaViewGridClass))

typedef struct _MayaViewGrid MayaViewGrid;
typedef struct _MayaViewGridClass MayaViewGridClass;
typedef struct _MayaViewGridPrivate MayaViewGridPrivate;

#define MAYA_VIEW_TYPE_GRID_DAY (maya_view_grid_day_get_type ())
#define MAYA_VIEW_GRID_DAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDay))
#define MAYA_VIEW_GRID_DAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDayClass))
#define MAYA_VIEW_IS_GRID_DAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_GRID_DAY))
#define MAYA_VIEW_IS_GRID_DAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_GRID_DAY))
#define MAYA_VIEW_GRID_DAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDayClass))

typedef struct _MayaViewGridDay MayaViewGridDay;
typedef struct _MayaViewGridDayClass MayaViewGridDayClass;
enum  {
	MAYA_VIEW_GRID_0_PROPERTY,
	MAYA_VIEW_GRID_GRID_RANGE_PROPERTY,
	MAYA_VIEW_GRID_NUM_PROPERTIES
};
static GParamSpec* maya_view_grid_properties[MAYA_VIEW_GRID_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block26Data Block26Data;

#define MAYA_VIEW_TYPE_EVENT_BUTTON (maya_view_event_button_get_type ())
#define MAYA_VIEW_EVENT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButton))
#define MAYA_VIEW_EVENT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButtonClass))
#define MAYA_VIEW_IS_EVENT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON))
#define MAYA_VIEW_IS_EVENT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_EVENT_BUTTON))
#define MAYA_VIEW_EVENT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButtonClass))

typedef struct _MayaViewEventButton MayaViewEventButton;
typedef struct _MayaViewEventButtonClass MayaViewEventButtonClass;
enum  {
	MAYA_VIEW_GRID_ON_EVENT_ADD_SIGNAL,
	MAYA_VIEW_GRID_SELECTION_CHANGED_SIGNAL,
	MAYA_VIEW_GRID_NUM_SIGNALS
};
static guint maya_view_grid_signals[MAYA_VIEW_GRID_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MayaViewGrid {
	GtkGrid parent_instance;
	MayaViewGridPrivate * priv;
};

struct _MayaViewGridClass {
	GtkGridClass parent_class;
};

struct _MayaViewGridPrivate {
	GeeHashMap* data;
	CalendarUtilDateRange* _grid_range;
	MayaViewGridDay* selected_gridday;
	MayaViewGridDay* today_widget;
};

struct _Block26Data {
	int _ref_count_;
	MayaViewGrid* self;
	MayaViewGridDay* day;
};

static gint MayaViewGrid_private_offset;
static gpointer maya_view_grid_parent_class = NULL;
static GtkCssProvider* maya_view_grid_style_provider;
static GtkCssProvider* maya_view_grid_style_provider = NULL;
VALA_EXTERN GSettings* maya_application_saved_state;

VALA_EXTERN GType maya_view_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewGrid, g_object_unref)
VALA_EXTERN GType maya_view_grid_day_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewGridDay, g_object_unref)
static void maya_view_grid_callback_update_today (MayaViewGrid* self);
static guint maya_view_grid_day_hash (MayaViewGrid* self,
                               GDateTime* date);
static void maya_view_grid_on_day_focus_in (MayaViewGrid* self,
                                     MayaViewGridDay* day);
VALA_EXTERN void maya_view_grid_day_set_selected (MayaViewGridDay* self,
                                      gboolean selected);
VALA_EXTERN GDateTime* maya_view_grid_day_get_date (MayaViewGridDay* self);
VALA_EXTERN void maya_view_grid_focus_date (MayaViewGrid* self,
                                GDateTime* date);
VALA_EXTERN void maya_view_grid_set_range (MayaViewGrid* self,
                               CalendarUtilDateRange* new_range,
                               GDateTime* month_start);
VALA_EXTERN CalendarUtilDateRange* maya_view_grid_get_grid_range (MayaViewGrid* self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static MayaViewGridDay* maya_view_grid_update_day (MayaViewGrid* self,
                                            MayaViewGridDay* day,
                                            GDateTime* new_date,
                                            GDateTime* today,
                                            GDateTime* month_start);
VALA_EXTERN MayaViewGridDay* maya_view_grid_day_new (GDateTime* date);
VALA_EXTERN MayaViewGridDay* maya_view_grid_day_construct (GType object_type,
                                               GDateTime* date);
static void _____lambda137_ (MayaViewGrid* self,
                      GDateTime* date);
static void ______lambda137__maya_view_grid_day_on_event_add (MayaViewGridDay* _sender,
                                                       GDateTime* date,
                                                       gpointer self);
static gboolean _____lambda138_ (MayaViewGrid* self,
                          GdkEventScroll* event);
static gboolean ______lambda138__gtk_widget_scroll_event (GtkWidget* _sender,
                                                   GdkEventScroll* event,
                                                   gpointer self);
static gboolean _____lambda139_ (Block26Data* _data26_,
                          GdkEventFocus* event);
static gboolean ______lambda139__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                     GdkEventFocus* event,
                                                     gpointer self);
static void maya_view_grid_set_grid_range (MayaViewGrid* self,
                                    CalendarUtilDateRange* value);
VALA_EXTERN void maya_view_grid_day_set_in_current_month (MayaViewGridDay* self,
                                              gboolean value);
VALA_EXTERN void maya_view_grid_day_set_date (MayaViewGridDay* self,
                                  GDateTime* value);
VALA_EXTERN void maya_view_grid_add_event (MayaViewGrid* self,
                               ECalComponent* event);
VALA_EXTERN GType maya_view_event_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventButton, g_object_unref)
VALA_EXTERN MayaViewEventButton* maya_view_event_button_new (ECalComponent* comp);
VALA_EXTERN MayaViewEventButton* maya_view_event_button_construct (GType object_type,
                                                       ECalComponent* comp);
VALA_EXTERN void maya_view_grid_day_add_event_button (MayaViewGridDay* self,
                                          MayaViewEventButton* button);
VALA_EXTERN void maya_view_grid_remove_event (MayaViewGrid* self,
                                  ECalComponent* event);
VALA_EXTERN void maya_view_grid_day_remove_event (MayaViewGridDay* self,
                                      ECalComponent* comp);
VALA_EXTERN void maya_view_grid_update_event (MayaViewGrid* self,
                                  ECalComponent* event);
VALA_EXTERN gboolean maya_view_grid_day_update_event (MayaViewGridDay* self,
                                          ECalComponent* modified_event);
VALA_EXTERN void maya_view_grid_remove_all_events (MayaViewGrid* self);
VALA_EXTERN void maya_view_grid_day_clear_events (MayaViewGridDay* self);
VALA_EXTERN MayaViewGrid* maya_view_grid_new (void);
VALA_EXTERN MayaViewGrid* maya_view_grid_construct (GType object_type);
static GObject * maya_view_grid_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _maya_view_grid_callback_update_today_calendar_time_manager_on_update_today (CalendarTimeManager* _sender,
                                                                                  gpointer self);
static void maya_view_grid_finalize (GObject * obj);
static GType maya_view_grid_get_type_once (void);
static void _vala_maya_view_grid_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_maya_view_grid_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
maya_view_grid_get_instance_private (MayaViewGrid* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewGrid_private_offset);
}

/** Update the names of the current and previous "Today" cells, if necessary.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
maya_view_grid_callback_update_today (MayaViewGrid* self)
{
	MayaViewGridDay* old_today_widget = NULL;
	MayaViewGridDay* _tmp0_;
	MayaViewGridDay* _tmp1_;
	GDateTime* today = NULL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	guint today_hash = 0U;
	GDateTime* _tmp6_;
	GeeHashMap* _tmp7_;
	MayaViewGridDay* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->today_widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	old_today_widget = _tmp1_;
	_tmp2_ = g_date_time_new_now_local ();
	_tmp3_ = _tmp2_;
	_tmp4_ = calendar_util_datetime_strip_time (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_date_time_unref0 (_tmp3_);
	today = _tmp5_;
	_tmp6_ = today;
	today_hash = maya_view_grid_day_hash (self, _tmp6_);
	_tmp7_ = self->priv->data;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, (gpointer) ((guintptr) today_hash))) {
		MayaViewGridDay* new_today_widget = NULL;
		GeeHashMap* _tmp8_;
		gpointer _tmp9_;
		MayaViewGridDay* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = self->priv->data;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, (gpointer) ((guintptr) today_hash));
		new_today_widget = (MayaViewGridDay*) _tmp9_;
		_tmp10_ = new_today_widget;
		_tmp11_ = gtk_widget_get_name ((GtkWidget*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (g_strcmp0 (_tmp12_, "today") == 0) {
			g_debug ("Grid.vala:78: Today cell already up to date. Nothing to do.");
			_g_object_unref0 (new_today_widget);
			_g_date_time_unref0 (today);
			_g_object_unref0 (old_today_widget);
			return;
		} else {
			MayaViewGridDay* _tmp13_;
			MayaViewGridDay* _tmp14_;
			MayaViewGridDay* _tmp15_;
			_tmp13_ = new_today_widget;
			gtk_widget_set_name ((GtkWidget*) _tmp13_, "today");
			_tmp14_ = new_today_widget;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (self->priv->today_widget);
			self->priv->today_widget = _tmp15_;
		}
		_g_object_unref0 (new_today_widget);
	} else {
		MayaViewGridDay* _tmp16_;
		g_debug ("Grid.vala:85: Today out of range of calendar grid.");
		_tmp16_ = self->priv->today_widget;
		if (_tmp16_ != NULL) {
			MayaViewGridDay* _tmp17_;
			_tmp17_ = self->priv->today_widget;
			gtk_widget_set_name ((GtkWidget*) _tmp17_, "MayaViewGridDay");
		}
		_g_object_unref0 (self->priv->today_widget);
		self->priv->today_widget = NULL;
		_g_date_time_unref0 (today);
		_g_object_unref0 (old_today_widget);
		return;
	}
	_tmp18_ = old_today_widget;
	if (_tmp18_ != NULL) {
		MayaViewGridDay* _tmp19_;
		_tmp19_ = old_today_widget;
		gtk_widget_set_name ((GtkWidget*) _tmp19_, "MayaViewGridDay");
	} else {
		g_debug ("Grid.vala:97: No previous today widget to update. Nothing to do.");
	}
	_g_date_time_unref0 (today);
	_g_object_unref0 (old_today_widget);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
maya_view_grid_on_day_focus_in (MayaViewGrid* self,
                                MayaViewGridDay* day)
{
	MayaViewGridDay* _tmp0_;
	GDateTime* selected_date = NULL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	MayaViewGridDay* _tmp5_;
	GDateTime* _tmp6_;
	GSettings* _tmp7_;
	GDateTime* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp11_;
	gint date_month = 0;
	GDateTime* _tmp12_;
	CalendarEventStore* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	gint date_year = 0;
	GDateTime* _tmp16_;
	CalendarEventStore* _tmp17_;
	GDateTime* _tmp18_;
	GDateTime* _tmp19_;
	gboolean _tmp20_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (day != NULL);
	_tmp0_ = self->priv->selected_gridday;
	if (_tmp0_ != NULL) {
		MayaViewGridDay* _tmp1_;
		_tmp1_ = self->priv->selected_gridday;
		maya_view_grid_day_set_selected (_tmp1_, FALSE);
	}
	_tmp2_ = maya_view_grid_day_get_date (day);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	selected_date = _tmp4_;
	_tmp5_ = _g_object_ref0 (day);
	_g_object_unref0 (self->priv->selected_gridday);
	self->priv->selected_gridday = _tmp5_;
	maya_view_grid_day_set_selected (day, TRUE);
	gtk_widget_set_state_flags ((GtkWidget*) day, GTK_STATE_FLAG_FOCUSED, FALSE);
	_tmp6_ = selected_date;
	g_signal_emit (self, maya_view_grid_signals[MAYA_VIEW_GRID_SELECTION_CHANGED_SIGNAL], 0, _tmp6_);
	_tmp7_ = maya_application_saved_state;
	_tmp8_ = selected_date;
	_tmp9_ = g_date_time_format (_tmp8_, "%Y-%j");
	_tmp10_ = _tmp9_;
	g_settings_set_string (_tmp7_, "selected-day", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = calendar_event_store_get_default ();
	calmodel = _tmp11_;
	_tmp12_ = selected_date;
	_tmp13_ = calmodel;
	_tmp14_ = calendar_event_store_get_month_start (_tmp13_);
	_tmp15_ = _tmp14_;
	date_month = g_date_time_get_month (_tmp12_) - g_date_time_get_month (_tmp15_);
	_tmp16_ = selected_date;
	_tmp17_ = calmodel;
	_tmp18_ = calendar_event_store_get_month_start (_tmp17_);
	_tmp19_ = _tmp18_;
	date_year = g_date_time_get_year (_tmp16_) - g_date_time_get_year (_tmp19_);
	if (date_month != 0) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = date_year != 0;
	}
	if (_tmp20_) {
		CalendarEventStore* _tmp21_;
		CalendarEventStore* _tmp22_;
		_tmp21_ = calmodel;
		calendar_event_store_change_month (_tmp21_, date_month);
		_tmp22_ = calmodel;
		calendar_event_store_change_year (_tmp22_, date_year);
	}
	_g_object_unref0 (calmodel);
	_g_date_time_unref0 (selected_date);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

void
maya_view_grid_focus_date (MayaViewGrid* self,
                           GDateTime* date)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint date_hash = 0U;
	GeeHashMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	_tmp0_ = g_date_time_to_string (date);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Setting focus to @ ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	g_debug ("Grid.vala:122: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	date_hash = maya_view_grid_day_hash (self, date);
	_tmp4_ = self->priv->data;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) date_hash)) == TRUE) {
		MayaViewGridDay* day_widget = NULL;
		GeeHashMap* _tmp5_;
		gpointer _tmp6_;
		MayaViewGridDay* _tmp7_;
		MayaViewGridDay* _tmp8_;
		_tmp5_ = self->priv->data;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) date_hash));
		day_widget = (MayaViewGridDay*) _tmp6_;
		_tmp7_ = day_widget;
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
		_tmp8_ = day_widget;
		maya_view_grid_on_day_focus_in (self, _tmp8_);
		_g_object_unref0 (day_widget);
	}
}

/**
     * Sets the given range to be displayed in the grid. Note that the number of days
     * must remain the same.
     */
static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		MayaViewGrid* self;
		self = _data26_->self;
		_g_object_unref0 (_data26_->day);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static void
_____lambda137_ (MayaViewGrid* self,
                 GDateTime* date)
{
	g_return_if_fail (date != NULL);
	g_signal_emit (self, maya_view_grid_signals[MAYA_VIEW_GRID_ON_EVENT_ADD_SIGNAL], 0, date);
}

static void
______lambda137__maya_view_grid_day_on_event_add (MayaViewGridDay* _sender,
                                                  GDateTime* date,
                                                  gpointer self)
{
	_____lambda137_ ((MayaViewGrid*) self, date);
}

static gboolean
_____lambda138_ (MayaViewGrid* self,
                 GdkEventScroll* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	g_signal_emit_by_name ((GtkWidget*) self, "scroll-event", event, &_tmp0_);
	result = FALSE;
	return result;
}

static gboolean
______lambda138__gtk_widget_scroll_event (GtkWidget* _sender,
                                          GdkEventScroll* event,
                                          gpointer self)
{
	gboolean result;
	result = _____lambda138_ ((MayaViewGrid*) self, event);
	return result;
}

static gboolean
_____lambda139_ (Block26Data* _data26_,
                 GdkEventFocus* event)
{
	MayaViewGrid* self;
	MayaViewGridDay* _tmp0_;
	gboolean result;
	self = _data26_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data26_->day;
	maya_view_grid_on_day_focus_in (self, _tmp0_);
	result = FALSE;
	return result;
}

static gboolean
______lambda139__gtk_widget_focus_in_event (GtkWidget* _sender,
                                            GdkEventFocus* event,
                                            gpointer self)
{
	gboolean result;
	result = _____lambda139_ (self, event);
	return result;
}

void
maya_view_grid_set_range (MayaViewGrid* self,
                          CalendarUtilDateRange* new_range,
                          GDateTime* month_start)
{
	GDateTime* today = NULL;
	GDateTime* _tmp0_;
	GeeList* old_dates = NULL;
	CalendarUtilDateRange* _tmp1_;
	GeeList* new_dates = NULL;
	GeeList* _tmp5_;
	GeeHashMap* data_new = NULL;
	GeeHashMap* _tmp6_;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint i = 0;
	gint col = 0;
	gint row = 0;
	GeeHashMap* _tmp59_;
	GeeHashMap* _tmp60_;
	GeeHashMap* _tmp61_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_range != NULL);
	g_return_if_fail (month_start != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	today = _tmp0_;
	_tmp1_ = self->priv->_grid_range;
	if (_tmp1_ == NULL) {
		GeeArrayList* _tmp2_;
		_tmp2_ = gee_array_list_new (G_TYPE_DATE_TIME, (GBoxedCopyFunc) g_date_time_ref, (GDestroyNotify) g_date_time_unref, NULL, NULL, NULL);
		_g_object_unref0 (old_dates);
		old_dates = (GeeList*) _tmp2_;
	} else {
		CalendarUtilDateRange* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = self->priv->_grid_range;
		_tmp4_ = calendar_util_date_range_to_list (_tmp3_);
		_g_object_unref0 (old_dates);
		old_dates = _tmp4_;
	}
	_tmp5_ = calendar_util_date_range_to_list (new_range);
	new_dates = _tmp5_;
	_tmp6_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, MAYA_VIEW_TYPE_GRID_DAY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	data_new = _tmp6_;
	_tmp7_ = new_dates;
	_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert ((_tmp9_ % 7) == 0, "new_dates.size % 7 == 0");
	i = 0;
	col = 0;
	row = 0;
	{
		gboolean _tmp10_ = FALSE;
		i = 0;
		_tmp10_ = TRUE;
		while (TRUE) {
			Block26Data* _data26_;
			GeeList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GDateTime* new_date = NULL;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			GeeList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp45_ = 0;
			GeeHashMap* _tmp46_;
			GDateTime* _tmp47_;
			MayaViewGridDay* _tmp48_;
			_data26_ = g_slice_new0 (Block26Data);
			_data26_->_ref_count_ = 1;
			_data26_->self = g_object_ref (self);
			if (!_tmp10_) {
				gint _tmp11_;
				_tmp11_ = i;
				i = _tmp11_ + 1;
			}
			_tmp10_ = FALSE;
			_tmp12_ = new_dates;
			_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (!(i < _tmp14_)) {
				block26_data_unref (_data26_);
				_data26_ = NULL;
				break;
			}
			_tmp15_ = new_dates;
			_tmp16_ = gee_list_get (_tmp15_, i);
			new_date = (GDateTime*) _tmp16_;
			_tmp17_ = old_dates;
			_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			if (i < _tmp19_) {
				GDateTime* old_date = NULL;
				GeeList* _tmp20_;
				gpointer _tmp21_;
				GeeHashMap* _tmp22_;
				GDateTime* _tmp23_;
				gpointer _tmp24_;
				MayaViewGridDay* _tmp25_;
				GDateTime* _tmp26_;
				GDateTime* _tmp27_;
				MayaViewGridDay* _tmp28_;
				_tmp20_ = old_dates;
				_tmp21_ = gee_list_get (_tmp20_, i);
				old_date = (GDateTime*) _tmp21_;
				_tmp22_ = self->priv->data;
				_tmp23_ = old_date;
				_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, (gpointer) ((guintptr) maya_view_grid_day_hash (self, _tmp23_)));
				_tmp25_ = (MayaViewGridDay*) _tmp24_;
				_tmp26_ = new_date;
				_tmp27_ = today;
				_tmp28_ = maya_view_grid_update_day (self, _tmp25_, _tmp26_, _tmp27_, month_start);
				_g_object_unref0 (_data26_->day);
				_data26_->day = _tmp28_;
				_g_object_unref0 (_tmp25_);
				_g_date_time_unref0 (old_date);
			} else {
				GDateTime* _tmp29_;
				MayaViewGridDay* _tmp30_;
				MayaViewGridDay* _tmp31_;
				GDateTime* _tmp32_;
				GDateTime* _tmp33_;
				MayaViewGridDay* _tmp34_;
				MayaViewGridDay* _tmp35_;
				MayaViewGridDay* _tmp36_;
				MayaViewGridDay* _tmp37_;
				MayaViewGridDay* _tmp43_;
				MayaViewGridDay* _tmp44_;
				_tmp29_ = new_date;
				_tmp30_ = maya_view_grid_day_new (_tmp29_);
				g_object_ref_sink (_tmp30_);
				_tmp31_ = _tmp30_;
				_tmp32_ = new_date;
				_tmp33_ = today;
				_tmp34_ = maya_view_grid_update_day (self, _tmp31_, _tmp32_, _tmp33_, month_start);
				_g_object_unref0 (_data26_->day);
				_data26_->day = _tmp34_;
				_g_object_unref0 (_tmp31_);
				_tmp35_ = _data26_->day;
				g_signal_connect_object (_tmp35_, "on-event-add", (GCallback) ______lambda137__maya_view_grid_day_on_event_add, self, 0);
				_tmp36_ = _data26_->day;
				g_signal_connect_object ((GtkWidget*) _tmp36_, "scroll-event", (GCallback) ______lambda138__gtk_widget_scroll_event, self, 0);
				_tmp37_ = _data26_->day;
				g_signal_connect_data ((GtkWidget*) _tmp37_, "focus-in-event", (GCallback) ______lambda139__gtk_widget_focus_in_event, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
				if (col == 0) {
					GtkStyleContext* day_context = NULL;
					MayaViewGridDay* _tmp38_;
					GtkStyleContext* _tmp39_;
					GtkStyleContext* _tmp40_;
					GtkCssProvider* _tmp41_;
					GtkStyleContext* _tmp42_;
					_tmp38_ = _data26_->day;
					_tmp39_ = gtk_widget_get_style_context ((GtkWidget*) _tmp38_);
					day_context = _tmp39_;
					_tmp40_ = day_context;
					_tmp41_ = maya_view_grid_style_provider;
					gtk_style_context_add_provider (_tmp40_, (GtkStyleProvider*) _tmp41_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
					_tmp42_ = day_context;
					gtk_style_context_add_class (_tmp42_, "firstcol");
				}
				_tmp43_ = _data26_->day;
				gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp43_, col, row, 1, 1);
				_tmp44_ = _data26_->day;
				gtk_widget_show_all ((GtkWidget*) _tmp44_);
			}
			col = (col + 1) % 7;
			if (col == 0) {
				_tmp45_ = row + 1;
			} else {
				_tmp45_ = row;
			}
			row = _tmp45_;
			_tmp46_ = data_new;
			_tmp47_ = new_date;
			_tmp48_ = _data26_->day;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp46_, (gpointer) ((guintptr) maya_view_grid_day_hash (self, _tmp47_)), _tmp48_);
			_g_date_time_unref0 (new_date);
			block26_data_unref (_data26_);
			_data26_ = NULL;
		}
	}
	while (TRUE) {
		GeeList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		GDateTime* old_date = NULL;
		GeeList* _tmp52_;
		gpointer _tmp53_;
		MayaViewGridDay* old_day = NULL;
		GeeHashMap* _tmp54_;
		GDateTime* _tmp55_;
		gpointer _tmp56_;
		MayaViewGridDay* _tmp57_;
		gint _tmp58_;
		_tmp49_ = old_dates;
		_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		if (!(i < _tmp51_)) {
			break;
		}
		_tmp52_ = old_dates;
		_tmp53_ = gee_list_get (_tmp52_, i);
		old_date = (GDateTime*) _tmp53_;
		_tmp54_ = self->priv->data;
		_tmp55_ = old_date;
		_tmp56_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp54_, (gpointer) ((guintptr) maya_view_grid_day_hash (self, _tmp55_)));
		old_day = (MayaViewGridDay*) _tmp56_;
		_tmp57_ = old_day;
		gtk_widget_destroy ((GtkWidget*) _tmp57_);
		_tmp58_ = i;
		i = _tmp58_ + 1;
		_g_object_unref0 (old_day);
		_g_date_time_unref0 (old_date);
	}
	_tmp59_ = self->priv->data;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp59_);
	_tmp60_ = self->priv->data;
	_tmp61_ = data_new;
	gee_map_set_all ((GeeMap*) _tmp60_, (GeeMap*) _tmp61_);
	maya_view_grid_set_grid_range (self, new_range);
	_g_object_unref0 (data_new);
	_g_object_unref0 (new_dates);
	_g_object_unref0 (old_dates);
	_g_date_time_unref0 (today);
}

/**
     * Updates the given GridDay so that it shows the given date. Changes to its style etc.
     */
static MayaViewGridDay*
maya_view_grid_update_day (MayaViewGrid* self,
                           MayaViewGridDay* day,
                           GDateTime* new_date,
                           GDateTime* today,
                           GDateTime* month_start)
{
	gboolean _tmp0_ = FALSE;
	MayaViewGridDay* _tmp2_;
	MayaViewGridDay* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (day != NULL, NULL);
	g_return_val_if_fail (new_date != NULL, NULL);
	g_return_val_if_fail (today != NULL, NULL);
	g_return_val_if_fail (month_start != NULL, NULL);
	if (g_date_time_get_day_of_year (new_date) == g_date_time_get_day_of_year (today)) {
		_tmp0_ = g_date_time_get_year (new_date) == g_date_time_get_year (today);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MayaViewGridDay* _tmp1_;
		gtk_widget_set_name ((GtkWidget*) day, "today");
		_tmp1_ = _g_object_ref0 (day);
		_g_object_unref0 (self->priv->today_widget);
		self->priv->today_widget = _tmp1_;
	}
	maya_view_grid_day_set_in_current_month (day, g_date_time_get_month (new_date) == g_date_time_get_month (month_start));
	maya_view_grid_day_set_date (day, new_date);
	_tmp2_ = _g_object_ref0 (day);
	result = _tmp2_;
	return result;
}

/**
     * Puts the given event on the grid.
     */
void
maya_view_grid_add_event (MayaViewGrid* self,
                          ECalComponent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		GeeIterator* _grid_day_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->data;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_grid_day_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			MayaViewGridDay* grid_day = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			MayaViewGridDay* _tmp9_;
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			_tmp6_ = _grid_day_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _grid_day_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			grid_day = (MayaViewGridDay*) _tmp8_;
			_tmp9_ = grid_day;
			_tmp10_ = maya_view_grid_day_get_date (_tmp9_);
			_tmp11_ = _tmp10_;
			if (calendar_util_ecalcomponent_is_on_day (event, _tmp11_)) {
				MayaViewEventButton* button = NULL;
				MayaViewEventButton* _tmp12_;
				MayaViewGridDay* _tmp13_;
				MayaViewEventButton* _tmp14_;
				_tmp12_ = maya_view_event_button_new (event);
				g_object_ref_sink (_tmp12_);
				button = _tmp12_;
				_tmp13_ = grid_day;
				_tmp14_ = button;
				maya_view_grid_day_add_event_button (_tmp13_, _tmp14_);
				_g_object_unref0 (button);
			}
			_g_object_unref0 (grid_day);
		}
		_g_object_unref0 (_grid_day_it);
	}
}

static guint
maya_view_grid_day_hash (MayaViewGrid* self,
                         GDateTime* date)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (date != NULL, 0U);
	result = (guint) (((g_date_time_get_year (date) * 10000) + (g_date_time_get_month (date) * 100)) + g_date_time_get_day_of_month (date));
	return result;
}

/**
     * Removes the given event from the grid.
     */
void
maya_view_grid_remove_event (MayaViewGrid* self,
                             ECalComponent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		GeeIterator* _grid_day_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->data;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_grid_day_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			MayaViewGridDay* grid_day = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			MayaViewGridDay* _tmp9_;
			_tmp6_ = _grid_day_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _grid_day_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			grid_day = (MayaViewGridDay*) _tmp8_;
			_tmp9_ = grid_day;
			maya_view_grid_day_remove_event (_tmp9_, event);
			_g_object_unref0 (grid_day);
		}
		_g_object_unref0 (_grid_day_it);
	}
}

void
maya_view_grid_update_event (MayaViewGrid* self,
                             ECalComponent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		GeeIterator* _grid_day_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->data;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_grid_day_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			MayaViewGridDay* grid_day = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			MayaViewGridDay* _tmp9_;
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			_tmp6_ = _grid_day_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _grid_day_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			grid_day = (MayaViewGridDay*) _tmp8_;
			_tmp9_ = grid_day;
			_tmp10_ = maya_view_grid_day_get_date (_tmp9_);
			_tmp11_ = _tmp10_;
			if (calendar_util_ecalcomponent_is_on_day (event, _tmp11_)) {
				MayaViewGridDay* _tmp12_;
				_tmp12_ = grid_day;
				if (!maya_view_grid_day_update_event (_tmp12_, event)) {
					MayaViewEventButton* button = NULL;
					MayaViewEventButton* _tmp13_;
					MayaViewGridDay* _tmp14_;
					MayaViewEventButton* _tmp15_;
					_tmp13_ = maya_view_event_button_new (event);
					g_object_ref_sink (_tmp13_);
					button = _tmp13_;
					_tmp14_ = grid_day;
					_tmp15_ = button;
					maya_view_grid_day_add_event_button (_tmp14_, _tmp15_);
					_g_object_unref0 (button);
				}
			} else {
				MayaViewGridDay* _tmp16_;
				_tmp16_ = grid_day;
				maya_view_grid_day_remove_event (_tmp16_, event);
			}
			_g_object_unref0 (grid_day);
		}
		_g_object_unref0 (_grid_day_it);
	}
}

/**
     * Removes all events from the grid.
     */
void
maya_view_grid_remove_all_events (MayaViewGrid* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _grid_day_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->data;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_grid_day_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			MayaViewGridDay* grid_day = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			MayaViewGridDay* _tmp9_;
			_tmp6_ = _grid_day_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _grid_day_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			grid_day = (MayaViewGridDay*) _tmp8_;
			_tmp9_ = grid_day;
			maya_view_grid_day_clear_events (_tmp9_);
			_g_object_unref0 (grid_day);
		}
		_g_object_unref0 (_grid_day_it);
	}
}

MayaViewGrid*
maya_view_grid_construct (GType object_type)
{
	MayaViewGrid * self = NULL;
	self = (MayaViewGrid*) g_object_new (object_type, NULL);
	return self;
}

MayaViewGrid*
maya_view_grid_new (void)
{
	return maya_view_grid_construct (MAYA_VIEW_TYPE_GRID);
}

CalendarUtilDateRange*
maya_view_grid_get_grid_range (MayaViewGrid* self)
{
	CalendarUtilDateRange* result;
	CalendarUtilDateRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_grid_range;
	result = _tmp0_;
	return result;
}

static void
maya_view_grid_set_grid_range (MayaViewGrid* self,
                               CalendarUtilDateRange* value)
{
	CalendarUtilDateRange* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_grid_get_grid_range (self);
	if (old_value != value) {
		CalendarUtilDateRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_grid_range);
		self->priv->_grid_range = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_grid_properties[MAYA_VIEW_GRID_GRID_RANGE_PROPERTY]);
	}
}

static void
_maya_view_grid_callback_update_today_calendar_time_manager_on_update_today (CalendarTimeManager* _sender,
                                                                             gpointer self)
{
	maya_view_grid_callback_update_today ((MayaViewGrid*) self);
}

static GObject *
maya_view_grid_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewGrid * self;
	GeeHashMap* _tmp0_;
	GdkEventMask _tmp1_;
	GdkEventMask _tmp2_;
	GdkEventMask _tmp3_;
	GdkEventMask _tmp4_;
	CalendarTimeManager* time_manager = NULL;
	CalendarTimeManager* _tmp5_;
	CalendarTimeManager* _tmp6_;
	parent_class = G_OBJECT_CLASS (maya_view_grid_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_GRID, MayaViewGrid);
	gtk_grid_insert_column ((GtkGrid*) self, 7);
	gtk_grid_set_column_homogeneous ((GtkGrid*) self, TRUE);
	gtk_grid_set_row_homogeneous ((GtkGrid*) self, TRUE);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 0);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 0);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, MAYA_VIEW_TYPE_GRID_DAY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->data);
	self->priv->data = _tmp0_;
	_tmp1_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp2_ | GDK_SCROLL_MASK);
	_tmp3_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp4_ = _tmp3_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp4_ | GDK_SMOOTH_SCROLL_MASK);
	_tmp5_ = calendar_time_manager_get_default ();
	time_manager = _tmp5_;
	_tmp6_ = time_manager;
	g_signal_connect_object (_tmp6_, "on-update-today", (GCallback) _maya_view_grid_callback_update_today_calendar_time_manager_on_update_today, self, 0);
	return obj;
}

static void
maya_view_grid_class_init (MayaViewGridClass * klass,
                           gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	maya_view_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewGrid_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_grid_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_grid_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_grid_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_GRID_GRID_RANGE_PROPERTY, maya_view_grid_properties[MAYA_VIEW_GRID_GRID_RANGE_PROPERTY] = g_param_spec_object ("grid-range", "grid-range", "grid-range", CALENDAR_UTIL_TYPE_DATE_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	maya_view_grid_signals[MAYA_VIEW_GRID_ON_EVENT_ADD_SIGNAL] = g_signal_new ("on-event-add", MAYA_VIEW_TYPE_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	maya_view_grid_signals[MAYA_VIEW_GRID_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", MAYA_VIEW_TYPE_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (maya_view_grid_style_provider);
	maya_view_grid_style_provider = _tmp0_;
	_tmp1_ = maya_view_grid_style_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/calendar/Grid.css");
}

static void
maya_view_grid_instance_init (MayaViewGrid * self,
                              gpointer klass)
{
	self->priv = maya_view_grid_get_instance_private (self);
	self->priv->today_widget = NULL;
}

static void
maya_view_grid_finalize (GObject * obj)
{
	MayaViewGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_GRID, MayaViewGrid);
	_g_object_unref0 (self->priv->data);
	_g_object_unref0 (self->priv->_grid_range);
	_g_object_unref0 (self->priv->selected_gridday);
	_g_object_unref0 (self->priv->today_widget);
	G_OBJECT_CLASS (maya_view_grid_parent_class)->finalize (obj);
}

/**
 * Represents the entire date grid as a table.
 */
static GType
maya_view_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewGrid), 0, (GInstanceInitFunc) maya_view_grid_instance_init, NULL };
	GType maya_view_grid_type_id;
	maya_view_grid_type_id = g_type_register_static (gtk_grid_get_type (), "MayaViewGrid", &g_define_type_info, 0);
	MayaViewGrid_private_offset = g_type_add_instance_private (maya_view_grid_type_id, sizeof (MayaViewGridPrivate));
	return maya_view_grid_type_id;
}

GType
maya_view_grid_get_type (void)
{
	static volatile gsize maya_view_grid_type_id__once = 0;
	if (g_once_init_enter (&maya_view_grid_type_id__once)) {
		GType maya_view_grid_type_id;
		maya_view_grid_type_id = maya_view_grid_get_type_once ();
		g_once_init_leave (&maya_view_grid_type_id__once, maya_view_grid_type_id);
	}
	return maya_view_grid_type_id__once;
}

static void
_vala_maya_view_grid_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	MayaViewGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_GRID, MayaViewGrid);
	switch (property_id) {
		case MAYA_VIEW_GRID_GRID_RANGE_PROPERTY:
		g_value_set_object (value, maya_view_grid_get_grid_range (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_grid_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	MayaViewGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_GRID, MayaViewGrid);
	switch (property_id) {
		case MAYA_VIEW_GRID_GRID_RANGE_PROPERTY:
		maya_view_grid_set_grid_range (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

