/* Thumbnail.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Thumbnail.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <pango/pango.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define THUMBNAIL_HQ_IMPROVEMENT_MSEC 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	THUMBNAIL_0_PROPERTY,
	THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* thumbnail_properties[THUMBNAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ThumbnailPrivate {
	MediaSource* media;
	gint scale;
	Dimensions original_dim;
	Dimensions dim;
	GdkPixbuf* unscaled_pixbuf;
	GCancellable* cancellable;
	gboolean hq_scheduled;
	gboolean hq_reschedule;
	gboolean exposure;
};

static gint Thumbnail_private_offset;
static gpointer thumbnail_parent_class = NULL;
static gint thumbnail__scale_factor;
static gint thumbnail__scale_factor = 1;

static void thumbnail_on_tag_contents_altered (Thumbnail* self,
                                        ContainerSource* container,
                                        GeeCollection* added,
                                        gboolean relinking,
                                        GeeCollection* removed,
                                        gboolean unlinking);
static void _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                                ContainerSource* container,
                                                                                                GeeCollection* added,
                                                                                                gboolean relinked,
                                                                                                GeeCollection* removed,
                                                                                                gboolean unlinked,
                                                                                                gpointer self);
static void thumbnail_on_tags_altered (Thumbnail* self,
                                GeeMap* altered);
static void _thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                               GeeMap* items,
                                                               gpointer self);
static void thumbnail_set_scale_factor (Thumbnail* self,
                                 gint value);
static gint thumbnail_get_scale_factor (Thumbnail* self);
static void thumbnail_update_title (Thumbnail* self,
                             gboolean init);
static void thumbnail_update_comment (Thumbnail* self,
                               gboolean init);
static void thumbnail_update_tags (Thumbnail* self,
                            gboolean init);
static void thumbnail_real_notify_altered (DataObject* base,
                                    Alteration* alteration);
gchar* g_utf8_collate_key_for_filename (const gchar* str,
                                        gssize len);
static void thumbnail_real_thumbnail_altered (ThumbnailView* base);
static void thumbnail_delayed_high_quality_fetch (Thumbnail* self);
static void thumbnail_paint_empty (Thumbnail* self);
static void thumbnail_real_notify_collection_property_set (DataObject* base,
                                                    const gchar* name,
                                                    GValue* old,
                                                    GValue* val);
static void thumbnail_resize (Thumbnail* self,
                       gint new_scale);
static void thumbnail_cancel_async_fetch (Thumbnail* self);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
static void thumbnail_schedule_low_quality_fetch (Thumbnail* self);
static void thumbnail_on_low_quality_fetched (Thumbnail* self,
                                       GdkPixbuf* pixbuf,
                                       GdkPixbuf* unscaled,
                                       Dimensions* dim,
                                       GdkInterpType interp,
                                       GError* err);
static void _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                             GdkPixbuf* unscaled,
                                                                             Dimensions* dim,
                                                                             GdkInterpType interp,
                                                                             GError* err,
                                                                             gpointer self);
static gboolean thumbnail_on_schedule_high_quality (Thumbnail* self);
static gboolean _thumbnail_on_schedule_high_quality_gsource_func (gpointer self);
static void thumbnail_on_high_quality_fetched (Thumbnail* self,
                                        GdkPixbuf* pixbuf,
                                        GdkPixbuf* unscaled,
                                        Dimensions* dim,
                                        GdkInterpType interp,
                                        GError* err);
static void _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                              GdkPixbuf* unscaled,
                                                                              Dimensions* dim,
                                                                              GdkInterpType interp,
                                                                              GError* err,
                                                                              gpointer self);
static void thumbnail_real_exposed (CheckerboardItem* base);
static void thumbnail_real_unexposed (CheckerboardItem* base);
static void thumbnail_real_paint (CheckerboardItem* base,
                           cairo_t* ctx,
                           GtkStyleContext* style_context);
static void thumbnail_finalize (GObject * obj);
static GType thumbnail_get_type_once (void);
static void _vala_thumbnail_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_thumbnail_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
thumbnail_get_instance_private (Thumbnail* self)
{
	return G_STRUCT_MEMBER_P (self, Thumbnail_private_offset);
}

static void
_thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                           ContainerSource* container,
                                                                                           GeeCollection* added,
                                                                                           gboolean relinked,
                                                                                           GeeCollection* removed,
                                                                                           gboolean unlinked,
                                                                                           gpointer self)
{
	thumbnail_on_tag_contents_altered ((Thumbnail*) self, container, added, relinked, removed, unlinked);
}

static void
_thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                          GeeMap* items,
                                                          gpointer self)
{
	thumbnail_on_tags_altered ((Thumbnail*) self, items);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Thumbnail*
thumbnail_construct (GType object_type,
                     MediaSource* media,
                     gint scale)
{
	Thumbnail * self = NULL;
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	MediaSource* _tmp8_;
	TagSourceCollection* _tmp9_;
	TagSourceCollection* _tmp10_;
	Dimensions _tmp11_ = {0};
	gint _tmp12_;
	gint _tmp13_;
	Dimensions _tmp14_ = {0};
	g_return_val_if_fail (media != NULL, NULL);
	media_source_get_dimensions (media, PHOTO_EXCEPTION_NONE, &_tmp0_);
	dimensions_get_scaled (&_tmp0_, scale, TRUE, &_tmp1_);
	_tmp2_ = data_object_get_name ((DataObject*) media);
	_tmp3_ = _tmp2_;
	_tmp4_ = media_source_get_comment (media);
	_tmp5_ = _tmp4_;
	self = (Thumbnail*) checkerboard_item_construct (object_type, (ThumbnailSource*) media, &_tmp1_, _tmp3_, _tmp5_, FALSE, PANGO_ALIGN_LEFT);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = thumbnail_cache_get_scale_factor ();
	_tmp7_ = _tmp6_;
	thumbnail_set_scale_factor (self, _tmp7_);
	_tmp8_ = _g_object_ref0 (media);
	_g_object_unref0 (self->priv->media);
	self->priv->media = _tmp8_;
	self->priv->scale = scale;
	_tmp9_ = tag_global;
	g_signal_connect_object ((ContainerSourceCollection*) _tmp9_, "container-contents-altered", (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self, 0);
	_tmp10_ = tag_global;
	g_signal_connect_object ((DataCollection*) _tmp10_, "items-altered", (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self, 0);
	media_source_get_dimensions (media, PHOTO_EXCEPTION_NONE, &_tmp11_);
	self->priv->original_dim = _tmp11_;
	_tmp12_ = thumbnail_get_scale_factor (self);
	_tmp13_ = _tmp12_;
	dimensions_get_scaled (&self->priv->original_dim, scale * _tmp13_, TRUE, &_tmp14_);
	self->priv->dim = _tmp14_;
	thumbnail_update_title (self, TRUE);
	thumbnail_update_comment (self, TRUE);
	thumbnail_update_tags (self, TRUE);
	return self;
}

Thumbnail*
thumbnail_new (MediaSource* media,
               gint scale)
{
	return thumbnail_construct (TYPE_THUMBNAIL, media, scale);
}

static void
thumbnail_update_tags (Thumbnail* self,
                       gboolean init)
{
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp0_;
	MediaSource* _tmp1_;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tag_global;
	_tmp1_ = self->priv->media;
	_tmp2_ = tag_source_collection_fetch_sorted_for_source (_tmp0_, _tmp1_);
	tags = (GeeCollection*) _tmp2_;
	_tmp4_ = tags;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeCollection* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = tags;
		_tmp6_ = gee_collection_get_size (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == 0;
	}
	if (_tmp3_) {
		checkerboard_item_clear_subtitle ((CheckerboardItem*) self);
	} else {
		if (!init) {
			GeeCollection* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = tags;
			_tmp9_ = tag_make_tag_string (_tmp8_, "<small>", ", ", "</small>", TRUE);
			_tmp10_ = _tmp9_;
			checkerboard_item_set_subtitle ((CheckerboardItem*) self, _tmp10_, TRUE, PANGO_ALIGN_LEFT);
			_g_free0 (_tmp10_);
		} else {
			checkerboard_item_set_subtitle ((CheckerboardItem*) self, "<small>.</small>", TRUE, PANGO_ALIGN_LEFT);
		}
	}
	_g_object_unref0 (tags);
}

static void
thumbnail_on_tag_contents_altered (Thumbnail* self,
                                   ContainerSource* container,
                                   GeeCollection* added,
                                   gboolean relinking,
                                   GeeCollection* removed,
                                   gboolean unlinking)
{
	gboolean _tmp0_ = FALSE;
	gboolean tag_added = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean tag_removed = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	if (!self->priv->exposure) {
		return;
	}
	if (added != NULL) {
		MediaSource* _tmp1_;
		_tmp1_ = self->priv->media;
		_tmp0_ = gee_collection_contains (added, (DataSource*) _tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	tag_added = _tmp0_;
	if (removed != NULL) {
		MediaSource* _tmp3_;
		_tmp3_ = self->priv->media;
		_tmp2_ = gee_collection_contains (removed, (DataSource*) _tmp3_);
	} else {
		_tmp2_ = FALSE;
	}
	tag_removed = _tmp2_;
	if (tag_added) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = tag_removed;
	}
	if (_tmp4_) {
		thumbnail_update_tags (self, FALSE);
	}
}

static void
thumbnail_on_tags_altered (Thumbnail* self,
                           GeeMap* altered)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (altered != NULL);
	if (!self->priv->exposure) {
		return;
	}
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (altered);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Tag* tag = NULL;
			DataObject* _tmp8_;
			Tag* _tmp9_;
			Tag* _tmp10_;
			MediaSource* _tmp11_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_TAG, Tag));
			tag = _tmp9_;
			_tmp10_ = tag;
			_tmp11_ = self->priv->media;
			if (tag_contains (_tmp10_, _tmp11_)) {
				thumbnail_update_tags (self, FALSE);
				_g_object_unref0 (tag);
				_g_object_unref0 (object);
				break;
			}
			_g_object_unref0 (tag);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
thumbnail_update_title (Thumbnail* self,
                        gboolean init)
{
	gchar* title = NULL;
	MediaSource* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->media;
	_tmp1_ = data_object_get_name ((DataObject*) _tmp0_);
	title = _tmp1_;
	_tmp2_ = title;
	if (is_string_empty (_tmp2_)) {
		checkerboard_item_clear_title ((CheckerboardItem*) self);
	} else {
		if (!init) {
			const gchar* _tmp3_;
			_tmp3_ = title;
			checkerboard_item_set_title ((CheckerboardItem*) self, _tmp3_, FALSE, PANGO_ALIGN_LEFT);
		} else {
			checkerboard_item_set_title ((CheckerboardItem*) self, "", FALSE, PANGO_ALIGN_LEFT);
		}
	}
	_g_free0 (title);
}

static void
thumbnail_update_comment (Thumbnail* self,
                          gboolean init)
{
	gchar* comment = NULL;
	MediaSource* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->media;
	_tmp1_ = media_source_get_comment (_tmp0_);
	comment = _tmp1_;
	_tmp2_ = comment;
	if (is_string_empty (_tmp2_)) {
		checkerboard_item_clear_comment ((CheckerboardItem*) self);
	} else {
		if (!init) {
			const gchar* _tmp3_;
			_tmp3_ = comment;
			checkerboard_item_set_comment ((CheckerboardItem*) self, _tmp3_, FALSE, PANGO_ALIGN_LEFT);
		} else {
			checkerboard_item_set_comment ((CheckerboardItem*) self, "", FALSE, PANGO_ALIGN_LEFT);
		}
	}
	_g_free0 (comment);
}

static void
thumbnail_real_notify_altered (DataObject* base,
                               Alteration* alteration)
{
	Thumbnail * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (Thumbnail*) base;
	g_return_if_fail (alteration != NULL);
	if (self->priv->exposure) {
		_tmp0_ = alteration_has_detail (alteration, "metadata", "name");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		thumbnail_update_title (self, FALSE);
	}
	if (self->priv->exposure) {
		_tmp1_ = alteration_has_detail (alteration, "metadata", "comment");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		thumbnail_update_comment (self, FALSE);
	}
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_altered ((DataObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), alteration);
}

MediaSource*
thumbnail_get_media_source (Thumbnail* self)
{
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	MediaSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->media;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gint64
thumbnail_photo_id_ascending_comparator (void* a,
                                         void* b)
{
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	gint64 result;
	_tmp0_ = ((Thumbnail*) a)->priv->media;
	_tmp1_ = ((Thumbnail*) b)->priv->media;
	result = data_source_get_instance_id ((DataSource*) _tmp0_) - data_source_get_instance_id ((DataSource*) _tmp1_);
	return result;
}

gint64
thumbnail_photo_id_descending_comparator (void* a,
                                          void* b)
{
	gint64 result;
	result = thumbnail_photo_id_ascending_comparator (b, a);
	return result;
}

gint64
thumbnail_title_ascending_comparator (void* a,
                                      void* b)
{
	gint64 _result_ = 0LL;
	GCompareFunc _tmp0_;
	MediaSource* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	MediaSource* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_ = 0LL;
	gint64 result;
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = ((Thumbnail*) a)->priv->media;
	_tmp2_ = data_object_get_name ((DataObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = ((Thumbnail*) b)->priv->media;
	_tmp5_ = data_object_get_name ((DataObject*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = (gint64) _tmp0_ (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_result_ = _tmp7_;
	if (_result_ != ((gint64) 0)) {
		_tmp8_ = _result_;
	} else {
		_tmp8_ = thumbnail_photo_id_ascending_comparator (a, b);
	}
	result = _tmp8_;
	return result;
}

gint64
thumbnail_title_descending_comparator (void* a,
                                       void* b)
{
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 result;
	_result_ = thumbnail_title_ascending_comparator (b, a);
	if (_result_ != ((gint64) 0)) {
		_tmp0_ = _result_;
	} else {
		_tmp0_ = thumbnail_photo_id_descending_comparator (a, b);
	}
	result = _tmp0_;
	return result;
}

gboolean
thumbnail_title_comparator_predicate (DataObject* object,
                                      Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	result = alteration_has_detail (alteration, "metadata", "title");
	return result;
}

gint64
thumbnail_exposure_time_ascending_comparator (void* a,
                                              void* b)
{
	gint64 time_a = 0LL;
	MediaSource* _tmp0_;
	gint64 time_b = 0LL;
	MediaSource* _tmp1_;
	gint64 _result_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 result;
	_tmp0_ = ((Thumbnail*) a)->priv->media;
	time_a = media_source_get_exposure_time (_tmp0_);
	_tmp1_ = ((Thumbnail*) b)->priv->media;
	time_b = media_source_get_exposure_time (_tmp1_);
	_result_ = time_a - time_b;
	if (_result_ != ((gint64) 0)) {
		_tmp2_ = _result_;
	} else {
		_tmp2_ = thumbnail_filename_ascending_comparator (a, b);
	}
	result = _tmp2_;
	return result;
}

gint64
thumbnail_exposure_time_descending_comparator (void* a,
                                               void* b)
{
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 result;
	_result_ = thumbnail_exposure_time_ascending_comparator (b, a);
	if (_result_ != ((gint64) 0)) {
		_tmp0_ = _result_;
	} else {
		_tmp0_ = thumbnail_filename_descending_comparator (a, b);
	}
	result = _tmp0_;
	return result;
}

gboolean
thumbnail_exposure_time_comparator_predicate (DataObject* object,
                                              Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	result = alteration_has_detail (alteration, "metadata", "exposure-time");
	return result;
}

gint64
thumbnail_timestamp_ascending_comparator (void* a,
                                          void* b)
{
	gint64 time_a = 0LL;
	MediaSource* _tmp0_;
	gint64 time_b = 0LL;
	MediaSource* _tmp1_;
	gint64 _result_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 result;
	_tmp0_ = ((Thumbnail*) a)->priv->media;
	time_a = (gint64) media_source_get_timestamp (_tmp0_);
	_tmp1_ = ((Thumbnail*) b)->priv->media;
	time_b = (gint64) media_source_get_timestamp (_tmp1_);
	_result_ = time_a - time_b;
	if (_result_ != ((gint64) 0)) {
		_tmp2_ = _result_;
	} else {
		_tmp2_ = thumbnail_exposure_time_ascending_comparator (a, b);
	}
	result = _tmp2_;
	return result;
}

gint64
thumbnail_timestamp_descending_comparator (void* a,
                                           void* b)
{
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 result;
	_result_ = thumbnail_timestamp_ascending_comparator (b, a);
	if (_result_ != ((gint64) 0)) {
		_tmp0_ = _result_;
	} else {
		_tmp0_ = thumbnail_exposure_time_descending_comparator (a, b);
	}
	result = _tmp0_;
	return result;
}

gboolean
thumbnail_timestamp_comparator_predicate (DataObject* object,
                                          Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	result = alteration_has_detail (alteration, "metadata", "timestamp");
	return result;
}

gint64
thumbnail_filename_ascending_comparator (void* a,
                                         void* b)
{
	gchar* path_a = NULL;
	MediaSource* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* path_b = NULL;
	MediaSource* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gint64 _result_ = 0LL;
	GCompareFunc _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint64 _tmp21_;
	gint64 _tmp22_ = 0LL;
	gint64 result;
	_tmp0_ = ((Thumbnail*) a)->priv->media;
	_tmp1_ = media_source_get_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	path_a = _tmp6_;
	_tmp7_ = ((Thumbnail*) b)->priv->media;
	_tmp8_ = media_source_get_file (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_basename (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_object_unref0 (_tmp9_);
	path_b = _tmp13_;
	_tmp14_ = ((GCompareFunc) g_strcmp0);
	_tmp15_ = path_a;
	_tmp16_ = g_utf8_collate_key_for_filename (_tmp15_, (gssize) -1);
	_tmp17_ = _tmp16_;
	_tmp18_ = path_b;
	_tmp19_ = g_utf8_collate_key_for_filename (_tmp18_, (gssize) -1);
	_tmp20_ = _tmp19_;
	_tmp21_ = (gint64) _tmp14_ (_tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp17_);
	_result_ = _tmp21_;
	if (_result_ != ((gint64) 0)) {
		_tmp22_ = _result_;
	} else {
		_tmp22_ = thumbnail_photo_id_ascending_comparator (a, b);
	}
	result = _tmp22_;
	_g_free0 (path_b);
	_g_free0 (path_a);
	return result;
}

gint64
thumbnail_filename_descending_comparator (void* a,
                                          void* b)
{
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 result;
	_result_ = thumbnail_filename_ascending_comparator (b, a);
	if (_result_ != ((gint64) 0)) {
		_tmp0_ = _result_;
	} else {
		_tmp0_ = thumbnail_photo_id_descending_comparator (a, b);
	}
	result = _tmp0_;
	return result;
}

static void
thumbnail_real_thumbnail_altered (ThumbnailView* base)
{
	Thumbnail * self;
	MediaSource* _tmp0_;
	Dimensions _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	self = (Thumbnail*) base;
	_tmp0_ = self->priv->media;
	media_source_get_dimensions (_tmp0_, PHOTO_EXCEPTION_NONE, &_tmp1_);
	self->priv->original_dim = _tmp1_;
	_tmp2_ = thumbnail_get_scale_factor (self);
	_tmp3_ = _tmp2_;
	dimensions_get_scaled (&self->priv->original_dim, self->priv->scale * _tmp3_, TRUE, &_tmp4_);
	self->priv->dim = _tmp4_;
	if (self->priv->exposure) {
		thumbnail_delayed_high_quality_fetch (self);
	} else {
		thumbnail_paint_empty (self);
	}
	THUMBNAIL_VIEW_CLASS (thumbnail_parent_class)->thumbnail_altered ((ThumbnailView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static void
thumbnail_real_notify_collection_property_set (DataObject* base,
                                               const gchar* name,
                                               GValue* old,
                                               GValue* val)
{
	Thumbnail * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	GValue _tmp4_;
	self = (Thumbnail*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (THUMBNAIL_PROP_SIZE)))) {
		switch (0) {
			default:
			{
				GValue _tmp3_;
				_tmp3_ = *val;
				thumbnail_resize (self, g_value_get_int (&_tmp3_));
				break;
			}
		}
	}
	_tmp4_ = *val;
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_collection_property_set ((DataObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), name, old, &_tmp4_);
}

static void
thumbnail_resize (Thumbnail* self,
                  gint new_scale)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Dimensions _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = thumbnail_get_MIN_SCALE ();
	_tmp1_ = _tmp0_;
	_vala_assert (new_scale >= _tmp1_, "new_scale >= MIN_SCALE");
	_tmp2_ = thumbnail_get_MAX_SCALE ();
	_tmp3_ = _tmp2_;
	_vala_assert (new_scale <= _tmp3_, "new_scale <= MAX_SCALE");
	if (self->priv->scale == new_scale) {
		return;
	}
	self->priv->scale = new_scale;
	_tmp4_ = thumbnail_get_scale_factor (self);
	_tmp5_ = _tmp4_;
	dimensions_get_scaled (&self->priv->original_dim, self->priv->scale * _tmp5_, TRUE, &_tmp6_);
	self->priv->dim = _tmp6_;
	thumbnail_cancel_async_fetch (self);
	if (self->priv->exposure) {
		GdkPixbuf* resizable = NULL;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp11_;
		resizable = NULL;
		_tmp7_ = self->priv->unscaled_pixbuf;
		if (_tmp7_ != NULL) {
			GdkPixbuf* _tmp8_;
			GdkPixbuf* _tmp9_;
			_tmp8_ = self->priv->unscaled_pixbuf;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (resizable);
			resizable = _tmp9_;
		} else {
			if (checkerboard_item_has_image ((CheckerboardItem*) self)) {
				GdkPixbuf* _tmp10_;
				_tmp10_ = checkerboard_item_get_image ((CheckerboardItem*) self);
				_g_object_unref0 (resizable);
				resizable = _tmp10_;
			}
		}
		_tmp11_ = resizable;
		if (_tmp11_ != NULL) {
			GdkPixbuf* _tmp12_;
			Dimensions _tmp13_;
			GdkPixbuf* _tmp14_;
			GdkPixbuf* _tmp15_;
			_tmp12_ = resizable;
			_tmp13_ = self->priv->dim;
			_tmp14_ = resize_pixbuf (_tmp12_, &_tmp13_, THUMBNAIL_LOW_QUALITY_INTERP);
			_tmp15_ = _tmp14_;
			checkerboard_item_set_image ((CheckerboardItem*) self, _tmp15_);
			_g_object_unref0 (_tmp15_);
		}
		thumbnail_delayed_high_quality_fetch (self);
		_g_object_unref0 (resizable);
	} else {
		Dimensions _tmp16_;
		_tmp16_ = self->priv->dim;
		checkerboard_item_clear_image ((CheckerboardItem*) self, &_tmp16_);
	}
}

static void
thumbnail_paint_empty (Thumbnail* self)
{
	Dimensions _tmp0_;
	g_return_if_fail (self != NULL);
	thumbnail_cancel_async_fetch (self);
	_tmp0_ = self->priv->dim;
	checkerboard_item_clear_image ((CheckerboardItem*) self, &_tmp0_);
	_g_object_unref0 (self->priv->unscaled_pixbuf);
	self->priv->unscaled_pixbuf = NULL;
}

static void
_thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                        GdkPixbuf* unscaled,
                                                                        Dimensions* dim,
                                                                        GdkInterpType interp,
                                                                        GError* err,
                                                                        gpointer self)
{
	thumbnail_on_low_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
}

static void
thumbnail_schedule_low_quality_fetch (Thumbnail* self)
{
	GCancellable* _tmp0_;
	MediaSource* _tmp1_;
	Dimensions _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	thumbnail_cancel_async_fetch (self);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = self->priv->media;
	_tmp2_ = self->priv->dim;
	_tmp3_ = self->priv->cancellable;
	thumbnail_cache_fetch_async_scaled ((ThumbnailSource*) _tmp1_, (gint) THUMBNAIL_CACHE_SIZE_SMALLEST, &_tmp2_, THUMBNAIL_LOW_QUALITY_INTERP, _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp3_);
}

static gboolean
_thumbnail_on_schedule_high_quality_gsource_func (gpointer self)
{
	gboolean result;
	result = thumbnail_on_schedule_high_quality ((Thumbnail*) self);
	return result;
}

static void
thumbnail_delayed_high_quality_fetch (Thumbnail* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->hq_scheduled) {
		self->priv->hq_reschedule = TRUE;
		return;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) THUMBNAIL_HQ_IMPROVEMENT_MSEC, _thumbnail_on_schedule_high_quality_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->hq_scheduled = TRUE;
}

static void
_thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                         GdkPixbuf* unscaled,
                                                                         Dimensions* dim,
                                                                         GdkInterpType interp,
                                                                         GError* err,
                                                                         gpointer self)
{
	thumbnail_on_high_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
}

static gboolean
thumbnail_on_schedule_high_quality (Thumbnail* self)
{
	GCancellable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->hq_reschedule) {
		self->priv->hq_reschedule = FALSE;
		result = TRUE;
		return result;
	}
	thumbnail_cancel_async_fetch (self);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	if (self->priv->exposure) {
		MediaSource* _tmp1_;
		Dimensions _tmp2_;
		GCancellable* _tmp3_;
		_tmp1_ = self->priv->media;
		_tmp2_ = self->priv->dim;
		_tmp3_ = self->priv->cancellable;
		thumbnail_cache_fetch_async_scaled ((ThumbnailSource*) _tmp1_, self->priv->scale, &_tmp2_, THUMBNAIL_HIGH_QUALITY_INTERP, _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp3_);
	}
	self->priv->hq_scheduled = FALSE;
	result = FALSE;
	return result;
}

static void
thumbnail_cancel_async_fetch (Thumbnail* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static void
thumbnail_on_low_quality_fetched (Thumbnail* self,
                                  GdkPixbuf* pixbuf,
                                  GdkPixbuf* unscaled,
                                  Dimensions* dim,
                                  GdkInterpType interp,
                                  GError* err)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (dim != NULL);
	if (err != NULL) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = data_object_to_string ((DataObject*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = err->message;
		g_critical ("Thumbnail.vala:363: Unable to fetch low-quality thumbnail for %s (scal" \
"e: %d): %s", _tmp1_, self->priv->scale, _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (pixbuf != NULL) {
		checkerboard_item_set_image ((CheckerboardItem*) self, pixbuf);
	}
	if (unscaled != NULL) {
		GdkPixbuf* _tmp3_;
		_tmp3_ = _g_object_ref0 (unscaled);
		_g_object_unref0 (self->priv->unscaled_pixbuf);
		self->priv->unscaled_pixbuf = _tmp3_;
	}
	thumbnail_delayed_high_quality_fetch (self);
}

static void
thumbnail_on_high_quality_fetched (Thumbnail* self,
                                   GdkPixbuf* pixbuf,
                                   GdkPixbuf* unscaled,
                                   Dimensions* dim,
                                   GdkInterpType interp,
                                   GError* err)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (dim != NULL);
	if (err != NULL) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = data_object_to_string ((DataObject*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = err->message;
		g_critical ("Thumbnail.vala:378: Unable to fetch high-quality thumbnail for %s (sca" \
"le: %d): %s", _tmp1_, self->priv->scale, _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (pixbuf != NULL) {
		checkerboard_item_set_image ((CheckerboardItem*) self, pixbuf);
	}
	if (unscaled != NULL) {
		GdkPixbuf* _tmp3_;
		_tmp3_ = _g_object_ref0 (unscaled);
		_g_object_unref0 (self->priv->unscaled_pixbuf);
		self->priv->unscaled_pixbuf = _tmp3_;
	}
}

static void
thumbnail_real_exposed (CheckerboardItem* base)
{
	Thumbnail * self;
	self = (Thumbnail*) base;
	self->priv->exposure = TRUE;
	if (!checkerboard_item_has_image ((CheckerboardItem*) self)) {
		thumbnail_schedule_low_quality_fetch (self);
	}
	thumbnail_update_title (self, FALSE);
	thumbnail_update_comment (self, FALSE);
	thumbnail_update_tags (self, FALSE);
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static void
thumbnail_real_unexposed (CheckerboardItem* base)
{
	Thumbnail * self;
	self = (Thumbnail*) base;
	self->priv->exposure = FALSE;
	thumbnail_paint_empty (self);
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static void
thumbnail_real_paint (CheckerboardItem* base,
                      cairo_t* ctx,
                      GtkStyleContext* style_context)
{
	Thumbnail * self;
	gboolean _tmp0_ = FALSE;
	MediaSource* _tmp1_;
	self = (Thumbnail*) base;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (style_context != NULL);
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), ctx, style_context);
	thumbnail_set_scale_factor (self, gtk_style_context_get_scale (style_context));
	_tmp1_ = self->priv->media;
	if (_tmp1_ != NULL) {
		MediaSource* _tmp2_;
		_tmp2_ = self->priv->media;
		_tmp0_ = IS_FLAGGABLE (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MediaSource* _tmp3_;
		_tmp3_ = self->priv->media;
		if (flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_FLAGGABLE, Flaggable))) {
			GdkPixbuf* flag_icon = NULL;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			GdkRectangle _tmp6_;
			GdkRectangle _tmp7_;
			GdkPixbuf* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GdkRectangle _tmp11_;
			gtk_style_context_save (style_context);
			gtk_style_context_add_class (style_context, GRANITE_STYLE_CLASS_OVERLAY_BAR);
			_tmp4_ = resources_get_flag_trinket ();
			flag_icon = _tmp4_;
			_tmp5_ = flag_icon;
			_tmp6_ = ((CheckerboardItem*) self)->allocation;
			_tmp7_ = ((CheckerboardItem*) self)->allocation;
			_tmp8_ = flag_icon;
			_tmp9_ = gdk_pixbuf_get_width (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = ((CheckerboardItem*) self)->allocation;
			gtk_render_icon (style_context, ctx, _tmp5_, (gdouble) ((_tmp6_.x + _tmp7_.width) - (((_tmp10_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH) + THUMBNAIL_FLAG_OFFSET)), (gdouble) (((_tmp11_.y + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH) + THUMBNAIL_FLAG_OFFSET));
			gtk_style_context_restore (style_context);
			_g_object_unref0 (flag_icon);
		}
	}
}

gint
thumbnail_get_MIN_SCALE (void)
{
	gint result;
	result = 92;
	return result;
}

gint
thumbnail_get_MAX_SCALE (void)
{
	gint result;
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_LARGEST);
	return result;
}

gint
thumbnail_get_DEFAULT_SCALE (void)
{
	gint result;
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
	return result;
}

static gint
thumbnail_get_scale_factor (Thumbnail* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = thumbnail__scale_factor;
	return result;
}

static void
thumbnail_set_scale_factor (Thumbnail* self,
                            gint value)
{
	g_return_if_fail (self != NULL);
	if (thumbnail__scale_factor != value) {
		thumbnail__scale_factor = value;
		data_view_notify_view_altered ((DataView*) self);
	}
}

static void
thumbnail_class_init (ThumbnailClass * klass,
                      gpointer klass_data)
{
	thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Thumbnail_private_offset);
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) thumbnail_real_notify_altered;
	((ThumbnailViewClass *) klass)->thumbnail_altered = (void (*) (ThumbnailView*)) thumbnail_real_thumbnail_altered;
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject*, const gchar*, GValue*, GValue*)) thumbnail_real_notify_collection_property_set;
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem*)) thumbnail_real_exposed;
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem*)) thumbnail_real_unexposed;
	((CheckerboardItemClass *) klass)->paint = (void (*) (CheckerboardItem*, cairo_t*, GtkStyleContext*)) thumbnail_real_paint;
	G_OBJECT_CLASS (klass)->get_property = _vala_thumbnail_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_thumbnail_set_property;
	G_OBJECT_CLASS (klass)->finalize = thumbnail_finalize;
}

static void
thumbnail_instance_init (Thumbnail * self,
                         gpointer klass)
{
	self->priv = thumbnail_get_instance_private (self);
	self->priv->unscaled_pixbuf = NULL;
	self->priv->cancellable = NULL;
	self->priv->hq_scheduled = FALSE;
	self->priv->hq_reschedule = FALSE;
	self->priv->exposure = FALSE;
}

static void
thumbnail_finalize (GObject * obj)
{
	Thumbnail * self;
	GCancellable* _tmp0_;
	TagSourceCollection* _tmp2_;
	guint _tmp3_;
	TagSourceCollection* _tmp4_;
	guint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL, Thumbnail);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = tag_global;
	g_signal_parse_name ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ContainerSourceCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self);
	_tmp4_ = tag_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self);
	_g_object_unref0 (self->priv->media);
	_g_object_unref0 (self->priv->unscaled_pixbuf);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (thumbnail_parent_class)->finalize (obj);
}

static GType
thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnail), 0, (GInstanceInitFunc) thumbnail_instance_init, NULL };
	GType thumbnail_type_id;
	thumbnail_type_id = g_type_register_static (TYPE_CHECKERBOARD_ITEM, "Thumbnail", &g_define_type_info, 0);
	Thumbnail_private_offset = g_type_add_instance_private (thumbnail_type_id, sizeof (ThumbnailPrivate));
	return thumbnail_type_id;
}

GType
thumbnail_get_type (void)
{
	static volatile gsize thumbnail_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_type_id__once)) {
		GType thumbnail_type_id;
		thumbnail_type_id = thumbnail_get_type_once ();
		g_once_init_leave (&thumbnail_type_id__once, thumbnail_type_id);
	}
	return thumbnail_type_id__once;
}

static void
_vala_thumbnail_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	Thumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THUMBNAIL, Thumbnail);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_thumbnail_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	Thumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THUMBNAIL, Thumbnail);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

