#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkClientSocket_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDirectory_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExecutableRunner_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkServerSocket_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSocket_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSocketCollection_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTimerLog_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkCommonSystemCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkClientSocket_Init(csi);
  vtkDirectory_Init(csi);
  vtkExecutableRunner_Init(csi);
  vtkServerSocket_Init(csi);
  vtkSocket_Init(csi);
  vtkSocketCollection_Init(csi);
  vtkTimerLog_Init(csi);
}
