#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGLTFExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkIVExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkJSONDataSetWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkJSONRenderWindowExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkJSONSceneExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOBJExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOOGLExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPOVExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRIBExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRIBLight_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRIBProperty_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSVGContextDevice2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSVGExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSingleVTPExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVRMLExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkX3D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkX3DExporter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkX3DExporterFIWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkX3DExporterWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkX3DExporterXMLWriter_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOExportCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkExporter_Init(csi);
  vtkGLTFExporter_Init(csi);
  vtkIVExporter_Init(csi);
  vtkJSONDataSetWriter_Init(csi);
  vtkJSONRenderWindowExporter_Init(csi);
  vtkJSONSceneExporter_Init(csi);
  vtkOBJExporter_Init(csi);
  vtkOOGLExporter_Init(csi);
  vtkPOVExporter_Init(csi);
  vtkRIBExporter_Init(csi);
  vtkRIBLight_Init(csi);
  vtkRIBProperty_Init(csi);
  vtkSVGContextDevice2D_Init(csi);
  vtkSVGExporter_Init(csi);
  vtkSingleVTPExporter_Init(csi);
  vtkVRMLExporter_Init(csi);
  vtkX3D_Init(csi);
  vtkX3DExporter_Init(csi);
  vtkX3DExporterFIWriter_Init(csi);
  vtkX3DExporterWriter_Init(csi);
  vtkX3DExporterXMLWriter_Init(csi);
}
