// ClientServer wrapper for vtkIOSSReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkIOSSReader.h"
#include "vtkSystemIncludes.h"
#include "vtkStdString.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkIOSSReaderClientServerNewCommand(void* /*ctx*/)
{
  return vtkIOSSReader::New();
}


static int vtkIOSSReaderCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkIOSSReader *op = vtkIOSSReader::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkIOSSReader.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkIOSSReader  *temp20;
      {
      temp20 = vtkIOSSReader::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkIOSSReader::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkIOSSReader  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkIOSSReader::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkIOSSReader  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkIOSSReader::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AddFileName",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->AddFileName(temp0);
      return 1;
      }
    }
  if (!strcmp("ClearFileNames",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearFileNames();
      return 1;
      }
    }
  if (!strcmp("GetFileName",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    const char    *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetFileName(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfFileNames",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetNumberOfFileNames();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetFileName",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetFileName(temp0);
      return 1;
      }
    }
  if (!strcmp("SetDatabaseTypeOverride",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetDatabaseTypeOverride(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDatabaseTypeOverride",method) && msg.GetNumberOfArguments(0) == 2)
    {
    char    *temp20;
      {
      temp20 = (op)->GetDatabaseTypeOverride();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetDisplacementMagnitude",method) && msg.GetNumberOfArguments(0) == 3)
    {
    double   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetDisplacementMagnitude(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDisplacementMagnitude",method) && msg.GetNumberOfArguments(0) == 2)
    {
    double   temp20;
      {
      temp20 = (op)->GetDisplacementMagnitude();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetGroupNumericVectorFieldComponents",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetGroupNumericVectorFieldComponents(temp0);
      return 1;
      }
    }
  if (!strcmp("GetGroupNumericVectorFieldComponents",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetGroupNumericVectorFieldComponents();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetFieldSuffixSeparator",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetFieldSuffixSeparator(temp0);
      return 1;
      }
    }
  if (!strcmp("GetFieldSuffixSeparator",method) && msg.GetNumberOfArguments(0) == 2)
    {
    std::string   temp20;
      {
      temp20 = (op)->GetFieldSuffixSeparator();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetScanForRelatedFiles",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetScanForRelatedFiles(temp0);
      return 1;
      }
    }
  if (!strcmp("GetScanForRelatedFiles",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetScanForRelatedFiles();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ScanForRelatedFilesOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ScanForRelatedFilesOn();
      return 1;
      }
    }
  if (!strcmp("ScanForRelatedFilesOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ScanForRelatedFilesOff();
      return 1;
      }
    }
  if (!strcmp("SetFileRange",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    int      temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetFileRange(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("SetFileRange",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int    temp0[2];
    if(msg.GetArgument(0, 2, temp0, 2))
      {
      op->SetFileRange(temp0);
      return 1;
      }
    }
  if (!strcmp("GetFileRange",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int     *temp20;
      {
      temp20 = (op)->GetFileRange();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << vtkClientServerStream::InsertArray(temp20,2) << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetFileStride",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetFileStride(temp0);
      return 1;
      }
    }
  if (!strcmp("GetFileStrideMinValue",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetFileStrideMinValue();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFileStrideMaxValue",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetFileStrideMaxValue();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFileStride",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetFileStride();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetCaching",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetCaching(temp0);
      return 1;
      }
    }
  if (!strcmp("GetCaching",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetCaching();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("CachingOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->CachingOn();
      return 1;
      }
    }
  if (!strcmp("CachingOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->CachingOff();
      return 1;
      }
    }
  if (!strcmp("SetMergeExodusEntityBlocks",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetMergeExodusEntityBlocks(temp0);
      return 1;
      }
    }
  if (!strcmp("GetMergeExodusEntityBlocks",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetMergeExodusEntityBlocks();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("MergeExodusEntityBlocksOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->MergeExodusEntityBlocksOn();
      return 1;
      }
    }
  if (!strcmp("MergeExodusEntityBlocksOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->MergeExodusEntityBlocksOff();
      return 1;
      }
    }
  if (!strcmp("SetElementAndSideIds",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetElementAndSideIds(temp0);
      return 1;
      }
    }
  if (!strcmp("GetElementAndSideIds",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetElementAndSideIds();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ElementAndSideIdsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ElementAndSideIdsOn();
      return 1;
      }
    }
  if (!strcmp("ElementAndSideIdsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ElementAndSideIdsOff();
      return 1;
      }
    }
  if (!strcmp("SetGenerateFileId",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetGenerateFileId(temp0);
      return 1;
      }
    }
  if (!strcmp("GetGenerateFileId",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetGenerateFileId();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GenerateFileIdOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->GenerateFileIdOn();
      return 1;
      }
    }
  if (!strcmp("GenerateFileIdOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->GenerateFileIdOff();
      return 1;
      }
    }
  if (!strcmp("SetReadIds",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetReadIds(temp0);
      return 1;
      }
    }
  if (!strcmp("GetReadIds",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetReadIds();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ReadIdsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ReadIdsOn();
      return 1;
      }
    }
  if (!strcmp("ReadIdsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ReadIdsOff();
      return 1;
      }
    }
  if (!strcmp("SetRemoveUnusedPoints",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetRemoveUnusedPoints(temp0);
      return 1;
      }
    }
  if (!strcmp("GetRemoveUnusedPoints",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetRemoveUnusedPoints();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveUnusedPointsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveUnusedPointsOn();
      return 1;
      }
    }
  if (!strcmp("RemoveUnusedPointsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveUnusedPointsOff();
      return 1;
      }
    }
  if (!strcmp("SetApplyDisplacements",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetApplyDisplacements(temp0);
      return 1;
      }
    }
  if (!strcmp("GetApplyDisplacements",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetApplyDisplacements();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ApplyDisplacementsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ApplyDisplacementsOn();
      return 1;
      }
    }
  if (!strcmp("ApplyDisplacementsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ApplyDisplacementsOff();
      return 1;
      }
    }
  if (!strcmp("SetReadGlobalFields",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetReadGlobalFields(temp0);
      return 1;
      }
    }
  if (!strcmp("GetReadGlobalFields",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetReadGlobalFields();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ReadGlobalFieldsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ReadGlobalFieldsOn();
      return 1;
      }
    }
  if (!strcmp("ReadGlobalFieldsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ReadGlobalFieldsOff();
      return 1;
      }
    }
  if (!strcmp("SetReadAllFilesToDetermineStructure",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetReadAllFilesToDetermineStructure(temp0);
      return 1;
      }
    }
  if (!strcmp("GetReadAllFilesToDetermineStructure",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetReadAllFilesToDetermineStructure();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ReadAllFilesToDetermineStructureOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ReadAllFilesToDetermineStructureOn();
      return 1;
      }
    }
  if (!strcmp("ReadAllFilesToDetermineStructureOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ReadAllFilesToDetermineStructureOff();
      return 1;
      }
    }
  if (!strcmp("SetReadQAAndInformationRecords",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetReadQAAndInformationRecords(temp0);
      return 1;
      }
    }
  if (!strcmp("GetReadQAAndInformationRecords",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetReadQAAndInformationRecords();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ReadQAAndInformationRecordsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ReadQAAndInformationRecordsOn();
      return 1;
      }
    }
  if (!strcmp("ReadQAAndInformationRecordsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ReadQAAndInformationRecordsOff();
      return 1;
      }
    }
  if (!strcmp("SetController",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkMultiProcessController  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkMultiProcessController"))
      {
      op->SetController(temp0);
      return 1;
      }
    }
  if (!strcmp("GetController",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkMultiProcessController  *temp20;
      {
      temp20 = (op)->GetController();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AddProperty",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *temp0;
    int      temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->AddProperty(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("AddProperty",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *temp0;
    double   temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->AddProperty(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("AddProperty",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *temp0;
    char    *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->AddProperty(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("RemoveProperty",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->RemoveProperty(temp0);
      return 1;
      }
    }
  if (!strcmp("ClearProperties",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearProperties();
      return 1;
      }
    }
  if (!strcmp("GetEntityTypeIsBlock",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    bool   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkIOSSReader::GetEntityTypeIsBlock(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetEntityTypeIsSet",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    bool   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkIOSSReader::GetEntityTypeIsSet(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetDataAssemblyNodeNameForEntityType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    const char    *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkIOSSReader::GetDataAssemblyNodeNameForEntityType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetMergedEntityNameForEntityType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    const char    *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkIOSSReader::GetMergedEntityNameForEntityType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetEntitySelection",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    vtkDataArraySelection  *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetEntitySelection(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNodeBlockSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetNodeBlockSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetEdgeBlockSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetEdgeBlockSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFaceBlockSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetFaceBlockSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetElementBlockSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetElementBlockSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetStructuredBlockSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetStructuredBlockSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNodeSetSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetNodeSetSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetEdgeSetSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetEdgeSetSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFaceSetSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetFaceSetSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetElementSetSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetElementSetSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetSideSetSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetSideSetSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFieldSelection",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    vtkDataArraySelection  *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetFieldSelection(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNodeBlockFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetNodeBlockFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetEdgeBlockFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetEdgeBlockFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFaceBlockFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetFaceBlockFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetElementBlockFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetElementBlockFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetStructuredBlockFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetStructuredBlockFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNodeSetFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetNodeSetFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetEdgeSetFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetEdgeSetFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFaceSetFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetFaceSetFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetElementSetFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetElementSetFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetSideSetFieldSelection",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataArraySelection  *temp20;
      {
      temp20 = (op)->GetSideSetFieldSelection();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveAllEntitySelections",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveAllEntitySelections();
      return 1;
      }
    }
  if (!strcmp("RemoveAllFieldSelections",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveAllFieldSelections();
      return 1;
      }
    }
  if (!strcmp("RemoveAllSelections",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveAllSelections();
      return 1;
      }
    }
  if (!strcmp("GetEntityIdMapAsString",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    vtkStringArray  *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetEntityIdMapAsString(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNodeBlockIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetNodeBlockIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetEdgeBlockIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetEdgeBlockIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFaceBlockIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetFaceBlockIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetElementBlockIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetElementBlockIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetStructuredBlockIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetStructuredBlockIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNodeSetIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetNodeSetIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetEdgeSetIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetEdgeSetIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetFaceSetIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetFaceSetIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetElementSetIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetElementSetIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetSideSetIdMapAsString",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkStringArray  *temp20;
      {
      temp20 = (op)->GetSideSetIdMapAsString();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetAssembly",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataAssembly  *temp20;
      {
      temp20 = (op)->GetAssembly();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetAssemblyTag",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetAssemblyTag();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AddSelector",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    bool   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->AddSelector(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ClearSelectors",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearSelectors();
      return 1;
      }
    }
  if (!strcmp("SetSelector",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetSelector(temp0);
      return 1;
      }
    }
  if (!strcmp("GetNumberOfSelectors",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetNumberOfSelectors();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetSelector",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    const char    *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetSelector(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ReadMetaData",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkInformation  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkInformation"))
      {
      temp20 = (op)->ReadMetaData(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ReadMesh",method) && msg.GetNumberOfArguments(0) == 7)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    vtkDataObject  *temp4;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 6, &temp4, "vtkDataObject"))
      {
      temp20 = (op)->ReadMesh(temp0,temp1,temp2,temp3,temp4);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ReadPoints",method) && msg.GetNumberOfArguments(0) == 7)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    vtkDataObject  *temp4;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 6, &temp4, "vtkDataObject"))
      {
      temp20 = (op)->ReadPoints(temp0,temp1,temp2,temp3,temp4);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ReadArrays",method) && msg.GetNumberOfArguments(0) == 7)
    {
    int      temp0;
    int      temp1;
    int      temp2;
    int      temp3;
    vtkDataObject  *temp4;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 6, &temp4, "vtkDataObject"))
      {
      temp20 = (op)->ReadArrays(temp0,temp1,temp2,temp3,temp4);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetMTime",method) && msg.GetNumberOfArguments(0) == 2)
    {
    unsigned long     temp20;
      {
      temp20 = (op)->GetMTime();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("DoTestFilePatternMatching",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = vtkIOSSReader::DoTestFilePatternMatching();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ENTITY_ID",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkIOSSReader::ENTITY_ID();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }

  {
    const char* commandName = "vtkReaderAlgorithm";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkIOSSReader, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkIOSSReader_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkIOSSReader", vtkIOSSReaderClientServerNewCommand);
    csi->AddCommandFunction("vtkIOSSReader", vtkIOSSReaderCommand);
    }
}
}
