// python wrapper for vtkSortedTableStreamer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSortedTableStreamer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSortedTableStreamer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSortedTableStreamer_ClassNew(); }


static PyObject *
PyvtkSortedTableStreamer_PrintInfo(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "PrintInfo");

  vtkTable *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTable"))
  {
    vtkSortedTableStreamer::PrintInfo(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_TestInternalClasses(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "TestInternalClasses");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkSortedTableStreamer::TestInternalClasses();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSortedTableStreamer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSortedTableStreamer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSortedTableStreamer *tempr = vtkSortedTableStreamer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSortedTableStreamer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSortedTableStreamer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSortedTableStreamer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSortedTableStreamer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_FillInputPortInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillInputPortInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  int temp0;
  vtkInformation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->FillInputPortInformation(temp0, temp1) :
      op->vtkSortedTableStreamer::FillInputPortInformation(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetBlock(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlock");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetBlock() :
      op->vtkSortedTableStreamer::GetBlock());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_SetBlock(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlock");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlock(temp0);
    }
    else
    {
      op->vtkSortedTableStreamer::SetBlock(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetBlockSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetBlockSize() :
      op->vtkSortedTableStreamer::GetBlockSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_SetBlockSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlockSize(temp0);
    }
    else
    {
      op->vtkSortedTableStreamer::SetBlockSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetSelectedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSelectedComponent() :
      op->vtkSortedTableStreamer::GetSelectedComponent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_SetSelectedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelectedComponent(temp0);
    }
    else
    {
      op->vtkSortedTableStreamer::SetSelectedComponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_SetShowFieldData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowFieldData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowFieldData(temp0);
    }
    else
    {
      op->vtkSortedTableStreamer::SetShowFieldData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetShowFieldData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowFieldData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowFieldData() :
      op->vtkSortedTableStreamer::GetShowFieldData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_ShowFieldDataOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowFieldDataOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowFieldDataOn();
    }
    else
    {
      op->vtkSortedTableStreamer::ShowFieldDataOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_ShowFieldDataOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowFieldDataOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowFieldDataOff();
    }
    else
    {
      op->vtkSortedTableStreamer::ShowFieldDataOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkSortedTableStreamer::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkSortedTableStreamer::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetColumnNameToSort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnNameToSort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetColumnNameToSort() :
      op->vtkSortedTableStreamer::GetColumnNameToSort());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_SetColumnNameToSort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColumnNameToSort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColumnNameToSort(temp0);
    }
    else
    {
      op->vtkSortedTableStreamer::SetColumnNameToSort(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_SetInvertOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInvertOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInvertOrder(temp0);
    }
    else
    {
      op->vtkSortedTableStreamer::SetInvertOrder(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSortedTableStreamer_GetInvertOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInvertOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSortedTableStreamer *op = static_cast<vtkSortedTableStreamer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetInvertOrder() :
      op->vtkSortedTableStreamer::GetInvertOrder());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSortedTableStreamer_Methods[] = {
  {"PrintInfo", PyvtkSortedTableStreamer_PrintInfo, METH_VARARGS,
   "PrintInfo(input:vtkTable) -> None\nC++: static void PrintInfo(vtkTable *input)\n\n"},
  {"TestInternalClasses", PyvtkSortedTableStreamer_TestInternalClasses, METH_VARARGS,
   "TestInternalClasses() -> bool\nC++: static bool TestInternalClasses()\n\nTest the internal structure and make sure that they behave as\nexpected. Return true if everything is OK, false otherwise.\n"},
  {"IsTypeOf", PyvtkSortedTableStreamer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSortedTableStreamer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSortedTableStreamer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSortedTableStreamer\nC++: static vtkSortedTableStreamer *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSortedTableStreamer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSortedTableStreamer\nC++: vtkSortedTableStreamer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSortedTableStreamer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSortedTableStreamer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"FillInputPortInformation", PyvtkSortedTableStreamer_FillInputPortInformation, METH_VARARGS,
   "FillInputPortInformation(self, port:int, info:vtkInformation)\n    -> int\nC++: int FillInputPortInformation(int port, vtkInformation *info)\n    override;\n\nOnly one input which is the table to sort\n"},
  {"GetBlock", PyvtkSortedTableStreamer_GetBlock, METH_VARARGS,
   "GetBlock(self) -> int\nC++: virtual vtkIdType GetBlock()\n\nBlock index used to select a data range\n"},
  {"SetBlock", PyvtkSortedTableStreamer_SetBlock, METH_VARARGS,
   "SetBlock(self, _arg:int) -> None\nC++: virtual void SetBlock(vtkIdType _arg)\n\n"},
  {"GetBlockSize", PyvtkSortedTableStreamer_GetBlockSize, METH_VARARGS,
   "GetBlockSize(self) -> int\nC++: virtual vtkIdType GetBlockSize()\n\nSet the block size. Default value is 1024\n"},
  {"SetBlockSize", PyvtkSortedTableStreamer_SetBlockSize, METH_VARARGS,
   "SetBlockSize(self, _arg:int) -> None\nC++: virtual void SetBlockSize(vtkIdType _arg)\n\n"},
  {"GetSelectedComponent", PyvtkSortedTableStreamer_GetSelectedComponent, METH_VARARGS,
   "GetSelectedComponent(self) -> int\nC++: virtual int GetSelectedComponent()\n\nChoose on which column the sort operation should occur\n"},
  {"SetSelectedComponent", PyvtkSortedTableStreamer_SetSelectedComponent, METH_VARARGS,
   "SetSelectedComponent(self, _arg:int) -> None\nC++: virtual void SetSelectedComponent(int _arg)\n\n"},
  {"SetShowFieldData", PyvtkSortedTableStreamer_SetShowFieldData, METH_VARARGS,
   "SetShowFieldData(self, _arg:bool) -> None\nC++: virtual void SetShowFieldData(bool _arg)\n\nAllow user to enable/disable field data visibility. Default to\nfalse.\n"},
  {"GetShowFieldData", PyvtkSortedTableStreamer_GetShowFieldData, METH_VARARGS,
   "GetShowFieldData(self) -> bool\nC++: virtual bool GetShowFieldData()\n\n"},
  {"ShowFieldDataOn", PyvtkSortedTableStreamer_ShowFieldDataOn, METH_VARARGS,
   "ShowFieldDataOn(self) -> None\nC++: virtual void ShowFieldDataOn()\n\n"},
  {"ShowFieldDataOff", PyvtkSortedTableStreamer_ShowFieldDataOff, METH_VARARGS,
   "ShowFieldDataOff(self) -> None\nC++: virtual void ShowFieldDataOff()\n\n"},
  {"SetController", PyvtkSortedTableStreamer_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *)\n\nGet/Set the MPI controller used for gathering.\n"},
  {"GetController", PyvtkSortedTableStreamer_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"GetColumnNameToSort", PyvtkSortedTableStreamer_GetColumnNameToSort, METH_VARARGS,
   "GetColumnNameToSort(self) -> str\nC++: const char *GetColumnNameToSort()\n\nChoose on which column the sort operation should occur\n"},
  {"SetColumnNameToSort", PyvtkSortedTableStreamer_SetColumnNameToSort, METH_VARARGS,
   "SetColumnNameToSort(self, columnName:str) -> None\nC++: void SetColumnNameToSort(const char *columnName)\n\n"},
  {"SetInvertOrder", PyvtkSortedTableStreamer_SetInvertOrder, METH_VARARGS,
   "SetInvertOrder(self, newValue:int) -> None\nC++: void SetInvertOrder(int newValue)\n\n"},
  {"GetInvertOrder", PyvtkSortedTableStreamer_GetInvertOrder, METH_VARARGS,
   "GetInvertOrder(self) -> int\nC++: virtual int GetInvertOrder()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSortedTableStreamer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("block"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSortedTableStreamer_GetBlock(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSortedTableStreamer_SetBlock(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSortedTableStreamer_SetBlock(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBlock/SetBlock\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("block_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSortedTableStreamer_GetBlockSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSortedTableStreamer_SetBlockSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSortedTableStreamer_SetBlockSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBlockSize/SetBlockSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("selected_component"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSortedTableStreamer_GetSelectedComponent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSortedTableStreamer_SetSelectedComponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSortedTableStreamer_SetSelectedComponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelectedComponent/SetSelectedComponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_field_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSortedTableStreamer_GetShowFieldData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSortedTableStreamer_SetShowFieldData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSortedTableStreamer_SetShowFieldData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShowFieldData/SetShowFieldData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSortedTableStreamer_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSortedTableStreamer_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSortedTableStreamer_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("column_name_to_sort"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSortedTableStreamer_GetColumnNameToSort(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSortedTableStreamer_SetColumnNameToSort(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSortedTableStreamer_SetColumnNameToSort(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetColumnNameToSort/SetColumnNameToSort\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("invert_order"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSortedTableStreamer_GetInvertOrder(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSortedTableStreamer_SetInvertOrder(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSortedTableStreamer_SetInvertOrder(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInvertOrder/SetInvertOrder\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSortedTableStreamer_Doc =
  "vtkSortedTableStreamer - return a sorted subset of the original table\n\n"
  "Superclass: vtkTableAlgorithm\n\n"
  "This filter is used quickly get a sorted subset of a given vtkTable.\n"
  "By sorted we mean a subset build from a global sort even if some\n"
  "optimisation allow us to skip a global table sorting.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSortedTableStreamer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersRendering.vtkSortedTableStreamer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSortedTableStreamer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSortedTableStreamer_StaticNew()
{
  return vtkSortedTableStreamer::New();
}

PyObject *PyvtkSortedTableStreamer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSortedTableStreamer_Type, PyvtkSortedTableStreamer_Methods,
    "vtkSortedTableStreamer",
 &PyvtkSortedTableStreamer_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTableAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSortedTableStreamer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSortedTableStreamer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSortedTableStreamer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSortedTableStreamer", o) != 0)
  {
    Py_DECREF(o);
  }

}

