// python wrapper for vtkSMDataAssemblyDomain
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMDataAssemblyDomain.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMDataAssemblyDomain(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMDataAssemblyDomain_ClassNew(); }

#ifndef DECLARED_PyvtkSMDomain_ClassNew
extern "C" { PyObject *PyvtkSMDomain_ClassNew(); }
#define DECLARED_PyvtkSMDomain_ClassNew
#endif

static PyObject *
PyvtkSMDataAssemblyDomain_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMDataAssemblyDomain::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataAssemblyDomain *op = static_cast<vtkSMDataAssemblyDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMDataAssemblyDomain::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMDataAssemblyDomain *tempr = vtkSMDataAssemblyDomain::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataAssemblyDomain *op = static_cast<vtkSMDataAssemblyDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMDataAssemblyDomain *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMDataAssemblyDomain::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMDataAssemblyDomain::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataAssemblyDomain *op = static_cast<vtkSMDataAssemblyDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMDataAssemblyDomain::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_GetDataAssemblyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataAssemblyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataAssemblyDomain *op = static_cast<vtkSMDataAssemblyDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDataAssemblyName() :
      op->vtkSMDataAssemblyDomain::GetDataAssemblyName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_GetDataAssembly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataAssembly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataAssemblyDomain *op = static_cast<vtkSMDataAssemblyDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataAssembly *tempr = (ap.IsBound() ?
      op->GetDataAssembly() :
      op->vtkSMDataAssemblyDomain::GetDataAssembly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataAssemblyDomain *op = static_cast<vtkSMDataAssemblyDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    if (ap.IsBound())
    {
      op->Update(temp0);
    }
    else
    {
      op->vtkSMDataAssemblyDomain::Update(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataAssemblyDomain_SetDefaultValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDefaultValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataAssemblyDomain *op = static_cast<vtkSMDataAssemblyDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProperty") &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->SetDefaultValues(temp0, temp1) :
      op->vtkSMDataAssemblyDomain::SetDefaultValues(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMDataAssemblyDomain_Methods[] = {
  {"IsTypeOf", PyvtkSMDataAssemblyDomain_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMDataAssemblyDomain_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMDataAssemblyDomain_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMDataAssemblyDomain\nC++: static vtkSMDataAssemblyDomain *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMDataAssemblyDomain_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMDataAssemblyDomain\nC++: vtkSMDataAssemblyDomain *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMDataAssemblyDomain_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMDataAssemblyDomain_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetDataAssemblyName", PyvtkSMDataAssemblyDomain_GetDataAssemblyName, METH_VARARGS,
   "GetDataAssemblyName(self) -> str\nC++: const char *GetDataAssemblyName()\n\nReturns the name for the chosen assembly, if any.\n"},
  {"GetDataAssembly", PyvtkSMDataAssemblyDomain_GetDataAssembly, METH_VARARGS,
   "GetDataAssembly(self) -> vtkDataAssembly\nC++: vtkDataAssembly *GetDataAssembly()\n\nProvides access to the data assembly.\n"},
  {"Update", PyvtkSMDataAssemblyDomain_Update, METH_VARARGS,
   "Update(self, requestingProperty:vtkSMProperty) -> None\nC++: void Update(vtkSMProperty *requestingProperty) override;\n\nUpdate self based on the \"unchecked\" values of all required\nproperties. Subclasses must override this method to update the\ndomain based on the requestingProperty (and/or other required\nproperties).\n"},
  {"SetDefaultValues", PyvtkSMDataAssemblyDomain_SetDefaultValues, METH_VARARGS,
   "SetDefaultValues(self, prop:vtkSMProperty,\n    use_unchecked_values:bool) -> int\nC++: int SetDefaultValues(vtkSMProperty *prop,\n    bool use_unchecked_values) override;\n\nA vtkSMProperty is often defined with a default value in the XML\nitself. However, many times, the default value must be determined\nat run time. To facilitate this, domains can override this method\nto compute and set the default value for the property. Note that\nunlike the compile-time default values, the application must\nexplicitly call this method to initialize the property. If\nuse_unchecked_values is true, the property's unchecked values\nwill be changed by this method. Returns 1 if the domain updated\nthe property. Default implementation does nothing.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMDataAssemblyDomain_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("data_assembly_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMDataAssemblyDomain_GetDataAssemblyName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataAssemblyName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_assembly"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMDataAssemblyDomain_GetDataAssembly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataAssembly\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMDataAssemblyDomain_Doc =
  "vtkSMDataAssemblyDomain - a domain that uses vtkDataAssembly\n\n"
  "Superclass: vtkSMDomain\n\n"
  "vtkSMDataAssemblyDomain is intended for vtkSMStringVectorProperty\n"
  "that uses vtkDataAssembly to qualify values. For example, the \"Paths\"\n"
  "property on `vtkExtractBlockUsingDataAssembly` filter that lets the\n"
  "user select paths to extract uses this domain.\n\n"
  "Example usage in a ServerManager XML is as follows:\n\n"
  "{xml}\n"
  "<SourceProxy ...>\n"
  "...\n"
  "  <StringVectorProperty clean_command=\"ClearNodePaths\"\n"
  "                     command=\"AddNodePath\"\n"
  "                     name=\"Paths\"\n"
  "                     number_of_elements_per_command=\"1\"\n"
  "                     panel_visibility=\"default\"\n"
  "                     repeat_command=\"1\"\n"
  "                     animateable=\"0\">\n"
  "    <DataAssemblyDomain name=\"data_assembly\" (optional)entity_type=3>\n"
  "      \n"
  "        <Property function=\"Input\" name=\"Input\" />\n"
  "      \n"
  "    \n"
  "    \n"
  "      This property lists the paths for blocks to extract.\n"
  "    \n"
  "  \n\n"
  "vtkSMDataAssemblyDomain can also be used on readers. In that case, it\n"
  "uses vtkPVDataAssemblyInformation to obtain the data assembly from\n"
  "the reader. The following snippet shows how this domain can be used\n"
  "on a reader. Note, the 'Tag' required property is essential to use\n"
  "this domain on a reader. It is used to determine when to fetch the\n"
  "vtkDataAssembly from the reader.\n\n"
  "{xml}\n\n"
  "<SourceProxy ...> ...\n"
  "  <IntVectorProperty name=\"AssemblyTag\"\n"
  "    command=\"GetAssemblyTag\"\n"
  "    information_only=\"1\">\n"
  "    \n"
  "      This is simply an int that changes whenever a new assembly is\n"
  "built\n"
  "      by the reader. This can be used to determine if the assembly\n"
  "should be fetched from\n"
  "      the reader whenever the reader is updated.\n"
  "    \n"
  "  \n\n\n"
  "  <StringVectorProperty name=\"AssemmblySelectors\"\n"
  "    command=\"AddSelector\"\n"
  "    clean_command=\"ClearSelectors\"\n"
  "    repeat_command=\"1\"\n"
  "    number_of_elements_per_command=\"1\"\n"
  "    panel_widget=\"data_assembly_editor\" >\n"
  "    <DataAssemblyDomain name=\"data_assembly\">\n"
  "      \n"
  "        <Property function=\"Tag\" name=\"AssemblyTag\" />\n"
  "      \n"
  "    \n"
  "    \n"
  "      Specify the selectors for the data assembly chosen using\n"
  "**Assembly**\n"
  "      to choose the blocks to extract from the input dataset.\n"
  "    \n"
  "    \n"
  "      <!-- AssemblyTag == 0 implies there's no assembly in the file,\n"
  "      in which case, we want to hide this widget entirely -->\n"
  "      <PropertyWidgetDecorator type=\"GenericDecorator\"\n"
  "        mode=\"visibility\"\n"
  "        property=\"AssemblyTag\"\n"
  "        value=\"0\"\n"
  "        inverse=\"1\" />\n"
  "    \n"
  "  \n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMDataAssemblyDomain_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMDataAssemblyDomain", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMDataAssemblyDomain_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMDataAssemblyDomain_StaticNew()
{
  return vtkSMDataAssemblyDomain::New();
}

PyObject *PyvtkSMDataAssemblyDomain_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMDataAssemblyDomain_Type, PyvtkSMDataAssemblyDomain_Methods,
    "vtkSMDataAssemblyDomain",
 &PyvtkSMDataAssemblyDomain_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMDomain_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMDataAssemblyDomain_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMDataAssemblyDomain(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMDataAssemblyDomain_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMDataAssemblyDomain", o) != 0)
  {
    Py_DECREF(o);
  }

}

