// python wrapper for vtkSMAnimationScene
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMAnimationScene.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMAnimationScene(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMAnimationScene_ClassNew(); }


static PyObject *
PyvtkSMAnimationScene_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMAnimationScene::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMAnimationScene::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMAnimationScene *tempr = vtkSMAnimationScene::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMAnimationScene *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMAnimationScene::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMAnimationScene::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMAnimationScene::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_AddCue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddCue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  vtkAnimationCue *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAnimationCue"))
  {
    if (ap.IsBound())
    {
      op->AddCue(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::AddCue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_RemoveCue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveCue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  vtkAnimationCue *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAnimationCue"))
  {
    if (ap.IsBound())
    {
      op->RemoveCue(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::RemoveCue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_RemoveAllCues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllCues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllCues();
    }
    else
    {
      op->vtkSMAnimationScene::RemoveAllCues();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetNumberOfCues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfCues() :
      op->vtkSMAnimationScene::GetNumberOfCues());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_AddViewProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddViewProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy"))
  {
    if (ap.IsBound())
    {
      op->AddViewProxy(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::AddViewProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_RemoveViewProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveViewProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy"))
  {
    if (ap.IsBound())
    {
      op->RemoveViewProxy(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::RemoveViewProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_RemoveAllViewProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllViewProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllViewProxies();
    }
    else
    {
      op->vtkSMAnimationScene::RemoveAllViewProxies();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetNumberOfViewProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfViewProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfViewProxies() :
      op->vtkSMAnimationScene::GetNumberOfViewProxies());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetViewProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetViewProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMViewProxy *tempr = (ap.IsBound() ?
      op->GetViewProxy(temp0) :
      op->vtkSMAnimationScene::GetViewProxy(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetTimeKeeper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeKeeper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetTimeKeeper(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetTimeKeeper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetTimeKeeper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeKeeper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetTimeKeeper() :
      op->vtkSMAnimationScene::GetTimeKeeper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetLockStartTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLockStartTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLockStartTime(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetLockStartTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetLockStartTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLockStartTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLockStartTime() :
      op->vtkSMAnimationScene::GetLockStartTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_LockStartTimeOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LockStartTimeOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LockStartTimeOn();
    }
    else
    {
      op->vtkSMAnimationScene::LockStartTimeOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_LockStartTimeOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LockStartTimeOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LockStartTimeOff();
    }
    else
    {
      op->vtkSMAnimationScene::LockStartTimeOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetLockEndTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLockEndTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLockEndTime(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetLockEndTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetLockEndTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLockEndTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLockEndTime() :
      op->vtkSMAnimationScene::GetLockEndTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_LockEndTimeOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LockEndTimeOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LockEndTimeOn();
    }
    else
    {
      op->vtkSMAnimationScene::LockEndTimeOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_LockEndTimeOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LockEndTimeOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LockEndTimeOff();
    }
    else
    {
      op->vtkSMAnimationScene::LockEndTimeOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetSceneTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSceneTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSceneTime(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetSceneTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetSceneTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSceneTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetSceneTime() :
      op->vtkSMAnimationScene::GetSceneTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetPlaybackTimeWindow_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPlaybackTimeWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPlaybackTimeWindow(temp0, temp1);
    }
    else
    {
      op->vtkSMAnimationScene::SetPlaybackTimeWindow(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMAnimationScene_SetPlaybackTimeWindow_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPlaybackTimeWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetPlaybackTimeWindow(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetPlaybackTimeWindow(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMAnimationScene_SetPlaybackTimeWindow(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMAnimationScene_SetPlaybackTimeWindow_s1(self, args);
    case 1:
      return PyvtkSMAnimationScene_SetPlaybackTimeWindow_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetPlaybackTimeWindow");
  return nullptr;
}


static PyObject *
PyvtkSMAnimationScene_GetPlaybackTimeWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPlaybackTimeWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetPlaybackTimeWindow() :
      op->vtkSMAnimationScene::GetPlaybackTimeWindow());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetLoop(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLoop");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLoop(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetLoop(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetLoop(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLoop");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLoop() :
      op->vtkSMAnimationScene::GetLoop());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_Play(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Play");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Play();
    }
    else
    {
      op->vtkSMAnimationScene::Play();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_Reverse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Reverse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Reverse();
    }
    else
    {
      op->vtkSMAnimationScene::Reverse();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_Stop(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Stop");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Stop();
    }
    else
    {
      op->vtkSMAnimationScene::Stop();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GoToNext(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GoToNext");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GoToNext();
    }
    else
    {
      op->vtkSMAnimationScene::GoToNext();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GoToPrevious(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GoToPrevious");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GoToPrevious();
    }
    else
    {
      op->vtkSMAnimationScene::GoToPrevious();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GoToFirst(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GoToFirst");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GoToFirst();
    }
    else
    {
      op->vtkSMAnimationScene::GoToFirst();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GoToLast(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GoToLast");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GoToLast();
    }
    else
    {
      op->vtkSMAnimationScene::GoToLast();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetPlayMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPlayMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPlayMode(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetPlayMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetPlayMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPlayMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPlayMode() :
      op->vtkSMAnimationScene::GetPlayMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetNumberOfFrames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfFrames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfFrames(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetNumberOfFrames(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetDuration(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method SetDuration."
    " (" "Use `SetStride` instead`" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(self, args, "SetDuration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDuration(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetDuration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetFramesPerTimestep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFramesPerTimestep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFramesPerTimestep(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetFramesPerTimestep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetStride(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStride");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStride(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetStride(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetInPlay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInPlay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetInPlay() :
      op->vtkSMAnimationScene::GetInPlay());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetForceDisableCaching(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceDisableCaching");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceDisableCaching(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetForceDisableCaching(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetForceDisableCaching(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceDisableCaching");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceDisableCaching() :
      op->vtkSMAnimationScene::GetForceDisableCaching());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetOverrideStillRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOverrideStillRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOverrideStillRender(temp0);
    }
    else
    {
      op->vtkSMAnimationScene::SetOverrideStillRender(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetOverrideStillRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOverrideStillRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMAnimationScene *op = static_cast<vtkSMAnimationScene *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOverrideStillRender() :
      op->vtkSMAnimationScene::GetOverrideStillRender());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_SetGlobalUseGeometryCache(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod SetGlobalUseGeometryCache."
    " (" "Use vtkPVGeneralSettings::SetCacheGeometryForAnimation" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(args, "SetGlobalUseGeometryCache");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMAnimationScene::SetGlobalUseGeometryCache(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMAnimationScene_GetGlobalUseGeometryCache(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod GetGlobalUseGeometryCache."
    " (" "Use vtkPVGeneralSettings::GetCacheGeometryForAnimation" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(args, "GetGlobalUseGeometryCache");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkSMAnimationScene::GetGlobalUseGeometryCache();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMAnimationScene_Methods[] = {
  {"IsTypeOf", PyvtkSMAnimationScene_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMAnimationScene_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMAnimationScene_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMAnimationScene\nC++: static vtkSMAnimationScene *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMAnimationScene_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMAnimationScene\nC++: vtkSMAnimationScene *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMAnimationScene_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMAnimationScene_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"AddCue", PyvtkSMAnimationScene_AddCue, METH_VARARGS,
   "AddCue(self, cue:vtkAnimationCue) -> None\nC++: void AddCue(vtkAnimationCue *cue)\n\nAdd/Remove an AnimationCue to/from the Scene. It's an error to\nadd a cue twice to the Scene.\n"},
  {"RemoveCue", PyvtkSMAnimationScene_RemoveCue, METH_VARARGS,
   "RemoveCue(self, cue:vtkAnimationCue) -> None\nC++: void RemoveCue(vtkAnimationCue *cue)\n\n"},
  {"RemoveAllCues", PyvtkSMAnimationScene_RemoveAllCues, METH_VARARGS,
   "RemoveAllCues(self) -> None\nC++: void RemoveAllCues()\n\n"},
  {"GetNumberOfCues", PyvtkSMAnimationScene_GetNumberOfCues, METH_VARARGS,
   "GetNumberOfCues(self) -> int\nC++: int GetNumberOfCues()\n\n"},
  {"AddViewProxy", PyvtkSMAnimationScene_AddViewProxy, METH_VARARGS,
   "AddViewProxy(self, proxy:vtkSMViewProxy) -> None\nC++: void AddViewProxy(vtkSMViewProxy *proxy)\n\nAdd view proxies that are involved in the animation generated by\nthis scene. When playing the animation, the scene will call\nStillRender() on the view proxies it is aware of, also updating\nany caching parameters.\n"},
  {"RemoveViewProxy", PyvtkSMAnimationScene_RemoveViewProxy, METH_VARARGS,
   "RemoveViewProxy(self, proxy:vtkSMViewProxy) -> None\nC++: void RemoveViewProxy(vtkSMViewProxy *proxy)\n\n"},
  {"RemoveAllViewProxies", PyvtkSMAnimationScene_RemoveAllViewProxies, METH_VARARGS,
   "RemoveAllViewProxies(self) -> None\nC++: void RemoveAllViewProxies()\n\n"},
  {"GetNumberOfViewProxies", PyvtkSMAnimationScene_GetNumberOfViewProxies, METH_VARARGS,
   "GetNumberOfViewProxies(self) -> int\nC++: unsigned int GetNumberOfViewProxies()\n\nAccess the view proxies.\n"},
  {"GetViewProxy", PyvtkSMAnimationScene_GetViewProxy, METH_VARARGS,
   "GetViewProxy(self, cc:int) -> vtkSMViewProxy\nC++: vtkSMViewProxy *GetViewProxy(unsigned int cc)\n\n"},
  {"SetTimeKeeper", PyvtkSMAnimationScene_SetTimeKeeper, METH_VARARGS,
   "SetTimeKeeper(self, __a:vtkSMProxy) -> None\nC++: void SetTimeKeeper(vtkSMProxy *)\n\nSet the time keeper. Time keeper is used to obtain the\ninformation about timesteps. This is required to play animation\nin \"Snap To Timesteps\" mode.\n"},
  {"GetTimeKeeper", PyvtkSMAnimationScene_GetTimeKeeper, METH_VARARGS,
   "GetTimeKeeper(self) -> vtkSMProxy\nC++: virtual vtkSMProxy *GetTimeKeeper()\n\n"},
  {"SetLockStartTime", PyvtkSMAnimationScene_SetLockStartTime, METH_VARARGS,
   "SetLockStartTime(self, _arg:bool) -> None\nC++: virtual void SetLockStartTime(bool _arg)\n\nLock the start time. When locked, the StartTime won't be\nautomatically updated when data time changes.\n"},
  {"GetLockStartTime", PyvtkSMAnimationScene_GetLockStartTime, METH_VARARGS,
   "GetLockStartTime(self) -> bool\nC++: virtual bool GetLockStartTime()\n\n"},
  {"LockStartTimeOn", PyvtkSMAnimationScene_LockStartTimeOn, METH_VARARGS,
   "LockStartTimeOn(self) -> None\nC++: virtual void LockStartTimeOn()\n\n"},
  {"LockStartTimeOff", PyvtkSMAnimationScene_LockStartTimeOff, METH_VARARGS,
   "LockStartTimeOff(self) -> None\nC++: virtual void LockStartTimeOff()\n\n"},
  {"SetLockEndTime", PyvtkSMAnimationScene_SetLockEndTime, METH_VARARGS,
   "SetLockEndTime(self, _arg:bool) -> None\nC++: virtual void SetLockEndTime(bool _arg)\n\nLock the end time. When locked, the EndTime won't be\nautomatically updated when the data time changes.\n"},
  {"GetLockEndTime", PyvtkSMAnimationScene_GetLockEndTime, METH_VARARGS,
   "GetLockEndTime(self) -> bool\nC++: virtual bool GetLockEndTime()\n\n"},
  {"LockEndTimeOn", PyvtkSMAnimationScene_LockEndTimeOn, METH_VARARGS,
   "LockEndTimeOn(self) -> None\nC++: virtual void LockEndTimeOn()\n\n"},
  {"LockEndTimeOff", PyvtkSMAnimationScene_LockEndTimeOff, METH_VARARGS,
   "LockEndTimeOff(self) -> None\nC++: virtual void LockEndTimeOff()\n\n"},
  {"SetSceneTime", PyvtkSMAnimationScene_SetSceneTime, METH_VARARGS,
   "SetSceneTime(self, time:float) -> None\nC++: void SetSceneTime(double time)\n\nSets the current animation time.\n"},
  {"GetSceneTime", PyvtkSMAnimationScene_GetSceneTime, METH_VARARGS,
   "GetSceneTime(self) -> float\nC++: virtual double GetSceneTime()\n\n"},
  {"SetPlaybackTimeWindow", PyvtkSMAnimationScene_SetPlaybackTimeWindow, METH_VARARGS,
   "SetPlaybackTimeWindow(self, _arg1:float, _arg2:float) -> None\nC++: virtual void SetPlaybackTimeWindow(double _arg1,\n    double _arg2)\nSetPlaybackTimeWindow(self, _arg:(float, float)) -> None\nC++: void SetPlaybackTimeWindow(const double _arg[2])\n\nGet/Set the Playback Window for this cue. The Playback Window is\nuse to mask out time that belong to a given cue but that we don't\nwant to play back. This is particularly useful when we want to\nexport a subset of an animation without recomputing any start and\nend value relative to the cue and the number of frame associated\nto it. This is used by the Animation Player to only play a subset\nof the cue. To disable it just make the lower bound bigger than\nthe upper one.\n"},
  {"GetPlaybackTimeWindow", PyvtkSMAnimationScene_GetPlaybackTimeWindow, METH_VARARGS,
   "GetPlaybackTimeWindow(self) -> (float, float)\nC++: virtual double *GetPlaybackTimeWindow()\n\n"},
  {"SetLoop", PyvtkSMAnimationScene_SetLoop, METH_VARARGS,
   "SetLoop(self, val:int) -> None\nC++: void SetLoop(int val)\n\nForwarded to vtkCompositeAnimationPlayer.\n"},
  {"GetLoop", PyvtkSMAnimationScene_GetLoop, METH_VARARGS,
   "GetLoop(self) -> int\nC++: int GetLoop()\n\n"},
  {"Play", PyvtkSMAnimationScene_Play, METH_VARARGS,
   "Play(self) -> None\nC++: void Play()\n\n"},
  {"Reverse", PyvtkSMAnimationScene_Reverse, METH_VARARGS,
   "Reverse(self) -> None\nC++: void Reverse()\n\n"},
  {"Stop", PyvtkSMAnimationScene_Stop, METH_VARARGS,
   "Stop(self) -> None\nC++: void Stop()\n\n"},
  {"GoToNext", PyvtkSMAnimationScene_GoToNext, METH_VARARGS,
   "GoToNext(self) -> None\nC++: void GoToNext()\n\n"},
  {"GoToPrevious", PyvtkSMAnimationScene_GoToPrevious, METH_VARARGS,
   "GoToPrevious(self) -> None\nC++: void GoToPrevious()\n\n"},
  {"GoToFirst", PyvtkSMAnimationScene_GoToFirst, METH_VARARGS,
   "GoToFirst(self) -> None\nC++: void GoToFirst()\n\n"},
  {"GoToLast", PyvtkSMAnimationScene_GoToLast, METH_VARARGS,
   "GoToLast(self) -> None\nC++: void GoToLast()\n\n"},
  {"SetPlayMode", PyvtkSMAnimationScene_SetPlayMode, METH_VARARGS,
   "SetPlayMode(self, val:int) -> None\nC++: void SetPlayMode(int val)\n\n"},
  {"GetPlayMode", PyvtkSMAnimationScene_GetPlayMode, METH_VARARGS,
   "GetPlayMode(self) -> int\nC++: int GetPlayMode()\n\n"},
  {"SetNumberOfFrames", PyvtkSMAnimationScene_SetNumberOfFrames, METH_VARARGS,
   "SetNumberOfFrames(self, val:int) -> None\nC++: void SetNumberOfFrames(int val)\n\n"},
  {"SetDuration", PyvtkSMAnimationScene_SetDuration, METH_VARARGS,
   "SetDuration(self, val:int) -> None\nC++: void SetDuration(int val)\n\n"},
  {"SetFramesPerTimestep", PyvtkSMAnimationScene_SetFramesPerTimestep, METH_VARARGS,
   "SetFramesPerTimestep(self, val:int) -> None\nC++: void SetFramesPerTimestep(int val)\n\n"},
  {"SetStride", PyvtkSMAnimationScene_SetStride, METH_VARARGS,
   "SetStride(self, val:int) -> None\nC++: void SetStride(int val)\n\n"},
  {"GetInPlay", PyvtkSMAnimationScene_GetInPlay, METH_VARARGS,
   "GetInPlay(self) -> bool\nC++: bool GetInPlay()\n\n"},
  {"SetForceDisableCaching", PyvtkSMAnimationScene_SetForceDisableCaching, METH_VARARGS,
   "SetForceDisableCaching(self, _arg:bool) -> None\nC++: virtual void SetForceDisableCaching(bool _arg)\n\nSet to true to force caching to be disabled. When false\n(default), caching is determined based on the value from\nvtkPVGeneralSettings::GetInstance()->GetCacheGeometryForAnimation(\n).\n"},
  {"GetForceDisableCaching", PyvtkSMAnimationScene_GetForceDisableCaching, METH_VARARGS,
   "GetForceDisableCaching(self) -> bool\nC++: virtual bool GetForceDisableCaching()\n\n"},
  {"SetOverrideStillRender", PyvtkSMAnimationScene_SetOverrideStillRender, METH_VARARGS,
   "SetOverrideStillRender(self, _arg:bool) -> None\nC++: virtual void SetOverrideStillRender(bool _arg)\n\nWhen set, we skip calling still render to render each frame.\nUseful to avoid updating screen when saving animations to disk,\nfor example.\n"},
  {"GetOverrideStillRender", PyvtkSMAnimationScene_GetOverrideStillRender, METH_VARARGS,
   "GetOverrideStillRender(self) -> bool\nC++: virtual bool GetOverrideStillRender()\n\n"},
  {"SetGlobalUseGeometryCache", PyvtkSMAnimationScene_SetGlobalUseGeometryCache, METH_VARARGS,
   "SetGlobalUseGeometryCache(__a:bool) -> None\nC++: static void SetGlobalUseGeometryCache(bool)\n\nTurn caching on/off globally. Typically, on uses\nvtkPVGeneralSettings to toggle cache settings rather than using\nthis API directly.\n"},
  {"GetGlobalUseGeometryCache", PyvtkSMAnimationScene_GetGlobalUseGeometryCache, METH_VARARGS,
   "GetGlobalUseGeometryCache() -> bool\nC++: static bool GetGlobalUseGeometryCache()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMAnimationScene_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("time_keeper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetTimeKeeper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetTimeKeeper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetTimeKeeper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeKeeper/SetTimeKeeper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lock_start_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetLockStartTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetLockStartTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetLockStartTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLockStartTime/SetLockStartTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lock_end_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetLockEndTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetLockEndTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetLockEndTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLockEndTime/SetLockEndTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scene_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetSceneTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetSceneTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetSceneTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSceneTime/SetSceneTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("playback_time_window"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetPlaybackTimeWindow(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetPlaybackTimeWindow(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetPlaybackTimeWindow(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPlaybackTimeWindow/SetPlaybackTimeWindow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("loop"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetLoop(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetLoop(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetLoop(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLoop/SetLoop\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("play_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetPlayMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetPlayMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetPlayMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPlayMode/SetPlayMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("duration"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetDuration(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetDuration(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDuration\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("frames_per_timestep"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetFramesPerTimestep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetFramesPerTimestep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFramesPerTimestep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stride"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetStride(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetStride(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetStride\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_disable_caching"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetForceDisableCaching(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetForceDisableCaching(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetForceDisableCaching(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceDisableCaching/SetForceDisableCaching\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("override_still_render"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetOverrideStillRender(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetOverrideStillRender(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetOverrideStillRender(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOverrideStillRender/SetOverrideStillRender\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_use_geometry_cache"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetGlobalUseGeometryCache(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetGlobalUseGeometryCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetGlobalUseGeometryCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGlobalUseGeometryCache/SetGlobalUseGeometryCache\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("in_play"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetInPlay(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInPlay\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_frames"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMAnimationScene_SetNumberOfFrames(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMAnimationScene_SetNumberOfFrames(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfFrames\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_cues"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetNumberOfCues(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCues\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_view_proxies"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMAnimationScene_GetNumberOfViewProxies(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfViewProxies\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMAnimationScene_Doc =
  "vtkSMAnimationScene - animation scene for ParaView.\n\n"
  "Superclass: vtkAnimationCue\n\n"
  "vtkSMAnimationScene extends vtkAnimationCue to add support for a\n"
  "scene in ParaView.\n\n"
  "We don't use vtkAnimationScene since ParaView has more elaborate\n"
  "playback requirements. To support that, this class delegates playback\n"
  "responsibility to vtkAnimationPlayer and subclasses.\n\n"
  "vtkSMAnimationScene also is proxy-aware and hence can work with\n"
  "proxies and views proxies for updating property values, rendering,\n"
  "etc.\n\n"
  "vtkSMAnimationScene forwards the vtkCommand::StartEvent and\n"
  "vtkCommand::EndEvent from vtkCompositeAnimationPlayer to mark the\n"
  "start and end of animation playback.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMAnimationScene_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingAnimation.vtkSMAnimationScene", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMAnimationScene_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMAnimationScene_StaticNew()
{
  return vtkSMAnimationScene::New();
}

PyObject *PyvtkSMAnimationScene_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMAnimationScene_Type, PyvtkSMAnimationScene_Methods,
    "vtkSMAnimationScene",
 &PyvtkSMAnimationScene_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkAnimationCue");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkSMAnimationScene::UpdateStartEndTimesEvent);
  if (o)
  {
    PyDict_SetItemString(d, "UpdateStartEndTimesEvent", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMAnimationScene_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMAnimationScene(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMAnimationScene_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMAnimationScene", o) != 0)
  {
    Py_DECREF(o);
  }

}

