// ClientServer wrapper for vtkChartXY object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkChartXY.h"
#include "vtkSystemIncludes.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkChartXYClientServerNewCommand(void* /*ctx*/)
{
  return vtkChartXY::New();
}


static int vtkChartXYCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkChartXY *op = vtkChartXY::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkChartXY.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkChartXY::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkChartXY  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkChartXY::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkChartXY  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkChartXY::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkChartXY  *temp20;
      {
      temp20 = vtkChartXY::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("Update",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->Update();
      return 1;
      }
    }
  if (!strcmp("Paint",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkContext2D  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkContext2D"))
      {
      temp20 = (op)->Paint(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AddPlot",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    vtkPlot  *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->AddPlot(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AddPlot",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    unsigned int      temp1;
    vtkPlot  *temp20;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      temp20 = (op)->AddPlot(temp0,temp1);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AddPlot",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkPlot  *temp0;
    long long   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot"))
      {
      temp20 = (op)->AddPlot(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AddPlot",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkPlot  *temp0;
    unsigned int      temp1;
    long long   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot") &&
      msg.GetArgument(0, 3, &temp1))
      {
      temp20 = (op)->AddPlot(temp0,temp1);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemovePlot",method) && msg.GetNumberOfArguments(0) == 3)
    {
    long long   temp0;
    bool   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->RemovePlot(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ClearPlots",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearPlots();
      return 1;
      }
    }
  if (!strcmp("GetPlot",method) && msg.GetNumberOfArguments(0) == 3)
    {
    long long   temp0;
    vtkPlot  *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetPlot(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetPlotIndex",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkPlot  *temp0;
    long long   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot"))
      {
      temp20 = (op)->GetPlotIndex(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RaisePlot",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkPlot  *temp0;
    long long   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot"))
      {
      temp20 = (op)->RaisePlot(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("StackPlotAbove",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkPlot  *temp0;
    vtkPlot  *temp1;
    long long   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkPlot"))
      {
      temp20 = (op)->StackPlotAbove(temp0,temp1);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("LowerPlot",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkPlot  *temp0;
    long long   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot"))
      {
      temp20 = (op)->LowerPlot(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("StackPlotUnder",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkPlot  *temp0;
    vtkPlot  *temp1;
    long long   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkPlot"))
      {
      temp20 = (op)->StackPlotUnder(temp0,temp1);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfPlots",method) && msg.GetNumberOfArguments(0) == 2)
    {
    long long   temp20;
      {
      temp20 = (op)->GetNumberOfPlots();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetPlotCorner",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkPlot  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot"))
      {
      temp20 = (op)->GetPlotCorner(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetPlotCorner",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkPlot  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPlot") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetPlotCorner(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetAxis",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    vtkAxis  *temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetAxis(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAxis",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkAxis  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkAxis"))
      {
      op->SetAxis(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("SetShowLegend",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetShowLegend(temp0);
      return 1;
      }
    }
  if (!strcmp("GetLegend",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkChartLegend  *temp20;
      {
      temp20 = (op)->GetLegend();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetTooltip",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkTooltipItem  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkTooltipItem"))
      {
      op->SetTooltip(temp0);
      return 1;
      }
    }
  if (!strcmp("GetTooltip",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkTooltipItem  *temp20;
      {
      temp20 = (op)->GetTooltip();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfAxes",method) && msg.GetNumberOfArguments(0) == 2)
    {
    long long   temp20;
      {
      temp20 = (op)->GetNumberOfAxes();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RecalculateBounds",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RecalculateBounds();
      return 1;
      }
    }
  if (!strcmp("SetSelectionMethod",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetSelectionMethod(temp0);
      return 1;
      }
    }
  if (!strcmp("RemovePlotSelections",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemovePlotSelections();
      return 1;
      }
    }
  if (!strcmp("SetDrawAxesAtOrigin",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetDrawAxesAtOrigin(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDrawAxesAtOrigin",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetDrawAxesAtOrigin();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("DrawAxesAtOriginOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DrawAxesAtOriginOn();
      return 1;
      }
    }
  if (!strcmp("DrawAxesAtOriginOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DrawAxesAtOriginOff();
      return 1;
      }
    }
  if (!strcmp("SetAutoAxes",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAutoAxes(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAutoAxes",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetAutoAxes();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AutoAxesOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->AutoAxesOn();
      return 1;
      }
    }
  if (!strcmp("AutoAxesOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->AutoAxesOff();
      return 1;
      }
    }
  if (!strcmp("SetHiddenAxisBorder",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetHiddenAxisBorder(temp0);
      return 1;
      }
    }
  if (!strcmp("GetHiddenAxisBorder",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetHiddenAxisBorder();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetForceAxesToBounds",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetForceAxesToBounds(temp0);
      return 1;
      }
    }
  if (!strcmp("GetForceAxesToBounds",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetForceAxesToBounds();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ForceAxesToBoundsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ForceAxesToBoundsOn();
      return 1;
      }
    }
  if (!strcmp("ForceAxesToBoundsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ForceAxesToBoundsOff();
      return 1;
      }
    }
  if (!strcmp("SetIgnoreNanInBounds",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetIgnoreNanInBounds(temp0);
      return 1;
      }
    }
  if (!strcmp("GetIgnoreNanInBounds",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetIgnoreNanInBounds();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IgnoreNanInBoundsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->IgnoreNanInBoundsOn();
      return 1;
      }
    }
  if (!strcmp("IgnoreNanInBoundsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->IgnoreNanInBoundsOff();
      return 1;
      }
    }
  if (!strcmp("SetBarWidthFraction",method) && msg.GetNumberOfArguments(0) == 3)
    {
    float    temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetBarWidthFraction(temp0);
      return 1;
      }
    }
  if (!strcmp("GetBarWidthFraction",method) && msg.GetNumberOfArguments(0) == 2)
    {
    float    temp20;
      {
      temp20 = (op)->GetBarWidthFraction();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetZoomWithMouseWheel",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetZoomWithMouseWheel(temp0);
      return 1;
      }
    }
  if (!strcmp("GetZoomWithMouseWheel",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetZoomWithMouseWheel();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ZoomWithMouseWheelOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ZoomWithMouseWheelOn();
      return 1;
      }
    }
  if (!strcmp("ZoomWithMouseWheelOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ZoomWithMouseWheelOff();
      return 1;
      }
    }
  if (!strcmp("SetAxisZoom",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    bool   temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetAxisZoom(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetAxisZoom",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    bool   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetAxisZoom(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAdjustLowerBoundForLogPlot",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAdjustLowerBoundForLogPlot(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAdjustLowerBoundForLogPlot",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetAdjustLowerBoundForLogPlot();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AdjustLowerBoundForLogPlotOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->AdjustLowerBoundForLogPlotOn();
      return 1;
      }
    }
  if (!strcmp("AdjustLowerBoundForLogPlotOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->AdjustLowerBoundForLogPlotOff();
      return 1;
      }
    }
  if (!strcmp("SetDragPointAlongX",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetDragPointAlongX(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDragPointAlongX",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetDragPointAlongX();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("DragPointAlongXOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DragPointAlongXOn();
      return 1;
      }
    }
  if (!strcmp("DragPointAlongXOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DragPointAlongXOff();
      return 1;
      }
    }
  if (!strcmp("SetDragPointAlongY",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetDragPointAlongY(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDragPointAlongY",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetDragPointAlongY();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("DragPointAlongYOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DragPointAlongYOn();
      return 1;
      }
    }
  if (!strcmp("DragPointAlongYOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->DragPointAlongYOff();
      return 1;
      }
    }
  if (!strcmp("MakeSelection",method) && msg.GetNumberOfArguments(0) == 5)
    {
    vtkAnnotationLink  *temp0;
    vtkIdTypeArray  *temp1;
    vtkPlot  *temp2;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkAnnotationLink") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkIdTypeArray") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 4, &temp2, "vtkPlot"))
      {
      vtkChartXY::MakeSelection(temp0,temp1,temp2);
      return 1;
      }
    }
  if (!strcmp("MinusSelection",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkIdTypeArray  *temp0;
    vtkIdTypeArray  *temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkIdTypeArray") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkIdTypeArray"))
      {
      vtkChartXY::MinusSelection(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("AddSelection",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkIdTypeArray  *temp0;
    vtkIdTypeArray  *temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkIdTypeArray") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkIdTypeArray"))
      {
      vtkChartXY::AddSelection(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("ToggleSelection",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkIdTypeArray  *temp0;
    vtkIdTypeArray  *temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkIdTypeArray") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkIdTypeArray"))
      {
      vtkChartXY::ToggleSelection(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("BuildSelection",method) && msg.GetNumberOfArguments(0) == 7)
    {
    vtkAnnotationLink  *temp0;
    int      temp1;
    vtkIdTypeArray  *temp2;
    vtkIdTypeArray  *temp3;
    vtkPlot  *temp4;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkAnnotationLink") &&
      msg.GetArgument(0, 3, &temp1) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 4, &temp2, "vtkIdTypeArray") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 5, &temp3, "vtkIdTypeArray") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 6, &temp4, "vtkPlot"))
      {
      vtkChartXY::BuildSelection(temp0,temp1,temp2,temp3,temp4);
      return 1;
      }
    }

  {
    const char* commandName = "vtkChart";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkChartXY, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkChartXY_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkChartXY", vtkChartXYClientServerNewCommand);
    csi->AddCommandFunction("vtkChartXY", vtkChartXYCommand);
    }
}
}
