// python wrapper for vtkSMExtractsController
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMExtractsController.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMExtractsController(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMExtractsController_ClassNew(); }


static PyObject *
PyvtkSMExtractsController_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMExtractsController::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMExtractsController::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMExtractsController *tempr = vtkSMExtractsController::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMExtractsController *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMExtractsController::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMExtractsController::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMExtractsController::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_SetTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeStep(temp0);
    }
    else
    {
      op->vtkSMExtractsController::SetTimeStep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetTimeStepMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepMinValue() :
      op->vtkSMExtractsController::GetTimeStepMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetTimeStepMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepMaxValue() :
      op->vtkSMExtractsController::GetTimeStepMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStep() :
      op->vtkSMExtractsController::GetTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_SetTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTime(temp0);
    }
    else
    {
      op->vtkSMExtractsController::SetTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTime() :
      op->vtkSMExtractsController::GetTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_SetExtractsOutputDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExtractsOutputDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExtractsOutputDirectory(temp0);
    }
    else
    {
      op->vtkSMExtractsController::SetExtractsOutputDirectory(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetExtractsOutputDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExtractsOutputDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetExtractsOutputDirectory() :
      op->vtkSMExtractsController::GetExtractsOutputDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetRealExtractsOutputDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRealExtractsOutputDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetRealExtractsOutputDirectory() :
      op->vtkSMExtractsController::GetRealExtractsOutputDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_Extract_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Extract");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->Extract(temp0) :
      op->vtkSMExtractsController::Extract(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMExtractsController_Extract_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Extract");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkSMSessionProxyManager *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSessionProxyManager"))
  {
    bool tempr = (ap.IsBound() ?
      op->Extract(temp0) :
      op->vtkSMExtractsController::Extract(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMExtractsController_Extract_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Extract");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Extract() :
      op->vtkSMExtractsController::Extract());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMExtractsController_Extract_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Extract");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkCollection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCollection"))
  {
    bool tempr = (ap.IsBound() ?
      op->Extract(temp0) :
      op->vtkSMExtractsController::Extract(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMExtractsController_Extract_Methods[] = {
  {"Extract", PyvtkSMExtractsController_Extract_s1, METH_VARARGS,
   "@V *vtkSMProxy"},
  {"Extract", PyvtkSMExtractsController_Extract_s2, METH_VARARGS,
   "@V *vtkSMSessionProxyManager"},
  {"Extract", PyvtkSMExtractsController_Extract_s4, METH_VARARGS,
   "@V *vtkCollection"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMExtractsController_Extract(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMExtractsController_Extract_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMExtractsController_Extract_s3(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Extract");
  return nullptr;
}


static PyObject *
PyvtkSMExtractsController_IsAnyTriggerActivated_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsAnyTriggerActivated");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkSMSessionProxyManager *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSessionProxyManager"))
  {
    bool tempr = (ap.IsBound() ?
      op->IsAnyTriggerActivated(temp0) :
      op->vtkSMExtractsController::IsAnyTriggerActivated(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMExtractsController_IsAnyTriggerActivated_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsAnyTriggerActivated");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsAnyTriggerActivated() :
      op->vtkSMExtractsController::IsAnyTriggerActivated());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMExtractsController_IsAnyTriggerActivated_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsAnyTriggerActivated");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkCollection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCollection"))
  {
    bool tempr = (ap.IsBound() ?
      op->IsAnyTriggerActivated(temp0) :
      op->vtkSMExtractsController::IsAnyTriggerActivated(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMExtractsController_IsAnyTriggerActivated_Methods[] = {
  {"IsAnyTriggerActivated", PyvtkSMExtractsController_IsAnyTriggerActivated_s1, METH_VARARGS,
   "@V *vtkSMSessionProxyManager"},
  {"IsAnyTriggerActivated", PyvtkSMExtractsController_IsAnyTriggerActivated_s3, METH_VARARGS,
   "@V *vtkCollection"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMExtractsController_IsAnyTriggerActivated(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMExtractsController_IsAnyTriggerActivated_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMExtractsController_IsAnyTriggerActivated_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "IsAnyTriggerActivated");
  return nullptr;
}


static PyObject *
PyvtkSMExtractsController_IsTriggerActivated(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsTriggerActivated");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->IsTriggerActivated(temp0) :
      op->vtkSMExtractsController::IsTriggerActivated(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_CanExtract(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanExtract");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->CanExtract(temp0, temp1) :
      op->vtkSMExtractsController::CanExtract(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_CreateExtractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateExtractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  const char *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->CreateExtractor(temp0, temp1, temp2) :
      op->vtkSMExtractsController::CreateExtractor(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_CreateSteeringExtractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateSteeringExtractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->CreateSteeringExtractor(temp0, temp1) :
      op->vtkSMExtractsController::CreateSteeringExtractor(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_IsExtractor(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsExtractor");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = vtkSMExtractsController::IsExtractor(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetInputForExtractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputForExtractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetInputForExtractor(temp0) :
      op->vtkSMExtractsController::GetInputForExtractor(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_GetSummaryTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSummaryTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTable *tempr = (ap.IsBound() ?
      op->GetSummaryTable() :
      op->vtkSMExtractsController::GetSummaryTable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_ResetSummaryTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetSummaryTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetSummaryTable();
    }
    else
    {
      op->vtkSMExtractsController::ResetSummaryTable();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_SaveSummaryTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveSummaryTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMExtractsController *op = static_cast<vtkSMExtractsController *>(vp);

  std::string temp0;
  vtkSMSessionProxyManager *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSessionProxyManager"))
  {
    bool tempr = (ap.IsBound() ?
      op->SaveSummaryTable(temp0, temp1) :
      op->vtkSMExtractsController::SaveSummaryTable(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_IsExtractorEnabled(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsExtractorEnabled");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMExtractsController::IsExtractorEnabled(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMExtractsController_SetExtractorEnabled(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetExtractorEnabled");

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMExtractsController::SetExtractorEnabled(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMExtractsController_Methods[] = {
  {"IsTypeOf", PyvtkSMExtractsController_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMExtractsController_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMExtractsController_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMExtractsController\nC++: static vtkSMExtractsController *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMExtractsController_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMExtractsController\nC++: vtkSMExtractsController *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMExtractsController_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMExtractsController_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetTimeStep", PyvtkSMExtractsController_SetTimeStep, METH_VARARGS,
   "SetTimeStep(self, _arg:int) -> None\nC++: virtual void SetTimeStep(int _arg)\n\nInformation about current time/timestep. This must be set\ncorrectly before using `Extract` to generate extracts.\n"},
  {"GetTimeStepMinValue", PyvtkSMExtractsController_GetTimeStepMinValue, METH_VARARGS,
   "GetTimeStepMinValue(self) -> int\nC++: virtual int GetTimeStepMinValue()\n\n"},
  {"GetTimeStepMaxValue", PyvtkSMExtractsController_GetTimeStepMaxValue, METH_VARARGS,
   "GetTimeStepMaxValue(self) -> int\nC++: virtual int GetTimeStepMaxValue()\n\n"},
  {"GetTimeStep", PyvtkSMExtractsController_GetTimeStep, METH_VARARGS,
   "GetTimeStep(self) -> int\nC++: virtual int GetTimeStep()\n\n"},
  {"SetTime", PyvtkSMExtractsController_SetTime, METH_VARARGS,
   "SetTime(self, _arg:float) -> None\nC++: virtual void SetTime(double _arg)\n\n"},
  {"GetTime", PyvtkSMExtractsController_GetTime, METH_VARARGS,
   "GetTime(self) -> float\nC++: virtual double GetTime()\n\n"},
  {"SetExtractsOutputDirectory", PyvtkSMExtractsController_SetExtractsOutputDirectory, METH_VARARGS,
   "SetExtractsOutputDirectory(self, _arg:str) -> None\nC++: virtual void SetExtractsOutputDirectory(const char *_arg)\n\nGet/Set the root directory to use for writing extracts. This must\nbe set correctly before using `Extract` to generate extracts.\n\note This can be overridden at runtime using environment variable\n`PARAVIEW_OVERRIDE_EXTRACTS_OUTPUT_DIRECTORY`. If set, the value\nspecified here ignored and the environment variable is used\ninstead.\n"},
  {"GetExtractsOutputDirectory", PyvtkSMExtractsController_GetExtractsOutputDirectory, METH_VARARGS,
   "GetExtractsOutputDirectory(self) -> str\nC++: virtual char *GetExtractsOutputDirectory()\n\n"},
  {"GetRealExtractsOutputDirectory", PyvtkSMExtractsController_GetRealExtractsOutputDirectory, METH_VARARGS,
   "GetRealExtractsOutputDirectory(self) -> str\nC++: const char *GetRealExtractsOutputDirectory()\n\nReturns the extract output directory to use. If\n`PARAVIEW_OVERRIDE_EXTRACTS_OUTPUT_DIRECTORY` is not set, this\nwill be same as `GetExtractsOutputDirectory` else this will be\nthe value of the `PARAVIEW_OVERRIDE_EXTRACTS_OUTPUT_DIRECTORY`\nenvironment variable.\n"},
  {"Extract", PyvtkSMExtractsController_Extract, METH_VARARGS,
   "Extract(self, extractor:vtkSMProxy) -> bool\nC++: bool Extract(vtkSMProxy *extractor)\nExtract(self, pxm:vtkSMSessionProxyManager) -> bool\nC++: bool Extract(vtkSMSessionProxyManager *pxm)\nExtract(self) -> bool\nC++: bool Extract()\nExtract(self, collection:vtkCollection) -> bool\nC++: bool Extract(vtkCollection *collection)\n\nGenerate the extract for the current state. Returns true if\nextract was generated, false if skipped or failed.\n\nThis overload generates extract from the specific extractor.\n"},
  {"IsAnyTriggerActivated", PyvtkSMExtractsController_IsAnyTriggerActivated, METH_VARARGS,
   "IsAnyTriggerActivated(self, pxm:vtkSMSessionProxyManager) -> bool\nC++: bool IsAnyTriggerActivated(vtkSMSessionProxyManager *pxm)\nIsAnyTriggerActivated(self) -> bool\nC++: bool IsAnyTriggerActivated()\nIsAnyTriggerActivated(self, collection:vtkCollection) -> bool\nC++: bool IsAnyTriggerActivated(vtkCollection *collection)\n\nCheck if any of the extractors registered with the chosen\nproxy-manager (or active proxy-manager, is none specified) has\ntheir trigger activated given the current state of the\napplication and the values for Time and TimeStep set on the\ncontroller.\n"},
  {"IsTriggerActivated", PyvtkSMExtractsController_IsTriggerActivated, METH_VARARGS,
   "IsTriggerActivated(self, extractor:vtkSMProxy) -> bool\nC++: bool IsTriggerActivated(vtkSMProxy *extractor)\n\nSame as `IsAnyTriggerActivated` except only check the selected\nextractor's trigger definition.\n"},
  {"CanExtract", PyvtkSMExtractsController_CanExtract, METH_VARARGS,
   "CanExtract(self, extractor:vtkSMProxy, input:vtkSMProxy) -> bool\nC++: bool CanExtract(vtkSMProxy *extractor, vtkSMProxy *input)\n\n"},
  {"CreateExtractor", PyvtkSMExtractsController_CreateExtractor, METH_VARARGS,
   "CreateExtractor(self, proxy:vtkSMProxy, xmlname:str,\n    registrationName:str=...) -> vtkSMProxy\nC++: vtkSMProxy *CreateExtractor(vtkSMProxy *proxy,\n    const char *xmlname, const char *registrationName=nullptr)\n\nCreates, initializes and registers a new extractor of the chosen\ntype.\n"},
  {"CreateSteeringExtractor", PyvtkSMExtractsController_CreateSteeringExtractor, METH_VARARGS,
   "CreateSteeringExtractor(self, proxy:vtkSMProxy,\n    registrationName:str=...) -> vtkSMProxy\nC++: vtkSMProxy *CreateSteeringExtractor(vtkSMProxy *proxy,\n    const char *registrationName=nullptr)\n\nCreates and initializes a new steering extractor\n"},
  {"IsExtractor", PyvtkSMExtractsController_IsExtractor, METH_VARARGS,
   "IsExtractor(extractor:vtkSMProxy, proxy:vtkSMProxy) -> bool\nC++: static bool IsExtractor(vtkSMProxy *extractor,\n    vtkSMProxy *proxy)\n\nReturns true is the `extractor` is an extractor for the `proxy`.\n"},
  {"GetInputForExtractor", PyvtkSMExtractsController_GetInputForExtractor, METH_VARARGS,
   "GetInputForExtractor(self, extractor:vtkSMProxy) -> vtkSMProxy\nC++: vtkSMProxy *GetInputForExtractor(vtkSMProxy *extractor)\n\nGiven an extractor proxy, returns the producer for the extractor,\nif any. May return a vtkSMViewProxy or a vtkSMOutputPort.\n"},
  {"GetSummaryTable", PyvtkSMExtractsController_GetSummaryTable, METH_VARARGS,
   "GetSummaryTable(self) -> vtkTable\nC++: vtkTable *GetSummaryTable()\n\nGet access to the summary table generated so far. This will be\nnullptr until the first extract is generated.\n\nSee @ref GeneratingExtractsSummary for information about summary\ntable.\n"},
  {"ResetSummaryTable", PyvtkSMExtractsController_ResetSummaryTable, METH_VARARGS,
   "ResetSummaryTable(self) -> None\nC++: void ResetSummaryTable()\n\nReset summary table.\n\nGenerally not needed since there is not much use for reusing\nvtkSMExtractsController, one should just create a new one when\nneeded.\n"},
  {"SaveSummaryTable", PyvtkSMExtractsController_SaveSummaryTable, METH_VARARGS,
   "SaveSummaryTable(self, fname:str, pxm:vtkSMSessionProxyManager)\n    -> bool\nC++: bool SaveSummaryTable(const std::string &fname,\n    vtkSMSessionProxyManager *pxm)\n\nSaves summary table to a file. Path is relative to the\nExtractsOutputDirectory.\n"},
  {"IsExtractorEnabled", PyvtkSMExtractsController_IsExtractorEnabled, METH_VARARGS,
   "IsExtractorEnabled(extractor:vtkSMProxy) -> bool\nC++: static bool IsExtractorEnabled(vtkSMProxy *extractor)\n\nReturns true of the extractor is enabled.\n"},
  {"SetExtractorEnabled", PyvtkSMExtractsController_SetExtractorEnabled, METH_VARARGS,
   "SetExtractorEnabled(extractor:vtkSMProxy, val:bool) -> None\nC++: static void SetExtractorEnabled(vtkSMProxy *extractor,\n    bool val)\n\nEnable/disable an extractor.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMExtractsController_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMExtractsController_GetTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMExtractsController_SetTimeStep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMExtractsController_SetTimeStep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeStep/SetTimeStep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMExtractsController_GetTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMExtractsController_SetTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMExtractsController_SetTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTime/SetTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("extracts_output_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMExtractsController_GetExtractsOutputDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMExtractsController_SetExtractsOutputDirectory(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMExtractsController_SetExtractsOutputDirectory(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExtractsOutputDirectory/SetExtractsOutputDirectory\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("real_extracts_output_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMExtractsController_GetRealExtractsOutputDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRealExtractsOutputDirectory\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("summary_table"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMExtractsController_GetSummaryTable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSummaryTable\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMExtractsController_Doc =
  "vtkSMExtractsController - controller for extract generation\n\n"
  "Superclass: vtkObject\n\n"
  "vtkSMExtractsController is a controllers that provides API to handle\n"
  "various aspects of extractors and extract generation mechanisms\n"
  "supported by ParaView.\n\n"
  "It provides API to query, create extractors of known types. It also\n"
  "provides API to generate extracts using the defined extractors.\n\n"
  "@section GeneratingExtractsSummary Summary of generated extracts\n\n"
  "vtkSMExtractsController generates a summary table for all extracts\n"
  "generated. Each row in this summary table corresponds to an extract\n"
  "generated. Each column provides information about that extract.\n"
  "Filename for the extract is stored in a column named `FILE_[type]`\n"
  "where `[type]` is replaced by the extension of the file. Other\n"
  "columns are used to stored named values that characterize the\n"
  "extract.\n\n"
  "Currently, this summary table is used to generated a Cinema\n"
  "specification which can be used to explore the generated extracts\n"
  "using Cinema tools (https://cinemascience.github.io/).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMExtractsController_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMExtractsController", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMExtractsController_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMExtractsController_StaticNew()
{
  return vtkSMExtractsController::New();
}

PyObject *PyvtkSMExtractsController_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMExtractsController_Type, PyvtkSMExtractsController_Methods,
    "vtkSMExtractsController",
 &PyvtkSMExtractsController_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMExtractsController_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMExtractsController(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMExtractsController_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMExtractsController", o) != 0)
  {
    Py_DECREF(o);
  }

}

