/**
 *
 * @file s_refine_functions.h
 *
 * PaStiX refinement functions implementations.
 *
 * @copyright 2015-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Mathieu Faverge
 * @author Pierre Ramet
 * @author Xavier Lacoste
 * @author Gregoire Pichon
 * @author Theophile Terraz
 * @author Vincent Bridonneau
 * @date 2024-07-05
 * @generated from /build/pastix/src/pastix-6.4.0/refinement/z_refine_functions.h, normal z -> s, Sun Feb 15 18:01:29 2026
 *
 * @addtogroup pastix_dev_refine
 * @{
 *   @brief TODO.
 *
 **/

#ifndef _s_refine_functions_h_
#define _s_refine_functions_h_

#include "common.h"
#include "bcsc/bcsc.h"

#ifndef DOXYGEN_SHOULD_SKIP_THIS
/**
 * @brief TODO
 */
struct s_solver
{
    pastix_int_t    (* getN   )   (pastix_data_t *);
    pastix_fixdbl_t (* getEps )   (pastix_data_t *);
    pastix_int_t    (* getImax)   (pastix_data_t *);
    pastix_int_t    (* getRestart)(pastix_data_t *);

    void* (*malloc)(size_t);
    void  (*free)(void*);

    void   (*output_oneiter)( pastix_fixdbl_t, pastix_fixdbl_t, float, pastix_int_t);
    void   (*output_final)( pastix_data_t *, float, pastix_int_t,
                            pastix_fixdbl_t, void*, float*);

    void   (*scal)( pastix_data_t *, pastix_int_t, float, float * );
    float (*dot) ( pastix_data_t *, pastix_int_t, const float *, const float * );
    void   (*copy)( pastix_data_t *, pastix_int_t, const float *, float * );
    void   (*axpy)( pastix_data_t *, pastix_int_t, float, const float *, float *);
    void   (*spmv)( const pastix_data_t *, pastix_trans_t, float, const float *, float, float * );
    void   (*spsv)( pastix_data_t *, float *, float * );
    float (*norm)( pastix_data_t *, pastix_int_t, const float * );
    void   (*gemv)( pastix_data_t *, pastix_int_t, pastix_int_t,
                    float, const float *, pastix_int_t,
                    const float *, float, float *);
};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

void s_refine_init(struct s_solver *, pastix_data_t*);

pastix_int_t s_gmres_smp   ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t s_grad_smp    ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t s_pivot_smp   ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t s_bicgstab_smp( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );

/**
 * @}
 */
#endif /* _s_refine_functions_h_ */
