/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2026 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtMultimedia.h"

#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtMultimedia/qplaybackoptions.sip"
#include <qplaybackoptions.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.2/build/QtMultimedia/sipQtMultimediaQPlaybackOptions.cpp"

#line 27 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_std_chrono_duration.sip"
#include <chrono>
#line 33 "/build/pyqt6/src/pyqt6-6.10.2/build/QtMultimedia/sipQtMultimediaQPlaybackOptions.cpp"


PyDoc_STRVAR(doc_QPlaybackOptions_swap, "swap(self, other: QPlaybackOptions)");

extern "C" {static PyObject *meth_QPlaybackOptions_swap(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaybackOptions* a0;
        ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPlaybackOptions, &sipCpp, sipType_QPlaybackOptions, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_swap, doc_QPlaybackOptions_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_networkTimeout, "networkTimeout(self) -> int");

extern "C" {static PyObject *meth_QPlaybackOptions_networkTimeout(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_networkTimeout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlaybackOptions, &sipCpp))
        {
            ::std::chrono::milliseconds*sipRes;

            sipRes = new ::std::chrono::milliseconds(sipCpp->networkTimeout());

            return sipConvertFromNewType(sipRes, sipType_std_chrono_milliseconds, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_networkTimeout, doc_QPlaybackOptions_networkTimeout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_setNetworkTimeout, "setNetworkTimeout(self, timeout: int)");

extern "C" {static PyObject *meth_QPlaybackOptions_setNetworkTimeout(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_setNetworkTimeout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::std::chrono::milliseconds* a0;
        int a0State = 0;
        ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlaybackOptions, &sipCpp, sipType_std_chrono_milliseconds, &a0, &a0State))
        {
            sipCpp->setNetworkTimeout(*a0);
            sipReleaseType(a0, sipType_std_chrono_milliseconds, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_setNetworkTimeout, doc_QPlaybackOptions_setNetworkTimeout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_resetNetworkTimeout, "resetNetworkTimeout(self)");

extern "C" {static PyObject *meth_QPlaybackOptions_resetNetworkTimeout(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_resetNetworkTimeout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlaybackOptions, &sipCpp))
        {
            sipCpp->resetNetworkTimeout();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_resetNetworkTimeout, doc_QPlaybackOptions_resetNetworkTimeout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_playbackIntent, "playbackIntent(self) -> QPlaybackOptions.PlaybackIntent");

extern "C" {static PyObject *meth_QPlaybackOptions_playbackIntent(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_playbackIntent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlaybackOptions, &sipCpp))
        {
            ::QPlaybackOptions::PlaybackIntent sipRes;

            sipRes = sipCpp->playbackIntent();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QPlaybackOptions_PlaybackIntent);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_playbackIntent, doc_QPlaybackOptions_playbackIntent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_setPlaybackIntent, "setPlaybackIntent(self, intent: QPlaybackOptions.PlaybackIntent)");

extern "C" {static PyObject *meth_QPlaybackOptions_setPlaybackIntent(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_setPlaybackIntent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaybackOptions::PlaybackIntent a0;
        ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QPlaybackOptions, &sipCpp, sipType_QPlaybackOptions_PlaybackIntent, &a0))
        {
            sipCpp->setPlaybackIntent(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_setPlaybackIntent, doc_QPlaybackOptions_setPlaybackIntent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_resetPlaybackIntent, "resetPlaybackIntent(self)");

extern "C" {static PyObject *meth_QPlaybackOptions_resetPlaybackIntent(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_resetPlaybackIntent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlaybackOptions, &sipCpp))
        {
            sipCpp->resetPlaybackIntent();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_resetPlaybackIntent, doc_QPlaybackOptions_resetPlaybackIntent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_probeSize, "probeSize(self) -> int");

extern "C" {static PyObject *meth_QPlaybackOptions_probeSize(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_probeSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlaybackOptions, &sipCpp))
        {
            ::qsizetype sipRes;

            sipRes = sipCpp->probeSize();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_probeSize, doc_QPlaybackOptions_probeSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_setProbeSize, "setProbeSize(self, probeSizeBytes: int)");

extern "C" {static PyObject *meth_QPlaybackOptions_setProbeSize(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_setProbeSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QPlaybackOptions, &sipCpp, &a0))
        {
            sipCpp->setProbeSize(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_setProbeSize, doc_QPlaybackOptions_setProbeSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlaybackOptions_resetProbeSize, "resetProbeSize(self)");

extern "C" {static PyObject *meth_QPlaybackOptions_resetProbeSize(PyObject *, PyObject *);}
static PyObject *meth_QPlaybackOptions_resetProbeSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaybackOptions *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlaybackOptions, &sipCpp))
        {
            sipCpp->resetProbeSize();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlaybackOptions, sipName_resetProbeSize, doc_QPlaybackOptions_resetProbeSize);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPlaybackOptions___eq__(PyObject *, PyObject *);}
static PyObject *slot_QPlaybackOptions___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPlaybackOptions *sipCpp = reinterpret_cast< ::QPlaybackOptions *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPlaybackOptions));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPlaybackOptions, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, eq_slot, sipType_QPlaybackOptions, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPlaybackOptions___ne__(PyObject *, PyObject *);}
static PyObject *slot_QPlaybackOptions___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPlaybackOptions *sipCpp = reinterpret_cast< ::QPlaybackOptions *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPlaybackOptions));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPlaybackOptions, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, ne_slot, sipType_QPlaybackOptions, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPlaybackOptions___ge__(PyObject *, PyObject *);}
static PyObject *slot_QPlaybackOptions___ge__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPlaybackOptions *sipCpp = reinterpret_cast< ::QPlaybackOptions *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPlaybackOptions));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPlaybackOptions, &a0))
        {
            bool sipRes;

            sipRes = operator>=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, ge_slot, sipType_QPlaybackOptions, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPlaybackOptions___le__(PyObject *, PyObject *);}
static PyObject *slot_QPlaybackOptions___le__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPlaybackOptions *sipCpp = reinterpret_cast< ::QPlaybackOptions *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPlaybackOptions));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPlaybackOptions, &a0))
        {
            bool sipRes;

            sipRes = operator<=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, le_slot, sipType_QPlaybackOptions, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPlaybackOptions___gt__(PyObject *, PyObject *);}
static PyObject *slot_QPlaybackOptions___gt__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPlaybackOptions *sipCpp = reinterpret_cast< ::QPlaybackOptions *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPlaybackOptions));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPlaybackOptions, &a0))
        {
            bool sipRes;

            sipRes = operator>((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, gt_slot, sipType_QPlaybackOptions, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPlaybackOptions___lt__(PyObject *, PyObject *);}
static PyObject *slot_QPlaybackOptions___lt__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPlaybackOptions *sipCpp = reinterpret_cast< ::QPlaybackOptions *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPlaybackOptions));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaybackOptions* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPlaybackOptions, &a0))
        {
            bool sipRes;

            sipRes = operator<((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, lt_slot, sipType_QPlaybackOptions, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QPlaybackOptions(void *, int);}
static void release_QPlaybackOptions(void *sipCppV, int)
{
    delete reinterpret_cast< ::QPlaybackOptions *>(sipCppV);
}


extern "C" {static void *array_QPlaybackOptions(Py_ssize_t);}
static void *array_QPlaybackOptions(Py_ssize_t sipNrElem)
{
    return new ::QPlaybackOptions[sipNrElem];
}


extern "C" {static void array_delete_QPlaybackOptions(void *);}
static void array_delete_QPlaybackOptions(void *sipCpp)
{
    delete[] reinterpret_cast< ::QPlaybackOptions *>(sipCpp);
}


extern "C" {static void assign_QPlaybackOptions(void *, Py_ssize_t, void *);}
static void assign_QPlaybackOptions(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QPlaybackOptions *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QPlaybackOptions *>(sipSrc);
}


extern "C" {static void *copy_QPlaybackOptions(const void *, Py_ssize_t);}
static void *copy_QPlaybackOptions(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QPlaybackOptions(reinterpret_cast<const ::QPlaybackOptions *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QPlaybackOptions(sipSimpleWrapper *);}
static void dealloc_QPlaybackOptions(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QPlaybackOptions(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QPlaybackOptions(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QPlaybackOptions(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QPlaybackOptions *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QPlaybackOptions();

            return sipCpp;
        }
    }

    {
        const ::QPlaybackOptions* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPlaybackOptions, &a0))
        {
            sipCpp = new ::QPlaybackOptions(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QPlaybackOptions[] = {
    {(void *)slot_QPlaybackOptions___eq__, eq_slot},
    {(void *)slot_QPlaybackOptions___ne__, ne_slot},
    {(void *)slot_QPlaybackOptions___ge__, ge_slot},
    {(void *)slot_QPlaybackOptions___le__, le_slot},
    {(void *)slot_QPlaybackOptions___gt__, gt_slot},
    {(void *)slot_QPlaybackOptions___lt__, lt_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QPlaybackOptions[] = {
    {sipName_networkTimeout, meth_QPlaybackOptions_networkTimeout, METH_VARARGS, doc_QPlaybackOptions_networkTimeout},
    {sipName_playbackIntent, meth_QPlaybackOptions_playbackIntent, METH_VARARGS, doc_QPlaybackOptions_playbackIntent},
    {sipName_probeSize, meth_QPlaybackOptions_probeSize, METH_VARARGS, doc_QPlaybackOptions_probeSize},
    {sipName_resetNetworkTimeout, meth_QPlaybackOptions_resetNetworkTimeout, METH_VARARGS, doc_QPlaybackOptions_resetNetworkTimeout},
    {sipName_resetPlaybackIntent, meth_QPlaybackOptions_resetPlaybackIntent, METH_VARARGS, doc_QPlaybackOptions_resetPlaybackIntent},
    {sipName_resetProbeSize, meth_QPlaybackOptions_resetProbeSize, METH_VARARGS, doc_QPlaybackOptions_resetProbeSize},
    {sipName_setNetworkTimeout, meth_QPlaybackOptions_setNetworkTimeout, METH_VARARGS, doc_QPlaybackOptions_setNetworkTimeout},
    {sipName_setPlaybackIntent, meth_QPlaybackOptions_setPlaybackIntent, METH_VARARGS, doc_QPlaybackOptions_setPlaybackIntent},
    {sipName_setProbeSize, meth_QPlaybackOptions_setProbeSize, METH_VARARGS, doc_QPlaybackOptions_setProbeSize},
    {sipName_swap, meth_QPlaybackOptions_swap, METH_VARARGS, doc_QPlaybackOptions_swap}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QPlaybackOptions[] = {
    {sipName_Playback, static_cast<int>(::QPlaybackOptions::PlaybackIntent::Playback)},
    {sipName_LowLatencyStreaming, static_cast<int>(::QPlaybackOptions::PlaybackIntent::LowLatencyStreaming)},
    {0, 0}
};

PyDoc_STRVAR(doc_QPlaybackOptions, "\1QPlaybackOptions()\n"
"QPlaybackOptions(a0: QPlaybackOptions)");


sipClassTypeDef sipTypeDef_QtMultimedia_QPlaybackOptions = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QPlaybackOptions,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QPlaybackOptions,
        {0, 0, 1},
        10, methods_QPlaybackOptions,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QPlaybackOptions, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QPlaybackOptions,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QPlaybackOptions,
    init_type_QPlaybackOptions,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QPlaybackOptions,
    assign_QPlaybackOptions,
    array_QPlaybackOptions,
    copy_QPlaybackOptions,
    release_QPlaybackOptions,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QPlaybackOptions,
    sizeof (::QPlaybackOptions),
};
