#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <string.h>
#include <assert.h>
#include "uv.h"
#include "Python.h"

typedef void* GeventWatcherObject;
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused"
#pragma clang diagnostic ignored "-Wunused-parameter"
#pragma clang diagnostic ignored "-Wundefined-internal"
#endif

static int python_callback(GeventWatcherObject handle, int revents);
static void python_queue_callback(uv_handle_t* watcher_ptr, int revents);
static void python_handle_error(GeventWatcherObject handle, int revents);
static void python_stop(GeventWatcherObject handle);

static void _gevent_generic_callback1(uv_handle_t* watcher, int arg)
{
    python_queue_callback(watcher, arg);
}

static void _gevent_generic_callback0(uv_handle_t* handle)
{
    _gevent_generic_callback1(handle, 0);
}

static void _gevent_async_callback0(uv_async_t* handle)
{
    _gevent_generic_callback0((uv_handle_t*)handle);
}

static void _gevent_timer_callback0(uv_timer_t* handle)
{
    _gevent_generic_callback0((uv_handle_t*)handle);
}

static void _gevent_prepare_callback0(uv_prepare_t* handle)
{
    _gevent_generic_callback0((uv_handle_t*)handle);
}

static void _gevent_check_callback0(uv_check_t* handle)
{
    _gevent_generic_callback0((uv_handle_t*)handle);
}

static void _gevent_idle_callback0(uv_idle_t* handle)
{
    _gevent_generic_callback0((uv_handle_t*)handle);
}

static void _gevent_signal_callback1(uv_signal_t* handle, int signum)
{
    _gevent_generic_callback1((uv_handle_t*)handle, signum);
}


static void _gevent_poll_callback2(void* handle, int status, int events)
{
    _gevent_generic_callback1(handle, status < 0 ? status : events);
}

static void _gevent_fs_event_callback3(void* handle, const char* filename, int events, int status)
{
    _gevent_generic_callback1(handle, status < 0 ? status : events);
}


typedef struct _gevent_fs_poll_s {
    uv_fs_poll_t handle;
    uv_stat_t curr;
    uv_stat_t prev;
} gevent_fs_poll_t;

static void _gevent_fs_poll_callback3(void* handlep, int status, const uv_stat_t* prev, const uv_stat_t* curr)
{
    // stat pointers are valid for this callback only.
    // if given, copy them into our structure, where they can be reached
    // from python, just like libev's watcher does, before calling
    // the callback.

    // The callback is invoked with status < 0 if path does not exist
    // or is inaccessible. The watcher is not stopped but your
    // callback is not called again until something changes (e.g. when
    // the file is created or the error reason changes).
    // In that case the fields will be 0 in curr/prev.


    gevent_fs_poll_t* handle = (gevent_fs_poll_t*)handlep;

    handle->curr = *curr;
    handle->prev = *prev;

    _gevent_generic_callback1((uv_handle_t*)handle, 0);
}

static void gevent_uv_walk_callback_close(uv_handle_t* handle, void* arg)
{
    if( handle && !uv_is_closing(handle) ) {
        uv_close(handle, NULL);
        handle->data = NULL;
    }
}

static void gevent_close_all_handles(uv_loop_t* loop)
{
    if (loop) {
        uv_walk(loop, gevent_uv_walk_callback_close, NULL);
    }
}

static void gevent_zero_timer(uv_timer_t* handle)
{
    memset(handle, 0, sizeof(uv_timer_t));
}

static void gevent_zero_check(uv_check_t* handle)
{
    memset(handle, 0, sizeof(uv_check_t));
}

static void gevent_zero_prepare(uv_prepare_t* handle)
{
    memset(handle, 0, sizeof(uv_prepare_t));
}

static void gevent_zero_loop(uv_loop_t* handle)
{
    memset(handle, 0, sizeof(uv_loop_t));
}

/***
 * Allocation functions
 */

#include "_ffi/alloc.c"

static void* _gevent_uv_malloc(size_t size)
{
    return gevent_realloc(NULL, size);
}

static void* _gevent_uv_realloc(void* ptr, size_t size)
{
    return gevent_realloc(ptr, size);
}

static void _gevent_uv_free(void* ptr)
{
    gevent_realloc(ptr, 0);
}

static void* _gevent_uv_calloc(size_t count, size_t size)
{
    // We assume no overflows. Not using PyObject_Calloc because
    // it's not available prior to 3.5 and isn't in PyPy.
    void* result;
    result = _gevent_uv_malloc(count * size);
    if(result) {
        memset(result, 0, count * size);
    }
    return result;
}

static void gevent_set_uv_alloc()
{
    uv_replace_allocator(_gevent_uv_malloc,
                         _gevent_uv_realloc,
                         _gevent_uv_calloc,
                         _gevent_uv_free);
}

/***
 * Utility Functions
 */
#ifdef __APPLE__
#include <mach/mach.h>
#include <mach/mach_time.h>
#include <pthread.h>

// based on code from libuv
static void gevent_move_pthread_to_realtime_scheduling_class(pthread_t pthread)
{
    mach_timebase_info_data_t timebase_info;
    mach_timebase_info(&timebase_info);

    const uint64_t NANOS_PER_MSEC = 1000000ULL;
    double clock2abs = ((double)timebase_info.denom / (double)timebase_info.numer) * NANOS_PER_MSEC;

    thread_time_constraint_policy_data_t policy;
    policy.period = 0;
    policy.computation = (uint32_t)(5 * clock2abs); // 5 ms of work
    policy.constraint = (uint32_t)(10 * clock2abs);
    policy.preemptible = FALSE;

    int kr = thread_policy_set(
        pthread_mach_thread_np(pthread),
        THREAD_TIME_CONSTRAINT_POLICY,
        (thread_policy_t)&policy,
        THREAD_TIME_CONSTRAINT_POLICY_COUNT);

    if (kr != KERN_SUCCESS) {
        mach_error("thread_policy_set:", kr);
        exit(1);
    }
}

static void gevent_test_setup()
{
    gevent_move_pthread_to_realtime_scheduling_class(pthread_self());
}
#else
static void gevent_test_setup() {}
#endif


#ifdef __clang__
#pragma clang diagnostic pop
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunreachable-code"
#endif


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // char const *()(int)
/*  1 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // char const *()(uv_handle_type)
/*  4 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // uv_handle_type
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // char const *()(void)
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_async_t *)
/*  9 */ _CFFI_OP(_CFFI_OP_POINTER, 229), // uv_async_t *
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_check_t *)
/* 12 */ _CFFI_OP(_CFFI_OP_POINTER, 230), // uv_check_t *
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_check_t *, void(*)(uv_check_t *))
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 16 */ _CFFI_OP(_CFFI_OP_POINTER, 153), // void(*)(uv_check_t *)
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_fs_event_t *)
/* 19 */ _CFFI_OP(_CFFI_OP_POINTER, 231), // uv_fs_event_t *
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_fs_event_t *, char *, size_t *)
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 222), // char *
/* 24 */ _CFFI_OP(_CFFI_OP_POINTER, 148), // size_t *
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_fs_event_t *, void(*)(uv_fs_event_t *, char const *, int, int), char const *, unsigned int)
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 28 */ _CFFI_OP(_CFFI_OP_POINTER, 156), // void(*)(uv_fs_event_t *, char const *, int, int)
/* 29 */ _CFFI_OP(_CFFI_OP_POINTER, 222), // char const *
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_idle_t *)
/* 33 */ _CFFI_OP(_CFFI_OP_POINTER, 234), // uv_idle_t *
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_idle_t *, void(*)(uv_idle_t *))
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 37 */ _CFFI_OP(_CFFI_OP_POINTER, 179), // void(*)(uv_idle_t *)
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *)
/* 40 */ _CFFI_OP(_CFFI_OP_POINTER, 235), // struct uv_loop_s *
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_async_t *, void(*)(uv_async_t *))
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 44 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 45 */ _CFFI_OP(_CFFI_OP_POINTER, 150), // void(*)(uv_async_t *)
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_check_t *)
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_fs_event_t *)
/* 52 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_idle_t *)
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_poll_t *, int)
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 61 */ _CFFI_OP(_CFFI_OP_POINTER, 236), // uv_poll_t *
/* 62 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_prepare_t *)
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 66 */ _CFFI_OP(_CFFI_OP_POINTER, 237), // uv_prepare_t *
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_run_mode)
/* 69 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 70 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // uv_run_mode
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_signal_t *)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 74 */ _CFFI_OP(_CFFI_OP_POINTER, 238), // uv_signal_t *
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t *, uv_timer_t *)
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 78 */ _CFFI_OP(_CFFI_OP_POINTER, 240), // uv_timer_t *
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_loop_t const *)
/* 81 */ _CFFI_OP(_CFFI_OP_POINTER, 235), // uv_loop_t const *
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_poll_t *)
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_poll_t *, int, void(*)(uv_poll_t *, int, int))
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 88 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 89 */ _CFFI_OP(_CFFI_OP_POINTER, 190), // void(*)(uv_poll_t *, int, int)
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_prepare_t *)
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_prepare_t *, void(*)(uv_prepare_t *))
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 96 */ _CFFI_OP(_CFFI_OP_POINTER, 195), // void(*)(uv_prepare_t *)
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_signal_t *)
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 74),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_signal_t *, void(*)(uv_signal_t *, int), int)
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 74),
/* 103 */ _CFFI_OP(_CFFI_OP_POINTER, 198), // void(*)(uv_signal_t *, int)
/* 104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_timer_t *)
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uv_timer_t *, void(*)(uv_timer_t *), uint64_t, uint64_t)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 111 */ _CFFI_OP(_CFFI_OP_POINTER, 202), // void(*)(uv_timer_t *)
/* 112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 113 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(void *)
/* 116 */ _CFFI_OP(_CFFI_OP_POINTER, 245), // void *
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(void *, int)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 120 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(void *, void *)
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(void *, void(*)(uv_fs_poll_t *, int, uv_stat_t const *, uv_stat_t const *), char const *, unsigned int)
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 128 */ _CFFI_OP(_CFFI_OP_POINTER, 162), // void(*)(uv_fs_poll_t *, int, uv_stat_t const *, uv_stat_t const *)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 130 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION, 148), // size_t()(uv_handle_type)
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION, 112), // uint64_t()(uv_loop_t *)
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION, 112), // uint64_t()(uv_timer_t const *)
/* 139 */ _CFFI_OP(_CFFI_OP_POINTER, 240), // uv_timer_t const *
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 30), // unsigned int()(void)
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // uv_loop_t *()(void)
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 116), // void *()(void *, int, size_t)
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 147 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 148 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_async_t *)
/* 151 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_check_t *)
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_fs_event_t *, char const *, int, int)
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 158 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 159 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 160 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_fs_poll_t *, int, uv_stat_t const *, uv_stat_t const *)
/* 163 */ _CFFI_OP(_CFFI_OP_POINTER, 232), // uv_fs_poll_t *
/* 164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 165 */ _CFFI_OP(_CFFI_OP_POINTER, 239), // uv_stat_t const *
/* 166 */ _CFFI_OP(_CFFI_OP_NOOP, 165),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_handle_t *)
/* 169 */ _CFFI_OP(_CFFI_OP_POINTER, 233), // uv_handle_t *
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_handle_t *, int)
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 169),
/* 173 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_handle_t *, void *)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 169),
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_idle_t *)
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_loop_t *)
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_loop_t *, void(*)(uv_handle_t *, void *), void *)
/* 186 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 187 */ _CFFI_OP(_CFFI_OP_POINTER, 175), // void(*)(uv_handle_t *, void *)
/* 188 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 190 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_poll_t *, int, int)
/* 191 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 192 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 193 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 195 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_prepare_t *)
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_signal_t *, int)
/* 199 */ _CFFI_OP(_CFFI_OP_NOOP, 74),
/* 200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_timer_t *)
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(uv_timer_t *, uint64_t)
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 207 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(void *)
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(void *, int)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 214 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(void *, void(*)(uv_handle_t *))
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 218 */ _CFFI_OP(_CFFI_OP_POINTER, 168), // void(*)(uv_handle_t *)
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION, 245), // void()(void)
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 222 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 223 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // enum uv_fs_event
/* 224 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // enum uv_fs_event_flags
/* 225 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // enum uv_poll_event
/* 226 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // gevent_fs_poll_t
/* 227 */ _CFFI_OP(_CFFI_OP_POINTER, 118), // int(*)(void *, int)
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9), // long
/* 229 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // uv_async_t
/* 230 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // uv_check_t
/* 231 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // uv_fs_event_t
/* 232 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // uv_fs_poll_t
/* 233 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // uv_handle_t
/* 234 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // uv_idle_t
/* 235 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // uv_loop_t
/* 236 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // uv_poll_t
/* 237 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // uv_prepare_t
/* 238 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // uv_signal_t
/* 239 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // uv_stat_t
/* 240 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // uv_timer_t
/* 241 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // uv_timespec_t
/* 242 */ _CFFI_OP(_CFFI_OP_POINTER, 171), // void(*)(uv_handle_t *, int)
/* 243 */ _CFFI_OP(_CFFI_OP_POINTER, 209), // void(*)(void *)
/* 244 */ _CFFI_OP(_CFFI_OP_POINTER, 212), // void(*)(void *, int)
/* 245 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_UV_UNKNOWN_HANDLE(unsigned long long *o)
{
  int n = (UV_UNKNOWN_HANDLE) <= 0;
  *o = (unsigned long long)((UV_UNKNOWN_HANDLE) | 0);  /* check that UV_UNKNOWN_HANDLE is an integer */
  return n;
}

static int _cffi_const_UV_ASYNC(unsigned long long *o)
{
  int n = (UV_ASYNC) <= 0;
  *o = (unsigned long long)((UV_ASYNC) | 0);  /* check that UV_ASYNC is an integer */
  return n;
}

static int _cffi_const_UV_CHECK(unsigned long long *o)
{
  int n = (UV_CHECK) <= 0;
  *o = (unsigned long long)((UV_CHECK) | 0);  /* check that UV_CHECK is an integer */
  return n;
}

static int _cffi_const_UV_FS_EVENT(unsigned long long *o)
{
  int n = (UV_FS_EVENT) <= 0;
  *o = (unsigned long long)((UV_FS_EVENT) | 0);  /* check that UV_FS_EVENT is an integer */
  return n;
}

static int _cffi_const_UV_FS_POLL(unsigned long long *o)
{
  int n = (UV_FS_POLL) <= 0;
  *o = (unsigned long long)((UV_FS_POLL) | 0);  /* check that UV_FS_POLL is an integer */
  return n;
}

static int _cffi_const_UV_HANDLE(unsigned long long *o)
{
  int n = (UV_HANDLE) <= 0;
  *o = (unsigned long long)((UV_HANDLE) | 0);  /* check that UV_HANDLE is an integer */
  return n;
}

static int _cffi_const_UV_IDLE(unsigned long long *o)
{
  int n = (UV_IDLE) <= 0;
  *o = (unsigned long long)((UV_IDLE) | 0);  /* check that UV_IDLE is an integer */
  return n;
}

static int _cffi_const_UV_NAMED_PIPE(unsigned long long *o)
{
  int n = (UV_NAMED_PIPE) <= 0;
  *o = (unsigned long long)((UV_NAMED_PIPE) | 0);  /* check that UV_NAMED_PIPE is an integer */
  return n;
}

static int _cffi_const_UV_POLL(unsigned long long *o)
{
  int n = (UV_POLL) <= 0;
  *o = (unsigned long long)((UV_POLL) | 0);  /* check that UV_POLL is an integer */
  return n;
}

static int _cffi_const_UV_PREPARE(unsigned long long *o)
{
  int n = (UV_PREPARE) <= 0;
  *o = (unsigned long long)((UV_PREPARE) | 0);  /* check that UV_PREPARE is an integer */
  return n;
}

static int _cffi_const_UV_PROCESS(unsigned long long *o)
{
  int n = (UV_PROCESS) <= 0;
  *o = (unsigned long long)((UV_PROCESS) | 0);  /* check that UV_PROCESS is an integer */
  return n;
}

static int _cffi_const_UV_STREAM(unsigned long long *o)
{
  int n = (UV_STREAM) <= 0;
  *o = (unsigned long long)((UV_STREAM) | 0);  /* check that UV_STREAM is an integer */
  return n;
}

static int _cffi_const_UV_TCP(unsigned long long *o)
{
  int n = (UV_TCP) <= 0;
  *o = (unsigned long long)((UV_TCP) | 0);  /* check that UV_TCP is an integer */
  return n;
}

static int _cffi_const_UV_TIMER(unsigned long long *o)
{
  int n = (UV_TIMER) <= 0;
  *o = (unsigned long long)((UV_TIMER) | 0);  /* check that UV_TIMER is an integer */
  return n;
}

static int _cffi_const_UV_TTY(unsigned long long *o)
{
  int n = (UV_TTY) <= 0;
  *o = (unsigned long long)((UV_TTY) | 0);  /* check that UV_TTY is an integer */
  return n;
}

static int _cffi_const_UV_UDP(unsigned long long *o)
{
  int n = (UV_UDP) <= 0;
  *o = (unsigned long long)((UV_UDP) | 0);  /* check that UV_UDP is an integer */
  return n;
}

static int _cffi_const_UV_SIGNAL(unsigned long long *o)
{
  int n = (UV_SIGNAL) <= 0;
  *o = (unsigned long long)((UV_SIGNAL) | 0);  /* check that UV_SIGNAL is an integer */
  return n;
}

static int _cffi_const_UV_FILE(unsigned long long *o)
{
  int n = (UV_FILE) <= 0;
  *o = (unsigned long long)((UV_FILE) | 0);  /* check that UV_FILE is an integer */
  return n;
}

static int _cffi_const_UV_HANDLE_TYPE_MAX(unsigned long long *o)
{
  int n = (UV_HANDLE_TYPE_MAX) <= 0;
  *o = (unsigned long long)((UV_HANDLE_TYPE_MAX) | 0);  /* check that UV_HANDLE_TYPE_MAX is an integer */
  return n;
}

static int _cffi_const_UV_RUN_DEFAULT(unsigned long long *o)
{
  int n = (UV_RUN_DEFAULT) <= 0;
  *o = (unsigned long long)((UV_RUN_DEFAULT) | 0);  /* check that UV_RUN_DEFAULT is an integer */
  return n;
}

static int _cffi_const_UV_RUN_ONCE(unsigned long long *o)
{
  int n = (UV_RUN_ONCE) <= 0;
  *o = (unsigned long long)((UV_RUN_ONCE) | 0);  /* check that UV_RUN_ONCE is an integer */
  return n;
}

static int _cffi_const_UV_RUN_NOWAIT(unsigned long long *o)
{
  int n = (UV_RUN_NOWAIT) <= 0;
  *o = (unsigned long long)((UV_RUN_NOWAIT) | 0);  /* check that UV_RUN_NOWAIT is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_uv_stat_t(uv_stat_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->st_dev) | 0);  /* check that 'uv_stat_t.st_dev' is an integer */
  (void)((p->st_mode) | 0);  /* check that 'uv_stat_t.st_mode' is an integer */
  (void)((p->st_nlink) | 0);  /* check that 'uv_stat_t.st_nlink' is an integer */
  (void)((p->st_uid) | 0);  /* check that 'uv_stat_t.st_uid' is an integer */
  (void)((p->st_gid) | 0);  /* check that 'uv_stat_t.st_gid' is an integer */
  (void)((p->st_rdev) | 0);  /* check that 'uv_stat_t.st_rdev' is an integer */
  (void)((p->st_ino) | 0);  /* check that 'uv_stat_t.st_ino' is an integer */
  (void)((p->st_size) | 0);  /* check that 'uv_stat_t.st_size' is an integer */
  (void)((p->st_blksize) | 0);  /* check that 'uv_stat_t.st_blksize' is an integer */
  (void)((p->st_blocks) | 0);  /* check that 'uv_stat_t.st_blocks' is an integer */
  (void)((p->st_flags) | 0);  /* check that 'uv_stat_t.st_flags' is an integer */
  (void)((p->st_gen) | 0);  /* check that 'uv_stat_t.st_gen' is an integer */
  { uv_timespec_t *tmp = &p->st_atim; (void)tmp; }
  { uv_timespec_t *tmp = &p->st_mtim; (void)tmp; }
  { uv_timespec_t *tmp = &p->st_ctim; (void)tmp; }
  { uv_timespec_t *tmp = &p->st_birthtim; (void)tmp; }
}
struct _cffi_align_typedef_uv_stat_t { char x; uv_stat_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_uv_timespec_t(uv_timespec_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->tv_sec) | 0);  /* check that 'uv_timespec_t.tv_sec' is an integer */
  (void)((p->tv_nsec) | 0);  /* check that 'uv_timespec_t.tv_nsec' is an integer */
}
struct _cffi_align_typedef_uv_timespec_t { char x; uv_timespec_t y; };

static int _cffi_const_UV_RENAME(unsigned long long *o)
{
  int n = (UV_RENAME) <= 0;
  *o = (unsigned long long)((UV_RENAME) | 0);  /* check that UV_RENAME is an integer */
  return n;
}

static int _cffi_const_UV_CHANGE(unsigned long long *o)
{
  int n = (UV_CHANGE) <= 0;
  *o = (unsigned long long)((UV_CHANGE) | 0);  /* check that UV_CHANGE is an integer */
  return n;
}

static int _cffi_const_UV_FS_EVENT_WATCH_ENTRY(unsigned long long *o)
{
  int n = (UV_FS_EVENT_WATCH_ENTRY) <= 0;
  *o = (unsigned long long)((UV_FS_EVENT_WATCH_ENTRY) | 0);  /* check that UV_FS_EVENT_WATCH_ENTRY is an integer */
  return n;
}

static int _cffi_const_UV_FS_EVENT_STAT(unsigned long long *o)
{
  int n = (UV_FS_EVENT_STAT) <= 0;
  *o = (unsigned long long)((UV_FS_EVENT_STAT) | 0);  /* check that UV_FS_EVENT_STAT is an integer */
  return n;
}

static int _cffi_const_UV_FS_EVENT_RECURSIVE(unsigned long long *o)
{
  int n = (UV_FS_EVENT_RECURSIVE) <= 0;
  *o = (unsigned long long)((UV_FS_EVENT_RECURSIVE) | 0);  /* check that UV_FS_EVENT_RECURSIVE is an integer */
  return n;
}

static int _cffi_const_UV_READABLE(unsigned long long *o)
{
  int n = (UV_READABLE) <= 0;
  *o = (unsigned long long)((UV_READABLE) | 0);  /* check that UV_READABLE is an integer */
  return n;
}

static int _cffi_const_UV_WRITABLE(unsigned long long *o)
{
  int n = (UV_WRITABLE) <= 0;
  *o = (unsigned long long)((UV_WRITABLE) | 0);  /* check that UV_WRITABLE is an integer */
  return n;
}

static int _cffi_const_UV_DISCONNECT(unsigned long long *o)
{
  int n = (UV_DISCONNECT) <= 0;
  *o = (unsigned long long)((UV_DISCONNECT) | 0);  /* check that UV_DISCONNECT is an integer */
  return n;
}

static int _cffi_const_UV_PRIORITIZED(unsigned long long *o)
{
  int n = (UV_PRIORITIZED) <= 0;
  *o = (unsigned long long)((UV_PRIORITIZED) | 0);  /* check that UV_PRIORITIZED is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy___uv_close_callback =
  { "gevent.libuv._corecffi._uv_close_callback", 0, 0, 0 };

static void _uv_close_callback(uv_handle_t * a0)
{
  char a[8];
  char *p = a;
  *(uv_handle_t * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___uv_close_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_callback =
  { "gevent.libuv._corecffi.python_callback", (int)sizeof(int), 0, 0 };

static int python_callback(void * a0, int a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__python_callback, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__python_check_callback =
  { "gevent.libuv._corecffi.python_check_callback", 0, 0, 0 };

static void python_check_callback(uv_check_t * a0)
{
  char a[8];
  char *p = a;
  *(uv_check_t * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__python_check_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_handle_error =
  { "gevent.libuv._corecffi.python_handle_error", 0, 0, 0 };

static void python_handle_error(void * a0, int a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__python_handle_error, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_prepare_callback =
  { "gevent.libuv._corecffi.python_prepare_callback", 0, 0, 0 };

static void python_prepare_callback(uv_prepare_t * a0)
{
  char a[8];
  char *p = a;
  *(uv_prepare_t * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__python_prepare_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_queue_callback =
  { "gevent.libuv._corecffi.python_queue_callback", 0, 0, 0 };

static void python_queue_callback(uv_handle_t * a0, int a1)
{
  char a[16];
  char *p = a;
  *(uv_handle_t * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__python_queue_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_sigchld_callback =
  { "gevent.libuv._corecffi.python_sigchld_callback", 0, 0, 0 };

static void python_sigchld_callback(uv_signal_t * a0, int a1)
{
  char a[16];
  char *p = a;
  *(uv_signal_t * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__python_sigchld_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_stop =
  { "gevent.libuv._corecffi.python_stop", 0, 0, 0 };

static void python_stop(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__python_stop, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_timer0_callback =
  { "gevent.libuv._corecffi.python_timer0_callback", 0, 0, 0 };

static void python_timer0_callback(uv_check_t * a0)
{
  char a[8];
  char *p = a;
  *(uv_check_t * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__python_timer0_callback, p);
}

static void _cffi_d__gevent_async_callback0(uv_async_t * x0)
{
  _gevent_async_callback0(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_async_callback0(PyObject *self, PyObject *arg0)
{
  uv_async_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_async_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_async_callback0(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_async_callback0 _cffi_d__gevent_async_callback0
#endif

static void _cffi_d__gevent_check_callback0(uv_check_t * x0)
{
  _gevent_check_callback0(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_check_callback0(PyObject *self, PyObject *arg0)
{
  uv_check_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_check_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_check_callback0(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_check_callback0 _cffi_d__gevent_check_callback0
#endif

static void _cffi_d__gevent_fs_event_callback3(uv_fs_event_t * x0, char const * x1, int x2, int x3)
{
  _gevent_fs_event_callback3(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_fs_event_callback3(PyObject *self, PyObject *args)
{
  uv_fs_event_t * x0;
  char const * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "_gevent_fs_event_callback3", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_fs_event_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_fs_event_callback3(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_fs_event_callback3 _cffi_d__gevent_fs_event_callback3
#endif

static void _cffi_d__gevent_fs_poll_callback3(uv_fs_poll_t * x0, int x1, uv_stat_t const * x2, uv_stat_t const * x3)
{
  _gevent_fs_poll_callback3(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_fs_poll_callback3(PyObject *self, PyObject *args)
{
  uv_fs_poll_t * x0;
  int x1;
  uv_stat_t const * x2;
  uv_stat_t const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "_gevent_fs_poll_callback3", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_fs_poll_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(165), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uv_stat_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(165), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(165), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uv_stat_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(165), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_fs_poll_callback3(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_fs_poll_callback3 _cffi_d__gevent_fs_poll_callback3
#endif

static void _cffi_d__gevent_idle_callback0(uv_idle_t * x0)
{
  _gevent_idle_callback0(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_idle_callback0(PyObject *self, PyObject *arg0)
{
  uv_idle_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_idle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_idle_callback0(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_idle_callback0 _cffi_d__gevent_idle_callback0
#endif

static void _cffi_d__gevent_poll_callback2(uv_poll_t * x0, int x1, int x2)
{
  _gevent_poll_callback2(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_poll_callback2(PyObject *self, PyObject *args)
{
  uv_poll_t * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "_gevent_poll_callback2", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_poll_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_poll_callback2(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_poll_callback2 _cffi_d__gevent_poll_callback2
#endif

static void _cffi_d__gevent_prepare_callback0(uv_prepare_t * x0)
{
  _gevent_prepare_callback0(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_prepare_callback0(PyObject *self, PyObject *arg0)
{
  uv_prepare_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_prepare_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_prepare_callback0(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_prepare_callback0 _cffi_d__gevent_prepare_callback0
#endif

static void _cffi_d__gevent_signal_callback1(uv_signal_t * x0, int x1)
{
  _gevent_signal_callback1(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_signal_callback1(PyObject *self, PyObject *args)
{
  uv_signal_t * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "_gevent_signal_callback1", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_signal_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_signal_callback1(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_signal_callback1 _cffi_d__gevent_signal_callback1
#endif

static void _cffi_d__gevent_timer_callback0(uv_timer_t * x0)
{
  _gevent_timer_callback0(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_timer_callback0(PyObject *self, PyObject *arg0)
{
  uv_timer_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_timer_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_timer_callback0(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_timer_callback0 _cffi_d__gevent_timer_callback0
#endif

static void _cffi_d_gevent_close_all_handles(uv_loop_t * x0)
{
  gevent_close_all_handles(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_close_all_handles(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_close_all_handles(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_close_all_handles _cffi_d_gevent_close_all_handles
#endif

static void _cffi_d_gevent_set_uv_alloc(void)
{
  gevent_set_uv_alloc();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_set_uv_alloc(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_set_uv_alloc(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_set_uv_alloc _cffi_d_gevent_set_uv_alloc
#endif

static void _cffi_d_gevent_test_setup(void)
{
  gevent_test_setup();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_test_setup(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_test_setup(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_test_setup _cffi_d_gevent_test_setup
#endif

static void _cffi_d_gevent_uv_walk_callback_close(uv_handle_t * x0, void * x1)
{
  gevent_uv_walk_callback_close(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_uv_walk_callback_close(PyObject *self, PyObject *args)
{
  uv_handle_t * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "gevent_uv_walk_callback_close", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(169), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_handle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(169), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_uv_walk_callback_close(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_uv_walk_callback_close _cffi_d_gevent_uv_walk_callback_close
#endif

static void _cffi_d_gevent_zero_check(uv_check_t * x0)
{
  gevent_zero_check(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_zero_check(PyObject *self, PyObject *arg0)
{
  uv_check_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_check_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_zero_check(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_zero_check _cffi_d_gevent_zero_check
#endif

static void _cffi_d_gevent_zero_loop(uv_loop_t * x0)
{
  gevent_zero_loop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_zero_loop(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_zero_loop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_zero_loop _cffi_d_gevent_zero_loop
#endif

static void _cffi_d_gevent_zero_prepare(uv_prepare_t * x0)
{
  gevent_zero_prepare(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_zero_prepare(PyObject *self, PyObject *arg0)
{
  uv_prepare_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_prepare_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_zero_prepare(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_zero_prepare _cffi_d_gevent_zero_prepare
#endif

static void _cffi_d_gevent_zero_timer(uv_timer_t * x0)
{
  gevent_zero_timer(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_zero_timer(PyObject *self, PyObject *arg0)
{
  uv_timer_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_timer_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_zero_timer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_zero_timer _cffi_d_gevent_zero_timer
#endif

static void * _cffi_d_memset(void * x0, int x1, size_t x2)
{
  return memset(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_memset(PyObject *self, PyObject *args)
{
  void * x0;
  int x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "memset", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = memset(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(116));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_memset _cffi_d_memset
#endif

static int _cffi_d_uv_async_init(uv_loop_t * x0, uv_async_t * x1, void(* x2)(uv_async_t *))
{
  return uv_async_init(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_async_init(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_async_t * x1;
  void(* x2)(uv_async_t *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "uv_async_init", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_async_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (void(*)(uv_async_t *))_cffi_to_c_pointer(arg2, _cffi_type(45));
  if (x2 == (void(*)(uv_async_t *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_async_init(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_async_init _cffi_d_uv_async_init
#endif

static int _cffi_d_uv_async_send(uv_async_t * x0)
{
  return uv_async_send(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_async_send(PyObject *self, PyObject *arg0)
{
  uv_async_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_async_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_async_send(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_async_send _cffi_d_uv_async_send
#endif

static unsigned int _cffi_d_uv_available_parallelism(void)
{
  return uv_available_parallelism();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_available_parallelism(PyObject *self, PyObject *noarg)
{
  unsigned int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_available_parallelism(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_uv_available_parallelism _cffi_d_uv_available_parallelism
#endif

static int _cffi_d_uv_backend_fd(uv_loop_t const * x0)
{
  return uv_backend_fd(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_backend_fd(PyObject *self, PyObject *arg0)
{
  uv_loop_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_backend_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_backend_fd _cffi_d_uv_backend_fd
#endif

static uint64_t _cffi_d_uv_backend_timeout(uv_loop_t * x0)
{
  return uv_backend_timeout(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_backend_timeout(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_backend_timeout(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_backend_timeout _cffi_d_uv_backend_timeout
#endif

static int _cffi_d_uv_check_init(uv_loop_t * x0, uv_check_t * x1)
{
  return uv_check_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_check_init(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_check_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_check_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_check_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_check_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_check_init _cffi_d_uv_check_init
#endif

static int _cffi_d_uv_check_start(uv_check_t * x0, void(* x1)(uv_check_t *))
{
  return uv_check_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_check_start(PyObject *self, PyObject *args)
{
  uv_check_t * x0;
  void(* x1)(uv_check_t *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_check_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_check_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_check_t *))_cffi_to_c_pointer(arg1, _cffi_type(16));
  if (x1 == (void(*)(uv_check_t *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_check_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_check_start _cffi_d_uv_check_start
#endif

static int _cffi_d_uv_check_stop(uv_check_t * x0)
{
  return uv_check_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_check_stop(PyObject *self, PyObject *arg0)
{
  uv_check_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_check_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_check_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_check_stop _cffi_d_uv_check_stop
#endif

static void _cffi_d_uv_close(void * x0, void(* x1)(uv_handle_t *))
{
  uv_close(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_close(PyObject *self, PyObject *args)
{
  void * x0;
  void(* x1)(uv_handle_t *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_close", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_handle_t *))_cffi_to_c_pointer(arg1, _cffi_type(218));
  if (x1 == (void(*)(uv_handle_t *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { uv_close(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_uv_close _cffi_d_uv_close
#endif

static uv_loop_t * _cffi_d_uv_default_loop(void)
{
  return uv_default_loop();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_default_loop(PyObject *self, PyObject *noarg)
{
  uv_loop_t * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_default_loop(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(40));
  return pyresult;
}
#else
#  define _cffi_f_uv_default_loop _cffi_d_uv_default_loop
#endif

static char const * _cffi_d_uv_err_name(int x0)
{
  return uv_err_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_err_name(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_err_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  return pyresult;
}
#else
#  define _cffi_f_uv_err_name _cffi_d_uv_err_name
#endif

static int _cffi_d_uv_fs_event_getpath(uv_fs_event_t * x0, char * x1, size_t * x2)
{
  return uv_fs_event_getpath(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_fs_event_getpath(PyObject *self, PyObject *args)
{
  uv_fs_event_t * x0;
  char * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "uv_fs_event_getpath", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_fs_event_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_fs_event_getpath(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_fs_event_getpath _cffi_d_uv_fs_event_getpath
#endif

static int _cffi_d_uv_fs_event_init(uv_loop_t * x0, uv_fs_event_t * x1)
{
  return uv_fs_event_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_fs_event_init(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_fs_event_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_fs_event_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_fs_event_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_fs_event_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_fs_event_init _cffi_d_uv_fs_event_init
#endif

static int _cffi_d_uv_fs_event_start(uv_fs_event_t * x0, void(* x1)(uv_fs_event_t *, char const *, int, int), char const * x2, unsigned int x3)
{
  return uv_fs_event_start(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_fs_event_start(PyObject *self, PyObject *args)
{
  uv_fs_event_t * x0;
  void(* x1)(uv_fs_event_t *, char const *, int, int);
  char const * x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "uv_fs_event_start", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_fs_event_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_fs_event_t *, char const *, int, int))_cffi_to_c_pointer(arg1, _cffi_type(28));
  if (x1 == (void(*)(uv_fs_event_t *, char const *, int, int))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_fs_event_start(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_fs_event_start _cffi_d_uv_fs_event_start
#endif

static int _cffi_d_uv_fs_event_stop(uv_fs_event_t * x0)
{
  return uv_fs_event_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_fs_event_stop(PyObject *self, PyObject *arg0)
{
  uv_fs_event_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_fs_event_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_fs_event_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_fs_event_stop _cffi_d_uv_fs_event_stop
#endif

static int _cffi_d_uv_fs_poll_init(void * x0, void * x1)
{
  return uv_fs_poll_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_fs_poll_init(PyObject *self, PyObject *args)
{
  void * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_fs_poll_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_fs_poll_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_fs_poll_init _cffi_d_uv_fs_poll_init
#endif

static int _cffi_d_uv_fs_poll_start(void * x0, void(* x1)(uv_fs_poll_t *, int, uv_stat_t const *, uv_stat_t const *), char const * x2, unsigned int x3)
{
  return uv_fs_poll_start(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_fs_poll_start(PyObject *self, PyObject *args)
{
  void * x0;
  void(* x1)(uv_fs_poll_t *, int, uv_stat_t const *, uv_stat_t const *);
  char const * x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "uv_fs_poll_start", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_fs_poll_t *, int, uv_stat_t const *, uv_stat_t const *))_cffi_to_c_pointer(arg1, _cffi_type(128));
  if (x1 == (void(*)(uv_fs_poll_t *, int, uv_stat_t const *, uv_stat_t const *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_fs_poll_start(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_fs_poll_start _cffi_d_uv_fs_poll_start
#endif

static int _cffi_d_uv_fs_poll_stop(void * x0)
{
  return uv_fs_poll_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_fs_poll_stop(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_fs_poll_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_fs_poll_stop _cffi_d_uv_fs_poll_stop
#endif

static size_t _cffi_d_uv_handle_size(uv_handle_type x0)
{
  return uv_handle_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_handle_size(PyObject *self, PyObject *arg0)
{
  uv_handle_type x0;
  size_t result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(4), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_handle_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_uv_handle_size _cffi_d_uv_handle_size
#endif

static char const * _cffi_d_uv_handle_type_name(uv_handle_type x0)
{
  return uv_handle_type_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_handle_type_name(PyObject *self, PyObject *arg0)
{
  uv_handle_type x0;
  char const * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(4), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_handle_type_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  return pyresult;
}
#else
#  define _cffi_f_uv_handle_type_name _cffi_d_uv_handle_type_name
#endif

static int _cffi_d_uv_has_ref(void * x0)
{
  return uv_has_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_has_ref(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_has_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_has_ref _cffi_d_uv_has_ref
#endif

static int _cffi_d_uv_idle_init(uv_loop_t * x0, uv_idle_t * x1)
{
  return uv_idle_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_idle_init(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_idle_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_idle_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_idle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_idle_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_idle_init _cffi_d_uv_idle_init
#endif

static int _cffi_d_uv_idle_start(uv_idle_t * x0, void(* x1)(uv_idle_t *))
{
  return uv_idle_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_idle_start(PyObject *self, PyObject *args)
{
  uv_idle_t * x0;
  void(* x1)(uv_idle_t *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_idle_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_idle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_idle_t *))_cffi_to_c_pointer(arg1, _cffi_type(37));
  if (x1 == (void(*)(uv_idle_t *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_idle_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_idle_start _cffi_d_uv_idle_start
#endif

static int _cffi_d_uv_idle_stop(uv_idle_t * x0)
{
  return uv_idle_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_idle_stop(PyObject *self, PyObject *arg0)
{
  uv_idle_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_idle_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_idle_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_idle_stop _cffi_d_uv_idle_stop
#endif

static int _cffi_d_uv_is_active(void * x0)
{
  return uv_is_active(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_is_active(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_is_active(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_is_active _cffi_d_uv_is_active
#endif

static int _cffi_d_uv_is_closing(void * x0)
{
  return uv_is_closing(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_is_closing(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_is_closing(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_is_closing _cffi_d_uv_is_closing
#endif

static int _cffi_d_uv_loop_alive(uv_loop_t const * x0)
{
  return uv_loop_alive(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_loop_alive(PyObject *self, PyObject *arg0)
{
  uv_loop_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_loop_alive(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_loop_alive _cffi_d_uv_loop_alive
#endif

static int _cffi_d_uv_loop_close(uv_loop_t * x0)
{
  return uv_loop_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_loop_close(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_loop_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_loop_close _cffi_d_uv_loop_close
#endif

static int _cffi_d_uv_loop_fork(uv_loop_t * x0)
{
  return uv_loop_fork(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_loop_fork(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_loop_fork(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_loop_fork _cffi_d_uv_loop_fork
#endif

static int _cffi_d_uv_loop_init(uv_loop_t * x0)
{
  return uv_loop_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_loop_init(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_loop_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_loop_init _cffi_d_uv_loop_init
#endif

static uv_loop_t * _cffi_d_uv_loop_new(void)
{
  return uv_loop_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_loop_new(PyObject *self, PyObject *noarg)
{
  uv_loop_t * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_loop_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(40));
  return pyresult;
}
#else
#  define _cffi_f_uv_loop_new _cffi_d_uv_loop_new
#endif

static uint64_t _cffi_d_uv_now(uv_loop_t * x0)
{
  return uv_now(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_now(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_now(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_now _cffi_d_uv_now
#endif

static int _cffi_d_uv_poll_init(uv_loop_t * x0, uv_poll_t * x1, int x2)
{
  return uv_poll_init(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_poll_init(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_poll_t * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "uv_poll_init", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_poll_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_poll_init(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_poll_init _cffi_d_uv_poll_init
#endif

static int _cffi_d_uv_poll_init_socket(uv_loop_t * x0, uv_poll_t * x1, int x2)
{
  return uv_poll_init_socket(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_poll_init_socket(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_poll_t * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "uv_poll_init_socket", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_poll_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_poll_init_socket(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_poll_init_socket _cffi_d_uv_poll_init_socket
#endif

static int _cffi_d_uv_poll_start(uv_poll_t * x0, int x1, void(* x2)(uv_poll_t *, int, int))
{
  return uv_poll_start(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_poll_start(PyObject *self, PyObject *args)
{
  uv_poll_t * x0;
  int x1;
  void(* x2)(uv_poll_t *, int, int);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "uv_poll_start", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_poll_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (void(*)(uv_poll_t *, int, int))_cffi_to_c_pointer(arg2, _cffi_type(89));
  if (x2 == (void(*)(uv_poll_t *, int, int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_poll_start(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_poll_start _cffi_d_uv_poll_start
#endif

static int _cffi_d_uv_poll_stop(uv_poll_t * x0)
{
  return uv_poll_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_poll_stop(PyObject *self, PyObject *arg0)
{
  uv_poll_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_poll_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_poll_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_poll_stop _cffi_d_uv_poll_stop
#endif

static int _cffi_d_uv_prepare_init(uv_loop_t * x0, uv_prepare_t * x1)
{
  return uv_prepare_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_prepare_init(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_prepare_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_prepare_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_prepare_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_prepare_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_prepare_init _cffi_d_uv_prepare_init
#endif

static int _cffi_d_uv_prepare_start(uv_prepare_t * x0, void(* x1)(uv_prepare_t *))
{
  return uv_prepare_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_prepare_start(PyObject *self, PyObject *args)
{
  uv_prepare_t * x0;
  void(* x1)(uv_prepare_t *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_prepare_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_prepare_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_prepare_t *))_cffi_to_c_pointer(arg1, _cffi_type(96));
  if (x1 == (void(*)(uv_prepare_t *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_prepare_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_prepare_start _cffi_d_uv_prepare_start
#endif

static int _cffi_d_uv_prepare_stop(uv_prepare_t * x0)
{
  return uv_prepare_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_prepare_stop(PyObject *self, PyObject *arg0)
{
  uv_prepare_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_prepare_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_prepare_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_prepare_stop _cffi_d_uv_prepare_stop
#endif

static void _cffi_d_uv_ref(void * x0)
{
  uv_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_ref(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { uv_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_uv_ref _cffi_d_uv_ref
#endif

static int _cffi_d_uv_run(uv_loop_t * x0, uv_run_mode x1)
{
  return uv_run(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_run(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_run_mode x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_run", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_run(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_run _cffi_d_uv_run
#endif

static int _cffi_d_uv_signal_init(uv_loop_t * x0, uv_signal_t * x1)
{
  return uv_signal_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_signal_init(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_signal_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_signal_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_signal_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_signal_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_signal_init _cffi_d_uv_signal_init
#endif

static int _cffi_d_uv_signal_start(uv_signal_t * x0, void(* x1)(uv_signal_t *, int), int x2)
{
  return uv_signal_start(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_signal_start(PyObject *self, PyObject *args)
{
  uv_signal_t * x0;
  void(* x1)(uv_signal_t *, int);
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "uv_signal_start", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_signal_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_signal_t *, int))_cffi_to_c_pointer(arg1, _cffi_type(103));
  if (x1 == (void(*)(uv_signal_t *, int))NULL && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_signal_start(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_signal_start _cffi_d_uv_signal_start
#endif

static int _cffi_d_uv_signal_stop(uv_signal_t * x0)
{
  return uv_signal_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_signal_stop(PyObject *self, PyObject *arg0)
{
  uv_signal_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_signal_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_signal_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_signal_stop _cffi_d_uv_signal_stop
#endif

static void _cffi_d_uv_stop(uv_loop_t * x0)
{
  uv_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_stop(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { uv_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_uv_stop _cffi_d_uv_stop
#endif

static char const * _cffi_d_uv_strerror(int x0)
{
  return uv_strerror(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_strerror(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_strerror(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  return pyresult;
}
#else
#  define _cffi_f_uv_strerror _cffi_d_uv_strerror
#endif

static int _cffi_d_uv_timer_again(uv_timer_t * x0)
{
  return uv_timer_again(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_timer_again(PyObject *self, PyObject *arg0)
{
  uv_timer_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_timer_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_timer_again(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_timer_again _cffi_d_uv_timer_again
#endif

static uint64_t _cffi_d_uv_timer_get_repeat(uv_timer_t const * x0)
{
  return uv_timer_get_repeat(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_timer_get_repeat(PyObject *self, PyObject *arg0)
{
  uv_timer_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_timer_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_timer_get_repeat(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_timer_get_repeat _cffi_d_uv_timer_get_repeat
#endif

static int _cffi_d_uv_timer_init(uv_loop_t * x0, uv_timer_t * x1)
{
  return uv_timer_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_timer_init(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  uv_timer_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_timer_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uv_timer_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_timer_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_timer_init _cffi_d_uv_timer_init
#endif

static void _cffi_d_uv_timer_set_repeat(uv_timer_t * x0, uint64_t x1)
{
  uv_timer_set_repeat(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_timer_set_repeat(PyObject *self, PyObject *args)
{
  uv_timer_t * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "uv_timer_set_repeat", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_timer_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { uv_timer_set_repeat(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_uv_timer_set_repeat _cffi_d_uv_timer_set_repeat
#endif

static int _cffi_d_uv_timer_start(uv_timer_t * x0, void(* x1)(uv_timer_t *), uint64_t x2, uint64_t x3)
{
  return uv_timer_start(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_timer_start(PyObject *self, PyObject *args)
{
  uv_timer_t * x0;
  void(* x1)(uv_timer_t *);
  uint64_t x2;
  uint64_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "uv_timer_start", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_timer_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_timer_t *))_cffi_to_c_pointer(arg1, _cffi_type(111));
  if (x1 == (void(*)(uv_timer_t *))NULL && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_timer_start(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_timer_start _cffi_d_uv_timer_start
#endif

static int _cffi_d_uv_timer_stop(uv_timer_t * x0)
{
  return uv_timer_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_timer_stop(PyObject *self, PyObject *arg0)
{
  uv_timer_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_timer_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_timer_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_uv_timer_stop _cffi_d_uv_timer_stop
#endif

static void _cffi_d_uv_unref(void * x0)
{
  uv_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_unref(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { uv_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_uv_unref _cffi_d_uv_unref
#endif

static void _cffi_d_uv_update_time(uv_loop_t * x0)
{
  uv_update_time(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_update_time(PyObject *self, PyObject *arg0)
{
  uv_loop_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { uv_update_time(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_uv_update_time _cffi_d_uv_update_time
#endif

static char const * _cffi_d_uv_version_string(void)
{
  return uv_version_string();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_version_string(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = uv_version_string(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  return pyresult;
}
#else
#  define _cffi_f_uv_version_string _cffi_d_uv_version_string
#endif

static void _cffi_d_uv_walk(uv_loop_t * x0, void(* x1)(uv_handle_t *, void *), void * x2)
{
  uv_walk(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_uv_walk(PyObject *self, PyObject *args)
{
  uv_loop_t * x0;
  void(* x1)(uv_handle_t *, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "uv_walk", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uv_loop_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uv_handle_t *, void *))_cffi_to_c_pointer(arg1, _cffi_type(187));
  if (x1 == (void(*)(uv_handle_t *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { uv_walk(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_uv_walk _cffi_d_uv_walk
#endif

static int _cffi_const_LIBUV_EMBED(unsigned long long *o)
{
  int n = (LIBUV_EMBED) <= 0;
  *o = (unsigned long long)((LIBUV_EMBED) | 0);  /* check that LIBUV_EMBED is an integer */
  return n;
}

static int _cffi_const_UV_EBADF(unsigned long long *o)
{
  int n = (UV_EBADF) <= 0;
  *o = (unsigned long long)((UV_EBADF) | 0);  /* check that UV_EBADF is an integer */
  return n;
}

static int _cffi_const_UV_EBUSY(unsigned long long *o)
{
  int n = (UV_EBUSY) <= 0;
  *o = (unsigned long long)((UV_EBUSY) | 0);  /* check that UV_EBUSY is an integer */
  return n;
}

static int _cffi_const_UV_VERSION_MAJOR(unsigned long long *o)
{
  int n = (UV_VERSION_MAJOR) <= 0;
  *o = (unsigned long long)((UV_VERSION_MAJOR) | 0);  /* check that UV_VERSION_MAJOR is an integer */
  return n;
}

static int _cffi_const_UV_VERSION_MINOR(unsigned long long *o)
{
  int n = (UV_VERSION_MINOR) <= 0;
  *o = (unsigned long long)((UV_VERSION_MINOR) | 0);  /* check that UV_VERSION_MINOR is an integer */
  return n;
}

static int _cffi_const_UV_VERSION_PATCH(unsigned long long *o)
{
  int n = (UV_VERSION_PATCH) <= 0;
  *o = (unsigned long long)((UV_VERSION_PATCH) | 0);  /* check that UV_VERSION_PATCH is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__gevent_fs_poll_t(gevent_fs_poll_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { uv_fs_poll_t *tmp = &p->handle; (void)tmp; }
  { uv_stat_t *tmp = &p->curr; (void)tmp; }
  { uv_stat_t *tmp = &p->prev; (void)tmp; }
}
struct _cffi_align__gevent_fs_poll_t { char x; gevent_fs_poll_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_async_t(uv_async_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_async_t { char x; uv_async_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_check_t(uv_check_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_check_t { char x; uv_check_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_fs_event_t(uv_fs_event_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_fs_event_t { char x; uv_fs_event_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_fs_poll_t(uv_fs_poll_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_fs_poll_t { char x; uv_fs_poll_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_handle_t(uv_handle_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_handle_t { char x; uv_handle_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_idle_t(uv_idle_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_idle_t { char x; uv_idle_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_loop_t(uv_loop_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_loop_t { char x; uv_loop_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_poll_t(uv_poll_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_poll_t { char x; uv_poll_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_prepare_t(uv_prepare_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_prepare_t { char x; uv_prepare_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_signal_t(uv_signal_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_signal_t { char x; uv_signal_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__uv_timer_t(uv_timer_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct uv_loop_s * *tmp = &p->loop; (void)tmp; }
  { uv_handle_type *tmp = &p->type; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__uv_timer_t { char x; uv_timer_t y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "LIBUV_EMBED", (void *)_cffi_const_LIBUV_EMBED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "UV_ASYNC", (void *)_cffi_const_UV_ASYNC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_CHANGE", (void *)_cffi_const_UV_CHANGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_CHECK", (void *)_cffi_const_UV_CHECK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_DISCONNECT", (void *)_cffi_const_UV_DISCONNECT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_EBADF", (void *)_cffi_const_UV_EBADF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "UV_EBUSY", (void *)_cffi_const_UV_EBUSY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "UV_FILE", (void *)_cffi_const_UV_FILE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_FS_EVENT", (void *)_cffi_const_UV_FS_EVENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_FS_EVENT_RECURSIVE", (void *)_cffi_const_UV_FS_EVENT_RECURSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_FS_EVENT_STAT", (void *)_cffi_const_UV_FS_EVENT_STAT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_FS_EVENT_WATCH_ENTRY", (void *)_cffi_const_UV_FS_EVENT_WATCH_ENTRY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_FS_POLL", (void *)_cffi_const_UV_FS_POLL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_HANDLE", (void *)_cffi_const_UV_HANDLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_HANDLE_TYPE_MAX", (void *)_cffi_const_UV_HANDLE_TYPE_MAX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_IDLE", (void *)_cffi_const_UV_IDLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_NAMED_PIPE", (void *)_cffi_const_UV_NAMED_PIPE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_POLL", (void *)_cffi_const_UV_POLL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_PREPARE", (void *)_cffi_const_UV_PREPARE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_PRIORITIZED", (void *)_cffi_const_UV_PRIORITIZED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_PROCESS", (void *)_cffi_const_UV_PROCESS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_READABLE", (void *)_cffi_const_UV_READABLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_RENAME", (void *)_cffi_const_UV_RENAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_RUN_DEFAULT", (void *)_cffi_const_UV_RUN_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_RUN_NOWAIT", (void *)_cffi_const_UV_RUN_NOWAIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_RUN_ONCE", (void *)_cffi_const_UV_RUN_ONCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_SIGNAL", (void *)_cffi_const_UV_SIGNAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_STREAM", (void *)_cffi_const_UV_STREAM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_TCP", (void *)_cffi_const_UV_TCP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_TIMER", (void *)_cffi_const_UV_TIMER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_TTY", (void *)_cffi_const_UV_TTY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_UDP", (void *)_cffi_const_UV_UDP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_UNKNOWN_HANDLE", (void *)_cffi_const_UV_UNKNOWN_HANDLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "UV_VERSION_MAJOR", (void *)_cffi_const_UV_VERSION_MAJOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "UV_VERSION_MINOR", (void *)_cffi_const_UV_VERSION_MINOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "UV_VERSION_PATCH", (void *)_cffi_const_UV_VERSION_PATCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "UV_WRITABLE", (void *)_cffi_const_UV_WRITABLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "_gevent_async_callback0", (void *)_cffi_f__gevent_async_callback0, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 150), (void *)_cffi_d__gevent_async_callback0 },
  { "_gevent_check_callback0", (void *)_cffi_f__gevent_check_callback0, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 153), (void *)_cffi_d__gevent_check_callback0 },
  { "_gevent_fs_event_callback3", (void *)_cffi_f__gevent_fs_event_callback3, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 156), (void *)_cffi_d__gevent_fs_event_callback3 },
  { "_gevent_fs_poll_callback3", (void *)_cffi_f__gevent_fs_poll_callback3, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 162), (void *)_cffi_d__gevent_fs_poll_callback3 },
  { "_gevent_idle_callback0", (void *)_cffi_f__gevent_idle_callback0, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 179), (void *)_cffi_d__gevent_idle_callback0 },
  { "_gevent_poll_callback2", (void *)_cffi_f__gevent_poll_callback2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 190), (void *)_cffi_d__gevent_poll_callback2 },
  { "_gevent_prepare_callback0", (void *)_cffi_f__gevent_prepare_callback0, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 195), (void *)_cffi_d__gevent_prepare_callback0 },
  { "_gevent_signal_callback1", (void *)_cffi_f__gevent_signal_callback1, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 198), (void *)_cffi_d__gevent_signal_callback1 },
  { "_gevent_timer_callback0", (void *)_cffi_f__gevent_timer_callback0, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 202), (void *)_cffi_d__gevent_timer_callback0 },
  { "_uv_close_callback", (void *)&_cffi_externpy___uv_close_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 218), (void *)_uv_close_callback },
  { "gevent_close_all_handles", (void *)_cffi_f_gevent_close_all_handles, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 182), (void *)_cffi_d_gevent_close_all_handles },
  { "gevent_set_uv_alloc", (void *)_cffi_f_gevent_set_uv_alloc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 220), (void *)_cffi_d_gevent_set_uv_alloc },
  { "gevent_test_setup", (void *)_cffi_f_gevent_test_setup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 220), (void *)_cffi_d_gevent_test_setup },
  { "gevent_uv_walk_callback_close", (void *)_cffi_f_gevent_uv_walk_callback_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_gevent_uv_walk_callback_close },
  { "gevent_zero_check", (void *)_cffi_f_gevent_zero_check, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 153), (void *)_cffi_d_gevent_zero_check },
  { "gevent_zero_loop", (void *)_cffi_f_gevent_zero_loop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 182), (void *)_cffi_d_gevent_zero_loop },
  { "gevent_zero_prepare", (void *)_cffi_f_gevent_zero_prepare, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 195), (void *)_cffi_d_gevent_zero_prepare },
  { "gevent_zero_timer", (void *)_cffi_f_gevent_zero_timer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 202), (void *)_cffi_d_gevent_zero_timer },
  { "memset", (void *)_cffi_f_memset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_memset },
  { "python_callback", (void *)&_cffi_externpy__python_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 227), (void *)python_callback },
  { "python_check_callback", (void *)&_cffi_externpy__python_check_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 16), (void *)python_check_callback },
  { "python_handle_error", (void *)&_cffi_externpy__python_handle_error, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 244), (void *)python_handle_error },
  { "python_prepare_callback", (void *)&_cffi_externpy__python_prepare_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 96), (void *)python_prepare_callback },
  { "python_queue_callback", (void *)&_cffi_externpy__python_queue_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 242), (void *)python_queue_callback },
  { "python_sigchld_callback", (void *)&_cffi_externpy__python_sigchld_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 103), (void *)python_sigchld_callback },
  { "python_stop", (void *)&_cffi_externpy__python_stop, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 243), (void *)python_stop },
  { "python_timer0_callback", (void *)&_cffi_externpy__python_timer0_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 16), (void *)python_timer0_callback },
  { "uv_async_init", (void *)_cffi_f_uv_async_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 42), (void *)_cffi_d_uv_async_init },
  { "uv_async_send", (void *)_cffi_f_uv_async_send, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 8), (void *)_cffi_d_uv_async_send },
  { "uv_available_parallelism", (void *)_cffi_f_uv_available_parallelism, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 141), (void *)_cffi_d_uv_available_parallelism },
  { "uv_backend_fd", (void *)_cffi_f_uv_backend_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 80), (void *)_cffi_d_uv_backend_fd },
  { "uv_backend_timeout", (void *)_cffi_f_uv_backend_timeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 135), (void *)_cffi_d_uv_backend_timeout },
  { "uv_check_init", (void *)_cffi_f_uv_check_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_uv_check_init },
  { "uv_check_start", (void *)_cffi_f_uv_check_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 14), (void *)_cffi_d_uv_check_start },
  { "uv_check_stop", (void *)_cffi_f_uv_check_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 11), (void *)_cffi_d_uv_check_stop },
  { "uv_close", (void *)_cffi_f_uv_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 216), (void *)_cffi_d_uv_close },
  { "uv_default_loop", (void *)_cffi_f_uv_default_loop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 143), (void *)_cffi_d_uv_default_loop },
  { "uv_err_name", (void *)_cffi_f_uv_err_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_uv_err_name },
  { "uv_fs_event_getpath", (void *)_cffi_f_uv_fs_event_getpath, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 21), (void *)_cffi_d_uv_fs_event_getpath },
  { "uv_fs_event_init", (void *)_cffi_f_uv_fs_event_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 51), (void *)_cffi_d_uv_fs_event_init },
  { "uv_fs_event_start", (void *)_cffi_f_uv_fs_event_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 26), (void *)_cffi_d_uv_fs_event_start },
  { "uv_fs_event_stop", (void *)_cffi_f_uv_fs_event_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_uv_fs_event_stop },
  { "uv_fs_poll_init", (void *)_cffi_f_uv_fs_poll_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 122), (void *)_cffi_d_uv_fs_poll_init },
  { "uv_fs_poll_start", (void *)_cffi_f_uv_fs_poll_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 126), (void *)_cffi_d_uv_fs_poll_start },
  { "uv_fs_poll_stop", (void *)_cffi_f_uv_fs_poll_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 115), (void *)_cffi_d_uv_fs_poll_stop },
  { "uv_handle_size", (void *)_cffi_f_uv_handle_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 132), (void *)_cffi_d_uv_handle_size },
  { "uv_handle_type_name", (void *)_cffi_f_uv_handle_type_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_uv_handle_type_name },
  { "uv_has_ref", (void *)_cffi_f_uv_has_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 115), (void *)_cffi_d_uv_has_ref },
  { "uv_idle_init", (void *)_cffi_f_uv_idle_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 55), (void *)_cffi_d_uv_idle_init },
  { "uv_idle_start", (void *)_cffi_f_uv_idle_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 35), (void *)_cffi_d_uv_idle_start },
  { "uv_idle_stop", (void *)_cffi_f_uv_idle_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 32), (void *)_cffi_d_uv_idle_stop },
  { "uv_is_active", (void *)_cffi_f_uv_is_active, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 115), (void *)_cffi_d_uv_is_active },
  { "uv_is_closing", (void *)_cffi_f_uv_is_closing, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 115), (void *)_cffi_d_uv_is_closing },
  { "uv_loop_alive", (void *)_cffi_f_uv_loop_alive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 80), (void *)_cffi_d_uv_loop_alive },
  { "uv_loop_close", (void *)_cffi_f_uv_loop_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 39), (void *)_cffi_d_uv_loop_close },
  { "uv_loop_fork", (void *)_cffi_f_uv_loop_fork, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 39), (void *)_cffi_d_uv_loop_fork },
  { "uv_loop_init", (void *)_cffi_f_uv_loop_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 39), (void *)_cffi_d_uv_loop_init },
  { "uv_loop_new", (void *)_cffi_f_uv_loop_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 143), (void *)_cffi_d_uv_loop_new },
  { "uv_now", (void *)_cffi_f_uv_now, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 135), (void *)_cffi_d_uv_now },
  { "uv_poll_init", (void *)_cffi_f_uv_poll_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 59), (void *)_cffi_d_uv_poll_init },
  { "uv_poll_init_socket", (void *)_cffi_f_uv_poll_init_socket, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 59), (void *)_cffi_d_uv_poll_init_socket },
  { "uv_poll_start", (void *)_cffi_f_uv_poll_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 86), (void *)_cffi_d_uv_poll_start },
  { "uv_poll_stop", (void *)_cffi_f_uv_poll_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 83), (void *)_cffi_d_uv_poll_stop },
  { "uv_prepare_init", (void *)_cffi_f_uv_prepare_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 64), (void *)_cffi_d_uv_prepare_init },
  { "uv_prepare_start", (void *)_cffi_f_uv_prepare_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 94), (void *)_cffi_d_uv_prepare_start },
  { "uv_prepare_stop", (void *)_cffi_f_uv_prepare_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 91), (void *)_cffi_d_uv_prepare_stop },
  { "uv_ref", (void *)_cffi_f_uv_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 209), (void *)_cffi_d_uv_ref },
  { "uv_run", (void *)_cffi_f_uv_run, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 68), (void *)_cffi_d_uv_run },
  { "uv_signal_init", (void *)_cffi_f_uv_signal_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 72), (void *)_cffi_d_uv_signal_init },
  { "uv_signal_start", (void *)_cffi_f_uv_signal_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 101), (void *)_cffi_d_uv_signal_start },
  { "uv_signal_stop", (void *)_cffi_f_uv_signal_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 98), (void *)_cffi_d_uv_signal_stop },
  { "uv_stop", (void *)_cffi_f_uv_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 182), (void *)_cffi_d_uv_stop },
  { "uv_strerror", (void *)_cffi_f_uv_strerror, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_uv_strerror },
  { "uv_timer_again", (void *)_cffi_f_uv_timer_again, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_uv_timer_again },
  { "uv_timer_get_repeat", (void *)_cffi_f_uv_timer_get_repeat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 138), (void *)_cffi_d_uv_timer_get_repeat },
  { "uv_timer_init", (void *)_cffi_f_uv_timer_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 76), (void *)_cffi_d_uv_timer_init },
  { "uv_timer_set_repeat", (void *)_cffi_f_uv_timer_set_repeat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 205), (void *)_cffi_d_uv_timer_set_repeat },
  { "uv_timer_start", (void *)_cffi_f_uv_timer_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_uv_timer_start },
  { "uv_timer_stop", (void *)_cffi_f_uv_timer_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_uv_timer_stop },
  { "uv_unref", (void *)_cffi_f_uv_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 209), (void *)_cffi_d_uv_unref },
  { "uv_update_time", (void *)_cffi_f_uv_update_time, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 182), (void *)_cffi_d_uv_update_time },
  { "uv_version_string", (void *)_cffi_f_uv_version_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 6), (void *)_cffi_d_uv_version_string },
  { "uv_walk", (void *)_cffi_f_uv_walk, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 185), (void *)_cffi_d_uv_walk },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "st_dev", offsetof(uv_stat_t, st_dev),
              sizeof(((uv_stat_t *)0)->st_dev),
              _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_mode", offsetof(uv_stat_t, st_mode),
               sizeof(((uv_stat_t *)0)->st_mode),
               _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_nlink", offsetof(uv_stat_t, st_nlink),
                sizeof(((uv_stat_t *)0)->st_nlink),
                _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_uid", offsetof(uv_stat_t, st_uid),
              sizeof(((uv_stat_t *)0)->st_uid),
              _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_gid", offsetof(uv_stat_t, st_gid),
              sizeof(((uv_stat_t *)0)->st_gid),
              _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_rdev", offsetof(uv_stat_t, st_rdev),
               sizeof(((uv_stat_t *)0)->st_rdev),
               _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_ino", offsetof(uv_stat_t, st_ino),
              sizeof(((uv_stat_t *)0)->st_ino),
              _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_size", offsetof(uv_stat_t, st_size),
               sizeof(((uv_stat_t *)0)->st_size),
               _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_blksize", offsetof(uv_stat_t, st_blksize),
                  sizeof(((uv_stat_t *)0)->st_blksize),
                  _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_blocks", offsetof(uv_stat_t, st_blocks),
                 sizeof(((uv_stat_t *)0)->st_blocks),
                 _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_flags", offsetof(uv_stat_t, st_flags),
                sizeof(((uv_stat_t *)0)->st_flags),
                _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_gen", offsetof(uv_stat_t, st_gen),
              sizeof(((uv_stat_t *)0)->st_gen),
              _CFFI_OP(_CFFI_OP_NOOP, 112) },
  { "st_atim", offsetof(uv_stat_t, st_atim),
               sizeof(((uv_stat_t *)0)->st_atim),
               _CFFI_OP(_CFFI_OP_NOOP, 241) },
  { "st_mtim", offsetof(uv_stat_t, st_mtim),
               sizeof(((uv_stat_t *)0)->st_mtim),
               _CFFI_OP(_CFFI_OP_NOOP, 241) },
  { "st_ctim", offsetof(uv_stat_t, st_ctim),
               sizeof(((uv_stat_t *)0)->st_ctim),
               _CFFI_OP(_CFFI_OP_NOOP, 241) },
  { "st_birthtim", offsetof(uv_stat_t, st_birthtim),
                   sizeof(((uv_stat_t *)0)->st_birthtim),
                   _CFFI_OP(_CFFI_OP_NOOP, 241) },
  { "tv_sec", offsetof(uv_timespec_t, tv_sec),
              sizeof(((uv_timespec_t *)0)->tv_sec),
              _CFFI_OP(_CFFI_OP_NOOP, 228) },
  { "tv_nsec", offsetof(uv_timespec_t, tv_nsec),
               sizeof(((uv_timespec_t *)0)->tv_nsec),
               _CFFI_OP(_CFFI_OP_NOOP, 228) },
  { "handle", offsetof(gevent_fs_poll_t, handle),
              sizeof(((gevent_fs_poll_t *)0)->handle),
              _CFFI_OP(_CFFI_OP_NOOP, 232) },
  { "curr", offsetof(gevent_fs_poll_t, curr),
            sizeof(((gevent_fs_poll_t *)0)->curr),
            _CFFI_OP(_CFFI_OP_NOOP, 239) },
  { "prev", offsetof(gevent_fs_poll_t, prev),
            sizeof(((gevent_fs_poll_t *)0)->prev),
            _CFFI_OP(_CFFI_OP_NOOP, 239) },
  { "loop", offsetof(uv_async_t, loop),
            sizeof(((uv_async_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_async_t, type),
            sizeof(((uv_async_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_async_t, data),
            sizeof(((uv_async_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_check_t, loop),
            sizeof(((uv_check_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_check_t, type),
            sizeof(((uv_check_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_check_t, data),
            sizeof(((uv_check_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_fs_event_t, loop),
            sizeof(((uv_fs_event_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_fs_event_t, type),
            sizeof(((uv_fs_event_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_fs_event_t, data),
            sizeof(((uv_fs_event_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_fs_poll_t, loop),
            sizeof(((uv_fs_poll_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_fs_poll_t, type),
            sizeof(((uv_fs_poll_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_fs_poll_t, data),
            sizeof(((uv_fs_poll_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_handle_t, loop),
            sizeof(((uv_handle_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_handle_t, type),
            sizeof(((uv_handle_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_handle_t, data),
            sizeof(((uv_handle_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_idle_t, loop),
            sizeof(((uv_idle_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_idle_t, type),
            sizeof(((uv_idle_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_idle_t, data),
            sizeof(((uv_idle_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "data", offsetof(uv_loop_t, data),
            sizeof(((uv_loop_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_poll_t, loop),
            sizeof(((uv_poll_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_poll_t, type),
            sizeof(((uv_poll_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_poll_t, data),
            sizeof(((uv_poll_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_prepare_t, loop),
            sizeof(((uv_prepare_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_prepare_t, type),
            sizeof(((uv_prepare_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_prepare_t, data),
            sizeof(((uv_prepare_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_signal_t, loop),
            sizeof(((uv_signal_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_signal_t, type),
            sizeof(((uv_signal_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_signal_t, data),
            sizeof(((uv_signal_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "loop", offsetof(uv_timer_t, loop),
            sizeof(((uv_timer_t *)0)->loop),
            _CFFI_OP(_CFFI_OP_NOOP, 40) },
  { "type", offsetof(uv_timer_t, type),
            sizeof(((uv_timer_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "data", offsetof(uv_timer_t, data),
            sizeof(((uv_timer_t *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 116) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$uv_stat_t", 239, _CFFI_F_CHECK_FIELDS,
    sizeof(uv_stat_t), offsetof(struct _cffi_align_typedef_uv_stat_t, y), 0, 16 },
  { "$uv_timespec_t", 241, _CFFI_F_CHECK_FIELDS,
    sizeof(uv_timespec_t), offsetof(struct _cffi_align_typedef_uv_timespec_t, y), 16, 2 },
  { "_gevent_fs_poll_s", 226, 0,
    sizeof(gevent_fs_poll_t), offsetof(struct _cffi_align__gevent_fs_poll_t, y), 18, 3 },
  { "uv_async_s", 229, 0,
    sizeof(uv_async_t), offsetof(struct _cffi_align__uv_async_t, y), 21, 3 },
  { "uv_check_s", 230, 0,
    sizeof(uv_check_t), offsetof(struct _cffi_align__uv_check_t, y), 24, 3 },
  { "uv_fs_event_s", 231, 0,
    sizeof(uv_fs_event_t), offsetof(struct _cffi_align__uv_fs_event_t, y), 27, 3 },
  { "uv_fs_poll_s", 232, 0,
    sizeof(uv_fs_poll_t), offsetof(struct _cffi_align__uv_fs_poll_t, y), 30, 3 },
  { "uv_handle_s", 233, 0,
    sizeof(uv_handle_t), offsetof(struct _cffi_align__uv_handle_t, y), 33, 3 },
  { "uv_idle_s", 234, 0,
    sizeof(uv_idle_t), offsetof(struct _cffi_align__uv_idle_t, y), 36, 3 },
  { "uv_loop_s", 235, 0,
    sizeof(uv_loop_t), offsetof(struct _cffi_align__uv_loop_t, y), 39, 1 },
  { "uv_poll_s", 236, 0,
    sizeof(uv_poll_t), offsetof(struct _cffi_align__uv_poll_t, y), 40, 3 },
  { "uv_prepare_s", 237, 0,
    sizeof(uv_prepare_t), offsetof(struct _cffi_align__uv_prepare_t, y), 43, 3 },
  { "uv_signal_s", 238, 0,
    sizeof(uv_signal_t), offsetof(struct _cffi_align__uv_signal_t, y), 46, 3 },
  { "uv_timer_s", 240, 0,
    sizeof(uv_timer_t), offsetof(struct _cffi_align__uv_timer_t, y), 49, 3 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$uv_handle_type", 4, _cffi_prim_int(sizeof(uv_handle_type), ((uv_handle_type)-1) <= 0),
    "UV_UNKNOWN_HANDLE,UV_ASYNC,UV_CHECK,UV_FS_EVENT,UV_FS_POLL,UV_HANDLE,UV_IDLE,UV_NAMED_PIPE,UV_POLL,UV_PREPARE,UV_PROCESS,UV_STREAM,UV_TCP,UV_TIMER,UV_TTY,UV_UDP,UV_SIGNAL,UV_FILE,UV_HANDLE_TYPE_MAX" },
  { "$uv_run_mode", 70, _cffi_prim_int(sizeof(uv_run_mode), ((uv_run_mode)-1) <= 0),
    "UV_RUN_DEFAULT,UV_RUN_ONCE,UV_RUN_NOWAIT" },
  { "uv_fs_event", 223, _cffi_prim_int(sizeof(enum uv_fs_event), ((enum uv_fs_event)-1) <= 0),
    "UV_RENAME,UV_CHANGE" },
  { "uv_fs_event_flags", 224, _cffi_prim_int(sizeof(enum uv_fs_event_flags), ((enum uv_fs_event_flags)-1) <= 0),
    "UV_FS_EVENT_WATCH_ENTRY,UV_FS_EVENT_STAT,UV_FS_EVENT_RECURSIVE" },
  { "uv_poll_event", 225, _cffi_prim_int(sizeof(enum uv_poll_event), ((enum uv_poll_event)-1) <= 0),
    "UV_READABLE,UV_WRITABLE,UV_DISCONNECT,UV_PRIORITIZED" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "GeventWatcherObject", 116 },
  { "gevent_fs_poll_t", 226 },
  { "uv_async_cb", 45 },
  { "uv_async_t", 229 },
  { "uv_check_cb", 16 },
  { "uv_check_t", 230 },
  { "uv_close_cb", 218 },
  { "uv_fs_event_cb", 28 },
  { "uv_fs_event_t", 231 },
  { "uv_fs_poll_cb", 128 },
  { "uv_fs_poll_t", 232 },
  { "uv_handle_t", 233 },
  { "uv_handle_type", 4 },
  { "uv_idle_cb", 37 },
  { "uv_idle_t", 234 },
  { "uv_loop_t", 235 },
  { "uv_poll_cb", 89 },
  { "uv_poll_t", 236 },
  { "uv_prepare_cb", 96 },
  { "uv_prepare_t", 237 },
  { "uv_run_mode", 70 },
  { "uv_signal_cb", 103 },
  { "uv_signal_t", 238 },
  { "uv_stat_t", 239 },
  { "uv_timer_cb", 111 },
  { "uv_timer_t", 240 },
  { "uv_timespec_t", 241 },
  { "uv_walk_cb", 187 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  120,  /* num_globals */
  14,  /* num_struct_unions */
  5,  /* num_enums */
  28,  /* num_typenames */
  NULL,  /* no includes */
  246,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__corecffi(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__corecffi(void) { return NULL; }
#  else
     init_corecffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__corecffi(void)
{
  return _cffi_init("gevent.libuv._corecffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_corecffi(void)
{
  _cffi_init("gevent.libuv._corecffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
