/* AUTOMATICALLY GENERATED by qapi-gen.py DO NOT MODIFY */

/*
 * Schema-defined QAPI/QMP commands
 *
 * Copyright IBM, Corp. 2011
 * Copyright (C) 2014-2018 Red Hat, Inc.
 *
 * This work is licensed under the terms of the GNU LGPL, version 2.1 or later.
 * See the COPYING.LIB file in the top-level directory.
 */

#include "qemu/osdep.h"
#include "qapi/compat-policy.h"
#include "qapi/visitor.h"
#include "qobject/qdict.h"
#include "qapi/dealloc-visitor.h"
#include "qapi/error.h"
#include "qapi-visit-machine.h"
#include "qapi-commands-machine.h"
#include "qobject/qjson.h"
#include "trace/trace-qapi_commands_machine_trace_events.h"

void qmp_marshal_query_cpus_fast(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    CpuInfoFastList *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_CPUS_FAST)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_cpus_fast(req_json->str);
    }

    retval = qmp_query_cpus_fast(&err);
    if (err) {
        trace_qmp_exit_query_cpus_fast(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_CpuInfoFastList(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_CpuInfoFastList(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_CPUS_FAST)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_cpus_fast(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_machines(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    MachineInfoList *retval;
    Visitor *ov;
    q_obj_query_machines_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_query_machines_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_MACHINES)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_machines(req_json->str);
    }

    retval = qmp_query_machines(arg.has_compat_props, arg.compat_props, &err);
    if (err) {
        trace_qmp_exit_query_machines(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_MachineInfoList(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_MachineInfoList(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_MACHINES)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_machines(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_query_machines_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_current_machine(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    CurrentMachineParams *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_CURRENT_MACHINE)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_current_machine(req_json->str);
    }

    retval = qmp_query_current_machine(&err);
    if (err) {
        trace_qmp_exit_query_current_machine(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_CurrentMachineParams(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_CurrentMachineParams(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_CURRENT_MACHINE)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_current_machine(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_target(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    QemuTargetInfo *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_TARGET)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_target(req_json->str);
    }

    retval = qmp_query_target(&err);
    if (err) {
        trace_qmp_exit_query_target(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_QemuTargetInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_QemuTargetInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_TARGET)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_target(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_uuid(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    UuidInfo *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_UUID)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_uuid(req_json->str);
    }

    retval = qmp_query_uuid(&err);
    if (err) {
        trace_qmp_exit_query_uuid(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_UuidInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_UuidInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_UUID)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_uuid(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_vm_generation_id(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    GuidInfo *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_VM_GENERATION_ID)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_vm_generation_id(req_json->str);
    }

    retval = qmp_query_vm_generation_id(&err);
    if (err) {
        trace_qmp_exit_query_vm_generation_id(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_GuidInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_GuidInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_VM_GENERATION_ID)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_vm_generation_id(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_system_reset(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_SYSTEM_RESET)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_system_reset(req_json->str);
    }

    qmp_system_reset(&err);
    if (err) {
        trace_qmp_exit_system_reset(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_system_reset("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_system_powerdown(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_SYSTEM_POWERDOWN)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_system_powerdown(req_json->str);
    }

    qmp_system_powerdown(&err);
    if (err) {
        trace_qmp_exit_system_powerdown(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_system_powerdown("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_system_wakeup(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_SYSTEM_WAKEUP)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_system_wakeup(req_json->str);
    }

    qmp_system_wakeup(&err);
    if (err) {
        trace_qmp_exit_system_wakeup(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_system_wakeup("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_inject_nmi(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_INJECT_NMI)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_inject_nmi(req_json->str);
    }

    qmp_inject_nmi(&err);
    if (err) {
        trace_qmp_exit_inject_nmi(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_inject_nmi("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_memsave(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    q_obj_memsave_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_memsave_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_MEMSAVE)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_memsave(req_json->str);
    }

    qmp_memsave(arg.val, arg.size, arg.filename, arg.has_cpu_index, arg.cpu_index, &err);
    if (err) {
        trace_qmp_exit_memsave(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_memsave("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_memsave_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_pmemsave(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    q_obj_pmemsave_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_pmemsave_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_PMEMSAVE)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_pmemsave(req_json->str);
    }

    qmp_pmemsave(arg.val, arg.size, arg.filename, &err);
    if (err) {
        trace_qmp_exit_pmemsave(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_pmemsave("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_pmemsave_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_memdev(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    MemdevList *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_MEMDEV)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_memdev(req_json->str);
    }

    retval = qmp_query_memdev(&err);
    if (err) {
        trace_qmp_exit_query_memdev(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_MemdevList(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_MemdevList(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_MEMDEV)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_memdev(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_hotpluggable_cpus(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HotpluggableCPUList *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_HOTPLUGGABLE_CPUS)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_hotpluggable_cpus(req_json->str);
    }

    retval = qmp_query_hotpluggable_cpus(&err);
    if (err) {
        trace_qmp_exit_query_hotpluggable_cpus(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HotpluggableCPUList(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HotpluggableCPUList(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_HOTPLUGGABLE_CPUS)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_hotpluggable_cpus(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_set_numa_node(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    NumaOptions arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_NumaOptions_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_SET_NUMA_NODE)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_set_numa_node(req_json->str);
    }

    qmp_set_numa_node(&arg, &err);
    if (err) {
        trace_qmp_exit_set_numa_node(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_set_numa_node("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_NumaOptions_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_balloon(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    q_obj_balloon_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_balloon_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_BALLOON)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_balloon(req_json->str);
    }

    qmp_balloon(arg.value, &err);
    if (err) {
        trace_qmp_exit_balloon(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_balloon("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_balloon_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_balloon(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    BalloonInfo *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_BALLOON)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_balloon(req_json->str);
    }

    retval = qmp_query_balloon(&err);
    if (err) {
        trace_qmp_exit_query_balloon(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_BalloonInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_BalloonInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_BALLOON)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_balloon(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_hv_balloon_status_report(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HvBalloonInfo *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_HV_BALLOON_STATUS_REPORT)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_hv_balloon_status_report(req_json->str);
    }

    retval = qmp_query_hv_balloon_status_report(&err);
    if (err) {
        trace_qmp_exit_query_hv_balloon_status_report(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HvBalloonInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HvBalloonInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_HV_BALLOON_STATUS_REPORT)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_hv_balloon_status_report(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_memory_size_summary(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    MemoryInfo *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_MEMORY_SIZE_SUMMARY)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_memory_size_summary(req_json->str);
    }

    retval = qmp_query_memory_size_summary(&err);
    if (err) {
        trace_qmp_exit_query_memory_size_summary(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_MemoryInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_MemoryInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_MEMORY_SIZE_SUMMARY)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_memory_size_summary(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_memory_devices(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    MemoryDeviceInfoList *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_MEMORY_DEVICES)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_memory_devices(req_json->str);
    }

    retval = qmp_query_memory_devices(&err);
    if (err) {
        trace_qmp_exit_query_memory_devices(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_MemoryDeviceInfoList(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_MemoryDeviceInfoList(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_MEMORY_DEVICES)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_memory_devices(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_x_query_irq(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HumanReadableText *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_X_QUERY_IRQ)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_x_query_irq(req_json->str);
    }

    retval = qmp_x_query_irq(&err);
    if (err) {
        trace_qmp_exit_x_query_irq(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HumanReadableText(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HumanReadableText(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_X_QUERY_IRQ)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_x_query_irq(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

#if defined(CONFIG_TCG)
void qmp_marshal_x_query_jit(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HumanReadableText *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_X_QUERY_JIT)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_x_query_jit(req_json->str);
    }

    retval = qmp_x_query_jit(&err);
    if (err) {
        trace_qmp_exit_x_query_jit(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HumanReadableText(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HumanReadableText(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_X_QUERY_JIT)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_x_query_jit(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}
#endif /* defined(CONFIG_TCG) */

void qmp_marshal_x_query_numa(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HumanReadableText *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_X_QUERY_NUMA)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_x_query_numa(req_json->str);
    }

    retval = qmp_x_query_numa(&err);
    if (err) {
        trace_qmp_exit_x_query_numa(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HumanReadableText(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HumanReadableText(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_X_QUERY_NUMA)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_x_query_numa(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_x_query_ramblock(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HumanReadableText *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_X_QUERY_RAMBLOCK)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_x_query_ramblock(req_json->str);
    }

    retval = qmp_x_query_ramblock(&err);
    if (err) {
        trace_qmp_exit_x_query_ramblock(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HumanReadableText(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HumanReadableText(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_X_QUERY_RAMBLOCK)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_x_query_ramblock(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_x_query_roms(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HumanReadableText *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_X_QUERY_ROMS)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_x_query_roms(req_json->str);
    }

    retval = qmp_x_query_roms(&err);
    if (err) {
        trace_qmp_exit_x_query_roms(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HumanReadableText(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HumanReadableText(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_X_QUERY_ROMS)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_x_query_roms(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_x_query_usb(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HumanReadableText *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_X_QUERY_USB)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_x_query_usb(req_json->str);
    }

    retval = qmp_x_query_usb(&err);
    if (err) {
        trace_qmp_exit_x_query_usb(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HumanReadableText(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HumanReadableText(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_X_QUERY_USB)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_x_query_usb(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

#if defined(CONFIG_FDT)
void qmp_marshal_dumpdtb(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    q_obj_dumpdtb_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_dumpdtb_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_DUMPDTB)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_dumpdtb(req_json->str);
    }

    qmp_dumpdtb(arg.filename, &err);
    if (err) {
        trace_qmp_exit_dumpdtb(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_dumpdtb("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_dumpdtb_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}
#endif /* defined(CONFIG_FDT) */

void qmp_marshal_x_query_interrupt_controllers(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    HumanReadableText *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_X_QUERY_INTERRUPT_CONTROLLERS)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_x_query_interrupt_controllers(req_json->str);
    }

    retval = qmp_x_query_interrupt_controllers(&err);
    if (err) {
        trace_qmp_exit_x_query_interrupt_controllers(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_HumanReadableText(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_HumanReadableText(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_X_QUERY_INTERRUPT_CONTROLLERS)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_x_query_interrupt_controllers(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_firmware_log(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    FirmwareLog *retval;
    Visitor *ov;
    q_obj_query_firmware_log_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_query_firmware_log_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_FIRMWARE_LOG)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_firmware_log(req_json->str);
    }

    retval = qmp_query_firmware_log(arg.has_max_size, arg.max_size, &err);
    if (err) {
        trace_qmp_exit_query_firmware_log(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_FirmwareLog(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_FirmwareLog(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_FIRMWARE_LOG)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_firmware_log(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_query_firmware_log_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_dump_skeys(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    q_obj_dump_skeys_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_dump_skeys_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_DUMP_SKEYS)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_dump_skeys(req_json->str);
    }

    qmp_dump_skeys(arg.filename, &err);
    if (err) {
        trace_qmp_exit_dump_skeys(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    trace_qmp_exit_dump_skeys("{}", true);

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_dump_skeys_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_cpu_model_comparison(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    CpuModelCompareInfo *retval;
    Visitor *ov;
    q_obj_query_cpu_model_comparison_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_query_cpu_model_comparison_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_CPU_MODEL_COMPARISON)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_cpu_model_comparison(req_json->str);
    }

    retval = qmp_query_cpu_model_comparison(arg.modela, arg.modelb, &err);
    if (err) {
        trace_qmp_exit_query_cpu_model_comparison(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_CpuModelCompareInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_CpuModelCompareInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_CPU_MODEL_COMPARISON)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_cpu_model_comparison(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_query_cpu_model_comparison_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_cpu_model_baseline(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    CpuModelBaselineInfo *retval;
    Visitor *ov;
    q_obj_query_cpu_model_baseline_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_query_cpu_model_baseline_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_CPU_MODEL_BASELINE)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_cpu_model_baseline(req_json->str);
    }

    retval = qmp_query_cpu_model_baseline(arg.modela, arg.modelb, &err);
    if (err) {
        trace_qmp_exit_query_cpu_model_baseline(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_CpuModelBaselineInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_CpuModelBaselineInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_CPU_MODEL_BASELINE)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_cpu_model_baseline(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_query_cpu_model_baseline_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_cpu_model_expansion(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    CpuModelExpansionInfo *retval;
    Visitor *ov;
    q_obj_query_cpu_model_expansion_arg arg = {0};

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    if (visit_type_q_obj_query_cpu_model_expansion_arg_members(v, &arg, errp)) {
        ok = visit_check_struct(v, errp);
    }
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_CPU_MODEL_EXPANSION)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_cpu_model_expansion(req_json->str);
    }

    retval = qmp_query_cpu_model_expansion(arg.type, arg.model, &err);
    if (err) {
        trace_qmp_exit_query_cpu_model_expansion(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_CpuModelExpansionInfo(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_CpuModelExpansionInfo(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_CPU_MODEL_EXPANSION)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_cpu_model_expansion(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_type_q_obj_query_cpu_model_expansion_arg_members(v, &arg, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

void qmp_marshal_query_cpu_definitions(QDict *args, QObject **ret, Error **errp)
{
    Error *err = NULL;
    bool ok = false;
    Visitor *v;
    CpuDefinitionInfoList *retval;
    Visitor *ov;

    v = qobject_input_visitor_new_qmp(QOBJECT(args));
    if (!visit_start_struct(v, NULL, NULL, 0, errp)) {
        goto out;
    }
    ok = visit_check_struct(v, errp);
    visit_end_struct(v, NULL);
    if (!ok) {
        goto out;
    }

    if (trace_event_get_state_backends(TRACE_QMP_ENTER_QUERY_CPU_DEFINITIONS)) {
        g_autoptr(GString) req_json = qobject_to_json(QOBJECT(args));

        trace_qmp_enter_query_cpu_definitions(req_json->str);
    }

    retval = qmp_query_cpu_definitions(&err);
    if (err) {
        trace_qmp_exit_query_cpu_definitions(error_get_pretty(err), false);
        error_propagate(errp, err);
        goto out;
    }

    ov = qobject_output_visitor_new_qmp(ret);
    if (visit_type_CpuDefinitionInfoList(ov, "unused", &retval, errp)) {
        visit_complete(ov, ret);
    }
    visit_free(ov);
    ov = qapi_dealloc_visitor_new();
    visit_type_CpuDefinitionInfoList(ov, "unused", &retval, NULL);
    visit_free(ov);

    if (trace_event_get_state_backends(TRACE_QMP_EXIT_QUERY_CPU_DEFINITIONS)) {
        g_autoptr(GString) ret_json = qobject_to_json(*ret);

        trace_qmp_exit_query_cpu_definitions(ret_json->str, true);
    }

out:
    visit_free(v);
    v = qapi_dealloc_visitor_new();
    visit_start_struct(v, NULL, NULL, 0, NULL);
    visit_end_struct(v, NULL);
    visit_free(v);
}

/* Dummy declaration to prevent empty .o file */
char qapi_dummy_qapi_commands_machine_c;
