// content/common/agent_scheduling_group.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_SHARED_INTERNAL_H_
#define CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "content/common/document_scoped_interface_bundle.mojom-shared-internal.h"
#include "content/common/native_types.mojom-shared-internal.h"
#include "ipc/constants.mojom-shared-internal.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace content {
namespace mojom {
namespace internal {
class CreateViewParams_Data;
class CreateFrameWidgetParams_Data;
class CreateFrameParams_Data;

struct ViewWidgetType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) CreateViewParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CreateViewParams_Data));
      new (data()) CreateViewParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CreateViewParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CreateViewParams_Data>(index_);
    }
    CreateViewParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::RendererPreferences_Data> renderer_preferences;
  mojo::internal::Pointer<::blink::mojom::internal::WebPreferences_Data> web_preferences;
  int32_t view_id;
  int32_t main_frame_routing_id;
  int32_t main_frame_widget_routing_id;
  mojo::internal::AssociatedEndpointHandle_Data frame_widget;
  mojo::internal::Pointer<::content::mojom::internal::DocumentScopedInterfaceBundle_Data> main_frame_interface_bundle;
  mojo::internal::AssociatedInterface_Data frame_widget_host;
  mojo::internal::AssociatedInterface_Data widget_host;
  mojo::internal::AssociatedEndpointHandle_Data widget;
  int32_t proxy_routing_id;
  mojo::internal::Pointer<mojo::internal::String_Data> session_storage_namespace_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> opener_frame_token;
  mojo::internal::Pointer<::content::mojom::internal::FrameReplicationState_Data> replicated_frame_state;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> main_frame_frame_token;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtools_main_frame_token;
  uint8_t hidden : 1;
  uint8_t never_composited : 1;
  uint8_t window_was_created_with_opener : 1;
  uint8_t has_committed_real_load : 1;
  uint8_t renderer_wide_named_frame_lookup : 1;
  uint8_t pad20_[3];
  int32_t type;
  mojo::internal::Pointer<::blink::mojom::internal::VisualProperties_Data> visual_properties;
  mojo::internal::AssociatedEndpointHandle_Data blink_page_broadcast;
  uint8_t padfinal_[4];

 private:
  CreateViewParams_Data();
  ~CreateViewParams_Data() = delete;
};
static_assert(sizeof(CreateViewParams_Data) == 136,
              "Bad sizeof(CreateViewParams_Data)");
// Used by CreateViewParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateViewParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateViewParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateViewParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CreateViewParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateViewParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) CreateFrameWidgetParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CreateFrameWidgetParams_Data));
      new (data()) CreateFrameWidgetParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CreateFrameWidgetParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CreateFrameWidgetParams_Data>(index_);
    }
    CreateFrameWidgetParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id;
  mojo::internal::AssociatedInterface_Data frame_widget_host;
  mojo::internal::AssociatedEndpointHandle_Data frame_widget;
  mojo::internal::AssociatedInterface_Data widget_host;
  mojo::internal::AssociatedEndpointHandle_Data widget;
  uint8_t pad4_[4];
  mojo::internal::Pointer<::blink::mojom::internal::VisualProperties_Data> visual_properties;

 private:
  CreateFrameWidgetParams_Data();
  ~CreateFrameWidgetParams_Data() = delete;
};
static_assert(sizeof(CreateFrameWidgetParams_Data) == 48,
              "Bad sizeof(CreateFrameWidgetParams_Data)");
// Used by CreateFrameWidgetParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateFrameWidgetParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateFrameWidgetParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateFrameWidgetParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CreateFrameWidgetParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateFrameWidgetParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) CreateFrameParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CreateFrameParams_Data));
      new (data()) CreateFrameParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CreateFrameParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CreateFrameParams_Data>(index_);
    }
    CreateFrameParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id;
  int32_t previous_routing_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> frame_token;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> opener_frame_token;
  int32_t parent_routing_id;
  int32_t previous_sibling_routing_id;
  mojo::internal::Pointer<::content::mojom::internal::DocumentScopedInterfaceBundle_Data> interface_bundle;
  mojo::internal::Pointer<::content::mojom::internal::FrameReplicationState_Data> replication_state;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtools_frame_token;
  mojo::internal::Pointer<::blink::mojom::internal::FrameOwnerProperties_Data> frame_owner_properties;
  mojo::internal::Pointer<internal::CreateFrameWidgetParams_Data> widget_params;
  uint8_t has_committed_real_load : 1;
  uint8_t padfinal_[7];

 private:
  CreateFrameParams_Data();
  ~CreateFrameParams_Data() = delete;
};
static_assert(sizeof(CreateFrameParams_Data) == 88,
              "Bad sizeof(CreateFrameParams_Data)");
// Used by CreateFrameParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateFrameParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateFrameParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateFrameParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CreateFrameParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateFrameParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_SHARED_INTERNAL_H_