// content/common/child_process.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_CHILD_PROCESS_MOJOM_H_
#define CONTENT_COMMON_CHILD_PROCESS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/child_process.mojom-shared.h"
#include "content/common/child_process.mojom-forward.h"
#include "ipc/ipc.mojom.h"
#include "mojo/public/mojom/base/file.mojom-forward.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom.h"
#include "services/service_manager/public/mojom/service.mojom.h"
#include "services/tracing/public/mojom/background_tracing_agent.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class ChildProcessHostProxy;

template <typename ImplRefTraits>
class ChildProcessHostStub;

class ChildProcessHostRequestValidator;


class CONTENT_EXPORT ChildProcessHost
    : public ChildProcessHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ChildProcessHostInterfaceBase;
  using Proxy_ = ChildProcessHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChildProcessHostStub<ImplRefTraits>;

  using RequestValidator_ = ChildProcessHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindHostReceiverMinVersion = 0,
  };
  virtual ~ChildProcessHost() {}

  
  virtual void BindHostReceiver(::mojo::GenericPendingReceiver receiver) = 0;
};

class ChildProcessProxy;

template <typename ImplRefTraits>
class ChildProcessStub;

class ChildProcessRequestValidator;


class CONTENT_EXPORT ChildProcess
    : public ChildProcessInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ChildProcessInterfaceBase;
  using Proxy_ = ChildProcessProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChildProcessStub<ImplRefTraits>;

  using RequestValidator_ = ChildProcessRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kProcessShutdownMinVersion = 0,
    kGetBackgroundTracingAgentProviderMinVersion = 0,
    kCrashHungProcessMinVersion = 0,
    kBootstrapLegacyIpcMinVersion = 0,
    kRunServiceMinVersion = 0,
    kBindServiceInterfaceMinVersion = 0,
    kBindReceiverMinVersion = 0,
  };
  virtual ~ChildProcess() {}

  
  virtual void ProcessShutdown() = 0;

  
  virtual void GetBackgroundTracingAgentProvider(::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> receiver) = 0;

  
  virtual void CrashHungProcess() = 0;

  
  virtual void BootstrapLegacyIpc(::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> receiver) = 0;

  
  virtual void RunService(const std::string& service_name, ::mojo::PendingReceiver<::service_manager::mojom::Service> receiver) = 0;

  
  virtual void BindServiceInterface(::mojo::GenericPendingReceiver receiver) = 0;

  
  virtual void BindReceiver(::mojo::GenericPendingReceiver receiver) = 0;
};



class CONTENT_EXPORT ChildProcessHostProxy
    : public ChildProcessHost {
 public:
  using InterfaceType = ChildProcessHost;

  explicit ChildProcessHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindHostReceiver(::mojo::GenericPendingReceiver receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT ChildProcessProxy
    : public ChildProcess {
 public:
  using InterfaceType = ChildProcess;

  explicit ChildProcessProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ProcessShutdown() final;
  
  void GetBackgroundTracingAgentProvider(::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> receiver) final;
  
  void CrashHungProcess() final;
  
  void BootstrapLegacyIpc(::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> receiver) final;
  
  void RunService(const std::string& service_name, ::mojo::PendingReceiver<::service_manager::mojom::Service> receiver) final;
  
  void BindServiceInterface(::mojo::GenericPendingReceiver receiver) final;
  
  void BindReceiver(::mojo::GenericPendingReceiver receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT ChildProcessHostStubDispatch {
 public:
  static bool Accept(ChildProcessHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChildProcessHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChildProcessHost>>
class ChildProcessHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChildProcessHostStub() {}
  ~ChildProcessHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT ChildProcessStubDispatch {
 public:
  static bool Accept(ChildProcess* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChildProcess* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChildProcess>>
class ChildProcessStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChildProcessStub() {}
  ~ChildProcessStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT ChildProcessHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT ChildProcessRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_CHILD_PROCESS_MOJOM_H_