// device/vr/public/mojom/browser_test_interfaces.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/vr/public/mojom/browser_test_interfaces.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "device/vr/public/mojom/browser_test_interfaces.mojom-params-data.h"
#include "device/vr/public/mojom/browser_test_interfaces.mojom-shared-message-ids.h"

#include "device/vr/public/mojom/browser_test_interfaces.mojom-import-headers.h"


#ifndef DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_JUMBO_H_
#define DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_JUMBO_H_
#endif
namespace device_test {
namespace mojom {
Color::Color()
    : r(),
      g(),
      b(),
      a() {}

Color::Color(
    uint8_t r_in,
    uint8_t g_in,
    uint8_t b_in,
    uint8_t a_in)
    : r(std::move(r_in)),
      g(std::move(g_in)),
      b(std::move(b_in)),
      a(std::move(a_in)) {}

Color::~Color() = default;
size_t Color::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->r);
  seed = mojo::internal::Hash(seed, this->g);
  seed = mojo::internal::Hash(seed, this->b);
  seed = mojo::internal::Hash(seed, this->a);
  return seed;
}

void Color::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("r", this->r);
  value->SetInteger("g", this->g);
  value->SetInteger("b", this->b);
  value->SetInteger("a", this->a);
}

bool Color::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubmittedFrameData::SubmittedFrameData()
    : color(),
      eye(),
      viewport(),
      image_size() {}

SubmittedFrameData::SubmittedFrameData(
    ColorPtr color_in,
    Eye eye_in,
    const ::gfx::Rect& viewport_in,
    const ::gfx::Size& image_size_in)
    : color(std::move(color_in)),
      eye(std::move(eye_in)),
      viewport(std::move(viewport_in)),
      image_size(std::move(image_size_in)) {}

SubmittedFrameData::~SubmittedFrameData() = default;

void SubmittedFrameData::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->color.is_null()) {
    value->SetString("color", "nullptr");
  } else {
    value->BeginDictionary("color");
    this->color->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("eye", base::trace_event::ValueToString(this->eye));
  value->SetString("viewport", base::trace_event::ValueToString(this->viewport, "<value of type const ::gfx::Rect&>"));
  value->SetString("image_size", base::trace_event::ValueToString(this->image_size, "<value of type const ::gfx::Size&>"));
}

bool SubmittedFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PoseFrameData::PoseFrameData()
    : device_to_origin() {}

PoseFrameData::PoseFrameData(
    const base::Optional<::gfx::Transform>& device_to_origin_in)
    : device_to_origin(std::move(device_to_origin_in)) {}

PoseFrameData::~PoseFrameData() = default;

void PoseFrameData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("device_to_origin", base::trace_event::ValueToString(this->device_to_origin, "<value of type const base::Optional<::gfx::Transform>&>"));
}

bool PoseFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProjectionRaw::ProjectionRaw()
    : left(),
      right(),
      top(),
      bottom() {}

ProjectionRaw::ProjectionRaw(
    float left_in,
    float right_in,
    float top_in,
    float bottom_in)
    : left(std::move(left_in)),
      right(std::move(right_in)),
      top(std::move(top_in)),
      bottom(std::move(bottom_in)) {}

ProjectionRaw::~ProjectionRaw() = default;
size_t ProjectionRaw::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->left);
  seed = mojo::internal::Hash(seed, this->right);
  seed = mojo::internal::Hash(seed, this->top);
  seed = mojo::internal::Hash(seed, this->bottom);
  return seed;
}

void ProjectionRaw::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetDouble("left", this->left);
  value->SetDouble("right", this->right);
  value->SetDouble("top", this->top);
  value->SetDouble("bottom", this->bottom);
}

bool ProjectionRaw::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeviceConfig::DeviceConfig()
    : interpupillary_distance(),
      projection_left(),
      projection_right() {}

DeviceConfig::DeviceConfig(
    float interpupillary_distance_in,
    ProjectionRawPtr projection_left_in,
    ProjectionRawPtr projection_right_in)
    : interpupillary_distance(std::move(interpupillary_distance_in)),
      projection_left(std::move(projection_left_in)),
      projection_right(std::move(projection_right_in)) {}

DeviceConfig::~DeviceConfig() = default;
size_t DeviceConfig::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->interpupillary_distance);
  seed = mojo::internal::Hash(seed, this->projection_left);
  seed = mojo::internal::Hash(seed, this->projection_right);
  return seed;
}

void DeviceConfig::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetDouble("interpupillary_distance", this->interpupillary_distance);
  if (this->projection_left.is_null()) {
    value->SetString("projection_left", "nullptr");
  } else {
    value->BeginDictionary("projection_left");
    this->projection_left->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->projection_right.is_null()) {
    value->SetString("projection_right", "nullptr");
  } else {
    value->BeginDictionary("projection_right");
    this->projection_right->AsValueInto(value);
    value->EndDictionary();
  }
}

bool DeviceConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ControllerAxisData::ControllerAxisData()
    : x(),
      y(),
      axis_type() {}

ControllerAxisData::ControllerAxisData(
    float x_in,
    float y_in,
    uint8_t axis_type_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      axis_type(std::move(axis_type_in)) {}

ControllerAxisData::~ControllerAxisData() = default;
size_t ControllerAxisData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->x);
  seed = mojo::internal::Hash(seed, this->y);
  seed = mojo::internal::Hash(seed, this->axis_type);
  return seed;
}

void ControllerAxisData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetDouble("x", this->x);
  value->SetDouble("y", this->y);
  value->SetInteger("axis_type", this->axis_type);
}

bool ControllerAxisData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ControllerFrameData::ControllerFrameData()
    : packet_number(),
      buttons_pressed(),
      buttons_touched(),
      supported_buttons(),
      axis_data(),
      pose_data(),
      role(ControllerRole::kControllerRoleInvalid),
      is_valid() {}

ControllerFrameData::ControllerFrameData(
    uint32_t packet_number_in,
    uint64_t buttons_pressed_in,
    uint64_t buttons_touched_in,
    uint64_t supported_buttons_in,
    std::vector<ControllerAxisDataPtr> axis_data_in,
    PoseFrameDataPtr pose_data_in,
    ControllerRole role_in,
    bool is_valid_in)
    : packet_number(std::move(packet_number_in)),
      buttons_pressed(std::move(buttons_pressed_in)),
      buttons_touched(std::move(buttons_touched_in)),
      supported_buttons(std::move(supported_buttons_in)),
      axis_data(std::move(axis_data_in)),
      pose_data(std::move(pose_data_in)),
      role(std::move(role_in)),
      is_valid(std::move(is_valid_in)) {}

ControllerFrameData::~ControllerFrameData() = default;

void ControllerFrameData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("packet_number", base::NumberToString(this->packet_number));
  value->SetString("buttons_pressed", base::NumberToString(this->buttons_pressed));
  value->SetString("buttons_touched", base::NumberToString(this->buttons_touched));
  value->SetString("supported_buttons", base::NumberToString(this->supported_buttons));
  value->BeginArray("axis_data");
  for (const auto& item0 : this->axis_data) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  if (this->pose_data.is_null()) {
    value->SetString("pose_data", "nullptr");
  } else {
    value->BeginDictionary("pose_data");
    this->pose_data->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("role", base::trace_event::ValueToString(this->role));
  value->SetBoolean("is_valid", this->is_valid);
}

bool ControllerFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EventData::EventData()
    : type(EventType::kNoEvent),
      interaction_profile(InteractionProfileType::kInvalid) {}

EventData::EventData(
    EventType type_in,
    InteractionProfileType interaction_profile_in)
    : type(std::move(type_in)),
      interaction_profile(std::move(interaction_profile_in)) {}

EventData::~EventData() = default;
size_t EventData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->interaction_profile);
  return seed;
}

void EventData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetString("interaction_profile", base::trace_event::ValueToString(this->interaction_profile));
}

bool EventData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char XRTestHook::Name_[] = "device_test.mojom.XRTestHook";
bool XRTestHook::OnFrameSubmitted(SubmittedFrameDataPtr frame_data) {
  NOTREACHED();
  return false;
}
bool XRTestHook::WaitGetDeviceConfig(DeviceConfigPtr* out_config) {
  NOTREACHED();
  return false;
}
bool XRTestHook::WaitGetPresentingPose(PoseFrameDataPtr* out_data) {
  NOTREACHED();
  return false;
}
bool XRTestHook::WaitGetMagicWindowPose(PoseFrameDataPtr* out_data) {
  NOTREACHED();
  return false;
}
bool XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex(uint32_t index, ControllerRole* out_role) {
  NOTREACHED();
  return false;
}
bool XRTestHook::WaitGetTrackedDeviceClass(uint32_t index, TrackedDeviceClass* out_device_class) {
  NOTREACHED();
  return false;
}
bool XRTestHook::WaitGetControllerData(uint32_t index, ControllerFrameDataPtr* out_data) {
  NOTREACHED();
  return false;
}
bool XRTestHook::WaitGetEventData(EventDataPtr* out_data) {
  NOTREACHED();
  return false;
}
class XRTestHook_OnFrameSubmitted_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_OnFrameSubmitted_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(XRTestHook_OnFrameSubmitted_HandleSyncResponse);
};

class XRTestHook_OnFrameSubmitted_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_OnFrameSubmitted_ForwardToCallback(
      XRTestHook::OnFrameSubmittedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::OnFrameSubmittedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRTestHook_OnFrameSubmitted_ForwardToCallback);
};
class XRTestHook_WaitGetDeviceConfig_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetDeviceConfig_HandleSyncResponse(
      bool* result, DeviceConfigPtr* out_config)
      : result_(result), out_config_(out_config) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  DeviceConfigPtr* out_config_;DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetDeviceConfig_HandleSyncResponse);
};

class XRTestHook_WaitGetDeviceConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetDeviceConfig_ForwardToCallback(
      XRTestHook::WaitGetDeviceConfigCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetDeviceConfigCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetDeviceConfig_ForwardToCallback);
};
class XRTestHook_WaitGetPresentingPose_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetPresentingPose_HandleSyncResponse(
      bool* result, PoseFrameDataPtr* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PoseFrameDataPtr* out_data_;DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetPresentingPose_HandleSyncResponse);
};

class XRTestHook_WaitGetPresentingPose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetPresentingPose_ForwardToCallback(
      XRTestHook::WaitGetPresentingPoseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetPresentingPoseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetPresentingPose_ForwardToCallback);
};
class XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse(
      bool* result, PoseFrameDataPtr* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PoseFrameDataPtr* out_data_;DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse);
};

class XRTestHook_WaitGetMagicWindowPose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetMagicWindowPose_ForwardToCallback(
      XRTestHook::WaitGetMagicWindowPoseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetMagicWindowPoseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetMagicWindowPose_ForwardToCallback);
};
class XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse(
      bool* result, ControllerRole* out_role)
      : result_(result), out_role_(out_role) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ControllerRole* out_role_;DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse);
};

class XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback(
      XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback);
};
class XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse(
      bool* result, TrackedDeviceClass* out_device_class)
      : result_(result), out_device_class_(out_device_class) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  TrackedDeviceClass* out_device_class_;DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse);
};

class XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback(
      XRTestHook::WaitGetTrackedDeviceClassCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetTrackedDeviceClassCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback);
};
class XRTestHook_WaitGetControllerData_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetControllerData_HandleSyncResponse(
      bool* result, ControllerFrameDataPtr* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ControllerFrameDataPtr* out_data_;DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetControllerData_HandleSyncResponse);
};

class XRTestHook_WaitGetControllerData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetControllerData_ForwardToCallback(
      XRTestHook::WaitGetControllerDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetControllerDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetControllerData_ForwardToCallback);
};
class XRTestHook_WaitGetEventData_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetEventData_HandleSyncResponse(
      bool* result, EventDataPtr* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  EventDataPtr* out_data_;DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetEventData_HandleSyncResponse);
};

class XRTestHook_WaitGetEventData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetEventData_ForwardToCallback(
      XRTestHook::WaitGetEventDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetEventDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetEventData_ForwardToCallback);
};

XRTestHookProxy::XRTestHookProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool XRTestHookProxy::OnFrameSubmitted(
    SubmittedFrameDataPtr param_frame_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "device_test::mojom::XRTestHook::OnFrameSubmitted", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (param_frame_data.is_null()) {
        raw_value->SetString("frame_data", "nullptr");
      } else {
        raw_value->BeginDictionary("frame_data");
        param_frame_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_OnFrameSubmitted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_OnFrameSubmitted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_data)::BaseType::BufferWriter
      frame_data_writer;
  mojo::internal::Serialize<::device_test::mojom::SubmittedFrameDataDataView>(
      param_frame_data, buffer, &frame_data_writer, &serialization_context);
  params->frame_data.Set(
      frame_data_writer.is_null() ? nullptr : frame_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_data in XRTestHook.OnFrameSubmitted request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("OnFrameSubmitted");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_OnFrameSubmitted_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "device_test::mojom::XRTestHook::OnFrameSubmitted");
#endif
  return result;
}

void XRTestHookProxy::OnFrameSubmitted(
    SubmittedFrameDataPtr in_frame_data, OnFrameSubmittedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device_test::mojom::XRTestHook::OnFrameSubmitted", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_frame_data.is_null()) {
        raw_value->SetString("frame_data", "nullptr");
      } else {
        raw_value->BeginDictionary("frame_data");
        in_frame_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_OnFrameSubmitted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_OnFrameSubmitted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_data)::BaseType::BufferWriter
      frame_data_writer;
  mojo::internal::Serialize<::device_test::mojom::SubmittedFrameDataDataView>(
      in_frame_data, buffer, &frame_data_writer, &serialization_context);
  params->frame_data.Set(
      frame_data_writer.is_null() ? nullptr : frame_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_data in XRTestHook.OnFrameSubmitted request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("OnFrameSubmitted");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_OnFrameSubmitted_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool XRTestHookProxy::WaitGetDeviceConfig(
    DeviceConfigPtr* out_param_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "device_test::mojom::XRTestHook::WaitGetDeviceConfig");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetDeviceConfig_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetDeviceConfig_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetDeviceConfig");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetDeviceConfig_HandleSyncResponse(
          &result, out_param_config));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetDeviceConfig", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_config) {
        if ((*out_param_config).is_null()) {
          raw_value->SetString("config", "nullptr");
        } else {
          raw_value->BeginDictionary("config");
          (*out_param_config)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("config", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void XRTestHookProxy::WaitGetDeviceConfig(
    WaitGetDeviceConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device_test::mojom::XRTestHook::WaitGetDeviceConfig");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetDeviceConfig_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetDeviceConfig_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetDeviceConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetDeviceConfig_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool XRTestHookProxy::WaitGetPresentingPose(
    PoseFrameDataPtr* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "device_test::mojom::XRTestHook::WaitGetPresentingPose");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetPresentingPose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetPresentingPose_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetPresentingPose");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetPresentingPose_HandleSyncResponse(
          &result, out_param_data));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetPresentingPose", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_data) {
        if ((*out_param_data).is_null()) {
          raw_value->SetString("data", "nullptr");
        } else {
          raw_value->BeginDictionary("data");
          (*out_param_data)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("data", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void XRTestHookProxy::WaitGetPresentingPose(
    WaitGetPresentingPoseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device_test::mojom::XRTestHook::WaitGetPresentingPose");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetPresentingPose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetPresentingPose_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetPresentingPose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetPresentingPose_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool XRTestHookProxy::WaitGetMagicWindowPose(
    PoseFrameDataPtr* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "device_test::mojom::XRTestHook::WaitGetMagicWindowPose");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetMagicWindowPose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetMagicWindowPose_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetMagicWindowPose");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse(
          &result, out_param_data));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetMagicWindowPose", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_data) {
        if ((*out_param_data).is_null()) {
          raw_value->SetString("data", "nullptr");
        } else {
          raw_value->BeginDictionary("data");
          (*out_param_data)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("data", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void XRTestHookProxy::WaitGetMagicWindowPose(
    WaitGetMagicWindowPoseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device_test::mojom::XRTestHook::WaitGetMagicWindowPose");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetMagicWindowPose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetMagicWindowPose_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetMagicWindowPose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetMagicWindowPose_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool XRTestHookProxy::WaitGetControllerRoleForTrackedDeviceIndex(
    uint32_t param_index, ControllerRole* out_param_role) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("index", base::NumberToString(param_index));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->index = param_index;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerRoleForTrackedDeviceIndex");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse(
          &result, out_param_role));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_role) {
        raw_value->SetString("role", base::trace_event::ValueToString((*out_param_role)));
      } else {
        raw_value->SetString("role", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void XRTestHookProxy::WaitGetControllerRoleForTrackedDeviceIndex(
    uint32_t in_index, WaitGetControllerRoleForTrackedDeviceIndexCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("index", base::NumberToString(in_index));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->index = in_index;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerRoleForTrackedDeviceIndex");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool XRTestHookProxy::WaitGetTrackedDeviceClass(
    uint32_t param_index, TrackedDeviceClass* out_param_device_class) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("index", base::NumberToString(param_index));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetTrackedDeviceClass_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->index = param_index;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetTrackedDeviceClass");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse(
          &result, out_param_device_class));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_device_class) {
        raw_value->SetString("device_class", base::trace_event::ValueToString((*out_param_device_class)));
      } else {
        raw_value->SetString("device_class", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void XRTestHookProxy::WaitGetTrackedDeviceClass(
    uint32_t in_index, WaitGetTrackedDeviceClassCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("index", base::NumberToString(in_index));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetTrackedDeviceClass_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->index = in_index;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetTrackedDeviceClass");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool XRTestHookProxy::WaitGetControllerData(
    uint32_t param_index, ControllerFrameDataPtr* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetControllerData", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("index", base::NumberToString(param_index));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetControllerData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetControllerData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->index = param_index;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerData");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetControllerData_HandleSyncResponse(
          &result, out_param_data));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetControllerData", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_data) {
        if ((*out_param_data).is_null()) {
          raw_value->SetString("data", "nullptr");
        } else {
          raw_value->BeginDictionary("data");
          (*out_param_data)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("data", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void XRTestHookProxy::WaitGetControllerData(
    uint32_t in_index, WaitGetControllerDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetControllerData", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("index", base::NumberToString(in_index));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetControllerData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetControllerData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->index = in_index;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetControllerData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool XRTestHookProxy::WaitGetEventData(
    EventDataPtr* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "device_test::mojom::XRTestHook::WaitGetEventData");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetEventData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetEventData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetEventData");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetEventData_HandleSyncResponse(
          &result, out_param_data));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device_test::mojom::XRTestHook::WaitGetEventData", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_data) {
        if ((*out_param_data).is_null()) {
          raw_value->SetString("data", "nullptr");
        } else {
          raw_value->BeginDictionary("data");
          (*out_param_data)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("data", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void XRTestHookProxy::WaitGetEventData(
    WaitGetEventDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device_test::mojom::XRTestHook::WaitGetEventData");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetEventData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetEventData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetEventData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetEventData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class XRTestHook_OnFrameSubmitted_ProxyToResponder {
 public:
  static XRTestHook::OnFrameSubmittedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRTestHook_OnFrameSubmitted_ProxyToResponder> proxy(
        new XRTestHook_OnFrameSubmitted_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRTestHook_OnFrameSubmitted_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_OnFrameSubmitted_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRTestHook_OnFrameSubmitted_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRTestHook::OnFrameSubmittedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRTestHook_OnFrameSubmitted_ProxyToResponder);
};

bool XRTestHook_OnFrameSubmitted_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRTestHook::OnFrameSubmittedCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  XRTestHook_OnFrameSubmitted_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void XRTestHook_OnFrameSubmitted_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device_test::mojom::XRTestHook::OnFrameSubmittedCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_OnFrameSubmitted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRTestHook::OnFrameSubmittedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("OnFrameSubmitted");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_OnFrameSubmitted_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  XRTestHook_OnFrameSubmitted_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 0, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetDeviceConfig_ProxyToResponder {
 public:
  static XRTestHook::WaitGetDeviceConfigCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRTestHook_WaitGetDeviceConfig_ProxyToResponder> proxy(
        new XRTestHook_WaitGetDeviceConfig_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRTestHook_WaitGetDeviceConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetDeviceConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRTestHook_WaitGetDeviceConfig_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRTestHook::WaitGetDeviceConfigCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceConfigPtr in_config);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetDeviceConfig_ProxyToResponder);
};

bool XRTestHook_WaitGetDeviceConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRTestHook::WaitGetDeviceConfigCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  DeviceConfigPtr p_config{};
  XRTestHook_WaitGetDeviceConfig_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_config));
  return true;
}

void XRTestHook_WaitGetDeviceConfig_ProxyToResponder::Run(
    DeviceConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetDeviceConfigCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_config.is_null()) {
        raw_value->SetString("config", "nullptr");
      } else {
        raw_value->BeginDictionary("config");
        in_config->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetDeviceConfig_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->config)::BaseType::BufferWriter
      config_writer;
  mojo::internal::Serialize<::device_test::mojom::DeviceConfigDataView>(
      in_config, buffer, &config_writer, &serialization_context);
  params->config.Set(
      config_writer.is_null() ? nullptr : config_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetDeviceConfigCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetDeviceConfig");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetDeviceConfig_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  DeviceConfigPtr p_config{};
  XRTestHook_WaitGetDeviceConfig_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 1, true);
    return false;
  }
  *out_config_ = std::move(p_config);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetPresentingPose_ProxyToResponder {
 public:
  static XRTestHook::WaitGetPresentingPoseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRTestHook_WaitGetPresentingPose_ProxyToResponder> proxy(
        new XRTestHook_WaitGetPresentingPose_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRTestHook_WaitGetPresentingPose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetPresentingPose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRTestHook_WaitGetPresentingPose_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRTestHook::WaitGetPresentingPoseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PoseFrameDataPtr in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetPresentingPose_ProxyToResponder);
};

bool XRTestHook_WaitGetPresentingPose_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRTestHook::WaitGetPresentingPoseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PoseFrameDataPtr p_data{};
  XRTestHook_WaitGetPresentingPose_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void XRTestHook_WaitGetPresentingPose_ProxyToResponder::Run(
    PoseFrameDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetPresentingPoseCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_data.is_null()) {
        raw_value->SetString("data", "nullptr");
      } else {
        raw_value->BeginDictionary("data");
        in_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetPresentingPose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data)::BaseType::BufferWriter
      data_writer;
  mojo::internal::Serialize<::device_test::mojom::PoseFrameDataDataView>(
      in_data, buffer, &data_writer, &serialization_context);
  params->data.Set(
      data_writer.is_null() ? nullptr : data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetPresentingPoseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetPresentingPose");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetPresentingPose_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PoseFrameDataPtr p_data{};
  XRTestHook_WaitGetPresentingPose_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 2, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetMagicWindowPose_ProxyToResponder {
 public:
  static XRTestHook::WaitGetMagicWindowPoseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRTestHook_WaitGetMagicWindowPose_ProxyToResponder> proxy(
        new XRTestHook_WaitGetMagicWindowPose_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRTestHook_WaitGetMagicWindowPose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetMagicWindowPose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRTestHook_WaitGetMagicWindowPose_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRTestHook::WaitGetMagicWindowPoseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PoseFrameDataPtr in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetMagicWindowPose_ProxyToResponder);
};

bool XRTestHook_WaitGetMagicWindowPose_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRTestHook::WaitGetMagicWindowPoseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PoseFrameDataPtr p_data{};
  XRTestHook_WaitGetMagicWindowPose_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void XRTestHook_WaitGetMagicWindowPose_ProxyToResponder::Run(
    PoseFrameDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetMagicWindowPoseCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_data.is_null()) {
        raw_value->SetString("data", "nullptr");
      } else {
        raw_value->BeginDictionary("data");
        in_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetMagicWindowPose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data)::BaseType::BufferWriter
      data_writer;
  mojo::internal::Serialize<::device_test::mojom::PoseFrameDataDataView>(
      in_data, buffer, &data_writer, &serialization_context);
  params->data.Set(
      data_writer.is_null() ? nullptr : data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetMagicWindowPoseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetMagicWindowPose");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PoseFrameDataPtr p_data{};
  XRTestHook_WaitGetMagicWindowPose_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 3, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder {
 public:
  static XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder> proxy(
        new XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ControllerRole in_role);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder);
};

bool XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ControllerRole p_role{};
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadRole(&p_role))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_role));
  return true;
}

void XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder::Run(
    ControllerRole in_role) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("role", base::trace_event::ValueToString(in_role));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::device_test::mojom::ControllerRole>(
      in_role, &params->role);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerRoleForTrackedDeviceIndex");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ControllerRole p_role{};
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadRole(&p_role))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 4, true);
    return false;
  }
  *out_role_ = std::move(p_role);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder {
 public:
  static XRTestHook::WaitGetTrackedDeviceClassCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder> proxy(
        new XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRTestHook::WaitGetTrackedDeviceClassCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      TrackedDeviceClass in_device_class);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder);
};

bool XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRTestHook::WaitGetTrackedDeviceClassCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  TrackedDeviceClass p_device_class{};
  XRTestHook_WaitGetTrackedDeviceClass_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadDeviceClass(&p_device_class))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_device_class));
  return true;
}

void XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder::Run(
    TrackedDeviceClass in_device_class) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetTrackedDeviceClassCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("device_class", base::trace_event::ValueToString(in_device_class));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetTrackedDeviceClass_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::device_test::mojom::TrackedDeviceClass>(
      in_device_class, &params->device_class);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetTrackedDeviceClassCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetTrackedDeviceClass");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  TrackedDeviceClass p_device_class{};
  XRTestHook_WaitGetTrackedDeviceClass_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadDeviceClass(&p_device_class))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 5, true);
    return false;
  }
  *out_device_class_ = std::move(p_device_class);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetControllerData_ProxyToResponder {
 public:
  static XRTestHook::WaitGetControllerDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRTestHook_WaitGetControllerData_ProxyToResponder> proxy(
        new XRTestHook_WaitGetControllerData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRTestHook_WaitGetControllerData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetControllerData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRTestHook_WaitGetControllerData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRTestHook::WaitGetControllerDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ControllerFrameDataPtr in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetControllerData_ProxyToResponder);
};

bool XRTestHook_WaitGetControllerData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRTestHook::WaitGetControllerDataCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetControllerData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetControllerData_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ControllerFrameDataPtr p_data{};
  XRTestHook_WaitGetControllerData_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void XRTestHook_WaitGetControllerData_ProxyToResponder::Run(
    ControllerFrameDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetControllerDataCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_data.is_null()) {
        raw_value->SetString("data", "nullptr");
      } else {
        raw_value->BeginDictionary("data");
        in_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetControllerData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetControllerData_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data)::BaseType::BufferWriter
      data_writer;
  mojo::internal::Serialize<::device_test::mojom::ControllerFrameDataDataView>(
      in_data, buffer, &data_writer, &serialization_context);
  params->data.Set(
      data_writer.is_null() ? nullptr : data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetControllerDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetControllerData_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetControllerData_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetControllerData_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ControllerFrameDataPtr p_data{};
  XRTestHook_WaitGetControllerData_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 6, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetEventData_ProxyToResponder {
 public:
  static XRTestHook::WaitGetEventDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRTestHook_WaitGetEventData_ProxyToResponder> proxy(
        new XRTestHook_WaitGetEventData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRTestHook_WaitGetEventData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetEventData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRTestHook_WaitGetEventData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRTestHook::WaitGetEventDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      EventDataPtr in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRTestHook_WaitGetEventData_ProxyToResponder);
};

bool XRTestHook_WaitGetEventData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRTestHook::WaitGetEventDataCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetEventData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetEventData_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  EventDataPtr p_data{};
  XRTestHook_WaitGetEventData_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void XRTestHook_WaitGetEventData_ProxyToResponder::Run(
    EventDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetEventDataCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_data.is_null()) {
        raw_value->SetString("data", "nullptr");
      } else {
        raw_value->BeginDictionary("data");
        in_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRTestHook_WaitGetEventData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRTestHook_WaitGetEventData_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data)::BaseType::BufferWriter
      data_writer;
  mojo::internal::Serialize<::device_test::mojom::EventDataDataView>(
      in_data, buffer, &data_writer, &serialization_context);
  params->data.Set(
      data_writer.is_null() ? nullptr : data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRTestHook::WaitGetEventDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetEventData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetEventData_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetEventData_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetEventData_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  EventDataPtr p_data{};
  XRTestHook_WaitGetEventData_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 7, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool XRTestHookStubDispatch::Accept(
    XRTestHook* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kXRTestHook_OnFrameSubmitted_Name: {
      break;
    }
    case internal::kXRTestHook_WaitGetDeviceConfig_Name: {
      break;
    }
    case internal::kXRTestHook_WaitGetPresentingPose_Name: {
      break;
    }
    case internal::kXRTestHook_WaitGetMagicWindowPose_Name: {
      break;
    }
    case internal::kXRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Name: {
      break;
    }
    case internal::kXRTestHook_WaitGetTrackedDeviceClass_Name: {
      break;
    }
    case internal::kXRTestHook_WaitGetControllerData_Name: {
      break;
    }
    case internal::kXRTestHook_WaitGetEventData_Name: {
      break;
    }
  }
  return false;
}

// static
bool XRTestHookStubDispatch::AcceptWithResponder(
    XRTestHook* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRTestHook_OnFrameSubmitted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRTestHook::OnFrameSubmitted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRTestHook::OnFrameSubmitted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRTestHook_OnFrameSubmitted_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_OnFrameSubmitted_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SubmittedFrameDataPtr p_frame_data{};
      XRTestHook_OnFrameSubmitted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameData(&p_frame_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 0, false);
        return false;
      }
      XRTestHook::OnFrameSubmittedCallback callback =
          XRTestHook_OnFrameSubmitted_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameSubmitted(
std::move(p_frame_data), std::move(callback));
      return true;
    }
    case internal::kXRTestHook_WaitGetDeviceConfig_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRTestHook::WaitGetDeviceConfig",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRTestHook::WaitGetDeviceConfig");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRTestHook_WaitGetDeviceConfig_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetDeviceConfig_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRTestHook_WaitGetDeviceConfig_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 1, false);
        return false;
      }
      XRTestHook::WaitGetDeviceConfigCallback callback =
          XRTestHook_WaitGetDeviceConfig_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetDeviceConfig(std::move(callback));
      return true;
    }
    case internal::kXRTestHook_WaitGetPresentingPose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRTestHook::WaitGetPresentingPose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRTestHook::WaitGetPresentingPose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRTestHook_WaitGetPresentingPose_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetPresentingPose_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRTestHook_WaitGetPresentingPose_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 2, false);
        return false;
      }
      XRTestHook::WaitGetPresentingPoseCallback callback =
          XRTestHook_WaitGetPresentingPose_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetPresentingPose(std::move(callback));
      return true;
    }
    case internal::kXRTestHook_WaitGetMagicWindowPose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRTestHook::WaitGetMagicWindowPose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRTestHook::WaitGetMagicWindowPose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRTestHook_WaitGetMagicWindowPose_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetMagicWindowPose_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRTestHook_WaitGetMagicWindowPose_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 3, false);
        return false;
      }
      XRTestHook::WaitGetMagicWindowPoseCallback callback =
          XRTestHook_WaitGetMagicWindowPose_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetMagicWindowPose(std::move(callback));
      return true;
    }
    case internal::kXRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_index{};
      XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 4, false);
        return false;
      }
      XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback callback =
          XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetControllerRoleForTrackedDeviceIndex(
std::move(p_index), std::move(callback));
      return true;
    }
    case internal::kXRTestHook_WaitGetTrackedDeviceClass_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_index{};
      XRTestHook_WaitGetTrackedDeviceClass_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 5, false);
        return false;
      }
      XRTestHook::WaitGetTrackedDeviceClassCallback callback =
          XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetTrackedDeviceClass(
std::move(p_index), std::move(callback));
      return true;
    }
    case internal::kXRTestHook_WaitGetControllerData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRTestHook::WaitGetControllerData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRTestHook::WaitGetControllerData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRTestHook_WaitGetControllerData_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetControllerData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_index{};
      XRTestHook_WaitGetControllerData_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 6, false);
        return false;
      }
      XRTestHook::WaitGetControllerDataCallback callback =
          XRTestHook_WaitGetControllerData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetControllerData(
std::move(p_index), std::move(callback));
      return true;
    }
    case internal::kXRTestHook_WaitGetEventData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRTestHook::WaitGetEventData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRTestHook::WaitGetEventData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRTestHook_WaitGetEventData_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetEventData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRTestHook_WaitGetEventData_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 7, false);
        return false;
      }
      XRTestHook::WaitGetEventDataCallback callback =
          XRTestHook_WaitGetEventData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetEventData(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRTestHookValidationInfo[] = {
    {internal::kXRTestHook_OnFrameSubmitted_Name,
     {&internal::XRTestHook_OnFrameSubmitted_Params_Data::Validate,
      &internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data::Validate}},
    {internal::kXRTestHook_WaitGetDeviceConfig_Name,
     {&internal::XRTestHook_WaitGetDeviceConfig_Params_Data::Validate,
      &internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data::Validate}},
    {internal::kXRTestHook_WaitGetPresentingPose_Name,
     {&internal::XRTestHook_WaitGetPresentingPose_Params_Data::Validate,
      &internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data::Validate}},
    {internal::kXRTestHook_WaitGetMagicWindowPose_Name,
     {&internal::XRTestHook_WaitGetMagicWindowPose_Params_Data::Validate,
      &internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data::Validate}},
    {internal::kXRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Name,
     {&internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data::Validate,
      &internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data::Validate}},
    {internal::kXRTestHook_WaitGetTrackedDeviceClass_Name,
     {&internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data::Validate,
      &internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data::Validate}},
    {internal::kXRTestHook_WaitGetControllerData_Name,
     {&internal::XRTestHook_WaitGetControllerData_Params_Data::Validate,
      &internal::XRTestHook_WaitGetControllerData_ResponseParams_Data::Validate}},
    {internal::kXRTestHook_WaitGetEventData_Name,
     {&internal::XRTestHook_WaitGetEventData_Params_Data::Validate,
      &internal::XRTestHook_WaitGetEventData_ResponseParams_Data::Validate}},
};

bool XRTestHookRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device_test::mojom::XRTestHook::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRTestHookValidationInfo);
}

bool XRTestHookResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device_test::mojom::XRTestHook::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kXRTestHookValidationInfo);

}
const char XRServiceTestHook::Name_[] = "device_test.mojom.XRServiceTestHook";
bool XRServiceTestHook::SetTestHook(::mojo::PendingRemote<XRTestHook> hook) {
  NOTREACHED();
  return false;
}
bool XRServiceTestHook::TerminateDeviceServiceProcessForTesting() {
  NOTREACHED();
  return false;
}
class XRServiceTestHook_SetTestHook_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRServiceTestHook_SetTestHook_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(XRServiceTestHook_SetTestHook_HandleSyncResponse);
};

class XRServiceTestHook_SetTestHook_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRServiceTestHook_SetTestHook_ForwardToCallback(
      XRServiceTestHook::SetTestHookCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRServiceTestHook::SetTestHookCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRServiceTestHook_SetTestHook_ForwardToCallback);
};
class XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse);
};

class XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback(
      XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback);
};

XRServiceTestHookProxy::XRServiceTestHookProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool XRServiceTestHookProxy::SetTestHook(
    ::mojo::PendingRemote<XRTestHook> param_hook) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "device_test::mojom::XRServiceTestHook::SetTestHook", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("hook", param_hook.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRServiceTestHook_SetTestHook_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRServiceTestHook_SetTestHook_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device_test::mojom::XRTestHookInterfaceBase>>(
      param_hook, &params->hook, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("SetTestHook");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRServiceTestHook_SetTestHook_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "device_test::mojom::XRServiceTestHook::SetTestHook");
#endif
  return result;
}

void XRServiceTestHookProxy::SetTestHook(
    ::mojo::PendingRemote<XRTestHook> in_hook, SetTestHookCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device_test::mojom::XRServiceTestHook::SetTestHook", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("hook", in_hook.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRServiceTestHook_SetTestHook_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRServiceTestHook_SetTestHook_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device_test::mojom::XRTestHookInterfaceBase>>(
      in_hook, &params->hook, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("SetTestHook");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRServiceTestHook_SetTestHook_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool XRServiceTestHookProxy::TerminateDeviceServiceProcessForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRServiceTestHook_TerminateDeviceServiceProcessForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("TerminateDeviceServiceProcessForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting");
#endif
  return result;
}

void XRServiceTestHookProxy::TerminateDeviceServiceProcessForTesting(
    TerminateDeviceServiceProcessForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRServiceTestHook_TerminateDeviceServiceProcessForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("TerminateDeviceServiceProcessForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class XRServiceTestHook_SetTestHook_ProxyToResponder {
 public:
  static XRServiceTestHook::SetTestHookCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRServiceTestHook_SetTestHook_ProxyToResponder> proxy(
        new XRServiceTestHook_SetTestHook_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRServiceTestHook_SetTestHook_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRServiceTestHook_SetTestHook_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRServiceTestHook_SetTestHook_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRServiceTestHook::SetTestHookCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRServiceTestHook_SetTestHook_ProxyToResponder);
};

bool XRServiceTestHook_SetTestHook_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRServiceTestHook::SetTestHookCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRServiceTestHook_SetTestHook_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRServiceTestHook_SetTestHook_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  XRServiceTestHook_SetTestHook_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRServiceTestHook::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void XRServiceTestHook_SetTestHook_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device_test::mojom::XRServiceTestHook::SetTestHookCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRServiceTestHook_SetTestHook_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRServiceTestHook_SetTestHook_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRServiceTestHook::SetTestHookCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("SetTestHook");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRServiceTestHook_SetTestHook_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRServiceTestHook_SetTestHook_ResponseParams_Data* params =
      reinterpret_cast<internal::XRServiceTestHook_SetTestHook_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  XRServiceTestHook_SetTestHook_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRServiceTestHook::Name_, 0, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder {
 public:
  static XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder> proxy(
        new XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder);
};

bool XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRServiceTestHook::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRServiceTestHook_TerminateDeviceServiceProcessForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device_test::mojom::internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("TerminateDeviceServiceProcessForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRServiceTestHook::Name_, 1, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool XRServiceTestHookStubDispatch::Accept(
    XRServiceTestHook* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kXRServiceTestHook_SetTestHook_Name: {
      break;
    }
    case internal::kXRServiceTestHook_TerminateDeviceServiceProcessForTesting_Name: {
      break;
    }
  }
  return false;
}

// static
bool XRServiceTestHookStubDispatch::AcceptWithResponder(
    XRServiceTestHook* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRServiceTestHook_SetTestHook_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRServiceTestHook::SetTestHook",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRServiceTestHook::SetTestHook");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRServiceTestHook_SetTestHook_Params_Data* params =
          reinterpret_cast<
              internal::XRServiceTestHook_SetTestHook_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<XRTestHook> p_hook{};
      XRServiceTestHook_SetTestHook_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_hook =
            input_data_view.TakeHook<decltype(p_hook)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRServiceTestHook::Name_, 0, false);
        return false;
      }
      XRServiceTestHook::SetTestHookCallback callback =
          XRServiceTestHook_SetTestHook_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTestHook(
std::move(p_hook), std::move(callback));
      return true;
    }
    case internal::kXRServiceTestHook_TerminateDeviceServiceProcessForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data* params =
          reinterpret_cast<
              internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRServiceTestHook::Name_, 1, false);
        return false;
      }
      XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback callback =
          XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TerminateDeviceServiceProcessForTesting(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRServiceTestHookValidationInfo[] = {
    {internal::kXRServiceTestHook_SetTestHook_Name,
     {&internal::XRServiceTestHook_SetTestHook_Params_Data::Validate,
      &internal::XRServiceTestHook_SetTestHook_ResponseParams_Data::Validate}},
    {internal::kXRServiceTestHook_TerminateDeviceServiceProcessForTesting_Name,
     {&internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data::Validate,
      &internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data::Validate}},
};

bool XRServiceTestHookRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device_test::mojom::XRServiceTestHook::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRServiceTestHookValidationInfo);
}

bool XRServiceTestHookResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device_test::mojom::XRServiceTestHook::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kXRServiceTestHookValidationInfo);

}
}  // namespace mojom
}  // namespace device_test

namespace mojo {


// static
bool StructTraits<::device_test::mojom::Color::DataView, ::device_test::mojom::ColorPtr>::Read(
    ::device_test::mojom::Color::DataView input,
    ::device_test::mojom::ColorPtr* output) {
  bool success = true;
  ::device_test::mojom::ColorPtr result(::device_test::mojom::Color::New());
  
      if (success)
        result->r = input.r();
      if (success)
        result->g = input.g();
      if (success)
        result->b = input.b();
      if (success)
        result->a = input.a();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::SubmittedFrameData::DataView, ::device_test::mojom::SubmittedFrameDataPtr>::Read(
    ::device_test::mojom::SubmittedFrameData::DataView input,
    ::device_test::mojom::SubmittedFrameDataPtr* output) {
  bool success = true;
  ::device_test::mojom::SubmittedFrameDataPtr result(::device_test::mojom::SubmittedFrameData::New());
  
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success && !input.ReadEye(&result->eye))
        success = false;
      if (success && !input.ReadViewport(&result->viewport))
        success = false;
      if (success && !input.ReadImageSize(&result->image_size))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::PoseFrameData::DataView, ::device_test::mojom::PoseFrameDataPtr>::Read(
    ::device_test::mojom::PoseFrameData::DataView input,
    ::device_test::mojom::PoseFrameDataPtr* output) {
  bool success = true;
  ::device_test::mojom::PoseFrameDataPtr result(::device_test::mojom::PoseFrameData::New());
  
      if (success && !input.ReadDeviceToOrigin(&result->device_to_origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::ProjectionRaw::DataView, ::device_test::mojom::ProjectionRawPtr>::Read(
    ::device_test::mojom::ProjectionRaw::DataView input,
    ::device_test::mojom::ProjectionRawPtr* output) {
  bool success = true;
  ::device_test::mojom::ProjectionRawPtr result(::device_test::mojom::ProjectionRaw::New());
  
      if (success)
        result->left = input.left();
      if (success)
        result->right = input.right();
      if (success)
        result->top = input.top();
      if (success)
        result->bottom = input.bottom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::DeviceConfig::DataView, ::device_test::mojom::DeviceConfigPtr>::Read(
    ::device_test::mojom::DeviceConfig::DataView input,
    ::device_test::mojom::DeviceConfigPtr* output) {
  bool success = true;
  ::device_test::mojom::DeviceConfigPtr result(::device_test::mojom::DeviceConfig::New());
  
      if (success)
        result->interpupillary_distance = input.interpupillary_distance();
      if (success && !input.ReadProjectionLeft(&result->projection_left))
        success = false;
      if (success && !input.ReadProjectionRight(&result->projection_right))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::ControllerAxisData::DataView, ::device_test::mojom::ControllerAxisDataPtr>::Read(
    ::device_test::mojom::ControllerAxisData::DataView input,
    ::device_test::mojom::ControllerAxisDataPtr* output) {
  bool success = true;
  ::device_test::mojom::ControllerAxisDataPtr result(::device_test::mojom::ControllerAxisData::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->axis_type = input.axis_type();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::ControllerFrameData::DataView, ::device_test::mojom::ControllerFrameDataPtr>::Read(
    ::device_test::mojom::ControllerFrameData::DataView input,
    ::device_test::mojom::ControllerFrameDataPtr* output) {
  bool success = true;
  ::device_test::mojom::ControllerFrameDataPtr result(::device_test::mojom::ControllerFrameData::New());
  
      if (success)
        result->packet_number = input.packet_number();
      if (success)
        result->buttons_pressed = input.buttons_pressed();
      if (success)
        result->buttons_touched = input.buttons_touched();
      if (success)
        result->supported_buttons = input.supported_buttons();
      if (success && !input.ReadAxisData(&result->axis_data))
        success = false;
      if (success && !input.ReadPoseData(&result->pose_data))
        success = false;
      if (success && !input.ReadRole(&result->role))
        success = false;
      if (success)
        result->is_valid = input.is_valid();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::EventData::DataView, ::device_test::mojom::EventDataPtr>::Read(
    ::device_test::mojom::EventData::DataView input,
    ::device_test::mojom::EventDataPtr* output) {
  bool success = true;
  ::device_test::mojom::EventDataPtr result(::device_test::mojom::EventData::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadInteractionProfile(&result->interaction_profile))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif