// media/mojo/mojom/content_decryption_module.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/content_decryption_module.mojom-shared.h"
#include "media/mojo/mojom/content_decryption_module.mojom-forward.h"
#include "media/mojo/mojom/decryptor.mojom.h"
#include "url/mojom/url.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "media/base/ipc/media_param_traits_macros.h"
#include "media/mojo/mojom/cdm_key_information_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {

class ContentDecryptionModuleProxy;

template <typename ImplRefTraits>
class ContentDecryptionModuleStub;

class ContentDecryptionModuleRequestValidator;
class ContentDecryptionModuleResponseValidator;


class  ContentDecryptionModule
    : public ContentDecryptionModuleInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ContentDecryptionModuleInterfaceBase;
  using Proxy_ = ContentDecryptionModuleProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentDecryptionModuleStub<ImplRefTraits>;

  using RequestValidator_ = ContentDecryptionModuleRequestValidator;
  using ResponseValidator_ = ContentDecryptionModuleResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kSetServerCertificateMinVersion = 0,
    kGetStatusForPolicyMinVersion = 0,
    kCreateSessionAndGenerateRequestMinVersion = 0,
    kLoadSessionMinVersion = 0,
    kUpdateSessionMinVersion = 0,
    kCloseSessionMinVersion = 0,
    kRemoveSessionMinVersion = 0,
  };
  virtual ~ContentDecryptionModule() {}

  
  virtual void SetClient(::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> client) = 0;


  using SetServerCertificateCallback = base::OnceCallback<void(CdmPromiseResultPtr)>;
  
  virtual void SetServerCertificate(const std::vector<uint8_t>& certificate_data, SetServerCertificateCallback callback) = 0;


  using GetStatusForPolicyCallback = base::OnceCallback<void(CdmPromiseResultPtr, ::media::CdmKeyInformation::KeyStatus)>;
  
  virtual void GetStatusForPolicy(::media::HdcpVersion min_hdcp_version, GetStatusForPolicyCallback callback) = 0;


  using CreateSessionAndGenerateRequestCallback = base::OnceCallback<void(CdmPromiseResultPtr, const std::string&)>;
  
  virtual void CreateSessionAndGenerateRequest(::media::CdmSessionType session_type, ::media::EmeInitDataType init_data_type, const std::vector<uint8_t>& init_data, CreateSessionAndGenerateRequestCallback callback) = 0;


  using LoadSessionCallback = base::OnceCallback<void(CdmPromiseResultPtr, const std::string&)>;
  
  virtual void LoadSession(::media::CdmSessionType session_type, const std::string& session_id, LoadSessionCallback callback) = 0;


  using UpdateSessionCallback = base::OnceCallback<void(CdmPromiseResultPtr)>;
  
  virtual void UpdateSession(const std::string& session_id, const std::vector<uint8_t>& response, UpdateSessionCallback callback) = 0;


  using CloseSessionCallback = base::OnceCallback<void(CdmPromiseResultPtr)>;
  
  virtual void CloseSession(const std::string& session_id, CloseSessionCallback callback) = 0;


  using RemoveSessionCallback = base::OnceCallback<void(CdmPromiseResultPtr)>;
  
  virtual void RemoveSession(const std::string& session_id, RemoveSessionCallback callback) = 0;
};

class ContentDecryptionModuleClientProxy;

template <typename ImplRefTraits>
class ContentDecryptionModuleClientStub;

class ContentDecryptionModuleClientRequestValidator;


class  ContentDecryptionModuleClient
    : public ContentDecryptionModuleClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ContentDecryptionModuleClientInterfaceBase;
  using Proxy_ = ContentDecryptionModuleClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentDecryptionModuleClientStub<ImplRefTraits>;

  using RequestValidator_ = ContentDecryptionModuleClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSessionMessageMinVersion = 0,
    kOnSessionClosedMinVersion = 0,
    kOnSessionKeysChangeMinVersion = 0,
    kOnSessionExpirationUpdateMinVersion = 0,
  };
  virtual ~ContentDecryptionModuleClient() {}

  
  virtual void OnSessionMessage(const std::string& session_id, ::media::CdmMessageType message_type, const std::vector<uint8_t>& message) = 0;

  
  virtual void OnSessionClosed(const std::string& session_id) = 0;

  
  virtual void OnSessionKeysChange(const std::string& session_id, bool has_additional_usable_key, std::vector<::std::unique_ptr<::media::CdmKeyInformation>> keys_info) = 0;

  
  virtual void OnSessionExpirationUpdate(const std::string& session_id, double new_expiry_time_sec) = 0;
};

class CdmFactoryProxy;

template <typename ImplRefTraits>
class CdmFactoryStub;

class CdmFactoryRequestValidator;
class CdmFactoryResponseValidator;


class  CdmFactory
    : public CdmFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CdmFactoryInterfaceBase;
  using Proxy_ = CdmFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = CdmFactoryStub<ImplRefTraits>;

  using RequestValidator_ = CdmFactoryRequestValidator;
  using ResponseValidator_ = CdmFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateCdmMinVersion = 0,
  };
  virtual ~CdmFactory() {}


  using CreateCdmCallback = base::OnceCallback<void(::mojo::PendingRemote<ContentDecryptionModule>, const base::Optional<::base::UnguessableToken>&, ::mojo::PendingRemote<::media::mojom::Decryptor>, const std::string&)>;
  
  virtual void CreateCdm(const std::string& key_system, const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) = 0;
};



class  ContentDecryptionModuleProxy
    : public ContentDecryptionModule {
 public:
  using InterfaceType = ContentDecryptionModule;

  explicit ContentDecryptionModuleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> client) final;
  
  void SetServerCertificate(const std::vector<uint8_t>& certificate_data, SetServerCertificateCallback callback) final;
  
  void GetStatusForPolicy(::media::HdcpVersion min_hdcp_version, GetStatusForPolicyCallback callback) final;
  
  void CreateSessionAndGenerateRequest(::media::CdmSessionType session_type, ::media::EmeInitDataType init_data_type, const std::vector<uint8_t>& init_data, CreateSessionAndGenerateRequestCallback callback) final;
  
  void LoadSession(::media::CdmSessionType session_type, const std::string& session_id, LoadSessionCallback callback) final;
  
  void UpdateSession(const std::string& session_id, const std::vector<uint8_t>& response, UpdateSessionCallback callback) final;
  
  void CloseSession(const std::string& session_id, CloseSessionCallback callback) final;
  
  void RemoveSession(const std::string& session_id, RemoveSessionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ContentDecryptionModuleClientProxy
    : public ContentDecryptionModuleClient {
 public:
  using InterfaceType = ContentDecryptionModuleClient;

  explicit ContentDecryptionModuleClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSessionMessage(const std::string& session_id, ::media::CdmMessageType message_type, const std::vector<uint8_t>& message) final;
  
  void OnSessionClosed(const std::string& session_id) final;
  
  void OnSessionKeysChange(const std::string& session_id, bool has_additional_usable_key, std::vector<::std::unique_ptr<::media::CdmKeyInformation>> keys_info) final;
  
  void OnSessionExpirationUpdate(const std::string& session_id, double new_expiry_time_sec) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CdmFactoryProxy
    : public CdmFactory {
 public:
  using InterfaceType = CdmFactory;

  explicit CdmFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateCdm(const std::string& key_system, const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ContentDecryptionModuleStubDispatch {
 public:
  static bool Accept(ContentDecryptionModule* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentDecryptionModule* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentDecryptionModule>>
class ContentDecryptionModuleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentDecryptionModuleStub() {}
  ~ContentDecryptionModuleStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentDecryptionModuleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentDecryptionModuleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContentDecryptionModuleClientStubDispatch {
 public:
  static bool Accept(ContentDecryptionModuleClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentDecryptionModuleClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentDecryptionModuleClient>>
class ContentDecryptionModuleClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentDecryptionModuleClientStub() {}
  ~ContentDecryptionModuleClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentDecryptionModuleClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentDecryptionModuleClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CdmFactoryStubDispatch {
 public:
  static bool Accept(CdmFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CdmFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CdmFactory>>
class CdmFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CdmFactoryStub() {}
  ~CdmFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContentDecryptionModuleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContentDecryptionModuleClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CdmFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContentDecryptionModuleResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CdmFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  CdmPromiseResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CdmPromiseResult, T>::value>;
  using DataView = CdmPromiseResultDataView;
  using Data_ = internal::CdmPromiseResult_Data;
  using Exception = CdmPromiseResult_Exception;

  template <typename... Args>
  static CdmPromiseResultPtr New(Args&&... args) {
    return CdmPromiseResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CdmPromiseResultPtr From(const U& u) {
    return mojo::TypeConverter<CdmPromiseResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CdmPromiseResult>::Convert(*this);
  }


  CdmPromiseResult();

  CdmPromiseResult(
      bool success,
      ::media::CdmPromise::Exception exception,
      uint32_t system_code,
      const std::string& error_message);

  ~CdmPromiseResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CdmPromiseResultPtr>
  CdmPromiseResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CdmPromiseResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CdmPromiseResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CdmPromiseResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CdmPromiseResult_UnserializedMessageContext<
            UserType, CdmPromiseResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CdmPromiseResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CdmPromiseResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CdmPromiseResult_UnserializedMessageContext<
            UserType, CdmPromiseResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CdmPromiseResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool success;
  
  ::media::CdmPromise::Exception exception;
  
  uint32_t system_code;
  
  std::string error_message;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CdmPromiseResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CdmPromiseResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CdmPromiseResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CdmPromiseResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  CdmKeyInformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CdmKeyInformation, T>::value>;
  using DataView = CdmKeyInformationDataView;
  using Data_ = internal::CdmKeyInformation_Data;

  template <typename... Args>
  static CdmKeyInformationPtr New(Args&&... args) {
    return CdmKeyInformationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CdmKeyInformationPtr From(const U& u) {
    return mojo::TypeConverter<CdmKeyInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CdmKeyInformation>::Convert(*this);
  }


  CdmKeyInformation();

  CdmKeyInformation(
      std::vector<uint8_t> key_id,
      ::media::CdmKeyInformation::KeyStatus status,
      uint32_t system_code);

  ~CdmKeyInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CdmKeyInformationPtr>
  CdmKeyInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CdmKeyInformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CdmKeyInformation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CdmKeyInformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CdmKeyInformation_UnserializedMessageContext<
            UserType, CdmKeyInformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CdmKeyInformation::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CdmKeyInformation::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CdmKeyInformation_UnserializedMessageContext<
            UserType, CdmKeyInformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CdmKeyInformation::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<uint8_t> key_id;
  
  ::media::CdmKeyInformation::KeyStatus status;
  
  uint32_t system_code;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CdmKeyInformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CdmKeyInformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CdmKeyInformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CdmKeyInformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CdmPromiseResultPtr CdmPromiseResult::Clone() const {
  return New(
      mojo::Clone(success),
      mojo::Clone(exception),
      mojo::Clone(system_code),
      mojo::Clone(error_message)
  );
}

template <typename T, CdmPromiseResult::EnableIfSame<T>*>
bool CdmPromiseResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->success, other_struct.success))
    return false;
  if (!mojo::Equals(this->exception, other_struct.exception))
    return false;
  if (!mojo::Equals(this->system_code, other_struct.system_code))
    return false;
  if (!mojo::Equals(this->error_message, other_struct.error_message))
    return false;
  return true;
}

template <typename T, CdmPromiseResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.success, rhs.success))
    return true;
  if (std::less<>{}(rhs.success, lhs.success))
    return false;
  if (std::less<>{}(lhs.exception, rhs.exception))
    return true;
  if (std::less<>{}(rhs.exception, lhs.exception))
    return false;
  if (std::less<>{}(lhs.system_code, rhs.system_code))
    return true;
  if (std::less<>{}(rhs.system_code, lhs.system_code))
    return false;
  if (std::less<>{}(lhs.error_message, rhs.error_message))
    return true;
  if (std::less<>{}(rhs.error_message, lhs.error_message))
    return false;
  return false;
}
template <typename StructPtrType>
CdmKeyInformationPtr CdmKeyInformation::Clone() const {
  return New(
      mojo::Clone(key_id),
      mojo::Clone(status),
      mojo::Clone(system_code)
  );
}

template <typename T, CdmKeyInformation::EnableIfSame<T>*>
bool CdmKeyInformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_id, other_struct.key_id))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->system_code, other_struct.system_code))
    return false;
  return true;
}

template <typename T, CdmKeyInformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.key_id, rhs.key_id))
    return true;
  if (std::less<>{}(rhs.key_id, lhs.key_id))
    return false;
  if (std::less<>{}(lhs.status, rhs.status))
    return true;
  if (std::less<>{}(rhs.status, lhs.status))
    return false;
  if (std::less<>{}(lhs.system_code, rhs.system_code))
    return true;
  if (std::less<>{}(rhs.system_code, lhs.system_code))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::CdmPromiseResult::DataView,
                                         ::media::mojom::CdmPromiseResultPtr> {
  static bool IsNull(const ::media::mojom::CdmPromiseResultPtr& input) { return !input; }
  static void SetToNull(::media::mojom::CdmPromiseResultPtr* output) { output->reset(); }

  static decltype(::media::mojom::CdmPromiseResult::success) success(
      const ::media::mojom::CdmPromiseResultPtr& input) {
    return input->success;
  }

  static decltype(::media::mojom::CdmPromiseResult::exception) exception(
      const ::media::mojom::CdmPromiseResultPtr& input) {
    return input->exception;
  }

  static decltype(::media::mojom::CdmPromiseResult::system_code) system_code(
      const ::media::mojom::CdmPromiseResultPtr& input) {
    return input->system_code;
  }

  static const decltype(::media::mojom::CdmPromiseResult::error_message)& error_message(
      const ::media::mojom::CdmPromiseResultPtr& input) {
    return input->error_message;
  }

  static bool Read(::media::mojom::CdmPromiseResult::DataView input, ::media::mojom::CdmPromiseResultPtr* output);
};


template <>
struct  StructTraits<::media::mojom::CdmKeyInformation::DataView,
                                         ::media::mojom::CdmKeyInformationPtr> {
  static bool IsNull(const ::media::mojom::CdmKeyInformationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::CdmKeyInformationPtr* output) { output->reset(); }

  static const decltype(::media::mojom::CdmKeyInformation::key_id)& key_id(
      const ::media::mojom::CdmKeyInformationPtr& input) {
    return input->key_id;
  }

  static decltype(::media::mojom::CdmKeyInformation::status) status(
      const ::media::mojom::CdmKeyInformationPtr& input) {
    return input->status;
  }

  static decltype(::media::mojom::CdmKeyInformation::system_code) system_code(
      const ::media::mojom::CdmKeyInformationPtr& input) {
    return input->system_code;
  }

  static bool Read(::media::mojom::CdmKeyInformation::DataView input, ::media::mojom::CdmKeyInformationPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_H_