// media/mojo/mojom/renderer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/renderer.mojom-shared.h"
#include "media/mojo/mojom/renderer.mojom-forward.h"
#include "media/mojo/mojom/demuxer_stream.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {

class RendererProxy;

template <typename ImplRefTraits>
class RendererStub;

class RendererRequestValidator;
class RendererResponseValidator;


class  Renderer
    : public RendererInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RendererInterfaceBase;
  using Proxy_ = RendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererStub<ImplRefTraits>;

  using RequestValidator_ = RendererRequestValidator;
  using ResponseValidator_ = RendererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kFlushMinVersion = 0,
    kStartPlayingFromMinVersion = 0,
    kSetPlaybackRateMinVersion = 0,
    kSetVolumeMinVersion = 0,
    kSetCdmMinVersion = 0,
  };
  virtual ~Renderer() {}


  using InitializeCallback = base::OnceCallback<void(bool)>;
  
  virtual void Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, base::Optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams, MediaUrlParamsPtr media_url_params, InitializeCallback callback) = 0;


  using FlushCallback = base::OnceCallback<void()>;
  
  virtual void Flush(FlushCallback callback) = 0;

  
  virtual void StartPlayingFrom(::base::TimeDelta time) = 0;

  
  virtual void SetPlaybackRate(double playback_rate) = 0;

  
  virtual void SetVolume(float volume) = 0;


  using SetCdmCallback = base::OnceCallback<void(bool)>;
  
  virtual void SetCdm(const base::Optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) = 0;
};

class RendererClientProxy;

template <typename ImplRefTraits>
class RendererClientStub;

class RendererClientRequestValidator;


class  RendererClient
    : public RendererClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RendererClientInterfaceBase;
  using Proxy_ = RendererClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererClientStub<ImplRefTraits>;

  using RequestValidator_ = RendererClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTimeUpdateMinVersion = 0,
    kOnBufferingStateChangeMinVersion = 0,
    kOnEndedMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnAudioConfigChangeMinVersion = 0,
    kOnVideoConfigChangeMinVersion = 0,
    kOnVideoNaturalSizeChangeMinVersion = 0,
    kOnVideoOpacityChangeMinVersion = 0,
    kOnStatisticsUpdateMinVersion = 0,
    kOnWaitingMinVersion = 0,
  };
  virtual ~RendererClient() {}

  
  virtual void OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) = 0;

  
  virtual void OnBufferingStateChange(::media::BufferingState state, ::media::BufferingStateChangeReason reason) = 0;

  
  virtual void OnEnded() = 0;

  
  virtual void OnError() = 0;

  
  virtual void OnAudioConfigChange(const ::media::AudioDecoderConfig& config) = 0;

  
  virtual void OnVideoConfigChange(const ::media::VideoDecoderConfig& config) = 0;

  
  virtual void OnVideoNaturalSizeChange(const ::gfx::Size& size) = 0;

  
  virtual void OnVideoOpacityChange(bool opaque) = 0;

  
  virtual void OnStatisticsUpdate(const ::media::PipelineStatistics& stats) = 0;

  
  virtual void OnWaiting(::media::WaitingReason reason) = 0;
};



class  RendererProxy
    : public Renderer {
 public:
  using InterfaceType = Renderer;

  explicit RendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, base::Optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams, MediaUrlParamsPtr media_url_params, InitializeCallback callback) final;
  
  void Flush(FlushCallback callback) final;
  
  void StartPlayingFrom(::base::TimeDelta time) final;
  
  void SetPlaybackRate(double playback_rate) final;
  
  void SetVolume(float volume) final;
  
  void SetCdm(const base::Optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  RendererClientProxy
    : public RendererClient {
 public:
  using InterfaceType = RendererClient;

  explicit RendererClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) final;
  
  void OnBufferingStateChange(::media::BufferingState state, ::media::BufferingStateChangeReason reason) final;
  
  void OnEnded() final;
  
  void OnError() final;
  
  void OnAudioConfigChange(const ::media::AudioDecoderConfig& config) final;
  
  void OnVideoConfigChange(const ::media::VideoDecoderConfig& config) final;
  
  void OnVideoNaturalSizeChange(const ::gfx::Size& size) final;
  
  void OnVideoOpacityChange(bool opaque) final;
  
  void OnStatisticsUpdate(const ::media::PipelineStatistics& stats) final;
  
  void OnWaiting(::media::WaitingReason reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RendererStubDispatch {
 public:
  static bool Accept(Renderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Renderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Renderer>>
class RendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererStub() {}
  ~RendererStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererClientStubDispatch {
 public:
  static bool Accept(RendererClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererClient>>
class RendererClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererClientStub() {}
  ~RendererClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RendererClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RendererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  MediaUrlParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaUrlParams, T>::value>;
  using DataView = MediaUrlParamsDataView;
  using Data_ = internal::MediaUrlParams_Data;

  template <typename... Args>
  static MediaUrlParamsPtr New(Args&&... args) {
    return MediaUrlParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaUrlParamsPtr From(const U& u) {
    return mojo::TypeConverter<MediaUrlParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaUrlParams>::Convert(*this);
  }


  MediaUrlParams();

  MediaUrlParams(
      const ::GURL& media_url,
      const ::GURL& site_for_cookies,
      const ::url::Origin& top_frame_origin,
      bool allow_credentials,
      bool is_hls);

  ~MediaUrlParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaUrlParamsPtr>
  MediaUrlParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaUrlParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaUrlParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaUrlParams_UnserializedMessageContext<
            UserType, MediaUrlParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MediaUrlParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MediaUrlParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaUrlParams_UnserializedMessageContext<
            UserType, MediaUrlParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaUrlParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL media_url;
  
  ::GURL site_for_cookies;
  
  ::url::Origin top_frame_origin;
  
  bool allow_credentials;
  
  bool is_hls;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MediaUrlParamsPtr MediaUrlParams::Clone() const {
  return New(
      mojo::Clone(media_url),
      mojo::Clone(site_for_cookies),
      mojo::Clone(top_frame_origin),
      mojo::Clone(allow_credentials),
      mojo::Clone(is_hls)
  );
}

template <typename T, MediaUrlParams::EnableIfSame<T>*>
bool MediaUrlParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->media_url, other_struct.media_url))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  if (!mojo::Equals(this->top_frame_origin, other_struct.top_frame_origin))
    return false;
  if (!mojo::Equals(this->allow_credentials, other_struct.allow_credentials))
    return false;
  if (!mojo::Equals(this->is_hls, other_struct.is_hls))
    return false;
  return true;
}

template <typename T, MediaUrlParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.media_url, rhs.media_url))
    return true;
  if (std::less<>{}(rhs.media_url, lhs.media_url))
    return false;
  if (std::less<>{}(lhs.site_for_cookies, rhs.site_for_cookies))
    return true;
  if (std::less<>{}(rhs.site_for_cookies, lhs.site_for_cookies))
    return false;
  if (std::less<>{}(lhs.top_frame_origin, rhs.top_frame_origin))
    return true;
  if (std::less<>{}(rhs.top_frame_origin, lhs.top_frame_origin))
    return false;
  if (std::less<>{}(lhs.allow_credentials, rhs.allow_credentials))
    return true;
  if (std::less<>{}(rhs.allow_credentials, lhs.allow_credentials))
    return false;
  if (std::less<>{}(lhs.is_hls, rhs.is_hls))
    return true;
  if (std::less<>{}(rhs.is_hls, lhs.is_hls))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::MediaUrlParams::DataView,
                                         ::media::mojom::MediaUrlParamsPtr> {
  static bool IsNull(const ::media::mojom::MediaUrlParamsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::MediaUrlParamsPtr* output) { output->reset(); }

  static const decltype(::media::mojom::MediaUrlParams::media_url)& media_url(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->media_url;
  }

  static const decltype(::media::mojom::MediaUrlParams::site_for_cookies)& site_for_cookies(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->site_for_cookies;
  }

  static const decltype(::media::mojom::MediaUrlParams::top_frame_origin)& top_frame_origin(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->top_frame_origin;
  }

  static decltype(::media::mojom::MediaUrlParams::allow_credentials) allow_credentials(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->allow_credentials;
  }

  static decltype(::media::mojom::MediaUrlParams::is_hls) is_hls(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->is_hls;
  }

  static bool Read(::media::mojom::MediaUrlParams::DataView input, ::media::mojom::MediaUrlParamsPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_RENDERER_MOJOM_H_