// services/network/public/mojom/origin_policy_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/origin_policy_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/origin_policy_manager.mojom-params-data.h"
#include "services/network/public/mojom/origin_policy_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/origin_policy_manager.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ORIGIN_POLICY_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ORIGIN_POLICY_MANAGER_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
const char OriginPolicyManager::Name_[] = "network.mojom.OriginPolicyManager";

class OriginPolicyManager_RetrieveOriginPolicy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OriginPolicyManager_RetrieveOriginPolicy_ForwardToCallback(
      OriginPolicyManager::RetrieveOriginPolicyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  OriginPolicyManager::RetrieveOriginPolicyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(OriginPolicyManager_RetrieveOriginPolicy_ForwardToCallback);
};

OriginPolicyManagerProxy::OriginPolicyManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OriginPolicyManagerProxy::RetrieveOriginPolicy(
    const ::url::Origin& in_origin, const ::net::IsolationInfo& in_isolation_info, const base::Optional<std::string>& in_header_value, RetrieveOriginPolicyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::OriginPolicyManager::RetrieveOriginPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("isolation_info", base::trace_event::ValueToString(in_isolation_info, "<value of type const ::net::IsolationInfo&>"));
      if (in_header_value.has_value()) {
        raw_value->SetString("header_value", in_header_value.value());
      } else {
        raw_value->SetString("header_value", "base::nullopt");
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOriginPolicyManager_RetrieveOriginPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::OriginPolicyManager_RetrieveOriginPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in OriginPolicyManager.RetrieveOriginPolicy request");
  typename decltype(params->isolation_info)::BaseType::BufferWriter
      isolation_info_writer;
  mojo::internal::Serialize<::network::mojom::IsolationInfoDataView>(
      in_isolation_info, buffer, &isolation_info_writer, &serialization_context);
  params->isolation_info.Set(
      isolation_info_writer.is_null() ? nullptr : isolation_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->isolation_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null isolation_info in OriginPolicyManager.RetrieveOriginPolicy request");
  typename decltype(params->header_value)::BaseType::BufferWriter
      header_value_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_header_value, buffer, &header_value_writer, &serialization_context);
  params->header_value.Set(
      header_value_writer.is_null() ? nullptr : header_value_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OriginPolicyManager::Name_);
  message.set_method_name("RetrieveOriginPolicy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OriginPolicyManager_RetrieveOriginPolicy_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void OriginPolicyManagerProxy::AddExceptionFor(
    const ::url::Origin& in_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::OriginPolicyManager::AddExceptionFor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOriginPolicyManager_AddExceptionFor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::OriginPolicyManager_AddExceptionFor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in OriginPolicyManager.AddExceptionFor request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OriginPolicyManager::Name_);
  message.set_method_name("AddExceptionFor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder {
 public:
  static OriginPolicyManager::RetrieveOriginPolicyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder> proxy(
        new OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "OriginPolicyManager::RetrieveOriginPolicyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::network::OriginPolicy& in_origin_policy);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder);
};

bool OriginPolicyManager_RetrieveOriginPolicy_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::OriginPolicyManager::RetrieveOriginPolicyCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::OriginPolicyManager_RetrieveOriginPolicy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OriginPolicyManager_RetrieveOriginPolicy_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::network::OriginPolicy p_origin_policy{};
  OriginPolicyManager_RetrieveOriginPolicy_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadOriginPolicy(&p_origin_policy))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OriginPolicyManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_origin_policy));
  return true;
}

void OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder::Run(
    const ::network::OriginPolicy& in_origin_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::OriginPolicyManager::RetrieveOriginPolicyCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin_policy", base::trace_event::ValueToString(in_origin_policy, "<value of type const ::network::OriginPolicy&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOriginPolicyManager_RetrieveOriginPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::OriginPolicyManager_RetrieveOriginPolicy_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin_policy)::BaseType::BufferWriter
      origin_policy_writer;
  mojo::internal::Serialize<::network::mojom::OriginPolicyDataView>(
      in_origin_policy, buffer, &origin_policy_writer, &serialization_context);
  params->origin_policy.Set(
      origin_policy_writer.is_null() ? nullptr : origin_policy_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin_policy in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::OriginPolicyManager::RetrieveOriginPolicyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OriginPolicyManager::Name_);
  message.set_method_name("RetrieveOriginPolicy");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OriginPolicyManagerStubDispatch::Accept(
    OriginPolicyManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kOriginPolicyManager_RetrieveOriginPolicy_Name: {
      break;
    }
    case internal::kOriginPolicyManager_AddExceptionFor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::OriginPolicyManager::AddExceptionFor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::OriginPolicyManager::AddExceptionFor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::OriginPolicyManager_AddExceptionFor_Params_Data* params =
          reinterpret_cast<internal::OriginPolicyManager_AddExceptionFor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      OriginPolicyManager_AddExceptionFor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OriginPolicyManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddExceptionFor(
std::move(p_origin));
      return true;
    }
  }
  return false;
}

// static
bool OriginPolicyManagerStubDispatch::AcceptWithResponder(
    OriginPolicyManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kOriginPolicyManager_RetrieveOriginPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::OriginPolicyManager::RetrieveOriginPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::OriginPolicyManager::RetrieveOriginPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::OriginPolicyManager_RetrieveOriginPolicy_Params_Data* params =
          reinterpret_cast<
              internal::OriginPolicyManager_RetrieveOriginPolicy_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ::net::IsolationInfo p_isolation_info{};
      base::Optional<std::string> p_header_value{};
      OriginPolicyManager_RetrieveOriginPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadIsolationInfo(&p_isolation_info))
        success = false;
      if (success && !input_data_view.ReadHeaderValue(&p_header_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OriginPolicyManager::Name_, 0, false);
        return false;
      }
      OriginPolicyManager::RetrieveOriginPolicyCallback callback =
          OriginPolicyManager_RetrieveOriginPolicy_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RetrieveOriginPolicy(
std::move(p_origin), 
std::move(p_isolation_info), 
std::move(p_header_value), std::move(callback));
      return true;
    }
    case internal::kOriginPolicyManager_AddExceptionFor_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kOriginPolicyManagerValidationInfo[] = {
    {internal::kOriginPolicyManager_RetrieveOriginPolicy_Name,
     {&internal::OriginPolicyManager_RetrieveOriginPolicy_Params_Data::Validate,
      &internal::OriginPolicyManager_RetrieveOriginPolicy_ResponseParams_Data::Validate}},
    {internal::kOriginPolicyManager_AddExceptionFor_Name,
     {&internal::OriginPolicyManager_AddExceptionFor_Params_Data::Validate,
      nullptr /* no response */}},
};

bool OriginPolicyManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::OriginPolicyManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kOriginPolicyManagerValidationInfo);
}

bool OriginPolicyManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::OriginPolicyManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kOriginPolicyManagerValidationInfo);

}
}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif