// services/video_capture/public/mojom/video_frame_handler.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace video_capture {
namespace mojom {
namespace internal {
class  VideoFrameHandler_OnNewBuffer_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnNewBuffer_Params_Data));
      new (data()) VideoFrameHandler_OnNewBuffer_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnNewBuffer_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnNewBuffer_Params_Data>(index_);
    }
    VideoFrameHandler_OnNewBuffer_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  ::media::mojom::internal::VideoBufferHandle_Data buffer_handle;

 private:
  VideoFrameHandler_OnNewBuffer_Params_Data();
  ~VideoFrameHandler_OnNewBuffer_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnNewBuffer_Params_Data) == 32,
              "Bad sizeof(VideoFrameHandler_OnNewBuffer_Params_Data)");
class  VideoFrameHandler_OnFrameReadyInBuffer_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnFrameReadyInBuffer_Params_Data));
      new (data()) VideoFrameHandler_OnFrameReadyInBuffer_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnFrameReadyInBuffer_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnFrameReadyInBuffer_Params_Data>(index_);
    }
    VideoFrameHandler_OnFrameReadyInBuffer_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  int32_t frame_feedback_id;
  mojo::internal::Interface_Data access_permission;
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> frame_info;

 private:
  VideoFrameHandler_OnFrameReadyInBuffer_Params_Data();
  ~VideoFrameHandler_OnFrameReadyInBuffer_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnFrameReadyInBuffer_Params_Data) == 32,
              "Bad sizeof(VideoFrameHandler_OnFrameReadyInBuffer_Params_Data)");
class  VideoFrameHandler_OnBufferRetired_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnBufferRetired_Params_Data));
      new (data()) VideoFrameHandler_OnBufferRetired_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnBufferRetired_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnBufferRetired_Params_Data>(index_);
    }
    VideoFrameHandler_OnBufferRetired_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t padfinal_[4];

 private:
  VideoFrameHandler_OnBufferRetired_Params_Data();
  ~VideoFrameHandler_OnBufferRetired_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnBufferRetired_Params_Data) == 16,
              "Bad sizeof(VideoFrameHandler_OnBufferRetired_Params_Data)");
class  VideoFrameHandler_OnError_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnError_Params_Data));
      new (data()) VideoFrameHandler_OnError_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnError_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnError_Params_Data>(index_);
    }
    VideoFrameHandler_OnError_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  VideoFrameHandler_OnError_Params_Data();
  ~VideoFrameHandler_OnError_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnError_Params_Data) == 16,
              "Bad sizeof(VideoFrameHandler_OnError_Params_Data)");
class  VideoFrameHandler_OnFrameDropped_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnFrameDropped_Params_Data));
      new (data()) VideoFrameHandler_OnFrameDropped_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnFrameDropped_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnFrameDropped_Params_Data>(index_);
    }
    VideoFrameHandler_OnFrameDropped_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  VideoFrameHandler_OnFrameDropped_Params_Data();
  ~VideoFrameHandler_OnFrameDropped_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnFrameDropped_Params_Data) == 16,
              "Bad sizeof(VideoFrameHandler_OnFrameDropped_Params_Data)");
class  VideoFrameHandler_OnLog_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnLog_Params_Data));
      new (data()) VideoFrameHandler_OnLog_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnLog_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnLog_Params_Data>(index_);
    }
    VideoFrameHandler_OnLog_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  VideoFrameHandler_OnLog_Params_Data();
  ~VideoFrameHandler_OnLog_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnLog_Params_Data) == 16,
              "Bad sizeof(VideoFrameHandler_OnLog_Params_Data)");
class  VideoFrameHandler_OnStarted_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnStarted_Params_Data));
      new (data()) VideoFrameHandler_OnStarted_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnStarted_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnStarted_Params_Data>(index_);
    }
    VideoFrameHandler_OnStarted_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  VideoFrameHandler_OnStarted_Params_Data();
  ~VideoFrameHandler_OnStarted_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnStarted_Params_Data) == 8,
              "Bad sizeof(VideoFrameHandler_OnStarted_Params_Data)");
class  VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data));
      new (data()) VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data>(index_);
    }
    VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data();
  ~VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data) == 8,
              "Bad sizeof(VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data)");
class  VideoFrameHandler_OnStopped_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameHandler_OnStopped_Params_Data));
      new (data()) VideoFrameHandler_OnStopped_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameHandler_OnStopped_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameHandler_OnStopped_Params_Data>(index_);
    }
    VideoFrameHandler_OnStopped_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  VideoFrameHandler_OnStopped_Params_Data();
  ~VideoFrameHandler_OnStopped_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandler_OnStopped_Params_Data) == 8,
              "Bad sizeof(VideoFrameHandler_OnStopped_Params_Data)");

}  // namespace internal


class VideoFrameHandler_OnNewBuffer_ParamsDataView {
 public:
  VideoFrameHandler_OnNewBuffer_ParamsDataView() {}

  VideoFrameHandler_OnNewBuffer_ParamsDataView(
      internal::VideoFrameHandler_OnNewBuffer_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetBufferHandleDataView(
      ::media::mojom::VideoBufferHandleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBufferHandle(UserType* output) {
    
    auto* pointer = !data_->buffer_handle.is_null() ? &data_->buffer_handle : nullptr;
    return mojo::internal::Deserialize<::media::mojom::VideoBufferHandleDataView>(
        pointer, output, context_);
  }
 private:
  internal::VideoFrameHandler_OnNewBuffer_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VideoFrameHandler_OnFrameReadyInBuffer_ParamsDataView {
 public:
  VideoFrameHandler_OnFrameReadyInBuffer_ParamsDataView() {}

  VideoFrameHandler_OnFrameReadyInBuffer_ParamsDataView(
      internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  int32_t frame_feedback_id() const {
    return data_->frame_feedback_id;
  }
  template <typename UserType>
  UserType TakeAccessPermission() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::video_capture::mojom::ScopedAccessPermissionInterfaceBase>>(
            &data_->access_permission, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameInfo(UserType* output) {
    
    auto* pointer = data_->frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VideoFrameHandler_OnBufferRetired_ParamsDataView {
 public:
  VideoFrameHandler_OnBufferRetired_ParamsDataView() {}

  VideoFrameHandler_OnBufferRetired_ParamsDataView(
      internal::VideoFrameHandler_OnBufferRetired_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
 private:
  internal::VideoFrameHandler_OnBufferRetired_Params_Data* data_ = nullptr;
};



class VideoFrameHandler_OnError_ParamsDataView {
 public:
  VideoFrameHandler_OnError_ParamsDataView() {}

  VideoFrameHandler_OnError_ParamsDataView(
      internal::VideoFrameHandler_OnError_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureError>(
        data_value, output);
  }

  ::media::mojom::VideoCaptureError error() const {
    return static_cast<::media::mojom::VideoCaptureError>(data_->error);
  }
 private:
  internal::VideoFrameHandler_OnError_Params_Data* data_ = nullptr;
};



class VideoFrameHandler_OnFrameDropped_ParamsDataView {
 public:
  VideoFrameHandler_OnFrameDropped_ParamsDataView() {}

  VideoFrameHandler_OnFrameDropped_ParamsDataView(
      internal::VideoFrameHandler_OnFrameDropped_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureFrameDropReason>(
        data_value, output);
  }

  ::media::mojom::VideoCaptureFrameDropReason reason() const {
    return static_cast<::media::mojom::VideoCaptureFrameDropReason>(data_->reason);
  }
 private:
  internal::VideoFrameHandler_OnFrameDropped_Params_Data* data_ = nullptr;
};



class VideoFrameHandler_OnLog_ParamsDataView {
 public:
  VideoFrameHandler_OnLog_ParamsDataView() {}

  VideoFrameHandler_OnLog_ParamsDataView(
      internal::VideoFrameHandler_OnLog_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::VideoFrameHandler_OnLog_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VideoFrameHandler_OnStarted_ParamsDataView {
 public:
  VideoFrameHandler_OnStarted_ParamsDataView() {}

  VideoFrameHandler_OnStarted_ParamsDataView(
      internal::VideoFrameHandler_OnStarted_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoFrameHandler_OnStarted_Params_Data* data_ = nullptr;
};



class VideoFrameHandler_OnStartedUsingGpuDecode_ParamsDataView {
 public:
  VideoFrameHandler_OnStartedUsingGpuDecode_ParamsDataView() {}

  VideoFrameHandler_OnStartedUsingGpuDecode_ParamsDataView(
      internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data* data_ = nullptr;
};



class VideoFrameHandler_OnStopped_ParamsDataView {
 public:
  VideoFrameHandler_OnStopped_ParamsDataView() {}

  VideoFrameHandler_OnStopped_ParamsDataView(
      internal::VideoFrameHandler_OnStopped_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoFrameHandler_OnStopped_Params_Data* data_ = nullptr;
};


inline void VideoFrameHandler_OnNewBuffer_ParamsDataView::GetBufferHandleDataView(
    ::media::mojom::VideoBufferHandleDataView* output) {
  auto pointer = &data_->buffer_handle;
  *output = ::media::mojom::VideoBufferHandleDataView(pointer, context_);
}


inline void VideoFrameHandler_OnFrameReadyInBuffer_ParamsDataView::GetFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, context_);
}








inline void VideoFrameHandler_OnLog_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, context_);
}







}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_PARAMS_DATA_H_