// components/metrics/public/mojom/histogram_fetcher.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/metrics/public/mojom/histogram_fetcher.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/metrics/public/mojom/histogram_fetcher.mojom-params-data.h"
namespace metrics {
namespace mojom {

NOINLINE static const char* UmaChildPingStatusToStringHelper(UmaChildPingStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UmaChildPingStatus::BROWSER_SENT_IPC:
      return "BROWSER_SENT_IPC";
    case UmaChildPingStatus::CHILD_RECEIVED_IPC:
      return "CHILD_RECEIVED_IPC";
    case UmaChildPingStatus::BROWSER_REPLY_CALLBACK:
      return "BROWSER_REPLY_CALLBACK";
    default:
      return nullptr;
  }
}

std::string UmaChildPingStatusToString(UmaChildPingStatus value) {
  const char *str = UmaChildPingStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UmaChildPingStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UmaChildPingStatus value) {
  return os << UmaChildPingStatusToString(value);
}

NOINLINE static const char* UmaPingCallSourceToStringHelper(UmaPingCallSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UmaPingCallSource::PERIODIC:
      return "PERIODIC";
    case UmaPingCallSource::SHARED_MEMORY_SET_UP:
      return "SHARED_MEMORY_SET_UP";
    default:
      return nullptr;
  }
}

std::string UmaPingCallSourceToString(UmaPingCallSource value) {
  const char *str = UmaPingCallSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UmaPingCallSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UmaPingCallSource value) {
  return os << UmaPingCallSourceToString(value);
}

namespace internal {


// static
bool ChildHistogramFetcherFactory_CreateFetcher_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildHistogramFetcherFactory_CreateFetcher_Params_Data* object =
      static_cast<const ChildHistogramFetcherFactory_CreateFetcher_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->shared_memory, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->child_histogram_fetcher, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->child_histogram_fetcher,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ChildHistogramFetcherFactory_CreateFetcher_Params_Data::ChildHistogramFetcherFactory_CreateFetcher_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data* object =
      static_cast<const ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data*>(data);

  return true;
}

ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data* object =
      static_cast<const ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deltas, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& deltas_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->deltas, validation_context,
                                         &deltas_validate_params)) {
    return false;
  }

  return true;
}

ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildHistogramFetcher_Ping_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildHistogramFetcher_Ping_Params_Data* object =
      static_cast<const ChildHistogramFetcher_Ping_Params_Data*>(data);


  if (!::metrics::mojom::internal::UmaPingCallSource_Data
        ::Validate(object->call_source, validation_context))
    return false;

  return true;
}

ChildHistogramFetcher_Ping_Params_Data::ChildHistogramFetcher_Ping_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildHistogramFetcher_Ping_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildHistogramFetcher_Ping_ResponseParams_Data* object =
      static_cast<const ChildHistogramFetcher_Ping_ResponseParams_Data*>(data);

  return true;
}

ChildHistogramFetcher_Ping_ResponseParams_Data::ChildHistogramFetcher_Ping_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace metrics

namespace perfetto {

// static
void TraceFormatTraits<::metrics::mojom::UmaChildPingStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::metrics::mojom::UmaChildPingStatus value) {
  return std::move(context).WriteString(::metrics::mojom::UmaChildPingStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::metrics::mojom::UmaPingCallSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::metrics::mojom::UmaPingCallSource value) {
  return std::move(context).WriteString(::metrics::mojom::UmaPingCallSourceToString(value));
}

} // namespace perfetto