// media/mojo/mojom/decryptor.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/decryptor.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/decryptor.mojom-params-data.h"
#include "media/mojo/mojom/decryptor.mojom-shared-message-ids.h"

#include "media/mojo/mojom/decryptor.mojom-blink-import-headers.h"
#include "media/mojo/mojom/decryptor.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
const char Decryptor::Name_[] = "media.mojom.Decryptor";

Decryptor::IPCStableHashFunction Decryptor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Decryptor>(message.name())) {
    case messages::Decryptor::kInitialize: {
      return &Decryptor::Initialize_Sym::IPCStableHash;
    }
    case messages::Decryptor::kDecrypt: {
      return &Decryptor::Decrypt_Sym::IPCStableHash;
    }
    case messages::Decryptor::kCancelDecrypt: {
      return &Decryptor::CancelDecrypt_Sym::IPCStableHash;
    }
    case messages::Decryptor::kInitializeAudioDecoder: {
      return &Decryptor::InitializeAudioDecoder_Sym::IPCStableHash;
    }
    case messages::Decryptor::kInitializeVideoDecoder: {
      return &Decryptor::InitializeVideoDecoder_Sym::IPCStableHash;
    }
    case messages::Decryptor::kDecryptAndDecodeAudio: {
      return &Decryptor::DecryptAndDecodeAudio_Sym::IPCStableHash;
    }
    case messages::Decryptor::kDecryptAndDecodeVideo: {
      return &Decryptor::DecryptAndDecodeVideo_Sym::IPCStableHash;
    }
    case messages::Decryptor::kResetDecoder: {
      return &Decryptor::ResetDecoder_Sym::IPCStableHash;
    }
    case messages::Decryptor::kDeinitializeDecoder: {
      return &Decryptor::DeinitializeDecoder_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Decryptor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Decryptor>(message.name())) {
      case messages::Decryptor::kInitialize:
            return "Receive media::mojom::Decryptor::Initialize";
      case messages::Decryptor::kDecrypt:
            return "Receive media::mojom::Decryptor::Decrypt";
      case messages::Decryptor::kCancelDecrypt:
            return "Receive media::mojom::Decryptor::CancelDecrypt";
      case messages::Decryptor::kInitializeAudioDecoder:
            return "Receive media::mojom::Decryptor::InitializeAudioDecoder";
      case messages::Decryptor::kInitializeVideoDecoder:
            return "Receive media::mojom::Decryptor::InitializeVideoDecoder";
      case messages::Decryptor::kDecryptAndDecodeAudio:
            return "Receive media::mojom::Decryptor::DecryptAndDecodeAudio";
      case messages::Decryptor::kDecryptAndDecodeVideo:
            return "Receive media::mojom::Decryptor::DecryptAndDecodeVideo";
      case messages::Decryptor::kResetDecoder:
            return "Receive media::mojom::Decryptor::ResetDecoder";
      case messages::Decryptor::kDeinitializeDecoder:
            return "Receive media::mojom::Decryptor::DeinitializeDecoder";
    }
  } else {
    switch (static_cast<messages::Decryptor>(message.name())) {
      case messages::Decryptor::kInitialize:
            return "Receive reply media::mojom::Decryptor::Initialize";
      case messages::Decryptor::kDecrypt:
            return "Receive reply media::mojom::Decryptor::Decrypt";
      case messages::Decryptor::kCancelDecrypt:
            return "Receive reply media::mojom::Decryptor::CancelDecrypt";
      case messages::Decryptor::kInitializeAudioDecoder:
            return "Receive reply media::mojom::Decryptor::InitializeAudioDecoder";
      case messages::Decryptor::kInitializeVideoDecoder:
            return "Receive reply media::mojom::Decryptor::InitializeVideoDecoder";
      case messages::Decryptor::kDecryptAndDecodeAudio:
            return "Receive reply media::mojom::Decryptor::DecryptAndDecodeAudio";
      case messages::Decryptor::kDecryptAndDecodeVideo:
            return "Receive reply media::mojom::Decryptor::DecryptAndDecodeVideo";
      case messages::Decryptor::kResetDecoder:
            return "Receive reply media::mojom::Decryptor::ResetDecoder";
      case messages::Decryptor::kDeinitializeDecoder:
            return "Receive reply media::mojom::Decryptor::DeinitializeDecoder";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Decryptor::Initialize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::Initialize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Decryptor::Decrypt_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::Decrypt");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Decryptor::CancelDecrypt_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::CancelDecrypt");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Decryptor::InitializeAudioDecoder_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::InitializeAudioDecoder");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Decryptor::InitializeVideoDecoder_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::InitializeVideoDecoder");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Decryptor::DecryptAndDecodeAudio_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::DecryptAndDecodeAudio");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Decryptor::DecryptAndDecodeVideo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::DecryptAndDecodeVideo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Decryptor::ResetDecoder_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::ResetDecoder");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Decryptor::DeinitializeDecoder_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::Decryptor::DeinitializeDecoder");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Decryptor_Decrypt_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Decryptor_Decrypt_ForwardToCallback(
      Decryptor::DecryptCallback callback
      ) : callback_(std::move(callback)) {
  }

  Decryptor_Decrypt_ForwardToCallback(const Decryptor_Decrypt_ForwardToCallback&) = delete;
  Decryptor_Decrypt_ForwardToCallback& operator=(const Decryptor_Decrypt_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Decryptor::DecryptCallback callback_;
};

class Decryptor_InitializeAudioDecoder_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Decryptor_InitializeAudioDecoder_ForwardToCallback(
      Decryptor::InitializeAudioDecoderCallback callback
      ) : callback_(std::move(callback)) {
  }

  Decryptor_InitializeAudioDecoder_ForwardToCallback(const Decryptor_InitializeAudioDecoder_ForwardToCallback&) = delete;
  Decryptor_InitializeAudioDecoder_ForwardToCallback& operator=(const Decryptor_InitializeAudioDecoder_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Decryptor::InitializeAudioDecoderCallback callback_;
};

class Decryptor_InitializeVideoDecoder_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Decryptor_InitializeVideoDecoder_ForwardToCallback(
      Decryptor::InitializeVideoDecoderCallback callback
      ) : callback_(std::move(callback)) {
  }

  Decryptor_InitializeVideoDecoder_ForwardToCallback(const Decryptor_InitializeVideoDecoder_ForwardToCallback&) = delete;
  Decryptor_InitializeVideoDecoder_ForwardToCallback& operator=(const Decryptor_InitializeVideoDecoder_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Decryptor::InitializeVideoDecoderCallback callback_;
};

class Decryptor_DecryptAndDecodeAudio_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Decryptor_DecryptAndDecodeAudio_ForwardToCallback(
      Decryptor::DecryptAndDecodeAudioCallback callback
      ) : callback_(std::move(callback)) {
  }

  Decryptor_DecryptAndDecodeAudio_ForwardToCallback(const Decryptor_DecryptAndDecodeAudio_ForwardToCallback&) = delete;
  Decryptor_DecryptAndDecodeAudio_ForwardToCallback& operator=(const Decryptor_DecryptAndDecodeAudio_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Decryptor::DecryptAndDecodeAudioCallback callback_;
};

class Decryptor_DecryptAndDecodeVideo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Decryptor_DecryptAndDecodeVideo_ForwardToCallback(
      Decryptor::DecryptAndDecodeVideoCallback callback
      ) : callback_(std::move(callback)) {
  }

  Decryptor_DecryptAndDecodeVideo_ForwardToCallback(const Decryptor_DecryptAndDecodeVideo_ForwardToCallback&) = delete;
  Decryptor_DecryptAndDecodeVideo_ForwardToCallback& operator=(const Decryptor_DecryptAndDecodeVideo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Decryptor::DecryptAndDecodeVideoCallback callback_;
};

DecryptorProxy::DecryptorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DecryptorProxy::Initialize(
    ::mojo::ScopedDataPipeConsumerHandle in_audio_pipe, ::mojo::ScopedDataPipeConsumerHandle in_video_pipe, ::mojo::ScopedDataPipeConsumerHandle in_decrypt_pipe, ::mojo::ScopedDataPipeProducerHandle in_decrypted_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_pipe"), in_audio_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_pipe"), in_video_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decrypt_pipe"), in_decrypt_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decrypted_pipe"), in_decrypted_pipe,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_audio_pipe, &params->audio_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->audio_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid audio_pipe in Decryptor.Initialize request");
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_video_pipe, &params->video_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->video_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid video_pipe in Decryptor.Initialize request");
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_decrypt_pipe, &params->decrypt_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->decrypt_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid decrypt_pipe in Decryptor.Initialize request");
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_decrypted_pipe, &params->decrypted_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->decrypted_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid decrypted_pipe in Decryptor.Initialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DecryptorProxy::Decrypt(
    Decryptor::StreamType in_stream_type, ::media::mojom::blink::DecoderBufferPtr in_encrypted, DecryptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::Decrypt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_type"), in_stream_type,
                        "<value of type Decryptor::StreamType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encrypted"), in_encrypted,
                        "<value of type ::media::mojom::blink::DecoderBufferPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kDecrypt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_Decrypt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::Decryptor_StreamType>(
      in_stream_type, &params->stream_type);
  mojo::internal::MessageFragment<decltype(params->encrypted)>
      encrypted_fragment(params.message());
  encrypted_fragment.Claim(&params->encrypted);
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
      in_encrypted, encrypted_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->encrypted.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encrypted in Decryptor.Decrypt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("Decrypt");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Decryptor_Decrypt_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DecryptorProxy::CancelDecrypt(
    Decryptor::StreamType in_stream_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::CancelDecrypt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_type"), in_stream_type,
                        "<value of type Decryptor::StreamType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kCancelDecrypt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_CancelDecrypt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::Decryptor_StreamType>(
      in_stream_type, &params->stream_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("CancelDecrypt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DecryptorProxy::InitializeAudioDecoder(
    ::media::mojom::blink::AudioDecoderConfigPtr in_config, InitializeAudioDecoderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::InitializeAudioDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::media::mojom::blink::AudioDecoderConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kInitializeAudioDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_InitializeAudioDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioDecoderConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in Decryptor.InitializeAudioDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("InitializeAudioDecoder");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Decryptor_InitializeAudioDecoder_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DecryptorProxy::InitializeVideoDecoder(
    ::media::mojom::blink::VideoDecoderConfigPtr in_config, InitializeVideoDecoderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::InitializeVideoDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::media::mojom::blink::VideoDecoderConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kInitializeVideoDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_InitializeVideoDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoDecoderConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in Decryptor.InitializeVideoDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("InitializeVideoDecoder");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Decryptor_InitializeVideoDecoder_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DecryptorProxy::DecryptAndDecodeAudio(
    ::media::mojom::blink::DecoderBufferPtr in_encrypted, DecryptAndDecodeAudioCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::DecryptAndDecodeAudio", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encrypted"), in_encrypted,
                        "<value of type ::media::mojom::blink::DecoderBufferPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kDecryptAndDecodeAudio), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_DecryptAndDecodeAudio_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->encrypted)>
      encrypted_fragment(params.message());
  encrypted_fragment.Claim(&params->encrypted);
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
      in_encrypted, encrypted_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->encrypted.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encrypted in Decryptor.DecryptAndDecodeAudio request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("DecryptAndDecodeAudio");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Decryptor_DecryptAndDecodeAudio_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DecryptorProxy::DecryptAndDecodeVideo(
    ::media::mojom::blink::DecoderBufferPtr in_encrypted, DecryptAndDecodeVideoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::DecryptAndDecodeVideo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encrypted"), in_encrypted,
                        "<value of type ::media::mojom::blink::DecoderBufferPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kDecryptAndDecodeVideo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_DecryptAndDecodeVideo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->encrypted)>
      encrypted_fragment(params.message());
  encrypted_fragment.Claim(&params->encrypted);
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
      in_encrypted, encrypted_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->encrypted.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encrypted in Decryptor.DecryptAndDecodeVideo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("DecryptAndDecodeVideo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Decryptor_DecryptAndDecodeVideo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DecryptorProxy::ResetDecoder(
    Decryptor::StreamType in_stream_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::ResetDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_type"), in_stream_type,
                        "<value of type Decryptor::StreamType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kResetDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_ResetDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::Decryptor_StreamType>(
      in_stream_type, &params->stream_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("ResetDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DecryptorProxy::DeinitializeDecoder(
    Decryptor::StreamType in_stream_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Decryptor::DeinitializeDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_type"), in_stream_type,
                        "<value of type Decryptor::StreamType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kDeinitializeDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_DeinitializeDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::Decryptor_StreamType>(
      in_stream_type, &params->stream_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("DeinitializeDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Decryptor_Decrypt_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Decryptor::DecryptCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Decryptor_Decrypt_ProxyToResponder> proxy(
        new Decryptor_Decrypt_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Decryptor_Decrypt_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Decryptor_Decrypt_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Decryptor_Decrypt_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Decryptor::DecryptCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      Decryptor::Status in_status, ::media::mojom::blink::DecoderBufferPtr in_buffer);
};

bool Decryptor_Decrypt_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Decryptor_Decrypt_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Decryptor_Decrypt_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Decryptor.1
  bool success = true;
  Decryptor::Status p_status{};
  ::media::mojom::blink::DecoderBufferPtr p_buffer{};
  Decryptor_Decrypt_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadBuffer(&p_buffer))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Decryptor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_buffer));
  return true;
}

void Decryptor_Decrypt_ProxyToResponder::Run(
    Decryptor::Status in_status, ::media::mojom::blink::DecoderBufferPtr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::Decryptor::Decrypt", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type Decryptor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::blink::DecoderBufferPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kDecrypt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_Decrypt_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::Decryptor_Status>(
      in_status, &params->status);
  mojo::internal::MessageFragment<decltype(params->buffer)>
      buffer_fragment(params.message());
  buffer_fragment.Claim(&params->buffer);
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
      in_buffer, buffer_fragment, true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("Decrypt");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Decryptor_InitializeAudioDecoder_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Decryptor::InitializeAudioDecoderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Decryptor_InitializeAudioDecoder_ProxyToResponder> proxy(
        new Decryptor_InitializeAudioDecoder_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Decryptor_InitializeAudioDecoder_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Decryptor_InitializeAudioDecoder_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Decryptor_InitializeAudioDecoder_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Decryptor::InitializeAudioDecoderCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Decryptor_InitializeAudioDecoder_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Decryptor_InitializeAudioDecoder_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Decryptor_InitializeAudioDecoder_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Decryptor.3
  bool success = true;
  bool p_success{};
  Decryptor_InitializeAudioDecoder_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Decryptor::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Decryptor_InitializeAudioDecoder_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::Decryptor::InitializeAudioDecoder", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kInitializeAudioDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_InitializeAudioDecoder_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("InitializeAudioDecoder");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Decryptor_InitializeVideoDecoder_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Decryptor::InitializeVideoDecoderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Decryptor_InitializeVideoDecoder_ProxyToResponder> proxy(
        new Decryptor_InitializeVideoDecoder_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Decryptor_InitializeVideoDecoder_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Decryptor_InitializeVideoDecoder_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Decryptor_InitializeVideoDecoder_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Decryptor::InitializeVideoDecoderCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Decryptor_InitializeVideoDecoder_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Decryptor_InitializeVideoDecoder_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Decryptor_InitializeVideoDecoder_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Decryptor.4
  bool success = true;
  bool p_success{};
  Decryptor_InitializeVideoDecoder_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Decryptor::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Decryptor_InitializeVideoDecoder_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::Decryptor::InitializeVideoDecoder", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kInitializeVideoDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_InitializeVideoDecoder_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("InitializeVideoDecoder");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Decryptor_DecryptAndDecodeAudio_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Decryptor::DecryptAndDecodeAudioCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Decryptor_DecryptAndDecodeAudio_ProxyToResponder> proxy(
        new Decryptor_DecryptAndDecodeAudio_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Decryptor_DecryptAndDecodeAudio_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Decryptor_DecryptAndDecodeAudio_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Decryptor_DecryptAndDecodeAudio_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Decryptor::DecryptAndDecodeAudioCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      Decryptor::Status in_status, WTF::Vector<::media::mojom::blink::AudioBufferPtr> in_audio_buffers);
};

bool Decryptor_DecryptAndDecodeAudio_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Decryptor_DecryptAndDecodeAudio_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Decryptor_DecryptAndDecodeAudio_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Decryptor.5
  bool success = true;
  Decryptor::Status p_status{};
  WTF::Vector<::media::mojom::blink::AudioBufferPtr> p_audio_buffers{};
  Decryptor_DecryptAndDecodeAudio_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadAudioBuffers(&p_audio_buffers))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Decryptor::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_audio_buffers));
  return true;
}

void Decryptor_DecryptAndDecodeAudio_ProxyToResponder::Run(
    Decryptor::Status in_status, WTF::Vector<::media::mojom::blink::AudioBufferPtr> in_audio_buffers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::Decryptor::DecryptAndDecodeAudio", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type Decryptor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_buffers"), in_audio_buffers,
                        "<value of type WTF::Vector<::media::mojom::blink::AudioBufferPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kDecryptAndDecodeAudio), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_DecryptAndDecodeAudio_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::Decryptor_Status>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->audio_buffers)::BaseType>
      audio_buffers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& audio_buffers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::AudioBufferDataView>>(
      in_audio_buffers, audio_buffers_fragment, &audio_buffers_validate_params);
  params->audio_buffers.Set(
      audio_buffers_fragment.is_null() ? nullptr : audio_buffers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_buffers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_buffers in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("DecryptAndDecodeAudio");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Decryptor_DecryptAndDecodeVideo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Decryptor::DecryptAndDecodeVideoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Decryptor_DecryptAndDecodeVideo_ProxyToResponder> proxy(
        new Decryptor_DecryptAndDecodeVideo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Decryptor_DecryptAndDecodeVideo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Decryptor_DecryptAndDecodeVideo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Decryptor_DecryptAndDecodeVideo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Decryptor::DecryptAndDecodeVideoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      Decryptor::Status in_status, ::media::mojom::blink::VideoFramePtr in_video_frame, ::mojo::PendingRemote<FrameResourceReleaser> in_releaser);
};

bool Decryptor_DecryptAndDecodeVideo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Decryptor_DecryptAndDecodeVideo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Decryptor_DecryptAndDecodeVideo_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Decryptor.6
  bool success = true;
  Decryptor::Status p_status{};
  ::media::mojom::blink::VideoFramePtr p_video_frame{};
  ::mojo::PendingRemote<FrameResourceReleaser> p_releaser{};
  Decryptor_DecryptAndDecodeVideo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadVideoFrame(&p_video_frame))
    success = false;
  if (success) {
    p_releaser =
        input_data_view.TakeReleaser<decltype(p_releaser)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Decryptor::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_video_frame), 
std::move(p_releaser));
  return true;
}

void Decryptor_DecryptAndDecodeVideo_ProxyToResponder::Run(
    Decryptor::Status in_status, ::media::mojom::blink::VideoFramePtr in_video_frame, ::mojo::PendingRemote<FrameResourceReleaser> in_releaser) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::Decryptor::DecryptAndDecodeVideo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type Decryptor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_frame"), in_video_frame,
                        "<value of type ::media::mojom::blink::VideoFramePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("releaser"), in_releaser,
                        "<value of type ::mojo::PendingRemote<FrameResourceReleaser>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Decryptor::kDecryptAndDecodeVideo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Decryptor_DecryptAndDecodeVideo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::Decryptor_Status>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->video_frame)::BaseType> video_frame_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameDataView>(
      in_video_frame, video_frame_fragment);
  params->video_frame.Set(
      video_frame_fragment.is_null() ? nullptr : video_frame_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::FrameResourceReleaserInterfaceBase>>(
      in_releaser, &params->releaser, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Decryptor::Name_);
  message.set_method_name("DecryptAndDecodeVideo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DecryptorStubDispatch::Accept(
    Decryptor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Decryptor>(message->header()->name)) {
    case messages::Decryptor::kInitialize: {
      DCHECK(message->is_serialized());
      internal::Decryptor_Initialize_Params_Data* params =
          reinterpret_cast<internal::Decryptor_Initialize_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Decryptor.0
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_audio_pipe{};
      ::mojo::ScopedDataPipeConsumerHandle p_video_pipe{};
      ::mojo::ScopedDataPipeConsumerHandle p_decrypt_pipe{};
      ::mojo::ScopedDataPipeProducerHandle p_decrypted_pipe{};
      Decryptor_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_audio_pipe = input_data_view.TakeAudioPipe();
      if (success)
        p_video_pipe = input_data_view.TakeVideoPipe();
      if (success)
        p_decrypt_pipe = input_data_view.TakeDecryptPipe();
      if (success)
        p_decrypted_pipe = input_data_view.TakeDecryptedPipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_audio_pipe), 
        std::move(p_video_pipe), 
        std::move(p_decrypt_pipe), 
        std::move(p_decrypted_pipe));
      return true;
    }
    case messages::Decryptor::kDecrypt: {
      break;
    }
    case messages::Decryptor::kCancelDecrypt: {
      DCHECK(message->is_serialized());
      internal::Decryptor_CancelDecrypt_Params_Data* params =
          reinterpret_cast<internal::Decryptor_CancelDecrypt_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Decryptor.2
      bool success = true;
      Decryptor::StreamType p_stream_type{};
      Decryptor_CancelDecrypt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStreamType(&p_stream_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelDecrypt(        
        std::move(p_stream_type));
      return true;
    }
    case messages::Decryptor::kInitializeAudioDecoder: {
      break;
    }
    case messages::Decryptor::kInitializeVideoDecoder: {
      break;
    }
    case messages::Decryptor::kDecryptAndDecodeAudio: {
      break;
    }
    case messages::Decryptor::kDecryptAndDecodeVideo: {
      break;
    }
    case messages::Decryptor::kResetDecoder: {
      DCHECK(message->is_serialized());
      internal::Decryptor_ResetDecoder_Params_Data* params =
          reinterpret_cast<internal::Decryptor_ResetDecoder_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Decryptor.7
      bool success = true;
      Decryptor::StreamType p_stream_type{};
      Decryptor_ResetDecoder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStreamType(&p_stream_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetDecoder(        
        std::move(p_stream_type));
      return true;
    }
    case messages::Decryptor::kDeinitializeDecoder: {
      DCHECK(message->is_serialized());
      internal::Decryptor_DeinitializeDecoder_Params_Data* params =
          reinterpret_cast<internal::Decryptor_DeinitializeDecoder_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Decryptor.8
      bool success = true;
      Decryptor::StreamType p_stream_type{};
      Decryptor_DeinitializeDecoder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStreamType(&p_stream_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeinitializeDecoder(        
        std::move(p_stream_type));
      return true;
    }
  }
  return false;
}

// static
bool DecryptorStubDispatch::AcceptWithResponder(
    Decryptor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Decryptor>(message->header()->name)) {
    case messages::Decryptor::kInitialize: {
      break;
    }
    case messages::Decryptor::kDecrypt: {
      internal::Decryptor_Decrypt_Params_Data* params =
          reinterpret_cast<
              internal::Decryptor_Decrypt_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Decryptor.1
      bool success = true;
      Decryptor::StreamType p_stream_type{};
      ::media::mojom::blink::DecoderBufferPtr p_encrypted{};
      Decryptor_Decrypt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStreamType(&p_stream_type))
        success = false;
      if (success && !input_data_view.ReadEncrypted(&p_encrypted))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 1, false);
        return false;
      }
      Decryptor::DecryptCallback callback =
          Decryptor_Decrypt_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decrypt(        
        std::move(p_stream_type), 
        std::move(p_encrypted), std::move(callback));
      return true;
    }
    case messages::Decryptor::kCancelDecrypt: {
      break;
    }
    case messages::Decryptor::kInitializeAudioDecoder: {
      internal::Decryptor_InitializeAudioDecoder_Params_Data* params =
          reinterpret_cast<
              internal::Decryptor_InitializeAudioDecoder_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Decryptor.3
      bool success = true;
      ::media::mojom::blink::AudioDecoderConfigPtr p_config{};
      Decryptor_InitializeAudioDecoder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 3, false);
        return false;
      }
      Decryptor::InitializeAudioDecoderCallback callback =
          Decryptor_InitializeAudioDecoder_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeAudioDecoder(        
        std::move(p_config), std::move(callback));
      return true;
    }
    case messages::Decryptor::kInitializeVideoDecoder: {
      internal::Decryptor_InitializeVideoDecoder_Params_Data* params =
          reinterpret_cast<
              internal::Decryptor_InitializeVideoDecoder_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Decryptor.4
      bool success = true;
      ::media::mojom::blink::VideoDecoderConfigPtr p_config{};
      Decryptor_InitializeVideoDecoder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 4, false);
        return false;
      }
      Decryptor::InitializeVideoDecoderCallback callback =
          Decryptor_InitializeVideoDecoder_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeVideoDecoder(        
        std::move(p_config), std::move(callback));
      return true;
    }
    case messages::Decryptor::kDecryptAndDecodeAudio: {
      internal::Decryptor_DecryptAndDecodeAudio_Params_Data* params =
          reinterpret_cast<
              internal::Decryptor_DecryptAndDecodeAudio_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Decryptor.5
      bool success = true;
      ::media::mojom::blink::DecoderBufferPtr p_encrypted{};
      Decryptor_DecryptAndDecodeAudio_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncrypted(&p_encrypted))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 5, false);
        return false;
      }
      Decryptor::DecryptAndDecodeAudioCallback callback =
          Decryptor_DecryptAndDecodeAudio_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecryptAndDecodeAudio(        
        std::move(p_encrypted), std::move(callback));
      return true;
    }
    case messages::Decryptor::kDecryptAndDecodeVideo: {
      internal::Decryptor_DecryptAndDecodeVideo_Params_Data* params =
          reinterpret_cast<
              internal::Decryptor_DecryptAndDecodeVideo_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Decryptor.6
      bool success = true;
      ::media::mojom::blink::DecoderBufferPtr p_encrypted{};
      Decryptor_DecryptAndDecodeVideo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncrypted(&p_encrypted))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Decryptor::Name_, 6, false);
        return false;
      }
      Decryptor::DecryptAndDecodeVideoCallback callback =
          Decryptor_DecryptAndDecodeVideo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecryptAndDecodeVideo(        
        std::move(p_encrypted), std::move(callback));
      return true;
    }
    case messages::Decryptor::kResetDecoder: {
      break;
    }
    case messages::Decryptor::kDeinitializeDecoder: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDecryptorValidationInfo[] = {
    {base::to_underlying(messages::Decryptor::kInitialize),
     { &internal::Decryptor_Initialize_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Decryptor::kDecrypt),
     { &internal::Decryptor_Decrypt_Params_Data::Validate,
      &internal::Decryptor_Decrypt_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Decryptor::kCancelDecrypt),
     { &internal::Decryptor_CancelDecrypt_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Decryptor::kInitializeAudioDecoder),
     { &internal::Decryptor_InitializeAudioDecoder_Params_Data::Validate,
      &internal::Decryptor_InitializeAudioDecoder_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Decryptor::kInitializeVideoDecoder),
     { &internal::Decryptor_InitializeVideoDecoder_Params_Data::Validate,
      &internal::Decryptor_InitializeVideoDecoder_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Decryptor::kDecryptAndDecodeAudio),
     { &internal::Decryptor_DecryptAndDecodeAudio_Params_Data::Validate,
      &internal::Decryptor_DecryptAndDecodeAudio_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Decryptor::kDecryptAndDecodeVideo),
     { &internal::Decryptor_DecryptAndDecodeVideo_Params_Data::Validate,
      &internal::Decryptor_DecryptAndDecodeVideo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Decryptor::kResetDecoder),
     { &internal::Decryptor_ResetDecoder_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Decryptor::kDeinitializeDecoder),
     { &internal::Decryptor_DeinitializeDecoder_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DecryptorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::Decryptor::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDecryptorValidationInfo);
}

bool DecryptorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::Decryptor::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDecryptorValidationInfo);

}
const char FrameResourceReleaser::Name_[] = "media.mojom.FrameResourceReleaser";

FrameResourceReleaser::IPCStableHashFunction FrameResourceReleaser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameResourceReleaser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameResourceReleaserProxy::FrameResourceReleaserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool FrameResourceReleaserStubDispatch::Accept(
    FrameResourceReleaser* impl,
    mojo::Message* message) {
  return false;
}

// static
bool FrameResourceReleaserStubDispatch::AcceptWithResponder(
    FrameResourceReleaser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool FrameResourceReleaserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::FrameResourceReleaser::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}



}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void DecryptorInterceptorForTesting::Initialize(::mojo::ScopedDataPipeConsumerHandle audio_pipe, ::mojo::ScopedDataPipeConsumerHandle video_pipe, ::mojo::ScopedDataPipeConsumerHandle decrypt_pipe, ::mojo::ScopedDataPipeProducerHandle decrypted_pipe) {
  GetForwardingInterface()->Initialize(
    std::move(audio_pipe)
    , 
    std::move(video_pipe)
    , 
    std::move(decrypt_pipe)
    , 
    std::move(decrypted_pipe)
    );
}
void DecryptorInterceptorForTesting::Decrypt(Decryptor::StreamType stream_type, ::media::mojom::blink::DecoderBufferPtr encrypted, DecryptCallback callback) {
  GetForwardingInterface()->Decrypt(
    std::move(stream_type)
    , 
    std::move(encrypted)
    , std::move(callback));
}
void DecryptorInterceptorForTesting::CancelDecrypt(Decryptor::StreamType stream_type) {
  GetForwardingInterface()->CancelDecrypt(
    std::move(stream_type)
    );
}
void DecryptorInterceptorForTesting::InitializeAudioDecoder(::media::mojom::blink::AudioDecoderConfigPtr config, InitializeAudioDecoderCallback callback) {
  GetForwardingInterface()->InitializeAudioDecoder(
    std::move(config)
    , std::move(callback));
}
void DecryptorInterceptorForTesting::InitializeVideoDecoder(::media::mojom::blink::VideoDecoderConfigPtr config, InitializeVideoDecoderCallback callback) {
  GetForwardingInterface()->InitializeVideoDecoder(
    std::move(config)
    , std::move(callback));
}
void DecryptorInterceptorForTesting::DecryptAndDecodeAudio(::media::mojom::blink::DecoderBufferPtr encrypted, DecryptAndDecodeAudioCallback callback) {
  GetForwardingInterface()->DecryptAndDecodeAudio(
    std::move(encrypted)
    , std::move(callback));
}
void DecryptorInterceptorForTesting::DecryptAndDecodeVideo(::media::mojom::blink::DecoderBufferPtr encrypted, DecryptAndDecodeVideoCallback callback) {
  GetForwardingInterface()->DecryptAndDecodeVideo(
    std::move(encrypted)
    , std::move(callback));
}
void DecryptorInterceptorForTesting::ResetDecoder(Decryptor::StreamType stream_type) {
  GetForwardingInterface()->ResetDecoder(
    std::move(stream_type)
    );
}
void DecryptorInterceptorForTesting::DeinitializeDecoder(Decryptor::StreamType stream_type) {
  GetForwardingInterface()->DeinitializeDecoder(
    std::move(stream_type)
    );
}
DecryptorAsyncWaiter::DecryptorAsyncWaiter(
    Decryptor* proxy) : proxy_(proxy) {}

DecryptorAsyncWaiter::~DecryptorAsyncWaiter() = default;

void DecryptorAsyncWaiter::Decrypt(
    Decryptor::StreamType stream_type, ::media::mojom::blink::DecoderBufferPtr encrypted, Decryptor::Status* out_status, ::media::mojom::blink::DecoderBufferPtr* out_buffer) {
  base::RunLoop loop;
  proxy_->Decrypt(
      std::move(stream_type),
      std::move(encrypted),
      base::BindOnce(
          [](base::RunLoop* loop,
             Decryptor::Status* out_status
,
             ::media::mojom::blink::DecoderBufferPtr* out_buffer
,
             Decryptor::Status status,
             ::media::mojom::blink::DecoderBufferPtr buffer) {*out_status = std::move(status);*out_buffer = std::move(buffer);
            loop->Quit();
          },
          &loop,
          out_status,
          out_buffer));
  loop.Run();
}



void DecryptorAsyncWaiter::InitializeAudioDecoder(
    ::media::mojom::blink::AudioDecoderConfigPtr config, bool* out_success) {
  base::RunLoop loop;
  proxy_->InitializeAudioDecoder(
      std::move(config),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool DecryptorAsyncWaiter::InitializeAudioDecoder(
    ::media::mojom::blink::AudioDecoderConfigPtr config) {
  bool async_wait_result;
  InitializeAudioDecoder(std::move(config),&async_wait_result);
  return async_wait_result;
}

void DecryptorAsyncWaiter::InitializeVideoDecoder(
    ::media::mojom::blink::VideoDecoderConfigPtr config, bool* out_success) {
  base::RunLoop loop;
  proxy_->InitializeVideoDecoder(
      std::move(config),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool DecryptorAsyncWaiter::InitializeVideoDecoder(
    ::media::mojom::blink::VideoDecoderConfigPtr config) {
  bool async_wait_result;
  InitializeVideoDecoder(std::move(config),&async_wait_result);
  return async_wait_result;
}

void DecryptorAsyncWaiter::DecryptAndDecodeAudio(
    ::media::mojom::blink::DecoderBufferPtr encrypted, Decryptor::Status* out_status, WTF::Vector<::media::mojom::blink::AudioBufferPtr>* out_audio_buffers) {
  base::RunLoop loop;
  proxy_->DecryptAndDecodeAudio(
      std::move(encrypted),
      base::BindOnce(
          [](base::RunLoop* loop,
             Decryptor::Status* out_status
,
             WTF::Vector<::media::mojom::blink::AudioBufferPtr>* out_audio_buffers
,
             Decryptor::Status status,
             WTF::Vector<::media::mojom::blink::AudioBufferPtr> audio_buffers) {*out_status = std::move(status);*out_audio_buffers = std::move(audio_buffers);
            loop->Quit();
          },
          &loop,
          out_status,
          out_audio_buffers));
  loop.Run();
}



void DecryptorAsyncWaiter::DecryptAndDecodeVideo(
    ::media::mojom::blink::DecoderBufferPtr encrypted, Decryptor::Status* out_status, ::media::mojom::blink::VideoFramePtr* out_video_frame, ::mojo::PendingRemote<FrameResourceReleaser>* out_releaser) {
  base::RunLoop loop;
  proxy_->DecryptAndDecodeVideo(
      std::move(encrypted),
      base::BindOnce(
          [](base::RunLoop* loop,
             Decryptor::Status* out_status
,
             ::media::mojom::blink::VideoFramePtr* out_video_frame
,
             ::mojo::PendingRemote<FrameResourceReleaser>* out_releaser
,
             Decryptor::Status status,
             ::media::mojom::blink::VideoFramePtr video_frame,
             ::mojo::PendingRemote<FrameResourceReleaser> releaser) {*out_status = std::move(status);*out_video_frame = std::move(video_frame);*out_releaser = std::move(releaser);
            loop->Quit();
          },
          &loop,
          out_status,
          out_video_frame,
          out_releaser));
  loop.Run();
}






FrameResourceReleaserAsyncWaiter::FrameResourceReleaserAsyncWaiter(
    FrameResourceReleaser* proxy) : proxy_(proxy) {}

FrameResourceReleaserAsyncWaiter::~FrameResourceReleaserAsyncWaiter() = default;






}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif