// services/network/public/mojom/network_anonymization_key.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_anonymization_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"







namespace network::mojom {
class EmptyNetworkAnonymizationKeyDataView;

class NonEmptyNetworkAnonymizationKeyDataView;

class NetworkAnonymizationKeyDataView;


}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::EmptyNetworkAnonymizationKeyDataView> {
  using Data = ::network::mojom::internal::EmptyNetworkAnonymizationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView> {
  using Data = ::network::mojom::internal::NonEmptyNetworkAnonymizationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkAnonymizationKeyDataView> {
  using Data = ::network::mojom::internal::NetworkAnonymizationKey_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class EmptyNetworkAnonymizationKeyDataView {
 public:
  EmptyNetworkAnonymizationKeyDataView() = default;

  EmptyNetworkAnonymizationKeyDataView(
      internal::EmptyNetworkAnonymizationKey_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::EmptyNetworkAnonymizationKey_Data* data_ = nullptr;
};


class NonEmptyNetworkAnonymizationKeyDataView {
 public:
  NonEmptyNetworkAnonymizationKeyDataView() = default;

  NonEmptyNetworkAnonymizationKeyDataView(
      internal::NonEmptyNetworkAnonymizationKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopFrameSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameSite(UserType* output) {
    
    auto* pointer = data_->top_frame_site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  bool is_cross_site() const {
    return data_->is_cross_site;
  }
  inline void GetNonceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::NonEmptyNetworkAnonymizationKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkAnonymizationKeyDataView {
 public:
  using Tag = internal::NetworkAnonymizationKey_Data::NetworkAnonymizationKey_Tag;

  NetworkAnonymizationKeyDataView() = default;

  NetworkAnonymizationKeyDataView(
      internal::NetworkAnonymizationKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_empty() const { return data_->tag == Tag::kEmpty; }
  inline void GetEmptyDataView(
      EmptyNetworkAnonymizationKeyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEmpty(UserType* output) const {
    
    CHECK(is_empty());
    return mojo::internal::Deserialize<::network::mojom::EmptyNetworkAnonymizationKeyDataView>(
        data_->data.f_empty.Get(), output, message_);
  }
  bool is_non_empty() const { return data_->tag == Tag::kNonEmpty; }
  inline void GetNonEmptyDataView(
      NonEmptyNetworkAnonymizationKeyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNonEmpty(UserType* output) const {
    
    CHECK(is_non_empty());
    return mojo::internal::Deserialize<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView>(
        data_->data.f_non_empty.Get(), output, message_);
  }

 private:
  internal::NetworkAnonymizationKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::EmptyNetworkAnonymizationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::EmptyNetworkAnonymizationKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::EmptyNetworkAnonymizationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::network::mojom::internal::EmptyNetworkAnonymizationKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::EmptyNetworkAnonymizationKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NonEmptyNetworkAnonymizationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::top_frame_site(input)) in_top_frame_site = Traits::top_frame_site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_site)::BaseType> top_frame_site_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
        in_top_frame_site, top_frame_site_fragment);
    fragment->top_frame_site.Set(
        top_frame_site_fragment.is_null() ? nullptr : top_frame_site_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->top_frame_site.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_site in NonEmptyNetworkAnonymizationKey struct");
    fragment->is_cross_site = Traits::is_cross_site(input);
    decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nonce)::BaseType> nonce_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_nonce, nonce_fragment);
    fragment->nonce.Set(
        nonce_fragment.is_null() ? nullptr : nonce_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::NonEmptyNetworkAnonymizationKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NonEmptyNetworkAnonymizationKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkAnonymizationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::NetworkAnonymizationKeyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::NetworkAnonymizationKey_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::network::mojom::NetworkAnonymizationKeyDataView::Tag::kEmpty: {
        decltype(Traits::empty(input))
            in_empty = Traits::empty(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_empty)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::EmptyNetworkAnonymizationKeyDataView>(
            in_empty, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null empty in NetworkAnonymizationKey union");
        fragment->data.f_empty.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::NetworkAnonymizationKeyDataView::Tag::kNonEmpty: {
        decltype(Traits::non_empty(input))
            in_non_empty = Traits::non_empty(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_non_empty)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView>(
            in_non_empty, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null non_empty in NetworkAnonymizationKey union");
        fragment->data.f_non_empty.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::network::mojom::internal::NetworkAnonymizationKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkAnonymizationKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {



inline void NonEmptyNetworkAnonymizationKeyDataView::GetTopFrameSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->top_frame_site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void NonEmptyNetworkAnonymizationKeyDataView::GetNonceDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->nonce.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void NetworkAnonymizationKeyDataView::GetEmptyDataView(
    EmptyNetworkAnonymizationKeyDataView* output) const {
  CHECK(is_empty());
  *output = EmptyNetworkAnonymizationKeyDataView(data_->data.f_empty.Get(), message_);
}
inline void NetworkAnonymizationKeyDataView::GetNonEmptyDataView(
    NonEmptyNetworkAnonymizationKeyDataView* output) const {
  CHECK(is_non_empty());
  *output = NonEmptyNetworkAnonymizationKeyDataView(data_->data.f_non_empty.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_SHARED_H_