// services/network/public/mojom/p2p.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  P2PNetworkNotificationClient_NetworkListChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::NetworkInterface_Data>>> networks;
  mojo::internal::Pointer<::network::mojom::internal::IPAddress_Data> default_ipv4_local_address;
  mojo::internal::Pointer<::network::mojom::internal::IPAddress_Data> default_ipv6_local_address;

 private:
  friend class mojo::internal::MessageFragment<P2PNetworkNotificationClient_NetworkListChanged_Params_Data>;

  P2PNetworkNotificationClient_NetworkListChanged_Params_Data();
  ~P2PNetworkNotificationClient_NetworkListChanged_Params_Data() = delete;
};
static_assert(sizeof(P2PNetworkNotificationClient_NetworkListChanged_Params_Data) == 32,
              "Bad sizeof(P2PNetworkNotificationClient_NetworkListChanged_Params_Data)");
class  P2PSocketManager_StartNetworkNotifications_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data client;

 private:
  friend class mojo::internal::MessageFragment<P2PSocketManager_StartNetworkNotifications_Params_Data>;

  P2PSocketManager_StartNetworkNotifications_Params_Data();
  ~P2PSocketManager_StartNetworkNotifications_Params_Data() = delete;
};
static_assert(sizeof(P2PSocketManager_StartNetworkNotifications_Params_Data) == 16,
              "Bad sizeof(P2PSocketManager_StartNetworkNotifications_Params_Data)");
class  P2PSocketManager_GetHostAddress_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> host_name;
  uint8_t enable_mdns : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<P2PSocketManager_GetHostAddress_Params_Data>;

  P2PSocketManager_GetHostAddress_Params_Data();
  ~P2PSocketManager_GetHostAddress_Params_Data() = delete;
};
static_assert(sizeof(P2PSocketManager_GetHostAddress_Params_Data) == 24,
              "Bad sizeof(P2PSocketManager_GetHostAddress_Params_Data)");
class  P2PSocketManager_GetHostAddress_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::IPAddress_Data>>> addresses;

 private:
  friend class mojo::internal::MessageFragment<P2PSocketManager_GetHostAddress_ResponseParams_Data>;

  P2PSocketManager_GetHostAddress_ResponseParams_Data();
  ~P2PSocketManager_GetHostAddress_ResponseParams_Data() = delete;
};
static_assert(sizeof(P2PSocketManager_GetHostAddress_ResponseParams_Data) == 16,
              "Bad sizeof(P2PSocketManager_GetHostAddress_ResponseParams_Data)");
class  P2PSocketManager_GetHostAddressWithFamily_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> host_name;
  int32_t address_family;
  uint8_t enable_mdns : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<P2PSocketManager_GetHostAddressWithFamily_Params_Data>;

  P2PSocketManager_GetHostAddressWithFamily_Params_Data();
  ~P2PSocketManager_GetHostAddressWithFamily_Params_Data() = delete;
};
static_assert(sizeof(P2PSocketManager_GetHostAddressWithFamily_Params_Data) == 24,
              "Bad sizeof(P2PSocketManager_GetHostAddressWithFamily_Params_Data)");
class  P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::IPAddress_Data>>> addresses;

 private:
  friend class mojo::internal::MessageFragment<P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data>;

  P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data();
  ~P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data() = delete;
};
static_assert(sizeof(P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data) == 16,
              "Bad sizeof(P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data)");
class  P2PSocketManager_CreateSocket_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  mojo::internal::Handle_Data socket;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> local_address;
  mojo::internal::Pointer<internal::P2PPortRange_Data> port_range;
  mojo::internal::Pointer<internal::P2PHostAndIPEndPoint_Data> remote_address;
  mojo::internal::Pointer<::network::mojom::internal::MutableNetworkTrafficAnnotationTag_Data> traffic_annotation;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtools_token;
  mojo::internal::Interface_Data client;

 private:
  friend class mojo::internal::MessageFragment<P2PSocketManager_CreateSocket_Params_Data>;

  P2PSocketManager_CreateSocket_Params_Data();
  ~P2PSocketManager_CreateSocket_Params_Data() = delete;
};
static_assert(sizeof(P2PSocketManager_CreateSocket_Params_Data) == 64,
              "Bad sizeof(P2PSocketManager_CreateSocket_Params_Data)");
class  P2PSocket_Send_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;
  mojo::internal::Pointer<internal::P2PPacketInfo_Data> packet_info;

 private:
  friend class mojo::internal::MessageFragment<P2PSocket_Send_Params_Data>;

  P2PSocket_Send_Params_Data();
  ~P2PSocket_Send_Params_Data() = delete;
};
static_assert(sizeof(P2PSocket_Send_Params_Data) == 24,
              "Bad sizeof(P2PSocket_Send_Params_Data)");
class  P2PSocket_SendBatch_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::P2PSendPacket_Data>>> packet_batch;

 private:
  friend class mojo::internal::MessageFragment<P2PSocket_SendBatch_Params_Data>;

  P2PSocket_SendBatch_Params_Data();
  ~P2PSocket_SendBatch_Params_Data() = delete;
};
static_assert(sizeof(P2PSocket_SendBatch_Params_Data) == 16,
              "Bad sizeof(P2PSocket_SendBatch_Params_Data)");
class  P2PSocket_SetOption_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t option;
  int32_t value;

 private:
  friend class mojo::internal::MessageFragment<P2PSocket_SetOption_Params_Data>;

  P2PSocket_SetOption_Params_Data();
  ~P2PSocket_SetOption_Params_Data() = delete;
};
static_assert(sizeof(P2PSocket_SetOption_Params_Data) == 16,
              "Bad sizeof(P2PSocket_SetOption_Params_Data)");
class  P2PSocketClient_SocketCreated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> local_address;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> remote_address;

 private:
  friend class mojo::internal::MessageFragment<P2PSocketClient_SocketCreated_Params_Data>;

  P2PSocketClient_SocketCreated_Params_Data();
  ~P2PSocketClient_SocketCreated_Params_Data() = delete;
};
static_assert(sizeof(P2PSocketClient_SocketCreated_Params_Data) == 24,
              "Bad sizeof(P2PSocketClient_SocketCreated_Params_Data)");
class  P2PSocketClient_SendComplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::P2PSendPacketMetrics_Data> send_metrics;

 private:
  friend class mojo::internal::MessageFragment<P2PSocketClient_SendComplete_Params_Data>;

  P2PSocketClient_SendComplete_Params_Data();
  ~P2PSocketClient_SendComplete_Params_Data() = delete;
};
static_assert(sizeof(P2PSocketClient_SendComplete_Params_Data) == 16,
              "Bad sizeof(P2PSocketClient_SendComplete_Params_Data)");
class  P2PSocketClient_SendBatchComplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::P2PSendPacketMetrics_Data>>> send_metrics_batch;

 private:
  friend class mojo::internal::MessageFragment<P2PSocketClient_SendBatchComplete_Params_Data>;

  P2PSocketClient_SendBatchComplete_Params_Data();
  ~P2PSocketClient_SendBatchComplete_Params_Data() = delete;
};
static_assert(sizeof(P2PSocketClient_SendBatchComplete_Params_Data) == 16,
              "Bad sizeof(P2PSocketClient_SendBatchComplete_Params_Data)");
class  P2PSocketClient_DataReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::P2PReceivedPacket_Data>>> packets;

 private:
  friend class mojo::internal::MessageFragment<P2PSocketClient_DataReceived_Params_Data>;

  P2PSocketClient_DataReceived_Params_Data();
  ~P2PSocketClient_DataReceived_Params_Data() = delete;
};
static_assert(sizeof(P2PSocketClient_DataReceived_Params_Data) == 16,
              "Bad sizeof(P2PSocketClient_DataReceived_Params_Data)");

}  // namespace internal


class P2PNetworkNotificationClient_NetworkListChanged_ParamsDataView {
 public:
  P2PNetworkNotificationClient_NetworkListChanged_ParamsDataView() = default;

  P2PNetworkNotificationClient_NetworkListChanged_ParamsDataView(
      internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNetworksDataView(
      mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworks(UserType* output) {
    
    auto* pointer = data_->networks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>>(
        pointer, output, message_);
  }
  inline void GetDefaultIpv4LocalAddressDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultIpv4LocalAddress(UserType* output) {
    
    auto* pointer = data_->default_ipv4_local_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
  inline void GetDefaultIpv6LocalAddressDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultIpv6LocalAddress(UserType* output) {
    
    auto* pointer = data_->default_ipv6_local_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
 private:
  internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketManager_StartNetworkNotifications_ParamsDataView {
 public:
  P2PSocketManager_StartNetworkNotifications_ParamsDataView() = default;

  P2PSocketManager_StartNetworkNotifications_ParamsDataView(
      internal::P2PSocketManager_StartNetworkNotifications_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::P2PNetworkNotificationClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::P2PSocketManager_StartNetworkNotifications_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketManager_GetHostAddress_ParamsDataView {
 public:
  P2PSocketManager_GetHostAddress_ParamsDataView() = default;

  P2PSocketManager_GetHostAddress_ParamsDataView(
      internal::P2PSocketManager_GetHostAddress_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostName(UserType* output) {
    
    auto* pointer = data_->host_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool enable_mdns() const {
    return data_->enable_mdns;
  }
 private:
  internal::P2PSocketManager_GetHostAddress_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketManager_GetHostAddress_ResponseParamsDataView {
 public:
  P2PSocketManager_GetHostAddress_ResponseParamsDataView() = default;

  P2PSocketManager_GetHostAddress_ResponseParamsDataView(
      internal::P2PSocketManager_GetHostAddress_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressesDataView(
      mojo::ArrayDataView<::network::mojom::IPAddressDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddresses(UserType* output) {
    
    auto* pointer = data_->addresses.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>(
        pointer, output, message_);
  }
 private:
  internal::P2PSocketManager_GetHostAddress_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketManager_GetHostAddressWithFamily_ParamsDataView {
 public:
  P2PSocketManager_GetHostAddressWithFamily_ParamsDataView() = default;

  P2PSocketManager_GetHostAddressWithFamily_ParamsDataView(
      internal::P2PSocketManager_GetHostAddressWithFamily_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostName(UserType* output) {
    
    auto* pointer = data_->host_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t address_family() const {
    return data_->address_family;
  }
  bool enable_mdns() const {
    return data_->enable_mdns;
  }
 private:
  internal::P2PSocketManager_GetHostAddressWithFamily_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketManager_GetHostAddressWithFamily_ResponseParamsDataView {
 public:
  P2PSocketManager_GetHostAddressWithFamily_ResponseParamsDataView() = default;

  P2PSocketManager_GetHostAddressWithFamily_ResponseParamsDataView(
      internal::P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressesDataView(
      mojo::ArrayDataView<::network::mojom::IPAddressDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddresses(UserType* output) {
    
    auto* pointer = data_->addresses.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>(
        pointer, output, message_);
  }
 private:
  internal::P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketManager_CreateSocket_ParamsDataView {
 public:
  P2PSocketManager_CreateSocket_ParamsDataView() = default;

  P2PSocketManager_CreateSocket_ParamsDataView(
      internal::P2PSocketManager_CreateSocket_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::P2PSocketType>(
        data_value, output);
  }
  P2PSocketType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::P2PSocketType>(data_->type));
  }
  inline void GetLocalAddressDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalAddress(UserType* output) {
    
    auto* pointer = data_->local_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  inline void GetPortRangeDataView(
      P2PPortRangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPortRange(UserType* output) {
    
    auto* pointer = data_->port_range.Get();
    return mojo::internal::Deserialize<::network::mojom::P2PPortRangeDataView>(
        pointer, output, message_);
  }
  inline void GetRemoteAddressDataView(
      P2PHostAndIPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteAddress(UserType* output) {
    
    auto* pointer = data_->remote_address.Get();
    return mojo::internal::Deserialize<::network::mojom::P2PHostAndIPEndPointDataView>(
        pointer, output, message_);
  }
  inline void GetTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `devtools_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsToken` instead "
    "of `ReadDevtoolsToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::P2PSocketClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeSocket() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::P2PSocketInterfaceBase>>(
            &data_->socket, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::P2PSocketManager_CreateSocket_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocket_Send_ParamsDataView {
 public:
  P2PSocket_Send_ParamsDataView() = default;

  P2PSocket_Send_ParamsDataView(
      internal::P2PSocket_Send_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
  inline void GetPacketInfoDataView(
      P2PPacketInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPacketInfo(UserType* output) {
    
    auto* pointer = data_->packet_info.Get();
    return mojo::internal::Deserialize<::network::mojom::P2PPacketInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::P2PSocket_Send_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocket_SendBatch_ParamsDataView {
 public:
  P2PSocket_SendBatch_ParamsDataView() = default;

  P2PSocket_SendBatch_ParamsDataView(
      internal::P2PSocket_SendBatch_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPacketBatchDataView(
      mojo::ArrayDataView<P2PSendPacketDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPacketBatch(UserType* output) {
    
    auto* pointer = data_->packet_batch.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::P2PSendPacketDataView>>(
        pointer, output, message_);
  }
 private:
  internal::P2PSocket_SendBatch_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocket_SetOption_ParamsDataView {
 public:
  P2PSocket_SetOption_ParamsDataView() = default;

  P2PSocket_SetOption_ParamsDataView(
      internal::P2PSocket_SetOption_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadOption(UserType* output) const {
    auto data_value = data_->option;
    return mojo::internal::Deserialize<::network::mojom::P2PSocketOption>(
        data_value, output);
  }
  P2PSocketOption option() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::P2PSocketOption>(data_->option));
  }
  int32_t value() const {
    return data_->value;
  }
 private:
  internal::P2PSocket_SetOption_Params_Data* data_ = nullptr;
};


class P2PSocketClient_SocketCreated_ParamsDataView {
 public:
  P2PSocketClient_SocketCreated_ParamsDataView() = default;

  P2PSocketClient_SocketCreated_ParamsDataView(
      internal::P2PSocketClient_SocketCreated_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocalAddressDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalAddress(UserType* output) {
    
    auto* pointer = data_->local_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  inline void GetRemoteAddressDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteAddress(UserType* output) {
    
    auto* pointer = data_->remote_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
 private:
  internal::P2PSocketClient_SocketCreated_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketClient_SendComplete_ParamsDataView {
 public:
  P2PSocketClient_SendComplete_ParamsDataView() = default;

  P2PSocketClient_SendComplete_ParamsDataView(
      internal::P2PSocketClient_SendComplete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSendMetricsDataView(
      P2PSendPacketMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSendMetrics(UserType* output) {
    
    auto* pointer = data_->send_metrics.Get();
    return mojo::internal::Deserialize<::network::mojom::P2PSendPacketMetricsDataView>(
        pointer, output, message_);
  }
 private:
  internal::P2PSocketClient_SendComplete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketClient_SendBatchComplete_ParamsDataView {
 public:
  P2PSocketClient_SendBatchComplete_ParamsDataView() = default;

  P2PSocketClient_SendBatchComplete_ParamsDataView(
      internal::P2PSocketClient_SendBatchComplete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSendMetricsBatchDataView(
      mojo::ArrayDataView<P2PSendPacketMetricsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSendMetricsBatch(UserType* output) {
    
    auto* pointer = data_->send_metrics_batch.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::P2PSendPacketMetricsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::P2PSocketClient_SendBatchComplete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSocketClient_DataReceived_ParamsDataView {
 public:
  P2PSocketClient_DataReceived_ParamsDataView() = default;

  P2PSocketClient_DataReceived_ParamsDataView(
      internal::P2PSocketClient_DataReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPacketsDataView(
      mojo::ArrayDataView<P2PReceivedPacketDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPackets(UserType* output) {
    
    auto* pointer = data_->packets.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::P2PReceivedPacketDataView>>(
        pointer, output, message_);
  }
 private:
  internal::P2PSocketClient_DataReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void P2PNetworkNotificationClient_NetworkListChanged_ParamsDataView::GetNetworksDataView(
    mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>* output) {
  auto pointer = data_->networks.Get();
  *output = mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>(pointer, message_);
}
inline void P2PNetworkNotificationClient_NetworkListChanged_ParamsDataView::GetDefaultIpv4LocalAddressDataView(
    ::network::mojom::IPAddressDataView* output) {
  auto pointer = data_->default_ipv4_local_address.Get();
  *output = ::network::mojom::IPAddressDataView(pointer, message_);
}
inline void P2PNetworkNotificationClient_NetworkListChanged_ParamsDataView::GetDefaultIpv6LocalAddressDataView(
    ::network::mojom::IPAddressDataView* output) {
  auto pointer = data_->default_ipv6_local_address.Get();
  *output = ::network::mojom::IPAddressDataView(pointer, message_);
}




inline void P2PSocketManager_GetHostAddress_ParamsDataView::GetHostNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void P2PSocketManager_GetHostAddress_ResponseParamsDataView::GetAddressesDataView(
    mojo::ArrayDataView<::network::mojom::IPAddressDataView>* output) {
  auto pointer = data_->addresses.Get();
  *output = mojo::ArrayDataView<::network::mojom::IPAddressDataView>(pointer, message_);
}


inline void P2PSocketManager_GetHostAddressWithFamily_ParamsDataView::GetHostNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void P2PSocketManager_GetHostAddressWithFamily_ResponseParamsDataView::GetAddressesDataView(
    mojo::ArrayDataView<::network::mojom::IPAddressDataView>* output) {
  auto pointer = data_->addresses.Get();
  *output = mojo::ArrayDataView<::network::mojom::IPAddressDataView>(pointer, message_);
}


inline void P2PSocketManager_CreateSocket_ParamsDataView::GetLocalAddressDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->local_address.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}
inline void P2PSocketManager_CreateSocket_ParamsDataView::GetPortRangeDataView(
    P2PPortRangeDataView* output) {
  auto pointer = data_->port_range.Get();
  *output = P2PPortRangeDataView(pointer, message_);
}
inline void P2PSocketManager_CreateSocket_ParamsDataView::GetRemoteAddressDataView(
    P2PHostAndIPEndPointDataView* output) {
  auto pointer = data_->remote_address.Get();
  *output = P2PHostAndIPEndPointDataView(pointer, message_);
}
inline void P2PSocketManager_CreateSocket_ParamsDataView::GetTrafficAnnotationDataView(
    ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output) {
  auto pointer = data_->traffic_annotation.Get();
  *output = ::network::mojom::MutableNetworkTrafficAnnotationTagDataView(pointer, message_);
}
inline void P2PSocketManager_CreateSocket_ParamsDataView::GetDevtoolsTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void P2PSocket_Send_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ReadOnlyBufferDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ReadOnlyBufferDataView(pointer, message_);
}
inline void P2PSocket_Send_ParamsDataView::GetPacketInfoDataView(
    P2PPacketInfoDataView* output) {
  auto pointer = data_->packet_info.Get();
  *output = P2PPacketInfoDataView(pointer, message_);
}


inline void P2PSocket_SendBatch_ParamsDataView::GetPacketBatchDataView(
    mojo::ArrayDataView<P2PSendPacketDataView>* output) {
  auto pointer = data_->packet_batch.Get();
  *output = mojo::ArrayDataView<P2PSendPacketDataView>(pointer, message_);
}




inline void P2PSocketClient_SocketCreated_ParamsDataView::GetLocalAddressDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->local_address.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}
inline void P2PSocketClient_SocketCreated_ParamsDataView::GetRemoteAddressDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_address.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}


inline void P2PSocketClient_SendComplete_ParamsDataView::GetSendMetricsDataView(
    P2PSendPacketMetricsDataView* output) {
  auto pointer = data_->send_metrics.Get();
  *output = P2PSendPacketMetricsDataView(pointer, message_);
}


inline void P2PSocketClient_SendBatchComplete_ParamsDataView::GetSendMetricsBatchDataView(
    mojo::ArrayDataView<P2PSendPacketMetricsDataView>* output) {
  auto pointer = data_->send_metrics_batch.Get();
  *output = mojo::ArrayDataView<P2PSendPacketMetricsDataView>(pointer, message_);
}


inline void P2PSocketClient_DataReceived_ParamsDataView::GetPacketsDataView(
    mojo::ArrayDataView<P2PReceivedPacketDataView>* output) {
  auto pointer = data_->packets.Get();
  *output = mojo::ArrayDataView<P2PReceivedPacketDataView>(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_PARAMS_DATA_H_