// services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ISOLATION_KEY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ISOLATION_KEY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared-internal.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"







namespace network::mojom {
class SharedDictionaryIsolationKeyDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SharedDictionaryIsolationKeyDataView> {
  using Data = ::network::mojom::internal::SharedDictionaryIsolationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class SharedDictionaryIsolationKeyDataView {
 public:
  SharedDictionaryIsolationKeyDataView() = default;

  SharedDictionaryIsolationKeyDataView(
      internal::SharedDictionaryIsolationKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameOrigin(UserType* output) {
    
    auto* pointer = data_->frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameSite(UserType* output) {
    
    auto* pointer = data_->top_frame_site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedDictionaryIsolationKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedDictionaryIsolationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedDictionaryIsolationKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedDictionaryIsolationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_origin(input)) in_frame_origin = Traits::frame_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_origin)::BaseType> frame_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_frame_origin, frame_origin_fragment);
    fragment->frame_origin.Set(
        frame_origin_fragment.is_null() ? nullptr : frame_origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_origin in SharedDictionaryIsolationKey struct");
    decltype(Traits::top_frame_site(input)) in_top_frame_site = Traits::top_frame_site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_site)::BaseType> top_frame_site_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
        in_top_frame_site, top_frame_site_fragment);
    fragment->top_frame_site.Set(
        top_frame_site_fragment.is_null() ? nullptr : top_frame_site_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->top_frame_site.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_site in SharedDictionaryIsolationKey struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedDictionaryIsolationKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedDictionaryIsolationKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SharedDictionaryIsolationKeyDataView::GetFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void SharedDictionaryIsolationKeyDataView::GetTopFrameSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->top_frame_site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ISOLATION_KEY_MOJOM_SHARED_H_