// services/network/public/mojom/trust_token_access_observer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/trust_token_access_observer.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class TrustTokenIssuanceDetailsDataView;

class TrustTokenRedemptionDetailsDataView;

class TrustTokenSigningDetailsDataView;

class TrustTokenAccessDetailsDataView;


}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenIssuanceDetailsDataView> {
  using Data = ::network::mojom::internal::TrustTokenIssuanceDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenRedemptionDetailsDataView> {
  using Data = ::network::mojom::internal::TrustTokenRedemptionDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenSigningDetailsDataView> {
  using Data = ::network::mojom::internal::TrustTokenSigningDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenAccessDetailsDataView> {
  using Data = ::network::mojom::internal::TrustTokenAccessDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class TrustTokenAccessObserverInterfaceBase {};

using TrustTokenAccessObserverPtrDataView =
    mojo::InterfacePtrDataView<TrustTokenAccessObserverInterfaceBase>;
using TrustTokenAccessObserverRequestDataView =
    mojo::InterfaceRequestDataView<TrustTokenAccessObserverInterfaceBase>;
using TrustTokenAccessObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TrustTokenAccessObserverInterfaceBase>;
using TrustTokenAccessObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TrustTokenAccessObserverInterfaceBase>;


class TrustTokenIssuanceDetailsDataView {
 public:
  TrustTokenIssuanceDetailsDataView() = default;

  TrustTokenIssuanceDetailsDataView(
      internal::TrustTokenIssuanceDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetIssuerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `issuer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIssuer` instead "
    "of `ReadIssuer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->issuer.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool blocked() const {
    return data_->blocked;
  }
 private:
  internal::TrustTokenIssuanceDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustTokenRedemptionDetailsDataView {
 public:
  TrustTokenRedemptionDetailsDataView() = default;

  TrustTokenRedemptionDetailsDataView(
      internal::TrustTokenRedemptionDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetIssuerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `issuer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIssuer` instead "
    "of `ReadIssuer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->issuer.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool blocked() const {
    return data_->blocked;
  }
 private:
  internal::TrustTokenRedemptionDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustTokenSigningDetailsDataView {
 public:
  TrustTokenSigningDetailsDataView() = default;

  TrustTokenSigningDetailsDataView(
      internal::TrustTokenSigningDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool blocked() const {
    return data_->blocked;
  }
 private:
  internal::TrustTokenSigningDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustTokenAccessDetailsDataView {
 public:
  using Tag = internal::TrustTokenAccessDetails_Data::TrustTokenAccessDetails_Tag;

  TrustTokenAccessDetailsDataView() = default;

  TrustTokenAccessDetailsDataView(
      internal::TrustTokenAccessDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_issuance() const { return data_->tag == Tag::kIssuance; }
  inline void GetIssuanceDataView(
      TrustTokenIssuanceDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadIssuance(UserType* output) const {
    
    CHECK(is_issuance());
    return mojo::internal::Deserialize<::network::mojom::TrustTokenIssuanceDetailsDataView>(
        data_->data.f_issuance.Get(), output, message_);
  }
  bool is_redemption() const { return data_->tag == Tag::kRedemption; }
  inline void GetRedemptionDataView(
      TrustTokenRedemptionDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRedemption(UserType* output) const {
    
    CHECK(is_redemption());
    return mojo::internal::Deserialize<::network::mojom::TrustTokenRedemptionDetailsDataView>(
        data_->data.f_redemption.Get(), output, message_);
  }
  bool is_signing() const { return data_->tag == Tag::kSigning; }
  inline void GetSigningDataView(
      TrustTokenSigningDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSigning(UserType* output) const {
    
    CHECK(is_signing());
    return mojo::internal::Deserialize<::network::mojom::TrustTokenSigningDetailsDataView>(
        data_->data.f_signing.Get(), output, message_);
  }

 private:
  internal::TrustTokenAccessDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenIssuanceDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenIssuanceDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenIssuanceDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in TrustTokenIssuanceDetails struct");
    decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer)::BaseType> issuer_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_issuer, issuer_fragment);
    fragment->issuer.Set(
        issuer_fragment.is_null() ? nullptr : issuer_fragment.data());
    fragment->blocked = Traits::blocked(input);
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenIssuanceDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenIssuanceDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenRedemptionDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenRedemptionDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenRedemptionDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in TrustTokenRedemptionDetails struct");
    decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer)::BaseType> issuer_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_issuer, issuer_fragment);
    fragment->issuer.Set(
        issuer_fragment.is_null() ? nullptr : issuer_fragment.data());
    fragment->blocked = Traits::blocked(input);
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenRedemptionDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenRedemptionDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenSigningDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenSigningDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenSigningDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in TrustTokenSigningDetails struct");
    fragment->blocked = Traits::blocked(input);
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenSigningDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenSigningDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenAccessDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::TrustTokenAccessDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::TrustTokenAccessDetails_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kIssuance: {
        decltype(Traits::issuance(input))
            in_issuance = Traits::issuance(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_issuance)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::TrustTokenIssuanceDetailsDataView>(
            in_issuance, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null issuance in TrustTokenAccessDetails union");
        fragment->data.f_issuance.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kRedemption: {
        decltype(Traits::redemption(input))
            in_redemption = Traits::redemption(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_redemption)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::TrustTokenRedemptionDetailsDataView>(
            in_redemption, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null redemption in TrustTokenAccessDetails union");
        fragment->data.f_redemption.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kSigning: {
        decltype(Traits::signing(input))
            in_signing = Traits::signing(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_signing)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::TrustTokenSigningDetailsDataView>(
            in_signing, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null signing in TrustTokenAccessDetails union");
        fragment->data.f_signing.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenAccessDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenAccessDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void TrustTokenIssuanceDetailsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void TrustTokenIssuanceDetailsDataView::GetIssuerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->issuer.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void TrustTokenRedemptionDetailsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void TrustTokenRedemptionDetailsDataView::GetIssuerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->issuer.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void TrustTokenSigningDetailsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void TrustTokenAccessDetailsDataView::GetIssuanceDataView(
    TrustTokenIssuanceDetailsDataView* output) const {
  CHECK(is_issuance());
  *output = TrustTokenIssuanceDetailsDataView(data_->data.f_issuance.Get(), message_);
}
inline void TrustTokenAccessDetailsDataView::GetRedemptionDataView(
    TrustTokenRedemptionDetailsDataView* output) const {
  CHECK(is_redemption());
  *output = TrustTokenRedemptionDetailsDataView(data_->data.f_redemption.Get(), message_);
}
inline void TrustTokenAccessDetailsDataView::GetSigningDataView(
    TrustTokenSigningDetailsDataView* output) const {
  CHECK(is_signing());
  *output = TrustTokenSigningDetailsDataView(data_->data.f_signing.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SHARED_H_