// third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace blink::mojom {
class BackgroundFetchSettledFetchDataView;

class BackgroundFetchOptionsDataView;

class BackgroundFetchRegistrationDataDataView;

class BackgroundFetchRegistrationDataView;

class BackgroundFetchUkmDataDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchSettledFetchDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchSettledFetch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchOptionsDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchRegistrationDataDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchRegistrationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchRegistrationDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchUkmDataDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchUkmData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class BackgroundFetchError : int32_t {
  
  NONE = 0,
  
  DUPLICATED_DEVELOPER_ID = 1,
  
  INVALID_ARGUMENT = 2,
  
  INVALID_ID = 3,
  
  STORAGE_ERROR = 4,
  
  SERVICE_WORKER_UNAVAILABLE = 5,
  
  QUOTA_EXCEEDED = 6,
  
  PERMISSION_DENIED = 7,
  
  REGISTRATION_LIMIT_EXCEEDED = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundFetchError value);
inline bool IsKnownEnumValue(BackgroundFetchError value) {
  return internal::BackgroundFetchError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BackgroundFetchResult : int32_t {
  
  UNSET = 0,
  
  FAILURE = 1,
  
  SUCCESS = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundFetchResult value);
inline bool IsKnownEnumValue(BackgroundFetchResult value) {
  return internal::BackgroundFetchResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BackgroundFetchFailureReason : int32_t {
  
  NONE = 0,
  
  CANCELLED_FROM_UI = 1,
  
  CANCELLED_BY_DEVELOPER = 2,
  
  BAD_STATUS = 3,
  
  FETCH_ERROR = 4,
  
  SERVICE_WORKER_UNAVAILABLE = 5,
  
  QUOTA_EXCEEDED = 6,
  
  DOWNLOAD_TOTAL_EXCEEDED = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundFetchFailureReason value);
inline bool IsKnownEnumValue(BackgroundFetchFailureReason value) {
  return internal::BackgroundFetchFailureReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BackgroundFetchRegistrationObserverInterfaceBase {};

using BackgroundFetchRegistrationObserverPtrDataView =
    mojo::InterfacePtrDataView<BackgroundFetchRegistrationObserverInterfaceBase>;
using BackgroundFetchRegistrationObserverRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundFetchRegistrationObserverInterfaceBase>;
using BackgroundFetchRegistrationObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundFetchRegistrationObserverInterfaceBase>;
using BackgroundFetchRegistrationObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundFetchRegistrationObserverInterfaceBase>;
class BackgroundFetchServiceInterfaceBase {};

using BackgroundFetchServicePtrDataView =
    mojo::InterfacePtrDataView<BackgroundFetchServiceInterfaceBase>;
using BackgroundFetchServiceRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundFetchServiceInterfaceBase>;
using BackgroundFetchServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundFetchServiceInterfaceBase>;
using BackgroundFetchServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundFetchServiceInterfaceBase>;
class BackgroundFetchRegistrationServiceInterfaceBase {};

using BackgroundFetchRegistrationServicePtrDataView =
    mojo::InterfacePtrDataView<BackgroundFetchRegistrationServiceInterfaceBase>;
using BackgroundFetchRegistrationServiceRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundFetchRegistrationServiceInterfaceBase>;
using BackgroundFetchRegistrationServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundFetchRegistrationServiceInterfaceBase>;
using BackgroundFetchRegistrationServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundFetchRegistrationServiceInterfaceBase>;


class BackgroundFetchSettledFetchDataView {
 public:
  BackgroundFetchSettledFetchDataView() = default;

  BackgroundFetchSettledFetchDataView(
      internal::BackgroundFetchSettledFetch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      ::blink::mojom::FetchAPIRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestDataView>(
        pointer, output, message_);
  }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FetchAPIResponseDataView, UserType>(),
    "Attempting to read the optional `response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResponse` instead "
    "of `ReadResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::BackgroundFetchSettledFetch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundFetchOptionsDataView {
 public:
  BackgroundFetchOptionsDataView() = default;

  BackgroundFetchOptionsDataView(
      internal::BackgroundFetchOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIconsDataView(
      mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  uint64_t download_total() const {
    return data_->download_total;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BackgroundFetchOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundFetchRegistrationDataDataView {
 public:
  BackgroundFetchRegistrationDataDataView() = default;

  BackgroundFetchRegistrationDataDataView(
      internal::BackgroundFetchRegistrationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeveloperIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeveloperId(UserType* output) {
    
    auto* pointer = data_->developer_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t upload_total() const {
    return data_->upload_total;
  }
  uint64_t uploaded() const {
    return data_->uploaded;
  }
  uint64_t download_total() const {
    return data_->download_total;
  }
  uint64_t downloaded() const {
    return data_->downloaded;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::blink::mojom::BackgroundFetchResult>(
        data_value, output);
  }
  BackgroundFetchResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::BackgroundFetchResult>(data_->result));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFailureReason(UserType* output) const {
    auto data_value = data_->failure_reason;
    return mojo::internal::Deserialize<::blink::mojom::BackgroundFetchFailureReason>(
        data_value, output);
  }
  BackgroundFetchFailureReason failure_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::BackgroundFetchFailureReason>(data_->failure_reason));
  }
 private:
  internal::BackgroundFetchRegistrationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundFetchRegistrationDataView {
 public:
  BackgroundFetchRegistrationDataView() = default;

  BackgroundFetchRegistrationDataView(
      internal::BackgroundFetchRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegistrationDataDataView(
      BackgroundFetchRegistrationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistrationData(UserType* output) {
    
    auto* pointer = data_->registration_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::BackgroundFetchRegistrationDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeRegistrationInterface() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BackgroundFetchRegistrationServiceInterfaceBase>>(
            &data_->registration_interface, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BackgroundFetchRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundFetchUkmDataDataView {
 public:
  BackgroundFetchUkmDataDataView() = default;

  BackgroundFetchUkmDataDataView(
      internal::BackgroundFetchUkmData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t ideal_to_chosen_icon_size() const {
    return data_->ideal_to_chosen_icon_size;
  }
 private:
  internal::BackgroundFetchUkmData_Data* data_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::BackgroundFetchError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::BackgroundFetchError> {};

template <>
struct hash<::blink::mojom::BackgroundFetchResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::BackgroundFetchResult> {};

template <>
struct hash<::blink::mojom::BackgroundFetchFailureReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::BackgroundFetchFailureReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::BackgroundFetchError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::BackgroundFetchError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::BackgroundFetchResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::BackgroundFetchResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchFailureReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::BackgroundFetchFailureReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::BackgroundFetchFailureReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchSettledFetchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchSettledFetchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchSettledFetch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
        in_request, request_fragment);
    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->request.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request in BackgroundFetchSettledFetch struct");
    decltype(Traits::response(input)) in_response = Traits::response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response)::BaseType> response_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
        in_response, response_fragment);
    fragment->response.Set(
        response_fragment.is_null() ? nullptr : response_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchSettledFetch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchSettledFetchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        in_icons, icons_fragment, &icons_validate_params);
    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icons.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in BackgroundFetchOptions struct");
    fragment->download_total = Traits::download_total(input);
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in BackgroundFetchOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchRegistrationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchRegistrationDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchRegistrationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::developer_id(input)) in_developer_id = Traits::developer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->developer_id)::BaseType> developer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_developer_id, developer_id_fragment);
    fragment->developer_id.Set(
        developer_id_fragment.is_null() ? nullptr : developer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->developer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null developer_id in BackgroundFetchRegistrationData struct");
    fragment->upload_total = Traits::upload_total(input);
    fragment->uploaded = Traits::uploaded(input);
    fragment->download_total = Traits::download_total(input);
    fragment->downloaded = Traits::downloaded(input);
    mojo::internal::Serialize<::blink::mojom::BackgroundFetchResult>(
        Traits::result(input), &fragment->result);
    mojo::internal::Serialize<::blink::mojom::BackgroundFetchFailureReason>(
        Traits::failure_reason(input), &fragment->failure_reason);
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchRegistrationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchRegistrationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchRegistrationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchRegistrationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::registration_data(input)) in_registration_data = Traits::registration_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->registration_data)::BaseType> registration_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataDataView>(
        in_registration_data, registration_data_fragment);
    fragment->registration_data.Set(
        registration_data_fragment.is_null() ? nullptr : registration_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->registration_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null registration_data in BackgroundFetchRegistration struct");
    decltype(Traits::registration_interface(input)) in_registration_interface = Traits::registration_interface(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BackgroundFetchRegistrationServiceInterfaceBase>>(
        in_registration_interface, &fragment->registration_interface, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->registration_interface),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid registration_interface in BackgroundFetchRegistration struct");
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchRegistration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchRegistrationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchUkmDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchUkmDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchUkmData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->ideal_to_chosen_icon_size = Traits::ideal_to_chosen_icon_size(input);
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchUkmData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchUkmDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void BackgroundFetchSettledFetchDataView::GetRequestDataView(
    ::blink::mojom::FetchAPIRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = ::blink::mojom::FetchAPIRequestDataView(pointer, message_);
}
inline void BackgroundFetchSettledFetchDataView::GetResponseDataView(
    ::blink::mojom::FetchAPIResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = ::blink::mojom::FetchAPIResponseDataView(pointer, message_);
}


inline void BackgroundFetchOptionsDataView::GetIconsDataView(
    mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>(pointer, message_);
}
inline void BackgroundFetchOptionsDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BackgroundFetchRegistrationDataDataView::GetDeveloperIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->developer_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BackgroundFetchRegistrationDataView::GetRegistrationDataDataView(
    BackgroundFetchRegistrationDataDataView* output) {
  auto pointer = data_->registration_data.Get();
  *output = BackgroundFetchRegistrationDataDataView(pointer, message_);
}





}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::BackgroundFetchError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::BackgroundFetchError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::BackgroundFetchResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::BackgroundFetchResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::BackgroundFetchFailureReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::BackgroundFetchFailureReason value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_SHARED_H_