// third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class InterestGroupAdDataView;

class SellerCapabilitiesDataView;

class AuctionServerRequestFlagsDataView;

class AdKeywordReplacementDataView;

class InterestGroupDataView;

class PreviousWinDataView;

class BiddingBrowserSignalsDataView;

class StorageInterestGroupDataView;

class DirectFromSellerSignalsSubresourceDataView;

class DirectFromSellerSignalsDataView;

class AuctionAdConfigBuyerTimeoutsDataView;

class AdCurrencyDataView;

class AuctionAdConfigBuyerCurrenciesDataView;

class AuctionAdServerResponseConfigDataView;

class AuctionReportBuyerDebugModeConfigDataView;

class AuctionReportBuyersConfigDataView;

class AuctionAdConfigNonSharedParamsDataView;

class AuctionAdConfigDataView;

class AuctionDataBuyerConfigDataView;

class AuctionDataConfigDataView;

class AdAuctionPerSellerRequestDataView;

class AuctionAdConfigMaybePromiseJsonDataView;
class AuctionAdConfigMaybePromisePerBuyerSignalsDataView;
class AuctionAdConfigMaybePromiseBuyerTimeoutsDataView;
class AuctionAdConfigMaybePromiseBuyerCurrenciesDataView;
class AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView;
class AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView;
class AdAuctionRequestOrErrorDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::InterestGroupAdDataView> {
  using Data = ::blink::mojom::internal::InterestGroupAd_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SellerCapabilitiesDataView> {
  using Data = ::blink::mojom::internal::SellerCapabilities_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionServerRequestFlagsDataView> {
  using Data = ::blink::mojom::internal::AuctionServerRequestFlags_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdKeywordReplacementDataView> {
  using Data = ::blink::mojom::internal::AdKeywordReplacement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InterestGroupDataView> {
  using Data = ::blink::mojom::internal::InterestGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PreviousWinDataView> {
  using Data = ::blink::mojom::internal::PreviousWin_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BiddingBrowserSignalsDataView> {
  using Data = ::blink::mojom::internal::BiddingBrowserSignals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StorageInterestGroupDataView> {
  using Data = ::blink::mojom::internal::StorageInterestGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DirectFromSellerSignalsSubresourceDataView> {
  using Data = ::blink::mojom::internal::DirectFromSellerSignalsSubresource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DirectFromSellerSignalsDataView> {
  using Data = ::blink::mojom::internal::DirectFromSellerSignals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigBuyerTimeouts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdCurrencyDataView> {
  using Data = ::blink::mojom::internal::AdCurrency_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigBuyerCurrencies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdServerResponseConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionAdServerResponseConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionReportBuyerDebugModeConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionReportBuyerDebugModeConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionReportBuyersConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionReportBuyersConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigNonSharedParamsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigNonSharedParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionDataBuyerConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionDataBuyerConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionDataConfigDataView> {
  using Data = ::blink::mojom::internal::AuctionDataConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdAuctionPerSellerRequestDataView> {
  using Data = ::blink::mojom::internal::AdAuctionPerSellerRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseJson_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView> {
  using Data = ::blink::mojom::internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdAuctionRequestOrErrorDataView> {
  using Data = ::blink::mojom::internal::AdAuctionRequestOrError_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class InterestGroup_ExecutionMode : int32_t {
  
  kCompatibilityMode = 0,
  
  kGroupedByOriginMode = 1,
  
  kFrozenContext = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, InterestGroup_ExecutionMode value);
inline bool IsKnownEnumValue(InterestGroup_ExecutionMode value) {
  return internal::InterestGroup_ExecutionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline InterestGroup_ExecutionMode ToKnownEnumValue(InterestGroup_ExecutionMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return InterestGroup_ExecutionMode::kDefaultValue;
}


enum class InterestGroup_TrustedBiddingSignalsSlotSizeMode : int32_t {
  
  kNone = 0,
  
  kSlotSize = 1,
  
  kAllSlotsRequestedSizes = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, InterestGroup_TrustedBiddingSignalsSlotSizeMode value);
inline bool IsKnownEnumValue(InterestGroup_TrustedBiddingSignalsSlotSizeMode value) {
  return internal::InterestGroup_TrustedBiddingSignalsSlotSizeMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline InterestGroup_TrustedBiddingSignalsSlotSizeMode ToKnownEnumValue(InterestGroup_TrustedBiddingSignalsSlotSizeMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return InterestGroup_TrustedBiddingSignalsSlotSizeMode::kDefaultValue;
}


enum class AuctionAdConfigNonSharedParams_BuyerReportType : int32_t {
  
  kInterestGroupCount = 0,
  
  kBidCount = 1,
  
  kTotalGenerateBidLatency = 2,
  
  kTotalSignalsFetchLatency = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AuctionAdConfigNonSharedParams_BuyerReportType value);
inline bool IsKnownEnumValue(AuctionAdConfigNonSharedParams_BuyerReportType value) {
  return internal::AuctionAdConfigNonSharedParams_BuyerReportType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AuctionAdConfigNonSharedParams_RealTimeReportingType : int32_t {
  
  kDefaultLocalReporting = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AuctionAdConfigNonSharedParams_RealTimeReportingType value);
inline bool IsKnownEnumValue(AuctionAdConfigNonSharedParams_RealTimeReportingType value) {
  return internal::AuctionAdConfigNonSharedParams_RealTimeReportingType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class InterestGroupAdDataView {
 public:
  InterestGroupAdDataView() = default;

  InterestGroupAdDataView(
      internal::InterestGroupAd_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRenderUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRenderUrl(UserType* output) {
    
    auto* pointer = data_->render_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSizeGroupDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeGroup(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `size_group` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSizeGroup` instead "
    "of `ReadSizeGroup if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size_group.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `buyer_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBuyerReportingId` instead "
    "of `ReadBuyerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buyer_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBuyerAndSellerReportingId` instead "
    "of `ReadBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectableBuyerAndSellerReportingIdsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectableBuyerAndSellerReportingIds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `selectable_buyer_and_seller_reporting_ids` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelectableBuyerAndSellerReportingIds` instead "
    "of `ReadSelectableBuyerAndSellerReportingIds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->selectable_buyer_and_seller_reporting_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMetadata` instead "
    "of `ReadMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdRenderIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdRenderId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `ad_render_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdRenderId` instead "
    "of `ReadAdRenderId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_render_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAllowedReportingOriginsDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedReportingOrigins(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::url::mojom::OriginDataView>, UserType>(),
    "Attempting to read the optional `allowed_reporting_origins` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllowedReportingOrigins` instead "
    "of `ReadAllowedReportingOrigins if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->allowed_reporting_origins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, message_);
  }
  inline void GetCreativeScanningMetadataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreativeScanningMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `creative_scanning_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCreativeScanningMetadata` instead "
    "of `ReadCreativeScanningMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->creative_scanning_metadata.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::InterestGroupAd_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SellerCapabilitiesDataView {
 public:
  SellerCapabilitiesDataView() = default;

  SellerCapabilitiesDataView(
      internal::SellerCapabilities_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allows_interest_group_counts() const {
    return data_->allows_interest_group_counts;
  }
  bool allows_latency_stats() const {
    return data_->allows_latency_stats;
  }
 private:
  internal::SellerCapabilities_Data* data_ = nullptr;
};


class AuctionServerRequestFlagsDataView {
 public:
  AuctionServerRequestFlagsDataView() = default;

  AuctionServerRequestFlagsDataView(
      internal::AuctionServerRequestFlags_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool omit_ads() const {
    return data_->omit_ads;
  }
  bool include_full_ads() const {
    return data_->include_full_ads;
  }
  bool omit_user_bidding_signals() const {
    return data_->omit_user_bidding_signals;
  }
 private:
  internal::AuctionServerRequestFlags_Data* data_ = nullptr;
};


class AdKeywordReplacementDataView {
 public:
  AdKeywordReplacementDataView() = default;

  AdKeywordReplacementDataView(
      internal::AdKeywordReplacement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMatchDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatch(UserType* output) {
    
    auto* pointer = data_->match.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetReplacementDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplacement(UserType* output) {
    
    auto* pointer = data_->replacement.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdKeywordReplacement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InterestGroupDataView {
 public:
  InterestGroupDataView() = default;

  InterestGroupDataView(
      internal::InterestGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExpiryDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiry(UserType* output) {
    
    auto* pointer = data_->expiry.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetOwnerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOwner(UserType* output) {
    
    auto* pointer = data_->owner.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double priority() const {
    return data_->priority;
  }
  bool enable_bidding_signals_prioritization() const {
    return data_->enable_bidding_signals_prioritization;
  }
  inline void GetPriorityVectorDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPriorityVector(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, double>, UserType>(),
    "Attempting to read the optional `priority_vector` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPriorityVector` instead "
    "of `ReadPriorityVector if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->priority_vector.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  inline void GetPrioritySignalsOverridesDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrioritySignalsOverrides(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, double>, UserType>(),
    "Attempting to read the optional `priority_signals_overrides` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrioritySignalsOverrides` instead "
    "of `ReadPrioritySignalsOverrides if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->priority_signals_overrides.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  inline void GetSellerCapabilitiesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, SellerCapabilitiesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerCapabilities(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::SellerCapabilitiesDataView>, UserType>(),
    "Attempting to read the optional `seller_capabilities` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerCapabilities` instead "
    "of `ReadSellerCapabilities if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_capabilities.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::SellerCapabilitiesDataView>>(
        pointer, output, message_);
  }
  inline void GetAllSellersCapabilitiesDataView(
      SellerCapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllSellersCapabilities(UserType* output) {
    
    auto* pointer = data_->all_sellers_capabilities.Get();
    return mojo::internal::Deserialize<::blink::mojom::SellerCapabilitiesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadExecutionMode(UserType* output) const {
    auto data_value = data_->execution_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_ExecutionMode>(
        data_value, output);
  }
  InterestGroup_ExecutionMode execution_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_ExecutionMode>(data_->execution_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsSlotSizeMode(UserType* output) const {
    auto data_value = data_->trusted_bidding_signals_slot_size_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(
        data_value, output);
  }
  InterestGroup_TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(data_->trusted_bidding_signals_slot_size_mode));
  }
  inline void GetBiddingUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiddingUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `bidding_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiddingUrl` instead "
    "of `ReadBiddingUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bidding_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetBiddingWasmHelperUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiddingWasmHelperUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `bidding_wasm_helper_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiddingWasmHelperUrl` instead "
    "of `ReadBiddingWasmHelperUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bidding_wasm_helper_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `update_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUpdateUrl` instead "
    "of `ReadUpdateUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->update_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedBiddingSignalsUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsUrl` instead "
    "of `ReadTrustedBiddingSignalsUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedBiddingSignalsKeysDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsKeys` instead "
    "of `ReadTrustedBiddingSignalsKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  int32_t max_trusted_bidding_signals_url_length() const {
    return data_->max_trusted_bidding_signals_url_length;
  }
  inline void GetTrustedBiddingSignalsCoordinatorDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsCoordinator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_coordinator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsCoordinator` instead "
    "of `ReadTrustedBiddingSignalsCoordinator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_coordinator.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetUserBiddingSignalsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserBiddingSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `user_bidding_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserBiddingSignals` instead "
    "of `ReadUserBiddingSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_bidding_signals.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdsDataView(
      mojo::ArrayDataView<InterestGroupAdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, UserType>(),
    "Attempting to read the optional `ads` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAds` instead "
    "of `ReadAds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ads.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        pointer, output, message_);
  }
  inline void GetAdComponentsDataView(
      mojo::ArrayDataView<InterestGroupAdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdComponents(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, UserType>(),
    "Attempting to read the optional `ad_components` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdComponents` instead "
    "of `ReadAdComponents if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_components.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        pointer, output, message_);
  }
  inline void GetAdSizesDataView(
      mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdSizes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>, UserType>(),
    "Attempting to read the optional `ad_sizes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdSizes` instead "
    "of `ReadAdSizes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_sizes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>>(
        pointer, output, message_);
  }
  inline void GetSizeGroupsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeGroups(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>, UserType>(),
    "Attempting to read the optional `size_groups` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSizeGroups` instead "
    "of `ReadSizeGroups if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size_groups.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, message_);
  }
  inline void GetAuctionServerRequestFlagsDataView(
      AuctionServerRequestFlagsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionServerRequestFlags(UserType* output) {
    
    auto* pointer = data_->auction_server_request_flags.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionServerRequestFlagsDataView>(
        pointer, output, message_);
  }
  inline void GetAdditionalBidKeyDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalBidKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `additional_bid_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdditionalBidKey` instead "
    "of `ReadAdditionalBidKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->additional_bid_key.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetAggregationCoordinatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `aggregation_coordinator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregationCoordinatorOrigin` instead "
    "of `ReadAggregationCoordinatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::InterestGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PreviousWinDataView {
 public:
  PreviousWinDataView() = default;

  PreviousWinDataView(
      internal::PreviousWin_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetAdJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdJson(UserType* output) {
    
    auto* pointer = data_->ad_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PreviousWin_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BiddingBrowserSignalsDataView {
 public:
  BiddingBrowserSignalsDataView() = default;

  BiddingBrowserSignalsDataView(
      internal::BiddingBrowserSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t join_count() const {
    return data_->join_count;
  }
  int32_t bid_count() const {
    return data_->bid_count;
  }
  inline void GetPrevWinsDataView(
      mojo::ArrayDataView<PreviousWinDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrevWins(UserType* output) {
    
    auto* pointer = data_->prev_wins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PreviousWinDataView>>(
        pointer, output, message_);
  }
  bool for_debugging_only_in_cooldown_or_lockout() const {
    return data_->for_debugging_only_in_cooldown_or_lockout;
  }
 private:
  internal::BiddingBrowserSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StorageInterestGroupDataView {
 public:
  StorageInterestGroupDataView() = default;

  StorageInterestGroupDataView(
      internal::StorageInterestGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInterestGroupDataView(
      InterestGroupDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroup(UserType* output) {
    
    auto* pointer = data_->interest_group.Get();
    return mojo::internal::Deserialize<::blink::mojom::InterestGroupDataView>(
        pointer, output, message_);
  }
  inline void GetBiddingBrowserSignalsDataView(
      BiddingBrowserSignalsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiddingBrowserSignals(UserType* output) {
    
    auto* pointer = data_->bidding_browser_signals.Get();
    return mojo::internal::Deserialize<::blink::mojom::BiddingBrowserSignalsDataView>(
        pointer, output, message_);
  }
  inline void GetJoiningOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJoiningOrigin(UserType* output) {
    
    auto* pointer = data_->joining_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetJoinTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJoinTime(UserType* output) {
    
    auto* pointer = data_->join_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastUpdatedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUpdated(UserType* output) {
    
    auto* pointer = data_->last_updated.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetNextUpdateAfterDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNextUpdateAfter(UserType* output) {
    
    auto* pointer = data_->next_update_after.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  uint64_t estimated_size() const {
    return data_->estimated_size;
  }
 private:
  internal::StorageInterestGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DirectFromSellerSignalsSubresourceDataView {
 public:
  DirectFromSellerSignalsSubresourceDataView() = default;

  DirectFromSellerSignalsSubresourceDataView(
      internal::DirectFromSellerSignalsSubresource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBundleUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBundleUrl(UserType* output) {
    
    auto* pointer = data_->bundle_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::DirectFromSellerSignalsSubresource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DirectFromSellerSignalsDataView {
 public:
  DirectFromSellerSignalsDataView() = default;

  DirectFromSellerSignalsDataView(
      internal::DirectFromSellerSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrefixDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrefix(UserType* output) {
    
    auto* pointer = data_->prefix.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerSignalsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, DirectFromSellerSignalsSubresourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerSignals(UserType* output) {
    
    auto* pointer = data_->per_buyer_signals.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::DirectFromSellerSignalsSubresourceDataView>>(
        pointer, output, message_);
  }
  inline void GetSellerSignalsDataView(
      DirectFromSellerSignalsSubresourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DirectFromSellerSignalsSubresourceDataView, UserType>(),
    "Attempting to read the optional `seller_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerSignals` instead "
    "of `ReadSellerSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_signals.Get();
    return mojo::internal::Deserialize<::blink::mojom::DirectFromSellerSignalsSubresourceDataView>(
        pointer, output, message_);
  }
  inline void GetAuctionSignalsDataView(
      DirectFromSellerSignalsSubresourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DirectFromSellerSignalsSubresourceDataView, UserType>(),
    "Attempting to read the optional `auction_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionSignals` instead "
    "of `ReadAuctionSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_signals.Get();
    return mojo::internal::Deserialize<::blink::mojom::DirectFromSellerSignalsSubresourceDataView>(
        pointer, output, message_);
  }
 private:
  internal::DirectFromSellerSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigBuyerTimeoutsDataView {
 public:
  AuctionAdConfigBuyerTimeoutsDataView() = default;

  AuctionAdConfigBuyerTimeoutsDataView(
      internal::AuctionAdConfigBuyerTimeouts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllBuyersTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllBuyersTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `all_buyers_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllBuyersTimeout` instead "
    "of `ReadAllBuyersTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_buyers_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerTimeoutsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerTimeouts(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>, UserType>(),
    "Attempting to read the optional `per_buyer_timeouts` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerTimeouts` instead "
    "of `ReadPerBuyerTimeouts if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_timeouts.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AuctionAdConfigBuyerTimeouts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdCurrencyDataView {
 public:
  AdCurrencyDataView() = default;

  AdCurrencyDataView(
      internal::AdCurrency_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCurrencyCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrencyCode(UserType* output) {
    
    auto* pointer = data_->currency_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdCurrency_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigBuyerCurrenciesDataView {
 public:
  AuctionAdConfigBuyerCurrenciesDataView() = default;

  AuctionAdConfigBuyerCurrenciesDataView(
      internal::AuctionAdConfigBuyerCurrencies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllBuyersCurrencyDataView(
      AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllBuyersCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `all_buyers_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllBuyersCurrency` instead "
    "of `ReadAllBuyersCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_buyers_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerCurrenciesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, AdCurrencyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerCurrencies(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AdCurrencyDataView>, UserType>(),
    "Attempting to read the optional `per_buyer_currencies` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerCurrencies` instead "
    "of `ReadPerBuyerCurrencies if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_currencies.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AdCurrencyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AuctionAdConfigBuyerCurrencies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdServerResponseConfigDataView {
 public:
  AuctionAdServerResponseConfigDataView() = default;

  AuctionAdServerResponseConfigDataView(
      internal::AuctionAdServerResponseConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestIdDataView(
      ::mojo_base::mojom::UuidDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UuidDataView>(
        pointer, output, message_);
  }
 private:
  internal::AuctionAdServerResponseConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionReportBuyerDebugModeConfigDataView {
 public:
  AuctionReportBuyerDebugModeConfigDataView() = default;

  AuctionReportBuyerDebugModeConfigDataView(
      internal::AuctionReportBuyerDebugModeConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  std::optional<uint64_t> debug_key() const {

    return data_->debug_key_$flag
        ? std::make_optional(data_->debug_key_$value)
        : std::nullopt;
  }
 private:
  internal::AuctionReportBuyerDebugModeConfig_Data* data_ = nullptr;
};


class AuctionReportBuyersConfigDataView {
 public:
  AuctionReportBuyersConfigDataView() = default;

  AuctionReportBuyersConfigDataView(
      internal::AuctionReportBuyersConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBucketDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBucket(UserType* output) {
    
    auto* pointer = data_->bucket.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  double scale() const {
    return data_->scale;
  }
 private:
  internal::AuctionReportBuyersConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigNonSharedParamsDataView {
 public:
  AuctionAdConfigNonSharedParamsDataView() = default;

  AuctionAdConfigNonSharedParamsDataView(
      internal::AuctionAdConfigNonSharedParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInterestGroupBuyersDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroupBuyers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::url::mojom::OriginDataView>, UserType>(),
    "Attempting to read the optional `interest_group_buyers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterestGroupBuyers` instead "
    "of `ReadInterestGroupBuyers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interest_group_buyers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, message_);
  }
  inline void GetAuctionSignalsDataView(
      AuctionAdConfigMaybePromiseJsonDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionSignals(UserType* output) {
    
    auto* pointer = !data_->auction_signals.is_null() ? &data_->auction_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView>(
        pointer, output, message_);
  }
  inline void GetSellerSignalsDataView(
      AuctionAdConfigMaybePromiseJsonDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerSignals(UserType* output) {
    
    auto* pointer = !data_->seller_signals.is_null() ? &data_->seller_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView>(
        pointer, output, message_);
  }
  inline void GetSellerTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `seller_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerTimeout` instead "
    "of `ReadSellerTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerSignalsDataView(
      AuctionAdConfigMaybePromisePerBuyerSignalsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerSignals(UserType* output) {
    
    auto* pointer = !data_->per_buyer_signals.is_null() ? &data_->per_buyer_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerTimeoutsDataView(
      AuctionAdConfigMaybePromiseBuyerTimeoutsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerTimeouts(UserType* output) {
    
    auto* pointer = !data_->buyer_timeouts.is_null() ? &data_->buyer_timeouts : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView>(
        pointer, output, message_);
  }
  inline void GetReportingTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `reporting_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingTimeout` instead "
    "of `ReadReportingTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetSellerCurrencyDataView(
      AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `seller_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerCurrency` instead "
    "of `ReadSellerCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerCurrenciesDataView(
      AuctionAdConfigMaybePromiseBuyerCurrenciesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerCurrencies(UserType* output) {
    
    auto* pointer = !data_->buyer_currencies.is_null() ? &data_->buyer_currencies : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerCumulativeTimeoutsDataView(
      AuctionAdConfigMaybePromiseBuyerTimeoutsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerCumulativeTimeouts(UserType* output) {
    
    auto* pointer = !data_->buyer_cumulative_timeouts.is_null() ? &data_->buyer_cumulative_timeouts : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerGroupLimitsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerGroupLimits(UserType* output) {
    
    auto* pointer = data_->per_buyer_group_limits.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        pointer, output, message_);
  }
  inline void GetPerBuyerPrioritySignalsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerPrioritySignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>, UserType>(),
    "Attempting to read the optional `per_buyer_priority_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerPrioritySignals` instead "
    "of `ReadPerBuyerPrioritySignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_priority_signals.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>>(
        pointer, output, message_);
  }
  inline void GetAllBuyersPrioritySignalsDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllBuyersPrioritySignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, double>, UserType>(),
    "Attempting to read the optional `all_buyers_priority_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllBuyersPrioritySignals` instead "
    "of `ReadAllBuyersPrioritySignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_buyers_priority_signals.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  uint16_t all_buyers_group_limit() const {
    return data_->all_buyers_group_limit;
  }
  inline void GetAuctionReportBuyerKeysDataView(
      mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionReportBuyerKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>, UserType>(),
    "Attempting to read the optional `auction_report_buyer_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionReportBuyerKeys` instead "
    "of `ReadAuctionReportBuyerKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_report_buyer_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>>(
        pointer, output, message_);
  }
  inline void GetAuctionReportBuyersDataView(
      mojo::MapDataView<AuctionAdConfigNonSharedParams_BuyerReportType, AuctionReportBuyersConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionReportBuyers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType, ::blink::mojom::AuctionReportBuyersConfigDataView>, UserType>(),
    "Attempting to read the optional `auction_report_buyers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionReportBuyers` instead "
    "of `ReadAuctionReportBuyers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_report_buyers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType, ::blink::mojom::AuctionReportBuyersConfigDataView>>(
        pointer, output, message_);
  }
  inline void GetAuctionReportBuyerDebugModeConfigDataView(
      AuctionReportBuyerDebugModeConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionReportBuyerDebugModeConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuctionReportBuyerDebugModeConfigDataView, UserType>(),
    "Attempting to read the optional `auction_report_buyer_debug_mode_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionReportBuyerDebugModeConfig` instead "
    "of `ReadAuctionReportBuyerDebugModeConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_report_buyer_debug_mode_config.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionReportBuyerDebugModeConfigDataView>(
        pointer, output, message_);
  }
  inline void GetRequiredSellerCapabilitiesDataView(
      SellerCapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequiredSellerCapabilities(UserType* output) {
    
    auto* pointer = data_->required_seller_capabilities.Get();
    return mojo::internal::Deserialize<::blink::mojom::SellerCapabilitiesDataView>(
        pointer, output, message_);
  }
  inline void GetRequestedSizeDataView(
      ::blink::mojom::AdSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdSizeDataView, UserType>(),
    "Attempting to read the optional `requested_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestedSize` instead "
    "of `ReadRequestedSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->requested_size.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdSizeDataView>(
        pointer, output, message_);
  }
  inline void GetAllSlotsRequestedSizesDataView(
      mojo::ArrayDataView<::blink::mojom::AdSizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllSlotsRequestedSizes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AdSizeDataView>, UserType>(),
    "Attempting to read the optional `all_slots_requested_sizes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllSlotsRequestedSizes` instead "
    "of `ReadAllSlotsRequestedSizes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_slots_requested_sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AdSizeDataView>>(
        pointer, output, message_);
  }
  inline void GetPerBuyerMultiBidLimitsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerMultiBidLimits(UserType* output) {
    
    auto* pointer = data_->per_buyer_multi_bid_limits.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        pointer, output, message_);
  }
  uint16_t all_buyers_multi_bid_limit() const {
    return data_->all_buyers_multi_bid_limit;
  }
  inline void GetAuctionNonceDataView(
      ::mojo_base::mojom::UuidDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UuidDataView, UserType>(),
    "Attempting to read the optional `auction_nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionNonce` instead "
    "of `ReadAuctionNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UuidDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSellerRealTimeReportingType(UserType* output) const {
    if (!data_->seller_real_time_reporting_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>(
        data_->seller_real_time_reporting_type_$value, &output->emplace());
  }
  std::optional<AuctionAdConfigNonSharedParams_RealTimeReportingType> seller_real_time_reporting_type() const {
    if (!data_->seller_real_time_reporting_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>(data_->seller_real_time_reporting_type_$value));
  }
  inline void GetPerBuyerRealTimeReportingTypesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, AuctionAdConfigNonSharedParams_RealTimeReportingType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerRealTimeReportingTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>, UserType>(),
    "Attempting to read the optional `per_buyer_real_time_reporting_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerRealTimeReportingTypes` instead "
    "of `ReadPerBuyerRealTimeReportingTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_real_time_reporting_types.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>>(
        pointer, output, message_);
  }
  inline void GetComponentAuctionsDataView(
      mojo::ArrayDataView<AuctionAdConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComponentAuctions(UserType* output) {
    
    auto* pointer = data_->component_auctions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AuctionAdConfigDataView>>(
        pointer, output, message_);
  }
  inline void GetDeprecatedRenderUrlReplacementsDataView(
      AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedRenderUrlReplacements(UserType* output) {
    
    auto* pointer = !data_->deprecated_render_url_replacements.is_null() ? &data_->deprecated_render_url_replacements : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView>(
        pointer, output, message_);
  }
  int32_t max_trusted_scoring_signals_url_length() const {
    return data_->max_trusted_scoring_signals_url_length;
  }
  inline void GetTrustedScoringSignalsCoordinatorDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedScoringSignalsCoordinator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `trusted_scoring_signals_coordinator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedScoringSignalsCoordinator` instead "
    "of `ReadTrustedScoringSignalsCoordinator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_scoring_signals_coordinator.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::AuctionAdConfigNonSharedParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigDataView {
 public:
  AuctionAdConfigDataView() = default;

  AuctionAdConfigDataView(
      internal::AuctionAdConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSellerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeller(UserType* output) {
    
    auto* pointer = data_->seller.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetServerResponseDataView(
      AuctionAdServerResponseConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuctionAdServerResponseConfigDataView, UserType>(),
    "Attempting to read the optional `server_response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServerResponse` instead "
    "of `ReadServerResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->server_response.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdServerResponseConfigDataView>(
        pointer, output, message_);
  }
  inline void GetDecisionLogicUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecisionLogicUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `decision_logic_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecisionLogicUrl` instead "
    "of `ReadDecisionLogicUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decision_logic_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedScoringSignalsUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedScoringSignalsUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `trusted_scoring_signals_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedScoringSignalsUrl` instead "
    "of `ReadTrustedScoringSignalsUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_scoring_signals_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAuctionAdConfigNonSharedParamsDataView(
      AuctionAdConfigNonSharedParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionAdConfigNonSharedParams(UserType* output) {
    
    auto* pointer = data_->auction_ad_config_non_shared_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigNonSharedParamsDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSignalsDataView(
      AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSignals(UserType* output) {
    
    auto* pointer = !data_->direct_from_seller_signals.is_null() ? &data_->direct_from_seller_signals : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView>(
        pointer, output, message_);
  }
  bool expects_direct_from_seller_signals_header_ad_slot() const {
    return data_->expects_direct_from_seller_signals_header_ad_slot;
  }
  std::optional<uint16_t> seller_experiment_group_id() const {

    return data_->seller_experiment_group_id_$flag
        ? std::make_optional(data_->seller_experiment_group_id_$value)
        : std::nullopt;
  }
  std::optional<uint16_t> all_buyer_experiment_group_id() const {

    return data_->all_buyer_experiment_group_id_$flag
        ? std::make_optional(data_->all_buyer_experiment_group_id_$value)
        : std::nullopt;
  }
  inline void GetPerBuyerExperimentGroupIdsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerExperimentGroupIds(UserType* output) {
    
    auto* pointer = data_->per_buyer_experiment_group_ids.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        pointer, output, message_);
  }
  bool expects_additional_bids() const {
    return data_->expects_additional_bids;
  }
  inline void GetAggregationCoordinatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `aggregation_coordinator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregationCoordinatorOrigin` instead "
    "of `ReadAggregationCoordinatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  std::optional<bool> send_creative_scanning_metadata() const {

    return data_->send_creative_scanning_metadata_$flag
        ? std::make_optional(!!data_->send_creative_scanning_metadata_$value)
        : std::nullopt;
  }
 private:
  internal::AuctionAdConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionDataBuyerConfigDataView {
 public:
  AuctionDataBuyerConfigDataView() = default;

  AuctionDataBuyerConfigDataView(
      internal::AuctionDataBuyerConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  std::optional<uint32_t> target_size() const {

    return data_->target_size_$flag
        ? std::make_optional(data_->target_size_$value)
        : std::nullopt;
  }
 private:
  internal::AuctionDataBuyerConfig_Data* data_ = nullptr;
};


class AuctionDataConfigDataView {
 public:
  AuctionDataConfigDataView() = default;

  AuctionDataConfigDataView(
      internal::AuctionDataConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPerBuyerConfigsDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, AuctionDataBuyerConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerConfigs(UserType* output) {
    
    auto* pointer = data_->per_buyer_configs.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionDataBuyerConfigDataView>>(
        pointer, output, message_);
  }
  std::optional<uint32_t> request_size() const {

    return data_->request_size_$flag
        ? std::make_optional(data_->request_size_$value)
        : std::nullopt;
  }
 private:
  internal::AuctionDataConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdAuctionPerSellerRequestDataView {
 public:
  AdAuctionPerSellerRequestDataView() = default;

  AdAuctionPerSellerRequestDataView(
      internal::AdAuctionPerSellerRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSellerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeller(UserType* output) {
    
    auto* pointer = data_->seller.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      AdAuctionRequestOrErrorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AdAuctionRequestOrErrorDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdAuctionPerSellerRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionAdConfigMaybePromiseJsonDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseJson_Data::AuctionAdConfigMaybePromiseJson_Tag;

  AuctionAdConfigMaybePromiseJsonDataView() = default;

  AuctionAdConfigMaybePromiseJsonDataView(
      internal::AuctionAdConfigMaybePromiseJson_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    CHECK(is_value());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseJson_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromisePerBuyerSignalsDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data::AuctionAdConfigMaybePromisePerBuyerSignals_Tag;

  AuctionAdConfigMaybePromisePerBuyerSignalsDataView() = default;

  AuctionAdConfigMaybePromisePerBuyerSignalsDataView(
      internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    CHECK(is_value());
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromiseBuyerTimeoutsDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data::AuctionAdConfigMaybePromiseBuyerTimeouts_Tag;

  AuctionAdConfigMaybePromiseBuyerTimeoutsDataView() = default;

  AuctionAdConfigMaybePromiseBuyerTimeoutsDataView(
      internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      AuctionAdConfigBuyerTimeoutsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
    CHECK(is_value());
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromiseBuyerCurrenciesDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data::AuctionAdConfigMaybePromiseBuyerCurrencies_Tag;

  AuctionAdConfigMaybePromiseBuyerCurrenciesDataView() = default;

  AuctionAdConfigMaybePromiseBuyerCurrenciesDataView(
      internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      AuctionAdConfigBuyerCurrenciesDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
    CHECK(is_value());
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Tag;

  AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView() = default;

  AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView(
      internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      DirectFromSellerSignalsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DirectFromSellerSignalsDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    CHECK(is_value());
    return mojo::internal::Deserialize<::blink::mojom::DirectFromSellerSignalsDataView>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView {
 public:
  using Tag = internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Tag;

  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView() = default;

  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView(
      internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_promise() const { return data_->tag == Tag::kPromise; }
  uint32_t promise() const {
    CHECK(is_promise());
    return data_->data.f_promise;
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  inline void GetValueDataView(
      mojo::ArrayDataView<AdKeywordReplacementDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    
    CHECK(is_value());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AdKeywordReplacementDataView>>(
        data_->data.f_value.Get(), output, message_);
  }

 private:
  internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AdAuctionRequestOrErrorDataView {
 public:
  using Tag = internal::AdAuctionRequestOrError_Data::AdAuctionRequestOrError_Tag;

  AdAuctionRequestOrErrorDataView() = default;

  AdAuctionRequestOrErrorDataView(
      internal::AdAuctionRequestOrError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_request() const { return data_->tag == Tag::kRequest; }
  inline void GetRequestDataView(
      ::mojo_base::mojom::BigBufferDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) const {
    
    CHECK(is_request());
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        data_->data.f_request.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::AdAuctionRequestOrError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::InterestGroup_ExecutionMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::InterestGroup_ExecutionMode> {};

template <>
struct hash<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode> {};

template <>
struct hash<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType> {};

template <>
struct hash<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InterestGroup_ExecutionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::InterestGroup_ExecutionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::InterestGroup_ExecutionMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InterestGroupAdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InterestGroupAdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InterestGroupAd_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::render_url(input)) in_render_url = Traits::render_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->render_url)::BaseType> render_url_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_render_url, render_url_fragment);
    fragment->render_url.Set(
        render_url_fragment.is_null() ? nullptr : render_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->render_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null render_url in InterestGroupAd struct");
    decltype(Traits::size_group(input)) in_size_group = Traits::size_group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size_group)::BaseType> size_group_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_size_group, size_group_fragment);
    fragment->size_group.Set(
        size_group_fragment.is_null() ? nullptr : size_group_fragment.data());
    decltype(Traits::buyer_reporting_id(input)) in_buyer_reporting_id = Traits::buyer_reporting_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buyer_reporting_id)::BaseType> buyer_reporting_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_buyer_reporting_id, buyer_reporting_id_fragment);
    fragment->buyer_reporting_id.Set(
        buyer_reporting_id_fragment.is_null() ? nullptr : buyer_reporting_id_fragment.data());
    decltype(Traits::buyer_and_seller_reporting_id(input)) in_buyer_and_seller_reporting_id = Traits::buyer_and_seller_reporting_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buyer_and_seller_reporting_id)::BaseType> buyer_and_seller_reporting_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_buyer_and_seller_reporting_id, buyer_and_seller_reporting_id_fragment);
    fragment->buyer_and_seller_reporting_id.Set(
        buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : buyer_and_seller_reporting_id_fragment.data());
    decltype(Traits::selectable_buyer_and_seller_reporting_ids(input)) in_selectable_buyer_and_seller_reporting_ids = Traits::selectable_buyer_and_seller_reporting_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selectable_buyer_and_seller_reporting_ids)::BaseType>
        selectable_buyer_and_seller_reporting_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& selectable_buyer_and_seller_reporting_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_selectable_buyer_and_seller_reporting_ids, selectable_buyer_and_seller_reporting_ids_fragment, &selectable_buyer_and_seller_reporting_ids_validate_params);
    fragment->selectable_buyer_and_seller_reporting_ids.Set(
        selectable_buyer_and_seller_reporting_ids_fragment.is_null() ? nullptr : selectable_buyer_and_seller_reporting_ids_fragment.data());
    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_metadata, metadata_fragment);
    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
    decltype(Traits::ad_render_id(input)) in_ad_render_id = Traits::ad_render_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_render_id)::BaseType> ad_render_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_ad_render_id, ad_render_id_fragment);
    fragment->ad_render_id.Set(
        ad_render_id_fragment.is_null() ? nullptr : ad_render_id_fragment.data());
    decltype(Traits::allowed_reporting_origins(input)) in_allowed_reporting_origins = Traits::allowed_reporting_origins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowed_reporting_origins)::BaseType>
        allowed_reporting_origins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allowed_reporting_origins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        in_allowed_reporting_origins, allowed_reporting_origins_fragment, &allowed_reporting_origins_validate_params);
    fragment->allowed_reporting_origins.Set(
        allowed_reporting_origins_fragment.is_null() ? nullptr : allowed_reporting_origins_fragment.data());
    decltype(Traits::creative_scanning_metadata(input)) in_creative_scanning_metadata = Traits::creative_scanning_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creative_scanning_metadata)::BaseType> creative_scanning_metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_creative_scanning_metadata, creative_scanning_metadata_fragment);
    fragment->creative_scanning_metadata.Set(
        creative_scanning_metadata_fragment.is_null() ? nullptr : creative_scanning_metadata_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::InterestGroupAd_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InterestGroupAdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SellerCapabilitiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SellerCapabilitiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SellerCapabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->allows_interest_group_counts = Traits::allows_interest_group_counts(input);
    fragment->allows_latency_stats = Traits::allows_latency_stats(input);
  }

  static bool Deserialize(::blink::mojom::internal::SellerCapabilities_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SellerCapabilitiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionServerRequestFlagsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionServerRequestFlagsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionServerRequestFlags_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->omit_ads = Traits::omit_ads(input);
    fragment->include_full_ads = Traits::include_full_ads(input);
    fragment->omit_user_bidding_signals = Traits::omit_user_bidding_signals(input);
  }

  static bool Deserialize(::blink::mojom::internal::AuctionServerRequestFlags_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionServerRequestFlagsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdKeywordReplacementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdKeywordReplacementDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdKeywordReplacement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::match(input)) in_match = Traits::match(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->match)::BaseType> match_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_match, match_fragment);
    fragment->match.Set(
        match_fragment.is_null() ? nullptr : match_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->match.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null match in AdKeywordReplacement struct");
    decltype(Traits::replacement(input)) in_replacement = Traits::replacement(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replacement)::BaseType> replacement_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_replacement, replacement_fragment);
    fragment->replacement.Set(
        replacement_fragment.is_null() ? nullptr : replacement_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->replacement.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replacement in AdKeywordReplacement struct");
  }

  static bool Deserialize(::blink::mojom::internal::AdKeywordReplacement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdKeywordReplacementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InterestGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InterestGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InterestGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::expiry(input)) in_expiry = Traits::expiry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiry)::BaseType> expiry_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expiry, expiry_fragment);
    fragment->expiry.Set(
        expiry_fragment.is_null() ? nullptr : expiry_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->expiry.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiry in InterestGroup struct");
    decltype(Traits::owner(input)) in_owner = Traits::owner(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->owner)::BaseType> owner_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_owner, owner_fragment);
    fragment->owner.Set(
        owner_fragment.is_null() ? nullptr : owner_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->owner.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null owner in InterestGroup struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in InterestGroup struct");
    fragment->priority = Traits::priority(input);
    fragment->enable_bidding_signals_prioritization = Traits::enable_bidding_signals_prioritization(input);
    decltype(Traits::priority_vector(input)) in_priority_vector = Traits::priority_vector(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->priority_vector)::BaseType>
        priority_vector_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& priority_vector_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, double>>(
        in_priority_vector, priority_vector_fragment, &priority_vector_validate_params);
    fragment->priority_vector.Set(
        priority_vector_fragment.is_null() ? nullptr : priority_vector_fragment.data());
    decltype(Traits::priority_signals_overrides(input)) in_priority_signals_overrides = Traits::priority_signals_overrides(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->priority_signals_overrides)::BaseType>
        priority_signals_overrides_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& priority_signals_overrides_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, double>>(
        in_priority_signals_overrides, priority_signals_overrides_fragment, &priority_signals_overrides_validate_params);
    fragment->priority_signals_overrides.Set(
        priority_signals_overrides_fragment.is_null() ? nullptr : priority_signals_overrides_fragment.data());
    decltype(Traits::seller_capabilities(input)) in_seller_capabilities = Traits::seller_capabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seller_capabilities)::BaseType>
        seller_capabilities_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& seller_capabilities_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::SellerCapabilitiesDataView>>(
        in_seller_capabilities, seller_capabilities_fragment, &seller_capabilities_validate_params);
    fragment->seller_capabilities.Set(
        seller_capabilities_fragment.is_null() ? nullptr : seller_capabilities_fragment.data());
    decltype(Traits::all_sellers_capabilities(input)) in_all_sellers_capabilities = Traits::all_sellers_capabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_sellers_capabilities)::BaseType> all_sellers_capabilities_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::SellerCapabilitiesDataView>(
        in_all_sellers_capabilities, all_sellers_capabilities_fragment);
    fragment->all_sellers_capabilities.Set(
        all_sellers_capabilities_fragment.is_null() ? nullptr : all_sellers_capabilities_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->all_sellers_capabilities.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_sellers_capabilities in InterestGroup struct");
    mojo::internal::Serialize<::blink::mojom::InterestGroup_ExecutionMode>(
        Traits::execution_mode(input), &fragment->execution_mode);
    mojo::internal::Serialize<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(
        Traits::trusted_bidding_signals_slot_size_mode(input), &fragment->trusted_bidding_signals_slot_size_mode);
    decltype(Traits::bidding_url(input)) in_bidding_url = Traits::bidding_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bidding_url)::BaseType> bidding_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_bidding_url, bidding_url_fragment);
    fragment->bidding_url.Set(
        bidding_url_fragment.is_null() ? nullptr : bidding_url_fragment.data());
    decltype(Traits::bidding_wasm_helper_url(input)) in_bidding_wasm_helper_url = Traits::bidding_wasm_helper_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bidding_wasm_helper_url)::BaseType> bidding_wasm_helper_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_bidding_wasm_helper_url, bidding_wasm_helper_url_fragment);
    fragment->bidding_wasm_helper_url.Set(
        bidding_wasm_helper_url_fragment.is_null() ? nullptr : bidding_wasm_helper_url_fragment.data());
    decltype(Traits::update_url(input)) in_update_url = Traits::update_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->update_url)::BaseType> update_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_update_url, update_url_fragment);
    fragment->update_url.Set(
        update_url_fragment.is_null() ? nullptr : update_url_fragment.data());
    decltype(Traits::trusted_bidding_signals_url(input)) in_trusted_bidding_signals_url = Traits::trusted_bidding_signals_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_bidding_signals_url)::BaseType> trusted_bidding_signals_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_trusted_bidding_signals_url, trusted_bidding_signals_url_fragment);
    fragment->trusted_bidding_signals_url.Set(
        trusted_bidding_signals_url_fragment.is_null() ? nullptr : trusted_bidding_signals_url_fragment.data());
    decltype(Traits::trusted_bidding_signals_keys(input)) in_trusted_bidding_signals_keys = Traits::trusted_bidding_signals_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_bidding_signals_keys)::BaseType>
        trusted_bidding_signals_keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trusted_bidding_signals_keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_trusted_bidding_signals_keys, trusted_bidding_signals_keys_fragment, &trusted_bidding_signals_keys_validate_params);
    fragment->trusted_bidding_signals_keys.Set(
        trusted_bidding_signals_keys_fragment.is_null() ? nullptr : trusted_bidding_signals_keys_fragment.data());
    fragment->max_trusted_bidding_signals_url_length = Traits::max_trusted_bidding_signals_url_length(input);
    decltype(Traits::trusted_bidding_signals_coordinator(input)) in_trusted_bidding_signals_coordinator = Traits::trusted_bidding_signals_coordinator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_bidding_signals_coordinator)::BaseType> trusted_bidding_signals_coordinator_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_trusted_bidding_signals_coordinator, trusted_bidding_signals_coordinator_fragment);
    fragment->trusted_bidding_signals_coordinator.Set(
        trusted_bidding_signals_coordinator_fragment.is_null() ? nullptr : trusted_bidding_signals_coordinator_fragment.data());
    decltype(Traits::user_bidding_signals(input)) in_user_bidding_signals = Traits::user_bidding_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_bidding_signals)::BaseType> user_bidding_signals_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_user_bidding_signals, user_bidding_signals_fragment);
    fragment->user_bidding_signals.Set(
        user_bidding_signals_fragment.is_null() ? nullptr : user_bidding_signals_fragment.data());
    decltype(Traits::ads(input)) in_ads = Traits::ads(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ads)::BaseType>
        ads_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ads_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        in_ads, ads_fragment, &ads_validate_params);
    fragment->ads.Set(
        ads_fragment.is_null() ? nullptr : ads_fragment.data());
    decltype(Traits::ad_components(input)) in_ad_components = Traits::ad_components(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_components)::BaseType>
        ad_components_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ad_components_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        in_ad_components, ad_components_fragment, &ad_components_validate_params);
    fragment->ad_components.Set(
        ad_components_fragment.is_null() ? nullptr : ad_components_fragment.data());
    decltype(Traits::ad_sizes(input)) in_ad_sizes = Traits::ad_sizes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_sizes)::BaseType>
        ad_sizes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ad_sizes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>>(
        in_ad_sizes, ad_sizes_fragment, &ad_sizes_validate_params);
    fragment->ad_sizes.Set(
        ad_sizes_fragment.is_null() ? nullptr : ad_sizes_fragment.data());
    decltype(Traits::size_groups(input)) in_size_groups = Traits::size_groups(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size_groups)::BaseType>
        size_groups_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& size_groups_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
        in_size_groups, size_groups_fragment, &size_groups_validate_params);
    fragment->size_groups.Set(
        size_groups_fragment.is_null() ? nullptr : size_groups_fragment.data());
    decltype(Traits::auction_server_request_flags(input)) in_auction_server_request_flags = Traits::auction_server_request_flags(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auction_server_request_flags)::BaseType> auction_server_request_flags_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AuctionServerRequestFlagsDataView>(
        in_auction_server_request_flags, auction_server_request_flags_fragment);
    fragment->auction_server_request_flags.Set(
        auction_server_request_flags_fragment.is_null() ? nullptr : auction_server_request_flags_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->auction_server_request_flags.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null auction_server_request_flags in InterestGroup struct");
    decltype(Traits::additional_bid_key(input)) in_additional_bid_key = Traits::additional_bid_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->additional_bid_key)::BaseType>
        additional_bid_key_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& additional_bid_key_validate_params =
        mojo::internal::GetArrayValidator<32, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_additional_bid_key, additional_bid_key_fragment, &additional_bid_key_validate_params);
    fragment->additional_bid_key.Set(
        additional_bid_key_fragment.is_null() ? nullptr : additional_bid_key_fragment.data());
    decltype(Traits::aggregation_coordinator_origin(input)) in_aggregation_coordinator_origin = Traits::aggregation_coordinator_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aggregation_coordinator_origin)::BaseType> aggregation_coordinator_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_aggregation_coordinator_origin, aggregation_coordinator_origin_fragment);
    fragment->aggregation_coordinator_origin.Set(
        aggregation_coordinator_origin_fragment.is_null() ? nullptr : aggregation_coordinator_origin_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::InterestGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InterestGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PreviousWinDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PreviousWinDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PreviousWin_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::time(input)) in_time = Traits::time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time)::BaseType> time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_time, time_fragment);
    fragment->time.Set(
        time_fragment.is_null() ? nullptr : time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time in PreviousWin struct");
    decltype(Traits::ad_json(input)) in_ad_json = Traits::ad_json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_json)::BaseType> ad_json_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_ad_json, ad_json_fragment);
    fragment->ad_json.Set(
        ad_json_fragment.is_null() ? nullptr : ad_json_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->ad_json.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ad_json in PreviousWin struct");
  }

  static bool Deserialize(::blink::mojom::internal::PreviousWin_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PreviousWinDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BiddingBrowserSignalsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BiddingBrowserSignalsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BiddingBrowserSignals_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->join_count = Traits::join_count(input);
    fragment->bid_count = Traits::bid_count(input);
    decltype(Traits::prev_wins(input)) in_prev_wins = Traits::prev_wins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prev_wins)::BaseType>
        prev_wins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& prev_wins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PreviousWinDataView>>(
        in_prev_wins, prev_wins_fragment, &prev_wins_validate_params);
    fragment->prev_wins.Set(
        prev_wins_fragment.is_null() ? nullptr : prev_wins_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->prev_wins.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prev_wins in BiddingBrowserSignals struct");
    fragment->for_debugging_only_in_cooldown_or_lockout = Traits::for_debugging_only_in_cooldown_or_lockout(input);
  }

  static bool Deserialize(::blink::mojom::internal::BiddingBrowserSignals_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BiddingBrowserSignalsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StorageInterestGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StorageInterestGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StorageInterestGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::interest_group(input)) in_interest_group = Traits::interest_group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interest_group)::BaseType> interest_group_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::InterestGroupDataView>(
        in_interest_group, interest_group_fragment);
    fragment->interest_group.Set(
        interest_group_fragment.is_null() ? nullptr : interest_group_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->interest_group.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interest_group in StorageInterestGroup struct");
    decltype(Traits::bidding_browser_signals(input)) in_bidding_browser_signals = Traits::bidding_browser_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bidding_browser_signals)::BaseType> bidding_browser_signals_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::BiddingBrowserSignalsDataView>(
        in_bidding_browser_signals, bidding_browser_signals_fragment);
    fragment->bidding_browser_signals.Set(
        bidding_browser_signals_fragment.is_null() ? nullptr : bidding_browser_signals_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bidding_browser_signals.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bidding_browser_signals in StorageInterestGroup struct");
    decltype(Traits::joining_origin(input)) in_joining_origin = Traits::joining_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->joining_origin)::BaseType> joining_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_joining_origin, joining_origin_fragment);
    fragment->joining_origin.Set(
        joining_origin_fragment.is_null() ? nullptr : joining_origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->joining_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null joining_origin in StorageInterestGroup struct");
    decltype(Traits::join_time(input)) in_join_time = Traits::join_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->join_time)::BaseType> join_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_join_time, join_time_fragment);
    fragment->join_time.Set(
        join_time_fragment.is_null() ? nullptr : join_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->join_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null join_time in StorageInterestGroup struct");
    decltype(Traits::last_updated(input)) in_last_updated = Traits::last_updated(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_updated)::BaseType> last_updated_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_updated, last_updated_fragment);
    fragment->last_updated.Set(
        last_updated_fragment.is_null() ? nullptr : last_updated_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->last_updated.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_updated in StorageInterestGroup struct");
    decltype(Traits::next_update_after(input)) in_next_update_after = Traits::next_update_after(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->next_update_after)::BaseType> next_update_after_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_next_update_after, next_update_after_fragment);
    fragment->next_update_after.Set(
        next_update_after_fragment.is_null() ? nullptr : next_update_after_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->next_update_after.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null next_update_after in StorageInterestGroup struct");
    fragment->estimated_size = Traits::estimated_size(input);
  }

  static bool Deserialize(::blink::mojom::internal::StorageInterestGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StorageInterestGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DirectFromSellerSignalsSubresourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DirectFromSellerSignalsSubresourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DirectFromSellerSignalsSubresource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bundle_url(input)) in_bundle_url = Traits::bundle_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bundle_url)::BaseType> bundle_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_bundle_url, bundle_url_fragment);
    fragment->bundle_url.Set(
        bundle_url_fragment.is_null() ? nullptr : bundle_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bundle_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bundle_url in DirectFromSellerSignalsSubresource struct");
    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_token, token_fragment);
    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in DirectFromSellerSignalsSubresource struct");
  }

  static bool Deserialize(::blink::mojom::internal::DirectFromSellerSignalsSubresource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DirectFromSellerSignalsSubresourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DirectFromSellerSignalsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DirectFromSellerSignalsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DirectFromSellerSignals_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::prefix(input)) in_prefix = Traits::prefix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prefix)::BaseType> prefix_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_prefix, prefix_fragment);
    fragment->prefix.Set(
        prefix_fragment.is_null() ? nullptr : prefix_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->prefix.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prefix in DirectFromSellerSignals struct");
    decltype(Traits::per_buyer_signals(input)) in_per_buyer_signals = Traits::per_buyer_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_signals)::BaseType>
        per_buyer_signals_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_signals_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::DirectFromSellerSignalsSubresourceDataView>>(
        in_per_buyer_signals, per_buyer_signals_fragment, &per_buyer_signals_validate_params);
    fragment->per_buyer_signals.Set(
        per_buyer_signals_fragment.is_null() ? nullptr : per_buyer_signals_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->per_buyer_signals.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null per_buyer_signals in DirectFromSellerSignals struct");
    decltype(Traits::seller_signals(input)) in_seller_signals = Traits::seller_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seller_signals)::BaseType> seller_signals_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::DirectFromSellerSignalsSubresourceDataView>(
        in_seller_signals, seller_signals_fragment);
    fragment->seller_signals.Set(
        seller_signals_fragment.is_null() ? nullptr : seller_signals_fragment.data());
    decltype(Traits::auction_signals(input)) in_auction_signals = Traits::auction_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auction_signals)::BaseType> auction_signals_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::DirectFromSellerSignalsSubresourceDataView>(
        in_auction_signals, auction_signals_fragment);
    fragment->auction_signals.Set(
        auction_signals_fragment.is_null() ? nullptr : auction_signals_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DirectFromSellerSignals_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DirectFromSellerSignalsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionAdConfigBuyerTimeouts_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::all_buyers_timeout(input)) in_all_buyers_timeout = Traits::all_buyers_timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_buyers_timeout)::BaseType> all_buyers_timeout_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_all_buyers_timeout, all_buyers_timeout_fragment);
    fragment->all_buyers_timeout.Set(
        all_buyers_timeout_fragment.is_null() ? nullptr : all_buyers_timeout_fragment.data());
    decltype(Traits::per_buyer_timeouts(input)) in_per_buyer_timeouts = Traits::per_buyer_timeouts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_timeouts)::BaseType>
        per_buyer_timeouts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_timeouts_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>>(
        in_per_buyer_timeouts, per_buyer_timeouts_fragment, &per_buyer_timeouts_validate_params);
    fragment->per_buyer_timeouts.Set(
        per_buyer_timeouts_fragment.is_null() ? nullptr : per_buyer_timeouts_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigBuyerTimeouts_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdCurrencyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdCurrencyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdCurrency_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::currency_code(input)) in_currency_code = Traits::currency_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->currency_code)::BaseType> currency_code_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_currency_code, currency_code_fragment);
    fragment->currency_code.Set(
        currency_code_fragment.is_null() ? nullptr : currency_code_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->currency_code.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null currency_code in AdCurrency struct");
  }

  static bool Deserialize(::blink::mojom::internal::AdCurrency_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdCurrencyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionAdConfigBuyerCurrencies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::all_buyers_currency(input)) in_all_buyers_currency = Traits::all_buyers_currency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_buyers_currency)::BaseType> all_buyers_currency_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
        in_all_buyers_currency, all_buyers_currency_fragment);
    fragment->all_buyers_currency.Set(
        all_buyers_currency_fragment.is_null() ? nullptr : all_buyers_currency_fragment.data());
    decltype(Traits::per_buyer_currencies(input)) in_per_buyer_currencies = Traits::per_buyer_currencies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_currencies)::BaseType>
        per_buyer_currencies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_currencies_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AdCurrencyDataView>>(
        in_per_buyer_currencies, per_buyer_currencies_fragment, &per_buyer_currencies_validate_params);
    fragment->per_buyer_currencies.Set(
        per_buyer_currencies_fragment.is_null() ? nullptr : per_buyer_currencies_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigBuyerCurrencies_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdServerResponseConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionAdServerResponseConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionAdServerResponseConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::request_id(input)) in_request_id = Traits::request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_id)::BaseType> request_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
        in_request_id, request_id_fragment);
    fragment->request_id.Set(
        request_id_fragment.is_null() ? nullptr : request_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->request_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_id in AuctionAdServerResponseConfig struct");
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdServerResponseConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdServerResponseConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionReportBuyerDebugModeConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionReportBuyerDebugModeConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionReportBuyerDebugModeConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->is_enabled = Traits::is_enabled(input);
    fragment->debug_key_$flag = Traits::debug_key(input).has_value();
    if (Traits::debug_key(input).has_value()) {
      fragment->debug_key_$value = Traits::debug_key(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionReportBuyerDebugModeConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionReportBuyerDebugModeConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionReportBuyersConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionReportBuyersConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionReportBuyersConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bucket(input)) in_bucket = Traits::bucket(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bucket)::BaseType> bucket_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView>(
        in_bucket, bucket_fragment);
    fragment->bucket.Set(
        bucket_fragment.is_null() ? nullptr : bucket_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bucket.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bucket in AuctionReportBuyersConfig struct");
    fragment->scale = Traits::scale(input);
  }

  static bool Deserialize(::blink::mojom::internal::AuctionReportBuyersConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionReportBuyersConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigNonSharedParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionAdConfigNonSharedParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionAdConfigNonSharedParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::interest_group_buyers(input)) in_interest_group_buyers = Traits::interest_group_buyers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interest_group_buyers)::BaseType>
        interest_group_buyers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& interest_group_buyers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        in_interest_group_buyers, interest_group_buyers_fragment, &interest_group_buyers_validate_params);
    fragment->interest_group_buyers.Set(
        interest_group_buyers_fragment.is_null() ? nullptr : interest_group_buyers_fragment.data());
    decltype(Traits::auction_signals(input)) in_auction_signals = Traits::auction_signals(input);
    mojo::internal::MessageFragment<decltype(fragment->auction_signals)>
        auction_signals_fragment(fragment.message());
    auction_signals_fragment.Claim(&fragment->auction_signals);
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView>(
        in_auction_signals, auction_signals_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->auction_signals.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null auction_signals in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::seller_signals(input)) in_seller_signals = Traits::seller_signals(input);
    mojo::internal::MessageFragment<decltype(fragment->seller_signals)>
        seller_signals_fragment(fragment.message());
    seller_signals_fragment.Claim(&fragment->seller_signals);
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView>(
        in_seller_signals, seller_signals_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->seller_signals.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null seller_signals in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::seller_timeout(input)) in_seller_timeout = Traits::seller_timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seller_timeout)::BaseType> seller_timeout_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_seller_timeout, seller_timeout_fragment);
    fragment->seller_timeout.Set(
        seller_timeout_fragment.is_null() ? nullptr : seller_timeout_fragment.data());
    decltype(Traits::per_buyer_signals(input)) in_per_buyer_signals = Traits::per_buyer_signals(input);
    mojo::internal::MessageFragment<decltype(fragment->per_buyer_signals)>
        per_buyer_signals_fragment(fragment.message());
    per_buyer_signals_fragment.Claim(&fragment->per_buyer_signals);
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView>(
        in_per_buyer_signals, per_buyer_signals_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->per_buyer_signals.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null per_buyer_signals in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::buyer_timeouts(input)) in_buyer_timeouts = Traits::buyer_timeouts(input);
    mojo::internal::MessageFragment<decltype(fragment->buyer_timeouts)>
        buyer_timeouts_fragment(fragment.message());
    buyer_timeouts_fragment.Claim(&fragment->buyer_timeouts);
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView>(
        in_buyer_timeouts, buyer_timeouts_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->buyer_timeouts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buyer_timeouts in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::reporting_timeout(input)) in_reporting_timeout = Traits::reporting_timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_timeout)::BaseType> reporting_timeout_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_reporting_timeout, reporting_timeout_fragment);
    fragment->reporting_timeout.Set(
        reporting_timeout_fragment.is_null() ? nullptr : reporting_timeout_fragment.data());
    decltype(Traits::seller_currency(input)) in_seller_currency = Traits::seller_currency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seller_currency)::BaseType> seller_currency_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
        in_seller_currency, seller_currency_fragment);
    fragment->seller_currency.Set(
        seller_currency_fragment.is_null() ? nullptr : seller_currency_fragment.data());
    decltype(Traits::buyer_currencies(input)) in_buyer_currencies = Traits::buyer_currencies(input);
    mojo::internal::MessageFragment<decltype(fragment->buyer_currencies)>
        buyer_currencies_fragment(fragment.message());
    buyer_currencies_fragment.Claim(&fragment->buyer_currencies);
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView>(
        in_buyer_currencies, buyer_currencies_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->buyer_currencies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buyer_currencies in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::buyer_cumulative_timeouts(input)) in_buyer_cumulative_timeouts = Traits::buyer_cumulative_timeouts(input);
    mojo::internal::MessageFragment<decltype(fragment->buyer_cumulative_timeouts)>
        buyer_cumulative_timeouts_fragment(fragment.message());
    buyer_cumulative_timeouts_fragment.Claim(&fragment->buyer_cumulative_timeouts);
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView>(
        in_buyer_cumulative_timeouts, buyer_cumulative_timeouts_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->buyer_cumulative_timeouts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buyer_cumulative_timeouts in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::per_buyer_group_limits(input)) in_per_buyer_group_limits = Traits::per_buyer_group_limits(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_group_limits)::BaseType>
        per_buyer_group_limits_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_group_limits_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        in_per_buyer_group_limits, per_buyer_group_limits_fragment, &per_buyer_group_limits_validate_params);
    fragment->per_buyer_group_limits.Set(
        per_buyer_group_limits_fragment.is_null() ? nullptr : per_buyer_group_limits_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->per_buyer_group_limits.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null per_buyer_group_limits in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::per_buyer_priority_signals(input)) in_per_buyer_priority_signals = Traits::per_buyer_priority_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_priority_signals)::BaseType>
        per_buyer_priority_signals_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_priority_signals_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>>(
        in_per_buyer_priority_signals, per_buyer_priority_signals_fragment, &per_buyer_priority_signals_validate_params);
    fragment->per_buyer_priority_signals.Set(
        per_buyer_priority_signals_fragment.is_null() ? nullptr : per_buyer_priority_signals_fragment.data());
    decltype(Traits::all_buyers_priority_signals(input)) in_all_buyers_priority_signals = Traits::all_buyers_priority_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_buyers_priority_signals)::BaseType>
        all_buyers_priority_signals_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_buyers_priority_signals_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, double>>(
        in_all_buyers_priority_signals, all_buyers_priority_signals_fragment, &all_buyers_priority_signals_validate_params);
    fragment->all_buyers_priority_signals.Set(
        all_buyers_priority_signals_fragment.is_null() ? nullptr : all_buyers_priority_signals_fragment.data());
    fragment->all_buyers_group_limit = Traits::all_buyers_group_limit(input);
    decltype(Traits::auction_report_buyer_keys(input)) in_auction_report_buyer_keys = Traits::auction_report_buyer_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auction_report_buyer_keys)::BaseType>
        auction_report_buyer_keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& auction_report_buyer_keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>>(
        in_auction_report_buyer_keys, auction_report_buyer_keys_fragment, &auction_report_buyer_keys_validate_params);
    fragment->auction_report_buyer_keys.Set(
        auction_report_buyer_keys_fragment.is_null() ? nullptr : auction_report_buyer_keys_fragment.data());
    decltype(Traits::auction_report_buyers(input)) in_auction_report_buyers = Traits::auction_report_buyers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auction_report_buyers)::BaseType>
        auction_report_buyers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& auction_report_buyers_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AuctionAdConfigNonSharedParams_BuyerReportType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType, ::blink::mojom::AuctionReportBuyersConfigDataView>>(
        in_auction_report_buyers, auction_report_buyers_fragment, &auction_report_buyers_validate_params);
    fragment->auction_report_buyers.Set(
        auction_report_buyers_fragment.is_null() ? nullptr : auction_report_buyers_fragment.data());
    decltype(Traits::auction_report_buyer_debug_mode_config(input)) in_auction_report_buyer_debug_mode_config = Traits::auction_report_buyer_debug_mode_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auction_report_buyer_debug_mode_config)::BaseType> auction_report_buyer_debug_mode_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AuctionReportBuyerDebugModeConfigDataView>(
        in_auction_report_buyer_debug_mode_config, auction_report_buyer_debug_mode_config_fragment);
    fragment->auction_report_buyer_debug_mode_config.Set(
        auction_report_buyer_debug_mode_config_fragment.is_null() ? nullptr : auction_report_buyer_debug_mode_config_fragment.data());
    decltype(Traits::required_seller_capabilities(input)) in_required_seller_capabilities = Traits::required_seller_capabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->required_seller_capabilities)::BaseType> required_seller_capabilities_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::SellerCapabilitiesDataView>(
        in_required_seller_capabilities, required_seller_capabilities_fragment);
    fragment->required_seller_capabilities.Set(
        required_seller_capabilities_fragment.is_null() ? nullptr : required_seller_capabilities_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->required_seller_capabilities.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null required_seller_capabilities in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::requested_size(input)) in_requested_size = Traits::requested_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requested_size)::BaseType> requested_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AdSizeDataView>(
        in_requested_size, requested_size_fragment);
    fragment->requested_size.Set(
        requested_size_fragment.is_null() ? nullptr : requested_size_fragment.data());
    decltype(Traits::all_slots_requested_sizes(input)) in_all_slots_requested_sizes = Traits::all_slots_requested_sizes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_slots_requested_sizes)::BaseType>
        all_slots_requested_sizes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_slots_requested_sizes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdSizeDataView>>(
        in_all_slots_requested_sizes, all_slots_requested_sizes_fragment, &all_slots_requested_sizes_validate_params);
    fragment->all_slots_requested_sizes.Set(
        all_slots_requested_sizes_fragment.is_null() ? nullptr : all_slots_requested_sizes_fragment.data());
    decltype(Traits::per_buyer_multi_bid_limits(input)) in_per_buyer_multi_bid_limits = Traits::per_buyer_multi_bid_limits(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_multi_bid_limits)::BaseType>
        per_buyer_multi_bid_limits_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_multi_bid_limits_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        in_per_buyer_multi_bid_limits, per_buyer_multi_bid_limits_fragment, &per_buyer_multi_bid_limits_validate_params);
    fragment->per_buyer_multi_bid_limits.Set(
        per_buyer_multi_bid_limits_fragment.is_null() ? nullptr : per_buyer_multi_bid_limits_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->per_buyer_multi_bid_limits.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null per_buyer_multi_bid_limits in AuctionAdConfigNonSharedParams struct");
    fragment->all_buyers_multi_bid_limit = Traits::all_buyers_multi_bid_limit(input);
    decltype(Traits::auction_nonce(input)) in_auction_nonce = Traits::auction_nonce(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auction_nonce)::BaseType> auction_nonce_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
        in_auction_nonce, auction_nonce_fragment);
    fragment->auction_nonce.Set(
        auction_nonce_fragment.is_null() ? nullptr : auction_nonce_fragment.data());
    fragment->seller_real_time_reporting_type_$flag = Traits::seller_real_time_reporting_type(input).has_value();
    if (Traits::seller_real_time_reporting_type(input).has_value()) {
      mojo::internal::Serialize<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>(
          Traits::seller_real_time_reporting_type(input).value(), &fragment->seller_real_time_reporting_type_$value);
    } else {
      fragment->seller_real_time_reporting_type_$value =
          static_cast<int32_t>(::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType::kMinValue);
    }
    decltype(Traits::per_buyer_real_time_reporting_types(input)) in_per_buyer_real_time_reporting_types = Traits::per_buyer_real_time_reporting_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_real_time_reporting_types)::BaseType>
        per_buyer_real_time_reporting_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_real_time_reporting_types_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AuctionAdConfigNonSharedParams_RealTimeReportingType_Data::Validate>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>>(
        in_per_buyer_real_time_reporting_types, per_buyer_real_time_reporting_types_fragment, &per_buyer_real_time_reporting_types_validate_params);
    fragment->per_buyer_real_time_reporting_types.Set(
        per_buyer_real_time_reporting_types_fragment.is_null() ? nullptr : per_buyer_real_time_reporting_types_fragment.data());
    decltype(Traits::component_auctions(input)) in_component_auctions = Traits::component_auctions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->component_auctions)::BaseType>
        component_auctions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& component_auctions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AuctionAdConfigDataView>>(
        in_component_auctions, component_auctions_fragment, &component_auctions_validate_params);
    fragment->component_auctions.Set(
        component_auctions_fragment.is_null() ? nullptr : component_auctions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->component_auctions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null component_auctions in AuctionAdConfigNonSharedParams struct");
    decltype(Traits::deprecated_render_url_replacements(input)) in_deprecated_render_url_replacements = Traits::deprecated_render_url_replacements(input);
    mojo::internal::MessageFragment<decltype(fragment->deprecated_render_url_replacements)>
        deprecated_render_url_replacements_fragment(fragment.message());
    deprecated_render_url_replacements_fragment.Claim(&fragment->deprecated_render_url_replacements);
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView>(
        in_deprecated_render_url_replacements, deprecated_render_url_replacements_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->deprecated_render_url_replacements.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null deprecated_render_url_replacements in AuctionAdConfigNonSharedParams struct");
    fragment->max_trusted_scoring_signals_url_length = Traits::max_trusted_scoring_signals_url_length(input);
    decltype(Traits::trusted_scoring_signals_coordinator(input)) in_trusted_scoring_signals_coordinator = Traits::trusted_scoring_signals_coordinator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_scoring_signals_coordinator)::BaseType> trusted_scoring_signals_coordinator_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_trusted_scoring_signals_coordinator, trusted_scoring_signals_coordinator_fragment);
    fragment->trusted_scoring_signals_coordinator.Set(
        trusted_scoring_signals_coordinator_fragment.is_null() ? nullptr : trusted_scoring_signals_coordinator_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigNonSharedParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigNonSharedParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionAdConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionAdConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::seller(input)) in_seller = Traits::seller(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seller)::BaseType> seller_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_seller, seller_fragment);
    fragment->seller.Set(
        seller_fragment.is_null() ? nullptr : seller_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->seller.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null seller in AuctionAdConfig struct");
    decltype(Traits::server_response(input)) in_server_response = Traits::server_response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_response)::BaseType> server_response_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AuctionAdServerResponseConfigDataView>(
        in_server_response, server_response_fragment);
    fragment->server_response.Set(
        server_response_fragment.is_null() ? nullptr : server_response_fragment.data());
    decltype(Traits::decision_logic_url(input)) in_decision_logic_url = Traits::decision_logic_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->decision_logic_url)::BaseType> decision_logic_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_decision_logic_url, decision_logic_url_fragment);
    fragment->decision_logic_url.Set(
        decision_logic_url_fragment.is_null() ? nullptr : decision_logic_url_fragment.data());
    decltype(Traits::trusted_scoring_signals_url(input)) in_trusted_scoring_signals_url = Traits::trusted_scoring_signals_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_scoring_signals_url)::BaseType> trusted_scoring_signals_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_trusted_scoring_signals_url, trusted_scoring_signals_url_fragment);
    fragment->trusted_scoring_signals_url.Set(
        trusted_scoring_signals_url_fragment.is_null() ? nullptr : trusted_scoring_signals_url_fragment.data());
    decltype(Traits::auction_ad_config_non_shared_params(input)) in_auction_ad_config_non_shared_params = Traits::auction_ad_config_non_shared_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auction_ad_config_non_shared_params)::BaseType> auction_ad_config_non_shared_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigNonSharedParamsDataView>(
        in_auction_ad_config_non_shared_params, auction_ad_config_non_shared_params_fragment);
    fragment->auction_ad_config_non_shared_params.Set(
        auction_ad_config_non_shared_params_fragment.is_null() ? nullptr : auction_ad_config_non_shared_params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->auction_ad_config_non_shared_params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null auction_ad_config_non_shared_params in AuctionAdConfig struct");
    decltype(Traits::direct_from_seller_signals(input)) in_direct_from_seller_signals = Traits::direct_from_seller_signals(input);
    mojo::internal::MessageFragment<decltype(fragment->direct_from_seller_signals)>
        direct_from_seller_signals_fragment(fragment.message());
    direct_from_seller_signals_fragment.Claim(&fragment->direct_from_seller_signals);
    mojo::internal::Serialize<::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView>(
        in_direct_from_seller_signals, direct_from_seller_signals_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->direct_from_seller_signals.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null direct_from_seller_signals in AuctionAdConfig struct");
    fragment->expects_direct_from_seller_signals_header_ad_slot = Traits::expects_direct_from_seller_signals_header_ad_slot(input);
    fragment->seller_experiment_group_id_$flag = Traits::seller_experiment_group_id(input).has_value();
    if (Traits::seller_experiment_group_id(input).has_value()) {
      fragment->seller_experiment_group_id_$value = Traits::seller_experiment_group_id(input).value();
    }
    fragment->all_buyer_experiment_group_id_$flag = Traits::all_buyer_experiment_group_id(input).has_value();
    if (Traits::all_buyer_experiment_group_id(input).has_value()) {
      fragment->all_buyer_experiment_group_id_$value = Traits::all_buyer_experiment_group_id(input).value();
    }
    decltype(Traits::per_buyer_experiment_group_ids(input)) in_per_buyer_experiment_group_ids = Traits::per_buyer_experiment_group_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_experiment_group_ids)::BaseType>
        per_buyer_experiment_group_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_experiment_group_ids_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>>(
        in_per_buyer_experiment_group_ids, per_buyer_experiment_group_ids_fragment, &per_buyer_experiment_group_ids_validate_params);
    fragment->per_buyer_experiment_group_ids.Set(
        per_buyer_experiment_group_ids_fragment.is_null() ? nullptr : per_buyer_experiment_group_ids_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->per_buyer_experiment_group_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null per_buyer_experiment_group_ids in AuctionAdConfig struct");
    fragment->expects_additional_bids = Traits::expects_additional_bids(input);
    decltype(Traits::aggregation_coordinator_origin(input)) in_aggregation_coordinator_origin = Traits::aggregation_coordinator_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aggregation_coordinator_origin)::BaseType> aggregation_coordinator_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_aggregation_coordinator_origin, aggregation_coordinator_origin_fragment);
    fragment->aggregation_coordinator_origin.Set(
        aggregation_coordinator_origin_fragment.is_null() ? nullptr : aggregation_coordinator_origin_fragment.data());
    fragment->send_creative_scanning_metadata_$flag = Traits::send_creative_scanning_metadata(input).has_value();
    if (Traits::send_creative_scanning_metadata(input).has_value()) {
      fragment->send_creative_scanning_metadata_$value = Traits::send_creative_scanning_metadata(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionDataBuyerConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionDataBuyerConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionDataBuyerConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->target_size_$flag = Traits::target_size(input).has_value();
    if (Traits::target_size(input).has_value()) {
      fragment->target_size_$value = Traits::target_size(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionDataBuyerConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionDataBuyerConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionDataConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuctionDataConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuctionDataConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::per_buyer_configs(input)) in_per_buyer_configs = Traits::per_buyer_configs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_buyer_configs)::BaseType>
        per_buyer_configs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_buyer_configs_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, ::blink::mojom::AuctionDataBuyerConfigDataView>>(
        in_per_buyer_configs, per_buyer_configs_fragment, &per_buyer_configs_validate_params);
    fragment->per_buyer_configs.Set(
        per_buyer_configs_fragment.is_null() ? nullptr : per_buyer_configs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->per_buyer_configs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null per_buyer_configs in AuctionDataConfig struct");
    fragment->request_size_$flag = Traits::request_size(input).has_value();
    if (Traits::request_size(input).has_value()) {
      fragment->request_size_$value = Traits::request_size(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionDataConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionDataConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdAuctionPerSellerRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdAuctionPerSellerRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdAuctionPerSellerRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::seller(input)) in_seller = Traits::seller(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seller)::BaseType> seller_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_seller, seller_fragment);
    fragment->seller.Set(
        seller_fragment.is_null() ? nullptr : seller_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->seller.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null seller in AdAuctionPerSellerRequest struct");
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    mojo::internal::Serialize<::blink::mojom::AdAuctionRequestOrErrorDataView>(
        in_data, data_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in AdAuctionPerSellerRequest struct");
  }

  static bool Deserialize(::blink::mojom::internal::AdAuctionPerSellerRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdAuctionPerSellerRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::AuctionAdConfigMaybePromiseJson_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView::Tag::kPromise: {
        decltype(Traits::promise(input))
            in_promise = Traits::promise(input);
        fragment->data.f_promise = in_promise;
        break;
      }
      case ::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView::Tag::kValue: {
        decltype(Traits::value(input))
            in_value = Traits::value(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_value)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<mojo::StringDataView>(
            in_value, value_fragment);
        fragment->data.f_value.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigMaybePromiseJson_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigMaybePromiseJsonDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView::Tag::kPromise: {
        decltype(Traits::promise(input))
            in_promise = Traits::promise(input);
        fragment->data.f_promise = in_promise;
        break;
      }
      case ::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView::Tag::kValue: {
        decltype(Traits::value(input))
            in_value = Traits::value(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_value)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
            mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
        mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>>(
            in_value, value_fragment, &value_validate_params);
        fragment->data.f_value.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView::Tag::kPromise: {
        decltype(Traits::promise(input))
            in_promise = Traits::promise(input);
        fragment->data.f_promise = in_promise;
        break;
      }
      case ::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView::Tag::kValue: {
        decltype(Traits::value(input))
            in_value = Traits::value(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_value)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::AuctionAdConfigBuyerTimeoutsDataView>(
            in_value, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null value in AuctionAdConfigMaybePromiseBuyerTimeouts union");
        fragment->data.f_value.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView::Tag::kPromise: {
        decltype(Traits::promise(input))
            in_promise = Traits::promise(input);
        fragment->data.f_promise = in_promise;
        break;
      }
      case ::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView::Tag::kValue: {
        decltype(Traits::value(input))
            in_value = Traits::value(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_value)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::AuctionAdConfigBuyerCurrenciesDataView>(
            in_value, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null value in AuctionAdConfigMaybePromiseBuyerCurrencies union");
        fragment->data.f_value.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView::Tag::kPromise: {
        decltype(Traits::promise(input))
            in_promise = Traits::promise(input);
        fragment->data.f_promise = in_promise;
        break;
      }
      case ::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView::Tag::kValue: {
        decltype(Traits::value(input))
            in_value = Traits::value(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_value)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::DirectFromSellerSignalsDataView>(
            in_value, value_fragment);
        fragment->data.f_value.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView::Tag::kPromise: {
        decltype(Traits::promise(input))
            in_promise = Traits::promise(input);
        fragment->data.f_promise = in_promise;
        break;
      }
      case ::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView::Tag::kValue: {
        decltype(Traits::value(input))
            in_value = Traits::value(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_value)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdKeywordReplacementDataView>>(
            in_value, value_fragment, &value_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null value in AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements union");
        fragment->data.f_value.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdAuctionRequestOrErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::AdAuctionRequestOrErrorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::AdAuctionRequestOrError_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::AdAuctionRequestOrErrorDataView::Tag::kRequest: {
        decltype(Traits::request(input))
            in_request = Traits::request(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_request)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
            in_request, value_fragment, false);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null request in AdAuctionRequestOrError union");
        fragment->data.f_request.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::AdAuctionRequestOrErrorDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_error)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<mojo::StringDataView>(
            in_error, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null error in AdAuctionRequestOrError union");
        fragment->data.f_error.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::AdAuctionRequestOrError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdAuctionRequestOrErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void InterestGroupAdDataView::GetRenderUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->render_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterestGroupAdDataView::GetSizeGroupDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->size_group.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterestGroupAdDataView::GetBuyerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->buyer_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterestGroupAdDataView::GetBuyerAndSellerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->buyer_and_seller_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterestGroupAdDataView::GetSelectableBuyerAndSellerReportingIdsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->selectable_buyer_and_seller_reporting_ids.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void InterestGroupAdDataView::GetMetadataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterestGroupAdDataView::GetAdRenderIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->ad_render_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterestGroupAdDataView::GetAllowedReportingOriginsDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->allowed_reporting_origins.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, message_);
}
inline void InterestGroupAdDataView::GetCreativeScanningMetadataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->creative_scanning_metadata.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void AdKeywordReplacementDataView::GetMatchDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->match.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdKeywordReplacementDataView::GetReplacementDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->replacement.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void InterestGroupDataView::GetExpiryDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiry.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void InterestGroupDataView::GetOwnerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->owner.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void InterestGroupDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterestGroupDataView::GetPriorityVectorDataView(
    mojo::MapDataView<mojo::StringDataView, double>* output) {
  auto pointer = data_->priority_vector.Get();
  *output = mojo::MapDataView<mojo::StringDataView, double>(pointer, message_);
}
inline void InterestGroupDataView::GetPrioritySignalsOverridesDataView(
    mojo::MapDataView<mojo::StringDataView, double>* output) {
  auto pointer = data_->priority_signals_overrides.Get();
  *output = mojo::MapDataView<mojo::StringDataView, double>(pointer, message_);
}
inline void InterestGroupDataView::GetSellerCapabilitiesDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, SellerCapabilitiesDataView>* output) {
  auto pointer = data_->seller_capabilities.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, SellerCapabilitiesDataView>(pointer, message_);
}
inline void InterestGroupDataView::GetAllSellersCapabilitiesDataView(
    SellerCapabilitiesDataView* output) {
  auto pointer = data_->all_sellers_capabilities.Get();
  *output = SellerCapabilitiesDataView(pointer, message_);
}
inline void InterestGroupDataView::GetBiddingUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->bidding_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void InterestGroupDataView::GetBiddingWasmHelperUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->bidding_wasm_helper_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void InterestGroupDataView::GetUpdateUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->update_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void InterestGroupDataView::GetTrustedBiddingSignalsUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->trusted_bidding_signals_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void InterestGroupDataView::GetTrustedBiddingSignalsKeysDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->trusted_bidding_signals_keys.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void InterestGroupDataView::GetTrustedBiddingSignalsCoordinatorDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->trusted_bidding_signals_coordinator.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void InterestGroupDataView::GetUserBiddingSignalsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_bidding_signals.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterestGroupDataView::GetAdsDataView(
    mojo::ArrayDataView<InterestGroupAdDataView>* output) {
  auto pointer = data_->ads.Get();
  *output = mojo::ArrayDataView<InterestGroupAdDataView>(pointer, message_);
}
inline void InterestGroupDataView::GetAdComponentsDataView(
    mojo::ArrayDataView<InterestGroupAdDataView>* output) {
  auto pointer = data_->ad_components.Get();
  *output = mojo::ArrayDataView<InterestGroupAdDataView>(pointer, message_);
}
inline void InterestGroupDataView::GetAdSizesDataView(
    mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>* output) {
  auto pointer = data_->ad_sizes.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::blink::mojom::AdSizeDataView>(pointer, message_);
}
inline void InterestGroupDataView::GetSizeGroupsDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output) {
  auto pointer = data_->size_groups.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>(pointer, message_);
}
inline void InterestGroupDataView::GetAuctionServerRequestFlagsDataView(
    AuctionServerRequestFlagsDataView* output) {
  auto pointer = data_->auction_server_request_flags.Get();
  *output = AuctionServerRequestFlagsDataView(pointer, message_);
}
inline void InterestGroupDataView::GetAdditionalBidKeyDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->additional_bid_key.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void InterestGroupDataView::GetAggregationCoordinatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->aggregation_coordinator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void PreviousWinDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void PreviousWinDataView::GetAdJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->ad_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BiddingBrowserSignalsDataView::GetPrevWinsDataView(
    mojo::ArrayDataView<PreviousWinDataView>* output) {
  auto pointer = data_->prev_wins.Get();
  *output = mojo::ArrayDataView<PreviousWinDataView>(pointer, message_);
}


inline void StorageInterestGroupDataView::GetInterestGroupDataView(
    InterestGroupDataView* output) {
  auto pointer = data_->interest_group.Get();
  *output = InterestGroupDataView(pointer, message_);
}
inline void StorageInterestGroupDataView::GetBiddingBrowserSignalsDataView(
    BiddingBrowserSignalsDataView* output) {
  auto pointer = data_->bidding_browser_signals.Get();
  *output = BiddingBrowserSignalsDataView(pointer, message_);
}
inline void StorageInterestGroupDataView::GetJoiningOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->joining_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void StorageInterestGroupDataView::GetJoinTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->join_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void StorageInterestGroupDataView::GetLastUpdatedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_updated.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void StorageInterestGroupDataView::GetNextUpdateAfterDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->next_update_after.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void DirectFromSellerSignalsSubresourceDataView::GetBundleUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->bundle_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DirectFromSellerSignalsSubresourceDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void DirectFromSellerSignalsDataView::GetPrefixDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->prefix.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DirectFromSellerSignalsDataView::GetPerBuyerSignalsDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, DirectFromSellerSignalsSubresourceDataView>* output) {
  auto pointer = data_->per_buyer_signals.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, DirectFromSellerSignalsSubresourceDataView>(pointer, message_);
}
inline void DirectFromSellerSignalsDataView::GetSellerSignalsDataView(
    DirectFromSellerSignalsSubresourceDataView* output) {
  auto pointer = data_->seller_signals.Get();
  *output = DirectFromSellerSignalsSubresourceDataView(pointer, message_);
}
inline void DirectFromSellerSignalsDataView::GetAuctionSignalsDataView(
    DirectFromSellerSignalsSubresourceDataView* output) {
  auto pointer = data_->auction_signals.Get();
  *output = DirectFromSellerSignalsSubresourceDataView(pointer, message_);
}


inline void AuctionAdConfigBuyerTimeoutsDataView::GetAllBuyersTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->all_buyers_timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void AuctionAdConfigBuyerTimeoutsDataView::GetPerBuyerTimeoutsDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>* output) {
  auto pointer = data_->per_buyer_timeouts.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, ::mojo_base::mojom::TimeDeltaDataView>(pointer, message_);
}


inline void AdCurrencyDataView::GetCurrencyCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->currency_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AuctionAdConfigBuyerCurrenciesDataView::GetAllBuyersCurrencyDataView(
    AdCurrencyDataView* output) {
  auto pointer = data_->all_buyers_currency.Get();
  *output = AdCurrencyDataView(pointer, message_);
}
inline void AuctionAdConfigBuyerCurrenciesDataView::GetPerBuyerCurrenciesDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, AdCurrencyDataView>* output) {
  auto pointer = data_->per_buyer_currencies.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, AdCurrencyDataView>(pointer, message_);
}


inline void AuctionAdServerResponseConfigDataView::GetRequestIdDataView(
    ::mojo_base::mojom::UuidDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = ::mojo_base::mojom::UuidDataView(pointer, message_);
}




inline void AuctionReportBuyersConfigDataView::GetBucketDataView(
    ::mojo_base::mojom::Uint128DataView* output) {
  auto pointer = data_->bucket.Get();
  *output = ::mojo_base::mojom::Uint128DataView(pointer, message_);
}


inline void AuctionAdConfigNonSharedParamsDataView::GetInterestGroupBuyersDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->interest_group_buyers.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetAuctionSignalsDataView(
    AuctionAdConfigMaybePromiseJsonDataView* output) {
  auto pointer = &data_->auction_signals;
  *output = AuctionAdConfigMaybePromiseJsonDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetSellerSignalsDataView(
    AuctionAdConfigMaybePromiseJsonDataView* output) {
  auto pointer = &data_->seller_signals;
  *output = AuctionAdConfigMaybePromiseJsonDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetSellerTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seller_timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetPerBuyerSignalsDataView(
    AuctionAdConfigMaybePromisePerBuyerSignalsDataView* output) {
  auto pointer = &data_->per_buyer_signals;
  *output = AuctionAdConfigMaybePromisePerBuyerSignalsDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetBuyerTimeoutsDataView(
    AuctionAdConfigMaybePromiseBuyerTimeoutsDataView* output) {
  auto pointer = &data_->buyer_timeouts;
  *output = AuctionAdConfigMaybePromiseBuyerTimeoutsDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetReportingTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->reporting_timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetSellerCurrencyDataView(
    AdCurrencyDataView* output) {
  auto pointer = data_->seller_currency.Get();
  *output = AdCurrencyDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetBuyerCurrenciesDataView(
    AuctionAdConfigMaybePromiseBuyerCurrenciesDataView* output) {
  auto pointer = &data_->buyer_currencies;
  *output = AuctionAdConfigMaybePromiseBuyerCurrenciesDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetBuyerCumulativeTimeoutsDataView(
    AuctionAdConfigMaybePromiseBuyerTimeoutsDataView* output) {
  auto pointer = &data_->buyer_cumulative_timeouts;
  *output = AuctionAdConfigMaybePromiseBuyerTimeoutsDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetPerBuyerGroupLimitsDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output) {
  auto pointer = data_->per_buyer_group_limits.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetPerBuyerPrioritySignalsDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>* output) {
  auto pointer = data_->per_buyer_priority_signals.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, mojo::MapDataView<mojo::StringDataView, double>>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetAllBuyersPrioritySignalsDataView(
    mojo::MapDataView<mojo::StringDataView, double>* output) {
  auto pointer = data_->all_buyers_priority_signals.Get();
  *output = mojo::MapDataView<mojo::StringDataView, double>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetAuctionReportBuyerKeysDataView(
    mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>* output) {
  auto pointer = data_->auction_report_buyer_keys.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::Uint128DataView>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetAuctionReportBuyersDataView(
    mojo::MapDataView<AuctionAdConfigNonSharedParams_BuyerReportType, AuctionReportBuyersConfigDataView>* output) {
  auto pointer = data_->auction_report_buyers.Get();
  *output = mojo::MapDataView<AuctionAdConfigNonSharedParams_BuyerReportType, AuctionReportBuyersConfigDataView>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetAuctionReportBuyerDebugModeConfigDataView(
    AuctionReportBuyerDebugModeConfigDataView* output) {
  auto pointer = data_->auction_report_buyer_debug_mode_config.Get();
  *output = AuctionReportBuyerDebugModeConfigDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetRequiredSellerCapabilitiesDataView(
    SellerCapabilitiesDataView* output) {
  auto pointer = data_->required_seller_capabilities.Get();
  *output = SellerCapabilitiesDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetRequestedSizeDataView(
    ::blink::mojom::AdSizeDataView* output) {
  auto pointer = data_->requested_size.Get();
  *output = ::blink::mojom::AdSizeDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetAllSlotsRequestedSizesDataView(
    mojo::ArrayDataView<::blink::mojom::AdSizeDataView>* output) {
  auto pointer = data_->all_slots_requested_sizes.Get();
  *output = mojo::ArrayDataView<::blink::mojom::AdSizeDataView>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetPerBuyerMultiBidLimitsDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output) {
  auto pointer = data_->per_buyer_multi_bid_limits.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetAuctionNonceDataView(
    ::mojo_base::mojom::UuidDataView* output) {
  auto pointer = data_->auction_nonce.Get();
  *output = ::mojo_base::mojom::UuidDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetPerBuyerRealTimeReportingTypesDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, AuctionAdConfigNonSharedParams_RealTimeReportingType>* output) {
  auto pointer = data_->per_buyer_real_time_reporting_types.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, AuctionAdConfigNonSharedParams_RealTimeReportingType>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetComponentAuctionsDataView(
    mojo::ArrayDataView<AuctionAdConfigDataView>* output) {
  auto pointer = data_->component_auctions.Get();
  *output = mojo::ArrayDataView<AuctionAdConfigDataView>(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetDeprecatedRenderUrlReplacementsDataView(
    AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView* output) {
  auto pointer = &data_->deprecated_render_url_replacements;
  *output = AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView(pointer, message_);
}
inline void AuctionAdConfigNonSharedParamsDataView::GetTrustedScoringSignalsCoordinatorDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->trusted_scoring_signals_coordinator.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void AuctionAdConfigDataView::GetSellerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->seller.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void AuctionAdConfigDataView::GetServerResponseDataView(
    AuctionAdServerResponseConfigDataView* output) {
  auto pointer = data_->server_response.Get();
  *output = AuctionAdServerResponseConfigDataView(pointer, message_);
}
inline void AuctionAdConfigDataView::GetDecisionLogicUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->decision_logic_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AuctionAdConfigDataView::GetTrustedScoringSignalsUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->trusted_scoring_signals_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AuctionAdConfigDataView::GetAuctionAdConfigNonSharedParamsDataView(
    AuctionAdConfigNonSharedParamsDataView* output) {
  auto pointer = data_->auction_ad_config_non_shared_params.Get();
  *output = AuctionAdConfigNonSharedParamsDataView(pointer, message_);
}
inline void AuctionAdConfigDataView::GetDirectFromSellerSignalsDataView(
    AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView* output) {
  auto pointer = &data_->direct_from_seller_signals;
  *output = AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView(pointer, message_);
}
inline void AuctionAdConfigDataView::GetPerBuyerExperimentGroupIdsDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>* output) {
  auto pointer = data_->per_buyer_experiment_group_ids.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, uint16_t>(pointer, message_);
}
inline void AuctionAdConfigDataView::GetAggregationCoordinatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->aggregation_coordinator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}




inline void AuctionDataConfigDataView::GetPerBuyerConfigsDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, AuctionDataBuyerConfigDataView>* output) {
  auto pointer = data_->per_buyer_configs.Get();
  *output = mojo::MapDataView<::url::mojom::OriginDataView, AuctionDataBuyerConfigDataView>(pointer, message_);
}


inline void AdAuctionPerSellerRequestDataView::GetSellerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->seller.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void AdAuctionPerSellerRequestDataView::GetDataDataView(
    AdAuctionRequestOrErrorDataView* output) {
  auto pointer = &data_->data;
  *output = AdAuctionRequestOrErrorDataView(pointer, message_);
}


inline void AuctionAdConfigMaybePromiseJsonDataView::GetValueDataView(
    mojo::StringDataView* output) const {
  CHECK(is_value());
  *output = mojo::StringDataView(data_->data.f_value.Get(), message_);
}

inline void AuctionAdConfigMaybePromisePerBuyerSignalsDataView::GetValueDataView(
    mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>* output) const {
  CHECK(is_value());
  *output = mojo::MapDataView<::url::mojom::OriginDataView, mojo::StringDataView>(data_->data.f_value.Get(), message_);
}

inline void AuctionAdConfigMaybePromiseBuyerTimeoutsDataView::GetValueDataView(
    AuctionAdConfigBuyerTimeoutsDataView* output) const {
  CHECK(is_value());
  *output = AuctionAdConfigBuyerTimeoutsDataView(data_->data.f_value.Get(), message_);
}

inline void AuctionAdConfigMaybePromiseBuyerCurrenciesDataView::GetValueDataView(
    AuctionAdConfigBuyerCurrenciesDataView* output) const {
  CHECK(is_value());
  *output = AuctionAdConfigBuyerCurrenciesDataView(data_->data.f_value.Get(), message_);
}

inline void AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView::GetValueDataView(
    DirectFromSellerSignalsDataView* output) const {
  CHECK(is_value());
  *output = DirectFromSellerSignalsDataView(data_->data.f_value.Get(), message_);
}

inline void AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView::GetValueDataView(
    mojo::ArrayDataView<AdKeywordReplacementDataView>* output) const {
  CHECK(is_value());
  *output = mojo::ArrayDataView<AdKeywordReplacementDataView>(data_->data.f_value.Get(), message_);
}

inline void AdAuctionRequestOrErrorDataView::GetRequestDataView(
    ::mojo_base::mojom::BigBufferDataView* output) const {
  CHECK(is_request());
  *output = ::mojo_base::mojom::BigBufferDataView(data_->data.f_request.Get(), message_);
}
inline void AdAuctionRequestOrErrorDataView::GetErrorDataView(
    mojo::StringDataView* output) const {
  CHECK(is_error());
  *output = mojo::StringDataView(data_->data.f_error.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::InterestGroup_ExecutionMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::InterestGroup_ExecutionMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_SHARED_H_