// third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/back_forward_cache_not_restored_reasons.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared.h"
#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/mixed_content.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/renderer_content_settings.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/system_entropy.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/was_activated_option.mojom-shared.h"
#include "third_party/blink/public/mojom/page/browsing_context_group_info.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/runtime_feature_state/runtime_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace blink::mojom {
class BeginNavigationParamsDataView;

class CommonNavigationParamsDataView;

class NavigationTimingDataView;

class OldPageInfoDataView;

class CommitNavigationParamsDataView;

class PageSwapEventParamsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::BeginNavigationParamsDataView> {
  using Data = ::blink::mojom::internal::BeginNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CommonNavigationParamsDataView> {
  using Data = ::blink::mojom::internal::CommonNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::NavigationTimingDataView> {
  using Data = ::blink::mojom::internal::NavigationTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::OldPageInfoDataView> {
  using Data = ::blink::mojom::internal::OldPageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CommitNavigationParamsDataView> {
  using Data = ::blink::mojom::internal::CommitNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PageSwapEventParamsDataView> {
  using Data = ::blink::mojom::internal::PageSwapEventParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class NavigationType : int32_t {
  
  RELOAD = 0,
  
  RELOAD_BYPASSING_CACHE = 1,
  
  RESTORE = 2,
  
  RESTORE_WITH_POST = 3,
  
  HISTORY_SAME_DOCUMENT = 4,
  
  HISTORY_DIFFERENT_DOCUMENT = 5,
  
  SAME_DOCUMENT = 6,
  
  DIFFERENT_DOCUMENT = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NavigationType value);
inline bool IsKnownEnumValue(NavigationType value) {
  return internal::NavigationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NavigationTypeForNavigationApi : int32_t {
  
  kPush = 0,
  
  kTraverse = 1,
  
  kReplace = 2,
  
  kReload = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NavigationTypeForNavigationApi value);
inline bool IsKnownEnumValue(NavigationTypeForNavigationApi value) {
  return internal::NavigationTypeForNavigationApi_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ForceHistoryPush : int32_t {
  
  kYes = 0,
  
  kNo = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ForceHistoryPush value);
inline bool IsKnownEnumValue(ForceHistoryPush value) {
  return internal::ForceHistoryPush_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ParentResourceTimingAccess : int32_t {
  
  kDoNotReport = 0,
  
  kReportWithoutResponseDetails = 1,
  
  kReportWithResponseDetails = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ParentResourceTimingAccess value);
inline bool IsKnownEnumValue(ParentResourceTimingAccess value) {
  return internal::ParentResourceTimingAccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BeginNavigationParamsDataView {
 public:
  BeginNavigationParamsDataView() = default;

  BeginNavigationParamsDataView(
      internal::BeginNavigationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInitiatorFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LocalFrameTokenDataView, UserType>(),
    "Attempting to read the optional `initiator_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorFrameToken` instead "
    "of `ReadInitiatorFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t load_flags() const {
    return data_->load_flags;
  }
  bool skip_service_worker() const {
    return data_->skip_service_worker;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestContextType(UserType* output) const {
    auto data_value = data_->request_context_type;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextType>(
        data_value, output);
  }
  ::blink::mojom::RequestContextType request_context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::RequestContextType>(data_->request_context_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMixedContentContextType(UserType* output) const {
    auto data_value = data_->mixed_content_context_type;
    return mojo::internal::Deserialize<::blink::mojom::MixedContentContextType>(
        data_value, output);
  }
  ::blink::mojom::MixedContentContextType mixed_content_context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MixedContentContextType>(data_->mixed_content_context_type));
  }
  bool is_form_submission() const {
    return data_->is_form_submission;
  }
  bool was_initiated_by_link_click() const {
    return data_->was_initiated_by_link_click;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadForceHistoryPush(UserType* output) const {
    auto data_value = data_->force_history_push;
    return mojo::internal::Deserialize<::blink::mojom::ForceHistoryPush>(
        data_value, output);
  }
  ForceHistoryPush force_history_push() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ForceHistoryPush>(data_->force_history_push));
  }
  inline void GetSearchableFormUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearchableFormUrl(UserType* output) {
    
    auto* pointer = data_->searchable_form_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSearchableFormEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearchableFormEncoding(UserType* output) {
    
    auto* pointer = data_->searchable_form_encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetClientSideRedirectUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSideRedirectUrl(UserType* output) {
    
    auto* pointer = data_->client_side_redirect_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsInitiatorDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsInitiator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::DictionaryValueDataView, UserType>(),
    "Attempting to read the optional `devtools_initiator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsInitiator` instead "
    "of `ReadDevtoolsInitiator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_initiator.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  inline void GetTrustTokenParamsDataView(
      ::network::mojom::TrustTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustTokenParamsDataView, UserType>(),
    "Attempting to read the optional `trust_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenParams` instead "
    "of `ReadTrustTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenParamsDataView>(
        pointer, output, message_);
  }
  inline void GetImpressionDataView(
      ::blink::mojom::ImpressionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImpression(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ImpressionDataView, UserType>(),
    "Attempting to read the optional `impression` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImpression` instead "
    "of `ReadImpression if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::blink::mojom::ImpressionDataView>(
        pointer, output, message_);
  }
  inline void GetBeforeUnloadStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBeforeUnloadStart(UserType* output) {
    
    auto* pointer = data_->before_unload_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetBeforeUnloadEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBeforeUnloadEnd(UserType* output) {
    
    auto* pointer = data_->before_unload_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorActivationAndAdStatus(UserType* output) const {
    auto data_value = data_->initiator_activation_and_ad_status;
    return mojo::internal::Deserialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        data_value, output);
  }
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(data_->initiator_activation_and_ad_status));
  }
  bool is_container_initiated() const {
    return data_->is_container_initiated;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  bool has_rel_opener() const {
    return data_->has_rel_opener;
  }
 private:
  internal::BeginNavigationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommonNavigationParamsDataView {
 public:
  CommonNavigationParamsDataView() = default;

  CommonNavigationParamsDataView(
      internal::CommonNavigationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `initiator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorOrigin` instead "
    "of `ReadInitiatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `initiator_base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorBaseUrl` instead "
    "of `ReadInitiatorBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  int32_t transition() const {
    return data_->transition;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationType(UserType* output) const {
    auto data_value = data_->navigation_type;
    return mojo::internal::Deserialize<::blink::mojom::NavigationType>(
        data_value, output);
  }
  NavigationType navigation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationType>(data_->navigation_type));
  }
  inline void GetDownloadPolicyDataView(
      ::blink::mojom::NavigationDownloadPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownloadPolicy(UserType* output) {
    
    auto* pointer = data_->download_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        pointer, output, message_);
  }
  bool should_replace_current_entry() const {
    return data_->should_replace_current_entry;
  }
  inline void GetBaseUrlForDataUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseUrlForDataUrl(UserType* output) {
    
    auto* pointer = data_->base_url_for_data_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationStart(UserType* output) {
    
    auto* pointer = data_->navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPostDataDataView(
      ::network::mojom::URLRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `post_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPostData` instead "
    "of `ReadPostData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->post_data.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, message_);
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, message_);
  }
  bool started_from_context_menu() const {
    return data_->started_from_context_menu;
  }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  bool text_fragment_token() const {
    return data_->text_fragment_token;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadShouldCheckMainWorldCsp(UserType* output) const {
    auto data_value = data_->should_check_main_world_csp;
    return mojo::internal::Deserialize<::network::mojom::CSPDisposition>(
        data_value, output);
  }
  ::network::mojom::CSPDisposition should_check_main_world_csp() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CSPDisposition>(data_->should_check_main_world_csp));
  }
  inline void GetInitiatorOriginTrialFeaturesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOriginTrialFeatures(UserType* output) {
    
    auto* pointer = data_->initiator_origin_trial_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetHrefTranslateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHrefTranslate(UserType* output) {
    
    auto* pointer = data_->href_translate.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_history_navigation_in_new_child_frame() const {
    return data_->is_history_navigation_in_new_child_frame;
  }
  inline void GetInputStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputStart(UserType* output) {
    
    auto* pointer = data_->input_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestDestination(UserType* output) const {
    auto data_value = data_->request_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination request_destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->request_destination));
  }
 private:
  internal::CommonNavigationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NavigationTimingDataView {
 public:
  NavigationTimingDataView() = default;

  NavigationTimingDataView(
      internal::NavigationTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRedirectStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectStart(UserType* output) {
    
    auto* pointer = data_->redirect_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetRedirectEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectEnd(UserType* output) {
    
    auto* pointer = data_->redirect_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetFetchStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchStart(UserType* output) {
    
    auto* pointer = data_->fetch_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSystemEntropyAtNavigationStart(UserType* output) const {
    auto data_value = data_->system_entropy_at_navigation_start;
    return mojo::internal::Deserialize<::blink::mojom::SystemEntropy>(
        data_value, output);
  }
  ::blink::mojom::SystemEntropy system_entropy_at_navigation_start() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SystemEntropy>(data_->system_entropy_at_navigation_start));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadParentResourceTimingAccess(UserType* output) const {
    auto data_value = data_->parent_resource_timing_access;
    return mojo::internal::Deserialize<::blink::mojom::ParentResourceTimingAccess>(
        data_value, output);
  }
  ParentResourceTimingAccess parent_resource_timing_access() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ParentResourceTimingAccess>(data_->parent_resource_timing_access));
  }
 private:
  internal::NavigationTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OldPageInfoDataView {
 public:
  OldPageInfoDataView() = default;

  OldPageInfoDataView(
      internal::OldPageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTokenForOldMainFrameDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameTokenForOldMainFrame(UserType* output) {
    
    auto* pointer = data_->frame_token_for_old_main_frame.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetNewLifecycleStateForOldPageDataView(
      ::blink::mojom::PageLifecycleStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewLifecycleStateForOldPage(UserType* output) {
    
    auto* pointer = data_->new_lifecycle_state_for_old_page.Get();
    return mojo::internal::Deserialize<::blink::mojom::PageLifecycleStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::OldPageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommitNavigationParamsDataView {
 public:
  CommitNavigationParamsDataView() = default;

  CommitNavigationParamsDataView(
      internal::CommitNavigationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginToCommitDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginToCommit(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `origin_to_commit` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOriginToCommit` instead "
    "of `ReadOriginToCommit if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->origin_to_commit.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetStorageKeyDataView(
      ::blink::mojom::StorageKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorageKey(UserType* output) {
    
    auto* pointer = data_->storage_key.Get();
    return mojo::internal::Deserialize<::blink::mojom::StorageKeyDataView>(
        pointer, output, message_);
  }
  bool is_overriding_user_agent() const {
    return data_->is_overriding_user_agent;
  }
  inline void GetRedirectsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirects(UserType* output) {
    
    auto* pointer = data_->redirects.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetRedirectResponseDataView(
      mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectResponse(UserType* output) {
    
    auto* pointer = data_->redirect_response.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>>(
        pointer, output, message_);
  }
  inline void GetRedirectInfosDataView(
      mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectInfos(UserType* output) {
    
    auto* pointer = data_->redirect_infos.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetPostContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostContentType(UserType* output) {
    
    auto* pointer = data_->post_content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalMethod(UserType* output) {
    
    auto* pointer = data_->original_method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool can_load_local_resources() const {
    return data_->can_load_local_resources;
  }
  inline void GetPageStateDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageState(UserType* output) {
    
    auto* pointer = data_->page_state.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  int32_t nav_entry_id() const {
    return data_->nav_entry_id;
  }
  inline void GetSubframeUniqueNamesDataView(
      mojo::MapDataView<mojo::StringDataView, bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframeUniqueNames(UserType* output) {
    
    auto* pointer = data_->subframe_unique_names.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, bool>>(
        pointer, output, message_);
  }
  bool intended_as_new_entry() const {
    return data_->intended_as_new_entry;
  }
  int32_t pending_history_list_index() const {
    return data_->pending_history_list_index;
  }
  int32_t current_history_list_index() const {
    return data_->current_history_list_index;
  }
  int32_t current_history_list_length() const {
    return data_->current_history_list_length;
  }
  bool was_discarded() const {
    return data_->was_discarded;
  }
  bool is_view_source() const {
    return data_->is_view_source;
  }
  bool should_clear_history_list() const {
    return data_->should_clear_history_list;
  }
  inline void GetNavigationTimingDataView(
      NavigationTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationTiming(UserType* output) {
    
    auto* pointer = data_->navigation_timing.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationTimingDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWasActivated(UserType* output) const {
    auto data_value = data_->was_activated;
    return mojo::internal::Deserialize<::blink::mojom::WasActivatedOption>(
        data_value, output);
  }
  ::blink::mojom::WasActivatedOption was_activated() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WasActivatedOption>(data_->was_activated));
  }
  inline void GetNavigationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationToken(UserType* output) {
    
    auto* pointer = data_->navigation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPrefetchedSignedExchangesDataView(
      mojo::ArrayDataView<::blink::mojom::PrefetchedSignedExchangeInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrefetchedSignedExchanges(UserType* output) {
    
    auto* pointer = data_->prefetched_signed_exchanges.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PrefetchedSignedExchangeInfoDataView>>(
        pointer, output, message_);
  }
  bool is_browser_initiated() const {
    return data_->is_browser_initiated;
  }
  bool has_ua_visual_transition() const {
    return data_->has_ua_visual_transition;
  }
  int64_t document_ukm_source_id() const {
    return data_->document_ukm_source_id;
  }
  inline void GetFramePolicyDataView(
      ::blink::mojom::FramePolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFramePolicy(UserType* output) {
    
    auto* pointer = data_->frame_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::FramePolicyDataView>(
        pointer, output, message_);
  }
  inline void GetForceEnabledOriginTrialsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForceEnabledOriginTrials(UserType* output) {
    
    auto* pointer = data_->force_enabled_origin_trials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool origin_agent_cluster() const {
    return data_->origin_agent_cluster;
  }
  bool origin_agent_cluster_left_as_default() const {
    return data_->origin_agent_cluster_left_as_default;
  }
  inline void GetEnabledClientHintsDataView(
      mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledClientHints(UserType* output) {
    
    auto* pointer = data_->enabled_client_hints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        pointer, output, message_);
  }
  bool is_cross_site_cross_browsing_context_group() const {
    return data_->is_cross_site_cross_browsing_context_group;
  }
  bool should_have_sticky_user_activation() const {
    return data_->should_have_sticky_user_activation;
  }
  inline void GetOldPageInfoDataView(
      OldPageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOldPageInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::OldPageInfoDataView, UserType>(),
    "Attempting to read the optional `old_page_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOldPageInfo` instead "
    "of `ReadOldPageInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->old_page_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::OldPageInfoDataView>(
        pointer, output, message_);
  }
  int32_t http_response_code() const {
    return data_->http_response_code;
  }
  inline void GetNavigationApiHistoryEntryArraysDataView(
      ::blink::mojom::NavigationApiHistoryEntryArraysDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiHistoryEntryArrays(UserType* output) {
    
    auto* pointer = data_->navigation_api_history_entry_arrays.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationApiHistoryEntryArraysDataView>(
        pointer, output, message_);
  }
  inline void GetEarlyHintsPreloadedResourcesDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEarlyHintsPreloadedResources(UserType* output) {
    
    auto* pointer = data_->early_hints_preloaded_resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetCommitSentDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommitSent(UserType* output) {
    
    auto* pointer = data_->commit_sent.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetSrcdocValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcdocValue(UserType* output) {
    
    auto* pointer = data_->srcdoc_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_load_data_with_base_url() const {
    return data_->is_load_data_with_base_url;
  }
  bool ancestor_or_self_has_cspee() const {
    return data_->ancestor_or_self_has_cspee;
  }
  inline void GetReducedAcceptLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReducedAcceptLanguage(UserType* output) {
    
    auto* pointer = data_->reduced_accept_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationDeliveryType(UserType* output) const {
    auto data_value = data_->navigation_delivery_type;
    return mojo::internal::Deserialize<::network::mojom::NavigationDeliveryType>(
        data_value, output);
  }
  ::network::mojom::NavigationDeliveryType navigation_delivery_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NavigationDeliveryType>(data_->navigation_delivery_type));
  }
  inline void GetViewTransitionStateDataView(
      ::blink::mojom::ViewTransitionStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ViewTransitionStateDataView, UserType>(),
    "Attempting to read the optional `view_transition_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewTransitionState` instead "
    "of `ReadViewTransitionState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_transition_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionStateDataView>(
        pointer, output, message_);
  }
  inline void GetSoftNavigationHeuristicsTaskIdDataView(
      ::blink::mojom::TaskAttributionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSoftNavigationHeuristicsTaskId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TaskAttributionIdDataView, UserType>(),
    "Attempting to read the optional `soft_navigation_heuristics_task_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSoftNavigationHeuristicsTaskId` instead "
    "of `ReadSoftNavigationHeuristicsTaskId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->soft_navigation_heuristics_task_id.Get();
    return mojo::internal::Deserialize<::blink::mojom::TaskAttributionIdDataView>(
        pointer, output, message_);
  }
  inline void GetModifiedRuntimeFeaturesDataView(
      mojo::MapDataView<::blink::mojom::RuntimeFeature, bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiedRuntimeFeatures(UserType* output) {
    
    auto* pointer = data_->modified_runtime_features.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::RuntimeFeature, bool>>(
        pointer, output, message_);
  }
  inline void GetFencedFramePropertiesDataView(
      ::blink::mojom::FencedFramePropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFencedFrameProperties(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FencedFramePropertiesDataView, UserType>(),
    "Attempting to read the optional `fenced_frame_properties` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFencedFrameProperties` instead "
    "of `ReadFencedFrameProperties if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fenced_frame_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::FencedFramePropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetNotRestoredReasonsDataView(
      ::blink::mojom::BackForwardCacheNotRestoredReasonsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNotRestoredReasons(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::BackForwardCacheNotRestoredReasonsDataView, UserType>(),
    "Attempting to read the optional `not_restored_reasons` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNotRestoredReasons` instead "
    "of `ReadNotRestoredReasons if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->not_restored_reasons.Get();
    return mojo::internal::Deserialize<::blink::mojom::BackForwardCacheNotRestoredReasonsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLoadWithStorageAccess(UserType* output) const {
    auto data_value = data_->load_with_storage_access;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus load_with_storage_access() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->load_with_storage_access));
  }
  inline void GetBrowsingContextGroupInfoDataView(
      ::blink::mojom::BrowsingContextGroupInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowsingContextGroupInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::BrowsingContextGroupInfoDataView, UserType>(),
    "Attempting to read the optional `browsing_context_group_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowsingContextGroupInfo` instead "
    "of `ReadBrowsingContextGroupInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browsing_context_group_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::BrowsingContextGroupInfoDataView>(
        pointer, output, message_);
  }
  inline void GetLcppHintDataView(
      ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLcppHint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView, UserType>(),
    "Attempting to read the optional `lcpp_hint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLcppHint` instead "
    "of `ReadLcppHint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->lcpp_hint.Get();
    return mojo::internal::Deserialize<::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView>(
        pointer, output, message_);
  }
  inline void GetContentSettingsDataView(
      ::blink::mojom::RendererContentSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSettings(UserType* output) {
    
    auto* pointer = data_->content_settings.Get();
    return mojo::internal::Deserialize<::blink::mojom::RendererContentSettingsDataView>(
        pointer, output, message_);
  }
  inline void GetCookieDeprecationLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieDeprecationLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cookie_deprecation_label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieDeprecationLabel` instead "
    "of `ReadCookieDeprecationLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_deprecation_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<uint64_t> visited_link_salt() const {

    return data_->visited_link_salt_$flag
        ? std::make_optional(data_->visited_link_salt_$value)
        : std::nullopt;
  }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceId` instead "
    "of `ReadLocalSurfaceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  inline void GetInitialPermissionStatusesDataView(
      mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialPermissionStatuses(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>, UserType>(),
    "Attempting to read the optional `initial_permission_statuses` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialPermissionStatuses` instead "
    "of `ReadInitialPermissionStatuses if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_permission_statuses.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>>(
        pointer, output, message_);
  }
  bool should_skip_screenshot() const {
    return data_->should_skip_screenshot;
  }
  bool force_new_document_sequence_number() const {
    return data_->force_new_document_sequence_number;
  }
 private:
  internal::CommitNavigationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageSwapEventParamsDataView {
 public:
  PageSwapEventParamsDataView() = default;

  PageSwapEventParamsDataView(
      internal::PageSwapEventParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPageStateDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageState(UserType* output) {
    
    auto* pointer = data_->page_state.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationType(UserType* output) const {
    auto data_value = data_->navigation_type;
    return mojo::internal::Deserialize<::blink::mojom::NavigationTypeForNavigationApi>(
        data_value, output);
  }
  NavigationTypeForNavigationApi navigation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationTypeForNavigationApi>(data_->navigation_type));
  }
 private:
  internal::PageSwapEventParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::NavigationType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::NavigationType> {};

template <>
struct hash<::blink::mojom::NavigationTypeForNavigationApi>
    : public mojo::internal::EnumHashImpl<::blink::mojom::NavigationTypeForNavigationApi> {};

template <>
struct hash<::blink::mojom::ForceHistoryPush>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ForceHistoryPush> {};

template <>
struct hash<::blink::mojom::ParentResourceTimingAccess>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ParentResourceTimingAccess> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NavigationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::NavigationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::NavigationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NavigationTypeForNavigationApi, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::NavigationTypeForNavigationApi, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::NavigationTypeForNavigationApi>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ForceHistoryPush, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ForceHistoryPush, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ForceHistoryPush>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ParentResourceTimingAccess, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ParentResourceTimingAccess, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ParentResourceTimingAccess>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BeginNavigationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BeginNavigationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BeginNavigationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::initiator_frame_token(input)) in_initiator_frame_token = Traits::initiator_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_frame_token)::BaseType> initiator_frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
        in_initiator_frame_token, initiator_frame_token_fragment);
    fragment->initiator_frame_token.Set(
        initiator_frame_token_fragment.is_null() ? nullptr : initiator_frame_token_fragment.data());
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_headers, headers_fragment);
    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in BeginNavigationParams struct");
    fragment->load_flags = Traits::load_flags(input);
    fragment->skip_service_worker = Traits::skip_service_worker(input);
    mojo::internal::Serialize<::blink::mojom::RequestContextType>(
        Traits::request_context_type(input), &fragment->request_context_type);
    mojo::internal::Serialize<::blink::mojom::MixedContentContextType>(
        Traits::mixed_content_context_type(input), &fragment->mixed_content_context_type);
    fragment->is_form_submission = Traits::is_form_submission(input);
    fragment->was_initiated_by_link_click = Traits::was_initiated_by_link_click(input);
    mojo::internal::Serialize<::blink::mojom::ForceHistoryPush>(
        Traits::force_history_push(input), &fragment->force_history_push);
    decltype(Traits::searchable_form_url(input)) in_searchable_form_url = Traits::searchable_form_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->searchable_form_url)::BaseType> searchable_form_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_searchable_form_url, searchable_form_url_fragment);
    fragment->searchable_form_url.Set(
        searchable_form_url_fragment.is_null() ? nullptr : searchable_form_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->searchable_form_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null searchable_form_url in BeginNavigationParams struct");
    decltype(Traits::searchable_form_encoding(input)) in_searchable_form_encoding = Traits::searchable_form_encoding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->searchable_form_encoding)::BaseType> searchable_form_encoding_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_searchable_form_encoding, searchable_form_encoding_fragment);
    fragment->searchable_form_encoding.Set(
        searchable_form_encoding_fragment.is_null() ? nullptr : searchable_form_encoding_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->searchable_form_encoding.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null searchable_form_encoding in BeginNavigationParams struct");
    decltype(Traits::client_side_redirect_url(input)) in_client_side_redirect_url = Traits::client_side_redirect_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_side_redirect_url)::BaseType> client_side_redirect_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_client_side_redirect_url, client_side_redirect_url_fragment);
    fragment->client_side_redirect_url.Set(
        client_side_redirect_url_fragment.is_null() ? nullptr : client_side_redirect_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->client_side_redirect_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null client_side_redirect_url in BeginNavigationParams struct");
    decltype(Traits::devtools_initiator(input)) in_devtools_initiator = Traits::devtools_initiator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_initiator)::BaseType> devtools_initiator_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
        in_devtools_initiator, devtools_initiator_fragment);
    fragment->devtools_initiator.Set(
        devtools_initiator_fragment.is_null() ? nullptr : devtools_initiator_fragment.data());
    decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView>(
        in_trust_token_params, trust_token_params_fragment);
    fragment->trust_token_params.Set(
        trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());
    decltype(Traits::impression(input)) in_impression = Traits::impression(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->impression)::BaseType> impression_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ImpressionDataView>(
        in_impression, impression_fragment);
    fragment->impression.Set(
        impression_fragment.is_null() ? nullptr : impression_fragment.data());
    decltype(Traits::before_unload_start(input)) in_before_unload_start = Traits::before_unload_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->before_unload_start)::BaseType> before_unload_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_before_unload_start, before_unload_start_fragment);
    fragment->before_unload_start.Set(
        before_unload_start_fragment.is_null() ? nullptr : before_unload_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->before_unload_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null before_unload_start in BeginNavigationParams struct");
    decltype(Traits::before_unload_end(input)) in_before_unload_end = Traits::before_unload_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->before_unload_end)::BaseType> before_unload_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_before_unload_end, before_unload_end_fragment);
    fragment->before_unload_end.Set(
        before_unload_end_fragment.is_null() ? nullptr : before_unload_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->before_unload_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null before_unload_end in BeginNavigationParams struct");
    mojo::internal::Serialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        Traits::initiator_activation_and_ad_status(input), &fragment->initiator_activation_and_ad_status);
    fragment->is_container_initiated = Traits::is_container_initiated(input);
    mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
        Traits::storage_access_api_status(input), &fragment->storage_access_api_status);
    fragment->has_rel_opener = Traits::has_rel_opener(input);
  }

  static bool Deserialize(::blink::mojom::internal::BeginNavigationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BeginNavigationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CommonNavigationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CommonNavigationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CommonNavigationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in CommonNavigationParams struct");
    decltype(Traits::initiator_origin(input)) in_initiator_origin = Traits::initiator_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_origin)::BaseType> initiator_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_initiator_origin, initiator_origin_fragment);
    fragment->initiator_origin.Set(
        initiator_origin_fragment.is_null() ? nullptr : initiator_origin_fragment.data());
    decltype(Traits::initiator_base_url(input)) in_initiator_base_url = Traits::initiator_base_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_base_url)::BaseType> initiator_base_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_initiator_base_url, initiator_base_url_fragment);
    fragment->initiator_base_url.Set(
        initiator_base_url_fragment.is_null() ? nullptr : initiator_base_url_fragment.data());
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, referrer_fragment);
    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in CommonNavigationParams struct");
    fragment->transition = Traits::transition(input);
    mojo::internal::Serialize<::blink::mojom::NavigationType>(
        Traits::navigation_type(input), &fragment->navigation_type);
    decltype(Traits::download_policy(input)) in_download_policy = Traits::download_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->download_policy)::BaseType> download_policy_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        in_download_policy, download_policy_fragment);
    fragment->download_policy.Set(
        download_policy_fragment.is_null() ? nullptr : download_policy_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->download_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null download_policy in CommonNavigationParams struct");
    fragment->should_replace_current_entry = Traits::should_replace_current_entry(input);
    decltype(Traits::base_url_for_data_url(input)) in_base_url_for_data_url = Traits::base_url_for_data_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->base_url_for_data_url)::BaseType> base_url_for_data_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_base_url_for_data_url, base_url_for_data_url_fragment);
    fragment->base_url_for_data_url.Set(
        base_url_for_data_url_fragment.is_null() ? nullptr : base_url_for_data_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->base_url_for_data_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null base_url_for_data_url in CommonNavigationParams struct");
    decltype(Traits::navigation_start(input)) in_navigation_start = Traits::navigation_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_start)::BaseType> navigation_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_navigation_start, navigation_start_fragment);
    fragment->navigation_start.Set(
        navigation_start_fragment.is_null() ? nullptr : navigation_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->navigation_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_start in CommonNavigationParams struct");
    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method, method_fragment);
    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in CommonNavigationParams struct");
    decltype(Traits::post_data(input)) in_post_data = Traits::post_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->post_data)::BaseType> post_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::URLRequestBodyDataView>(
        in_post_data, post_data_fragment);
    fragment->post_data.Set(
        post_data_fragment.is_null() ? nullptr : post_data_fragment.data());
    decltype(Traits::source_location(input)) in_source_location = Traits::source_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_location)::BaseType> source_location_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
        in_source_location, source_location_fragment);
    fragment->source_location.Set(
        source_location_fragment.is_null() ? nullptr : source_location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->source_location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_location in CommonNavigationParams struct");
    fragment->started_from_context_menu = Traits::started_from_context_menu(input);
    fragment->has_user_gesture = Traits::has_user_gesture(input);
    fragment->text_fragment_token = Traits::text_fragment_token(input);
    mojo::internal::Serialize<::network::mojom::CSPDisposition>(
        Traits::should_check_main_world_csp(input), &fragment->should_check_main_world_csp);
    decltype(Traits::initiator_origin_trial_features(input)) in_initiator_origin_trial_features = Traits::initiator_origin_trial_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_origin_trial_features)::BaseType>
        initiator_origin_trial_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& initiator_origin_trial_features_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_initiator_origin_trial_features, initiator_origin_trial_features_fragment, &initiator_origin_trial_features_validate_params);
    fragment->initiator_origin_trial_features.Set(
        initiator_origin_trial_features_fragment.is_null() ? nullptr : initiator_origin_trial_features_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->initiator_origin_trial_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initiator_origin_trial_features in CommonNavigationParams struct");
    decltype(Traits::href_translate(input)) in_href_translate = Traits::href_translate(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->href_translate)::BaseType> href_translate_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_href_translate, href_translate_fragment);
    fragment->href_translate.Set(
        href_translate_fragment.is_null() ? nullptr : href_translate_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->href_translate.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null href_translate in CommonNavigationParams struct");
    fragment->is_history_navigation_in_new_child_frame = Traits::is_history_navigation_in_new_child_frame(input);
    decltype(Traits::input_start(input)) in_input_start = Traits::input_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_start)::BaseType> input_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_input_start, input_start_fragment);
    fragment->input_start.Set(
        input_start_fragment.is_null() ? nullptr : input_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->input_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_start in CommonNavigationParams struct");
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::request_destination(input), &fragment->request_destination);
  }

  static bool Deserialize(::blink::mojom::internal::CommonNavigationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CommonNavigationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NavigationTimingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NavigationTimingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NavigationTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::redirect_start(input)) in_redirect_start = Traits::redirect_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->redirect_start)::BaseType> redirect_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_redirect_start, redirect_start_fragment);
    fragment->redirect_start.Set(
        redirect_start_fragment.is_null() ? nullptr : redirect_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->redirect_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_start in NavigationTiming struct");
    decltype(Traits::redirect_end(input)) in_redirect_end = Traits::redirect_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->redirect_end)::BaseType> redirect_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_redirect_end, redirect_end_fragment);
    fragment->redirect_end.Set(
        redirect_end_fragment.is_null() ? nullptr : redirect_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->redirect_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_end in NavigationTiming struct");
    decltype(Traits::fetch_start(input)) in_fetch_start = Traits::fetch_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetch_start)::BaseType> fetch_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_fetch_start, fetch_start_fragment);
    fragment->fetch_start.Set(
        fetch_start_fragment.is_null() ? nullptr : fetch_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fetch_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fetch_start in NavigationTiming struct");
    mojo::internal::Serialize<::blink::mojom::SystemEntropy>(
        Traits::system_entropy_at_navigation_start(input), &fragment->system_entropy_at_navigation_start);
    mojo::internal::Serialize<::blink::mojom::ParentResourceTimingAccess>(
        Traits::parent_resource_timing_access(input), &fragment->parent_resource_timing_access);
  }

  static bool Deserialize(::blink::mojom::internal::NavigationTiming_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NavigationTimingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::OldPageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::OldPageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::OldPageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_token_for_old_main_frame(input)) in_frame_token_for_old_main_frame = Traits::frame_token_for_old_main_frame(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_token_for_old_main_frame)::BaseType> frame_token_for_old_main_frame_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
        in_frame_token_for_old_main_frame, frame_token_for_old_main_frame_fragment);
    fragment->frame_token_for_old_main_frame.Set(
        frame_token_for_old_main_frame_fragment.is_null() ? nullptr : frame_token_for_old_main_frame_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_token_for_old_main_frame.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_token_for_old_main_frame in OldPageInfo struct");
    decltype(Traits::new_lifecycle_state_for_old_page(input)) in_new_lifecycle_state_for_old_page = Traits::new_lifecycle_state_for_old_page(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_lifecycle_state_for_old_page)::BaseType> new_lifecycle_state_for_old_page_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PageLifecycleStateDataView>(
        in_new_lifecycle_state_for_old_page, new_lifecycle_state_for_old_page_fragment);
    fragment->new_lifecycle_state_for_old_page.Set(
        new_lifecycle_state_for_old_page_fragment.is_null() ? nullptr : new_lifecycle_state_for_old_page_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->new_lifecycle_state_for_old_page.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_lifecycle_state_for_old_page in OldPageInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::OldPageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::OldPageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CommitNavigationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CommitNavigationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CommitNavigationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin_to_commit(input)) in_origin_to_commit = Traits::origin_to_commit(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin_to_commit)::BaseType> origin_to_commit_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin_to_commit, origin_to_commit_fragment);
    fragment->origin_to_commit.Set(
        origin_to_commit_fragment.is_null() ? nullptr : origin_to_commit_fragment.data());
    decltype(Traits::storage_key(input)) in_storage_key = Traits::storage_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->storage_key)::BaseType> storage_key_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
        in_storage_key, storage_key_fragment);
    fragment->storage_key.Set(
        storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->storage_key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null storage_key in CommitNavigationParams struct");
    fragment->is_overriding_user_agent = Traits::is_overriding_user_agent(input);
    decltype(Traits::redirects(input)) in_redirects = Traits::redirects(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->redirects)::BaseType>
        redirects_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& redirects_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_redirects, redirects_fragment, &redirects_validate_params);
    fragment->redirects.Set(
        redirects_fragment.is_null() ? nullptr : redirects_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->redirects.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirects in CommitNavigationParams struct");
    decltype(Traits::redirect_response(input)) in_redirect_response = Traits::redirect_response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->redirect_response)::BaseType>
        redirect_response_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& redirect_response_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>>(
        in_redirect_response, redirect_response_fragment, &redirect_response_validate_params);
    fragment->redirect_response.Set(
        redirect_response_fragment.is_null() ? nullptr : redirect_response_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->redirect_response.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_response in CommitNavigationParams struct");
    decltype(Traits::redirect_infos(input)) in_redirect_infos = Traits::redirect_infos(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->redirect_infos)::BaseType>
        redirect_infos_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& redirect_infos_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>>(
        in_redirect_infos, redirect_infos_fragment, &redirect_infos_validate_params);
    fragment->redirect_infos.Set(
        redirect_infos_fragment.is_null() ? nullptr : redirect_infos_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->redirect_infos.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_infos in CommitNavigationParams struct");
    decltype(Traits::post_content_type(input)) in_post_content_type = Traits::post_content_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->post_content_type)::BaseType> post_content_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_post_content_type, post_content_type_fragment);
    fragment->post_content_type.Set(
        post_content_type_fragment.is_null() ? nullptr : post_content_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->post_content_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null post_content_type in CommitNavigationParams struct");
    decltype(Traits::original_url(input)) in_original_url = Traits::original_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->original_url)::BaseType> original_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_original_url, original_url_fragment);
    fragment->original_url.Set(
        original_url_fragment.is_null() ? nullptr : original_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->original_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_url in CommitNavigationParams struct");
    decltype(Traits::original_method(input)) in_original_method = Traits::original_method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->original_method)::BaseType> original_method_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_original_method, original_method_fragment);
    fragment->original_method.Set(
        original_method_fragment.is_null() ? nullptr : original_method_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->original_method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_method in CommitNavigationParams struct");
    fragment->can_load_local_resources = Traits::can_load_local_resources(input);
    decltype(Traits::page_state(input)) in_page_state = Traits::page_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_state)::BaseType> page_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_page_state, page_state_fragment);
    fragment->page_state.Set(
        page_state_fragment.is_null() ? nullptr : page_state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->page_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_state in CommitNavigationParams struct");
    fragment->nav_entry_id = Traits::nav_entry_id(input);
    decltype(Traits::subframe_unique_names(input)) in_subframe_unique_names = Traits::subframe_unique_names(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subframe_unique_names)::BaseType>
        subframe_unique_names_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& subframe_unique_names_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, bool>>(
        in_subframe_unique_names, subframe_unique_names_fragment, &subframe_unique_names_validate_params);
    fragment->subframe_unique_names.Set(
        subframe_unique_names_fragment.is_null() ? nullptr : subframe_unique_names_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->subframe_unique_names.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframe_unique_names in CommitNavigationParams struct");
    fragment->intended_as_new_entry = Traits::intended_as_new_entry(input);
    fragment->pending_history_list_index = Traits::pending_history_list_index(input);
    fragment->current_history_list_index = Traits::current_history_list_index(input);
    fragment->current_history_list_length = Traits::current_history_list_length(input);
    fragment->was_discarded = Traits::was_discarded(input);
    fragment->is_view_source = Traits::is_view_source(input);
    fragment->should_clear_history_list = Traits::should_clear_history_list(input);
    decltype(Traits::navigation_timing(input)) in_navigation_timing = Traits::navigation_timing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_timing)::BaseType> navigation_timing_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::NavigationTimingDataView>(
        in_navigation_timing, navigation_timing_fragment);
    fragment->navigation_timing.Set(
        navigation_timing_fragment.is_null() ? nullptr : navigation_timing_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->navigation_timing.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_timing in CommitNavigationParams struct");
    mojo::internal::Serialize<::blink::mojom::WasActivatedOption>(
        Traits::was_activated(input), &fragment->was_activated);
    decltype(Traits::navigation_token(input)) in_navigation_token = Traits::navigation_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_token)::BaseType> navigation_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_navigation_token, navigation_token_fragment);
    fragment->navigation_token.Set(
        navigation_token_fragment.is_null() ? nullptr : navigation_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->navigation_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_token in CommitNavigationParams struct");
    decltype(Traits::prefetched_signed_exchanges(input)) in_prefetched_signed_exchanges = Traits::prefetched_signed_exchanges(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prefetched_signed_exchanges)::BaseType>
        prefetched_signed_exchanges_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& prefetched_signed_exchanges_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PrefetchedSignedExchangeInfoDataView>>(
        in_prefetched_signed_exchanges, prefetched_signed_exchanges_fragment, &prefetched_signed_exchanges_validate_params);
    fragment->prefetched_signed_exchanges.Set(
        prefetched_signed_exchanges_fragment.is_null() ? nullptr : prefetched_signed_exchanges_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->prefetched_signed_exchanges.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prefetched_signed_exchanges in CommitNavigationParams struct");
    fragment->is_browser_initiated = Traits::is_browser_initiated(input);
    fragment->has_ua_visual_transition = Traits::has_ua_visual_transition(input);
    fragment->document_ukm_source_id = Traits::document_ukm_source_id(input);
    decltype(Traits::frame_policy(input)) in_frame_policy = Traits::frame_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_policy)::BaseType> frame_policy_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
        in_frame_policy, frame_policy_fragment);
    fragment->frame_policy.Set(
        frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_policy in CommitNavigationParams struct");
    decltype(Traits::force_enabled_origin_trials(input)) in_force_enabled_origin_trials = Traits::force_enabled_origin_trials(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->force_enabled_origin_trials)::BaseType>
        force_enabled_origin_trials_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& force_enabled_origin_trials_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_force_enabled_origin_trials, force_enabled_origin_trials_fragment, &force_enabled_origin_trials_validate_params);
    fragment->force_enabled_origin_trials.Set(
        force_enabled_origin_trials_fragment.is_null() ? nullptr : force_enabled_origin_trials_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->force_enabled_origin_trials.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null force_enabled_origin_trials in CommitNavigationParams struct");
    fragment->origin_agent_cluster = Traits::origin_agent_cluster(input);
    fragment->origin_agent_cluster_left_as_default = Traits::origin_agent_cluster_left_as_default(input);
    decltype(Traits::enabled_client_hints(input)) in_enabled_client_hints = Traits::enabled_client_hints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enabled_client_hints)::BaseType>
        enabled_client_hints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& enabled_client_hints_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        in_enabled_client_hints, enabled_client_hints_fragment, &enabled_client_hints_validate_params);
    fragment->enabled_client_hints.Set(
        enabled_client_hints_fragment.is_null() ? nullptr : enabled_client_hints_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->enabled_client_hints.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enabled_client_hints in CommitNavigationParams struct");
    fragment->is_cross_site_cross_browsing_context_group = Traits::is_cross_site_cross_browsing_context_group(input);
    fragment->should_have_sticky_user_activation = Traits::should_have_sticky_user_activation(input);
    decltype(Traits::old_page_info(input)) in_old_page_info = Traits::old_page_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->old_page_info)::BaseType> old_page_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::OldPageInfoDataView>(
        in_old_page_info, old_page_info_fragment);
    fragment->old_page_info.Set(
        old_page_info_fragment.is_null() ? nullptr : old_page_info_fragment.data());
    fragment->http_response_code = Traits::http_response_code(input);
    decltype(Traits::navigation_api_history_entry_arrays(input)) in_navigation_api_history_entry_arrays = Traits::navigation_api_history_entry_arrays(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_api_history_entry_arrays)::BaseType> navigation_api_history_entry_arrays_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::NavigationApiHistoryEntryArraysDataView>(
        in_navigation_api_history_entry_arrays, navigation_api_history_entry_arrays_fragment);
    fragment->navigation_api_history_entry_arrays.Set(
        navigation_api_history_entry_arrays_fragment.is_null() ? nullptr : navigation_api_history_entry_arrays_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->navigation_api_history_entry_arrays.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_api_history_entry_arrays in CommitNavigationParams struct");
    decltype(Traits::early_hints_preloaded_resources(input)) in_early_hints_preloaded_resources = Traits::early_hints_preloaded_resources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->early_hints_preloaded_resources)::BaseType>
        early_hints_preloaded_resources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& early_hints_preloaded_resources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_early_hints_preloaded_resources, early_hints_preloaded_resources_fragment, &early_hints_preloaded_resources_validate_params);
    fragment->early_hints_preloaded_resources.Set(
        early_hints_preloaded_resources_fragment.is_null() ? nullptr : early_hints_preloaded_resources_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->early_hints_preloaded_resources.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null early_hints_preloaded_resources in CommitNavigationParams struct");
    decltype(Traits::commit_sent(input)) in_commit_sent = Traits::commit_sent(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->commit_sent)::BaseType> commit_sent_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_commit_sent, commit_sent_fragment);
    fragment->commit_sent.Set(
        commit_sent_fragment.is_null() ? nullptr : commit_sent_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->commit_sent.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null commit_sent in CommitNavigationParams struct");
    decltype(Traits::srcdoc_value(input)) in_srcdoc_value = Traits::srcdoc_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->srcdoc_value)::BaseType> srcdoc_value_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_srcdoc_value, srcdoc_value_fragment);
    fragment->srcdoc_value.Set(
        srcdoc_value_fragment.is_null() ? nullptr : srcdoc_value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->srcdoc_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null srcdoc_value in CommitNavigationParams struct");
    fragment->is_load_data_with_base_url = Traits::is_load_data_with_base_url(input);
    fragment->ancestor_or_self_has_cspee = Traits::ancestor_or_self_has_cspee(input);
    decltype(Traits::reduced_accept_language(input)) in_reduced_accept_language = Traits::reduced_accept_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reduced_accept_language)::BaseType> reduced_accept_language_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_reduced_accept_language, reduced_accept_language_fragment);
    fragment->reduced_accept_language.Set(
        reduced_accept_language_fragment.is_null() ? nullptr : reduced_accept_language_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->reduced_accept_language.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduced_accept_language in CommitNavigationParams struct");
    mojo::internal::Serialize<::network::mojom::NavigationDeliveryType>(
        Traits::navigation_delivery_type(input), &fragment->navigation_delivery_type);
    decltype(Traits::view_transition_state(input)) in_view_transition_state = Traits::view_transition_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_transition_state)::BaseType> view_transition_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ViewTransitionStateDataView>(
        in_view_transition_state, view_transition_state_fragment);
    fragment->view_transition_state.Set(
        view_transition_state_fragment.is_null() ? nullptr : view_transition_state_fragment.data());
    decltype(Traits::soft_navigation_heuristics_task_id(input)) in_soft_navigation_heuristics_task_id = Traits::soft_navigation_heuristics_task_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->soft_navigation_heuristics_task_id)::BaseType> soft_navigation_heuristics_task_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::TaskAttributionIdDataView>(
        in_soft_navigation_heuristics_task_id, soft_navigation_heuristics_task_id_fragment);
    fragment->soft_navigation_heuristics_task_id.Set(
        soft_navigation_heuristics_task_id_fragment.is_null() ? nullptr : soft_navigation_heuristics_task_id_fragment.data());
    decltype(Traits::modified_runtime_features(input)) in_modified_runtime_features = Traits::modified_runtime_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->modified_runtime_features)::BaseType>
        modified_runtime_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& modified_runtime_features_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::RuntimeFeature_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::RuntimeFeature, bool>>(
        in_modified_runtime_features, modified_runtime_features_fragment, &modified_runtime_features_validate_params);
    fragment->modified_runtime_features.Set(
        modified_runtime_features_fragment.is_null() ? nullptr : modified_runtime_features_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->modified_runtime_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null modified_runtime_features in CommitNavigationParams struct");
    decltype(Traits::fenced_frame_properties(input)) in_fenced_frame_properties = Traits::fenced_frame_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fenced_frame_properties)::BaseType> fenced_frame_properties_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FencedFramePropertiesDataView>(
        in_fenced_frame_properties, fenced_frame_properties_fragment);
    fragment->fenced_frame_properties.Set(
        fenced_frame_properties_fragment.is_null() ? nullptr : fenced_frame_properties_fragment.data());
    decltype(Traits::not_restored_reasons(input)) in_not_restored_reasons = Traits::not_restored_reasons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->not_restored_reasons)::BaseType> not_restored_reasons_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::BackForwardCacheNotRestoredReasonsDataView>(
        in_not_restored_reasons, not_restored_reasons_fragment);
    fragment->not_restored_reasons.Set(
        not_restored_reasons_fragment.is_null() ? nullptr : not_restored_reasons_fragment.data());
    mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
        Traits::load_with_storage_access(input), &fragment->load_with_storage_access);
    decltype(Traits::browsing_context_group_info(input)) in_browsing_context_group_info = Traits::browsing_context_group_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browsing_context_group_info)::BaseType> browsing_context_group_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::BrowsingContextGroupInfoDataView>(
        in_browsing_context_group_info, browsing_context_group_info_fragment);
    fragment->browsing_context_group_info.Set(
        browsing_context_group_info_fragment.is_null() ? nullptr : browsing_context_group_info_fragment.data());
    decltype(Traits::lcpp_hint(input)) in_lcpp_hint = Traits::lcpp_hint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lcpp_hint)::BaseType> lcpp_hint_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView>(
        in_lcpp_hint, lcpp_hint_fragment);
    fragment->lcpp_hint.Set(
        lcpp_hint_fragment.is_null() ? nullptr : lcpp_hint_fragment.data());
    decltype(Traits::content_settings(input)) in_content_settings = Traits::content_settings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_settings)::BaseType> content_settings_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::RendererContentSettingsDataView>(
        in_content_settings, content_settings_fragment);
    fragment->content_settings.Set(
        content_settings_fragment.is_null() ? nullptr : content_settings_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content_settings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_settings in CommitNavigationParams struct");
    decltype(Traits::cookie_deprecation_label(input)) in_cookie_deprecation_label = Traits::cookie_deprecation_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_deprecation_label)::BaseType> cookie_deprecation_label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_cookie_deprecation_label, cookie_deprecation_label_fragment);
    fragment->cookie_deprecation_label.Set(
        cookie_deprecation_label_fragment.is_null() ? nullptr : cookie_deprecation_label_fragment.data());
    fragment->visited_link_salt_$flag = Traits::visited_link_salt(input).has_value();
    if (Traits::visited_link_salt(input).has_value()) {
      fragment->visited_link_salt_$value = Traits::visited_link_salt(input).value();
    }
    decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_surface_id)::BaseType> local_surface_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
        in_local_surface_id, local_surface_id_fragment);
    fragment->local_surface_id.Set(
        local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
    decltype(Traits::initial_permission_statuses(input)) in_initial_permission_statuses = Traits::initial_permission_statuses(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_permission_statuses)::BaseType>
        initial_permission_statuses_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& initial_permission_statuses_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::PermissionName_Data::Validate>(), *&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::PermissionStatus_Data::Validate>()>();
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>>(
        in_initial_permission_statuses, initial_permission_statuses_fragment, &initial_permission_statuses_validate_params);
    fragment->initial_permission_statuses.Set(
        initial_permission_statuses_fragment.is_null() ? nullptr : initial_permission_statuses_fragment.data());
    fragment->should_skip_screenshot = Traits::should_skip_screenshot(input);
    fragment->force_new_document_sequence_number = Traits::force_new_document_sequence_number(input);
  }

  static bool Deserialize(::blink::mojom::internal::CommitNavigationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CommitNavigationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PageSwapEventParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageSwapEventParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PageSwapEventParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PageSwapEventParams struct");
    decltype(Traits::page_state(input)) in_page_state = Traits::page_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_state)::BaseType> page_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_page_state, page_state_fragment);
    fragment->page_state.Set(
        page_state_fragment.is_null() ? nullptr : page_state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->page_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_state in PageSwapEventParams struct");
    mojo::internal::Serialize<::blink::mojom::NavigationTypeForNavigationApi>(
        Traits::navigation_type(input), &fragment->navigation_type);
  }

  static bool Deserialize(::blink::mojom::internal::PageSwapEventParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PageSwapEventParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void BeginNavigationParamsDataView::GetInitiatorFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->initiator_frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetHeadersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetSearchableFormUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->searchable_form_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetSearchableFormEncodingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->searchable_form_encoding.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetClientSideRedirectUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->client_side_redirect_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetDevtoolsInitiatorDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->devtools_initiator.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetTrustTokenParamsDataView(
    ::network::mojom::TrustTokenParamsDataView* output) {
  auto pointer = data_->trust_token_params.Get();
  *output = ::network::mojom::TrustTokenParamsDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetImpressionDataView(
    ::blink::mojom::ImpressionDataView* output) {
  auto pointer = data_->impression.Get();
  *output = ::blink::mojom::ImpressionDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetBeforeUnloadStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->before_unload_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void BeginNavigationParamsDataView::GetBeforeUnloadEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->before_unload_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void CommonNavigationParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetInitiatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->initiator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetInitiatorBaseUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->initiator_base_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetDownloadPolicyDataView(
    ::blink::mojom::NavigationDownloadPolicyDataView* output) {
  auto pointer = data_->download_policy.Get();
  *output = ::blink::mojom::NavigationDownloadPolicyDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetBaseUrlForDataUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->base_url_for_data_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetNavigationStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->navigation_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetPostDataDataView(
    ::network::mojom::URLRequestBodyDataView* output) {
  auto pointer = data_->post_data.Get();
  *output = ::network::mojom::URLRequestBodyDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetSourceLocationDataView(
    ::network::mojom::SourceLocationDataView* output) {
  auto pointer = data_->source_location.Get();
  *output = ::network::mojom::SourceLocationDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetInitiatorOriginTrialFeaturesDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->initiator_origin_trial_features.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetHrefTranslateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->href_translate.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CommonNavigationParamsDataView::GetInputStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->input_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void NavigationTimingDataView::GetRedirectStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->redirect_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void NavigationTimingDataView::GetRedirectEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->redirect_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void NavigationTimingDataView::GetFetchStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->fetch_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void OldPageInfoDataView::GetFrameTokenForOldMainFrameDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->frame_token_for_old_main_frame.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void OldPageInfoDataView::GetNewLifecycleStateForOldPageDataView(
    ::blink::mojom::PageLifecycleStateDataView* output) {
  auto pointer = data_->new_lifecycle_state_for_old_page.Get();
  *output = ::blink::mojom::PageLifecycleStateDataView(pointer, message_);
}


inline void CommitNavigationParamsDataView::GetOriginToCommitDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin_to_commit.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetStorageKeyDataView(
    ::blink::mojom::StorageKeyDataView* output) {
  auto pointer = data_->storage_key.Get();
  *output = ::blink::mojom::StorageKeyDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetRedirectsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->redirects.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetRedirectResponseDataView(
    mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>* output) {
  auto pointer = data_->redirect_response.Get();
  *output = mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetRedirectInfosDataView(
    mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>* output) {
  auto pointer = data_->redirect_infos.Get();
  *output = mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetPostContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->post_content_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetOriginalUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->original_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetOriginalMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->original_method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetPageStateDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->page_state.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetSubframeUniqueNamesDataView(
    mojo::MapDataView<mojo::StringDataView, bool>* output) {
  auto pointer = data_->subframe_unique_names.Get();
  *output = mojo::MapDataView<mojo::StringDataView, bool>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetNavigationTimingDataView(
    NavigationTimingDataView* output) {
  auto pointer = data_->navigation_timing.Get();
  *output = NavigationTimingDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetNavigationTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->navigation_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetPrefetchedSignedExchangesDataView(
    mojo::ArrayDataView<::blink::mojom::PrefetchedSignedExchangeInfoDataView>* output) {
  auto pointer = data_->prefetched_signed_exchanges.Get();
  *output = mojo::ArrayDataView<::blink::mojom::PrefetchedSignedExchangeInfoDataView>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetFramePolicyDataView(
    ::blink::mojom::FramePolicyDataView* output) {
  auto pointer = data_->frame_policy.Get();
  *output = ::blink::mojom::FramePolicyDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetForceEnabledOriginTrialsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->force_enabled_origin_trials.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetEnabledClientHintsDataView(
    mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output) {
  auto pointer = data_->enabled_client_hints.Get();
  *output = mojo::ArrayDataView<::network::mojom::WebClientHintsType>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetOldPageInfoDataView(
    OldPageInfoDataView* output) {
  auto pointer = data_->old_page_info.Get();
  *output = OldPageInfoDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetNavigationApiHistoryEntryArraysDataView(
    ::blink::mojom::NavigationApiHistoryEntryArraysDataView* output) {
  auto pointer = data_->navigation_api_history_entry_arrays.Get();
  *output = ::blink::mojom::NavigationApiHistoryEntryArraysDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetEarlyHintsPreloadedResourcesDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->early_hints_preloaded_resources.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetCommitSentDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->commit_sent.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetSrcdocValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->srcdoc_value.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetReducedAcceptLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reduced_accept_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetViewTransitionStateDataView(
    ::blink::mojom::ViewTransitionStateDataView* output) {
  auto pointer = data_->view_transition_state.Get();
  *output = ::blink::mojom::ViewTransitionStateDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetSoftNavigationHeuristicsTaskIdDataView(
    ::blink::mojom::TaskAttributionIdDataView* output) {
  auto pointer = data_->soft_navigation_heuristics_task_id.Get();
  *output = ::blink::mojom::TaskAttributionIdDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetModifiedRuntimeFeaturesDataView(
    mojo::MapDataView<::blink::mojom::RuntimeFeature, bool>* output) {
  auto pointer = data_->modified_runtime_features.Get();
  *output = mojo::MapDataView<::blink::mojom::RuntimeFeature, bool>(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetFencedFramePropertiesDataView(
    ::blink::mojom::FencedFramePropertiesDataView* output) {
  auto pointer = data_->fenced_frame_properties.Get();
  *output = ::blink::mojom::FencedFramePropertiesDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetNotRestoredReasonsDataView(
    ::blink::mojom::BackForwardCacheNotRestoredReasonsDataView* output) {
  auto pointer = data_->not_restored_reasons.Get();
  *output = ::blink::mojom::BackForwardCacheNotRestoredReasonsDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetBrowsingContextGroupInfoDataView(
    ::blink::mojom::BrowsingContextGroupInfoDataView* output) {
  auto pointer = data_->browsing_context_group_info.Get();
  *output = ::blink::mojom::BrowsingContextGroupInfoDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetLcppHintDataView(
    ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView* output) {
  auto pointer = data_->lcpp_hint.Get();
  *output = ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetContentSettingsDataView(
    ::blink::mojom::RendererContentSettingsDataView* output) {
  auto pointer = data_->content_settings.Get();
  *output = ::blink::mojom::RendererContentSettingsDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetCookieDeprecationLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cookie_deprecation_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}
inline void CommitNavigationParamsDataView::GetInitialPermissionStatusesDataView(
    mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>* output) {
  auto pointer = data_->initial_permission_statuses.Get();
  *output = mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>(pointer, message_);
}


inline void PageSwapEventParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PageSwapEventParamsDataView::GetPageStateDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->page_state.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::NavigationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::NavigationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::NavigationTypeForNavigationApi> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::NavigationTypeForNavigationApi value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ForceHistoryPush> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ForceHistoryPush value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ParentResourceTimingAccess> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ParentResourceTimingAccess value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_SHARED_H_