// third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_POLICY_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink::mojom {
class NavigationDownloadTypesDataView;

class NavigationDownloadPolicyDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::NavigationDownloadTypesDataView> {
  using Data = ::blink::mojom::internal::NavigationDownloadTypes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::NavigationDownloadPolicyDataView> {
  using Data = ::blink::mojom::internal::NavigationDownloadPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class NavigationDownloadTypesDataView {
 public:
  NavigationDownloadTypesDataView() = default;

  NavigationDownloadTypesDataView(
      internal::NavigationDownloadTypes_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool view_source() const {
    return data_->view_source;
  }
  bool interstitial() const {
    return data_->interstitial;
  }
  bool opener_cross_origin() const {
    return data_->opener_cross_origin;
  }
  bool ad_frame_no_gesture() const {
    return data_->ad_frame_no_gesture;
  }
  bool ad_frame() const {
    return data_->ad_frame;
  }
  bool sandbox() const {
    return data_->sandbox;
  }
  bool no_gesture() const {
    return data_->no_gesture;
  }
 private:
  internal::NavigationDownloadTypes_Data* data_ = nullptr;
};


class NavigationDownloadPolicyDataView {
 public:
  NavigationDownloadPolicyDataView() = default;

  NavigationDownloadPolicyDataView(
      internal::NavigationDownloadPolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetObservedTypesDataView(
      NavigationDownloadTypesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadObservedTypes(UserType* output) {
    
    auto* pointer = data_->observed_types.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationDownloadTypesDataView>(
        pointer, output, message_);
  }
  inline void GetDisallowedTypesDataView(
      NavigationDownloadTypesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisallowedTypes(UserType* output) {
    
    auto* pointer = data_->disallowed_types.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationDownloadTypesDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationDownloadPolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NavigationDownloadTypesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NavigationDownloadTypesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NavigationDownloadTypes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->view_source = Traits::view_source(input);
    fragment->interstitial = Traits::interstitial(input);
    fragment->opener_cross_origin = Traits::opener_cross_origin(input);
    fragment->ad_frame_no_gesture = Traits::ad_frame_no_gesture(input);
    fragment->ad_frame = Traits::ad_frame(input);
    fragment->sandbox = Traits::sandbox(input);
    fragment->no_gesture = Traits::no_gesture(input);
  }

  static bool Deserialize(::blink::mojom::internal::NavigationDownloadTypes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NavigationDownloadTypesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NavigationDownloadPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NavigationDownloadPolicyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NavigationDownloadPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::observed_types(input)) in_observed_types = Traits::observed_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->observed_types)::BaseType> observed_types_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::NavigationDownloadTypesDataView>(
        in_observed_types, observed_types_fragment);
    fragment->observed_types.Set(
        observed_types_fragment.is_null() ? nullptr : observed_types_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->observed_types.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null observed_types in NavigationDownloadPolicy struct");
    decltype(Traits::disallowed_types(input)) in_disallowed_types = Traits::disallowed_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disallowed_types)::BaseType> disallowed_types_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::NavigationDownloadTypesDataView>(
        in_disallowed_types, disallowed_types_fragment);
    fragment->disallowed_types.Set(
        disallowed_types_fragment.is_null() ? nullptr : disallowed_types_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->disallowed_types.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null disallowed_types in NavigationDownloadPolicy struct");
  }

  static bool Deserialize(::blink::mojom::internal::NavigationDownloadPolicy_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NavigationDownloadPolicyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void NavigationDownloadPolicyDataView::GetObservedTypesDataView(
    NavigationDownloadTypesDataView* output) {
  auto pointer = data_->observed_types.Get();
  *output = NavigationDownloadTypesDataView(pointer, message_);
}
inline void NavigationDownloadPolicyDataView::GetDisallowedTypesDataView(
    NavigationDownloadTypesDataView* output) {
  auto pointer = data_->disallowed_types.Get();
  *output = NavigationDownloadTypesDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_POLICY_MOJOM_SHARED_H_