// third_party/blink/public/mojom/permissions/permission.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/permissions/permission.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/permissions/permission.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* PermissionNameToStringHelper(PermissionName value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PermissionName::GEOLOCATION:
      return "GEOLOCATION";
    case PermissionName::NOTIFICATIONS:
      return "NOTIFICATIONS";
    case PermissionName::MIDI:
      return "MIDI";
    case PermissionName::PROTECTED_MEDIA_IDENTIFIER:
      return "PROTECTED_MEDIA_IDENTIFIER";
    case PermissionName::DURABLE_STORAGE:
      return "DURABLE_STORAGE";
    case PermissionName::AUDIO_CAPTURE:
      return "AUDIO_CAPTURE";
    case PermissionName::VIDEO_CAPTURE:
      return "VIDEO_CAPTURE";
    case PermissionName::BACKGROUND_SYNC:
      return "BACKGROUND_SYNC";
    case PermissionName::SENSORS:
      return "SENSORS";
    case PermissionName::CLIPBOARD_READ:
      return "CLIPBOARD_READ";
    case PermissionName::CLIPBOARD_WRITE:
      return "CLIPBOARD_WRITE";
    case PermissionName::PAYMENT_HANDLER:
      return "PAYMENT_HANDLER";
    case PermissionName::BACKGROUND_FETCH:
      return "BACKGROUND_FETCH";
    case PermissionName::IDLE_DETECTION:
      return "IDLE_DETECTION";
    case PermissionName::PERIODIC_BACKGROUND_SYNC:
      return "PERIODIC_BACKGROUND_SYNC";
    case PermissionName::SCREEN_WAKE_LOCK:
      return "SCREEN_WAKE_LOCK";
    case PermissionName::SYSTEM_WAKE_LOCK:
      return "SYSTEM_WAKE_LOCK";
    case PermissionName::NFC:
      return "NFC";
    case PermissionName::STORAGE_ACCESS:
      return "STORAGE_ACCESS";
    case PermissionName::WINDOW_MANAGEMENT:
      return "WINDOW_MANAGEMENT";
    case PermissionName::LOCAL_FONTS:
      return "LOCAL_FONTS";
    case PermissionName::DISPLAY_CAPTURE:
      return "DISPLAY_CAPTURE";
    case PermissionName::TOP_LEVEL_STORAGE_ACCESS:
      return "TOP_LEVEL_STORAGE_ACCESS";
    case PermissionName::CAPTURED_SURFACE_CONTROL:
      return "CAPTURED_SURFACE_CONTROL";
    case PermissionName::SPEAKER_SELECTION:
      return "SPEAKER_SELECTION";
    case PermissionName::KEYBOARD_LOCK:
      return "KEYBOARD_LOCK";
    case PermissionName::POINTER_LOCK:
      return "POINTER_LOCK";
    case PermissionName::FULLSCREEN:
      return "FULLSCREEN";
    case PermissionName::WEB_APP_INSTALLATION:
      return "WEB_APP_INSTALLATION";
    default:
      return nullptr;
  }
}

std::string PermissionNameToString(PermissionName value) {
  const char *str = PermissionNameToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PermissionName value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PermissionName value) {
  return os << PermissionNameToString(value);
}

NOINLINE static const char* EmbeddedPermissionControlResultToStringHelper(EmbeddedPermissionControlResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EmbeddedPermissionControlResult::kDismissed:
      return "kDismissed";
    case EmbeddedPermissionControlResult::kGranted:
      return "kGranted";
    case EmbeddedPermissionControlResult::kDenied:
      return "kDenied";
    case EmbeddedPermissionControlResult::kNotSupported:
      return "kNotSupported";
    case EmbeddedPermissionControlResult::kResolvedNoUserGesture:
      return "kResolvedNoUserGesture";
    default:
      return nullptr;
  }
}

std::string EmbeddedPermissionControlResultToString(EmbeddedPermissionControlResult value) {
  const char *str = EmbeddedPermissionControlResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EmbeddedPermissionControlResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EmbeddedPermissionControlResult value) {
  return os << EmbeddedPermissionControlResultToString(value);
}

namespace internal {
// static
bool PermissionDescriptorExtension_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PermissionDescriptorExtension_Data* object = static_cast<const PermissionDescriptorExtension_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PermissionDescriptorExtension_Tag::kMidi: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_midi, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_midi, validation_context))
        return false;
      return true;
    }
    case PermissionDescriptorExtension_Tag::kClipboard: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_clipboard, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_clipboard, validation_context))
        return false;
      return true;
    }
    case PermissionDescriptorExtension_Tag::kCameraDevice: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_camera_device, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_camera_device, validation_context))
        return false;
      return true;
    }
    case PermissionDescriptorExtension_Tag::kTopLevelStorageAccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_top_level_storage_access, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_top_level_storage_access, validation_context))
        return false;
      return true;
    }
    case PermissionDescriptorExtension_Tag::kFullscreen: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_fullscreen, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_fullscreen, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PermissionDescriptorExtension");
      return false;
    }
  }
}


// static
bool MidiPermissionDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MidiPermissionDescriptor_Data* object =
      static_cast<const MidiPermissionDescriptor_Data*>(data);

  return true;
}

MidiPermissionDescriptor_Data::MidiPermissionDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardPermissionDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardPermissionDescriptor_Data* object =
      static_cast<const ClipboardPermissionDescriptor_Data*>(data);

  return true;
}

ClipboardPermissionDescriptor_Data::ClipboardPermissionDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CameraDevicePermissionDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CameraDevicePermissionDescriptor_Data* object =
      static_cast<const CameraDevicePermissionDescriptor_Data*>(data);

  return true;
}

CameraDevicePermissionDescriptor_Data::CameraDevicePermissionDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TopLevelStorageAccessPermissionDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TopLevelStorageAccessPermissionDescriptor_Data* object =
      static_cast<const TopLevelStorageAccessPermissionDescriptor_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requestedOrigin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requestedOrigin, validation_context))
    return false;

  return true;
}

TopLevelStorageAccessPermissionDescriptor_Data::TopLevelStorageAccessPermissionDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FullscreenPermissionDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FullscreenPermissionDescriptor_Data* object =
      static_cast<const FullscreenPermissionDescriptor_Data*>(data);

  return true;
}

FullscreenPermissionDescriptor_Data::FullscreenPermissionDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionDescriptor_Data* object =
      static_cast<const PermissionDescriptor_Data*>(data);


  if (!::blink::mojom::internal::PermissionName_Data
        ::Validate(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->extension, validation_context))
    return false;

  return true;
}

PermissionDescriptor_Data::PermissionDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedPermissionRequestDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedPermissionRequestDescriptor_Data* object =
      static_cast<const EmbeddedPermissionRequestDescriptor_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& permissions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->permissions, validation_context,
                                         &permissions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_position, validation_context))
    return false;

  return true;
}

EmbeddedPermissionRequestDescriptor_Data::EmbeddedPermissionRequestDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionObserver_OnPermissionStatusChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionObserver_OnPermissionStatusChange_Params_Data* object =
      static_cast<const PermissionObserver_OnPermissionStatusChange_Params_Data*>(data);


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PermissionObserver_OnPermissionStatusChange_Params_Data::PermissionObserver_OnPermissionStatusChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data* object =
      static_cast<const EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& statuses_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::PermissionStatus_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->statuses, validation_context,
                                         &statuses_validate_params)) {
    return false;
  }

  return true;
}

EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data::EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_HasPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_HasPermission_Params_Data* object =
      static_cast<const PermissionService_HasPermission_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;

  return true;
}

PermissionService_HasPermission_Params_Data::PermissionService_HasPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_HasPermission_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_HasPermission_ResponseParams_Data* object =
      static_cast<const PermissionService_HasPermission_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PermissionService_HasPermission_ResponseParams_Data::PermissionService_HasPermission_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data* object =
      static_cast<const PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& permissions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->permissions, validation_context,
                                         &permissions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data::PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RequestPageEmbeddedPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RequestPageEmbeddedPermission_Params_Data* object =
      static_cast<const PermissionService_RequestPageEmbeddedPermission_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptor, validation_context))
    return false;

  return true;
}

PermissionService_RequestPageEmbeddedPermission_Params_Data::PermissionService_RequestPageEmbeddedPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data* object =
      static_cast<const PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::EmbeddedPermissionControlResult_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data::PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RequestPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RequestPermission_Params_Data* object =
      static_cast<const PermissionService_RequestPermission_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;

  return true;
}

PermissionService_RequestPermission_Params_Data::PermissionService_RequestPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RequestPermission_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RequestPermission_ResponseParams_Data* object =
      static_cast<const PermissionService_RequestPermission_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PermissionService_RequestPermission_ResponseParams_Data::PermissionService_RequestPermission_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RequestPermissions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RequestPermissions_Params_Data* object =
      static_cast<const PermissionService_RequestPermissions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& permission_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->permission, validation_context,
                                         &permission_validate_params)) {
    return false;
  }

  return true;
}

PermissionService_RequestPermissions_Params_Data::PermissionService_RequestPermissions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RequestPermissions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RequestPermissions_ResponseParams_Data* object =
      static_cast<const PermissionService_RequestPermissions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->statuses, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& statuses_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::PermissionStatus_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->statuses, validation_context,
                                         &statuses_validate_params)) {
    return false;
  }

  return true;
}

PermissionService_RequestPermissions_ResponseParams_Data::PermissionService_RequestPermissions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RevokePermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RevokePermission_Params_Data* object =
      static_cast<const PermissionService_RevokePermission_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;

  return true;
}

PermissionService_RevokePermission_Params_Data::PermissionService_RevokePermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_RevokePermission_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_RevokePermission_ResponseParams_Data* object =
      static_cast<const PermissionService_RevokePermission_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PermissionService_RevokePermission_ResponseParams_Data::PermissionService_RevokePermission_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_AddPermissionObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_AddPermissionObserver_Params_Data* object =
      static_cast<const PermissionService_AddPermissionObserver_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->last_known_status, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PermissionService_AddPermissionObserver_Params_Data::PermissionService_AddPermissionObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_AddPageEmbeddedPermissionObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_AddPageEmbeddedPermissionObserver_Params_Data* object =
      static_cast<const PermissionService_AddPageEmbeddedPermissionObserver_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->last_known_status, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PermissionService_AddPageEmbeddedPermissionObserver_Params_Data::PermissionService_AddPageEmbeddedPermissionObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionService_NotifyEventListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionService_NotifyEventListener_Params_Data* object =
      static_cast<const PermissionService_NotifyEventListener_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_type, validation_context,
                                         &event_type_validate_params)) {
    return false;
  }

  return true;
}

PermissionService_NotifyEventListener_Params_Data::PermissionService_NotifyEventListener_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PermissionName>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PermissionName value) {
  return std::move(context).WriteString(::blink::mojom::PermissionNameToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EmbeddedPermissionControlResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::EmbeddedPermissionControlResult value) {
  return std::move(context).WriteString(::blink::mojom::EmbeddedPermissionControlResultToString(value));
}

} // namespace perfetto