// third_party/blink/public/mojom/plugins/plugin_registry.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PLUGINS_PLUGIN_REGISTRY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PLUGINS_PLUGIN_REGISTRY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class PluginRegistryProxy;

template <typename ImplRefTraits>
class PluginRegistryStub;

class PluginRegistryRequestValidator;
class PluginRegistryResponseValidator;


class BLINK_COMMON_EXPORT PluginRegistry
    : public PluginRegistryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PluginRegistryInterfaceBase;
  using Proxy_ = PluginRegistryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PluginRegistryStub<ImplRefTraits>;

  using RequestValidator_ = PluginRegistryRequestValidator;
  using ResponseValidator_ = PluginRegistryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPluginsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPlugins_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PluginRegistry() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetPlugins(bool refresh, std::vector<PluginInfoPtr>* out_plugins);

  using GetPluginsCallback = base::OnceCallback<void(std::vector<PluginInfoPtr>)>;
  
  virtual void GetPlugins(bool refresh, GetPluginsCallback callback) = 0;
};



class BLINK_COMMON_EXPORT PluginRegistryProxy
    : public PluginRegistry {
 public:
  using InterfaceType = PluginRegistry;

  explicit PluginRegistryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetPlugins(bool refresh, std::vector<PluginInfoPtr>* out_plugins) final;
  
  void GetPlugins(bool refresh, GetPluginsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT PluginRegistryStubDispatch {
 public:
  static bool Accept(PluginRegistry* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PluginRegistry* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PluginRegistry>>
class PluginRegistryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PluginRegistryStub() = default;
  ~PluginRegistryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PluginRegistryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PluginRegistryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PluginRegistryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PluginRegistryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT PluginMimeType {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PluginMimeType, T>::value>;
  using DataView = PluginMimeTypeDataView;
  using Data_ = internal::PluginMimeType_Data;

  template <typename... Args>
  static PluginMimeTypePtr New(Args&&... args) {
    return PluginMimeTypePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PluginMimeTypePtr From(const U& u) {
    return mojo::TypeConverter<PluginMimeTypePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PluginMimeType>::Convert(*this);
  }


  PluginMimeType();

  PluginMimeType(
      const std::string& mime_type,
      const ::std::u16string& description,
      std::vector<std::string> file_extensions);


  ~PluginMimeType();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PluginMimeTypePtr>
  PluginMimeTypePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PluginMimeType::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PluginMimeType::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PluginMimeType::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PluginMimeType::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PluginMimeType::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PluginMimeType_UnserializedMessageContext<
            UserType, PluginMimeType::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PluginMimeType::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PluginMimeType::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PluginMimeType_UnserializedMessageContext<
            UserType, PluginMimeType::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PluginMimeType::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string mime_type;
  
  ::std::u16string description;
  
  std::vector<std::string> file_extensions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PluginMimeType::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PluginMimeType::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PluginMimeType::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PluginMimeType::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PluginInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PluginInfo, T>::value>;
  using DataView = PluginInfoDataView;
  using Data_ = internal::PluginInfo_Data;

  template <typename... Args>
  static PluginInfoPtr New(Args&&... args) {
    return PluginInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PluginInfoPtr From(const U& u) {
    return mojo::TypeConverter<PluginInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PluginInfo>::Convert(*this);
  }


  PluginInfo();

  PluginInfo(
      const ::std::u16string& name,
      const ::std::u16string& description,
      const ::base::FilePath& filename,
      uint32_t background_color,
      std::vector<PluginMimeTypePtr> mime_types,
      bool may_use_external_handler);

PluginInfo(const PluginInfo&) = delete;
PluginInfo& operator=(const PluginInfo&) = delete;

  ~PluginInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PluginInfoPtr>
  PluginInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PluginInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PluginInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PluginInfo_UnserializedMessageContext<
            UserType, PluginInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PluginInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PluginInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PluginInfo_UnserializedMessageContext<
            UserType, PluginInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PluginInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  ::std::u16string description;
  
  ::base::FilePath filename;
  
  uint32_t background_color;
  
  std::vector<PluginMimeTypePtr> mime_types;
  
  bool may_use_external_handler;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PluginMimeTypePtr PluginMimeType::Clone() const {
  return New(
      mojo::Clone(mime_type),
      mojo::Clone(description),
      mojo::Clone(file_extensions)
  );
}

template <typename T, PluginMimeType::EnableIfSame<T>*>
bool PluginMimeType::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->file_extensions, other_struct.file_extensions))
    return false;
  return true;
}

template <typename T, PluginMimeType::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.file_extensions < rhs.file_extensions)
    return true;
  if (rhs.file_extensions < lhs.file_extensions)
    return false;
  return false;
}
template <typename StructPtrType>
PluginInfoPtr PluginInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(description),
      mojo::Clone(filename),
      mojo::Clone(background_color),
      mojo::Clone(mime_types),
      mojo::Clone(may_use_external_handler)
  );
}

template <typename T, PluginInfo::EnableIfSame<T>*>
bool PluginInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->filename, other_struct.filename))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->mime_types, other_struct.mime_types))
    return false;
  if (!mojo::Equals(this->may_use_external_handler, other_struct.may_use_external_handler))
    return false;
  return true;
}

template <typename T, PluginInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.filename < rhs.filename)
    return true;
  if (rhs.filename < lhs.filename)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.mime_types < rhs.mime_types)
    return true;
  if (rhs.mime_types < lhs.mime_types)
    return false;
  if (lhs.may_use_external_handler < rhs.may_use_external_handler)
    return true;
  if (rhs.may_use_external_handler < lhs.may_use_external_handler)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PluginMimeType::DataView,
                                         ::blink::mojom::PluginMimeTypePtr> {
  static bool IsNull(const ::blink::mojom::PluginMimeTypePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PluginMimeTypePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PluginMimeType::mime_type)& mime_type(
      const ::blink::mojom::PluginMimeTypePtr& input) {
    return input->mime_type;
  }

  static const decltype(::blink::mojom::PluginMimeType::description)& description(
      const ::blink::mojom::PluginMimeTypePtr& input) {
    return input->description;
  }

  static const decltype(::blink::mojom::PluginMimeType::file_extensions)& file_extensions(
      const ::blink::mojom::PluginMimeTypePtr& input) {
    return input->file_extensions;
  }

  static bool Read(::blink::mojom::PluginMimeType::DataView input, ::blink::mojom::PluginMimeTypePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PluginInfo::DataView,
                                         ::blink::mojom::PluginInfoPtr> {
  static bool IsNull(const ::blink::mojom::PluginInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PluginInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PluginInfo::name)& name(
      const ::blink::mojom::PluginInfoPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::PluginInfo::description)& description(
      const ::blink::mojom::PluginInfoPtr& input) {
    return input->description;
  }

  static const decltype(::blink::mojom::PluginInfo::filename)& filename(
      const ::blink::mojom::PluginInfoPtr& input) {
    return input->filename;
  }

  static decltype(::blink::mojom::PluginInfo::background_color) background_color(
      const ::blink::mojom::PluginInfoPtr& input) {
    return input->background_color;
  }

  static const decltype(::blink::mojom::PluginInfo::mime_types)& mime_types(
      const ::blink::mojom::PluginInfoPtr& input) {
    return input->mime_types;
  }

  static decltype(::blink::mojom::PluginInfo::may_use_external_handler) may_use_external_handler(
      const ::blink::mojom::PluginInfoPtr& input) {
    return input->may_use_external_handler;
  }

  static bool Read(::blink::mojom::PluginInfo::DataView input, ::blink::mojom::PluginInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PLUGINS_PLUGIN_REGISTRY_MOJOM_H_