// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE SCHEMA DEFINITION AND DESCRIPTION IN
//   ../../../../../qtwebengine/src/3rdparty/chromium/third_party/search_engines_data/prepopulated_engines_schema.json
//   ../../../../../qtwebengine/src/3rdparty/chromium/third_party/search_engines_data/resources/definitions/prepopulated_engines.json
// DO NOT EDIT.

#include "prepopulated_engines.h"

namespace TemplateURLPrepopulateData {

const int kMaxPrepopulatedEngineID = 112;
const int kCurrentDataVersion = 170;

const PrepopulatedEngine ask = {
  u"Ask",
  u"ask.com",
  "https://www.ask.com/wp-content/uploads/sites/3/2021/10/ask-favicon.png",
  "https://www.ask.com/web?q={searchTerms}",
  "UTF-8",
  "https://lss.sse-iacapps.com/query?q={searchTerms}&li=ff",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_ASK,
  nullptr,
  nullptr,
  4,
  {},
};

const char* const array_baidu_alternate_urls[] = {
  "https://www.baidu.com/s?ie={inputEncoding}&wd={searchTerms}",
  "https://www.baidu.com/s?ie={inputEncoding}&word={searchTerms}",
  "https://www.baidu.com/{google:pathWildcard}/s?ie={inputEncoding}&word={searchTerms}",
};
const PrepopulatedEngine baidu = {
  u"\x767e" u"\x5ea6" u"",
  u"baidu.com",
  "https://www.baidu.com/favicon.ico",
  "https://www.baidu.com/#ie={inputEncoding}&wd={searchTerms}",
  "UTF-8",
  "https://suggestion.baidu.com/su?wd={searchTerms}&action=opensearch&ie={inputEncoding}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_baidu_alternate_urls,
  SEARCH_ENGINE_BAIDU,
  nullptr,
  nullptr,
  21,
  {},
};

const RegulatoryExtension array_bing_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "PC=U316&FORM=CHROMN",
    "PC=U316",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "PC=U534&FORM=U534DF",
    "PC=U534&FORM=U534SS",
  },
};
const PrepopulatedEngine bing = {
  u"Microsoft Bing",
  u"bing.com",
  "https://www.bing.com/sa/simg/bing_p_rr_teal_min.ico",
  "https://www.bing.com/search?q={searchTerms}",
  "UTF-8",
  "https://www.bing.com/osjson.aspx?query={searchTerms}&language={language}",
  "https://www.bing.com/images/detail/search?iss=sbiupload&FORM=CHROMI#enterInsights",
  nullptr,
  "https://www.bing.com/chrome/newtab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  "imageBin={google:imageThumbnailBase64}",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_BING,
  nullptr,
  nullptr,
  3,
  array_bing_regulatory_extensions,
};

const PrepopulatedEngine brave = {
  u"Brave",
  u"search.brave.com",
  "https://cdn.search.brave.com/serp/favicon.ico",
  "https://search.brave.com/search?q={searchTerms}",
  "UTF-8",
  "https://search.brave.com/api/suggest?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_BRAVE,
  nullptr,
  nullptr,
  109,
  {},
};

const PrepopulatedEngine coccoc = {
  u"C\x1ed1" u"c C\x1ed1" u"c",
  u"coccoc.com",
  "https://coccoc.com/favicon.ico",
  "https://coccoc.com/search#query={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_COCCOC,
  nullptr,
  nullptr,
  91,
  {},
};

const PrepopulatedEngine daum = {
  u"Daum",
  u"daum.net",
  "https://search.daum.net/favicon.ico",
  "https://search.daum.net/search?w=tot&DA=JU5&q={searchTerms}",
  "UTF-8",
  "https://suggest.search.daum.net/sushi/opensearch/pc?q={searchTerms}&DA=JU6",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_DAUM,
  nullptr,
  nullptr,
  68,
  {},
};

const RegulatoryExtension array_duckduckgo_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kAndroidEEA,
    "t=euandroid",
    nullptr,
  },
};
const PrepopulatedEngine duckduckgo = {
  u"DuckDuckGo",
  u"duckduckgo.com",
  "https://duckduckgo.com/favicon.ico",
  "https://duckduckgo.com/?q={searchTerms}",
  "UTF-8",
  "https://duckduckgo.com/ac/?q={searchTerms}&type=list",
  nullptr,
  nullptr,
  "https://duckduckgo.com/chrome_newtab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_DUCKDUCKGO,
  nullptr,
  nullptr,
  92,
  array_duckduckgo_regulatory_extensions,
};

const RegulatoryExtension array_ecosia_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "addon=opensearch",
    nullptr,
  },
};
const PrepopulatedEngine ecosia = {
  u"Ecosia",
  u"ecosia.org",
  "https://cdn.ecosia.org/assets/images/ico/favicon.ico",
  "https://www.ecosia.org/search?q={searchTerms}",
  "UTF-8",
  "https://ac.ecosia.org?q={searchTerms}&mkt={language}&type=list&language={language}",
  nullptr,
  nullptr,
  "https://www.ecosia.org/newtab/",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_ECOSIA,
  nullptr,
  nullptr,
  101,
  array_ecosia_regulatory_extensions,
};

const char* const array_google_alternate_urls[] = {
  "{google:baseURL}#q={searchTerms}",
  "{google:baseURL}search#q={searchTerms}",
  "{google:baseURL}webhp#q={searchTerms}",
  "{google:baseURL}s#q={searchTerms}",
  "{google:baseURL}s?q={searchTerms}",
};
const char* const array_google_search_intent_params[] = {
  "si",
  "gs_ssp",
};
const PrepopulatedEngine google = {
  u"Google",
  u"google.com",
  "https://www.google.com/images/branding/product/ico/googleg_alldp.ico",
  "{google:baseURL}search?q={searchTerms}&{google:RLZ}{google:originalQueryForSuggestion}{google:assistedQueryStats}{google:searchFieldtrialParameter}{google:language}{google:prefetchSource}{google:searchClient}{google:sourceId}{google:contextualSearchVersion}ie={inputEncoding}",
  "UTF-8",
  "{google:baseSuggestURL}search?{google:searchFieldtrialParameter}client={google:suggestClient}&gs_ri={google:suggestRid}&xssi=t&q={searchTerms}&{google:inputType}{google:omniboxFocusType}{google:cursorPosition}{google:currentPageUrl}{google:pageClassification}{google:clientCacheTimeToLive}{google:searchVersion}{google:sessionToken}{google:prefetchQuery}sugkey={google:suggestAPIKeyParameter}",
  "{google:baseSearchByImageURL}upload",
  "{google:baseSearchByImageURL}upload?filtertype=tr&{imageTranslateSourceLocale}{imageTranslateTargetLocale}",
  nullptr,
  "{google:baseURL}_/contextualsearch?{google:contextualSearchVersion}{google:contextualSearchContextData}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  "encoded_image={google:imageThumbnail},image_url={google:imageURL},sbisrc={google:imageSearchSource},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},processed_image_dimensions={google:processedImageDimensions}",
  "sourcelang",
  "targetlang",
  nullptr,
  array_google_search_intent_params,
  array_google_alternate_urls,
  SEARCH_ENGINE_GOOGLE,
  "ALLOWED",
  "ALLOWED",
  1,
  {},
};

const PrepopulatedEngine karma = {
  u"Karma Search",
  u"karmasearch.org",
  "https://karmasearch.org/favicon.ico",
  "https://karmasearch.org/search?q={searchTerms}",
  "UTF-8",
  "https://api.karmasearch.org/search/autosuggest?q={searchTerms}",
  nullptr,
  nullptr,
  "https://karmasearch.org/newtab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_KARMA,
  nullptr,
  nullptr,
  110,
  {},
};

const PrepopulatedEngine lilo = {
  u"Lilo",
  u"lilo.org",
  "https://www.lilo.org/wp-content/themes/jarvis_wp/ajans/assets/favicon.ico",
  "https://search.lilo.org/?q={searchTerms}",
  "UTF-8",
  "https://search.lilo.org/api/?service=suggestions&action=suggest&q={searchTerms}&f=chr&l={language}",
  nullptr,
  nullptr,
  "https://search.lilo.org",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_LILO,
  nullptr,
  nullptr,
  111,
  {},
};

const char* const array_mail_ru_alternate_urls[] = {
  "https://go.mail.ru/msearch?q={searchTerms}&{mailru:referralID}",
};
const PrepopulatedEngine mail_ru = {
  u"@MAIL.RU",
  u"mail.ru",
  "https://go.imgsmail.ru/favicon.ico",
  "https://go.mail.ru/search?q={searchTerms}&{mailru:referralID}&fr=ch_omnibox",
  "UTF-8",
  "https://suggests.go.mail.ru/chrome?q={searchTerms}",
  nullptr,
  nullptr,
  "https://go.mail.ru/chrome/newtab/",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_mail_ru_alternate_urls,
  SEARCH_ENGINE_MAILRU,
  nullptr,
  nullptr,
  83,
  {},
};

const PrepopulatedEngine mojeek = {
  u"Mojeek",
  u"mojeek.com",
  "https://www.mojeek.com/favicon.ico",
  "https://www.mojeek.com/search?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_MOJEEK,
  nullptr,
  nullptr,
  103,
  {},
};

const PrepopulatedEngine naver = {
  u"\xb124" u"\xc774" u"\xbc84" u"",
  u"naver.com",
  "https://ssl.pstatic.net/sstatic/search/favicon/favicon_140327.ico",
  "https://search.naver.com/search.naver?ie={inputEncoding}&query={searchTerms}&sm=chr_hty",
  "UTF-8",
  "https://ac.search.naver.com/nx/ac?of=os&ie={inputEncoding}&q={searchTerms}&oe={outputEncoding}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_NAVER,
  nullptr,
  nullptr,
  67,
  {},
};

const PrepopulatedEngine nona = {
  u"Nona",
  u"nona.de",
  "https://www.nona.de/favicon.ico",
  "https://www.nona.de/?q={searchTerms}",
  "UTF-8",
  "https://www.nona.de/autocomplete/?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_NONA,
  nullptr,
  nullptr,
  107,
  {},
};

const PrepopulatedEngine panda = {
  u"WWF Panda Search",
  u"panda-search.org",
  "https://panda-search.org/favicon.ico",
  "https://panda-search.org/search/?q={searchTerms}",
  "UTF-8",
  "https://suggest.panda-search.org/suggest?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_PANDASEARCH,
  nullptr,
  nullptr,
  104,
  {},
};

const PrepopulatedEngine petal_search = {
  u"Petal Search",
  u"petalsearch.com",
  "https://search-static-dre.dbankcdn.com/pc/v1/favicon.ico",
  "https://petalsearch.com/search?query={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_PETALSEARCH,
  nullptr,
  nullptr,
  102,
  {},
};

const PrepopulatedEngine presearch = {
  u"Presearch",
  u"presearch.com",
  "https://presearch.com/favicon.ico",
  "https://presearch.com/search?q={searchTerms}&src=c",
  "UTF-8",
  "https://presearch.com/api/suggest?q={searchTerms}&src=c",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_PRESEARCH,
  nullptr,
  nullptr,
  105,
  {},
};

const PrepopulatedEngine quendu = {
  u"Quendu.com",
  u"quendu.com",
  "https://quendu.com/assets/favicon-48x48.png",
  "https://www.quendu.com/search?q={searchTerms}",
  "UTF-8",
  "https://www.quendu.com/suggest?query={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_QUENDU,
  nullptr,
  nullptr,
  108,
  {},
};

const RegulatoryExtension array_qwant_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "client=cs-chrome",
    "client=opensearch",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "client=acs",
    "client=opensearch",
  },
};
const PrepopulatedEngine qwant = {
  u"Qwant",
  u"qwant.com",
  "https://www.qwant.com/favicon.ico",
  "https://www.qwant.com/?q={searchTerms}",
  "UTF-8",
  "https://api.qwant.com/api/suggest/?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_QWANT,
  nullptr,
  nullptr,
  94,
  array_qwant_regulatory_extensions,
};

const RegulatoryExtension array_seznam_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kAndroidEEA,
    "sourceid=srch_ga_cs",
    nullptr,
  },
};
const PrepopulatedEngine seznam = {
  u"Seznam.cz",
  u"seznam",
  "https://search.seznam.cz/favicon.ico",
  "https://search.seznam.cz/?q={searchTerms}",
  "UTF-8",
  "https://suggest.seznam.cz/fulltext_ff?phrase={searchTerms}",
  nullptr,
  nullptr,
  "https://search.seznam.cz/newtab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_SEZNAM,
  nullptr,
  nullptr,
  25,
  array_seznam_regulatory_extensions,
};

const char* const array_so_360_alternate_urls[] = {
  "https://m.so.com/s?ie={inputEncoding}&q={searchTerms}",
  "https://m.so.com/index.php?ie={inputEncoding}&q={searchTerms}",
};
const PrepopulatedEngine so_360 = {
  u"360",
  u"so.com",
  "https://www.so.com/favicon.ico",
  "https://www.so.com/s?ie={inputEncoding}&q={searchTerms}",
  "UTF-8",
  "https://sug.so.360.cn/suggest?encodein={inputEncoding}&encodeout={outputEncoding}&format=opensearch&word={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_so_360_alternate_urls,
  SEARCH_ENGINE_360,
  nullptr,
  nullptr,
  88,
  {},
};

const char* const array_sogou_alternate_urls[] = {
  "https://m.sogou.com/web/{google:pathWildcard}?ie={inputEncoding}&keyword={searchTerms}",
};
const PrepopulatedEngine sogou = {
  u"\x641c" u"\x72d7" u"",
  u"sogou.com",
  "https://www.sogou.com/images/logo/old/favicon.ico",
  "https://www.sogou.com/web?ie={inputEncoding}&query={searchTerms}",
  "UTF-8",
  "https://sugg.sogou.com/sugg/ajaj_json.jsp?type=addrbar&key={searchTerms}&ie={inputEncoding}&from=google",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_sogou_alternate_urls,
  SEARCH_ENGINE_SOGOU,
  nullptr,
  nullptr,
  56,
  {},
};

const PrepopulatedEngine yahoo = {
  u"Yahoo!",
  u"yahoo.com",
  "https://search.yahoo.com/favicon.ico",
  "https://search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas_sfp&p={searchTerms}",
  "UTF-8",
  "https://search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas_sfp&command={searchTerms}",
  nullptr,
  nullptr,
  "https://search.yahoo.com?fr=crmas_sfp",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_ar = {
  u"Yahoo! Argentina",
  u"ar.yahoo.com",
  "https://ar.search.yahoo.com/favicon.ico",
  "https://ar.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ar.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_at_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_at = {
  u"Yahoo Search",
  u"at.yahoo.com",
  "https://at.search.yahoo.com/favicon.ico",
  "https://at.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://at.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_at_regulatory_extensions,
};

const PrepopulatedEngine yahoo_au = {
  u"Yahoo!7",
  u"au.yahoo.com",
  "https://au.search.yahoo.com/favicon.ico",
  "https://au.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://au.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_br = {
  u"Yahoo! Brasil",
  u"br.yahoo.com",
  "https://br.search.yahoo.com/favicon.ico",
  "https://br.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://br.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_ca = {
  u"Yahoo! Canada",
  u"ca.yahoo.com",
  "https://ca.search.yahoo.com/favicon.ico",
  "https://ca.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ca.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_ch = {
  u"Yahoo! Schweiz",
  u"ch.yahoo.com",
  "https://ch.search.yahoo.com/favicon.ico",
  "https://ch.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ch.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_cl = {
  u"Yahoo! Chile",
  u"cl.yahoo.com",
  "https://cl.search.yahoo.com/favicon.ico",
  "https://cl.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://cl.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_co = {
  u"Yahoo! Colombia",
  u"co.yahoo.com",
  "https://co.search.yahoo.com/favicon.ico",
  "https://co.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://co.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_de_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_de = {
  u"Yahoo Search",
  u"de.yahoo.com",
  "https://de.search.yahoo.com/favicon.ico",
  "https://de.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://de.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_de_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_dk_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_dk = {
  u"Yahoo Search",
  u"dk.yahoo.com",
  "https://dk.search.yahoo.com/favicon.ico",
  "https://dk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://dk.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_dk_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_emea_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_emea = {
  u"Yahoo Search",
  u"emea.yahoo.com",
  "https://search.yahoo.com/favicon.ico",
  "https://emea.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://emea.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_emea_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_es_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_es = {
  u"Yahoo B\x00fa" u"squedas",
  u"es.yahoo.com",
  "https://es.search.yahoo.com/favicon.ico",
  "https://es.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://es.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_es_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_fi_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_fi = {
  u"Yahoo Search",
  u"fi.yahoo.com",
  "https://fi.search.yahoo.com/favicon.ico",
  "https://fi.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://fi.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_fi_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_fr_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_fr = {
  u"Yahoo Recherche",
  u"fr.yahoo.com",
  "https://fr.search.yahoo.com/favicon.ico",
  "https://fr.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://fr.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_fr_regulatory_extensions,
};

const PrepopulatedEngine yahoo_hk = {
  u"Yahoo! Hong Kong",
  u"hk.yahoo.com",
  "https://hk.search.yahoo.com/favicon.ico",
  "https://hk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://hk.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_id = {
  u"Yahoo! Indonesia",
  u"id.yahoo.com",
  "https://id.search.yahoo.com/favicon.ico",
  "https://id.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://id.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_in = {
  u"Yahoo! India",
  u"in.yahoo.com",
  "https://in.search.yahoo.com/favicon.ico",
  "https://in.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://in.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_it_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_it = {
  u"Ricerca di Yahoo",
  u"it.yahoo.com",
  "https://it.search.yahoo.com/favicon.ico",
  "https://it.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://it.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_it_regulatory_extensions,
};

const PrepopulatedEngine yahoo_jp = {
  u"Yahoo! JAPAN",
  u"yahoo.co.jp",
  "https://search.yahoo.co.jp/favicon.ico",
  "https://search.yahoo.co.jp/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://search.yahooapis.jp/AssistSearchService/V2/webassistSearch?p={searchTerms}&appid=oQsoxcyxg66enp0TYoirkKoryq6rF8bK76mW0KYxZ0v0WPLtn.Lix6wy8F_LwGWHUII-&output=fxjson&fr=crmas",
  nullptr,
  nullptr,
  "https://search.yahoo.co.jp/?fr=crmas_dt",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_mx = {
  u"Yahoo! M\x00e9" u"xico",
  u"mx.yahoo.com",
  "https://mx.search.yahoo.com/favicon.ico",
  "https://mx.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://mx.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_my = {
  u"Yahoo! Malaysia",
  u"malaysia.yahoo.com",
  "https://malaysia.search.yahoo.com/favicon.ico",
  "https://malaysia.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://malaysia.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_nl_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_nl = {
  u"Yahoo Search",
  u"nl.yahoo.com",
  "https://nl.search.yahoo.com/favicon.ico",
  "https://nl.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://nl.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_nl_regulatory_extensions,
};

const PrepopulatedEngine yahoo_nz = {
  u"Yahoo! New Zealand",
  u"nz.yahoo.com",
  "https://nz.search.yahoo.com/favicon.ico",
  "https://nz.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://nz.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_pe = {
  u"Yahoo! Per\x00fa" u"",
  u"pe.yahoo.com",
  "https://pe.search.yahoo.com/favicon.ico",
  "https://pe.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://pe.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_ph = {
  u"Yahoo! Philippines",
  u"ph.yahoo.com",
  "https://ph.search.yahoo.com/favicon.ico",
  "https://ph.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ph.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_se_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_se = {
  u"Yahoo Search",
  u"se.yahoo.com",
  "https://se.search.yahoo.com/favicon.ico",
  "https://se.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://se.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_se_regulatory_extensions,
};

const PrepopulatedEngine yahoo_sg = {
  u"Yahoo! Singapore",
  u"sg.yahoo.com",
  "https://sg.search.yahoo.com/favicon.ico",
  "https://sg.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://sg.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_th = {
  u"Yahoo! \x0e1b" u"\x0e23" u"\x0e30" u"\x0e40" u"\x0e17" u"\x0e28" u"\x0e44" u"\x0e17" u"\x0e22" u"",
  u"th.yahoo.com",
  "https://th.search.yahoo.com/favicon.ico",
  "https://th.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://th.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_tr = {
  u"Yahoo! T\x00fc" u"rkiye",
  u"tr.yahoo.com",
  "https://tr.search.yahoo.com/favicon.ico",
  "https://tr.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://tr.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_tw = {
  u"Yahoo!\x5947" u"\x6469" u"",
  u"tw.yahoo.com",
  "https://tw.search.yahoo.com/favicon.ico",
  "https://tw.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://tw.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_uk_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_uk = {
  u"Yahoo Search",
  u"uk.yahoo.com",
  "https://uk.search.yahoo.com/favicon.ico",
  "https://uk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://uk.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_uk_regulatory_extensions,
};

const PrepopulatedEngine yahoo_ve = {
  u"Yahoo! Venezuela",
  u"ve.yahoo.com",
  "https://ve.search.yahoo.com/favicon.ico",
  "https://ve.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ve.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_vn = {
  u"Yahoo! Vi\x1ec7" u"t Nam",
  u"vn.yahoo.com",
  "https://vn.search.yahoo.com/favicon.ico",
  "https://vn.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://vn.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yandex_by = {
  u"\x042f" u"\x043d" u"\x0434" u"\x0435" u"\x043a" u"\x0441" u"",
  u"yandex.by",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "https://yandex.by/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.by/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.by/images/search/?rpt=imageview",
  nullptr,
  "https://www.yandex.by/chrome/newtab",
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/yandex/drawable-xxhdpi/yandex.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const RegulatoryExtension array_yandex_com_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "from=os&clid=1836588",
    "uil=en&v=3&sn=5",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "clid=5143284",
    "uil=en",
  },
};
const PrepopulatedEngine yandex_com = {
  u"Yandex",
  u"yandex.com",
  "https://yastatic.net/lego/_/rBTjd6UOPk5913OSn5ZQVYMTQWQ.ico",
  "https://yandex.com/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.com/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.com/images/search?rpt=imageview",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  array_yandex_com_regulatory_extensions,
};

const PrepopulatedEngine yandex_kz = {
  u"\x042f" u"\x043d" u"\x0434" u"\x0435" u"\x043a" u"\x0441" u"",
  u"yandex.kz",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "https://yandex.kz/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.kz/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.kz/images/search/?rpt=imageview",
  nullptr,
  "https://www.yandex.kz/chrome/newtab",
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/yandex/drawable-xxhdpi/yandex.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const PrepopulatedEngine yandex_ru = {
  u"\x042f" u"\x043d" u"\x0434" u"\x0435" u"\x043a" u"\x0441" u"",
  u"yandex.ru",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "https://yandex.ru/{yandex:searchPath}?text={searchTerms}&{yandex:referralID}",
  "UTF-8",
  "https://suggest.yandex.ru/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.ru/images/search/?rpt=imageview",
  nullptr,
  "https://www.yandex.ru/chrome/newtab",
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/yandex/drawable-xxhdpi/yandex.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const PrepopulatedEngine yandex_tr = {
  u"Yandex",
  u"yandex.com.tr",
  "https://yastatic.net/lego/_/rBTjd6UOPk5913OSn5ZQVYMTQWQ.ico",
  "https://www.yandex.com.tr/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.com.tr/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.com.tr/gorsel/search?rpt=imageview",
  nullptr,
  "https://www.yandex.com.tr/chrome/newtab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const PrepopulatedEngine yandex_ua = {
  u"\x042f" u"\x043d" u"\x0434" u"\x0435" u"\x043a" u"\x0441" u"",
  u"yandex.ua",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "https://yandex.ua/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.ua/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.ua/images/search/?rpt=imageview",
  nullptr,
  "https://www.yandex.ua/chrome/newtab",
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/yandex/drawable-xxhdpi/yandex.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const PrepopulatedEngine yep = {
  u"Yep",
  u"yep.com",
  "https://cdn.yep.com/static/meta/favicon.ico",
  "https://yep.com/web?q={searchTerms}",
  "UTF-8",
  "https://api.yep.com/ac/?query={searchTerms}&os=true",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YEP,
  nullptr,
  nullptr,
  106,
  {},
};

const PrepopulatedEngine you = {
  u"You.com",
  u"you.com",
  "https://api.you.com/favicon.ico",
  "https://you.com/search?tbm=youchat&q={searchTerms}",
  "UTF-8",
  "https://you.com/api/ac?domain=default&q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YOU,
  nullptr,
  nullptr,
  112,
  {},
};

const char* const array_atlas_cz_alternate_urls[] = {
  "http://searchatlas.centrum.cz/?q={searchTerms}",
};
const PrepopulatedEngine atlas_cz = {
  u"Atlas.cz",
  u"atlas.cz",
  "https://searchatlas.centrum.cz/favicon.ico",
  "https://searchatlas.centrum.cz/?q={searchTerms}",
  "UTF-8",
  "http://radce.centrum.cz/?q={searchTerms}&of=1",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_atlas_cz_alternate_urls,
  SEARCH_ENGINE_ATLAS,
  nullptr,
  nullptr,
  27,
  {},
};

const char* const array_atlas_sk_alternate_urls[] = {
  "http://hladaj.atlas.sk/fulltext/?phrase={searchTerms}",
};
const PrepopulatedEngine atlas_sk = {
  u"ATLAS.SK",
  u"atlas.sk",
  "http://static.mediacentrum.sk/katalog/atlas.sk/images/favicon.ico",
  "https://hladaj.atlas.sk/fulltext/?phrase={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_atlas_sk_alternate_urls,
  SEARCH_ENGINE_ATLAS,
  nullptr,
  nullptr,
  27,
  {},
};

const char* const array_avg_alternate_urls[] = {
  "http://isearch.avg.com/search?q={searchTerms}",
  "http://search.avg.com/route/?q={searchTerms}&lng={language}",
  "https://isearch.avg.com/search?q={searchTerms}",
  "https://search.avg.com/route/?q={searchTerms}&lng={language}",
};
const PrepopulatedEngine avg = {
  u"AVG",
  u"search.avg.com",
  "http://search.avg.com/favicon.ico",
  "http://search.avg.com/search?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_avg_alternate_urls,
  SEARCH_ENGINE_AVG,
  nullptr,
  nullptr,
  50,
  {},
};

const char* const array_babylon_alternate_urls[] = {
  "http://search.babylon.com/?q={searchTerms}",
};
const PrepopulatedEngine babylon = {
  u"Babylon",
  u"search.babylon.com",
  "http://search.babylon.com/favicon.ico",
  "http://search.babylon.com/home?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_babylon_alternate_urls,
  SEARCH_ENGINE_BABYLON,
  nullptr,
  nullptr,
  64,
  {},
};

const char* const array_conduit_alternate_urls[] = {
  "http://search.conduit.com/Results.aspx?q={searchTerms}",
};
const PrepopulatedEngine conduit = {
  u"Conduit",
  u"conduit.com",
  "http://www.conduit.com/favicon.ico",
  "http://www.conduit.com/search?q={searchTerms}&ie={inputEncoding}&cx=010301873083402539744%3Anxaq5wgrtuo&cof=forid%3A11",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_conduit_alternate_urls,
  SEARCH_ENGINE_CONDUIT,
  nullptr,
  nullptr,
  36,
  {},
};

const char* const array_delfi_lt_alternate_urls[] = {
  "http://www.delfi.lt/paieska/?q={searchTerms}",
};
const PrepopulatedEngine delfi_lt = {
  u"DELFI",
  u"delfi.lt",
  "https://www.delfi.lt/favicon.ico",
  "https://www.delfi.lt/paieska/?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_delfi_lt_alternate_urls,
  SEARCH_ENGINE_DELFI,
  nullptr,
  nullptr,
  45,
  {},
};

const PrepopulatedEngine delfi_lv = {
  u"DELFI",
  u"delfi.lv",
  "http://g1.delphi.lv/favicon.ico",
  "http://www.delfi.lv/search_all/?ie={inputEncoding}&q={searchTerms}&lang={language}&cx=partner-pub-7754285690273419%3A1507605038&cof=FORID%3A10",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_DELFI,
  nullptr,
  nullptr,
  45,
  {},
};

const char* const array_delta_alternate_urls[] = {
  "http://www.delta-search.com/?q={searchTerms}",
  "http://www1.delta-search.com/home?q={searchTerms}",
  "http://www1.delta-search.com/?q={searchTerms}",
  "http://www2.delta-search.com/home?q={searchTerms}",
  "http://www2.delta-search.com/?q={searchTerms}",
  "http://www.search.delta-search.com/home?q={searchTerms}",
  "http://www.search.delta-search.com/?q={searchTerms}",
  "http://www.yhs.delta-search.com/home?q={searchTerms}",
  "http://www.yhs.delta-search.com/?q={searchTerms}",
  "http://mixidj.delta-search.com/home?q={searchTerms}",
  "http://mixidj.delta-search.com/?q={searchTerms}",
  "http://www.search.delta-search.com/home?q={searchTerms}",
  "http://www.search.delta-search.com/?q={searchTerms}",
};
const PrepopulatedEngine delta = {
  u"Delta",
  u"delta-search.com",
  "http://www.delta-search.com/favicon.ico",
  "http://www.delta-search.com/home?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_delta_alternate_urls,
  SEARCH_ENGINE_DELTA,
  nullptr,
  nullptr,
  66,
  {},
};

const PrepopulatedEngine funmoods = {
  u"Funmoods",
  u"searchfunmoods.com",
  "http://searchfunmoods.com/favicon.ico",
  "http://searchfunmoods.com/results.php?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_FUNMOODS,
  nullptr,
  nullptr,
  60,
  {},
};

const PrepopulatedEngine givero = {
  u"Givero",
  u"givero.com",
  "https://www.givero.com/favicon.ico",
  "https://www.givero.com/search?q={searchTerms}",
  "UTF-8",
  "https://www.givero.com/suggest?q={searchTerms}",
  nullptr,
  nullptr,
  "https://givero.com/new_tab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_GIVERO,
  nullptr,
  nullptr,
  95,
  {},
};

const PrepopulatedEngine gmx = {
  u"GMX Search",
  u"search.gmx.com",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://search.gmx.com/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.com/s?q={searchTerms}&brand=gmxcom&enc={inputEncoding}&sp=b",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_GMX,
  nullptr,
  nullptr,
  96,
  {},
};

const PrepopulatedEngine gmx_at = {
  u"GMX Suche",
  u"suche.gmx.at",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://suche.gmx.at/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.at/s?q={searchTerms}&brand=gmxat&enc={inputEncoding}&sp=b",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_GMX,
  nullptr,
  nullptr,
  96,
  {},
};

const PrepopulatedEngine gmx_de = {
  u"GMX Suche",
  u"suche.gmx.net",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://suche.gmx.net/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.net/s?q={searchTerms}&brand=gmx&enc={inputEncoding}&sp=b",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_GMX,
  nullptr,
  nullptr,
  96,
  {},
};

const PrepopulatedEngine gmx_es = {
  u"GMX Search",
  u"search.gmx.es",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://search.gmx.es/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.es/s?q={searchTerms}&brand=gmxes&enc={inputEncoding}&sp=b",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_GMX,
  nullptr,
  nullptr,
  96,
  {},
};

const PrepopulatedEngine gmx_fr = {
  u"GMX Search",
  u"search.gmx.fr",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://search.gmx.fr/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.fr/s?q={searchTerms}&brand=gmxfr&enc={inputEncoding}&sp=b",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_GMX,
  nullptr,
  nullptr,
  96,
  {},
};

const PrepopulatedEngine gmx_gb = {
  u"GMX Search",
  u"search.gmx.co.uk",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://search.gmx.co.uk/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.co.uk/s?q={searchTerms}&brand=gmxcouk&enc={inputEncoding}&sp=b",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_GMX,
  nullptr,
  nullptr,
  96,
  {},
};

const char* const array_goo_alternate_urls[] = {
  "http://search.goo.ne.jp/web.jsp?MT={searchTerms}&IE={inputEncoding}",
  "http://search.goo.ne.jp/sgt.jsp?MT={searchTerms}&CL=plugin&FM=json&IE={inputEncoding}",
};
const PrepopulatedEngine goo = {
  u"goo",
  u"search.goo.ne.jp",
  "https://search.goo.ne.jp/cdn/common/img/favicon.ico",
  "https://search.goo.ne.jp/web.jsp?MT={searchTerms}&IE={inputEncoding}",
  "EUC-JP",
  "https://search.goo.ne.jp/sgt.jsp?MT={searchTerms}&CL=plugin&FM=json&IE={inputEncoding}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_goo_alternate_urls,
  SEARCH_ENGINE_GOO,
  nullptr,
  nullptr,
  23,
  {},
};

const PrepopulatedEngine imesh = {
  u"IMesh",
  u"search.imesh.net",
  "http://search.imesh.net/favicon.ico",
  "http://search.imesh.net/music?hl={language}&si={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_IMESH,
  nullptr,
  nullptr,
  81,
  {},
};

const char* const array_iminent_alternate_urls[] = {
  "http://search.iminent.com/SearchTheWeb/v6/1033/homepage/Default.aspx#q={searchTerms}",
  "http://search.iminent.com/SearchTheWeb/v6/1033/homepage/Result.aspx#q={searchTerms}",
  "http://start.iminent.com/?q={searchTerms}",
  "http://start.iminent.com/StartWeb/1033/homepage/#q={searchTerms}",
};
const PrepopulatedEngine iminent = {
  u"SearchTheWeb",
  u"iminent.com",
  "http://search.iminent.com/Shared/Images/favicon_gl.ico",
  "http://search.iminent.com/?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_iminent_alternate_urls,
  SEARCH_ENGINE_IMINENT,
  nullptr,
  nullptr,
  79,
  {},
};

const PrepopulatedEngine in = {
  u"in.gr",
  u"in.gr",
  "http://find.in.gr/Themes/1/Default/Media/Layout/icon_in.png",
  "http://find.in.gr/?q={searchTerms}&ie={inputEncoding}&cx=partner-pub-3451081775397713%3Aklnvxp4nycj&cof=FORID%3A9",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_IN,
  nullptr,
  nullptr,
  54,
  {},
};

const char* const array_incredibar_alternate_urls[] = {
  "http://search.incredibar.com/?q={searchTerms}",
  "http://mystart.incredibar.com/?search={searchTerms}",
};
const PrepopulatedEngine incredibar = {
  u"MyStart",
  u"mystart.incredibar.com",
  "http://search.incredibar.com/favicon.ico",
  "http://search.incredibar.com/search.php?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_incredibar_alternate_urls,
  SEARCH_ENGINE_INCREDIBAR,
  nullptr,
  nullptr,
  74,
  {},
};

const PrepopulatedEngine info_com = {
  u"Info.com",
  u"info.com",
  "https://www.info.com/static/www.info.com/favicon.ico",
  "https://www.info.com/serp?q={searchTerms}&segment=info.0472",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_INFO_COM,
  nullptr,
  nullptr,
  97,
  {},
};

const PrepopulatedEngine libero = {
  u"Libero",
  u"libero.it",
  "http://ms1.iol.it/graph_hf/v.8.3.04/themes/default/img/favicon.ico",
  "http://arianna.libero.it/search/abin/integrata.cgi?query={searchTerms}",
  "ISO-8859-1",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_LIBERO,
  nullptr,
  nullptr,
  63,
  {},
};

const PrepopulatedEngine metager_de = {
  u"MetaGer",
  u"metager.de",
  "https://metager.de/favicon.ico",
  "https://metager.de/meta/meta.ger3?eingabe={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_METAGER,
  nullptr,
  nullptr,
  98,
  {},
};

const PrepopulatedEngine metager_gb = {
  u"MetaGer",
  u"metager.org",
  "https://metager.de/favicon.ico",
  "https://metager.org/meta/meta.ger3?eingabe={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_METAGER,
  nullptr,
  nullptr,
  98,
  {},
};

const char* const array_neti_alternate_urls[] = {
  "https://www.neti.ee/cgi-bin/otsing?query={searchTerms}&src=web",
  "https://www.neti.ee/api/suggestOS?suggestVersion=1&suggestQuery={searchTerms}",
};
const PrepopulatedEngine neti = {
  u"NETI",
  u"neti.ee",
  "http://www.neti.ee/favicon.ico",
  "http://www.neti.ee/cgi-bin/otsing?query={searchTerms}",
  "ISO-8859-1",
  "http://www.neti.ee/api/suggestOS?suggestQuery={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_neti_alternate_urls,
  SEARCH_ENGINE_NETI,
  nullptr,
  nullptr,
  44,
  {},
};

const PrepopulatedEngine nigma = {
  u"\x041d" u"\x0438" u"\x0433" u"\x043c" u"\x0430" u"",
  u"nigma.ru",
  "http://nigma.ru/themes/nigma/img/favicon.ico",
  "http://nigma.ru/?s={searchTerms}",
  "UTF-8",
  "http://autocomplete.nigma.ru/complete/query_help.php?suggest=true&q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_NIGMA,
  nullptr,
  nullptr,
  43,
  {},
};

const RegulatoryExtension array_oceanhero_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=ch_om",
    "fr=ch_om",
  },
};
const PrepopulatedEngine oceanhero = {
  u"OceanHero",
  u"oceanhero.today",
  "https://oceanhero.today/favicon.ico",
  "https://oceanhero.today/web?q={searchTerms}",
  "UTF-8",
  "https://api.oceanhero.today/suggestions?q={searchTerms}",
  nullptr,
  nullptr,
  "https://oceanhero.today/home",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_OCEANHERO,
  nullptr,
  nullptr,
  99,
  array_oceanhero_regulatory_extensions,
};

const PrepopulatedEngine ok = {
  u"OK.hu",
  u"ok.hu",
  "http://ok.hu/gfx/favicon.ico",
  "http://ok.hu/katalogus?q={searchTerms}",
  "ISO-8859-2",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_OK,
  nullptr,
  nullptr,
  6,
  {},
};

const PrepopulatedEngine privacywall = {
  u"PrivacyWall",
  u"privacywall.org",
  "https://www.privacywall.org/images/favicon_32x32.ico",
  "https://www.privacywall.org/search/secure/?q={searchTerms}",
  "UTF-8",
  "https://search.privacywall.org/suggest.php?q={searchTerms}",
  nullptr,
  nullptr,
  "https://www.privacywall.org/newtab/",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_PRIVACYWALL,
  nullptr,
  nullptr,
  100,
  {},
};

const char* const array_rambler_alternate_urls[] = {
  "https://nova.rambler.ru/search?query={searchTerms}",
  "https://nova.rambler.ru/suggest?v=3&query={searchTerms}",
};
const PrepopulatedEngine rambler = {
  u"\x0420" u"\x0430" u"\x043c" u"\x0431" u"\x043b" u"\x0435" u"\x0440" u"",
  u"rambler.ru",
  "http://i.rl0.ru/2011/icons/rambler.ico",
  "http://nova.rambler.ru/search?query={searchTerms}",
  "UTF-8",
  "http://nova.rambler.ru/suggest?v=3&query={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_rambler_alternate_urls,
  SEARCH_ENGINE_RAMBLER,
  nullptr,
  nullptr,
  16,
  {},
};

const PrepopulatedEngine sapo = {
  u"SAPO",
  u"sapo.pt",
  "http://imgs.sapo.pt/images/sapo.ico",
  "http://pesquisa.sapo.pt/?q={searchTerms}",
  "UTF-8",
  "http://pesquisa.sapo.pt/livesapo?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_SAPO,
  nullptr,
  nullptr,
  77,
  {},
};

const PrepopulatedEngine searchnu = {
  u"searchnu",
  u"searchnu.com",
  "http://www.searchnu.com/favicon.ico",
  "http://www.searchnu.com/web?hl={language}&si={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_SEARCHNU,
  nullptr,
  nullptr,
  61,
  {},
};

const char* const array_search_results_alternate_urls[] = {
  "http://www.search-results.com/web?q={searchTerms}",
};
const PrepopulatedEngine search_results = {
  u"Search-results",
  u"search-results.com",
  "http://ak.apnstatic.com/media/images/favicon_search-results.ico",
  "http://dts.search-results.com/sr?lng={language}&src=hmp&q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_search_results_alternate_urls,
  SEARCH_ENGINE_SEARCH_RESULTS,
  nullptr,
  nullptr,
  78,
  {},
};

const char* const array_snapdo_alternate_urls[] = {
  "http://search.snap.do/?q={searchTerms}",
  "http://feed.snapdo.com/?q={searchTerms}",
  "http://feed.snap.do/?q={searchTerms}",
};
const PrepopulatedEngine snapdo = {
  u"SnapDo",
  u"search.snapdo.com",
  "http://linkurystoragenorthus.blob.core.windows.net/static/favicon.ico",
  "http://search.snapdo.com/?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_snapdo_alternate_urls,
  SEARCH_ENGINE_SNAPDO,
  nullptr,
  nullptr,
  70,
  {},
};

const char* const array_softonic_alternate_urls[] = {
  "http://en.softonic.com/s/{searchTerms}",
  "http://www.softonic.com/s/{searchTerms}",
  "http://www.softonic.com.br/s/{searchTerms}",
  "http://buscador.softonic.com/?q={searchTerms}",
  "http://nl.softonic.com/s/{searchTerms}",
  "https://search.softonic.com/?q={searchTerms}",
  "https://en.softonic.com/s/{searchTerms}",
  "https://www.softonic.com/s/{searchTerms}",
  "https://www.softonic.com.br/s/{searchTerms}",
  "https://buscador.softonic.com/?q={searchTerms}",
  "https://nl.softonic.com/s/{searchTerms}",
};
const PrepopulatedEngine softonic = {
  u"softonic",
  u"search.softonic.com",
  "http://search.softonic.com/img/favicon.ico",
  "http://search.softonic.com/?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_softonic_alternate_urls,
  SEARCH_ENGINE_SOFTONIC,
  nullptr,
  nullptr,
  80,
  {},
};

const PrepopulatedEngine sweetim = {
  u"SweetIM",
  u"home.sweetim.com",
  "http://search.sweetim.com/favicon.ico",
  "http://search.sweetim.com/search.asp?q={searchTerms}&ln={language}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_SWEETPACKS,
  nullptr,
  nullptr,
  65,
  {},
};

const char* const array_sweetpacks_alternate_urls[] = {
  "http://start.sweetpacks.com/?q={searchTerms}",
  "http://mysearch.sweetpacks.com/?q={searchTerms}",
};
const PrepopulatedEngine sweetpacks = {
  u"Sweetpacks",
  u"start.sweetpacks.com",
  "http://start.sweetpacks.com/favicon.ico",
  "http://start.sweetpacks.com/search.asp?q={searchTerms}&ln={language}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_sweetpacks_alternate_urls,
  SEARCH_ENGINE_SWEETPACKS,
  nullptr,
  nullptr,
  65,
  {},
};

const char* const array_terra_ar_alternate_urls[] = {
  "https://buscador.terra.com.ar/Default.aspx?source=Search&ca=s&query={searchTerms}",
};
const PrepopulatedEngine terra_ar = {
  u"Terra Argentina",
  u"terra.com.ar",
  "http://buscar.terra.com.ar/favicon.ico",
  "http://buscar.terra.com.ar/Default.aspx?source=Search&ca=s&query={searchTerms}",
  "ISO-8859-1",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_terra_ar_alternate_urls,
  SEARCH_ENGINE_TERRA,
  nullptr,
  nullptr,
  90,
  {},
};

const char* const array_terra_es_alternate_urls[] = {
  "https://buscador.terra.es/Default.aspx?source=Search&ca=s&query={searchTerms}",
};
const PrepopulatedEngine terra_es = {
  u"Terra",
  u"terra.es",
  "http://buscador.terra.es/favicon.ico",
  "http://buscador.terra.es/Default.aspx?source=Search&ca=s&query={searchTerms}",
  "ISO-8859-1",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_terra_es_alternate_urls,
  SEARCH_ENGINE_TERRA,
  nullptr,
  nullptr,
  90,
  {},
};

const PrepopulatedEngine tut = {
  u"TUT.BY",
  u"tut.by",
  "http://search.tut.by/favicon.ico",
  "http://search.tut.by/?ru=1&query={searchTerms}",
  "UTF-8",
  "http://suggest.yandex.ru/suggest-ff.cgi?part={searchTerms}&limit=10",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_TUT,
  nullptr,
  nullptr,
  17,
  {},
};

const char* const array_walla_alternate_urls[] = {
  "https://search.walla.co.il/?q={searchTerms}",
};
const PrepopulatedEngine walla = {
  u"\x05d5" u"\x05d5" u"\x05d0" u"\x05dc" u"\x05d4" u"!",
  u"walla.co.il",
  "http://www.walla.co.il/favicon.ico",
  "http://search.walla.co.il/?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_walla_alternate_urls,
  SEARCH_ENGINE_WALLA,
  nullptr,
  nullptr,
  55,
  {},
};

const PrepopulatedEngine wp = {
  u"Wirtualna Polska",
  u"wp.pl",
  "http://i.wp.pl/a/i/stg/500/favicon.ico",
  "http://szukaj.wp.pl/szukaj.html?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_WP,
  nullptr,
  nullptr,
  76,
  {},
};

const PrepopulatedEngine yahoo_qc = {
  u"Yahoo! Qu\x00e9" u"bec",
  u"qc.yahoo.com",
  "https://qc.search.yahoo.com/favicon.ico",
  "https://qc.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://qc.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const char* const array_zoznam_alternate_urls[] = {
  "http://www.zoznam.sk/hladaj.fcgi?s={searchTerms}",
};
const PrepopulatedEngine zoznam = {
  u"Zoznam",
  u"zoznam.sk",
  "https://www.zoznam.sk/favicon.ico",
  "https://www.zoznam.sk/hladaj.fcgi?s={searchTerms}",
  "windows-1250",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_zoznam_alternate_urls,
  SEARCH_ENGINE_ZOZNAM,
  nullptr,
  nullptr,
  85,
  {},
};

const PrepopulatedEngine* const array_kAllEngines[] = {
	&ask,
	&baidu,
	&bing,
	&brave,
	&coccoc,
	&daum,
	&duckduckgo,
	&ecosia,
	&google,
	&karma,
	&lilo,
	&mail_ru,
	&mojeek,
	&naver,
	&nona,
	&panda,
	&petal_search,
	&presearch,
	&quendu,
	&qwant,
	&seznam,
	&so_360,
	&sogou,
	&yahoo,
	&yahoo_ar,
	&yahoo_at,
	&yahoo_au,
	&yahoo_br,
	&yahoo_ca,
	&yahoo_ch,
	&yahoo_cl,
	&yahoo_co,
	&yahoo_de,
	&yahoo_dk,
	&yahoo_emea,
	&yahoo_es,
	&yahoo_fi,
	&yahoo_fr,
	&yahoo_hk,
	&yahoo_id,
	&yahoo_in,
	&yahoo_it,
	&yahoo_jp,
	&yahoo_mx,
	&yahoo_my,
	&yahoo_nl,
	&yahoo_nz,
	&yahoo_pe,
	&yahoo_ph,
	&yahoo_se,
	&yahoo_sg,
	&yahoo_th,
	&yahoo_tr,
	&yahoo_tw,
	&yahoo_uk,
	&yahoo_ve,
	&yahoo_vn,
	&yandex_by,
	&yandex_com,
	&yandex_kz,
	&yandex_ru,
	&yandex_tr,
	&yandex_ua,
	&yep,
	&you,
	&atlas_cz,
	&atlas_sk,
	&avg,
	&babylon,
	&conduit,
	&delfi_lt,
	&delfi_lv,
	&delta,
	&funmoods,
	&givero,
	&gmx,
	&gmx_at,
	&gmx_de,
	&gmx_es,
	&gmx_fr,
	&gmx_gb,
	&goo,
	&imesh,
	&iminent,
	&in,
	&incredibar,
	&info_com,
	&libero,
	&metager_de,
	&metager_gb,
	&neti,
	&nigma,
	&oceanhero,
	&ok,
	&privacywall,
	&rambler,
	&sapo,
	&searchnu,
	&search_results,
	&snapdo,
	&softonic,
	&sweetim,
	&sweetpacks,
	&terra_ar,
	&terra_es,
	&tut,
	&walla,
	&wp,
	&yahoo_qc,
	&zoznam,
};
const base::span<const PrepopulatedEngine* const> kAllEngines{array_kAllEngines};

}  // namespace TemplateURLPrepopulateData
