// components/download/public/common/download_stream.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/download/public/common/download_stream.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/download/public/common/download_stream.mojom-params-data.h"
#include "components/download/public/common/download_stream.mojom-shared-message-ids.h"

#include "components/download/public/common/download_stream.mojom-import-headers.h"
#include "components/download/public/common/download_stream.mojom-test-utils.h"


namespace download::mojom {
DownloadStreamHandle::DownloadStreamHandle()
    : stream(),
      client_receiver() {}

DownloadStreamHandle::DownloadStreamHandle(
    ::mojo::ScopedDataPipeConsumerHandle stream_in,
    ::mojo::PendingReceiver<DownloadStreamClient> client_receiver_in)
    : stream(std::move(stream_in)),
      client_receiver(std::move(client_receiver_in)) {}

DownloadStreamHandle::~DownloadStreamHandle() = default;

void DownloadStreamHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream"), this->stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<DownloadStreamClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DownloadStreamHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DownloadStreamClient::IPCStableHashFunction DownloadStreamClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DownloadStreamClient>(message.name())) {
    case messages::DownloadStreamClient::kOnStreamCompleted: {
      return &DownloadStreamClient::OnStreamCompleted_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DownloadStreamClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DownloadStreamClient>(message.name())) {
      case messages::DownloadStreamClient::kOnStreamCompleted:
            return "Receive download::mojom::DownloadStreamClient::OnStreamCompleted";
    }
  } else {
    switch (static_cast<messages::DownloadStreamClient>(message.name())) {
      case messages::DownloadStreamClient::kOnStreamCompleted:
            return "Receive reply download::mojom::DownloadStreamClient::OnStreamCompleted";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DownloadStreamClient::OnStreamCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0af5990;  // IPCStableHash for download::mojom::DownloadStreamClient::OnStreamCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DownloadStreamClientProxy::DownloadStreamClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DownloadStreamClientProxy::OnStreamCompleted(
    NetworkRequestStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send download::mojom::DownloadStreamClient::OnStreamCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type NetworkRequestStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadStreamClient::kOnStreamCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::download::mojom::internal::DownloadStreamClient_OnStreamCompleted_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::download::mojom::NetworkRequestStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadStreamClient::Name_);
  message.set_method_name("OnStreamCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DownloadStreamClientStubDispatch::Accept(
    DownloadStreamClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DownloadStreamClient>(message->header()->name)) {
    case messages::DownloadStreamClient::kOnStreamCompleted: {
      DCHECK(message->is_serialized());
      internal::DownloadStreamClient_OnStreamCompleted_Params_Data* params =
          reinterpret_cast<internal::DownloadStreamClient_OnStreamCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadStreamClient.0
      bool success = true;
      NetworkRequestStatus p_status{};
      DownloadStreamClient_OnStreamCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadStreamClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStreamCompleted(        
        std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool DownloadStreamClientStubDispatch::AcceptWithResponder(
    DownloadStreamClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DownloadStreamClient>(message->header()->name)) {
    case messages::DownloadStreamClient::kOnStreamCompleted: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDownloadStreamClientValidationInfo[] = {
    {base::to_underlying(messages::DownloadStreamClient::kOnStreamCompleted),
     { &internal::DownloadStreamClient_OnStreamCompleted_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DownloadStreamClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::download::mojom::DownloadStreamClient::Name_,
    kDownloadStreamClientValidationInfo);
}



}  // download::mojom


namespace mojo {


// static
bool StructTraits<::download::mojom::DownloadStreamHandle::DataView, ::download::mojom::DownloadStreamHandlePtr>::Read(
    ::download::mojom::DownloadStreamHandle::DataView input,
    ::download::mojom::DownloadStreamHandlePtr* output) {
  bool success = true;
  ::download::mojom::DownloadStreamHandlePtr result(::download::mojom::DownloadStreamHandle::New());
  
      if (success)
        result->stream = input.TakeStream();
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace download::mojom {


void DownloadStreamClientInterceptorForTesting::OnStreamCompleted(NetworkRequestStatus status) {
  GetForwardingInterface()->OnStreamCompleted(
    std::move(status)
    );
}
DownloadStreamClientAsyncWaiter::DownloadStreamClientAsyncWaiter(
    DownloadStreamClient* proxy) : proxy_(proxy) {}

DownloadStreamClientAsyncWaiter::~DownloadStreamClientAsyncWaiter() = default;







}  // download::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif