// components/input/render_input_router.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/input/render_input_router.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"


namespace input::mojom {
class RenderInputRouterConfigDataView;

class TouchTransferStateDataView;



}  // input::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::input::mojom::RenderInputRouterConfigDataView> {
  using Data = ::input::mojom::internal::RenderInputRouterConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::input::mojom::TouchTransferStateDataView> {
  using Data = ::input::mojom::internal::TouchTransferState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace input::mojom {
// Interface base classes. They are used for type safety check.
class RenderInputRouterDelegateInterfaceBase {};

using RenderInputRouterDelegatePtrDataView =
    mojo::InterfacePtrDataView<RenderInputRouterDelegateInterfaceBase>;
using RenderInputRouterDelegateRequestDataView =
    mojo::InterfaceRequestDataView<RenderInputRouterDelegateInterfaceBase>;
using RenderInputRouterDelegateAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderInputRouterDelegateInterfaceBase>;
using RenderInputRouterDelegateAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderInputRouterDelegateInterfaceBase>;
class RenderInputRouterDelegateClientInterfaceBase {};

using RenderInputRouterDelegateClientPtrDataView =
    mojo::InterfacePtrDataView<RenderInputRouterDelegateClientInterfaceBase>;
using RenderInputRouterDelegateClientRequestDataView =
    mojo::InterfaceRequestDataView<RenderInputRouterDelegateClientInterfaceBase>;
using RenderInputRouterDelegateClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderInputRouterDelegateClientInterfaceBase>;
using RenderInputRouterDelegateClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderInputRouterDelegateClientInterfaceBase>;


class RenderInputRouterConfigDataView {
 public:
  RenderInputRouterConfigDataView() = default;

  RenderInputRouterConfigDataView(
      internal::RenderInputRouterConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeRirClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::RenderInputRouterClientInterfaceBase>>(
            &data_->rir_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetGroupingIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupingId(UserType* output) {
    
    auto* pointer = data_->grouping_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool force_enable_zoom() const {
    return data_->force_enable_zoom;
  }
 private:
  internal::RenderInputRouterConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchTransferStateDataView {
 public:
  TouchTransferStateDataView() = default;

  TouchTransferStateDataView(
      internal::TouchTransferState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDownTimeMsDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownTimeMs(UserType* output) {
    
    auto* pointer = data_->down_time_ms.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetRootWidgetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootWidgetFrameSinkId(UserType* output) {
    
    auto* pointer = data_->root_widget_frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  float web_contents_y_offset_pix() const {
    return data_->web_contents_y_offset_pix;
  }
  float dip_scale() const {
    return data_->dip_scale;
  }
  bool browser_would_have_handled() const {
    return data_->browser_would_have_handled;
  }
 private:
  internal::TouchTransferState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // input::mojom

#endif  // COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_DATA_VIEW_H_