// components/metrics/dwa/mojom/dwa_interface.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/metrics/dwa/mojom/dwa_interface.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/metrics/dwa/mojom/dwa_interface.mojom-params-data.h"
#include "components/metrics/dwa/mojom/dwa_interface.mojom-shared-message-ids.h"

#include "components/metrics/dwa/mojom/dwa_interface.mojom-import-headers.h"
#include "components/metrics/dwa/mojom/dwa_interface.mojom-test-utils.h"


namespace metrics::dwa::mojom {
DwaEntry::DwaEntry()
    : event_hash(),
      content_hash(),
      studies_of_interest(),
      metrics() {}

DwaEntry::DwaEntry(
    uint64_t event_hash_in,
    uint64_t content_hash_in,
    const base::flat_map<std::string, bool>& studies_of_interest_in,
    const base::flat_map<uint64_t, int64_t>& metrics_in)
    : event_hash(std::move(event_hash_in)),
      content_hash(std::move(content_hash_in)),
      studies_of_interest(std::move(studies_of_interest_in)),
      metrics(std::move(metrics_in)) {}

DwaEntry::~DwaEntry() = default;

void DwaEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_hash"), this->event_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_hash"), this->content_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "studies_of_interest"), this->studies_of_interest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, bool>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metrics"), this->metrics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint64_t, int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DwaEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DwaRecorderClientInterface::IPCStableHashFunction DwaRecorderClientInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DwaRecorderClientInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

DwaRecorderClientInterfaceProxy::DwaRecorderClientInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool DwaRecorderClientInterfaceStubDispatch::Accept(
    DwaRecorderClientInterface* impl,
    mojo::Message* message) {
  return false;
}

// static
bool DwaRecorderClientInterfaceStubDispatch::AcceptWithResponder(
    DwaRecorderClientInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool DwaRecorderClientInterfaceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::metrics::dwa::mojom::DwaRecorderClientInterface::Name_,
    {});
}

// The declaration includes the definition on other builds.

DwaRecorderInterface::IPCStableHashFunction DwaRecorderInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DwaRecorderInterface>(message.name())) {
    case messages::DwaRecorderInterface::kAddEntry: {
      return &DwaRecorderInterface::AddEntry_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DwaRecorderInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DwaRecorderInterface>(message.name())) {
      case messages::DwaRecorderInterface::kAddEntry:
            return "Receive metrics::dwa::mojom::DwaRecorderInterface::AddEntry";
    }
  } else {
    switch (static_cast<messages::DwaRecorderInterface>(message.name())) {
      case messages::DwaRecorderInterface::kAddEntry:
            return "Receive reply metrics::dwa::mojom::DwaRecorderInterface::AddEntry";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DwaRecorderInterface::AddEntry_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9e1c920;  // IPCStableHash for metrics::dwa::mojom::DwaRecorderInterface::AddEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DwaRecorderInterfaceProxy::DwaRecorderInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DwaRecorderInterfaceProxy::AddEntry(
    DwaEntryPtr in_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics::dwa::mojom::DwaRecorderInterface::AddEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry,
                        "<value of type DwaEntryPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DwaRecorderInterface::kAddEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics::dwa::mojom::internal::DwaRecorderInterface_AddEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entry)::BaseType> entry_fragment(
          params.message());
  
  mojo::internal::Serialize<::metrics::dwa::mojom::DwaEntryDataView>(
    in_entry,
    entry_fragment);

  params->entry.Set(
      entry_fragment.is_null() ? nullptr : entry_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entry.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entry in DwaRecorderInterface.AddEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DwaRecorderInterface::Name_);
  message.set_method_name("AddEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DwaRecorderInterfaceStubDispatch::Accept(
    DwaRecorderInterface* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DwaRecorderInterface>(message->header()->name)) {
    case messages::DwaRecorderInterface::kAddEntry: {
      DCHECK(message->is_serialized());
      internal::DwaRecorderInterface_AddEntry_Params_Data* params =
          reinterpret_cast<internal::DwaRecorderInterface_AddEntry_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DwaRecorderInterface.0
      bool success = true;
      DwaEntryPtr p_entry{};
      DwaRecorderInterface_AddEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntry(&p_entry))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DwaRecorderInterface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddEntry(        
        std::move(p_entry));
      return true;
    }
  }
  return false;
}

// static
bool DwaRecorderInterfaceStubDispatch::AcceptWithResponder(
    DwaRecorderInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DwaRecorderInterface>(message->header()->name)) {
    case messages::DwaRecorderInterface::kAddEntry: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDwaRecorderInterfaceValidationInfo[] = {
    {base::to_underlying(messages::DwaRecorderInterface::kAddEntry),
     { &internal::DwaRecorderInterface_AddEntry_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DwaRecorderInterfaceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::metrics::dwa::mojom::DwaRecorderInterface::Name_,
    kDwaRecorderInterfaceValidationInfo);
}

// The declaration includes the definition on other builds.

DwaRecorderFactory::IPCStableHashFunction DwaRecorderFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DwaRecorderFactory>(message.name())) {
    case messages::DwaRecorderFactory::kCreateDwaRecorder: {
      return &DwaRecorderFactory::CreateDwaRecorder_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DwaRecorderFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DwaRecorderFactory>(message.name())) {
      case messages::DwaRecorderFactory::kCreateDwaRecorder:
            return "Receive metrics::dwa::mojom::DwaRecorderFactory::CreateDwaRecorder";
    }
  } else {
    switch (static_cast<messages::DwaRecorderFactory>(message.name())) {
      case messages::DwaRecorderFactory::kCreateDwaRecorder:
            return "Receive reply metrics::dwa::mojom::DwaRecorderFactory::CreateDwaRecorder";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DwaRecorderFactory::CreateDwaRecorder_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00a1bc9f;  // IPCStableHash for metrics::dwa::mojom::DwaRecorderFactory::CreateDwaRecorder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DwaRecorderFactoryProxy::DwaRecorderFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DwaRecorderFactoryProxy::CreateDwaRecorder(
    ::mojo::PendingReceiver<DwaRecorderInterface> in_receiver, ::mojo::PendingRemote<DwaRecorderClientInterface> in_client_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics::dwa::mojom::DwaRecorderFactory::CreateDwaRecorder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<DwaRecorderInterface>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_remote"), in_client_remote,
                        "<value of type ::mojo::PendingRemote<DwaRecorderClientInterface>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DwaRecorderFactory::kCreateDwaRecorder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics::dwa::mojom::internal::DwaRecorderFactory_CreateDwaRecorder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::metrics::dwa::mojom::DwaRecorderInterfaceInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DwaRecorderFactory.CreateDwaRecorder request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::metrics::dwa::mojom::DwaRecorderClientInterfaceInterfaceBase>>(
    in_client_remote,
    &params->client_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client_remote in DwaRecorderFactory.CreateDwaRecorder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DwaRecorderFactory::Name_);
  message.set_method_name("CreateDwaRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DwaRecorderFactoryStubDispatch::Accept(
    DwaRecorderFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DwaRecorderFactory>(message->header()->name)) {
    case messages::DwaRecorderFactory::kCreateDwaRecorder: {
      DCHECK(message->is_serialized());
      internal::DwaRecorderFactory_CreateDwaRecorder_Params_Data* params =
          reinterpret_cast<internal::DwaRecorderFactory_CreateDwaRecorder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DwaRecorderFactory.0
      bool success = true;
      ::mojo::PendingReceiver<DwaRecorderInterface> p_receiver{};
      ::mojo::PendingRemote<DwaRecorderClientInterface> p_client_remote{};
      DwaRecorderFactory_CreateDwaRecorder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client_remote =
            input_data_view.TakeClientRemote<decltype(p_client_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DwaRecorderFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDwaRecorder(        
        std::move(p_receiver), 
        std::move(p_client_remote));
      return true;
    }
  }
  return false;
}

// static
bool DwaRecorderFactoryStubDispatch::AcceptWithResponder(
    DwaRecorderFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DwaRecorderFactory>(message->header()->name)) {
    case messages::DwaRecorderFactory::kCreateDwaRecorder: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDwaRecorderFactoryValidationInfo[] = {
    {base::to_underlying(messages::DwaRecorderFactory::kCreateDwaRecorder),
     { &internal::DwaRecorderFactory_CreateDwaRecorder_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DwaRecorderFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::metrics::dwa::mojom::DwaRecorderFactory::Name_,
    kDwaRecorderFactoryValidationInfo);
}



}  // metrics::dwa::mojom


namespace mojo {


// static
bool StructTraits<::metrics::dwa::mojom::DwaEntry::DataView, ::metrics::dwa::mojom::DwaEntryPtr>::Read(
    ::metrics::dwa::mojom::DwaEntry::DataView input,
    ::metrics::dwa::mojom::DwaEntryPtr* output) {
  bool success = true;
  ::metrics::dwa::mojom::DwaEntryPtr result(::metrics::dwa::mojom::DwaEntry::New());
  
      if (success)
        result->event_hash = input.event_hash();
      if (success)
        result->content_hash = input.content_hash();
      if (success && !input.ReadStudiesOfInterest(&result->studies_of_interest))
        success = false;
      if (success && !input.ReadMetrics(&result->metrics))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace metrics::dwa::mojom {


DwaRecorderClientInterfaceAsyncWaiter::DwaRecorderClientInterfaceAsyncWaiter(
    DwaRecorderClientInterface* proxy) : proxy_(proxy) {}

DwaRecorderClientInterfaceAsyncWaiter::~DwaRecorderClientInterfaceAsyncWaiter() = default;





void DwaRecorderInterfaceInterceptorForTesting::AddEntry(DwaEntryPtr entry) {
  GetForwardingInterface()->AddEntry(
    std::move(entry)
    );
}
DwaRecorderInterfaceAsyncWaiter::DwaRecorderInterfaceAsyncWaiter(
    DwaRecorderInterface* proxy) : proxy_(proxy) {}

DwaRecorderInterfaceAsyncWaiter::~DwaRecorderInterfaceAsyncWaiter() = default;





void DwaRecorderFactoryInterceptorForTesting::CreateDwaRecorder(::mojo::PendingReceiver<DwaRecorderInterface> receiver, ::mojo::PendingRemote<DwaRecorderClientInterface> client_remote) {
  GetForwardingInterface()->CreateDwaRecorder(
    std::move(receiver)
    , 
    std::move(client_remote)
    );
}
DwaRecorderFactoryAsyncWaiter::DwaRecorderFactoryAsyncWaiter(
    DwaRecorderFactory* proxy) : proxy_(proxy) {}

DwaRecorderFactoryAsyncWaiter::~DwaRecorderFactoryAsyncWaiter() = default;







}  // metrics::dwa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif