// components/paint_preview/common/mojom/paint_preview_recorder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-features.h"  // IWYU pragma: export
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.h"  // IWYU pragma: export
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-forward.h"  // IWYU pragma: export
#include "components/paint_preview/common/mojom/paint_preview_types.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace paint_preview::mojom {

class PaintPreviewRecorderProxy;

template <typename ImplRefTraits>
class PaintPreviewRecorderStub;

class PaintPreviewRecorderRequestValidator;
class PaintPreviewRecorderResponseValidator;


class PaintPreviewRecorder
    : public PaintPreviewRecorderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "paint_preview.mojom.PaintPreviewRecorder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PaintPreviewRecorderInterfaceBase;
  using Proxy_ = PaintPreviewRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaintPreviewRecorderStub<ImplRefTraits>;

  using RequestValidator_ = PaintPreviewRecorderRequestValidator;
  using ResponseValidator_ = PaintPreviewRecorderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCapturePaintPreviewMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CapturePaintPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PaintPreviewRecorder() = default;

  using CapturePaintPreviewCallback = base::OnceCallback<void(PaintPreviewStatus, PaintPreviewCaptureResponsePtr)>;
  using CapturePaintPreviewMojoCallback = base::OnceCallback<void(PaintPreviewStatus, PaintPreviewCaptureResponsePtr)>;

  virtual void CapturePaintPreview(PaintPreviewCaptureParamsPtr params, CapturePaintPreviewCallback callback) = 0;
};



class  PaintPreviewRecorderProxy
    : public PaintPreviewRecorder {
 public:
  using InterfaceType = PaintPreviewRecorder;

  explicit PaintPreviewRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CapturePaintPreview(PaintPreviewCaptureParamsPtr params, CapturePaintPreviewCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PaintPreviewRecorderStubDispatch {
 public:
  static bool Accept(PaintPreviewRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaintPreviewRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaintPreviewRecorder>>
class PaintPreviewRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaintPreviewRecorderStub() = default;
  ~PaintPreviewRecorderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaintPreviewRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaintPreviewRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PaintPreviewRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PaintPreviewRecorderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  PaintPreviewCaptureParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintPreviewCaptureParams, T>::value>;
  using DataView = PaintPreviewCaptureParamsDataView;
  using Data_ = internal::PaintPreviewCaptureParams_Data;

  template <typename... Args>
  static PaintPreviewCaptureParamsPtr New(Args&&... args) {
    return PaintPreviewCaptureParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintPreviewCaptureParamsPtr From(const U& u) {
    return mojo::TypeConverter<PaintPreviewCaptureParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintPreviewCaptureParams>::Convert(*this);
  }


  PaintPreviewCaptureParams();

  PaintPreviewCaptureParams(
      ::paint_preview::RecordingPersistence persistence,
      const ::base::UnguessableToken& guid,
      const ::gfx::Rect& clip_rect,
      bool clip_rect_is_hint,
      bool is_main_frame,
      bool capture_links,
      ::base::File file,
      uint64_t max_capture_size,
      uint64_t max_decoded_image_size_bytes,
      bool skip_accelerated_content);

PaintPreviewCaptureParams(const PaintPreviewCaptureParams&) = delete;
PaintPreviewCaptureParams& operator=(const PaintPreviewCaptureParams&) = delete;

  ~PaintPreviewCaptureParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintPreviewCaptureParamsPtr>
  PaintPreviewCaptureParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintPreviewCaptureParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintPreviewCaptureParams_UnserializedMessageContext<
            UserType, PaintPreviewCaptureParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintPreviewCaptureParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintPreviewCaptureParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintPreviewCaptureParams_UnserializedMessageContext<
            UserType, PaintPreviewCaptureParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintPreviewCaptureParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::paint_preview::RecordingPersistence persistence;
  
  ::base::UnguessableToken guid;
  
  ::gfx::Rect clip_rect;
  
  bool clip_rect_is_hint;
  
  bool is_main_frame;
  
  bool capture_links;
  
  ::base::File file;
  
  uint64_t max_capture_size;
  
  uint64_t max_decoded_image_size_bytes;
  
  bool skip_accelerated_content;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LinkData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LinkData, T>::value>;
  using DataView = LinkDataDataView;
  using Data_ = internal::LinkData_Data;

  template <typename... Args>
  static LinkDataPtr New(Args&&... args) {
    return LinkDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LinkDataPtr From(const U& u) {
    return mojo::TypeConverter<LinkDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LinkData>::Convert(*this);
  }


  LinkData();

  LinkData(
      const ::GURL& url,
      const ::gfx::Rect& rect);


  ~LinkData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LinkDataPtr>
  LinkDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LinkData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LinkData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LinkData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LinkData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LinkData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LinkData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LinkData_UnserializedMessageContext<
            UserType, LinkData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LinkData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LinkData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LinkData_UnserializedMessageContext<
            UserType, LinkData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LinkData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::gfx::Rect rect;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LinkData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LinkData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LinkData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LinkData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PaintPreviewCaptureResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintPreviewCaptureResponse, T>::value>;
  using DataView = PaintPreviewCaptureResponseDataView;
  using Data_ = internal::PaintPreviewCaptureResponse_Data;

  template <typename... Args>
  static PaintPreviewCaptureResponsePtr New(Args&&... args) {
    return PaintPreviewCaptureResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintPreviewCaptureResponsePtr From(const U& u) {
    return mojo::TypeConverter<PaintPreviewCaptureResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintPreviewCaptureResponse>::Convert(*this);
  }


  PaintPreviewCaptureResponse();

  PaintPreviewCaptureResponse(
      const std::optional<::base::UnguessableToken>& embedding_token,
      const base::flat_map<uint32_t, ::base::UnguessableToken>& content_id_to_embedding_token,
      std::vector<LinkDataPtr> links,
      ::base::TimeDelta blink_recording_time,
      uint64_t serialized_size,
      const ::gfx::Point& scroll_offsets,
      const ::gfx::Point& frame_offsets,
      std::optional<::mojo_base::BigBuffer> skp);

PaintPreviewCaptureResponse(const PaintPreviewCaptureResponse&) = delete;
PaintPreviewCaptureResponse& operator=(const PaintPreviewCaptureResponse&) = delete;

  ~PaintPreviewCaptureResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintPreviewCaptureResponsePtr>
  PaintPreviewCaptureResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintPreviewCaptureResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintPreviewCaptureResponse_UnserializedMessageContext<
            UserType, PaintPreviewCaptureResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintPreviewCaptureResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintPreviewCaptureResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintPreviewCaptureResponse_UnserializedMessageContext<
            UserType, PaintPreviewCaptureResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintPreviewCaptureResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::UnguessableToken> embedding_token;
  
  base::flat_map<uint32_t, ::base::UnguessableToken> content_id_to_embedding_token;
  
  std::vector<LinkDataPtr> links;
  
  ::base::TimeDelta blink_recording_time;
  
  uint64_t serialized_size;
  
  ::gfx::Point scroll_offsets;
  
  ::gfx::Point frame_offsets;
  
  std::optional<::mojo_base::BigBuffer> skp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PaintPreviewCaptureParamsPtr PaintPreviewCaptureParams::Clone() const {
  return New(
      mojo::Clone(persistence),
      mojo::Clone(guid),
      mojo::Clone(clip_rect),
      mojo::Clone(clip_rect_is_hint),
      mojo::Clone(is_main_frame),
      mojo::Clone(capture_links),
      mojo::Clone(file),
      mojo::Clone(max_capture_size),
      mojo::Clone(max_decoded_image_size_bytes),
      mojo::Clone(skip_accelerated_content)
  );
}

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>*>
bool PaintPreviewCaptureParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->persistence, other_struct.persistence))
    return false;
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  if (!mojo::Equals(this->clip_rect, other_struct.clip_rect))
    return false;
  if (!mojo::Equals(this->clip_rect_is_hint, other_struct.clip_rect_is_hint))
    return false;
  if (!mojo::Equals(this->is_main_frame, other_struct.is_main_frame))
    return false;
  if (!mojo::Equals(this->capture_links, other_struct.capture_links))
    return false;
  if (!mojo::Equals(this->file, other_struct.file))
    return false;
  if (!mojo::Equals(this->max_capture_size, other_struct.max_capture_size))
    return false;
  if (!mojo::Equals(this->max_decoded_image_size_bytes, other_struct.max_decoded_image_size_bytes))
    return false;
  if (!mojo::Equals(this->skip_accelerated_content, other_struct.skip_accelerated_content))
    return false;
  return true;
}

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.persistence < rhs.persistence)
    return true;
  if (rhs.persistence < lhs.persistence)
    return false;
  if (lhs.guid < rhs.guid)
    return true;
  if (rhs.guid < lhs.guid)
    return false;
  if (lhs.clip_rect < rhs.clip_rect)
    return true;
  if (rhs.clip_rect < lhs.clip_rect)
    return false;
  if (lhs.clip_rect_is_hint < rhs.clip_rect_is_hint)
    return true;
  if (rhs.clip_rect_is_hint < lhs.clip_rect_is_hint)
    return false;
  if (lhs.is_main_frame < rhs.is_main_frame)
    return true;
  if (rhs.is_main_frame < lhs.is_main_frame)
    return false;
  if (lhs.capture_links < rhs.capture_links)
    return true;
  if (rhs.capture_links < lhs.capture_links)
    return false;
  if (lhs.file < rhs.file)
    return true;
  if (rhs.file < lhs.file)
    return false;
  if (lhs.max_capture_size < rhs.max_capture_size)
    return true;
  if (rhs.max_capture_size < lhs.max_capture_size)
    return false;
  if (lhs.max_decoded_image_size_bytes < rhs.max_decoded_image_size_bytes)
    return true;
  if (rhs.max_decoded_image_size_bytes < lhs.max_decoded_image_size_bytes)
    return false;
  if (lhs.skip_accelerated_content < rhs.skip_accelerated_content)
    return true;
  if (rhs.skip_accelerated_content < lhs.skip_accelerated_content)
    return false;
  return false;
}
template <typename StructPtrType>
LinkDataPtr LinkData::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(rect)
  );
}

template <typename T, LinkData::EnableIfSame<T>*>
bool LinkData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  return true;
}

template <typename T, LinkData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  return false;
}
template <typename StructPtrType>
PaintPreviewCaptureResponsePtr PaintPreviewCaptureResponse::Clone() const {
  return New(
      mojo::Clone(embedding_token),
      mojo::Clone(content_id_to_embedding_token),
      mojo::Clone(links),
      mojo::Clone(blink_recording_time),
      mojo::Clone(serialized_size),
      mojo::Clone(scroll_offsets),
      mojo::Clone(frame_offsets),
      mojo::Clone(skp)
  );
}

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>*>
bool PaintPreviewCaptureResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->embedding_token, other_struct.embedding_token))
    return false;
  if (!mojo::Equals(this->content_id_to_embedding_token, other_struct.content_id_to_embedding_token))
    return false;
  if (!mojo::Equals(this->links, other_struct.links))
    return false;
  if (!mojo::Equals(this->blink_recording_time, other_struct.blink_recording_time))
    return false;
  if (!mojo::Equals(this->serialized_size, other_struct.serialized_size))
    return false;
  if (!mojo::Equals(this->scroll_offsets, other_struct.scroll_offsets))
    return false;
  if (!mojo::Equals(this->frame_offsets, other_struct.frame_offsets))
    return false;
  if (!mojo::Equals(this->skp, other_struct.skp))
    return false;
  return true;
}

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.embedding_token < rhs.embedding_token)
    return true;
  if (rhs.embedding_token < lhs.embedding_token)
    return false;
  if (lhs.content_id_to_embedding_token < rhs.content_id_to_embedding_token)
    return true;
  if (rhs.content_id_to_embedding_token < lhs.content_id_to_embedding_token)
    return false;
  if (lhs.links < rhs.links)
    return true;
  if (rhs.links < lhs.links)
    return false;
  if (lhs.blink_recording_time < rhs.blink_recording_time)
    return true;
  if (rhs.blink_recording_time < lhs.blink_recording_time)
    return false;
  if (lhs.serialized_size < rhs.serialized_size)
    return true;
  if (rhs.serialized_size < lhs.serialized_size)
    return false;
  if (lhs.scroll_offsets < rhs.scroll_offsets)
    return true;
  if (rhs.scroll_offsets < lhs.scroll_offsets)
    return false;
  if (lhs.frame_offsets < rhs.frame_offsets)
    return true;
  if (rhs.frame_offsets < lhs.frame_offsets)
    return false;
  if (lhs.skp < rhs.skp)
    return true;
  if (rhs.skp < lhs.skp)
    return false;
  return false;
}


}  // paint_preview::mojom

namespace mojo {


template <>
struct  StructTraits<::paint_preview::mojom::PaintPreviewCaptureParams::DataView,
                                         ::paint_preview::mojom::PaintPreviewCaptureParamsPtr> {
  static bool IsNull(const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::PaintPreviewCaptureParamsPtr* output) { output->reset(); }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::persistence) persistence(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->persistence;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureParams::guid)& guid(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->guid;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureParams::clip_rect)& clip_rect(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->clip_rect;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::clip_rect_is_hint) clip_rect_is_hint(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->clip_rect_is_hint;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::is_main_frame) is_main_frame(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->is_main_frame;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::capture_links) capture_links(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->capture_links;
  }

  static  decltype(::paint_preview::mojom::PaintPreviewCaptureParams::file)& file(
       ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->file;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::max_capture_size) max_capture_size(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->max_capture_size;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::max_decoded_image_size_bytes) max_decoded_image_size_bytes(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->max_decoded_image_size_bytes;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::skip_accelerated_content) skip_accelerated_content(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->skip_accelerated_content;
  }

  static bool Read(::paint_preview::mojom::PaintPreviewCaptureParams::DataView input, ::paint_preview::mojom::PaintPreviewCaptureParamsPtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::LinkData::DataView,
                                         ::paint_preview::mojom::LinkDataPtr> {
  static bool IsNull(const ::paint_preview::mojom::LinkDataPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::LinkDataPtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::LinkData::url)& url(
      const ::paint_preview::mojom::LinkDataPtr& input) {
    return input->url;
  }

  static const decltype(::paint_preview::mojom::LinkData::rect)& rect(
      const ::paint_preview::mojom::LinkDataPtr& input) {
    return input->rect;
  }

  static bool Read(::paint_preview::mojom::LinkData::DataView input, ::paint_preview::mojom::LinkDataPtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::PaintPreviewCaptureResponse::DataView,
                                         ::paint_preview::mojom::PaintPreviewCaptureResponsePtr> {
  static bool IsNull(const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::PaintPreviewCaptureResponsePtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::embedding_token)& embedding_token(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->embedding_token;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::content_id_to_embedding_token)& content_id_to_embedding_token(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->content_id_to_embedding_token;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::links)& links(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->links;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::blink_recording_time)& blink_recording_time(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->blink_recording_time;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::serialized_size) serialized_size(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->serialized_size;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::scroll_offsets)& scroll_offsets(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->scroll_offsets;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::frame_offsets)& frame_offsets(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->frame_offsets;
  }

  static  decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::skp)& skp(
       ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->skp;
  }

  static bool Read(::paint_preview::mojom::PaintPreviewCaptureResponse::DataView input, ::paint_preview::mojom::PaintPreviewCaptureResponsePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_H_