// components/printing/common/print.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/printing/common/print.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/printing/common/print.mojom-data-view.h"




namespace std {

template <>
struct hash<::printing::mojom::PrintFailureReason>
    : public mojo::internal::EnumHashImpl<::printing::mojom::PrintFailureReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintFailureReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::PrintFailureReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::PrintFailureReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PreviewIdsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PreviewIdsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PreviewIds_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->request_id = Traits::request_id(input);

    fragment->ui_id = Traits::ui_id(input);
  }

  static bool Deserialize(::printing::mojom::internal::PreviewIds_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PreviewIdsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::RequestPrintPreviewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::RequestPrintPreviewParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::RequestPrintPreviewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_modifiable = Traits::is_modifiable(input);

    fragment->webnode_only = Traits::webnode_only(input);

    fragment->has_selection = Traits::has_selection(input);

    fragment->selection_only = Traits::selection_only(input);
  }

  static bool Deserialize(::printing::mojom::internal::RequestPrintPreviewParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::RequestPrintPreviewParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintFrameContentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintFrameContentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintFrameContentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printable_area)::BaseType> printable_area_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_printable_area,
      printable_area_fragment);

    fragment->printable_area.Set(
        printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printable_area.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printable_area in PrintFrameContentParams struct");

    fragment->document_cookie = Traits::document_cookie(input);
  }

  static bool Deserialize(::printing::mojom::internal::PrintFrameContentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintFrameContentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::OptionsFromDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::OptionsFromDocumentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::OptionsFromDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_scaling_disabled = Traits::is_scaling_disabled(input);

    fragment->copies = Traits::copies(input);

    
    mojo::internal::Serialize<::printing::mojom::DuplexMode>(
      Traits::duplex(input),
      &fragment->duplex);
  }

  static bool Deserialize(::printing::mojom::internal::OptionsFromDocumentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::OptionsFromDocumentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPrintContentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPrintContentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPrintContentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::metafile_data_region(input)) in_metafile_data_region = Traits::metafile_data_region(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metafile_data_region)::BaseType> metafile_data_region_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_metafile_data_region,
      metafile_data_region_fragment);

    fragment->metafile_data_region.Set(
        metafile_data_region_fragment.is_null() ? nullptr : metafile_data_region_fragment.data());

    decltype(Traits::subframe_content_info(input)) in_subframe_content_info = Traits::subframe_content_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subframe_content_info)::BaseType>
        subframe_content_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
      in_subframe_content_info,
      subframe_content_info_fragment,
      &subframe_content_info_validate_params);

    fragment->subframe_content_info.Set(
        subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subframe_content_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subframe_content_info in DidPrintContentParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::DidPrintContentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPrintContentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidStartPreviewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidStartPreviewParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidStartPreviewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->page_count = Traits::page_count(input);

    decltype(Traits::pages_to_render(input)) in_pages_to_render = Traits::pages_to_render(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pages_to_render)::BaseType>
        pages_to_render_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pages_to_render_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_pages_to_render,
      pages_to_render_fragment,
      &pages_to_render_validate_params);

    fragment->pages_to_render.Set(
        pages_to_render_fragment.is_null() ? nullptr : pages_to_render_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pages_to_render.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pages_to_render in DidStartPreviewParams struct");

    fragment->pages_per_sheet = Traits::pages_per_sheet(input);

    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_size)::BaseType> page_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
      in_page_size,
      page_size_fragment);

    fragment->page_size.Set(
        page_size_fragment.is_null() ? nullptr : page_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_size in DidStartPreviewParams struct");

    fragment->fit_to_page_scaling = Traits::fit_to_page_scaling(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidStartPreviewParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidStartPreviewParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPreviewPageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPreviewPageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPreviewPageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content)::BaseType> content_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
      in_content,
      content_fragment);

    fragment->content.Set(
        content_fragment.is_null() ? nullptr : content_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content in DidPreviewPageParams struct");

    fragment->page_index = Traits::page_index(input);

    fragment->document_cookie = Traits::document_cookie(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidPreviewPageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPreviewPageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPreviewDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPreviewDocumentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPreviewDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content)::BaseType> content_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
      in_content,
      content_fragment);

    fragment->content.Set(
        content_fragment.is_null() ? nullptr : content_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content in DidPreviewDocumentParams struct");

    fragment->document_cookie = Traits::document_cookie(input);

    fragment->expected_pages_count = Traits::expected_pages_count(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidPreviewDocumentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPreviewDocumentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_size)::BaseType> page_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
      in_page_size,
      page_size_fragment);

    fragment->page_size.Set(
        page_size_fragment.is_null() ? nullptr : page_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_size in PrintParams struct");

    decltype(Traits::content_size(input)) in_content_size = Traits::content_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_size)::BaseType> content_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
      in_content_size,
      content_size_fragment);

    fragment->content_size.Set(
        content_size_fragment.is_null() ? nullptr : content_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_size in PrintParams struct");

    decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printable_area)::BaseType> printable_area_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_printable_area,
      printable_area_fragment);

    fragment->printable_area.Set(
        printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printable_area.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printable_area in PrintParams struct");

    fragment->margin_top = Traits::margin_top(input);

    fragment->margin_left = Traits::margin_left(input);

    
    mojo::internal::Serialize<::printing::mojom::PageOrientation>(
      Traits::page_orientation(input),
      &fragment->page_orientation);

    decltype(Traits::dpi(input)) in_dpi = Traits::dpi(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dpi)::BaseType> dpi_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_dpi,
      dpi_fragment);

    fragment->dpi.Set(
        dpi_fragment.is_null() ? nullptr : dpi_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dpi.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dpi in PrintParams struct");

    fragment->scale_factor = Traits::scale_factor(input);

    fragment->document_cookie = Traits::document_cookie(input);

    fragment->selection_only = Traits::selection_only(input);

    fragment->preview_ui_id = Traits::preview_ui_id(input);

    fragment->preview_request_id = Traits::preview_request_id(input);

    fragment->is_first_request = Traits::is_first_request(input);

    
    mojo::internal::Serialize<::printing::mojom::PrintScalingOption>(
      Traits::print_scaling_option(input),
      &fragment->print_scaling_option);

    fragment->print_to_pdf = Traits::print_to_pdf(input);

    fragment->display_header_footer = Traits::display_header_footer(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in PrintParams struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PrintParams struct");

    decltype(Traits::header_template(input)) in_header_template = Traits::header_template(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->header_template)::BaseType> header_template_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_header_template,
      header_template_fragment);

    fragment->header_template.Set(
        header_template_fragment.is_null() ? nullptr : header_template_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->header_template.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header_template in PrintParams struct");

    decltype(Traits::footer_template(input)) in_footer_template = Traits::footer_template(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->footer_template)::BaseType> footer_template_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_footer_template,
      footer_template_fragment);

    fragment->footer_template.Set(
        footer_template_fragment.is_null() ? nullptr : footer_template_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->footer_template.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null footer_template in PrintParams struct");

    fragment->rasterize_pdf = Traits::rasterize_pdf(input);

    fragment->rasterize_pdf_dpi = Traits::rasterize_pdf_dpi(input);

    fragment->should_print_backgrounds = Traits::should_print_backgrounds(input);

    
    mojo::internal::Serialize<::printing::mojom::SkiaDocumentType>(
      Traits::printed_doc_type(input),
      &fragment->printed_doc_type);

    fragment->prefer_css_page_size = Traits::prefer_css_page_size(input);

    fragment->pages_per_sheet = Traits::pages_per_sheet(input);
    fragment->generate_tagged_pdf_$flag = Traits::generate_tagged_pdf(input).has_value();
    if (Traits::generate_tagged_pdf(input).has_value()) {
      fragment->generate_tagged_pdf_$value = Traits::generate_tagged_pdf(input).value();
    }

    
    mojo::internal::Serialize<::printing::mojom::GenerateDocumentOutline>(
      Traits::generate_document_outline(input),
      &fragment->generate_document_outline);
  }

  static bool Deserialize(::printing::mojom::internal::PrintParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintPagesParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintPagesParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintPagesParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType> params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::PrintParamsDataView>(
      in_params,
      params_fragment);

    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPagesParams struct");

    decltype(Traits::pages(input)) in_pages = Traits::pages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pages)::BaseType>
        pages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pages_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PageRangeDataView>>(
      in_pages,
      pages_fragment,
      &pages_validate_params);

    fragment->pages.Set(
        pages_fragment.is_null() ? nullptr : pages_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pages.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pages in PrintPagesParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::PrintPagesParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintPagesParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPrintDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPrintDocumentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPrintDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content)::BaseType> content_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
      in_content,
      content_fragment);

    fragment->content.Set(
        content_fragment.is_null() ? nullptr : content_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content in DidPrintDocumentParams struct");

    fragment->document_cookie = Traits::document_cookie(input);

    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_size)::BaseType> page_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_page_size,
      page_size_fragment);

    fragment->page_size.Set(
        page_size_fragment.is_null() ? nullptr : page_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_size in DidPrintDocumentParams struct");

    decltype(Traits::content_area(input)) in_content_area = Traits::content_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_area)::BaseType> content_area_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_content_area,
      content_area_fragment);

    fragment->content_area.Set(
        content_area_fragment.is_null() ? nullptr : content_area_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_area.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_area in DidPrintDocumentParams struct");

    decltype(Traits::physical_offsets(input)) in_physical_offsets = Traits::physical_offsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->physical_offsets)::BaseType> physical_offsets_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_physical_offsets,
      physical_offsets_fragment);

    fragment->physical_offsets.Set(
        physical_offsets_fragment.is_null() ? nullptr : physical_offsets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->physical_offsets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null physical_offsets in DidPrintDocumentParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::DidPrintDocumentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPrintDocumentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::ScriptedPrintParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::ScriptedPrintParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::ScriptedPrintParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->cookie = Traits::cookie(input);

    fragment->expected_pages_count = Traits::expected_pages_count(input);

    fragment->has_selection = Traits::has_selection(input);

    fragment->is_scripted = Traits::is_scripted(input);

    
    mojo::internal::Serialize<::printing::mojom::MarginType>(
      Traits::margin_type(input),
      &fragment->margin_type);
  }

  static bool Deserialize(::printing::mojom::internal::ScriptedPrintParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::ScriptedPrintParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintWithParamsResultDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintWithParamsResultDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintWithParamsResultData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType> params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::DidPrintDocumentParamsDataView>(
      in_params,
      params_fragment);

    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintWithParamsResultData struct");

    decltype(Traits::accessibility_tree(input)) in_accessibility_tree = Traits::accessibility_tree(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accessibility_tree)::BaseType> accessibility_tree_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
      in_accessibility_tree,
      accessibility_tree_fragment);

    fragment->accessibility_tree.Set(
        accessibility_tree_fragment.is_null() ? nullptr : accessibility_tree_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accessibility_tree.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accessibility_tree in PrintWithParamsResultData struct");

    
    mojo::internal::Serialize<::printing::mojom::GenerateDocumentOutline>(
      Traits::generate_document_outline(input),
      &fragment->generate_document_outline);
  }

  static bool Deserialize(::printing::mojom::internal::PrintWithParamsResultData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintWithParamsResultDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::printing::mojom::internal::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::printing::mojom::PrintWithParamsResultDataDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in PrintRenderFrame_PrintWithParams_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::printing::mojom::PrintFailureReason>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::printing::mojom::internal::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing::mojom {





inline void PrintFrameContentParamsDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}




inline void DidPrintContentParamsDataView::GetMetafileDataRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->metafile_data_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void DidPrintContentParamsDataView::GetSubframeContentInfoDataView(
    mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output) {
  auto pointer = data_->subframe_content_info.Get();
  *output = mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>(pointer, message_);
}


inline void DidStartPreviewParamsDataView::GetPagesToRenderDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->pages_to_render.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void DidStartPreviewParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}


inline void DidPreviewPageParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, message_);
}


inline void DidPreviewDocumentParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, message_);
}


inline void PrintParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}
inline void PrintParamsDataView::GetContentSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->content_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}
inline void PrintParamsDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void PrintParamsDataView::GetDpiDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->dpi.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PrintParamsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintParamsDataView::GetUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintParamsDataView::GetHeaderTemplateDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->header_template.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintParamsDataView::GetFooterTemplateDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->footer_template.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void PrintPagesParamsDataView::GetParamsDataView(
    PrintParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = PrintParamsDataView(pointer, message_);
}
inline void PrintPagesParamsDataView::GetPagesDataView(
    mojo::ArrayDataView<::printing::mojom::PageRangeDataView>* output) {
  auto pointer = data_->pages.Get();
  *output = mojo::ArrayDataView<::printing::mojom::PageRangeDataView>(pointer, message_);
}


inline void DidPrintDocumentParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, message_);
}
inline void DidPrintDocumentParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void DidPrintDocumentParamsDataView::GetContentAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->content_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void DidPrintDocumentParamsDataView::GetPhysicalOffsetsDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->physical_offsets.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}




inline void PrintWithParamsResultDataDataView::GetParamsDataView(
    DidPrintDocumentParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = DidPrintDocumentParamsDataView(pointer, message_);
}
inline void PrintWithParamsResultDataDataView::GetAccessibilityTreeDataView(
    ::ax::mojom::AXTreeUpdateDataView* output) {
  auto pointer = data_->accessibility_tree.Get();
  *output = ::ax::mojom::AXTreeUpdateDataView(pointer, message_);
}


inline void PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView::GetSuccessDataView(
    PrintWithParamsResultDataDataView* output) const {
  CHECK(is_success());
  *output = PrintWithParamsResultDataDataView(data_->data.f_success.Get(), message_);
}


}  // printing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::PrintFailureReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::PrintFailureReason value);
};

} // namespace perfetto

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_